--
-- PostgreSQL database dump
--

-- Dumped from database version 12.17
-- Dumped by pg_dump version 16.1 (Debian 16.1-1.pgdg110+1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: mdc_qualified_opportunity_zones; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdc_qualified_opportunity_zones (
    ogc_fid integer NOT NULL,
    objectid integer,
    statefp10 character varying,
    countyfp10 character varying,
    tractce10 character varying,
    geoid10 character varying,
    name10 character varying,
    namelsad10 character varying,
    mtfcc10 character varying,
    funcstat10 character varying,
    aland10 integer,
    awater10 integer,
    intptlat10 double precision,
    intptlon10 double precision,
    pop100 character varying,
    hu100 character varying,
    p0020002 integer,
    p0020005 integer,
    p0020006 integer,
    p0020007 integer,
    p0020008 integer,
    p0020009 integer,
    p0020010 integer,
    p0020011 integer,
    shape_area double precision,
    shape_length double precision,
    geom public.geometry(MultiPolygon,4326),
    geom_local public.geometry(MultiPolygon,2236)
);


ALTER TABLE public.mdc_qualified_opportunity_zones OWNER TO postgres;

--
-- Name: mdc_qualified_opportunity_zones_ogc_fid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdc_qualified_opportunity_zones_ogc_fid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mdc_qualified_opportunity_zones_ogc_fid_seq OWNER TO postgres;

--
-- Name: mdc_qualified_opportunity_zones_ogc_fid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdc_qualified_opportunity_zones_ogc_fid_seq OWNED BY public.mdc_qualified_opportunity_zones.ogc_fid;


--
-- Name: mdc_qualified_opportunity_zones ogc_fid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdc_qualified_opportunity_zones ALTER COLUMN ogc_fid SET DEFAULT nextval('public.mdc_qualified_opportunity_zones_ogc_fid_seq'::regclass);


--
-- Data for Name: mdc_qualified_opportunity_zones; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdc_qualified_opportunity_zones (ogc_fid, objectid, statefp10, countyfp10, tractce10, geoid10, name10, namelsad10, mtfcc10, funcstat10, aland10, awater10, intptlat10, intptlon10, pop100, hu100, p0020002, p0020005, p0020006, p0020007, p0020008, p0020009, p0020010, p0020011, shape_area, shape_length, geom, geom_local) FROM stdin;
13	13	12	086	009308	12086009308	93.08	Census Tract 93.08	G5020	S	1187318	67610	25.8879442	-80.2986961	     7318	     2341	6988	286	15	0	23	0	3	3	1556970.4765625	5644.18947544138	0106000020E61000000100000001030000000100000032000000BB8E600FAC1254C0C9DDFA7740E43940B398C752AA1254C0C9DDFA7740E43940C731F3D4A91254C022DD6F3619E43940AC659135A91254C0FA98D641E8E3394022D618D5A81254C0498E8A67CCE3394043784357A81254C0583E25FBAAE33940799BC40BA81254C0BDB0732C79E3394006475496A71254C0E7BD0DCE31E33940D4CF168EA61254C03D5994B510E3394061EB7996A61254C0021D14E7F9E2394071DD59A3A41254C079FD12B585E239406B3FBF14A41254C03FE0037B64E239400E7A8AB3A81254C089E928F962E2394051FE0896A91254C0BDA30AB662E239408FBCA307C41254C0B393B41A63E23940A87F5F6CE01254C0B50A5B7F63E239409A4B619DE91254C0948CEC3764E23940C6FA43CFEC1254C0B1C87CC263E23940988FF6C4F91254C0D40D9B0564E239406B52E7A00A1354C026AF7B5964E2394027600CA6201354C0B4ABB58362E239404538E76D2B1354C077F97E9462E2394009E79EA82B1354C00AEB9CB86DE23940351250025A1354C03504F3536DE2394015245717AF1354C07A552EAC6CE23940CE83C10AAF1354C0E2F3233670E2394015245717AF1354C00D41E76AB5E23940FA8F9AA1B01354C01266EE86BEE23940924DDA12B11354C0DE9BD091E6E23940082E3530B11354C08A5E31D215E3394052E07A23B21354C016C794C54EE33940C5C4171BB21354C0A58EA1F063E339404C7516B2B21354C01DB375D5C6E339406A009916B41354C0AE63C72C3EE439407F36E0D8721354C0D7F48C6B3FE43940B2C807D9711354C057ADD5E903E43940E872B20C301354C03E0E647403E4394087CE8C0C311354C0EC3473633DE439404A4ECE820F1354C0E9D001853DE439408BC45CD7EE1254C0CC59FEB23EE439402519B6E5E21254C08622E1063FE43940E5137C50D61254C08E2CAA173FE43940BA2DAA51CE1254C0F6BD6F283FE439400676CA5AC91254C048901B8D3FE439402E76B3F3BC1254C0349AE49D3FE43940F24AFBF0B21254C0B5E7C38840E43940067453F5B11254C0E578899940E439403E988A06AF1254C0B5E7C38840E4394096B0C55EAE1254C0B5E7C38840E43940BB8E600FAC1254C0C9DDFA7740E43940	0106000020BC080000010000000103000000010000003200000040CFAC725F212B41F1F497B7174D21415D6B8D25A5212B41C1FDEA17184D2141E7FF4439BB212B41F36E31C4644B2141E8A84924D7212B41684356E1454921412B12FFEEE7212B4134E3F6031148214164C98DA9FD212B41262978629E4621418E631A7B0C222B41703454FA75442141FCAC982A23222B41FDB8F4715E412141350615934E222B41B1E45A91EF3F2141298B29A04E222B41666D1396F23E2141EA2210D6A3222B41C8367D27EA3921412831FF2EBC222B41BBA409B879382141EBC389D602222B4179E5C3FF67382141B7632F58DF212B41CAE735E6643821412F1752FFB91D2B41902AE189633821414604F46546192B41CC021CC561382141C566CD74D5172B41C59037C967382141D8BAE24155172B4164C5680262382141C84ECE194D152B4191E5B420623821410A3D3270A8122B415285362362382141749DCEC4340F2B41B3BD8E0E493821410BE4D114840D2B41C941447947382141871756377A0D2B419275B800C3382141950794F735062B41A8E57ABBB43821417DF1023CDFF82A419052EA609B3821411F801100E1F82A412A5395A4C2382141FDC31BFADAF82A41036B3D46C23B21417E2B09A29CF82A412BDFDEFD263C21411DBDFB8888F82A419B33DB0DE33D2141C67EFB2A81F82A41A3C30C26EF3F2141F5105BB257F82A412A7ACDA6664221416E52DCC557F82A4102B24F7551432141CDD674503AF82A4136B896469A47214129E1F770FBF72A4124DE03BAC54C2141B89B8CA935022B41A95AF163E14C2141687EDC4561022B410BD01C8C4D4A2141984EF3F8B10C2B4131209882564A21412082FD6E860C2B41293EE0E7D84C2141B80C7F65C8112B41CB9C778DE14C214147919772E7162B41432202AAF54C2141AA3735C5C6182B418B896ADFFB4C214165A68CC0BF1A2B419D208650FF4C2141C799D99F001C2B41815F84C4014D2141C6A05FD5C71C2B413622BE33074D21419A942395B91E2B41AA10689C0A4D21417942D0474B202B41CF7842F4164D214192BB6ABA72202B41465EC8E4174D2141A6A7656EE8202B4160CA55CD174D214128176BBB02212B41DE14ACF1174D214140CFAC725F212B41F1F497B7174D2141
33	33	12	086	001402	12086001402	14.02	Census Tract 14.02	G5020	S	1181552	11686	25.8470343	-80.1915947	     4853	     2064	626	186	3882	10	17	0	23	109	1480784.77539063	5070.92738649497	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
37	37	12	086	009100	12086009100	91	Census Tract 91	G5020	S	10310932	219702	25.8105225	-80.3163876	     7620	     1962	6019	505	1069	1	18	0	1	7	13065634.4785156	26614.877648725	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
41	41	12	086	001606	12086001606	16.06	Census Tract 16.06	G5020	S	686952	0	25.8268982	-80.274986	     4323	     1577	4181	105	20	1	2	0	4	10	851423.26953125	4044.26919015513	0106000020E61000000100000001030000000100000023000000BBD80FD77E1154C0D7CD8B1E2BD33940D283EB3F7F1154C043652CA220D33940B7F426017E1154C038FCA96BE7D23940017436D77D1154C0441FDB1CA8D23940952974159F1154C0F594FB31A7D23940894EB3FBA21154C04C6AFD9AA6D239409B537BCDBF1154C0EA077A58A2D23940A33EE594CD1154C018D77BC1A1D23940D6155819DA1154C0A6E798A89FD23940C407D8B7E01154C06CB39A119FD23940695E43ABE01154C02AF78DEBD9D23940C4CA3A57E11154C08821F20C14D339402D65F913E21154C00553C56850D33940BB43BFBBE21154C0276725E68CD339406996E8D4E21154C03AB8A71CC6D339400FF2C2D4E31154C0F233E75602D43940711CAE13E41154C04E15F6A13ED43940C147C684E51154C06FB0243D78D43940DCDF4253C31154C08B3BA2DB7ED43940D9992471A31154C076F6966582D4394042056D69821154C07EEEE92186D4394078694BD7601154C008FD88A78AD43940E493B494401154C09AC0295B90D43940A162C5D33F1154C05218DBD858D439403F38DA943F1154C0BB93EC0D2AD43940C904F0553F1154C00E97F5CCFED339400F10EAD33E1154C0719FC7D7D1D33940D3DEFA123E1154C01C3FEE14A5D33940B19142413D1154C09C493B7474D33940CFA7821B3D1154C0411058A868D3394048EC548F481154C0A97AB3E765D33940539BD752541154C0D8C25F4C66D33940D30D71D75F1154C0B804D4CE63D33940BE1887CE7F1154C000A2FA2B5ED33940BBD80FD77E1154C0D7CD8B1E2BD33940	0106000020BC08000001000000010300000001000000230000000756058EA4512B41E24A6F17DC8F20410FCDE9BF94512B416F3AEAB0678F20411B08C541CA512B41E2C57F5BED8C2041B48B1AB7D4512B41DD8ABE2D2F8A20412FB280DC9D4C2B41B3310FA31D8A20416C5F2B50014C2B418D606B3B168A20417D2FB84C7C472B41AFBC9F9DE0892041483E2A0753452B41C908FF08D789204195460D825C432B4175A00304BD8920419A50ECBE52422B4153464404B5892041A875792451422B416FED79CF418C20410E54A4A232422B410B35F672C68E2041840F7E5C11422B419B3910CA639120412115805EF3412B415972F199029420417A680CF2EB412B41025875307D96204170057527C0412B41FCD76B0419992041E90D079FB2412B4180404FBDB59B2041D4605D3A75412B412F24E564349E2041FBF1C2CFD1462B411509A058859E20414C9543D2D14B2B4164FEA0A4B39E204158BB7EDEFF502B412CBB4C65E49E2041737AF09343562B41541EC7021E9F204170EA4995525B2B417AF6AD70649F2041F127E443745B2B41D0B0C2E5FC9C2041459F6D04815B2B419CFC76ECF59A2041B293008D8D5B2B4105D93D341699204197212BB7A45B2B4123DB77A4239720418A7373BCC55B2B41927B025133952041DD89D3A0E95B2B41EE34D01D18932041EB0DC246F05B2B4129F8654D95922041EB8AD992245A2B412A60B53774922041BCD26B2D4C582B41539287F575922041BE1B92D37D562B41C0C69FC5579220419850149C7A512B4113C4A427129220410756058EA4512B41E24A6F17DC8F2041
56	56	12	086	001005	12086001005	10.05	Census Tract 10.05	G5020	S	990429	30171	25.8598018	-80.2137025	     2069	      899	261	45	1719	12	11	1	2	18	1267321.71289063	4835.17645499213	0106000020E61000000100000001030000000100000022000000C1D393B7530D54C092E853B4A6DC394037CFD8CC510D54C0E22DA0C1DADB3940C70BC20B520D54C07F91D185C5DB3940045D0AD1510D54C0F335B69AA9DB39409C15DB35510D54C08583E15D62DB39405E6C9442500D54C025C498F4F2DA39405EFCC0C44F0D54C021115416B9DA394058CEF9B34F0D54C071274991B0DA394076394015670D54C0A4AC8905B9DA39408C904DD56D0D54C0054AD92ABCDA39403C3D7E650E0E54C06FB0C4CB07DB39408FB29DCD130E54C0614DC3DA13DB3940C76309BA260E54C079B84AB759DB3940A0AEBF644C0E54C0445C847550DC39408E6D09E6510E54C0FAC15A387DDC3940212CFFB34F0E54C0863F069D7DDC3940973759A0460E54C09B40AD2F7FDC3940CB37548E320E54C0523FA48B81DC394002C439241E0E54C05CF1320984DC394095E55C15110E54C0E486A0AC85DC394072C82474000E54C01E74CAEA8ADC39409747C92FEC0D54C0535D6E708FDC39408AABD2EFCE0D54C0AFDE54BE93DC394089BA06D5CE0D54C049FE9AA893DC394088637025CD0D54C0E69D814A92DC394094A1FEFBBC0D54C01F660D2495DC3940B15C0191AE0D54C0DC11E86A98DC39405565D599AB0D54C02B6A215A98DC394019E01ED98C0D54C09E9768DB9DDC3940F077DBCA7B0D54C0128BF2EFA0DC39401E784D8E6B0D54C0EB095F2AA3DC3940F85152B1610D54C02F0DD19FA3DC3940F65B421F5C0D54C01A7ECB64A5DC3940C1D393B7530D54C092E853B4A6DC3940	0106000020BC0800000100000001030000000100000022000000AC1AA12D65F82B417638DAB802FA2041AB7496C4BFF82B41620178F22CF120412BD58C52B7F82B41C25A085C41F0204186D4A265C2F82B41F858E8BC0BEF20418134EC7EDFF82B412B5D68B3F5EB2041FC216F180DF92B41EC04CD2122E7204154E365B224F92B4112A5175DA0E420417218CFE527F92B4193638BE041E420419810F9B97CF52B4137C1ABFF99E42041F30061866DF42B411C040043BBE42041740102A03ADB2B41598EF89EDBE720412E9FC0C660DA2B417D838B1660E82041606D797E64D72B41E0E9777F62EB204159C8782F6CD12B413A7941780AF62041860D84428CD02B416D7F9FA9F9F72041D9420D5EE4D02B4197A4A08BFEF72041CC1784A250D22B41ECE27F2512F82041D520D02B76D52B4123A2D21531F820414683C882A9D82B41B1C5AB9151F8204111DD9A98B5DA2B41BA7DC6DA66F8204124CFC2D250DD2B4168522AFAA4F82041CAA6CC1B7EE02B413AA5C0FADBF820410970E70114E52B41F73C08BA12F92041EAF10B3718E52B41EBF576CF11F92041EB3F8AFB5BE52B41BB368B0B03F920414AFB8995E4E72B41B1BE4D8826F9204186700B2627EA2B41B7D27E574EF920410087BF329EEA2B41C90DDC534EF9204137DCEF5870EF2B41D2CC5ECA92F92041F7FD21D01CF22B416B5AAA11B9F9204108D36773A8F42B41536B50B4D5F920419681535C34F62B414B752E2DDDF920411F9FBBDC13F72B41B0478526F2F92041AC1AA12D65F82B417638DAB802FA2041
60	60	12	086	005502	12086005502	55.02	Census Tract 55.02	G5020	S	1297577	0	25.7685036	-80.2471276	     7034	     2647	6604	350	18	1	55	0	1	5	1606673.87890625	5407.57722077137	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
1	1	12	086	001702	12086001702	17.02	Census Tract 17.02	G5020	S	1037753	0	25.8180801	-80.2446265	     2510	      994	598	16	1881	0	1	0	4	10	1286418.3359375	4670.80856229641	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
46	46	12	086	002004	12086002004	20.04	Census Tract 20.04	G5020	S	715951	0	25.8291721	-80.1919836	     2909	     1153	781	91	1963	10	10	0	4	50	884764.146484375	3754.03588308395	0106000020E610000001000000010300000001000000350000009AD42950820C54C08F8FA57246D339405F56176B8A0C54C01A073EE045D33940CB9AA24A8B0C54C03390CA5458D339408668FD2C8D0C54C06A48632F80D33940DBA62DC88D0C54C054B758DBB9D33940CA99ECED8D0C54C098A37AD3D2D33940504AEB848E0C54C0874D35BAEFD3394068F5C6ED8E0C54C0EE29961914D43940F9843F4E8F0C54C05D02DDA925D439401D75795F900C54C04E35041450D4394044A758BF900C54C02D4697C261D439405094474D910C54C088CCD1B672D439400FDCD538920C54C0A747A4DD8DD439402D87B1A1920C54C0D191E890B2D4394077E66773930C54C0A190588FD9D43940521A8530910C54C0408DA5DEFFD43940149D302F910C54C0ADA734F5FFD4394057C62D2A900C54C0EDC6043D12D539407A1962078F0C54C00D487F1527D5394083F70E058F0C54C0B8DF284027D53940C9677E82820C54C056F1A75D2AD53940203222F07E0C54C0D23BE04C2AD53940CB28E1916F0C54C0443834AD2BD53940B5A4D4725E0C54C0F441494C2ED539403C3F4559570C54C009CF667031D539401408C358570C54C027D8A17031D53940F20C5E8E4D0C54C00BB769EE34D53940983E1D8C4D0C54C05D9A36EF34D53940166E1C934D0C54C05FD1ED473FD5394000F1B0984D0C54C046CFFF8947D539405299EB964D0C54C06089228A47D53940016B666B3B0C54C0FB7BD4E748D53940B0B072542C0C54C0E113EEEF4AD539406A616CD9180C54C084777D3F4CD53940884FA58B0B0C54C0324695B04DD53940E2F8C2C2070C54C012385B584ED53940A8C39127070C54C05F29299122D539401442C2E4040C54C0B32EA2BF75D4394048B5463D020C54C03346C641AED3394082B741BB010C54C0B0B1AB4786D3394082B741BB010C54C03CF1474673D339400519F30A020C54C00AEF4AD955D3394059C28717020C54C085A136D153D33940F1274030050C54C0A999FEE153D33940FD29C9EA140C54C0C6F254E652D33940D8782D99210C54C0B9703A7551D33940F1E6E276260C54C07735E5AB50D33940D649F79B470C54C0A6565E004DD339403E43AC4D5A0C54C00515F82E4AD339400FB8053F680C54C005C76A7649D33940546AC2076D0C54C087472F8749D33940B2AFFCBE760C54C0EC9BA43748D339409AD42950820C54C08F8FA57246D33940	0106000020BC08000001000000010300000001000000350000006C19374EDE192C4108EC839D359220417DCC26E098182C417DF303482D922041BD013B8F74182C415DD1C5C6F992204175AC453226182C417E329A61B3942041BD1BA0F109182C419BFE4BF03297204165EA8A5402182C4116F8D9DD47982041721FBBAFE8172C412A83FC4C889920415275E2C5D5172C41B277F1A61B9B2041BDFB4C73C5172C41AD46E160DE9B2041FEC4EFB797172C41120CAB96B49D20414E55687B87172C41C7FDD3A0789E204135B8F81170172C41D632B38C349F204139A4474849172C41D9FBD67E61A02041937AF45836172C4125ED567BF8A12041BFA295CF12172C41922D23CFA8A32041257301036B172C414EC8CE4D52A5204119B2E1366B172C41CAFD5C4853A520412BCF0BEA92172C41EF18E24D1EA620410399921CBF172C41E4F897CE05A72041BF740677BF172C4199A462A807A72041B9E3E791B5192C417171DF482DA7204176E975FD441A2C4116726E6F2DA72041B9561BFAAD1C2C419A85FE7A40A7204101E989455D1F2C4103DCEFC561A72041BAA57B237A202C415CCE455D86A72041702EE4377A202C4196BDF45F86A7204173D57E1A03222C417A930784AFA72041226AE97403222C413487768DAFA72041C46177A701222C415A3ADD4F22A820417CFC563700222C41FB7B36E87DA820412AAD6F7E00222C416F8427EA7DA8204132C808FBD9242C4116974F8D91A82041346C96BC37272C41B4B32BD1ABA82041F9C692D9452A2C41DB5A842DBFA82041518471F05B2C2C411A398477D2A820417FF589DCF32C2C41C20DBCACDAA82041B6ABC4330F2D2C41D8CA803AF5A62041EAB92AD4752D2C413DF03ED9789F20418BFDAB13EE2D2C41B1C4CFB3D49620413E34E135052E2C4163CC2F6519952041DA5A4283062E2C41CB4D3E954694204196824D07FC2D2C41D51AF61B009320416062C031FA2D2C41DEA10290E9922041950F73D87D2D2C410D488B85E99220419032C851062B2C419DA81DB8DA922041BFE53D3209292C418B2A3896C7922041C731D4D945282C416184CAA8BD922041659B802613232C418A7713C38C9220412BA8AEAA24202C419C9224E5689220413566D7D5F41D2C41BDDA09775D9220417F43A4B8341D2C4166D3A0035D922041954B4EABAE1B2C419F78FA154C9220416C19374EDE192C4108EC839D35922041
2	2	12	086	002502	12086002502	25.02	Census Tract 25.02	G5020	S	1048128	4860	25.8085148	-80.2123821	     3421	     1179	2300	110	974	1	15	1	3	17	1313855.27148438	6673.88002237211	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	0106000020BC080000010000000103000000010000005600000081BCF38F1EF92B41ADE0B280296E20415FBE7118C9F92B41FD0274EC1E6E204184546A16C3FC2B41205371A7EF6D2041F2180AC5C6FC2B41A3FE713AEF6D20418478944161FD2B410AFAC663DD6D204119C0EF7D79FD2B41421A5897DA6D2041C0EE792E1AFE2B419FFC02E0C66D20418BFA505DB8FE2B41DE905AE2B56D2041757356B3C6FE2B412CFF666BD06C20415E979144DAFE2B414CB3A96F5B6B204185642EAFF5FE2B41D704DEBDA1682041A0A77BFDF9FE2B41FB6C4B8F56682041CD3A961626FF2B41A4721D8754652041BB0D1E5726FF2B416A355AC84F652041722D0B4933FF2B41ABE56D665C642041CDB6B05633FF2B419DF71B675B64204109DC293079FF2B41821AEBB09A5D20416FAD3AF381FF2B41C23F22DAC15C20419EEE070D87FF2B41FFAFF01A995C204178FD94FD85FF2B41B53B1EDC735C2041962296F685FF2B4109700DE7725C2041D4359CAACAFF2B413EE258BCA35420412CAECA75DFFF2B41F420472BD451204198F42A0ECDFE2B41274BA93DD351204182C88D0ED4FB2B41F2DC5B3995512041A69711239FF62B41715BE55062512041CE8E904E58F12B413065CC4F47512041B501032148F12B413D7C2B8A1A54204149EFA92A32F12B41C8CA6DB368562041EF59478018F12B416E516296B2572041B24D339A18F12B41D22DE6687D582041BC33BF15FFF02B4158107A1F8A5A20419ACB82A1EEF02B4166D89710D45B204124E880E414EF2B4168D38A23CC5B20413EEB34C3E5EC2B411CCCB142AA5B2041F48A1568CCEC2B411CB49A4D0B5E2041DE3E6F8EB3EC2B41C2520790F3602041A2D51EBD9BEC2B41131F05B3826320411B1BE6539BEC2B4199DE8F068C6320414EF6A33B8FEC2B41A4B44D799E642041A328B57080EC2B414A51B825EE652041EB7C640A8CEC2B41BDB816AB336620410DF5105B42EB2B41326EDA25256620411F3594A9E9E92B413BA4821813662041788E9BFAFBE62B4181AEB321EE65204142C87BADB6E62B41CF52A2DCE96520419088AD03A3E62B41E33CF9262867204142D6C9AA98E62B41F60B920E78672041C5129F6B7BE62B41DB7C34D017682041614FEC3A69E62B41A2105BF25E682041689C75E91CE62B414438B5095D6820416A38F4C0F6E52B41398F77155C682041A0C703E60EE62B411D254268E76520418F87476076E32B419D6616E9CE6520412D2DFE0AF6E02B416CF194CDB2652041DE40EE25E0E02B413BA873D7B1652041351C4B4522DE2B416F08711D95652041560CF7DA09DD2B41C7441D9E8C65204164FC7A218ADB2B4110FC26FD80652041C3D9BE1B88DB2B41A0C970ED806520411AED4A1F43D62B41B6DBFA02366520413CE9815B90D32B411ACC011F1C652041E2EC643114D12B414BD33DBD04652041B69B456DFBD02B417B1F0C300A67204125A3066CDBD02B41FD0C0B980F69204129800B87B8D02B41C0C2708DB06B20417AA48FAFB6D02B41EFF35A61A26C2041103AB938B6D02B418C096740DF6C2041C2F8DF9F30D92B4145C21951026D20410949163630DD2B417776F3E92E6D204101F65EC5F7DE2B416FE38DFA456D2041BF4D3446E5E12B4118D8F67E5D6D2041DF0A4FCF0CE22B4176565FBC5E6D2041278E137FA0E22B4167463B77636D2041F7F73216C1E52B4131ED59C7816D204115FC3BBFCDE52B41B9642387826D204176B4CD7D5BE72B417BF31D129A6D2041935914A362EB2B41F01539F8B06D204124D59A3E9DEC2B41959C80CAB76D204116299D043FF02B41F3F54EF3CB6D2041A41987043FF02B41A85FA9ABCE6D204129F151ABB1F32B414706C8B1F76D20418EBA9005B4F62B41D374DDA21C6E2041693B43F586F72B41778A6B87286E20416C6536F586F72B418FF410CF256E204181BCF38F1EF92B41ADE0B280296E2041
3	3	12	086	002404	12086002404	24.04	Census Tract 24.04	G5020	S	920634	0	25.8070826	-80.2278803	     5386	     2346	4614	190	534	6	12	1	4	25	1147334.9453125	4338.63715716942	0106000020E6100000010000000103000000010000002F000000B562386CC40E54C00D2D36FC4BCD39407AF76137D50E54C0FC7E91D249CD394030D0508FD60E54C0CA0435E4B5CD394069421F8BD60E54C0898CEA64BFCD3940370387ACD70E54C053D343413FCE39404268C6B4D80E54C03953874D7ACE39407ED652D6D80E54C0F76975ECB6CE3940E0701193D90E54C0024D792AF6CE3940D3D7E510DA0E54C05F44C79F30CF394021D9784BDB0E54C09D390DEAAACF3940885769D5DB0E54C0AF70F914CBCF3940E63030DDDB0E54C0055530E5CCCF3940FF5EDBD2DB0E54C01487207ED2CF3940EE5C27B6DB0E54C0DEA62B0BE2CF3940A5555AAFDB0E54C0ECF9ADB9E5CF3940CC0F7045C90E54C09EF0DE08E8CF3940984826D5C80E54C0CEBCB718E8CF39405335E243B40E54C0581E0700EBCF39400253035B990E54C0B5CEE804EDCF394005673F2E990E54C07E2E4608EDCF3940B3C86A5A770E54C0E157887BF0CF39407721444E750E54C09799F9B0F0CF3940444FCC6D560E54C0B55A2CE0F2CF39406AC3E416560E54C014C051E6F2CF394069123916560E54C0B55C6E69EDCF3940B2FC9213560E54C017F4209CD7CF3940AF3D724E550E54C0AD336CEC9ACF3940213AE495540E54C0DADA0A436CCF3940E1297B0B540E54C0F0F7AB993DCF3940CCCDECE9530E54C0316FAF951FCF3940B48AA941530E54C0DF1A06EA00CF3940022E9841530E54C0C039E7E600CF3940BFBF7EDD520E54C01BBACA89C5CE3940785C8631520E54C093F154E591CE39402A8E2914520E54C084FDBD3E89CE39403B9B6AEE510E54C015660FAD64CE3940191115BC510E54C084F4427E4CCE394008940064510E54C082A4A47E2DCE3940601C0F3A510E54C0E4BD90DD1BCE39403A436CC0500E54C0C1984A0EEECD394088DE92C04F0E54C0627B7A3897CD3940445A14DE4E0E54C0922536D059CD39405CC4928D700E54C082E7250356CD39409A7587A47F0E54C08F4743EA53CD394099445117920E54C0CDE1857D51CD3940B68907B6B30E54C0D05688B84FCD3940B562386CC40E54C00D2D36FC4BCD3940	0106000020BC080000010000000103000000010000002F000000B80DC64693BF2B410A93E7A25A4F20415F212DEEF0BC2B41ED6A64B53E4F2041242FCEF9B3BC2B41ADFDF21AED532041595FBF04B4BC2B411DF3CC835654204154BA9D567EBC2B41E8A8B67EE059204164B26A0F51BC2B41E5DA09386F5C20419B167BDF47BC2B41E61DE0990F5F20412679402B26BC2B41009A1CEBCC6120410AEB17A50EBC2B414B687C3A55642041B2883161D5BB2B4196BD9365A1692041478181A8BDBB2B410B86FB13066B2041BBEE2452BCBB2B41D8FC472F1A6B2041F9AA4C94BDBB2B41B7DC0548586B20416B5B5413C1BB2B410E79F4CC046C2041E4DA71E7C1BB2B4126A9F8A42D6C20411BD73A3FA5BE2B4106C414944B6C204126A6ADDBB6BE2B41ADFF355E4C6C2041069DA8A7F0C12B41EDFEE767716C2041C31DEF3529C62B41F1AC76228E6C2041C3927B3B30C62B41130B55528E6C204165B739837ECB2B41CB9A8092BC6C20417CB88CB9D0CB2B413FFF1E5FBF6C2041DD9D0E97A8D02B416986A5E7DE6C2041103AB938B6D02B418C096740DF6C20417AA48FAFB6D02B41EFF35A61A26C204129800B87B8D02B41C0C2708DB06B204125A3066CDBD02B41FD0C0B980F692041B69B456DFBD02B417B1F0C300A672041E2EC643114D12B414BD33DBD04652041FE57BA6B1BD12B41E5AD6DD5B76320416201FFD237D12B418309A8C963622041FD8CECD537D12B41D8E00EA7636220410C3B466C4BD12B41F1717D46D15F2041BE1DCAC769D12B41607F3A9C945D204169FEECF36ED12B41CD06AEAE345D204181AB594477D12B410303AF169F5B20418303E5BE80D12B41F26281E5925A2041E05D8E9790D12B41D86884233B59204187565B5398D12B41B0EAD7A1775820418666D067AED12B41D85D4F9E7B562041687BD639DCD12B4149A42AABB8522041A4661BC703D22B418923C3BD0F5020412145221BBBCC2B415EF7199CDD4F2041D43341315DCA2B416989AFC8C24F2041260B176778C72B41578E9389A34F204150D4DF3A32C22B41D9EB60FF874F2041B80DC64693BF2B410A93E7A25A4F2041
4	4	12	086	010609	12086010609	106.09	Census Tract 106.09	G5020	S	2178920	73039	25.570315	-80.3610726	     5140	     1961	3369	593	1058	5	38	8	11	58	2775625.28710938	8881.44835376825	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
5	5	12	086	010016	12086010016	100.16	Census Tract 100.16	G5020	S	1184764	102836	25.949931	-80.2858439	     4919	     1356	3902	246	708	2	23	0	4	34	1592266.43164063	5429.35924739599	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	0106000020BC080000010000000103000000010000004100000054750FEFCB422B414A5EB8F212FE2141A23C1BF5E3422B41DF0A6BB459FD2141848599F8F8422B41712B726591FA21419ABA46D20F432B4148DC0342D0F82141B3AC269680432B412B9D3C178BF821419AD6969176432B416F1357ABB9F7214174F9C61D85432B4135DD0B50BBF62141B954504C99432B410E03C3A678F52141802BCD32A4432B410B5298B3BBF42141B56DC36ECC432B41394A40DDC4F2214115066FB01D442B418217E05FAEEF21419F10DB922A442B41A035470878EE21419EBD620E41442B412C071D8D82EC2141DC73FFEB5A442B41CCA010A47BEA214155F02C3D66422B410CE2645862EA2141018A487B733E2B416A77DCE051EA2141D5B77B41913A2B41E5AFCF562FEA2141D7D711A93B392B41DD5CE9A80FEA21416E9112F19C372B411ACB7BD70EEA214161B592D0CC322B41AC13641DE8E92141D112861BD2302B412A81B070E2E92141B752CD72D62E2B41ADC4EBA7DDE92141A95EEB2ED02E2B41AD2CDD98DDE92141702D7110962D2B4180025B4BD2E9214173041B784E2B2B41414134C1CAE9214196CC6939B6262B41047A14BEA0E921415B8F00F91A232B41226BAE627FE9214105FB4E7BE3212B4186C2D02777E9214134D4FCED871E2B41F30C469B5FE92141676245FCC31A2B416213C55B3CE921417A5505F47D1A2B41566AAD5530E921417A589E73471A2B41B60A2BFA26E92141D6D83E18471A2B412D52B1D32DE921411F26FC9B3A1A2B4179F94C411DEA21418E19D9B0051A2B41772D3477C7ED2141E9A0C8BDCA192B41DF7B2C60E0F221417F4750FFA6192B414A22C41821F621417CC0A98D95192B41505C46FF81F72141BCCA5D4495192B41C50580CC87F72141C34A3C3494192B41E1A20CE4BCF821416CFEAD407D192B415572A6B3ECFA2141A818A3717D192B4142B1B22F96FC2141E90CAAC37C192B4177739801B3FC2141E65E60D479192B414C25B96F2FFD21413864AF1668232B4141AA0C0CB7FD214141C08F70FF242B41EB653DE2CCFD214104D910AFA7282B4107A3DFC3FFFD2141D6F688A4C6282B4198761BD9F2FD21412B33E8B0752A2B412CD0EADF88FD214116A526857B2C2B4114DD293C92FD21417FEEA38D6E2D2B41A5458CD2AAFD214147015D7BAF2F2B41194F153CBDFD2141B6C46B6E7A302B41B837A8E0D4FD21415395808068322B41F607DA4AF0FD21414346FD7387352B413FDA438E17FE21413565367336372B412354D32D36FE21417669B6A4D1382B419ADBB6574CFE21418C052493D5382B41E779EF8D4CFE214109E03DD3103B2B41E549ECED6DFE214197D09E14F63C2B419B3F84948DFE2141F03DB1EFEB3E2B414C5CDF3ABBFE21418959CB75E2402B41737AC1CAD1FE2141DC107CF62B432B4196443B62F3FE2141525BB5EC2E432B416D87EED63FFE214154750FEFCB422B414A5EB8F212FE2141
10	10	12	086	011403	12086011403	114.03	Census Tract 114.03	G5020	S	5075449	155186	25.4487034	-80.4923903	     6636	     2267	3402	873	2252	8	30	2	15	54	6439788.57421875	13350.3239224992	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
7	7	12	086	011005	12086011005	110.05	Census Tract 110.05	G5020	S	2112039	88980	25.489979	-80.4281705	     6011	     1655	4637	558	704	2	71	0	8	31	2733189.07617188	9080.08013262017	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
6	6	12	086	010015	12086010015	100.15	Census Tract 100.15	G5020	S	1728034	183930	25.9614033	-80.2866994	     3886	     1189	3530	244	80	0	14	0	3	15	2369250.61132813	6393.25822395661	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
16	16	12	086	008309	12086008309	83.09	Census Tract 83.09	G5020	S	2456097	0	25.606452	-80.3576356	     4459	     1570	579	46	3774	5	8	0	11	36	3032265.2578125	7736.89682237158	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
8	8	12	086	003601	12086003601	36.01	Census Tract 36.01	G5020	S	822494	43059	25.7763164	-80.2012916	     3027	     1611	1829	133	1035	10	7	0	4	9	1071436.42578125	5769.82250337493	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
9	9	12	086	001802	12086001802	18.02	Census Tract 18.02	G5020	S	1100984	0	25.818224	-80.2283664	     4005	     1454	918	29	3029	3	5	0	1	20	1357482.74414063	4826.17550746456	0106000020E6100000010000000103000000010000003B000000CC0F7045C90E54C09EF0DE08E8CF3940A5555AAFDB0E54C0ECF9ADB9E5CF3940DED53822DC0E54C0D10F8972FDCF3940D6B0F831DC0E54C040533DB300D03940B24898A7DC0E54C08FDE91BA25D0394057349F29DD0E54C078C1415B56D03940833B09B4DD0E54C0FADFD84F87D03940B93E3164DE0E54C0EDE618C69ED0394065959C57DE0E54C0CFD98DF0B7D039404E1DF70BDF0E54C097243D28E9D039404E70862DDF0E54C0F84B979619D13940A6FD0310E00E54C07C2D171A49D139401CA1C1CCE00E54C04D58AFE078D139400898C2CCE00E54C0D2FEE2E093D13940CE25F4D0E00E54C0AC389ED9A8D139404B59DE0FE10E54C055F7A7AACAD139407ECBAC0BE10E54C0DA5CA2DADAD13940D595C74EE10E54C02985ABE809D239400FCBF8E9E10E54C052B93FDD3AD239406D863DDDE20E54C0C678DBD16BD2394038F857B7E30E54C0332554559BD23940F9486330E80E54C0A1EDAB3CB4D239408BEE1231E40E54C041148BF5CCD2394042756C0FE40E54C072975F92FDD23940D4F87D9CD20E54C00815AB2000D33940462ADF20C30E54C034AB76F601D33940DEB8A8CDA10E54C022E8309105D33940AFD684D2800E54C0233CD4160AD339400351A31A5F0E54C00FCF02270ED339406F0779015F0E54C0F1BF0261DAD23940F263BB445E0E54C07D986624AED23940E09317CB5D0E54C0B964ACDF7FD239406E3FA7555D0E54C06DC4A7A34FD23940D960E1AD5C0E54C057C098FE1FD23940C973F9D75B0E54C0ACB776E6DFD139408180D4A95B0E54C016F60172BCD13940022365345B0E54C0C8C04FD18BD139407193ECD35A0E54C0CA33D29975D1394096FCBBCF5A0E54C07132702F63D13940EAE2ED3C5A0E54C0260D39872CD13940E693A0F5590E54C00886704908D139403E1CAFCB590E54C0594907B1F4D0394022FDBD0A590E54C06AA08A5DD5D03940BAF79ADC580E54C0C344E15FC5D03940266C6456580E54C0A506F46695D03940FA64FACB570E54C01E9F0AD764D0394087108A56570E54C0BD6CE1EE34D0394018480489560E54C065A15ABA0AD039404ABAD284560E54C0AD36BB9D05D039409735A080560E54C0A087BF4103D039406AC3E416560E54C014C051E6F2CF3940444FCC6D560E54C0B55A2CE0F2CF39407721444E750E54C09799F9B0F0CF3940B3C86A5A770E54C0E157887BF0CF394005673F2E990E54C07E2E4608EDCF39400253035B990E54C0B5CEE804EDCF39405335E243B40E54C0581E0700EBCF3940984826D5C80E54C0CEBCB718E8CF3940CC0F7045C90E54C09EF0DE08E8CF3940	0106000020BC080000010000000103000000010000003B0000001BD73A3FA5BE2B4106C414944B6C2041E4DA71E7C1BB2B4126A9F8A42D6C20412C333D59AEBB2B41EAE0E3AA346D2041FAEFD8AAABBB2B41EF2BA7BB586D2041F7D491D196BB2B41911FF459F36E204115BA02467FBB2B410B14D29D0E7120410CCC3E6466BB2B410AB466822D7320411B01403D49BB2B4121172F97317420411A71819549BB2B4136B4A7BE48752041B101461B2ABB2B41EF01A8816A77204107741FB521BB2B418AC2DCAD837920414596751AFBBA2B41B223DC7F927B204177687C67DABA2B410F1FF142A47D20417244FEA7D8BA2B412132F7C1CF7E2041D33422A4D6BA2B4197C4A35FB87F2041BBAD5C95CABA2B411358E1692F8120418AF09131CABA2B416A8467F8E2812041C696399FBCBA2B418EB1E0D8EC8320416849171CA1BA2B41AE7886B90B86204194ED2CC877BA2B4172EEE0852A88204163D4C97E52BA2B412B60A059398A2041211BAA459DB92B414DDB92894C8B20410C5E73303CBA2B411168F6B15F8C2041E6605D523EBA2B41BC3296F17A8E2041647307D5FABC2B41EC5859629B8E204144F6BB7068BF2B41255DD65FB38E2041D0540766A2C42B41AC0E6F31E38E2041D9882B7BCEC92B41335B33211D8F2041BD02B93218CF2B41108E022C528F20415A210C881FCF2B412A7E9FEA138D20415724C30740CF2B41C4720F69298B2041C334072356CF2B410D85674E288920418FB68BB66BCF2B41D83D3164118720412F277E2589CF2B41EF1D601001852041AC9C80E4AECF2B419740A8513A822041C93E2F73B8CF2B417F223D17B1802041F65B4D0DCECF2B41B37958D0957E2041056B5BA3DECF2B416B8CBE789F7D2041E920F67FE0CF2B4178D82335D37C2041F1828D1AFBCF2B4168D34B14757A204142B3C0A808D02B41A0D2B826E378204129CB3C8510D02B413A21EED509782041BB920DD630D02B41956B5E8AAE76204103479D1E39D02B41D90AD735FD752041AFE5C34F51D02B41EE42E937E97320418DEF8C336AD02B41E0A63EB0CE712041CBAC0CC27FD02B4141C45668BB6F2041F92886C2A2D02B41EE2AC473E76D2041897E8AC0A3D02B4103B357C1AE6D2041ED659D90A4D02B410026E096946D2041103AB938B6D02B418C096740DF6C2041DD9D0E97A8D02B416986A5E7DE6C20417CB88CB9D0CB2B413FFF1E5FBF6C204165B739837ECB2B41CB9A8092BC6C2041C3927B3B30C62B41130B55528E6C2041C31DEF3529C62B41F1AC76228E6C2041069DA8A7F0C12B41EDFEE767716C204126A6ADDBB6BE2B41ADFF355E4C6C20411BD73A3FA5BE2B4106C414944B6C2041
17	17	12	086	009905	12086009905	99.05	Census Tract 99.05	G5020	S	2162143	6377	25.9500736	-80.2203591	     5283	     1489	351	169	4670	4	26	0	9	54	2745286.23828125	6551.57135977531	0106000020E610000001000000010300000001000000350000008A03EB80400E54C0923488A61BF139406B91BE65420E54C01A83E27C1BF13940C2EA6D9E540E54C07BAF3E0068F13940034EDB81630E54C0104BD0D6AEF13940A040076C720E54C0034A214A01F239406A4AE57C7E0E54C02650E3E851F2394046D31FC2890E54C06004D05E9FF239404BB6E8418F0E54C019D79383D0F239408D133DED910E54C0A847DE99E6F239404A281C48980E54C0F5850C9209F33940D28613AA9D0E54C018212F7148F33940749264B6A10E54C0B8D598C87DF33940DED47154A40E54C00693B6C3A6F33940DC130BBFA60E54C053A36909D7F33940CD0A656DA80E54C00336F58007F43940E20D6006A90E54C0107598BB18F43940C80C8279AA0E54C0A5EC23885DF43940CAB32491AB0E54C021F9259097F43940B1D1C491AB0E54C0457387CB97F43940496D1D06AC0E54C0144AE602C3F43940A3BC6B08AC0E54C02C3916DEC3F43940FAA7D410AB0E54C047F4CEE9C3F43940BA8397DBA70E54C0B9AAAF10C4F43940BA89E4EF800E54C06EB5F9FECBF439405B7C1A474E0E54C02CC36E27D6F43940BF478666400E54C06AB5FE76D7F4394074F3FE89330E54C0304E2FC2D9F4394014587FC4180E54C0CE0F2CE3DDF43940160944D2100E54C0126095B4E0F43940FF01F345E40D54C0499C4CABE6F43940096BD5A5AF0D54C0AA023D1BF0F43940FBCC3A17AF0D54C0DAC5EF858EF43940DAD21167AE0D54C0CC0FF5B180F4394061E00663AD0D54C0E8522D5017F43940563E2AFAAC0D54C0B2077BDDE7F3394082125E67AC0D54C078671FD8B6F33940E35E8539AA0D54C0E9219D8B12F33940636C7A35A90D54C0C65A49CDAAF2394044FE3B2DA80D54C088E1F1B44FF23940BD4D3D96A70D54C09FA43A9E22F239401FB5C535A70D54C070514701F5F13940D751CD89A60D54C062021659BEF13940D1AEC3EEA40D54C04CF5415434F13940C84697EBD60D54C05D10FE762CF13940A30B06D6DA0D54C0E944FDDF2BF13940D67C0C20E50D54C0AB56E26E2AF1394081A87844EE0D54C0D43DAD2328F13940F06AC753F80D54C0E3EF5CC326F139404F83C0F11E0E54C03397DD2420F139409D4BE650280E54C03BFF187D1FF13940DA14B0B7360E54C0699B1B8A1CF139402F114BBB3A0E54C08C5B70251CF139408A03EB80400E54C0923488A61BF13940	0106000020BC08000001000000010300000001000000350000003A2D688CEBD12B413D02F08EB3DC21410157D5959FD12B4125948B4DB1DC2141A21C9F95BFCE2B41AD4845ADFDDF21411DE419AD65CC2B4197084CE60BE321417310D4F509CA2B41248674ED9AE6214114CE14A820C82B41BFD30D5516EA21413E3F947A57C62B41A0B9B4E16EED214196E15DAB77C52B41D8DE76B28EEF214101937D260BC52B41261C061083F021417EB54CF109C42B41F56DB87305F22141427621EA2DC32B41DF6F7892BDF42141FC7ACC0B88C22B414DFBE44B0CF72141B0059A601CC22B417A358240D2F82141E46CA34BB8C12B41101F1522E9FA2141AE47B4B271C12B4161D8105902FD21419775379A58C12B412BDA3351C1FD214125B5EFF419C12B41B89CD01DBC0022410C71005AEAC02B415651A18F3F0322412C11093DEAC02B41CF6E272242032241DA2EA82FD5C02B41B511556521052241A052D9C4D4C02B41264716E42A0522413142368FFBC02B415DC095A02B05224142E383397CC12B413868D4112E052241FF3D11DC94C72B412B2B1F408F052241FB0AEC3184CF2B41BA76DFF40B062241EC9FACBDB0D12B41B2B0CACC1D062241F1F1E679B4D32B416874C44E3A06224130356409E6D72B41B393147F6E0622410983EC9424D92B4117A96FA78F062241BCF6060F1FE02B41060BAE79DC06224120A9F04A5DE82B4195BC04CF510722412A9D38237AE82B41B4BAA983170322412D4A1DA996E82B4170485D4B7E0222412383446DC6E82B41D045B49AEDFD21413D6FC704DAE82B41B7896E64DFFB214106BE4C49F4E82B412F8BCFC5BFF921413E6CA7A456E92B41F8D908D6A1F22141FD8E924D86E92B41131B525223EE214177386FC7B5E92B41ABE68D1C31EA2141E3B2AF71D0E92B41C91E171D3DE82141FE9A8E99E2E92B415E0A853F43E6214145F98E3001EA2B41F465AF22E5E32141F07922CC4AEA2B411BB4C591EADD21413935C90476E22B41B4D9C64F87DD2141E8A439F9D8E12B41F2902DD47FDD21419CB52A4F3CE02B417F3D065E6DDD2141C7B0B1B5CDDE2B41464A78BB51DD21416F81F73D3ADD2B41FE85970E40DD214183CC18842DD72B41332E0D67EDDC214177DFE39AB5D52B41AE0396E5E3DC214132E3551174D32B41F97B00C0BFDC214159BE8110D3D22B41735F876EBADC21413A2D688CEBD12B413D02F08EB3DC2141
11	11	12	086	011001	12086011001	110.01	Census Tract 110.01	G5020	S	3675133	60512	25.4787543	-80.4558269	     9130	     3268	6320	633	2024	9	51	3	25	65	4603641.05273438	11700.359943122	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
12	12	12	086	009400	12086009400	94	Census Tract 94	G5020	S	2537501	60467	25.9329545	-80.2547584	     6370	     1821	1630	128	4539	9	2	1	8	53	3233712.828125	7192.14274714897	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
18	18	12	086	000807	12086000807	8.07	Census Tract 8.07	G5020	S	425003	0	25.8330613	-80.2827352	     3900	     1564	3704	126	63	3	1	0	0	3	526808.8046875	2910.40038327129	0106000020E61000000100000001030000000100000015000000C147C684E51154C06FB0243D78D439406979EBE8051254C02BDBEF5A75D43940B7B35B2B271254C07643F7D071D439400738AAA8471254C09890FE466ED439405EC5278B481254C056B91136A8D439401C99A7D6481254C01021DA84E7D4394041724A50491254C07ED1299E1FD539404F6374004A1254C06AE6DC4D5CD539401940F34B4A1254C0E0663D9D97D53940CCC9945C4B1254C00D02159DD1D53940F80D9C474B1254C0BB9441940DD63940DA6BEF432B1254C0D13FC1D611D639400912DA1E0A1254C0A7490F2A16D639404D67E23CE91154C006C9E6CC1BD63940C6B6E3A5E81154C035EDA8FBDED53940C6461028E81154C09F0C3FACA3D539406EB99245E71154C09D71194C68D53940D9F710FAE61154C0243A28442CD53940A0156F80E61154C051D27494EFD439404888F19DE51154C03EDE61A5B5D43940C147C684E51154C06FB0243D78D43940	0106000020BC0800000100000001030000000100000015000000D4605D3A75412B412F24E564349E2041B16018C8603C2B41FCD11F4B0D9E2041FED5F28129372B41EE5EE1C0DE9D2041EB49202711322B4124EBEA66B09D204168CD1023EA312B41EF75B7D032A020415FDBF47ADA312B4167B4E9F6F0A22041E9508D05C4312B41B91EFA1C5FA5204198EF02BCA4312B4169078F1900A82041CB8AD05195312B41363522E891AA2041D18E851067312B4199D4F40115AD20410E139ABD66312B41F45DD42AAEAF204130B0C4E76B362B41D98BBE68E4AF204107EED2749E3B2B41EAE971A51BB020410DC56866C6402B4112E86F6261B02041C6E715C7E1402B41AEBF61ECBEAD20417909CC1DF9402B41616872282DAB2041540D7C3F20412B41433111C19AA82041243417BD2F412B41FC9D4CF300A62041F2E2FA8046412B41426AE8EA5FA3204110F27C8C6D412B4117E55F81DDA02041D4605D3A75412B412F24E564349E2041
14	14	12	086	009307	12086009307	93.07	Census Tract 93.07	G5020	S	1267986	77800	25.8928296	-80.2964004	     6696	     2288	6314	272	92	0	13	0	0	5	1669539.24804688	5630.44211906317	0106000020E61000000100000001030000000100000061000000439A13C1BE1254C034584B4B1AE63940E732144CBB1254C06C54D8D519E639407B86A5A8B91254C035A4EEAF1AE63940D5F2257FB61254C0B91CF2AF1AE639408BD00C0EB51254C0B91CF2AF1AE6394007ACF81EB41254C0B0DF474B1AE6394062E04AA1B21254C035A6105C1AE63940AE237373B01254C023E3BAC01AE6394025E78934B01254C0BD26DD010CE639406AC0280CAF1254C03D5AA051C0E539409146FF0BAF1254C095E11545C0E5394006BD8A12AE1254C01EB99C4475E53940059525FEAD1254C072E097A96EE53940BEE21C63AD1254C0307A66743CE53940C251C3AEAC1254C0DC9D15F204E539408FBA2CA2AC1254C059436E13EAE43940481A9795AC1254C02988B974C8E43940D2E6AC56AC1254C08D234F38B7E4394012540C46AB1254C05A49F2F578E43940B398C752AA1254C0C9DDFA7740E43940BB8E600FAC1254C0C9DDFA7740E4394096B0C55EAE1254C0B5E7C38840E439403E988A06AF1254C0B5E7C38840E43940067453F5B11254C0E578899940E43940F24AFBF0B21254C0B5E7C38840E439402E76B3F3BC1254C0349AE49D3FE439400676CA5AC91254C048901B8D3FE43940BA2DAA51CE1254C0F6BD6F283FE43940E5137C50D61254C08E2CAA173FE439402519B6E5E21254C08622E1063FE439408BC45CD7EE1254C0CC59FEB23EE439404A4ECE820F1354C0E9D001853DE4394087CE8C0C311354C0EC3473633DE43940E872B20C301354C03E0E647403E43940B2C807D9711354C057ADD5E903E439407F36E0D8721354C0D7F48C6B3FE439406A009916B41354C0AE63C72C3EE43940A119B387B51354C0BC8F603D78E4394061CCAC9CB51354C0737B4C279CE439404CE0F1F8B51354C080070AD3BAE439406E6A472BB61354C0CC2CC9C9C0E43940BF87F18FB61354C09BF41FDDCBE4394010E23855B61354C07D29C933F2E43940A5502B7FB61354C000902882FBE43940CA99A176B71354C01B5C187B2BE539404E2E89E3B81354C088DBBF3FA1E539400E8EF3D6B81354C0A269E527D1E53940A26CB97EB91354C07856A3A5EEE53940062B21C5B91354C058F1235110E6394091631FCCB91354C009202EA913E639407596DDCEB91354C09B2AE1F814E63940235FDECCB91354C0ECF858F714E63940D814A93EB71354C02136070613E63940A498F7D4A91354C06B1C85DE17E63940DD0AC6D0A91354C001B931AC17E639401A5C0E96A91354C02BC0FB8E16E63940177825C0A81354C0891BFEF715E639403724B785A61354C03596BD9F16E63940F2A430DAA21354C0F2D19F141BE63940C6985743A11354C0CAA9D49A1BE63940DE6884E79D1354C06BBBEF461BE639402AE9491A9B1354C09CC8686019E6394014923C5A941354C0014C149718E63940F4F5BF6B8F1354C09CC8686019E63940709906538C1354C01360800C19E63940988EC0F68B1354C02D22F85318E639408B60F9E58B1354C03E326A6D16E63940512BC84A8B1354C0B0D589B016E63940F681333E8B1354C0BF12DDA718E63940331019648A1354C07E7AA34F19E63940442CC061611354C0F8B3DA3E19E63940169AAAB65A1354C0F21AA1E619E639403F1F91DC591354C0F8B3DA3E19E63940C8F09ED4561354C0F8B3DA3E19E63940885640864D1354C0F8B3DA3E19E63940786958B04C1354C0A312DDA718E63940BEE71D53361354C0C5A3BF9219E63940B14FBA822C1354C0D9B62B081AE63940D9B93FDB291354C09D162E7119E63940AC855F1C1B1354C03FDDF68119E6394073708785191354C0F21AA1E619E63940895DF885161354C0F21AA1E619E639402A177F47131354C0D9B62B081AE63940CF6DEA3A131354C0F21AA1E619E6394069F4B1B4121354C01850656019E639400E1B685CF71254C034584B4B1AE639404929482CE81254C060CBB9291AE63940D3858A6FE71254C09F6AB7C01AE63940889B9F52E41254C0F2D19F141BE639408EAE0596E21254C0B12D0D5C1AE639405A0FC165D41254C0F36866F719E6394096A8D580C71254C035A6105C1AE63940633690AFC31254C0DB04F1181AE63940775FE8B3C21254C09F6AB7C01AE6394063938614C21254C0A16D2A361BE63940DE1674F7BF1254C0A50BD7031BE63940439A13C1BE1254C034584B4B1AE63940	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
15	15	12	086	011101	12086011101	111.01	Census Tract 111.01	G5020	S	3588764	35609	25.4728669	-80.4699004	     8620	     2970	6426	932	1111	7	44	32	6	62	4476563.59765625	10103.234055786	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	0106000020BC080000010000000103000000010000007400000099D2B214D36F29414141EFCB968E1941641957BD756E29415BF473A5338B1941BA0FDE7EC56B29414D29D449F28419417DF2C6CB0869294124C4A0CEDF7E1941CB2DCA0BEA6629419630928ED0791941E0060642D2662941CB75B1BE9B7919414B9DDE4B2E632941AE7857AE86711941AD9EC7AB146229414EE64CEEE36E1941274AD2ABC95E294134DC6C6E62671941C9BA222BA55E294129DDA90015671941DCBD65D0815D2941D708FAFBAA6419416DF7D4AB815D2941D9D86BAEAA641941906A22B7855D2941D6987BA8AA641941904EFE93255E29410F31A0C5A96419413C71B9DE8E5E2941AD5783B9A46419415B865375AE5E2941F7F3DC35A3641941899BE958865F29410455D7A6A36419417C375E943061294147D4AC99A56419416CAEF506016529412DE62208C96419417D6900D3EF682941396341BAEC6419411BCAB29CBF6B2941BD5A27AF0C651941630E73146D702941458A08C63765194192D7DD9DB57329412D2996D45565194151BA564CCD73294157F7A3D3485B1941FA2255EECF732941D1E3A11B065A1941D261E846DC7329419AAAB02353571941F6A0283FE67329412209056628551941FF58FA2EF57329416E09A03B86501941387F9CA5ED732941170176E23D4D194119F07E6AEE732941066065EEA8491941EA44E96BEE732941C6C62CCEA1491941C4CD9D89F5732941BD12D2FD324819417207A019F5732941584235DA7E461941687F0DE9007429410E6AA3FDCD421941CBDA35100C742941AA14DEAA1B3F19415E4E470922742941D48DE4B12D3C19410722AB681D742941195698D5BA301941368A918D1D74294143DB8C9973301941C62832AD1D742941589A358B36301941B4A78ED61A7429411A68083C3A2A1941CB87826929742941453F41B06D241941C4AFFDCB2E742941F4525A8DC11B194197433A2C047429415BBB24ED8B1A19414CDFF64B99732941B5E5904D7619194135E354C0A0722941FE6357D7D5171941EF0F102CC7712941FF111CEDA01619417C5CF20BDC702941D85F462DA2151941B12BFB22676F294102C3D867B31419411552FF8BED6E2941051D6AAD1F141941B1AE02BA9E6E29414F4656BD0A131941B8EA18938B6E2941ACEEE8C0CA11194175621C4C866E2941EF7F04ED7211194115836B60F85E294175D1DF76C91019418650EB5A305C29417D40409CC9101941E02AABC35F59294122383B57C5101941B31254A2C45729416E5CC529CF10194165A10D583F5729412F4EFB32CB1019413EDAEC9A235629416E981D97C410194136413D0E72542941DA8A2B85C5101941AFADECF6254F2941F657992BCF1019418A4293C8AF4C2941424779C2C8101941380C7371A44929417C93C444CE10194186A69F239D492941EC5F69AB271619411F5244C29649294104AFB5DFF91A194192A16D4B8C49294188A745AD83201941A8E042E78C492941F92FA439BC201941FC88B39B9A49294147C4C98AB52519417E669F1B85492941195261BB1A2919419248E54B854929416EF1E7B4AB2C1941927C406B7949294171DE9D0D452F19419B75F844744929418F2E338ACF3119415E54E450734929411D4248F6473219418FA32F62734929414A0BA78E7C3219413728D43974492941FBFCEBA70F3519412CD89EDD7349294131FC3B4F0E361941B29213C373492941CAF3FB5F1A36194113A972377249294102BAF1C0CF361941AF6B4CA96E492941872B0251FD3719412828C991684929416F7F66CA833A194109C0AE1668492941A106294CC93C1941DAA67A5A63492941CB3CD2F6A53F1941E4C690964F49294171ADEB03D8441941307F8DFA4A492941D27CAC5C144A194126E023BB4349294198DA8EB0504F194136AEDCF03949294182C35E915B5419413F8E544B2D492941A76E632EA759194157FFEC412D4929417A82C3ADB55919415B09380B2A492941EA3630CEC35E19413DB719E220492941574AABCA1764194176C6837B1F49294116858FAF82691941AEC2972A11492941E8F1CAE8BD6B1941BF164E0F11492941DE2738CC946E19416DCAC1DB0D4929410FE72617A473194133F1CAB402492941A2D7E6C3C4781941551FDBC502492941B1064D13E47D19419A62FBC0024929416BFE88FF2E831941DDE3C4D1E34829412B5B18B449881941F48351C6E34829416EB0D4B5A18D1941E3B40CD5F84C2941E1D3E7ECA98D1941AC8FA4647D4F29414A2237A2BA8D1941E4BC87BC535229413D576C89DA8D1941917501429E5329417936D0DEE58D19411B169B895D5629414AEC4212F78D1941E35A0CC61E592941B5227AED138E19414EFB69F4CA5B29416034398D138E19418F80227B705E2941B0424935308E1941053A83752A6129411534750A4D8E1941BA5CA328A56329418684534D4C8E19413CA89081D8662941294B7736778E19419D118CD8B468294113CE2FDF728E19413ED1EF2BD768294148D72F8F728E194177FFF93D57692941C12F4436808E19411320CA109A692941072C3356878E1941E0D67BFD356A2941EC02F94C8B8E1941B62CA862616B294165BE5AEA928E194199D2B214D36F29414141EFCB968E1941
19	19	12	086	002501	12086002501	25.01	Census Tract 25.01	G5020	S	945956	0	25.8058985	-80.2179573	     5388	     1698	4161	139	1031	7	20	1	5	24	1172174.99609375	4762.3974339308	0106000020E6100000010000000103000000010000003A000000E78FDE8CCA0D54C0C33CECFF6BCF394027C0A01BCA0D54C0B0FA864B4FCF3940DD69BA61C80D54C0042E88A44FCF394025DAB7B5B50D54C096815E9252CF3940874CE61FAD0D54C01593770354CF39406B9DE1E9A40D54C02D35192555CF3940FD297936A50D54C0F63941E24ECF39406FC2F9E4A40D54C0B788599D30CF3940FF8957A2A40D54C07E08CFDD17CF3940D9D613A0A40D54C06875830617CF3940A3013B21A40D54C009AE9BF3DBCE3940111F339FA30D54C06A46BBD798CE3940BE05CB14A30D54C0334965EC61CE3940EE39A027950D54C0F9650FAD64CE39404366BB5B890D54C021A8812265CE3940796474FF880D54C0D81FA56147CE39407FCFD870880D54C09C4D7C1018CE3940FFE13C79880D54C00352A6C705CE394065283FE2870D54C0D628CA06E8CD394013E6CC6C870D54C02061ACCFB2CD394049094E21870D54C010905C9A71CD3940BE3309FBA60D54C0DCB5BF7D6CCD39409CA08463C60D54C02F80C75C68CD3940D1A3AC13C70D54C06DE2353B68CD3940B867EECBC90D54C08F4354E767CD3940FB726ACBE90D54C026641C3366CD39400F31A5CE0C0E54C02698D4B160CD3940A3760F8F2D0E54C07266848C5DCD3940445A14DE4E0E54C0922536D059CD394088DE92C04F0E54C0627B7A3897CD39403A436CC0500E54C0C1984A0EEECD3940601C0F3A510E54C0E4BD90DD1BCE394008940064510E54C082A4A47E2DCE3940191115BC510E54C084F4427E4CCE39403B9B6AEE510E54C015660FAD64CE39402A8E2914520E54C084FDBD3E89CE3940785C8631520E54C093F154E591CE3940BFBF7EDD520E54C01BBACA89C5CE3940022E9841530E54C0C039E7E600CF3940B48AA941530E54C0DF1A06EA00CF3940CCCDECE9530E54C0316FAF951FCF3940E1297B0B540E54C0F0F7AB993DCF394073509633440E54C0219CA55E3FCF3940901091FF320E54C0F963F55541CF3940279A1566110E54C05970925E47CF3940E0E13059110E54C06233B65F47CF39400737D4CA070E54C004D78F3748CF3940E44318CF000E54C094AA42D548CF394018602054EF0D54C0773A000C4BCF3940D67987C8EE0D54C0B68D2F1F4BCF3940B054E0D5DE0D54C0EECBF44F4DCF3940323D2C49CE0D54C0CFE6F5294FCF3940F93A31CBCE0D54C046AE3EDA87CF39408776EDD7CD0D54C003B703EB87CF3940DE0863F1CB0D54C08D41910C88CF394032422480CB0D54C0AC3268A081CF394049BAC9CBCA0D54C077CD6E3573CF3940E78FDE8CCA0D54C0C33CECFF6BCF3940	0106000020BC080000010000000103000000010000003A0000009088AD03A3E62B41E33CF9262867204142C87BADB6E62B41CF52A2DCE9652041788E9BFAFBE62B4181AEB321EE6520411F3594A9E9E92B413BA48218136620410DF5105B42EB2B41326EDA2525662041EB7C640A8CEC2B41BDB816AB33662041A328B57080EC2B414A51B825EE6520414EF6A33B8FEC2B41A4B44D799E6420411B1BE6539BEC2B4199DE8F068C632041A2D51EBD9BEC2B41131F05B382632041DE3E6F8EB3EC2B41C2520790F3602041F48A1568CCEC2B411CB49A4D0B5E20413EEB34C3E5EC2B411CCCB142AA5B204124E880E414EF2B4168D38A23CC5B20419ACB82A1EEF02B4166D89710D45B2041BC33BF15FFF02B4158107A1F8A5A2041B24D339A18F12B41D22DE6687D582041EF59478018F12B416E516296B257204149EFA92A32F12B41C8CA6DB368562041B501032148F12B413D7C2B8A1A542041CE8E904E58F12B413065CC4F4751204175A8706D59EC2B41A612CFF40651204179E9C83F6CE72B4161E90AA1D150204104FBFF9E50E72B4136098302D050204161E39F68E3E62B41C40A64B9CB5020416D1E0261DEE12B417A743D2CB15020412F5B958560DC2B414E63D6C26B50204130E535513DD72B41FE930B1441502041A4661BC703D22B418923C3BD0F502041687BD639DCD12B4149A42AABB85220418666D067AED12B41D85D4F9E7B56204187565B5398D12B41B0EAD7A177582041E05D8E9790D12B41D86884233B5920418303E5BE80D12B41F26281E5925A204181AB594477D12B410303AF169F5B204169FEECF36ED12B41CD06AEAE345D2041BE1DCAC769D12B41607F3A9C945D20410C3B466C4BD12B41F1717D46D15F2041FD8CECD537D12B41D8E00EA7636220416201FFD237D12B418309A8C963622041FE57BA6B1BD12B41E5AD6DD5B7632041E2EC643114D12B414BD33DBD046520413CE9815B90D32B411ACC011F1C6520411AED4A1F43D62B41B6DBFA0236652041C3D9BE1B88DB2B41A0C970ED8065204164FC7A218ADB2B4110FC26FD80652041560CF7DA09DD2B41C7441D9E8C652041351C4B4522DE2B416F08711D95652041DE40EE25E0E02B413BA873D7B16520412D2DFE0AF6E02B416CF194CDB26520418F87476076E32B419D6616E9CE652041A0C703E60EE62B411D254268E76520416A38F4C0F6E52B41398F77155C682041689C75E91CE62B414438B5095D682041614FEC3A69E62B41A2105BF25E682041C5129F6B7BE62B41DB7C34D01768204142D6C9AA98E62B41F60B920E786720419088AD03A3E62B41E33CF92628672041
21	21	12	086	011300	12086011300	113	Census Tract 113	G5020	S	3762753	0	25.4655676	-80.485599	     8796	     3183	4069	370	4238	7	15	1	9	87	4636503.984375	9035.34335234247	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
22	22	12	086	007200	12086007200	72	Census Tract 72	G5020	S	911075	0	25.7268016	-80.2536228	     2507	     1213	290	244	1945	3	3	1	3	18	1126732.83789063	5752.80575674862	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
20	20	12	086	010001	12086010001	100.01	Census Tract 100.01	G5020	S	4325513	198645	25.9674957	-80.2686513	     6465	     1967	1510	69	4833	8	3	0	4	38	5623735.85351563	13232.0300532978	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
23	23	12	086	000134	12086000134	1.34	Census Tract 1.34	G5020	S	1599135	28063	25.9624248	-80.1434223	     2806	     1601	1176	1380	127	2	85	0	5	31	2054754.67382813	8537.19507111192	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
26	26	12	086	002001	12086002001	20.01	Census Tract 20.01	G5020	S	1060195	778	25.8358947	-80.1958796	     3781	     1553	430	71	3124	7	6	0	11	132	1315591.80859375	5836.89086247003	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
24	24	12	086	008208	12086008208	82.08	Census Tract 82.08	G5020	S	2846991	21074	25.6061263	-80.3434961	     4041	     1575	1893	1334	543	3	186	1	18	63	3541568.59570313	10797.3149630358	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
25	25	12	086	002003	12086002003	20.03	Census Tract 20.03	G5020	S	808108	0	25.8287066	-80.2012598	     3336	     1305	597	94	2581	3	5	0	7	49	1006947.63671875	4087.22511296834	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
27	27	12	086	001904	12086001904	19.04	Census Tract 19.04	G5020	S	1121330	0	25.824242	-80.214152	     3932	     1615	388	42	3465	16	2	0	1	18	1390375.32617188	5855.94644580231	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
28	28	12	086	001903	12086001903	19.03	Census Tract 19.03	G5020	S	673456	0	25.8281896	-80.220569	     2815	     1331	243	28	2512	5	0	0	6	21	837479.720703125	3649.83490820842	0106000020E610000001000000010300000001000000310000000FCB0BAB3E0E54C0EBCFDC2012D339400351A31A5F0E54C00FCF02270ED33940791929E85F0E54C05A858D6A44D3394017B2A048600E54C043E065C471D339408B59A0DF600E54C0739EA8C1A0D33940ECA0CF7A610E54C01D13EABECFD3394022F7864C620E54C0931BDDF2FDD3394023A1BF74620E54C02E35C09E2ED43940AB8C1877620E54C0E5DAF27531D43940C4031405630E54C0220492FD5FD43940A23C2172630E54C0B30B63D075D43940F359CBD6630E54C0F1E7DAFA8ED43940348FFC71640E54C02274041EBDD43940450C11CA640E54C0868F1ADDE6D43940F4F226BE430E54C0CACA0D88EED43940ECB2FCF92C0E54C0EF40F30AF4D4394021A7905E2C0E54C0E9EC6330F4D439405B050217210E54C03ACA07E8F6D43940E9F8D715210E54C079C549E8F6D43940BA09B17E150E54C08148EE1AF8D43940B16E345C150E54C0E29A7F1EF8D4394081E5720C0B0E54C0E072AA30F9D43940248895FB0A0E54C0756D6A32F9D43940A47E6103FF0D54C0BFEC838AFBD43940D9B120C1FE0D54C047896F8EFBD43940489573F3F40D54C08E263823FCD4394097AECDD2F40D54C08A32AB27FCD4394010B2AFA9EA0D54C0AF34BD8AFDD439406308B594EA0D54C07CF2DA8CFDD439401C7A361FE00D54C0090AA59BFED439400A98920FE00D54C074D13E9DFED4394042EBF8AFDC0D54C0A6C23EE2FCD43940749A640CDC0D54C089A45C8DCAD439404B72744BDB0D54C07391D6939ED43940D5AE5D8ADB0D54C0B826EE8A85D439403AA2D0D1DA0D54C0BC52CD576ED439402C043643DA0D54C00ED68A694BD43940DCA9EE7DDA0D54C0E7994DD43ED43940C04D605CDA0D54C09287A2050DD4394036DE4000D90D54C01816CEABDFD33940285DEACDD80D54C07B24BD9DB0D339403D49A571D80D54C0BCED046A9DD33940D0CF6CEBD70D54C03916B7CA7FD339401EDB6669D70D54C0FD99A88152D339400D5E5211D70D54C0B11535AF1DD33940A1D6F2EEF80D54C051B33DBC1AD3394068E629D91A0E54C03056DC8E15D339403877A4633D0E54C0E23EFA4812D339400FCB0BAB3E0E54C0EBCFDC2012D33940	0106000020BC08000001000000010300000001000000310000004FF9CC6C2ED42B4108D0A1F6858F2041BD02B93218CF2B41108E022C528F2041B7D05B69F4CE2B4105636BE2AB9120414CED6F50E2CE2B41932BBDD5A2932041AA50678EC7CE2B417ACA61E8AB95204188795524ACCE2B4189D0FDF9B4972041439ACC3988CE2B41F1BCC845B59920415053F5BB7ECE2B41C7E5431BD19B2041EB2D262E7ECE2B410CBEE69CF09B20412E4F0DDE64CE2B4103A8DC98F49D204109A2DF5552CE2B41B8EEE490E69E204127538AE640CE2B414F48F09DFD9F2041250BB38A25CE2B41BE917C3CFDA1204132B82FFF14CE2B41B8AF8036CCA32041DACCF36B43D32B41DAA0EE1829A42041BF982833D5D62B4167882FA36BA42041FA2A6691EDD62B41B0CD6D676DA42041C93E754CB2D82B41C3FD693A8EA420410486307BB2D82B4103CB8C3D8EA42041A754C4CB83DA2B41AFC846499EA420418045493489DA2B41744F10799EA420410AC8F72C27DC2B414DEC2BCFACA42041C36906D229DC2B413A229AE6ACA42041CBD321480ADE2B410590C8C1C9A42041786C26AC14DE2B4147AB13FDC9A420418D73EC459EDF2B415E8E75C6D2A420413FF88D64A3DF2B41C3D39BFFD2A4204150D359483BE12B415ACE79CFE4A42041727497923EE12B41DC5FF6EBE4A42041EC46B876E2E22B414C55BC27F3A4204153FC9DEAE4E22B41624E3B3DF3A420416F76397C6CE32B41CAF1F9D9E0A4204136F60A7889E32B411174C0B7B2A2204123DB3AA3AAE32B41AFAD841FCBA020416801B06CA2E32B41A0A7C25FB59F20410E62A8E7C0E32B41159A1636B49E20410204D194D9E32B41347923E3309D20416933D133D1E32B41714E8E42A59C20418882F7C1D9E32B41CF8D03D27C9A2041C7A80A5C13E42B4162601F1B8698204140F68F5D1EE42B4196A02F367C96204135AB921B2EE42B4153B6484EA79520413BC6761E45E42B410A1F22DB5E94204116EEE3815CE42B410AC725AA689220413E5FA2D06DE42B41FCC5F9D51E902041C4F98E1B1EDF2B415919E607F68F2041318F5792CCD92B41B5A92E85B48F2041A83E4CC561D42B4138A54F01888F20414FF9CC6C2ED42B4108D0A1F6858F2041
29	29	12	086	001901	12086001901	19.01	Census Tract 19.01	G5020	S	1338946	0	25.8341122	-80.2113971	     4010	     1753	390	28	3544	6	2	0	4	36	1657163.38085938	5178.96406563528	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
30	30	12	086	001801	12086001801	18.01	Census Tract 18.01	G5020	S	1306930	0	25.8277967	-80.2328282	     3778	     1354	580	37	3125	8	0	0	5	23	1620342.921875	5397.04571321063	0106000020E61000000100000001030000000100000036000000450C11CA640E54C0868F1ADDE6D43940348FFC71640E54C02274041EBDD43940F359CBD6630E54C0F1E7DAFA8ED43940A23C2172630E54C0B30B63D075D43940C4031405630E54C0220492FD5FD43940AB8C1877620E54C0E5DAF27531D4394023A1BF74620E54C02E35C09E2ED4394022F7864C620E54C0931BDDF2FDD33940ECA0CF7A610E54C01D13EABECFD339408B59A0DF600E54C0739EA8C1A0D3394017B2A048600E54C043E065C471D33940791929E85F0E54C05A858D6A44D339400351A31A5F0E54C00FCF02270ED33940AFD684D2800E54C0233CD4160AD33940DEB8A8CDA10E54C022E8309105D33940462ADF20C30E54C034AB76F601D33940D4F87D9CD20E54C00815AB2000D3394042756C0FE40E54C072975F92FDD2394051EF9B17F90E54C02B21C4C6F9D239402E9BE3D3050F54C05B58E021F8D23940CF0E15A5260F54C0565873B9F4D23940310E78EA330F54C007ED90CEF3D239409EF28BB7370F54C03C1D3A33F4D2394042600449410F54C052B24140F1D23940E04ACC43480F54C0BC52B787F0D239400AD36856580F54C058FD7ED3EED2394066F29B75680F54C0D28C64F9EDD23940BE0F46DA680F54C0E20568F9EDD23940BE7F1958690F54C0977456C41CD33940059082E2690F54C009CC00CF29D33940A707740C6A0F54C0CF4FAF324DD33940DC9AC83E6A0F54C064F063F063D339403BE639B46A0F54C0074FDDEC7BD3394089246A4F6B0F54C0998B70D2A0D339405775FEF26B0F54C0F97E0C7ADBD33940DA4683C06C0F54C0F6B8DED517D439402B642D256D0F54C0F24E724254D43940D34BF2CC6D0F54C0082A9A3990D4394046F3F1636E0F54C0D2F70DA3C5D43940195FDC28540F54C09AA90196C8D4394018645D8A4D0F54C0ADD8AD63C8D43940A778C8CB3C0F54C0C8B3FF88CBD43940D70425372C0F54C02DBCDFA1CDD43940FAFC4D57190F54C06F949F0ED0D43940BABF6E980A0F54C074830AA5D4D439401690D2EEF90E54C0CF055C05D6D439400480DB27E90E54C0CF26002FD8D43940B017A4D4C70E54C034FFBABCDED43940A1C6CDD2B70E54C07183258EE1D43940D4D36E1BAF0E54C027940779E2D439402A6B6596A60E54C02855B046E2D43940A64F800C860E54C0868F1ADDE6D4394080E931E26B0E54C0760DAAFEE6D43940450C11CA640E54C0868F1ADDE6D43940	0106000020BC080000010000000103000000010000003600000032B82FFF14CE2B41B8AF8036CCA32041250BB38A25CE2B41BE917C3CFDA1204127538AE640CE2B414F48F09DFD9F204109A2DF5552CE2B41B8EEE490E69E20412E4F0DDE64CE2B4103A8DC98F49D2041EB2D262E7ECE2B410CBEE69CF09B20415053F5BB7ECE2B41C7E5431BD19B2041439ACC3988CE2B41F1BCC845B599204188795524ACCE2B4189D0FDF9B4972041AA50678EC7CE2B417ACA61E8AB9520414CED6F50E2CE2B41932BBDD5A2932041B7D05B69F4CE2B4105636BE2AB912041BD02B93218CF2B41108E022C528F2041D9882B7BCEC92B41335B33211D8F2041D0540766A2C42B41AC0E6F31E38E204144F6BB7068BF2B41255DD65FB38E2041647307D5FABC2B41EC5859629B8E2041E6605D523EBA2B41BC3296F17A8E2041F4371303F2B62B412E500BEC4B8E2041C6932CB7F2B42B41ECC154B5368E204122ABEA22CDAF2B41F0A4E93F098E2041067D4B49B8AD2B419EA43FFBFB8D2041DEEC1FA01FAD2B413AF14D75FF8D2041BEC738989FAB2B4103464285DC8D20411FB9765E87AA2B416A41EEE6D28D20417E82F21002A82B41781DAA44BC8D204143B0ECBB7AA52B410FA11714AF8D2041ADF7A8F16AA52B41F97DE8FCAE8D20410A62073654A52B4178CA85E7B58F20415F9851AA3DA52B417D5F54704690204186D401D234A52B41C5E6B8F1CE912041CC473B782BA52B4170312425CB922041E1BD288317A52B415417D418D59320418F85D2CEFCA42B4144715E386E952041AD27FE64DFA42B416C2480ADF8972041EB7F414BBBA42B416ED473FF959A2041BE22DBA2A7A42B41272A9423349D20410CCD817B89A42B412423BA21CD9F20412B5906616EA42B41E78E79721DA220410433DD718BA82B418F18553E44A22041255CCE3C95A92B41DEEDB79943A2204163DDBB6135AC2B412BFE1F636AA2204196FEA903CFAE2B41EFA2798285A220415F7439BAC4B12B416C017CCEA4A22041A77C2D8414B42B41E0DE9B22DBA2204148FAD97BB1B62B41AAB9B64BEEA22041E9F1290153B92B41F4361F360AA32041DCDC04B18CBE2B4168D1ACB85AA32041B9E7D63F0FC12B41EEFEBABD7DA3204120C5732D6DC22B4168EEFAF789A320412CEE8548C3C32B410661FECA89A32041AEEEAB84DDC82B41A9F9C659C4A320418D287721F8CC2B41C60B01FDCBA3204132B82FFF14CE2B41B8AF8036CCA32041
31	31	12	086	001502	12086001502	15.02	Census Tract 15.02	G5020	S	1691399	13777	25.8361902	-80.2342192	     3926	     1426	454	32	3388	4	10	0	3	35	2113666.24023438	6015.23766107324	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
32	32	12	086	001501	12086001501	15.01	Census Tract 15.01	G5020	S	668462	0	25.8355386	-80.221036	     3479	     1343	361	33	3044	1	4	1	4	31	825640.806640625	3636.74545244804	0106000020E6100000010000000103000000010000003B000000F4F226BE430E54C0CACA0D88EED43940450C11CA640E54C0868F1ADDE6D43940F1D24F3B650E54C0745797F716D539408C8C4DD2650E54C0084559563FD53940161CC632660E54C03ECA1EB567D539409DCCC4C9660E54C0E0A63A818ED53940275C3D2A670E54C069285B4DB5D53940FBE62FC0670E54C0EC502158DCD53940BC1AF3C4670E54C0E85A3C95DDD53940CE5E9EEB670E54C0D19D64D9EBD5394048C77229680E54C056A08AA802D63940FF808F2C680E54C0D5A234CE03D63940AE11ABCD680E54C0A8BA53DB2BD63940384E940C690E54C0757B925352D639406106B14F690E54C0951F87947DD63940902EA1106A0E54C0EAABC3D1A5D639404323A7926A0E54C0970B7D23D1D639406A2888625B0E54C042E7CB1AD3D6394048CE29364F0E54C07F25AD33D5D6394049CF68BD480E54C00D6538ECD5D639405C02B12F420E54C031FFE4E7D6D6394080C373AD260E54C09E9DA082DAD63940A1CBC3F9040E54C0ACDC97A3DED639409271ECB8E70D54C026DD65D3E2D63940CBC1D3B7E70D54C01C8A22CEE2D639409D732DDDE60D54C05A5E22B2DED639406FE74B83E60D54C0D5D386D3DBD63940DD89F828E60D54C0D6A441F1D8D63940DC0924FAE50D54C0C9B1E3C7AFD63940F381C945E50D54C04C4B9FCA80D639405BC489D4E40D54C01ADD16D363D639407EDE0B89E40D54C0351F988E50D639407D1BA9E9E30D54C022E5E18420D639407658464AE30D54C0ECD86201F1D53940CD0BF2EAE20D54C07C47A025D2D5394007762E87E20D54C0C9ED0621BED539400A6F3A46E20D54C0E9FE8DC4A9D53940F9F125EEE10D54C0043AD92797D539402C808C7CE10D54C08298ADA46CD5394032A1914AE10D54C0DF4B56955BD5394006581B53E00D54C0D82BDC0F1DD5394017655C2DE00D54C07644AFC20BD539400A98920FE00D54C074D13E9DFED439401C7A361FE00D54C0090AA59BFED439406308B594EA0D54C07CF2DA8CFDD4394010B2AFA9EA0D54C0AF34BD8AFDD4394097AECDD2F40D54C08A32AB27FCD43940489573F3F40D54C08E263823FCD43940D9B120C1FE0D54C047896F8EFBD43940A47E6103FF0D54C0BFEC838AFBD43940248895FB0A0E54C0756D6A32F9D4394081E5720C0B0E54C0E072AA30F9D43940B16E345C150E54C0E29A7F1EF8D43940BA09B17E150E54C08148EE1AF8D43940E9F8D715210E54C079C549E8F6D439405B050217210E54C03ACA07E8F6D4394021A7905E2C0E54C0E9EC6330F4D43940ECB2FCF92C0E54C0EF40F30AF4D43940F4F226BE430E54C0CACA0D88EED43940	0106000020BC080000010000000103000000010000003B000000DACCF36B43D32B41DAA0EE1829A4204132B82FFF14CE2B41B8AF8036CCA32041524FD31600CE2B41AF73F7ADE1A520415A5757C4E5CD2B4191850655A1A72041C62A08FFD3CD2B411170270961A920418F92CEC6B9CD2B415289FC3D0FAB2041B784E21BA8CD2B410A0FEF7FBDAC204189B8B3098ECD2B418115206C6EAE2041C9BCBE358DCD2B419AD762287CAE2041A4CD533686CD2B41D407915D1AAF2041AB6EFB057BCD2B419468BC4F17B02041694ED2757ACD2B41D7CF5E0824B020411014BB925ECD2B41875F9223E0B120414AC1E43052CD2B41A4CA10CB8AB32041398151D644CD2B4120DE44826AB520411EBB2CF223CD2B4128C6AAAB28B72041D3FDA0B80CCD2B419AAF000E09B9204124BCB8666ECF2B411AD16B7522B92041AB7E1D0857D12B413A65489B3CB92041FB53EFD35AD22B412B29472346B92041DD2511E561D32B41E429129952B9204161A7A027B2D72B417F9BC81D81B920414ECF0D0AFBDC2B41B75325F1B6B920415FC2BE4D91E12B412C17355EECB920410E851D7A91E12B419C6D1724ECB92041525D8B0AB4E12B419D3662C3BEB92041C630DC53C2E12B41DBCE78049FB92041007F45AFD0E12B41CD430A1D7FB9204184219CBFDAE12B416482D495B6B7204145E1A223FAE12B4168ED208AADB520418BC998D00DE22B416A3EC5566CB42041D1FE8AED1AE22B410E8BB1B096B3204116618B1937E22B41F2875EFE81B12041878DBC3C53E22B415537CD1C73AF20412F704B3A64E22B4198DA0CEA1CAE2041014A983275E22B410CA6F1F63EAD204155D4FBBA80E22B41C9E5CE2C5DAC2041359F65C68FE22B416892E8CE8EAB2041B0E4BA66A4E22B417A8E075CB7A920414FA21A5EADE22B412617AB2CFAA82041BADBE74FD8E22B41A21A4DE844A6204139A72960DFE22B413EE8240885A5204153FC9DEAE4E22B41624E3B3DF3A42041EC46B876E2E22B414C55BC27F3A42041727497923EE12B41DC5FF6EBE4A4204150D359483BE12B415ACE79CFE4A420413FF88D64A3DF2B41C3D39BFFD2A420418D73EC459EDF2B415E8E75C6D2A42041786C26AC14DE2B4147AB13FDC9A42041CBD321480ADE2B410590C8C1C9A42041C36906D229DC2B413A229AE6ACA420410AC8F72C27DC2B414DEC2BCFACA420418045493489DA2B41744F10799EA42041A754C4CB83DA2B41AFC846499EA420410486307BB2D82B4103CB8C3D8EA42041C93E754CB2D82B41C3FD693A8EA42041FA2A6691EDD62B41B0CD6D676DA42041BF982833D5D62B4167882FA36BA42041DACCF36B43D32B41DAA0EE1829A42041
34	34	12	086	001401	12086001401	14.01	Census Tract 14.01	G5020	S	1208551	0	25.8418621	-80.2015534	     4703	     1837	586	53	3906	11	8	2	3	134	1498701.52734375	5021.86889600217	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
35	35	12	086	008304	12086008304	83.04	Census Tract 83.04	G5020	S	3811253	30276	25.6332903	-80.3712258	     7577	     2561	1447	142	5825	16	24	0	23	100	4754387.36132813	10989.4495570772	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
36	36	12	086	007603	12086007603	76.03	Census Tract 76.03	G5020	S	1287108	1729	25.7106068	-80.2897922	     4223	     1937	1205	1048	1739	7	157	3	10	54	1594804.56054688	5390.95041630391	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	0106000020BC0800000100000001030000000100000044000000E3CF7803BF2D2B41222B3DCD27C41E41EC4A1DBDCF2D2B412B0A4FD1E9C01E41AEB9C5FD19332B4169D48E4F5BC11E418014919228332B4110DD74796ABD1E4195FF0EE13F332B41055DD4AB3CB91E41047D7D645A332B41E09399E32EB51E41E6AA09BE63332B419FD7D5E930B11E4132C16C4E76332B410E19997D34AD1E412C5BA02F8E332B411039EFAD26A91E41546A8385A5332B41E13452B3EEA41E41EF7FB80CB1332B41231CC66599A11E4128476D26C2332B412E8FFBF4DF9C1E414B1FF05ED4332B417F9454386F981E4151E01BE4EC332B41E109FCA281921E4196B953200E342B41B2BF2B4B358F1E41E403B8D81C342B419D9F34A70E8B1E41BB1267DE1C342B41200295710D8B1E41D5937DFA1F342B417186FC935E8A1E411AE0696326342B41B0603A29F6881E41223FCDDC28342B418AB86B036B881E41E1295B1E2F342B41D4A0DDCD3A871E41C7146F4D2F342B41E471ABDE31871E41D10467D838342B415A08A0B2DF841E4160B923E256342B41917EEA60897F1E41EF517FDF67342B41CF2879E5EC7B1E41D3AEFA1879342B417319F72EF9771E41B11AF3F391342B41CD9A201377731E4194F5465B0D322B41EA7CC7C33B731E4152550C77EA312B4140FD7F0637731E41C25124FE7A2F2B41CC27700EE9721E418F3FB9DF0A2D2B41DC5A34B996721E41757643306B2A2B412DB06A237B721E411BAFD8E07A292B416BF7F9D55F721E41D9784DB7E4282B411F5D592161721E41A8F5104B7F282B417FE9997E61721E4102DA0321B3272B4185E65B3562721E41D88E03F985242B41362BEC0D18721E411BE34755CE232B416EAFBA48F0711E4145B9629B61222B41F48A244EBF711E418BA539C7B7212B41829A49F49E711E4183732700FA1F2B41EFB1098F7E711E419350492AB11F2B41086A477CAF7B1E4109267CB5981F2B4146344D18A0801E41B43D09EA871F2B411F36F7ECEA851E41E62691ACF31E2B41042D25F2369A1E41F10C09E6DD1E2B41B0F6ED91339C1E411B4EC189DD1E2B41FBCD1F589D9F1E41A9BEAF86C31E2B41F7AE5537FBA21E41A84CE9F79F1E2B41FCE5241CD3A61E414D4CA014971E2B4183A83B013AA91E41154AF125861E2B4108C1A972DFAA1E41D38BD3617B1E2B411374D1D60EAF1E417F62BDEC551E2B41E550FDCAC0B31E41E9D1C1B4401E2B41FB68393FC7B81E41934CE5453F1E2B41F816808DE8B91E41BB6C951E261E2B41E6323349FCBC1E4167F1E1E71C1E2B4178EDD26FF0BD1E41656B35AC131E2B41BCA57DDCEBBE1E4106CAD117F41D2B41C3EBBDC7B0C31E413463B8C0D2202B41EDB0C09A08C41E414A3A61A8DC212B41E5EA6EFA39C41E412006945D54282B4196B10424DDC41E41E48EA38AA32D2B41EC29C94248C51E41DD5AB0DDB92D2B41376A9C5949C51E4190AE4B96CF2D2B41A28D72684AC51E410D358277CB2D2B41E156DDB326C51E41F7BF5E21BF2D2B41710A2DC8BBC41E41E3CF7803BF2D2B41222B3DCD27C41E41
43	43	12	086	002702	12086002702	27.02	Census Tract 27.02	G5020	S	1011154	0	25.7978926	-80.1915449	     2553	     1255	1721	447	292	1	37	0	7	48	1251953.2578125	6432.61237550623	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
51	51	12	086	000404	12086000404	4.04	Census Tract 4.04	G5020	S	2536510	105190	25.8891438	-80.2354768	     6102	     2170	1373	133	4483	11	13	0	8	81	3276251.09570313	7217.19238293267	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
38	38	12	086	005701	12086005701	57.01	Census Tract 57.01	G5020	S	1428932	67157	25.7732667	-80.2967531	     6076	     2321	5863	194	10	0	3	0	3	3	1852653.95703125	8278.51423817658	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
39	39	12	086	013400	12086013400	134	Census Tract 134	G5020	S	450700	169704	25.8812634	-80.3354696	     5069	     1653	4688	287	42	3	31	0	11	7	771352.939453125	3518.58480266578	0106000020E610000001000000010300000001000000330000005E7ED7173A1554C087125AD956E2394054FB0098391554C031686DE630E239408BD3BF11391554C08EF00A0F07E23940EF654AC9381554C0DAF720F4E6E139404D8C8035381554C035B59783B8E139400C589DCE371554C027BF373C96E1394099C7C8C9371554C08768F7D78FE13940F5F4C3C9371554C0538F58D08FE13940B85A2B6C371554C032ABD0C96AE139404606BBF6361554C0364A04F545E139405713FCD0361554C0C96FE5A239E13940B59B0AA7361554C03DD98ACA2CE13940CD838370361554C0F102EB351CE139405D7E6042361554C08A6D962F0EE139404922D220361554C089D458F603E139405A2F13FB351554C03E89C7F3F8E0394064E9C4B3351554C06F94BAAACBE03940C3C462AB351554C03D8420C9C4E0394055A50BE2341554C0C647F94785E039402DDB21AA511554C04301DA0885E03940CCF0BBD2511554C0B0BF7F0885E039401E687E3F661554C045DEA7E783E0394047E86C2E681554C045DEA7E783E03940312D6A99761554C076BBC32A84E0394036AA6C9C7E1554C0B7CA6B8F84E03940B0497C55981554C00092FADE85E039407696D9CAB51554C05D2AA97E84E03940A84AB433B61554C076688F2B9BE039401E7E9E72B61554C08702DFF8B9E0394094B188B1B61554C084D1F1A8D7E03940F9D73116B71554C08EA0608BF5E03940EF1D805DB71554C0D2B8C2B8FAE039407D39E365B71554C0FF746FD213E13940D8350794B71554C0BB502C1533E13940C37C820DB91554C09AC0242DADE139400B1D181AB91554C078C16A80B1E13940AF71079DBB1554C0301B822653E23940F02EA4ADBB1554C044CC885357E23940C9D0B811BB1554C05F3FAD5157E239407DAE3E21981554C0CBE09CE656E2394071B22F66841554C015495FD356E239409B289D597C1554C001BF43FF55E239403798CE0A761554C0B4F1205356E23940B4091E5C6B1554C099C8E66356E23940F2806DB9641554C01F18B07456E23940EDE311B25D1554C0A467798556E23940F8862DA2571554C0CEC53B9656E239407A9AD031511554C0531505A756E23940B944CD814F1554C0531505A756E23940C9D10806411554C0A23B94C856E239405E7ED7173A1554C087125AD956E23940	0106000020BC0800000100000001030000000100000033000000E73F6718F3BA2A41C076E71E57372141F77EF24709BB2A4185805A4AB2352141B08F59B120BB2A41C515504AE2332141B8D3C9DD2DBB2A4153FA513C7E322141D2B9F4A847BB2A41C898033E7B302141FC362ABA59BB2A4150B2F319FF2E2141510778D85ABB2A41749C8535B82E2141A3CDA7D95ABB2A4158A5FFE0B72E214151E6B19D6BBB2A412FE896431D2D2141D9A1E81B80BB2A4117CAB2D2842B2141149514B986BB2A41D13EB030FC2A214197354E068EBB2A4186A69CBE6D2A21419126A88297BB2A41F11617E0B5292141278E44899FBB2A413F1C54591A2921417CCAF55FA5BB2A41B33993F9A8282141B4C531EAABBB2A4171ED8BE12E282141104625A7B9BB2A4186AA37A1382621416007275BBBBB2A415A0A204FEC25214154B2DE82DEBB2A4124BBDB122C232141B273CF4E5BB72A4122E8567623232141785E2DF154B72A419865266A23232141B845CD3421B42A41F7CB20BD1223214168C68C9BD3B32A4104976858122321415F7534E590B12A41CD3C3952122321415327724D4FB02A412EAE110E152321410D39C2C746AC2A419C5A7A601E232141A07D2879A8A72A413CDDD926092321419A9A7DC496A72A411E75EE95042421413740052F8BA72A4157A087315A252141BFEB7CA97FA72A41916D4371A32621414D9328366EA72A41993AF7D7EE272141CDD12EBE62A72A418E81C936282821416537D00660A72A415C770C9F3E2921414D111B0C57A72A41D7F48F54992A214115CD860C15A72A410CB0694DE32F2141C7F19FD512A72A417AE9D04413302141D2513303A5A62A41636BBBC7133721415464CC2CA2A62A4141A81516423721413355B79EBAA62A41908FF82042372141F37FB3EE34AC2A4186D3E68E443721410BF7BAD34CAF2A41164BE7B947372141A3369BEC8FB02A41FBE2A22B40372141D3C518128DB12A41FD420016453721415181CDCD39B32A41A08E2FFC47372141AF94B11D44B42A41D40F1C104A3721416F80E7355EB52A41706BC0384C3721415C76168251B62A417D95E22E4E3721410D1421EE53B72A41E7922B3950372141B5E0F4A897B72A414C904991503721413D9E2EF2DCB92A4195485BFA54372141E73F6718F3BA2A41C076E71E57372141
40	40	12	086	000501	12086000501	5.01	Census Tract 5.01	G5020	S	5547926	399430	25.9201653	-80.2713713	     7578	     1970	2859	278	4313	9	48	1	9	61	7394636.84179688	13621.5126702042	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	0106000020BC08000001000000010300000001000000C800000099395647FA992B4190D2FE7559AE2141759E6944169A2B415DFDF2A84FAC21413F9A5B0D169A2B41724EB4CA3AAA21418D0A6ED6229A2B4199CD36713FA821412400198D229A2B41C797BCEE36A621418750E04F3B9A2B41BFF14DEF22A42141DE4FB963609A2B410EDBD89A0E9F2141D960DE8C799A2B410A05F547D19B214189D320C0AC9A2B4132B1D81B30952141DCFEFC31D59A2B41EC1FB785D6912141BC8DDC533F9A2B41C2041B06D29121419C294A4AF8992B41B9D14128D8912141B583192FB3992B418B665F92E591214120A2291D8F992B4110E0F718D691214163049D2ED7982B417DF6FB51BC912141E0A7C955FB962B41522B1FF4A5912141B61D4BE7A1922B4113B2B77A7A91214123EF76B07E912B41D653BBE6759121416262BEDBA5902B41DCD78307619121415F0DC7CB50902B41767DB3C01A91214115084F3B7C8E2B41A0482FFDFA90214124D577F8008D2B41806B8AE9ED902141C3CB7EDBC8892B41BBAD6438B990214178042232F2872B41205B4D43AF9021415986D8323C872B418EBEB30C9C902141A4756EEF7C862B41C19F66B093902141123955D439862B413FCB87079C90214132B5A5F5E8852B411ED8C6059D9021416DD5A7BBB57E2B4188896CD079902141195CEF6A0F7E2B410793936A77902141EFB6993D34782B418F1307372E90214192A8E462FF762B41877681EE15902141C8713BDECC742B4118757F7EEB8F2141C4DC479ACC732B4116A2AB3CD48F21415CAE6EFB85722B414790D4C3BE8F2141005D1A301A722B41EB139A85BA8F2141848296E715712B410C253F54B08F214145BB6EA9296F2B41063D05EE918F21419E82186E096D2B412DC505B17C8F21412290D37FA46B2B413B57D069738F2141A330BDF952692B416B59EBB85B8F2141B855ECC71B692B41F737C352568F2141DD32D422FF672B419C9A478B528F21417FA9045E29662B4121488E791E8F214189CA9F0538632B419B70C141128F2141BB940C7E7C612B418CF8BD84E88E214176E855CC61602B417DE05464E88E2141304272B87C5E2B41BC3232B0D58E2141266916B9635E2B419B19C774D88E21413DB8DE2D6F5D2B417A76EBE8D48E214151281B40085C2B417B0EBBFFCF8E21413955E5F27A5B2B416EC42FF1C78E2141618E6596305B2B41F9C720D85E8E21410D58FB75AE5A2B41ED7451D9568E214186344E7D655A2B4194283471568E21414D319E6856582B41428DA96D368E214110C9EC7F21572B41BCC9AB9F278E21416D527A12F7552B4116F9FB6B1F8E214184F70865CB542B41D503E4940B8E2141155FBE7B664D2B418CD60D07B48D21410222F910B4492B41291E00FF808D214153D72F374A492B41B77582DD818D2141A522283388482B41BCD35C558F8D2141FABD305665482B41874E94C6928D2141A823951313482B41841F6E96A18D2141A68D90C9AD472B411F74C5C0A98D2141783F288BF0442B41C581565B7F8D2141BFB367C29E432B41950016F6668D2141C1ABEE8AB3422B419E5A2BF34C8D2141412EE980E7402B41B3E1C9852F8D2141EB848654C7402B4154796713288D2141C7C749E4BA402B4164D79F8E1E8D21410F5B131DAD402B411D709864198D2141121C3C4E593F2B412781DE700A8D21413054F4D9D73E2B412D7A498DFF8C2141EF538BA0BF3E2B41EBA4AF3EED8C21419877C708593E2B4181F77239F38C2141FD8CC46BCA3D2B4148C5CB71EA8C214137B43280943D2B4163BE5D54EC8C2141DE79093ED33C2B41CB959DA2E78C2141FDC994E2A73C2B4127A3F094E18C2141607802921A3C2B413974C4B7DB8C2141727C2CFCE73B2B415EA7D0E5D48C214143EB492E653B2B41F0B9EE8BD08C21411816F3B02C3B2B4159764183C78C21412E799A58863A2B41AD3A693CCA8C214195D07FE9493A2B41D51CB12EC18C21411A89F010273A2B410D67D6B7C18C2141CC58F72FC3392B41B61B6372B88C21418C0419EE1A392B4177FE9941B08C2141A34E371AE5362B4196EF3516888C2141FACAF00EEC352B4172A38DA4718C21416E82CFE40D352B412430E128698C21411ECE42BBA7332B4182F613F14F8C21411315C15780332B4189819C8C458C2141A942D60B66332B412C69B967458C2141D9A06A7FFF322B4140577864438C2141B5B862768D312B4192B89E61318C2141DDDAC5003C312B4134468108268C2141C25D80B9252D2B4105E1C673E58B2141DA65495F592C2B41361BC670D18B21418D83C8200D2C2B41330D5B1ECE8B21414011D298EF2B2B411D88AF81C48B2141D3F2CE6E712B2B412561E2EAB88B21417D37FDBFE42A2B410241146DB78B2141D49DE2A94D2A2B41B100FDCBA08B2141E7CB28191D2A2B415B836644918B21411442645F92292B41A2D9EEB1928B21415C45AE4BC7282B411A1CEBF5858B2141B2EC171760282B41D8566EF2838B21416D0DBC5925272B41312FAD6F648B21413153A2070F272B41E0A1C07F5E8B2141187F20E1D3262B41B2455B455B8B21410B425D7A82262B414E933C05458B2141AB0261A644262B41AD5B47804A8B214135E6BF3532262B412B488137508B2141413E4012F5252B41ACD8DDE24F8B2141558A31EEBF252B41EEC1253E3B8B21414A8131D697252B41B5DB6492398B214127E9ABF144252B4193EF1207448B214168226DDED3242B4195C4586A438B21415F268BBAE0232B41B4B4E7322F8B2141527C305787232B418D5E51142B8B214151F983C554232B4196D7275B218B214125B514EDA7222B418EFC693E168B21419D14128282222B415A262EDD0B8B214144A14F3A68222B41850A7BD0088B2141B1F5DB4930222B415946A96A138B214123F707F717222B4151E62649138B21414511BB77CA212B4167B4B053048B2141EBEF61309D212B4143E3F5D0F48A21412A49F2308A212B416E63C45AE88A21418219F698C3202B41E8FD8975F18A2141825B1C6F88202B4197D79369F08A2141708CE76647202B410B23899CE68A21413326E20E01202B41AF8C4C3BE68A214170B37F58D81F2B41E1FEBF49DD8A214128B20EE87E1F2B419E3A1A9FE28A2141033C2308BD1E2B41054D95CADD8A2141DA3AE8EA991E2B4116809AEADC8A21412F7E7D7A951E2B41404D9120338B214111E20E65951E2B41A0C81DBE348B21412592451E151E2B41414C227816952141794EF8CF131E2B4168F18E38309521418D5B8AC1FF1D2B41ABD83437CE9621418A0EC720FC1D2B41F1B9347E3C97214155F08221031E2B41392576406A9721415B94CAAA061E2B41A7EDC55A819721413DF31429DC1D2B41DF2304D3F3992141D5B4CB39C91D2B4116E4D320419C2141881213F2A81D2B41BFC13C542A9E2141A7EFB27F971D2B411AA626CC10A1214122F87578971D2B41F6420AFD11A12141BE885E96931D2B41EC1790A306A22141C2B0C2D5451D2B41BB71BD6BF0A621415A14AF0A421D2B4176F2C0C92DA721412E416E460F1D2B4187C41E61F6AA21417D1BDAAE101D2B4117D710DEF9AA21416D6DD672311D2B41C839830C4BAB21417B4D1DCB351D2B4108D5A30A74AB214177ED5E422C1D2B415BCC4FCD1BAC21410FBC53E22B1D2B418E32FA6722AC21413B299402481D2B414D8A116523AC214196A3A5DD042A2B417F81F3EE95AC2141DEE36CF9552D2B419B8019C2B3AC21417C95D1FEE1322B41238EEA88DDAC214134094F04E3322B41628F5B90DDAC2141105E122D513C2B419AB82CA722AD214164D4E043623D2B41E6ECF48226AD214168B80F0235422B41602C6305D5AC214108FC3B24E4432B412B9689EDBCAC2141E6451BE29A452B41B9BFC5FAAEAC2141038DE3236F472B410EBDD776AFAC2141610ACD7E7A472B417658CE79AFAC2141F152211DDE4B2B41997C420ADAAC2141B38BDD093E512B41E6ABE77D27AD2141A7DC44D2CD552B41A4609F6A5AAD214121A5EA44185C2B41F8A357C1A0AD2141BA0AFB0A1C5C2B41820179ECA0AD21414D0F0EFD1B632B41E61BC1F0F0AD2141044D76401C632B41421DB0F3F0AD21416D750CAF24652B4183BC33D30BAE2141F7558C563B682B41B0FB894028AE2141F592B280746A2B41DC66DBE53CAE2141631A89E4B2702B41D5E9E25577AE2141FCA5CC0B79732B41177E9BE780AE2141AC94F3CB3D772B4171FF78B583AE214145A99C7B187D2B4119FCE26EDCAE2141D131A5EBCF7D2B41955EF14AE7AE2141ABBE3AC8E67F2B41CC4295E10AAF2141282F376925802B41C4F07E800FAF21415789D86574822B4176F1964548AF2141A349F8DC31852B419542681E80AF21413FEAA45937852B411F21508E80AF21412DADFA9FDB8E2B4179383673FEAF214131E1CD43E78E2B416D11A23FFFAF2141BC757F93F38F2B41F74FD2A511B0214137FF86F8E6992B410B7BA5168DB02141B3C1DF2EF1992B415B0D9FE89CAF214199395647FA992B4190D2FE7559AE2141
42	42	12	086	980800	12086980800	9808	Census Tract 9808	G5020	S	6406694	49576	25.9043912	-80.274653	        3	        1	3	0	0	0	0	0	0	0	8014557.43164063	11964.6486630165	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
48	48	12	086	000409	12086000409	4.09	Census Tract 4.09	G5020	S	1095262	0	25.8804241	-80.2163769	     4677	     1318	1253	74	3176	1	43	1	15	114	1355988.13867188	5728.14070904123	0106000020E610000001000000010300000001000000390000002A5EB4725F0D54C015A504AA42E23940BEA7DE8B5F0D54C05E4868B4DFE139407510FA65600D54C07EAC0C37A3E1394021D738D7600D54C0CA30146E83E13940CC9D7748610D54C0D3D905F963E13940FBAC5024610D54C0342ADD124FE13940B9FA1124610D54C08459A5EE4EE13940C893E603610D54C01883D0A13BE13940ABA215C7600D54C00F9DD92317E1394089580F5C600D54C0BDB413C2D4E039406DADF69A5F0D54C083AA629865E03940295FBE965F0D54C051FCFD2A63E039400B5625E6650D54C0957A05A662E0394042CBFCEA650D54C0E9CEA0A562E0394054FB1AC06C0D54C0AA6EB63062E03940AA3AEAB6740D54C061C3E30562E03940552B30E0950D54C0285CB3305CE0394087091201B70D54C07642510357E03940C13A8343D80D54C0A25525C551E039407C8EE681F90D54C01600D9764BE039407759FC82F90D54C0BFDFE0E54BE03940E32145F8F90D54C0F15A7BB77AE0394004ADD3FBF90D54C0340BF6A87CE03940097BEB4DFA0D54C030547E7BA9E039403E79B954FA0D54C09D2A0A13ABE03940A4F1E7B6FA0D54C0B6568406C2E03940A58A44B7FA0D54C0A57DFB1BC2E0394076AD4CD1FA0D54C025C4D886DBE03940C1EFBE46FB0D54C0EF0C71B60AE13940A7EB2E53FC0D54C032C660183AE139401F4DCE4D040E54C0BD990D2138E139405224B8A7140E54C00965BA2936E139404BEB4ACC1C0E54C058A0DE1034E139408B8720803D0E54C0289E5CA02EE13940A109747F5E0E54C07ED92F6229E13940F2225E8B7F0E54C067E5FC5125E1394079D35C22800E54C02BEC5C9254E139404B036B8F800E54C0B425DA7E83E139408E87E971810E54C018B98F88B3E13940014C2D65820E54C0B739D7EEE1E13940B34033E7820E54C0B97CF80413E239405583778E6A0E54C067B29B5C16E23940FA2126AD610E54C05F24609B17E239401CEDD898400E54C0F3C9FC4E1DE239406042E1B61F0E54C07B8E47D022E23940A793A7FAFE0D54C06445B1FD27E23940AE643136DD0D54C03C26DD3B2DE23940F8947143BC0D54C015D85DAC32E23940CA05DD699B0D54C0403534B837E239409827FB487A0D54C05D4C11C43CE23940AAB796E6770D54C0DC49BC2D3CE23940E8BAF3F9710D54C0EEF096BA3CE239402119EC3E6D0D54C03F384BC73FE2394030B5A1326D0D54C081DC39CF3FE239409FC39547670D54C023C7252841E239404EA6EBE2660D54C07C28E83841E239402A5EB4725F0D54C015A504AA42E23940	0106000020BC08000001000000010300000001000000390000004CF5824A2EF62B410268E8E737382141E98936F630F62B41BE90BD32EE33214100F065CF12F62B415B2F58064F312141DDEA0A2E03F62B419C898E59EE2F2141940E0887F3F52B416A55944F912E2141D40AAE97FAF52B4109BDF986A92D2141313AEEA3FAF52B41D8874BF5A72D21419DA75FF900F62B41A0DB18E8D12C21410C6ECBF20CF62B418018542F3D2B2141679A5F2A22F62B4184F8EBF55C2821417BD0FFDE47F62B4160CFA9188C232141872DEAB148F62B414540082D71232141761C6A734BF52B41818877E369232141FD301BB14AF52B41AA3AEFDD692321419AAB6A7A38F42B41A6CC56266323214123BD11D3F8F22B41904FDD5E5F232141FA221F2EC6ED2B412F00BAAC1623214160FF6BCE94E82B41359A3647D522214199C4722C5EE32B41C2FDB024932221411C31D13E28DE2B410CDAF03D4522214123C7ED0B28DE2B41FFCF420D4A222141D235C19012DE2B413D066544512421419A9922E111DE2B41E2F8B3D166242141E529410C02DE2B41F36256EC57262141BDC436E000DE2B41AFC94F9369262141CEB962F7EFDD2B41A7960C1068272141C02573E7EFDD2B41090110FE6827214151FBDA24EADD2B419D228BE782282141EA6F139DD4DD2B4111C040318E2A2141C70DAB65A7DD2B41F7304B859B2C21415834044667DC2B41FB6854CE832C2141BA0AE61CD7D92B41212C4E186A2C2141A573966B90D82B41D0374FE4502C21411AF71C3270D32B4110C558C50C2C21411C43F21E44CE2B41365EE8C7CA2B214199D16DFE15C92B41FAF849E2952B21410ACC4E3BFBC82B41343058DEA12D2141F2100811E7C82B41F78FD941AA2F2141FAA7936AC0C82B41D06952E5BE312141BD6A853E97C82B4184A26D58C13321418B51A8A67FC82B410FA220B4E1352141127CFF9A50CC2B41EA625B8A0C362141B307BFEFB4CD2B41FBD400751C362141BA6CAE3AE4D22B418750C68D63362141DB8254A40BD82B41D73AA171A83621416EF453282DDD2B4163813CAFE936214188C6351878E22B414FBD29EB2B3721410CE96923A2E72B419011772870372141E9BEC442C8EC2B41FE694C08B03721414F958B8FF9F12B4185A2CDFEEF372141C8EE254C59F22B41CE7CA70EEA37214109A1240A47F32B414C325797F1372141680BA1B304F42B417732B98F143821411C3664A006F42B4132F9ADEA14382141B875E710F4F42B416DE8DA4A2538214130F107D803F52B415B92171D263821414CF5824A2EF62B410268E8E737382141
44	44	12	086	002300	12086002300	23	Census Tract 23	G5020	S	1725281	0	25.8167865	-80.21515	     4963	     1851	1100	63	3725	12	6	0	8	49	2135015.44921875	6369.32228727135	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
45	45	12	086	002201	12086002201	22.01	Census Tract 22.01	G5020	S	985996	0	25.8190841	-80.1923893	     3573	     1377	1392	805	1257	2	40	1	20	56	1220249.02148438	4920.70131482651	0106000020E610000001000000010300000001000000490000004D40B898360C54C08C24C5F9B6CF39405C1226943D0C54C0917338D2B6CF394090B589223E0C54C091A76EE5B6CF394067E0E0C8450C54C05CF297EDB7CF3940B1A04AC74C0C54C056DC11DFB8CF3940F71742EE4C0C54C0C80752E4B8CF3940911673CB5D0C54C0EDF7CDA4BBCF394037292CE05D0C54C0578BCCA6BBCF3940176413F4730C54C0434414CBBDCF39404D9347E0740C54C02FBBF7E1BDCF39400B28CBED800C54C0A1809836BFCF39408205D9F1800C54C0131F0B37BFCF3940CF0F8054810C54C0AFA71373D1CF3940BC068154810C54C0B721FFB4D9CF3940186EC7B4810C54C05FACCFC208D039405B23A3B8810C54C01DB083A50AD03940E84FF74B820C54C07BF06C6C37D03940800D37BD820C54C088AC1A006BD03940ABC11126830C54C09F45F0C297D039401EA6AE1D830C54C08796E9B7A9D03940D7051911830C54C023457453C4D039400DECFC64830C54C011A89AD0E5D03940D09AB49F830C54C0A6984509F4D03940F294DD4F840C54C03E428B6F22D139409FAEABE2840C54C0A67A4D0B58D13940E90D62B4850C54C0BA57821C8ED13940BA3D7021860C54C0CDEBD08FB9D13940622535C9860C54C02EB7621BEBD13940BDFC90E6860C54C0FE92769F16D239408B8AC2EA860C54C08352EB2323D23940D579A53E870C54C010C00FA144D23940415E4236870C54C00A2FF45F53D239409FA9B3AB870C54C0562FD25B6FD23940AD474E3A880C54C003ABCB318CD2394048917853880C54C01323C2F89CD239401694C21B890C54C0D7005B60CCD239402EB0C41D890C54C0CA19C5DDCDD239406ED50E52890C54C0D4B6FCADF4D2394095D22BA8890C54C09A3E20D608D3394013B8B6A8890C54C0062C7CF708D339409B3123FE890C54C06D8FCD541DD33940D49D44358A0C54C0593314F431D33940F092EB468A0C54C0E356EF7C38D3394079DE086B8A0C54C0D580BFDA45D339405F56176B8A0C54C01A073EE045D339409AD42950820C54C08F8FA57246D33940B2AFFCBE760C54C0EC9BA43748D33940546AC2076D0C54C087472F8749D339400FB8053F680C54C005C76A7649D339403E43AC4D5A0C54C00515F82E4AD33940D649F79B470C54C0A6565E004DD33940F1E6E276260C54C07735E5AB50D33940D8782D99210C54C0B9703A7551D33940FD29C9EA140C54C0C6F254E652D33940F1274030050C54C0A999FEE153D3394059C28717020C54C085A136D153D33940666022A6020C54C0B369B45142D33940FB3EE84D030C54C09AE4EB6C34D339406E56BB62040C54C03B0D2E9523D33940B99D9CE4050C54C08926AEB90FD3394061B897A9070C54C09E764E21FCD23940A8FB3651090C54C02F7F40C8E5D23940B8AF3A760E0C54C0DE6AAB1C8DD239408A3A86281D0C54C0870681E18FD1394092A06938230C54C0CF5C463827D13940F630AF5C2D0C54C0FF553CBB76D039401C5DE1F72D0C54C09ABF54586AD03940ED6C96602F0C54C01F0B50C037D039408B050EC12F0C54C09F9010B52ED03940BBF06021310C54C07D222D1515D03940E1A29930360C54C06DF687A7B9CF394082737756360C54C093423CFBB6CF39404D40B898360C54C08C24C5F9B6CF3940	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
47	47	12	086	000220	12086000220	2.20	Census Tract 2.20	G5020	S	1311245	0	25.897141	-80.1760935	     4713	     1667	1112	401	3007	13	75	2	13	90	1626905.25195313	7094.52939768267	0106000020E6100000010000000103000000010000003D000000592EA4BB700A54C0BB74F0407DE639406EEADE2E800A54C0569B05DD3EE63940BB19A9A6A90A54C04A651DBF97E539400B0B8C8ABD0A54C0D6F2C98747E53940DF36581DBE0A54C019895D4D45E539402EFBC4CCC30A54C00B6ECB0D2DE53940E6066117CA0A54C036D645E80EE53940DC0F12FECA0A54C0A83AFAFD09E539403B8EB990CC0A54C05B3E7D9A01E53940355BFA48CF0A54C0A41B4C12F2E43940DBE90A66D10A54C02E3649D5E4E43940C5C46B11D60A54C026A89164C4E4394090272771DB0A54C05FF54AC397E43940330434F9EB0A54C0C2DC0E9108E439402B08EDA8EF0A54C08D70E99C0DE4394014EE7C49E80A54C04C54091E4DE4394007C0B538E80A54C0BC5711978AE439409B0E4F5EE90A54C0250913D5C9E4394033CC8ECFE90A54C0C56AAE1305E5394065AA70F00A0B54C06A818610FEE439401B7A30E32B0B54C081CB214CF8E4394050D75651410B54C06327F13BF4E439401A34641D4C0B54C037E67D2FF3E4394045E47E2D6D0B54C054B9E012EEE43940A70AAA138E0B54C0BE0423B3E8E43940CC7E8F41AF0B54C0199CDFFEE2E439400656BE47AF0B54C01B5AD4FDE2E4394025FB7D79BF0B54C0B2A8E13EE0E43940F7BD6E55D00B54C03221E94BDDE439409F5F6737F10B54C01DA92AECD7E4394092360F33F20B54C0B965FFB013E539405638568FF20B54C008E29BEF4EE53940BB5EFFF3F20B54C0BB2A406779E53940410FFE8AF30B54C0991CDAC29AE539408FDD5AA8F30B54C0D34B4187A0E53940E7FA040DF40B54C0AC14752DC8E539402369912EF40B54C02437D421DEE53940C2E4C432F40B54C074F65992E3E53940ABFC4B69F40B54C0505A478904E6394097D3F364F50B54C02B1F851F43E63940C9585809D40B54C014E50E6247E63940B9749F98B30B54C0216B923B4CE6394043821213920B54C0FAB0473252E63940B865EE01780B54C0CAAC27A756E63940FA2B8BA6710B54C019749A1C57E639407A7F4C68500B54C05BE4DF9D5CE63940C7FED9BC2F0B54C0B803486262E6394065F93FB92B0B54C02A8A0A0A63E63940BE4D5769100B54C086ADAB8F67E6394059223FF80E0B54C062AAC7D267E639407D584400F50A54C05A894A436DE639403BFACCB5ED0A54C0F213B9216DE63940CE78E60BDF0A54C07A8799D16FE6394049EFB6BECD0A54C01C28CDB372E63940BB481F6BCB0A54C07DD33F2973E6394065E1A820C40A54C07B1EE9F672E63940F7716008BE0A54C003A63D5774E63940EAE9110FAD0A54C05B80DD4578E63940B6E27269810A54C04A4479277FE639407CEBA6E0750A54C03D40AE4480E63940592EA4BB700A54C0BB74F0407DE63940	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
49	49	12	086	000408	12086000408	4.08	Census Tract 4.08	G5020	S	2095316	27724	25.8654679	-80.2209797	     5553	     1959	1489	193	3784	7	5	5	15	55	2631224.70117188	7577.36382219146	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
50	50	12	086	000405	12086000405	4.05	Census Tract 4.05	G5020	S	1609609	7573	25.8948172	-80.2181953	     4385	     1226	893	141	3210	12	32	0	19	78	2018367.87109375	6117.85057773741	0106000020E6100000010000000103000000010000003000000006236ED0C70D54C0A210124D0EE639405A5C2F5FC70D54C0B84F09B7EAE539400089939AA60D54C0A587737BF0E53940BD9D709F850D54C00C906533F5E5394015C151C27C0D54C0A9000FC6F6E53940EDF127E1720D54C013897B00F9E53940F2A319216C0D54C0F3A60922F9E539401DB07BE2690D54C07DB86ACE2FE5394082A3EE29690D54C09B08438C0CE539403465BE8E680D54C0BA4AECE0CEE439406335B021680D54C028A8D4F3A3E43940A6B4BFF7670D54C08D95842894E43940C1487C6D660D54C00F2CDAEB12E43940492C28F76B0D54C0EDC2FD6911E43940A48D79D8740D54C0FCD2AAEA1AE439402D6735F47F0D54C07EAD3FB018E439404BE988F3A00D54C0479BB93F13E43940C16B42FBC10D54C0C8B98E980EE43940045765F6E20D54C0D3DAEAE408E439400D408D73040E54C07D7EF62C04E43940C0C0FF1E250E54C0BADE3864FFE339402FF02905460E54C0ABDD0C26FAE339405ED24D00670E54C07944FDFCF3E339408EC54E84760E54C02C38E2F4F1E3394039FB21EC7D0E54C09063CB1AF1E339409A8FA9EA870E54C0969BCAECEFE33940646C2836880E54C07A90ABAD0DE439402140A881880E54C032C3672B2BE43940073C188E890E54C07CE01F4467E43940D81897D9890E54C04C9EF743A1E4394022CBDCCC8A0E54C0193A572ADDE439406FB67D468B0E54C016DD0DDA19E539405891671C8C0E54C05118148E55E539403DCA74898C0E54C0A2737EAF8FE539402D80964E8D0E54C0B0CE0014CAE539408E57F26B8D0E54C0BF9C8FADD5E53940BED2714E8E0E54C0315A2B662BE639404803D6E96C0E54C082B8B4D031E6394050B43DDA6C0E54C0457460D331E63940D1F496874C0E54C05F2FBC5C37E63940F22F336D4C0E54C0DC83496037E639404F8410C4140E54C0874ADADA3EE63940E444253C0A0E54C0F43B51D440E63940A18601A0F30D54C0C5CDF2C244E63940ABA84F88E90D54C0B136297746E63940F3DCD16FC80D54C09F5E21984AE63940949160FAC70D54C0DA6F4CE21AE6394006236ED0C70D54C0A210124D0EE63940	0106000020BC08000001000000010300000001000000300000005907F10591E52B41AB95D86938622141FCCF1223A5E52B4137BF05CAAD6021414B6136C3C7EA2B4176E948A3F560214126FC1901F3EF2B4141E3E8EC31612141CAB1FB9B56F12B41486A158345612141E2C95DEFE2F22B419A27569D60612141F3AF77D1F1F32B41BC7A3DB363612141C727115A59F42B41A3AB2212AB58214145ADB7A378F42B41E10F1F2624572141322DEF1695F42B418F8C143E78542141D8A7120EA9F42B4146C962329C522141601175AFB0F42B41F833FB0AED51214172E1C521F7F42B414BCF17E2534C2141468DA3FB18F42B41A4C13ED3414C2141EF2154F5B3F22B412E83CD15A94C2141EEB1EE4AF6F02B418E36E7AF8D4C2141F82C675CCAEB2B414D576765494C2141A273140F9DE62B41EB3D99D70D4C2141A5D96ECC71E12B41C54C10B0C64B2141899EA61632DC2B41719770568A4B21419D74FA4113D72B419C99F4794D4B214164EF2B40EBD12B4168F30C7E0B4B214120749503C0CC2B41ABC8E854BF4A21416C7A847351CA2B418357CF1EA54A21419481D24B28C92B41A01400EB994A2141DC65FD4497C72B415257F6778A4A2141FFA2607D89C72B41B96A656ED44B2141693104BA7BC72B414BA70F7C1B4D214183F88CB74DC72B417989B1D7B54F21419B308A173EC72B414047CB1D39522141F3CB800A14C72B41659FF850D1542141FA413802FDC62B41FB493D5A725721415E47E292D7C62B41CD3CEA65085A2141DA1F31AEC2C62B41AB428F188D5C21419C8569F69FC62B41E1DC9F9E145F21414545349A9AC62B4178F1C642955F2141C352F87E71C62B414FBE73E44B632141AFB13427ADCB2B41948827F79A632141E414DD98AFCB2B4101D279189B632141DAA2655DC0D02B41695BB32DE06321414FEC3180C4D02B412E075F5BE0632141BE172CB27DD92B41D443349140642141FD522E2D24DB2B41FAF390FB586421419B3B1943AFDE2B41285505018A642141A25EF42A44E02B41D01B05529F6421416D19590974E52B419B38890DD56421411027D59C89E52B4114D486F2C36221415907F10591E52B41AB95D86938622141
52	52	12	086	010011	12086010011	100.11	Census Tract 100.11	G5020	S	1936925	42998	25.9470641	-80.2483084	     6504	     2238	1106	92	5197	7	4	0	10	88	2456696.171875	8406.04692263904	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
53	53	12	086	001605	12086001605	16.05	Census Tract 16.05	G5020	S	475463	9091	25.8276064	-80.2825156	     4049	     1714	3809	136	79	1	18	0	0	6	600567.744140625	3600.57251546741	0106000020E6100000010000000103000000010000003A00000040A767FF891254C08B1EF55866D4394017426308861254C07AA5F15866D439403A423A4C811254C0257044B967D43940775ED58E681254C0523D26D269D439400738AAA8471254C09890FE466ED43940B7B35B2B271254C07643F7D071D439406979EBE8051254C02BDBEF5A75D43940C147C684E51154C06FB0243D78D43940711CAE13E41154C04E15F6A13ED439400FF2C2D4E31154C0F233E75602D439406996E8D4E21154C03AB8A71CC6D33940BB43BFBBE21154C0276725E68CD339402D65F913E21154C00553C56850D33940C4CA3A57E11154C08821F20C14D33940695E43ABE01154C02AF78DEBD9D23940C407D8B7E01154C06CB39A119FD239401D48910DF11154C0E6E98D7F99D239407C360C1EF31154C0D4DCF5AA8FD23940788AC871F41154C04067566089D239403C21AB5CF51154C038E417578FD23940FD4378EFF51154C0ED870DB391D2394057AAC107FC1154C09A1003A8A3D239402B99F039FD1154C0D488BEABA6D2394015175B80031254C025E0F2BDB9D23940D3E5E294061254C03028A4D5C3D239403F0794C2091254C05DD93541CED23940812D66E30E1254C0E65432ACDCD23940B0C52922101254C0D5E37FD1DFD239401BA98792161254C072471B87F4D239400D503888231254C04FDF18A71BD33940E991F6DB241254C023700DF620D3394093FFF7972A1254C014AB226931D33940A803FF602D1254C0ACE99CCC39D33940F0D1D253311254C0AAC214BA45D339402ACFD59A331254C015B493864DD339404E129EFE391254C05CFC149D5FD339402F79D7FC451254C0EAFBBF5C85D33940F6C96BA0461254C0F1539EDE86D3394061ADC9104D1254C046F1AEDB9AD33940E41B21BB581254C0BCEC9C00BDD33940CCA37B6F591254C056C62950BED339409ED389DC591254C014B93F58C0D33940CFF1892F601254C0EB3D4AECD4D3394059B9A7B9621254C00BDB3D97DCD33940C27BF6C86C1254C0E501A91DF8D339401C8AB888751254C0631874E310D4394053181584781254C041CDCFC81AD439400CD07DA5791254C0D3823B9A1DD4394055995961801254C0A13DF7CD30D439409D2FFFFF851254C03A24ED9441D4394054CB50F7871254C0C568FD5448D43940543B2475881254C04FD2D86D4AD43940DBB3F4B78A1254C0B90EEC2D51D439403AFF652D8B1254C089531AA754D4394073E107A78B1254C0F023840F58D43940715025C88E1254C0F97C35646FD439408E18CEB78B1254C0B276B96966D4394040A767FF891254C08B1EF55866D43940	0106000020BC080000010000000103000000010000003A000000628661E3A9272B41240B7F034A9D204196D1F51749282B41A8728BDF4A9D2041A872692307292B4137F1992A5B9D20417C48A067E82C2B4153BBF4CD779D2041EB49202711322B4124EBEA66B09D2041FED5F28129372B41EE5EE1C0DE9D2041B16018C8603C2B41FCD11F4B0D9E2041D4605D3A75412B412F24E564349E2041E90D079FB2412B4180404FBDB59B204170057527C0412B41FCD76B04199920417A680CF2EB412B41025875307D9620412115805EF3412B415972F19902942041840F7E5C11422B419B3910CA639120410E54A4A232422B410B35F672C68E2041A875792451422B416FED79CF418C20419A50ECBE52422B4153464404B58920412AA13F24C33F2B41B16005A3738920410E4A4CD7703F2B4107C8B524068920411EAB92EE3B3F2B412DEDF510C08820411E8BE1B9163F2B414D223C040289204138AD478EFF3E2B41B9D3250F1C89204133FD9AB8093E2B41DB2A4DE6E1892041ABDEBB82D93D2B41B7C03113038A20410FB5C15FDC3C2B41FBF7643CD58A2041D5722213603C2B4132F3E681448B20410BA923CFDF3B2B4189344D64B78B2041FD2D6A02113B2B41C9A22631568C20412F6F7DD1DE3A2B41DF9EC2CF788C2041EC3D8801DB392B41C6515D1C5D8D2041C88AA43CD0372B41B5100E400C8F2041DCFA06A09A372B4155CA56D7468F20418E927D5DB3362B41C634D90BFC8F20411BA20D0443362B41E03DE77B589020412A89CBBDA3352B410D6A36ECDB902041F17C68D247352B41858710EE31912041390F292646342B415FB8952AF9912041457C174B62322B410ACE6C42999320411680598B48322B417602D1D6A9932041FE5769C944312B410FAD1C26869420412E9202506E2F2B41F1463A56FE9520414341D1F1512F2B41D758E3B80C962041148B77B7402F2B4124FAF429239620411A71A188412E2B414266DC0A06972041C677A119DB2D2B41B2B1888A5A972041AE47B480452C2B41C34C97A989982041FA8D77B4E42A2B415A9F488A9A992041B4D068606C2A2B411AA697A8079A2041A00B33D03E2A2B419687C4AB269A2041FF6DAC452F292B4188700833FA9A20418C2D059D4C282B413601BF12B39B204128315043FD272B41E2B15285FD9B20419BBBC266E9272B411E0AE0AC149C20413D19AC358E272B41349C3A0F5F9C2041D8EBA5947B272B41E951997C859C20414392654C68272B414787132FAB9C20413361FA3EE9262B41C2B8CB4AAD9D20412132BBCE64272B413578F55D4A9D2041628661E3A9272B41240B7F034A9D2041
64	64	12	086	001803	12086001803	18.03	Census Tract 18.03	G5020	S	1067524	9904	25.8188344	-80.2356791	     3546	     1589	698	51	2770	4	1	0	1	21	1332170.56054688	4767.09174549469	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
54	54	12	086	001701	12086001701	17.01	Census Tract 17.01	G5020	S	2859796	0	25.8224232	-80.2519056	     4247	     1504	1639	67	2515	3	1	0	0	22	3544583.18164063	9004.4649479277	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
55	55	12	086	001006	12086001006	10.06	Census Tract 10.06	G5020	S	1278640	27052	25.8526156	-80.2022834	     4693	     1598	1377	168	3030	8	21	0	16	73	1619270.859375	5127.16693871255	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	0106000020BC080000010000000103000000010000004A000000CD34B1EDAF142C41D61E7045EFED20419DAD0EC6C9142C418757C6E449EB2041B3E6FB3EE2142C4128A591F5ADE820414C4511C0FA142C414B8AE6EF0CE62041FE17D6BB14152C41AFDD520651E32041FED6139E1B152C41937C13B947E22041034BECD025152C415AFEA2143AE1204113F3829327152C41013E0165F1E02041B4D0625229152C41DDA6A5E3AAE02041C08853F030152C413765D73B95DF20414CBED49136152C41A3FCBA56EDDE204199D3E19446152C419E065A9685DD20414D3775095E152C4115C0541F90DB2041315B2DE06A152C410655557315DA20413D1FC80084152C41697D5B3F7AD72041A63A614D9B152C415CE4E4735BD42041C0E36D26AE152C41DFE1EFAF66D22041675D31D1B6152C415EA0A81011D12041E545B6CE23132C41413A16C6FDD02041C959478F45122C4107BFE79AEED02041788ADFEAC7112C419A51CE90EED020418215800260112C41F732024CEAD02041537BBDADB5102C41565B6271E3D020417A0B2C26A00F2C4144E4E64CD8D020414E65DB72F80E2C4160189B76D1D020419235226E8D0D2C41D5EDD92AC2D0204137D668B19C0C2C4138649D85BED02041D5477A16440B2C4168FB2111B0D02041538ECEDBC50A2C418995FC64A4D0204159ED00871B0A2C4136B75D8B9DD02041C3BD2D6478092C4128D5BB479DD0204173D3CB44D9082C415C29BB2292D020417F1C8394DB062C41AAB65F0C7FD0204172784DFBD3042C416333892C73D02041ABC474A819022C419F33D93B46D02041E4FA4C1737002C41167CB36D30D02041B24B07112A002C416953F1D62FD020417598040747FF2B411BBFDE1A22D02041D8F87FE31FFE2B4103C1404010D0204156E03D99D1FD2B4168BE24DD13D02041DA65757390FD2B4119F887EA12D02041C09305DBA2FC2B419FD3B1750FD02041642138307AFB2B416CA0B51909D02041F34A6C3606FA2B41ECBC06C902D020418465CE6A05FA2B4114DC42A509D0204172D681A4DDF92B41A42EF6A560D1204166CD758DD3F92B41A66608B5F2D120410F19FAC0B8F92B41CF45E53115D5204173EA0EC0B8F92B41F131D24C15D52041BCE6273AACF92B416C27C332BDD620416EA0BCD98BF92B41AB98F9C66FDA20419949AB3976F92B41414F7168FADC2041AD94AC3753F92B41AB17C82EA1DF2041AE0D4D6C38F92B416B9ED8FB7FE22041E08C38192BF92B41566DF863E3E320417218CFE527F92B4193638BE041E4204154E365B224F92B4112A5175DA0E42041FC216F180DF92B41EC04CD2122E720418134EC7EDFF82B412B5D68B3F5EB2041B33B13FBCEF92B415413789AC5EC2041A8AF273938FA2B419D210883C5EC204174AC0C5452FB2B41DE122964D1EC20417C883779F1FB2B410699D4B6D6EC2041D28BD472B7FF2B419A77841403ED20418DB1633A8FFF2B4101CBA6A59FEF2041E7D012BD22022C41C823E6E5C2EF204113B1AA04DF042C416EBFEADAE7EF20416128E5CEFC062C415420B93808F020414E767D0A0A0A2C41B36902F524F020410BCC97F9270F2C41F064971857F02041ED8BEEEDF2102C4165F5196E70F02041C40F60DC90142C41158CC7128EF02041A91C627396142C41E233F52081EF2041CD34B1EDAF142C41D61E7045EFED2041
62	62	12	086	003400	12086003400	34	Census Tract 34	G5020	S	855462	0	25.7839241	-80.2005309	     2320	     1248	291	51	1947	6	1	0	0	24	1059742.34960938	4679.09872234031	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
57	57	12	086	001004	12086001004	10.04	Census Tract 10.04	G5020	S	2514950	0	25.8432692	-80.222718	     5354	     1999	1153	73	4047	5	11	0	10	55	3116808.86132813	9496.52589531821	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
58	58	12	086	001002	12086001002	10.02	Census Tract 10.02	G5020	S	2428932	106306	25.8537111	-80.2205467	     6402	     2232	1426	83	4818	7	4	0	6	58	3143506.390625	8892.27909302112	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
63	63	12	086	003100	12086003100	31	Census Tract 31	G5020	S	1077391	14846	25.7924563	-80.2013174	     4416	     1845	724	103	3509	7	2	0	10	61	1355166.82617188	5009.28978198518	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
59	59	12	086	009807	12086009807	98.07	Census Tract 98.07	G5020	S	1463467	367909	25.9664383	-80.196012	     6955	     2777	1388	1102	4073	7	214	3	31	137	2271952.65234375	8145.76039398396	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
61	61	12	086	002402	12086002402	24.02	Census Tract 24.02	G5020	S	1356239	0	25.7982112	-80.2316693	     5323	     1847	4727	248	319	8	4	0	4	13	1679936.6875	5511.51674594456	0106000020E6100000010000000103000000010000003A000000A2689F8F9B0E54C09943C3256BCB3940DFFFB77CA40E54C057A9652F6BCB39405D7BBCCBAE0E54C02BE86B8A6BCB39406B4B80E6BF0E54C0AC5BA1AE68CB3940E497CE87D00E54C062CD5BF865CB3940F4093D15D90E54C0AA9FCC3F65CB3940DF12DCA6E10E54C09E1BECBD63CB3940038E4934EA0E54C0B1F3452B62CB394054E2593BF30E54C00EC39D5D62CB3940B3C0AD1F040F54C02D8528E861CB3940DD4DB93E150F54C0E2C2A1D35ECB394089365144280F54C062E138995CCB3940CA99C0C52C0F54C0F387C9F55ACB394003E6FEFE360F54C04089C55E5ACB39407E2B2A443B0F54C00807F39A59CB394067347D953B0F54C09A28608C59CB39401304A3FB490F54C02F0A002657CB3940A4F1C47D4A0F54C0BA89311D57CB39402CCED08D520F54C00543B69156CB394021EE173D590F54C04F17F0E955CB39403F99F3A5590F54C00C189F5E94CB3940ABBF9C0A5A0F54C02D78E93CCECB39401139D5905A0F54C0963DCE370DCC39402442D4905A0F54C0E9C8893022CC3940C0DE8DCB5A0F54C03FC76E0B3ACC3940C0DE8DCB5A0F54C051B7E7CA44CC3940289121D85A0F54C021B5D6B04ACC39404D6AC4515B0F54C0E465E9CD85CC3940542D27F15B0F54C0DDD1B929C2CC39401101A73C5C0F54C0E6B25FB0F8CC39409C901F9D5C0F54C04B8891673BCD39407914F1063A0F54C0A10756023FCD394089698761290F54C0C250A26240CD3940F0186581180F54C00289DEE840CD39401A77FADB070F54C04A9584D744CD3940F0E9EEBCF60E54C05546D43746CD39406AA2CBDCE50E54C0B8D8417248CD39407AF76137D50E54C0FC7E91D249CD3940B562386CC40E54C00D2D36FC4BCD3940B68907B6B30E54C0D05688B84FCD394099445117920E54C0CDE1857D51CD39409A7587A47F0E54C08F4743EA53CD39405CC4928D700E54C082E7250356CD3940445A14DE4E0E54C0922536D059CD3940C0B7A4554E0E54C075C7B8D61ECD39400BF69E504E0E54C0DD13DDAA1CCD394025ECD5D54D0E54C0316D3D14E2CC3940449242324D0E54C03842FB7DA3CC394098CB03C14C0E54C02A403D0086CC39400D3C8B604C0E54C0F097473766CC3940BD71701D4C0E54C09A30EBCA44CC39402524042A4C0E54C0B17B251229CC39404ACA70864B0E54C04DD6A751ECCB3940A2E2ABDE4A0E54C0A5202756B1CB3940CA1403E3490E54C009E6227474CB39401B61230C6C0E54C0F2595ED970CB3940244A4B898D0E54C0B867D85B6ECB3940A2689F8F9B0E54C09943C3256BCB3940	0106000020BC080000010000000103000000010000003A00000028B821AF1BC62B41B98AC4BD8E3A2041E8A0E027B5C42B419998D30E8D3A20417FFFD21317C32B4118E9D8938E3A20411F63E03E68C02B41A57517DA6A3A2041DDDAE475CCBD2B41E5F760DE483A2041AA10A2FD74BC2B41EA8B17DE3E3A2041EEB617EA1CBB2B41077C23242C3A20417EEE0B80C5B92B4132F27AB1183A2041E2E01CE35AB82B4108485CC3183A20413564B670B4B52B41C4C724BA0F3A2041CE4A18F304B32B41881E0C91E93920413A6ABE1009B02B416D9A6F6BCC39204105EE113354AF2B419C108A32B939204191DF1B99B9AD2B412AD09846B03920416E35AD210EAD2B4133675BCCA63920419D8E276001AD2B41B9BECC17A6392041BBF77D2EBFAA2B415E47BA2088392041D0C32DC4AAAA2B41C144D4A08739204191FE08F566A92B413B799EB67F3920413ECDED805AA82B41FAF9B2E47639204158A14B0D46A82B41ED0F25902B3C2041F6AB7D8D32A82B41F2161F5AAD3E20413CC4FB7519A82B41825078CF67412041BA07501E18A82B41DF3BE76D5042204168E98A600DA82B41F87379FA58432041065555B00CA82B41FA2B0A32D043204170A27C560AA82B41603E6F9B114420416D79E577F3A72B41D2059230A1462041BDC0C298D6A72B41502F7A8C3E492041BDCD7F42C7A72B41987E86499B4B2041426F1EDAB3A72B41FAEB1C377F4E2041C01D23BC20AD2B41D5A68F3AAF4E2041EA17E735BDAF2B41C3E2DB5DC24E2041ED6C1DF462B22B417DA7651DCC4E2041F00DCA43FFB42B41DD0B7B9DFB4E20411A2191D2AEB72B41771759E10E4F2041DE99A47454BA2B412CBC428B2B4F20415F212DEEF0BC2B41ED6A64B53E4F2041B80DC64693BF2B410A93E7A25A4F204150D4DF3A32C22B41D9EB60FF874F2041260B176778C72B41578E9389A34F2041D43341315DCA2B416989AFC8C24F20412145221BBBCC2B415EF7199CDD4F2041A4661BC703D22B418923C3BD0F502041EB1AAE0A1DD22B413A2DF6B6814D20412B74C5F81DD22B41A7EE81A2694D2041B50CA91135D22B41C0A420E1DF4A2041B7CBE0D352D22B41EB4D28CF294820413C2A4A8666D22B41C02564CBE24620412AE06BBD77D22B415FB32C52824520417901887484D22B415A92F5A50F44204155F2BF4B84D22B416750CA24DC42204177396AEFA1D22B41BB0F9A6D3A402041C67CF11DC0D22B418A5A0558AC3D20415511E495EBD22B41DA47E041093B2041F666A4BB8FCD2B416EFAFB30D93A2041744DEDC94EC82B41E1DD27AAB53A204128B821AF1BC62B41B98AC4BD8E3A2041
65	65	12	086	000903	12086000903	9.03	Census Tract 9.03	G5020	S	2953945	0	25.8383344	-80.2504081	     2673	      883	1241	66	1331	2	2	0	3	28	3661829.63085938	7682.09265070752	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
66	66	12	086	000206	12086000206	2.06	Census Tract 2.06	G5020	S	2368724	70285	25.9177402	-80.1656246	     5349	     1711	1193	302	3563	5	111	2	21	152	3028362.87109375	7217.97411103908	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
67	67	12	086	000109	12086000109	1.09	Census Tract 1.09	G5020	S	6974951	1848554	25.912775	-80.1441461	     4086	     2296	1835	1012	1051	4	92	1	22	69	10957248.5976563	13847.3905624598	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
\.


--
-- Name: mdc_qualified_opportunity_zones_ogc_fid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.mdc_qualified_opportunity_zones_ogc_fid_seq', 67, true);


--
-- Name: mdc_qualified_opportunity_zones mdc_qualified_opportunity_zones_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdc_qualified_opportunity_zones
    ADD CONSTRAINT mdc_qualified_opportunity_zones_pkey PRIMARY KEY (ogc_fid);


--
-- Name: mdc_qualified_opportunity_zones_geom_geom_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX mdc_qualified_opportunity_zones_geom_geom_idx ON public.mdc_qualified_opportunity_zones USING gist (geom);


--
-- Name: mdc_qualified_opportunity_zones_geom_local_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX mdc_qualified_opportunity_zones_geom_local_idx ON public.mdc_qualified_opportunity_zones USING gist (geom_local);


--
-- PostgreSQL database dump complete
--

