--
-- PostgreSQL database dump
--

-- Dumped from database version 12.17
-- Dumped by pg_dump version 16.1 (Debian 16.1-1.pgdg110+1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: mdc_holc_redlining; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mdc_holc_redlining (
    ogc_fid integer NOT NULL,
    objectid integer,
    holc_grade character varying,
    city character varying,
    holc integer,
    code integer,
    st character varying,
    citystate character varying,
    shape_area double precision,
    shape_length double precision,
    geom public.geometry(MultiPolygon,4326),
    geom_local public.geometry(MultiPolygon,2236)
);


ALTER TABLE public.mdc_holc_redlining OWNER TO postgres;

--
-- Name: mdc_holc_redlining_ogc_fid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mdc_holc_redlining_ogc_fid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mdc_holc_redlining_ogc_fid_seq OWNER TO postgres;

--
-- Name: mdc_holc_redlining_ogc_fid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mdc_holc_redlining_ogc_fid_seq OWNED BY public.mdc_holc_redlining.ogc_fid;


--
-- Name: mdc_holc_redlining ogc_fid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdc_holc_redlining ALTER COLUMN ogc_fid SET DEFAULT nextval('public.mdc_holc_redlining_ogc_fid_seq'::regclass);


--
-- Data for Name: mdc_holc_redlining; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.mdc_holc_redlining (ogc_fid, objectid, holc_grade, city, holc, code, st, citystate, shape_area, shape_length, geom, geom_local) FROM stdin;
10	4343	A	Miami	1	1245000	FL	Miami, FL	3.55192639744928e-05	0.0235105197968482	0106000020E61000000100000001030000000100000008000000E1F8B1B4D90754C0B8B78ECA7DDF39402E855613430854C0040183BB6BDF3940E7B00F73480854C0CCFB2E6F85E039408D88673E440854C0367638A3AEE039401F3EA470410854C01436BA85D9E03940B6805E25100854C0E852B70EE9E0394062F670D1E20754C0CD39CA6BECE03940E1F8B1B4D90754C0B8B78ECA7DDF3940	0106000020BC08000001000000010300000001000000080000003BE067D708D42C4189285878E91A214170D702A384C32C41DEC0AAFE041A2141A8F7B23498C22C411CE0974F38262141E293F3FB3DC32C411EF4397902282141D6A4B55DABC32C413B3350EADE29214126720CCA64CB2C412B197C63982A2141A19694E97FD22C414DA50ED5C92A21413BE067D708D42C4189285878E91A2141
28	4361	B	Miami	2	1245000	FL	Miami, FL	7.6207978054299e-05	0.0525597767799756	0106000020E61000000100000001030000000100000012000000DA95A0038E1154C007CCB6F91DBD39402F0D899C5A1154C06687FD40E7BC3940B9202D5E241154C06B389D5FF2BC39403E8883D5EF1054C084217F24FDBC3940A2CAB426CB1054C048BC8470F0BD3940BD6DBB70AA1054C09A0E7AD638BE3940269B4ABDA91054C0F637A157D6BD3940F69388888C1054C0E961383CDCBD39407BD894F6891054C0DECE9B2A62BD3940C93D86EFA61054C0473587CC5EBD39406D10F7A2A71054C00EFFEC056EBC3940855CCA75EA1054C0CB4BF7B46FBC39404EEC04A8E71054C00A73B32633BB3940030B492E2B1154C00A73B32633BB39409FE5E60C461154C07752105022BB3940BE734B52491154C0B97097322DBC394079625A57891154C0D7A6442168BC3940DA95A0038E1154C007CCB6F91DBD3940	0106000020BC08000001000000010300000001000000120000003FAC99349C502B410943A68181361F41AF1A2D24B1582B41668CA757DA311F41243F023734612B4152B04028E9321F4159C16D9972692B419409068AEF331F41EB070D98256F2B410B413F4715491F41B8F35C8543742B41754693136A4F1F41637504D065742B410BE2D25FE1461F419888E30BFB782B41ADCF794771471F41ABC529EF69792B410ABD3479DE3C1F41643702EADD742B41D4FD1CB2863C1F41803DECB8D0742B4107B51407A9271F41DEE6A74B536A2B41E75BD059B0271F418EFB338CD76A2B418598B12A430C1F41FBD02BF33D602B41B4A40BFD240C1F415366B22D075C2B417D7D427CA30A1F41DE899B59735B2B41AE62B892C2211F41E21E5F1563512B418AD0AF88C1261F413FAC99349C502B410943A68181361F41
42	4375	C	Miami	3	1245000	FL	Miami, FL	3.55371553268924e-05	0.0371270462022692	0106000020E61000000200000001030000000100000006000000553E04E8A60854C0E5D61BEA34C639405B046688BA0854C0861B4E6BE3C439408528F7ECCD0854C04C23A3A0E7C43940ADF51AC2FE0854C02358F4052FC639403F4C8321B90854C0C8EC4BCE3AC63940553E04E8A60854C0E5D61BEA34C639400103000000010000000C000000254AA804970854C0994A12A73AC73940DEB72CEFA20854C0068DD8A880C639402DF8218DAF0854C0E93048C28AC639408662954CBA0854C013EDCFEA89C639404B69F1BA020954C014BB209C7BC639409DF033AA030954C063AD37F0BEC639402E35A5690E0954C063AD37F0BEC639402E35A5690E0954C0ACDD7C582CC73940C5C54A92080954C068C59B3C32C73940F9B1DAE0AA0854C0D77D358B40C73940EA87F76D9F0854C0FA22193A42C73940254AA804970854C0994A12A73AC73940	0106000020BC0800000200000001030000000100000006000000AFD43438B4B52C41FE04B4B53B02204146FCBC4BB8B22C41C743DCED2DE71F41A86065E2ACAF2C4176FB7E1581E71F419836B35AEBA72C4188770445E3012041D05C9AA6D7B22C41EBA86F4178022041AFD43438B4B52C41FE04B4B53B0220410103000000010000000C000000CB14E56A1FB82C41C6308C29970D2041E9DFD1454EB62C41080366F0840520412DA02CAD52B42C41CABA12A3F1052041204A76F7A2B22C41545F3578E50520414F36DA3E46A72C41DA1E95BE33052041DD635DD41BA72C4104586D521E082041C36C27106CA52C4122B9E5811B0820416E9DAA2764A52C4139E3DB13D90C2041AABDC8614EA62C414AC3D0F31B0D204171F36E2B01B52C415A1BD344D30D20419E0929F7CCB62C41B52D5DF5E80D2041CB14E56A1FB82C41C6308C29970D2041
53	4386	C	Miami	3	1245000	FL	Miami, FL	4.62395214526623e-05	0.0290768803011629	0106000020E61000000100000001030000000100000005000000359788A8E31154C03AEBE437C5D33940222A0B61801154C0DEA0F1E9D6D33940B67A98077A1154C0178B1CBF43D13940226E285EE01154C0771C4CC571D23940359788A8E31154C03AEBE437C5D33940	0106000020BC0800000100000001030000000100000005000000D1C342CECA412B41993C781873962041267D9B3A5C512B41FAD1CB4E4D972041B1B4139883522B418409DE2FBF7A2041A6511E9163422B41ED0E11A5BE872041D1C342CECA412B41993C781873962041
64	4397	D	Miami	4	1245000	FL	Miami, FL	1.57287036017806e-05	0.0165121561058093	0106000020E6100000010000000103000000010000000600000035371B35231054C0B7CE695D3DC4394033B6AFBA501054C0D64D4BBB37C439400394197E561054C0A98A92581EC53940E27B9820571054C00A3EBF9C97C53940BAAE744B261054C0625B7BA99CC5394035371B35231054C0B7CE695D3DC43940	0106000020BC080000010000000103000000010000000600000043BB47A91C892B4193B4996826D51F4136105E2CF8812B41CDA83AB994D41F410A8F0E2D02812B4186B611108EE81F413EE10913E1802B419BB27EF30FF31F41E95887858A882B41484B4A3196F31F4143BB47A91C892B4193B4996826D51F41
1	4334	A	Miami	1	1245000	FL	Miami, FL	0.000218454608784668	0.0882563204450698	0106000020E61000000200000001030000000100000008000000B5EE0DBB580B54C0AB8686D78BDD39406A7F235E570B54C046C83CE35CDD3940DECD7E9DEE0A54C0B72DAE1761DD39408F052C89F10A54C0849063537DDC39409A229A223B0B54C0B75277816CDC3940BE074579BA0B54C0C82E38676ADC39406DD76F199C0B54C00AE3685481DD3940B5EE0DBB580B54C0AB8686D78BDD39400103000000010000000E0000003ACB9425260C54C0367D9416D0DF394053334DD3050C54C057A5DCADC7DF394061B91F9CE10B54C0299DCCAFCEDF39405E128853DD0B54C0ED74D4A339DE39402DAB7B27B00B54C0ACD47A7343DE39405A3DB6B1EE0B54C0E859C23A0BDC3940A554D6F7A00C54C0B8CDCB96E9DB3940A907D246A70C54C0635DB67FE0DD39406AF1BF1BA60C54C0720EA67A15DE3940227C1336A80C54C0461C942B1ADF394007FB23CA660C54C0ADB257B52ADF39404E1136F5670C54C07614709A81DF3940032CE5C1250C54C0E9FC47FF7BDF39403ACB9425260C54C0367D9416D0DF3940	0106000020BC0800000200000001030000000100000008000000C86D5F58D5472C411A3365776D0421413CFEF7510F482C41BEE29EFA640221418FA30D0C7C582C4131FD6311AE0221417597FBC016582C41624AF7DECEF820415F7809628D4C2C41893F6FB301F82041C06FD3B195382C412662F170CAF72041545156BF453D2C410B918AF6E7032141C86D5F58D5472C411A3365776D0421410103000000010000000E000000A00E54CA77272C41E07E5E745E1D21411E2348B8892C2C413BA1E031091D21412A1835E636322C41394AFBED5F1D214157E891B6FE322C41308F281AD40B214169F55F4C133A2C41B803AA324C0C21413E0A10EA6B302C417C9D48BD9DF3204121A9C18D79142C41211EC38FFCF12041E5F3033A5A132C411818B86AC507214146BCF88785132C415BF6A85F110A2141E6A118741F132C41E8C51F835C152141B7FEFB59601D2C412D93F90A2416214148873C8A2B1D2C419ABDEC9DE71921413F4A3C2D8D272C416EDA34CAB9192141A00E54CA77272C41E07E5E745E1D2141
2	4335	A	Miami	1	1245000	FL	Miami, FL	0.000102855346995057	0.0531389372634272	0106000020E6100000010000000103000000010000002100000029735903360C54C0D7392F2AB6C139405A87031E410C54C0FB4677CE9EC13940CBC1A6AD550C54C0663A767B89C1394036BA7EB2630C54C0BBBF91BF82C13940AE708B2C6B0C54C00A2E752874C139401606929B940C54C0F3A779060EC1394029F4DB869A0C54C068D11394F7C03940933FEA3FA30C54C0887592DDE7C03940F927A206C30C54C0F94E85A5A5C039404D9EFE28D40C54C0B9BE177851C039406D38C774D90C54C0D5124EB225C039400A714FD1DD0C54C0AD21676407C03940F6069CFBE40C54C006318726CEBF3940DEC5A0B8E80C54C08B2DDF6FBEBF3940B6F1390DF70C54C00697DD7FA3BF3940ED0EC926FF0C54C0DC9C2FAF89BF394013805E3C0C0D54C0F8C9D7B977BF39407937B6A1190D54C02E27679051BF3940AB54CA17260D54C04B6AAB1D3BBF39402576D5522C0D54C04716E7AA24BF39403911E989370D54C07AC222380EBF394046841476500D54C059273CEFE6BE3940A911EEB95F0D54C0ED2F0043C5BE3940C283CEBA720D54C06AFCCAE366BF39405A9A0521930D54C0FD14C5C701C03940EADBCB7B710D54C0E757978D2DC03940756C3565330D54C028728B70C8C0394033BACD65D40C54C01378501ED0C13940E53949F08F0C54C08259D1818DC2394093814DE7740C54C0BD20767B50C2394069DAD5A9670C54C0173311692DC23940170BA155560C54C0893C861DFFC1394029735903360C54C0D7392F2AB6C13940	0106000020BC0800000100000001030000000100000021000000AB825AAB08272C41B76013E1ED9E1F41DA325F1B4C252C41D7BB5238E29C1F41549B146F13222C412E5DD108FF9A1F41D107F69FE01F2C41DE42CBC0629A1F418D3B9934B51E2C41D473DC671B991F4199704E573B182C4122C4625A2D901F4109ACD4074F172C419DA5757D388E1F418D98DF9BF1152C413428EDA4D78C1F4166F65D4EF9102C41A402DB1B0B871F41B9EC39834E0E2C412CB61D59B77F1F41FFFA6FA87C0D2C41CF5EACB5E97B1F41ED09AE72CF0C2C41E05C744F47791F417A491463B30B2C41BA8ED5F64D741F41F55F043B1E0B2C41BB02028EEF721F41BD4C8B38E0082C41A4935E0093701F4105A3F67C9C072C41D7423661526E1F41A7D558F18F052C416A5756A3BD6C1F41CCDE3A3A78032C41180CF98D68691F41C882130385012C41E575788670671F415F8CF9268C002C41108767837B651F41E4D4BC00CBFE2B412E42AA1784631F412D7C972DE4FA2B41F682688E10601F41A85C740881F82B419CF783311E5D1F41AEBCE0B07AF52B41A676ED9D166B1F414D5FC2915AF02B418C66DF2673781F4147CD30909FF52B419C7B12634E7C1F41FAF112F853FF2B41751F565FD8891F410F30343B2B0E2C414A913CFDDFA01F41B2D81D03DD182C41EA4BAADF6AB11F41207E725A1F1D2C41D8483C582EAC1F417EE64DB1351F2C41E4B66BCE2AA91F41B25DBB14F1212C41AF28A94E30A51F41AB825AAB08272C41B76013E1ED9E1F41
3	4336	A	Miami	1	1245000	FL	Miami, FL	2.01765992642322e-05	0.0193556516749103	0106000020E6100000010000000103000000010000000B0000007F4822A8F80D54C0B47FA5C0F0BD3940BDC673B8010E54C0A9DFC50FD6BD3940215598E7160E54C085FA0F49AABD3940C5174EAE360E54C0C572AED55CBD3940B92904C3300E54C0656FDD58C6BD3940A15C97D0330E54C0F45A4841E9BE39407B3C25CE270E54C0EDF430B9F3BE394016D24CBD0F0E54C098D872EA27BF394025B03C52E10D54C0A757727835BE39400950726BF80D54C013C95F73F1BD39407F4822A8F80D54C0B47FA5C0F0BD3940	0106000020BC080000010000000103000000010000000B00000057ADD0DF8DE02B41737152996A4A1F414A68FC6923DF2B412990B92B16481F410D17FD06D3DB2B41064695F640441F41710A7D33DBD62B4164B7D2B67B3D1F412FEFB826C2D72B413308BD36A3461F41307F5F6F34D72B41C2AA3249D75F1F4137E3055216D92B411CD3C136C5601F41C7B19FE9D9DC2B414E09537C56651F4130D8CE0D33E42B41508ED72A6A501F416DB3B35A97E02B41EDDF21337A4A1F4157ADD0DF8DE02B41737152996A4A1F41
32	4365	B	Miami	2	1245000	FL	Miami, FL	1.67552511811664e-05	0.0164347952399612	0106000020E610000001000000010300000001000000060000002AD7DE1ED90F54C0CCC0AB7379C43940BDFB74B3141054C03275155A6FC439407D86C8CD161054C04D884F07A0C53940FF1915A0DC0F54C01B3588EBA5C5394036480FE3D80F54C0C32ADEC8BCC439402AD7DE1ED90F54C0CCC0AB7379C43940	0106000020BC0800000100000001030000000100000006000000659A6B4DB9942B41665EDC427DDA1F413B2A0B4F608B2B41CADAA1F081D91F41875C40A1F88A2B4188E22DF1E7F31F41D9E05B7A19942B41CA2F314285F41F41E531C46CBE942B4167E03A1553E01F41659A6B4DB9942B41665EDC427DDA1F41
31	4364	B	Miami	2	1245000	FL	Miami, FL	1.21055948056892e-05	0.0190692821054435	0106000020E6100000010000000103000000010000000700000045622C1A850F54C02699EC1E27C03940E3A9C3E1B70F54C016DD99A122C0394042728670B90F54C0372736ECE5C039408BC14CA64D0F54C054961464F3C039408BC14CA64D0F54C0A4C63DC3BFC0394031B6ADB9850F54C0AD7CA9C8B6C0394045622C1A850F54C02699EC1E27C03940	0106000020BC080000010000000103000000010000000700000095C20D3C2FA22B410A2ABC08C57A1F415521FF2A379A2B41A503AA0B4A7A1F41750E7430EC992B4184967CAD358B1F41AFF19946D6AA2B41AFB09239928C1F416AD58E94D9AA2B418F84B3E618881F41DC35CA0B0DA22B41C69E49C537871F4195C20D3C2FA22B410A2ABC08C57A1F41
4	4337	A	Miami	1	1245000	FL	Miami, FL	0.000112904480829457	0.055317029321996	0106000020E61000000100000001030000000100000011000000756C3565330D54C028728B70C8C03940EADBCB7B710D54C0E757978D2DC039405A9A0521930D54C0FD14C5C701C03940793A2AA60E0E54C0E422A0BD58BF3940E63D3BD10F0E54C0725A13B243BF3940BD4C05F6270E54C0477FC69E20BF39407BDB05B02C0E54C064E6F82454C039404F20C1942E0E54C0BEE7D755CFC03940A3A6192FD60D54C0FAED2824D2C03940A3A6192FD60D54C0C88C160519C2394035B952AEB40D54C0A9A32FF929C23940713938BAA50D54C007CB76A44BC2394053440C8F8B0D54C0F8A87116C6C13940D20BC5BD3C0D54C0743EE1919DC239407EE071240C0D54C026049907AAC13940D24D9048430D54C0DCB966C214C13940756C3565330D54C028728B70C8C03940	0106000020BC0800000100000001030000000100000011000000FAF112F853FF2B41751F565FD8891F4147CD30909FF52B419C7B12634E7C1F414D5FC2915AF02B418C66DF2673781F417E26818502DD2B417DE2D42392691F4178E50EF6D4DC2B41136BC5B7BE671F4132A0F21E0DD92B41435A6122A9641F41FB5FB70F3BD82B410B5EC9084D7F1F4134A50DEAE6D72B4151B5B303F9891F4149C62F81C6E52B4173115B57618A1F41489F46F3B0E52B41CA4A2FDBB4A61F41FBEEFCEAF1EA2B416EC359FB3CA81F419F00157E48ED2B41D77A51112FAB1F41938C44C06CF12B416BF3ECD4A89F1F414D301D25BDFD2B417C844A1C7BB21F4117E17A0A6E052C4136A125EA779D1F41EC9A3D7FD0FC2B4108AEAAC76D901F41FAF112F853FF2B41751F565FD8891F41
5	4338	A	Miami	1	1245000	FL	Miami, FL	4.9336166739522e-05	0.0371263912363099	0106000020E610000001000000010300000001000000110000004F20C1942E0E54C0BEE7D755CFC039407BDB05B02C0E54C064E6F82454C039400EEE8F764A0E54C066ABA2AA4FC0394019E35650570E54C0D79FD11151C03940D1518B77760E54C0C9F5D5A648C0394045DBA883990E54C0A4472B754BC03940BB551C769B0E54C06823F1E882C1394049BD8E689D0E54C04549E0C0F8C13940571DD95FAD0E54C04549E0C0F8C13940EEC05F7DB00E54C0F6E0D91193C23940BFC12B0A5A0E54C0F6E0D91193C23940C55919393D0E54C027BD954390C239400FC9931B3A0E54C03313F802B4C139400D138CD15A0E54C0722B6B38B8C139404147B817580E54C07D537AB5C2C0394061D46C20480E54C0094D29E7BFC039404F20C1942E0E54C0BEE7D755CFC03940	0106000020BC080000010000000103000000010000001100000034A50DEAE6D72B4151B5B303F9891F41FB5FB70F3BD82B410B5EC9084D7F1F41BABA00F68ED32B41F2AB3096DB7E1F41A5AFFA858AD12B4162A0FFA1F47E1F41B35C7053A7CC2B4116CA432D2B7E1F41610E6CED26C72B4125AAA5EA587E1F41B1DB2579C4C62B4126B5CF4755991F417969AB976EC62B41D5355D9D8AA31F411411BA1BEDC32B412ECA3A1C83A31F4126D19FEF65C32B41F55A7003E1B01F4108F30F46F7D02B4161E6D3C009B11F415EA0DA3C7DD52B41222C0427D9B01F417AEAA7D008D62B4128739786C49D1F412CDB2344E6D02B41BC29A268129E1F4137F026D063D12B4171DB873FCD881F41FAB6D681E5D32B41E87B2F8E96881F4134A50DEAE6D72B4151B5B303F9891F41
6	4339	A	Miami	1	1245000	FL	Miami, FL	3.26900624258997e-05	0.0260711108986675	0106000020E61000000100000001030000000100000015000000DD6EDDBB301154C008B63BCC60B63940A27BCCC3261154C0567F42456EB6394089122AC1ED1054C085427B2A64B639407580CF2BB81054C02B2CB4646FB639405A27877FB31054C02696183B49B539408DAF99B6BE1054C096A5E0B4D6B4394081C14FCBB81054C0BD892237D2B439406D15D16AB91054C01398869595B43940A9C616D8BC1054C0268AA75693B43940C3F62B4EC91054C0A52FE7C6B2B43940E6BA72BBCC1054C0935FD9E1BCB43940F13DBEE5D31054C0F8B267C2BBB43940355A0214D61054C0F506FA6CE6B43940E9148BAFDB1054C0E53224DD05B53940C1FE5879E31054C07B6E620E23B5394089122AC1ED1054C0398839FC46B539403AA4FAC9F61054C04C50B78B67B53940613EC315FC1054C0FAF02A8770B539403D2F731F181154C0468F0B5A8AB539409A8C37ED1A1154C0932B0B129AB53940DD6EDDBB301154C008B63BCC60B63940	0106000020BC0800000100000001030000000100000015000000B84EB6A5AA5F2B41B0905BCD2BA11E417E6958813A612B41F43FAF1E5BA21E41D2E64E8D2E6A2B41CBFFDE6C94A11E4144F56C8B97722B416E4B5889A5A21E417D2520A065732B41CB70CFFB29891E41442940F0A9712B4186FD8E5A387F1E41FF87FE2298722B41F33FFD61D77E1E41B0CD74DA82722B417587981196791E41E787A13FF9712B41F68568B662791E4128AAC46902702B4117BB4A8A167C1E4166070C0B786F2B4124D5CF2CF57C1E414998A71A586E2B41E943190DD97C1E417486FECEFD6D2B4170AF11938A801E411C7DA0771A6D2B412EA3677A41831E4117C3AC9CDF6B2B41919DEC95C5851E41D083142B406A2B4142A08506DE881E419EE0CB05D3682B41B72C9A4CAC8B1E41372AE698FD672B41CC91DF30718C1E4172BCDE0A95632B416DE7AE89A18E1E41F410186123632B41160B2CFDFC8F1E41B84EB6A5AA5F2B41B0905BCD2BA11E41
7	4340	A	Miami	1	1245000	FL	Miami, FL	0.00020084472794224	0.121922560676745	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
8	4341	A	Miami	1	1245000	FL	Miami, FL	5.87447634643468e-05	0.056009314051793	0106000020E6100000020000000103000000010000000D000000225B8E3E830B54C07C9CAEDDACD839403666A7597F0B54C0E261652A80D73940BBA50212400B54C0C68CB39388D73940BD5743FB3B0B54C07481DA8E7AD7394095A5221D370B54C0E7D01F236BD739405EB843282E0B54C0B49576EE66D7394007B5A277310B54C02D669B9A52D73940D1D94E63340B54C08C5E0E4E53D739406E8FF0E63E0B54C0524D672C3CD73940A3D6827E490B54C008CE843333D739408DDF1E5BC10B54C0D54CDDE624D739403283A578C40B54C06AEDBDC5B1D83940225B8E3E830B54C07C9CAEDDACD839400103000000010000000C0000007A66B41B1E0B54C0C3126528D4D9394062181510110B54C0446C64E24CD93940D969C5461F0B54C0A9EF8B4B55D939400BFE05226E0B54C02A600DE045D93940EFF16090B60B54C0025375AB41D93940A7004BC0C50B54C01B996EC33CD939400D1CB47DC60B54C0865D8E4AF6D9394049F05BB46D0B54C0C949ADB3FED939402E10D28D2F0B54C09C94316E05DA39401333F3CB1D0B54C06D37CCA7F9D93940A9CA15E31E0B54C0D95864B0ECD939407A66B41B1E0B54C0C3126528D4D93940	0106000020BC080000020000000103000000010000000D000000496E491A81412C41EB2EEAFE5ACE2041CC1F514432422C4141F9E28654C120417326AD601E4C2C412E99FCB8C1C12041299B6985C34C2C4119BB244027C1204102DF7408884D2C41997FCD6C7DC02041ED97D7EEEF4E2C41D8730D0851C02041C1D3FD726C4E2C415400EFB76EBF20410B3A2623F74D2C41B27001C275BF2041206DFC98524C2C41DC06868772BE20415E33A7F1A94A2C411B0C6B570CBE20416194646ADE372C414894EBB44FBD2041DA5A36FF45372C41D4DEDA1D81CE2041496E491A81412C41EB2EEAFE5ACE20410103000000010000000C0000003DF938FB48512C41F42872E33FDB20416F5042295E532C41BA977FB166D520412F78B9ED22512C414E53DC65C0D520412CAECF16C6442C41B357178201D520416342666E6A392C41D7CA53BBC0D420413281B80909372C4121EC3F8586D42041E833978DDE362C41EA49194290DC20419AC79478CA442C4126B315C303DD2041C0B3DB26894E2C41486052085EDD20415B0883DF52512C4135D2CDE6DFDC2041A692A20028512C411D2D91CC4FDC20413DF938FB48512C41F42872E33FDB2041
9	4342	A	Miami	1	1245000	FL	Miami, FL	2.54704127655714e-05	0.0217284815024591	0106000020E6100000010000000103000000010000000A0000009D4AE571E10B54C0472A5C3B43D43940939B2F96CC0B54C0F546EF4CCFD439403516C4088D0B54C0F92578C9D3D43940FD3A007A8B0B54C0E7B8AB3BBCD439405D2CF63E850B54C0388568D077D439400ECF3171820B54C0898DB2C508D43940C37022B8790B54C0DB529822B9D3394055654240FC0B54C0988C724FA8D33940E96B1F50E80B54C084463E1C15D439409D4AE571E10B54C0472A5C3B43D43940	0106000020BC080000010000000103000000010000000A0000008C148FB508332C411C85594F519D20418A171B9F44362C41C10B902C68A32041CEC9A02C3C402C412BAB69CEA9A32041860E6B597C402C41718847EEA4A22041F17CDA437B412C414FF93692AF9F20410D76D487F3412C4199BA4B92E09A2041E2A1004F57432C41928749676F972041E0D783F2DE2E2C417A9C2E3A949620419084B617F8312C415E401603509B20418C148FB508332C411C85594F519D2041
11	4344	A	Miami	1	1245000	FL	Miami, FL	2.5300591460109e-05	0.0320294667860436	0106000020E6100000010000000103000000010000001A000000D1E9C357F40854C0BBDC6860E1D93940535DC584E60854C0C32FFAACE0D93940F903BDEECF0854C05AE4F864EFD93940633839A4DA0854C0CB2AC8BD63DA3940F903BDEECF0854C0F8F163225EDA3940A15DBBD0B60854C05A1D767C87DA3940DA522887860854C02386BA9BE9DA39403F788AA86B0854C05AD407A913DB39406F2EE261580854C047B5537D2BDB3940B3016E9C480854C049440FB436DB3940B3016E9C480854C0653B3A0900DB3940E18ACBBE590854C01EE35D51F1DA3940725AC0FC7C0854C02AA42ADDC5DA394013BBC0296F0854C0E3B5368043DA3940554F37677C0854C0E305FFC52DDA3940C3A07723860854C0271FE88C1BDA394045C2F2D8900854C0A600AEEA00DA3940F9B252739F0854C035C0B692DED93940691EE6E9C10854C0FC813EE7A7D9394016AFFB8CC00854C0C975E17483D939408B4E6BDAD20854C04470D3D46FD9394010775855ED0854C064095E396AD93940CDDE1AB7FC0854C08D2D9A9B5DD939405EDB9911F70854C0274B5CB09CD93940EF9B74BBF40854C0A9736838B5D93940D1E9C357F40854C0BBDC6860E1D93940	0106000020BC080000010000000103000000010000001A000000AA709B2820A82C41CD44792F61DC2041638890364BAA2C41A329A90B5DDC2041C1B813E9D4AD2C41A260C74106DD20415C3A6F831EAC2C41F636F4FE0DE220410EDF3AD9CCAD2C41DA0F329FD2E12041282D4134BAB12C41E1BC55EFA3E3204118D2069745B92C411916BC1BF1E720417F16323679BD2C413FB40AB0CAE92041AFA0B74F7DC02C41B2E43321D8EA20416D94C6A2F5C22C414D2DF3B558EB2041482081A7F9C22C41C2633552FAE820418C8ECCDD4AC02C417AC8818152E8204144E0DA39C7BA2C41EDA89E2567E620415FBE46C5FBBC2C4122737EC7C4E02041E39681D0E9BA2C41D6F1A042D0DF2041A6A6B84D64B92C411BBD7C8B03DF2041528E1252B8B72C41BF257F47D9DD204141404B8F70B52C41DFDA147758DC204125E18EF00CB02C41D31DD8F2F0D92041680E9E5046B02C41099F4F075DD8204186C484F068AD2C41D782C8837ED720414E837C3942A92C413803355939D72041F59B3297D9A62C416A2DD55CA9D620412782ECB4B7A72C41EC2CF28F66D92041CA7211BB13A82C4162D4804977DA2041AA709B2820A82C41CD44792F61DC2041
12	4345	A	Miami	1	1245000	FL	Miami, FL	3.53496218394866e-05	0.0346783289941052	0106000020E61000000200000001030000000100000015000000DD5EF671E80754C0D3D05A5F11D8394046575EFCF10754C016E074F80FD83940EB3533B6F40754C0A72A38C612D83940457C5A57020854C059FCC50466D939406DE0BB1E030854C03DFA46587AD93940E6B397C8000854C01E1BC69393D939407DCD4AA4FE0754C0B874A6B2A3D9394065573EF1FA0754C0E9E9F4B4AAD9394069EBF444F60754C0E9E9F4B4AAD93940DB35C33BF00754C07B133CFFA2D93940134C65ECEC0754C0266E57E092D939406214B800EA0754C0D4BC18076DD93940DD5EF671E80754C00841B28D33D939404AD9F9E9E50754C0C9226757DDD8394082EF9B9AE20754C0DDA6064EC1D8394053022D20DE0754C0B8414D2AA3D83940570DD6C0D50754C069F3A03630D839406E4894D7D90754C069F3A03630D83940669653EEDD0754C0D7A8DD682DD839407696C368E20754C0CAB46E7E21D83940DD5EF671E80754C0D3D05A5F11D8394001030000000100000027000000E5D89323110854C04D5AC11BC4D83940D908C9A4140854C0244FAB4BBAD83940BD4B6FA01C0854C0F8A888B2BBD83940565A79DB220854C057A1FB65BCD83940C1C9432D2D0854C087F74F49B3D8394079D82D5D3C0854C01DE86FC3A1D83940655622F5430854C00598A10D9AD83940B69CD91B4D0854C0058ECC6F8DD83940C69C4996510854C0093EFEB985D8394009E300BD5A0854C00A3C7C558BD8394076F9F2DC640854C079F1B88788D8394086F96257690854C07AEF36238ED839402E08DD0C740854C0A69559BC8CD83940C53471DD7A0854C0693EC4A698D8394094E22A7C810854C02445D6ADADD83940167B2804840854C04D5AC11BC4D839409330EA92850854C0C72EBE59E4D8394085F59BF6850854C0CAF299DFF5D83940513862FD840854C095CB9AE60AD93940EFC807267F0854C028DA3CF22DD93940124B83087C0854C0E3D67C1345D939408DD09F9B750854C048417EEA63D93940717757EF700854C03492908A77D9394003AF24E66A0854C015B30FC690D93940D673F654620854C004D5CF33A7D93940B5C1D5765D0854C0FC813EE7A7D93940832DCFB3540854C01590174EA9D93940F2D005624A0854C0D62EB052B7D93940655622F5430854C07BF04387BBD939400AE7C71D3E0854C07BF04387BBD939407DA88861340854C0A9736838B5D939405EA8A86C2B0854C0A8966368ABD939403FA8C877220854C0266E57E092D93940116D9AE6190854C019A7B50B7BD939405BDC14C9160854C0581FC1345CD9394067ACDF47130854C034E7D42632D93940ED13E2BF100854C06DDF7E3511D939408710D1940F0854C01ED49FC0E5D83940E5D89323110854C04D5AC11BC4D83940	0106000020BC080000020000000103000000010000001500000067D045DB45D22C41AC3AAB5B8DC82041C85ACDE7C6D02C419DADE9407BC820415EC1FC4059D02C410346E49F99C820416A122EFB1CCE2C415E75CDFF48D72041166E2F36FCCD2C41DA85A5412AD82041DE292F2758CE2C411E4F9AC442D92041A1DC58F3ACCE2C41FB9CFF27F6D92041E1838FF440CF2C41834459E444DA2041F677A690FCCF2C415186582446DA2041B1DA8076EFD02C41E5E8953CF2D920419A05908B75D12C4102B2684E40D920414E24E899EDD12C414A3EF7419DD720410605BE6330D22C411B84602620D520412F845B649CD22C418DB6408864D12041EAD83B5C23D32C4106DA2B6D2ED020415E966B63D9D32C4154A8BB4EE1CE2041E612240C32D52C415B4EE876E8C920412188D2E18DD42C41BEF2505EE7C92041B39C78ECE9D32C41573C1F2CC7C920418F49310137D32C41BC0F7ECC41C9204167D045DB45D22C41AC3AAB5B8DC8204101030000000100000027000000DC506BD3D6CB2C414F4B731441D020410BE7DBD64ACB2C41593FF84BD3CF204107EF333A0ACA2C4180563DB7E0CF2041AB6EFB0510C92C4128A64CD4E6CF20419ED3DE6072C72C4182983F017FCF20417D2B59EB11C52C414644D796B8CE20418A1BA29CE1C32C41E40C5C0B61CE2041DF2A2A2073C22C418F47D9A9D2CD2041C437B5E4BFC12C41CCA5F0F27BCD2041FACB661150C02C412EFA6BB7B7CD2041C21AD0C5B9BE2C41FF787FED95CD2041AC0B279005BE2C41AF0335F0D2CD20413A2DBCB657BC2C4168735C8CC0CD2041CD1A2D3C45BB2C41A4A825EA42CE20413BA6ACE839BA2C4121F6F2672ACF20415DD265A4D2B92C41CC3A9F8722D02041A632DDBE91B92C41A5CC0FC287D1204182150CD480B92C413F0A56064AD22041F2AB2E60A6B92C4100AC758633D32041EA7874538EBA2C41A89708CFB9D420418932CCB409BB2C41EBCAEB32BBD52041F904996909BC2C41813E19FD12D72041A824B895C3BC2C41F95318EBEDD72041F00F8B10B4BD2C41436F056807D92041F0D18B5E0ABF2C41D2F2AD7702DA204116EF6EBECDBF2C41FEEEEE880BDA2041132036682DC12C41599C5A691DDA20418E95ECADCAC22C41F5D0B3A5BBDA2041B25E0255CCC32C41C4561001ECDA2041B6B3BCD7B6C42C4196860A8FEDDA2041413F23283EC62C4156A81F2EAADA20414AAC7876A6C72C41A935E0B83FDA20412BA1B4DA0FC92C415331B0FF31D920412C41C68F69CA2C41CE2469F22BD820412CC7CDE8E8CA2C413C6299B1D6D62041BDFF0FB878CB2C41DADFA62505D5204186E1EBC5E0CB2C41A710196998D32041A277C1E112CC2C4149CFEDAFB6D12041DC506BD3D6CB2C414F4B731441D02041
13	4346	A	Miami	1	1245000	FL	Miami, FL	4.25620489750145e-05	0.0587055101508808	0106000020E61000000100000001030000000100000028000000A2BF3FC1DF0754C0DE8A7E2DE2D03940294BFED1DE0754C07DFE516E37D13940E25838C5DA0754C09B29EA6993D13940CF6AEED9D40754C0DB1A148BE7D1394055F6ACEAD30754C0B6E2EDD133D2394091B85D81CB0754C0D91A128A3CD339401E975246C50754C0CCB113AA90D3394026025107C40754C01885FDE8E5D3394069B39674C70754C03238B7FA4BD439401E975246C50754C033AE432BB3D439400AEBD3E5C50754C00E6E484310D539402E6D4FC8C20754C0993916885CD539404219CE28C20754C0C9282F2F49D6394099E190B7C30754C01A2B496979D639400AEBD3E5C50754C0A89054BBB3D639400AEBD3E5C50754C0BAD45CFCDAD6394026025107C40754C0B8AB69740DD73940AD8D0F18C30754C047FFFCECB7D73940C9A48C39C10754C0025B2DC9E4D739400B257245B20754C0394B8F0EDED7394086801BE0A40754C009E015AAE3D739404B7C9FBEA60754C0A89054BBB3D63940A5AFE56AAB0754C05B40271FE3D53940A2D9638CA90754C0D5723234C8D53940A2D9638CA90754C0FAA7E43475D53940C931614DA80754C09900ED6F52D5394021FA23DCA90754C019B3954635D53940DD8AA9F9AC0754C0E7856496F7D439401724275AAC0754C0B9FC10E6B9D439408E2DE52BAA0754C07725E6C665D439407216680AAC0754C0A813FCC2EDD33940F178F3E4B20754C0C3C33AA93DD33940B5097902B60754C09E48A070DFD23940F7BABE6FB90754C049F2207AA8D239406A2F005FBA0754C00BC598335CD23940C1398E78C20754C0A50D52B3B1D13940F73E5585C60754C0793B76DB7BD13940EFD356C4C70754C0C941D64148D13940DB27D863C80754C0DC7B931BCFD03940A2BF3FC1DF0754C0DE8A7E2DE2D03940	0106000020BC0800000100000001030000000100000028000000F97CC5D42AD42C410A0BA2B8DE7820419BCD310F4AD42C41A1DD87A0907C2041DD16E2E4E5D42C41C9E589038E8020413F73725ECDD52C41D4848ECA348420416FC02D41EDD52C41DF4FC82083872041C723776D2BD72C41407F56BCFD922041A0A758641FD82C41A311A98CA49620413BDDE11C4BD82C4153754875569A20417E8290F1B9D72C411A259DB9C19E2041D93EB7DC09D82C41178DABEC3AA320410D5D91F1E9D72C41C997BB6243A72041C657626161D82C4168A48B3892AA2041D3C515DA68D82C41CDF3096CD3B42041A61B9CBB26D82C412B9148F4E9B620419C1286D9CAD72C41DF2ABF4770B92041E6A886F0C7D72C413E8E24B323BB204198696B3F0FD82C41CF3B500554BD2041BB1E8B2128D82C41C4C14A32B7C42041D11917DA6FD82C41D2277B4DA9C62041A9495CBCC8DA2C41E51BDEAD62C620410363C329E2DC2C41BC9D4E7BA4C62041EB6091B2ADDC2C4177DC39A678B92041B763779001DC2C411910A96A6DB02041C1A99B9D4EDC2C417313695643AF20419E0DA6C754DC2C411273EDB3AAAB20410A1A0E6689DC2C41E5A3145D29AA2041BCAADC044DDC2C417C2ABB79E5A82041E3C40D82D4DB2C414199EC5E38A62041C1C4831BF2DB2C410FABE5438CA32041A15802EB4FDC2C41C48785BEE79F2041E6AA92C50DDC2C41F53AD5FDB39A2041A78585A007DB2C418C857BC8109320413ED45E8491DA2C41334D8FD0FA8E2041B11486FB0BDA2C41CFAC6A3A988C20412345AA1BECD92C41B8C47EE74989204193B5D279B3D82C41D8F6337AE48120410171D3D314D82C4169CB1E258E7F2041B089789BE6D72C413A333072517D20410CDAF78ED6D72C41358D627311782041F97CC5D42AD42C410A0BA2B8DE782041
15	4348	A	Miami	1	1245000	FL	Miami, FL	0.000117454532755801	0.136094513939477	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
14	4347	A	Miami	1	1245000	FL	Miami, FL	0.000394668675426146	0.340385021618095	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
16	4349	B	Miami	2	1245000	FL	Miami, FL	6.94844336521783e-05	0.0459825117024053	0106000020E610000001000000010300000001000000100000007A223E66560C54C007E5CAA8CBE439400D850ACC120C54C035B0A981D3E43940F92BC21F0E0C54C0486165D47FE3394087B780300D0C54C0A50AB67932E33940EDEA41800D0C54C01999BD0991E23940DF0C18D3F50B54C01926B83089E23940461005389F0B54C02896B9CB8EE239405ABC83989E0B54C08D8A4F802FE23940622782599D0B54C0476E8A1DC6E139409D2BFE7A9B0B54C02A792CFF9FE13940B1D77CDB9A0B54C03589EE173BE13940CA7ABD3DC00B54C0687103943FE139402AE79076F10B54C00838E29B36E139401A7CCCCD380C54C0DAF7CF84BAE239405FC9F5B9510C54C07CAB67B57EE339407A223E66560C54C007E5CAA8CBE43940	0106000020BC08000001000000010300000001000000100000007AE04EF28F1F2C4194A00388975421417C9BF375282A2C410F6D7C4FFF5421416FF0994EFB2A2C412F1079AB48462141030AB61F262B2C41292C70DDEE422141295641B2242B2C417E684613F03B214188EE0D80DB2E2C41659E8DE89E3B21410066E8146F3C2C4128C47FB1F23B21416A9951AE8E3C2C410519E4CFD1372141CC3852FCC73C2C41C383E12641332141B0396FA5153D2C411D18DBCB9A31214116BDA0A2353D2C414D41BDB33B2D2141D53287D758372C410E7F1A1A642D21419A47FFD2A12F2C41620DCE58F42C2141FA44AEE057242C412AABCC75B13D2141E092113762202C41926CB77E2B4621417AE04EF28F1F2C4194A0038897542141
17	4350	B	Miami	2	1245000	FL	Miami, FL	3.95234026200342e-05	0.0354086946512567	0106000020E6100000010000000103000000010000003000000086801BE0A40754C009E015AAE3D739400B257245B20754C0394B8F0EDED73940C9A48C39C10754C0025B2DC9E4D73940F684AB57BF0754C0386AABB01ED83940C7204A90BE0754C09E1FF6BE48D83940C7204A90BE0754C0075A24AE62D83940AFF7A6DFC10754C0F7A03579A9D83940AFF7A6DFC10754C036087101C2D83940AFF7A6DFC10754C0C9226757DDD839409BEC8DC4C50754C00841B28D33D939403D72FAC6CC0754C05DB6CCEC6AD93940A2C3CA08D20754C07959325F8FD9394092D63B83D60754C0176D1966A4D939406EDDCD53DD0754C029056650B0D939400776ABD0E80754C0F81AD8E3EBD9394017FF28FEF00754C01941A28A14DA394069F7200EF60754C0E3B5368043DA3940A90D3339F70754C00B8AAD545BDA3940B75B62CAFF0754C057E6D938A4DA3940F2A1A976040854C0A4A8F1DABEDA394001A219F1080854C0671ABA11CADA394022543ACF0D0854C0346ECFCBDFDA394025FBD117120854C036F136B8F2DA39407FF3C927170854C05AD407A913DB3940A6A5EA051C0854C0D5031ECC31DB3940CB667BE5FB0754C068F443B63DDB3940D723656FEF0754C0D5031ECC31DB39400B0A6224E40754C0AC719C4620DB3940DD574146DF0754C0D4B755DB10DB3940AE1CA33AD20754C0C8A1E8FBD5DA394073D65B8ECD0754C0B8071AADCFDA39407158F77BC10754C06753DB71B6DA394059A64618C10754C0433114D865DA39400BE2BA64A70754C0C94DC6A568DA3940173B9396A70754C01E9F8CE236DA3940BDCBA839A60754C01764A07219DA39402B46ACB1A30754C0545944AFE7D93940E98872B8A20754C0B82EB30AC6D939408567D7F7A00754C07A36372F99D939403F51C5CC9F0754C0D4BC18076DD93940C19B033E9E0754C02BAD696C1CD93940B124A1769D0754C099B015FFBAD83940CD2F2A0C9E0754C0A893D75792D83940279F14699F0754C03300474761D8394037167730A00754C0672A46A23FD839407A0EFFC5A00754C03D185B961CD83940B92411F1A10754C0288F65100BD8394086801BE0A40754C009E015AAE3D73940	0106000020BC08000001000000010300000001000000300000000363C329E2DC2C41BC9D4E7BA4C62041A9495CBCC8DA2C41E51BDEAD62C62041D11917DA6FD82C41D2277B4DA9C62041EDF2E521B7D82C41EA0B5D1A2CC92041C62B3948D3D82C41DD9B7DCFFECA204178FEA85BD1D82C4149F1AD7B1ECC204105B7503647D82C41E6ADC7DB2ECF2041240E776445D82C410DB564FA3ED02041F4435E5D43D82C41902653326ED12041005E47A0A0D72C4159C3707229D52041326F7F1A83D62C418C514FC48DD720412F3C6357ADD52C41037077A320D92041672F84FDF7D42C41AB8C27AD08DA204134C13183E5D32C41D42988048BDA2041677C05E613D22C413BBA4AC71CDD2041CEF77594C8D02C41271BBD82DDDE2041343C68DEF9CF2C4139D8B20BE5E0204104D0B834C9CF2C41B73D4410EDE120419A5CFAE06BCE2C412263294F13E52041C63F384FAECD2C41FD2A227C39E6204189B324B2F9CC2C41C6C983ADB4E62041BC3F63AC34CC2C4116F13F61A4E72041640A194F87CB2C4172EC442475E82041C38034A5B9CA2C41B70F202EE1E9204141B28F01F4C92C411EA4152C2EEB20412F7C1EDFFCCE2C4113A1D2EABAEB2041C3639104F2D02C419CDA15173AEB204195481CAEB8D22C4105F66CC27AEA2041B80D1B3D7DD32C41A938AD07D1E920410C54CD518DD52C41C520387D47E72041BB28736349D62C41B19C1EC602E72041FB5716E62FD82C41030B5723EEE52041092C518345D82C4105F4883070E22041588B09214DDC2C4162E1FD3196E22041BC45D20249DC2C41046250286EE020412223E8EA81DC2C4166D4E7FE27DF2041F3C7CE3CEBDC2C41223884AF00DD2041A374E5D214DD2C41132BC6C48BDB2041B09732835EDD2C4104986AAA9AD920415DE2CDB290DD2C416F436B2DB1D72041A43F9E3AD5DD2C411887318133D42041025868BEFBDD2C411CCD7604FBCF2041B1659F50E7DD2C41938443EB37CE2041BBAADE3DB4DD2C411A7FFB4E17CC20416ED90C7997DD2C41F017C1E6A1CA204194916FA082DD2C41648DBCFE1CC920410BB14B0655DD2C41E0B0604E5AC820410363C329E2DC2C41BC9D4E7BA4C62041
18	4351	B	Miami	2	1245000	FL	Miami, FL	0.000160384328410146	0.125445019941203	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
19	4352	B	Miami	2	1245000	FL	Miami, FL	1.21364475944574e-05	0.01288898860552	0106000020E61000000100000001030000000100000018000000718BE5D59A0954C08AF81AD8E3CA3940AD2A10DD960954C046C81BD5F3CA39409D657E848D0954C096C3EA8005CB39409D23B3F9860954C049627FA904CB3940C50AFB99810954C0AC6D8BC5FECA39407341ED1F7A0954C0AED27690FACA3940E29DE1A5720954C0D867615EE6CA39400DBA45DF6B0954C034741EDBD3CA394002074A90650954C0C937A6EAC8CA3940E3D77F055F0954C0F79206CB99CA3940F3DC661D5A0954C0363AD87C8BCA394065B042C7570954C0A74AA12E7DCA394065B042C7570954C0EC92F50B5ECA3940F21E32A8600954C00B04490539CA3940D6498011690954C0ECDBA5FB23CA3940415F27466D0954C0FD06931A0ECA3940F1265FD37A0954C0597B963608CA394072241EF0830954C0F8BC200B19CA394052BBB505910954C0688627D034CA3940FEB7092C9D0954C0E860D8D659CA39400ACA9F35A00954C02DC8C26381CA394069CDB060A10954C099B917E4A3CA3940C3B38D0A9F0954C0C50589B5C4CA3940718BE5D59A0954C08AF81AD8E3CA3940	0106000020BC0800000100000001030000000100000018000000022659FF168F2C412B37EEBAEE352041F2904D65B58F2C417D76241BA13620417B991A872B912C41A6E5FF8A673720417D9AA15D32922C41C11C46E85F372041D0BE03A40A932C41E732FBF61F3720414472C54237942C413D000F3DF3362041DF6C2F0765952C41E616D92A15362041A0719C8576962C415624FF9449352041D174FFB374972C41D951C2E1D1342041D229E6DE7E982C416E2533E1C8322041B9746EFC44992C41EC888C7A2B3220411515B1DDA3992C41AA4537688D312041D1071A1BA6992C41C9C2AA0B34302041BCAC0F2244982C41FE211308972E204148815FC7F3962C411BC6EA7CAB2D20411944BE6A4C962C41A9E96FB4B72C20414B94317F2C942C41632399D7722C2041AA0F4944BD922C4154A1F1282B2D20418D3592B4AD902C41268076CA5B2E204147BAE206C38E2C415F6DA757F32F20418FD97430468E2C41EB42F841A9312041A1D5A6CB148E2C41E054B2A627332041DF28D84B708E2C41F1EA6E4894342041022659FF168F2C412B37EEBAEE352041
20	4353	B	Miami	2	1245000	FL	Miami, FL	1.43460288200004e-05	0.017210650365436	0106000020E6100000010000000103000000010000000E0000003677F4BF1C0C54C02AC8C31A65C23940FFB956E51C0C54C0EAA943F23EC239400A132F171D0C54C0277C40FE24C23940512941421E0C54C027840EBA04C23940D3859A19240C54C0E525255BE2C139403DF5646B2E0C54C0D7B19D31C4C1394029735903360C54C0D7392F2AB6C13940170BA155560C54C0893C861DFFC1394069DAD5A9670C54C0173311692DC2394093814DE7740C54C0BD20767B50C23940E53949F08F0C54C08259D1818DC23940E5F77D65890C54C01D9D057EADC239407598DE7A640C54C005B47204B0C239403677F4BF1C0C54C02AC8C31A65C23940	0106000020BC080000010000000103000000010000000E00000000126BC8F32A2C418551D24023AE1F417451C584F02A2C419BE2C3ABD4AA1F41DB8E4B77EA2A2C41FCBFE5D294A81F41973290BABD2A2C41853B2371C8A51F415833BC61D5292C4108607A11CBA21F41A0576CD038282C410BDF33D928A01F41AB825AAB08272C41B76013E1ED9E1F41B25DBB14F1212C41AF28A94E30A51F417EE64DB1351F2C41E4B66BCE2AA91F41207E725A1F1D2C41D8483C582EAC1F41B2D81D03DD182C41EA4BAADF6AB11F41F4A958B2E1192C4147E024A533B41F414BB895BCAC1F2C419F6762C87DB41F4100126BC8F32A2C418551D24023AE1F41
21	4354	B	Miami	2	1245000	FL	Miami, FL	5.04947604440531e-05	0.0464796704310464	0106000020E6100000010000000103000000010000000F000000D1915F49160D54C0A83E113D09C3394033BACD65D40C54C01378501ED0C13940756C3565330D54C028728B70C8C03940D24D9048430D54C0DCB966C214C139407EE071240C0D54C026049907AAC13940D20BC5BD3C0D54C0743EE1919DC2394053440C8F8B0D54C0F8A87116C6C13940713938BAA50D54C007CB76A44BC2394035B952AEB40D54C0A9A32FF929C239408D81153DB60D54C0B8E6216269C239408D81153DB60D54C014A3ACB4CCC2394096B38671880D54C019BA193BCFC239401D3F4582870D54C04838B96813C33940B109EAA01A0D54C0DDDF71821DC33940D1915F49160D54C0A83E113D09C33940	0106000020BC080000010000000103000000010000000F00000087CA28F3BE032C418D6F8245E2BB1F410F30343B2B0E2C414A913CFDDFA01F41FAF112F853FF2B41751F565FD8891F41EC9A3D7FD0FC2B4108AEAAC76D901F4117E17A0A6E052C4136A125EA779D1F414D301D25BDFD2B417C844A1C7BB21F41938C44C06CF12B416BF3ECD4A89F1F419F00157E48ED2B41D77A51112FAB1F41FBEEFCEAF1EA2B416EC359FB3CA81F41150C6024AFEA2B4105CF43EEBAAD1F41A88E4E93A8EA2B416D2D405056B61F4187872054D8F12B41A7E4DE4DA4B61F411C21905AF9F12B41E24FBE3A8DBC1F4111B695250F032C41C44CA6DCA1BD1F4187CA28F3BE032C418D6F8245E2BB1F41
22	4355	B	Miami	2	1245000	FL	Miami, FL	2.71132537363883e-05	0.0220604687493714	0106000020E6100000010000000103000000010000000B000000E9CEBDCE000E54C01BB6E7F299C83940CE16DB67FF0D54C09B0B22BAB6C73940072384B4170E54C0BEB00569B8C739408DB66FF0300E54C007BC4878ADC739407550B26A6A0E54C0EA1F2E94A7C739407550B26A6A0E54C05B69A6509DC839403621ABC3600E54C03C65B7DB9DC83940AE767F824C0E54C0777781FF9EC83940BEDA0055440E54C029B00B16B9C83940294F4244450E54C0F9EAEF140EC93940E9CEBDCE000E54C01BB6E7F299C83940	0106000020BC080000010000000103000000010000000B00000059912AEF92DE2B41AFD772C9731B2041C35A6432DADE2B4176B262C19B11204167C2DAF509DB2B415C212FA4A81120413EA3060215D72B418EEE834B291120414F3B047A10CE2B41B4FF4957DA102041ACF2D97100CE2B4159DF5A11801B2041F87FAC2484CF2B41F01EF85F881B2041EEA630AFB1D22B41BF8E96CF991B2041F932B978F8D32B41F7AB8A1EBD1C204198A11D5ECDD32B41B9AD7BAD6B20204159912AEF92DE2B41AFD772C9731B2041
23	4356	B	Miami	2	1245000	FL	Miami, FL	4.18546073888137e-05	0.0362642365500542	0106000020E610000001000000010300000002000000080000004ABAFE0ED90E54C07AC88D9CB1C53940A5FC23EDD50E54C0D8C60A44F0C439403682B0FAD30E54C056A44DCBCBC439402A29D8C8D30E54C01B1C46040DC43940EF5B91BE470F54C06794F90AFCC33940D61A967B4B0F54C0F96222B73CC539402D785A494E0F54C0A425709AA7C539404ABAFE0ED90E54C07AC88D9CB1C539400900000047FCBD26010F54C0F9427FA348C539404A2C6322090F54C0677B25BE4AC539401BC8015B080F54C0D44FBEF484C5394049B1A974290F54C0EDAF5C587FC5394049B1A974290F54C0BD33A3FEFEC43940F00A38DC0B0F54C07D69D11C08C5394056853B54090F54C00CAC446907C5394076601FEE010F54C0273FACAEF8C4394047FCBD26010F54C0F9427FA348C53940	0106000020BC0800000100000001030000000200000008000000624D6B5FD4BC2B41224533EC00F61F415C7912B55EBD2B410DCF742F41E51F416A53C449AFBD2B41C1FDB10119E21F41B4066C72C3BD2B418F48E7DE90D11F41469265CC91AB2B41AC3B8D41E2CF1F4164569B11E7AA2B41D865C658AAEB1F410FF2AE956FAA2B41BF25D241ECF41F41624D6B5FD4BC2B41224533EC00F61F4109000000D1CEDC7A90B62B41BD479F72D5EC1F4127F42CA34FB52B410220726600ED1F415FD5432D6BB52B41C4723E2C0CF21F4104603FC939B02B41D0067A4780F11F4157C7C20742B02B41CF2284F060E61F41D43AD86AE6B42B416D2470FF38E71F4114A2B2264CB52B41B4CE849E2AE71F4108E0E05776B62B41A0560953E7E51F41D1CEDC7A90B62B41BD479F72D5EC1F41
24	4357	B	Miami	2	1245000	FL	Miami, FL	0.000222232522446575	0.140671242556229	0106000020E610000001000000010300000001000000360000008D81153DB60D54C0B8E6216269C2394035B952AEB40D54C0A9A32FF929C23940A3A6192FD60D54C0C88C160519C23940A3A6192FD60D54C0FAED2824D2C039404F20C1942E0E54C0BEE7D755CFC0394061D46C20480E54C0094D29E7BFC039404147B817580E54C07D537AB5C2C039400D138CD15A0E54C0722B6B38B8C139400FC9931B3A0E54C03313F802B4C13940C55919393D0E54C027BD954390C23940BFC12B0A5A0E54C0F6E0D91193C23940EEC05F7DB00E54C0F6E0D91193C23940571DD95FAD0E54C04549E0C0F8C1394049BD8E689D0E54C04549E0C0F8C13940BB551C769B0E54C06823F1E882C1394045DBA883990E54C0A4472B754BC03940D1518B77760E54C0C9F5D5A648C0394019E35650570E54C0D79FD11151C039400EEE8F764A0E54C066ABA2AA4FC039407BDB05B02C0E54C064E6F82454C03940BD4C05F6270E54C0477FC69E20BF39407B3C25CE270E54C0EDF430B9F3BE3940A15C97D0330E54C0F45A4841E9BE39407138EEF23F0E54C0ECB28EADDEBE39403A993E8F3F0E54C008F90E021BBF3940AD94C1F8790E54C0F8CEACC80FBF394095454009FC0E54C0749979F605BF39407E938FA5FB0E54C0591B1F5194BE394052FE6CE63B0F54C08B89961B90BE39406275CFAD3C0F54C0F8CEACC80FBF394056F0885B1C0F54C0F8CEACC80FBF3940CA2EE8221D0F54C007925E7144C03940DE115A7EDC0E54C0B69E000E4AC03940DE115A7EDC0E54C0D7D5B5EECDC03940D18C132CBC0E54C0FAED2824D2C0394027DE73F3BC0E54C0FD343D5B99C13940D902EA7C010F54C008E763F090C13940D902EA7C010F54C0E9B7D011D0C139403755D6BABD0E54C05315F778D1C13940FB20AA74C00E54C038C13A4C03C33940DDA981C5050F54C0E9D6D816FFC2394032FBE18C060F54C0E30927E3C4C339409F4977E4E30E54C07835C0E6CBC33940DD6EF910C00E54C0E30927E3C4C33940757A58E7990E54C0F86EA27FCAC33940ED85D7C86A0E54C003B4B21FD7C3394051517EB03E0E54C006EA650CDAC339405DC2AE743E0E54C0697D6FBFBBC339405BE2899F0D0E54C0EA48D845BEC339406753BA630D0E54C066BC508192C33940612EBE08FD0D54C0BA3460D290C33940EAA7E60FF90D54C0D461130656C23940B1B80CF3D60D54C0B96A6EEA5BC239408D81153DB60D54C0B8E6216269C23940	0106000020BC0800000100000001030000000100000036000000150C6024AFEA2B4105CF43EEBAAD1F41FBEEFCEAF1EA2B416EC359FB3CA81F41489F46F3B0E52B41CA4A2FDBB4A61F4149C62F81C6E52B4173115B57618A1F4134A50DEAE6D72B4151B5B303F9891F41FAB6D681E5D32B41E87B2F8E96881F4137F026D063D12B4171DB873FCD881F412CDB2344E6D02B41BC29A268129E1F417AEAA7D008D62B4128739786C49D1F415EA0DA3C7DD52B41222C0427D9B01F4108F30F46F7D02B4161E6D3C009B11F4126D19FEF65C32B41F55A7003E1B01F411411BA1BEDC32B412ECA3A1C83A31F417969AB976EC62B41D5355D9D8AA31F41B1DB2579C4C62B4126B5CF4755991F41610E6CED26C72B4125AAA5EA587E1F41B35C7053A7CC2B4116CA432D2B7E1F41A5AFFA858AD12B4162A0FFA1F47E1F41BABA00F68ED32B41F2AB3096DB7E1F41FB5FB70F3BD82B410B5EC9084D7F1F4132A0F21E0DD92B41435A6122A9641F4137E3055216D92B411CD3C136C5601F41307F5F6F34D72B41C2AA3249D75F1F41F268AB8C4DD52B41849BD5E4E65E1F41538E964059D52B41548FF47121641F4191F8C7DD2ECC2B418F55E3D70C631F41687BA33FC5B72B4162BA45F6F5611F41E5064037DCB72B41D2BEEF041D581F4161D6FD9DC6AD2B416F9BCBBCA1571F413C49E9239FAD2B41056ACDBEB1621F41FC2D97E0B1B22B4157521CC5C0621F415E370EC17EB22B41622A64B57F7D1F41F79DDBC3A3BC2B41C031BB5E1A7E1F41782E723F9BBC2B417D7138F487891F41FBFBAFA3ADC12B4155D71477F4891F4114C07F7281C12B4174C7C780379B1F415A7D2144C0B62B415C3FBCB45C9A1F41A10D4233BCB62B419C57D132D59F1F414E1544855EC12B41F0C09F0514A01F41B245B032DDC02B4118C95D3293BA1F41E2FF1795FCB52B41BABCE66815BA1F41EC571B8ED0B52B419358DF0339CB1F415F2B978240BB2B41DB4F51CEE4CB1F41A18DAA4EE0C02B4159720FFD59CB1F41B36D4128DDC62B41AF714066E8CB1F41554A696241CE2B410C1A48B116CD1F410A4A72BF2CD52B415783526F6CCD1F416B82E51D38D52B4174A8395ACCCA1F4122D06BD8E1DC2B41A77B808E1BCB1F411673401BEEDC2B41EB8E28B850C71F41E13D81507FDF2B41C86A6E2933C71F41581FF99933E02B4192767988EDAB1F412F2519C98DE52B41C1F4688480AC1F41150C6024AFEA2B4105CF43EEBAAD1F41
25	4358	B	Miami	2	1245000	FL	Miami, FL	6.95663907208655e-05	0.0411264313169445	0106000020E610000001000000010300000001000000240000007F4822A8F80D54C0B47FA5C0F0BD3940AA965E42F50D54C0FB457E4ED8BD3940AA965E42F50D54C04CB6FCFFB9BD39403FE051C8ED0D54C044E057CB6EBD39408A78FFE0E20D54C0361E46EA38BD3940FC1DA131F60D54C08884FE283BBD394016D24CBD0F0E54C0F31B6DEF2FBD3940053E1BC6180E54C0477C66CA00BD3940F1D367F01F0E54C0D8E0ABD4EEBC3940B6CFEBCE210E54C0987B25E9CABC39405749F4CA260E54C0B6FD9056B3BC3940E957FE052D0E54C0D47FFCC39BBC3940FD4548F1320E54C0C552EAB37FBC39400BF3113D380E54C0E6A39F9975BC394089EA9E56400E54C0E8BE863B72BC39401E2327B3440E54C09218C5F14ABC39403211719E4A0E54C08A361EB83FBC39408F5DCA42590E54C0998461793DBC3940DD915BDA630E54C075A2BA3F32BC3940295B69546B0E54C075A2BA3F32BC39403BDEB47E720E54C03AEB4C1B3ABC39405637FD2A770E54C066AF9A8E50BC3940A1950CE47F0E54C0A9C70F0C55BC3940916CD9AD870E54C067CA81304DBC3940DAB265C1900E54C012B5D44496BC39403DEDC3E9A00E54C039CCE95C18BD39405904410B9F0E54C05675BA3360BD394011544689A10E54C03886B90A4DBE394093F18096540E54C0441B85C6C1BE39407138EEF23F0E54C0ECB28EADDEBE3940A15C97D0330E54C0F45A4841E9BE3940B92904C3300E54C0656FDD58C6BD3940C5174EAE360E54C0C572AED55CBD3940215598E7160E54C085FA0F49AABD3940BDC673B8010E54C0A9DFC50FD6BD39407F4822A8F80D54C0B47FA5C0F0BD3940	0106000020BC080000010000000103000000010000002400000057ADD0DF8DE02B41737152996A4A1F4129137F0118E12B416E3E45E84D481F419E5096FF19E12B4139C80395AD451F419716EF634BE22B41410E0BC72C3F1F4133C1201705E42B4189E799B7863A1F41FAFACBC7FCE02B41ADC85450AF3A1F410DEB08FBFADC2B41D9F32F25AA391F413A20340793DB2B41E2953CFE8F351F41118F8C4574DA2B41AA74EB2AFE331F4144A1DA822BDA2B418007C46DE0301F41A6C28FC064D92B41F3F0C820D32E1F41636C9AEA6BD82B414F19C53CC52C1F41129442E47FD72B4159E496E2532A1F41CFC277BAABD62B41DB1DAB4171291F4138982F7466D52B411722B9B622291F410BB9D1C0B9D42B41256D7814B9251F41A174869FCCD32B41D8F73342BD241F41D6A1D25E80D12B413C24DB8784241F41917BB773D7CF2B41BBD3D08186231F41FCE6EBFDAACE2B41CC5253FA82231F41D132608A8ACD2B416D7DBDE92D241F413F94E64ACDCC2B41315BFEBF1D261F4185C635776ECB2B4143A7283F7D261F410E9ED5FF35CA2B41E340B943CB251F41475BB583C4C82B41346003301C2C1F41FA2DA6C632C62B41AD0DA7995A371F415B20703A79C62B419E33F528953D1F41DC0E68B705C62B418CF5680D1A521F417820711D12D22B41F0529EF35B5C1F41F268AB8C4DD52B41849BD5E4E65E1F41307F5F6F34D72B41C2AA3249D75F1F412FEFB826C2D72B413308BD36A3461F41710A7D33DBD62B4164B7D2B67B3D1F410D17FD06D3DB2B41064695F640441F414A68FC6923DF2B412990B92B16481F4157ADD0DF8DE02B41737152996A4A1F41
26	4359	B	Miami	2	1245000	FL	Miami, FL	0.000132702513155891	0.0684885175025663	0106000020E610000001000000010300000001000000270000007EC96359321054C0066365B039B8394077D6A6652F1054C02CFC0AFAD4B73940474A9EDEF10F54C0DDE82C927AB83940BD89891CAE0F54C0660AF68FA0B939404F6EE821AB0F54C09D6D503DCAB939409A4861C5A60F54C01DD0054EE6B939409540349A8C0F54C0BAE189FD3EBA3940E1E11FB15B0F54C0060A40CC73B9394025402F6A640F54C0DECC079C56B9394047DB42A16F0F54C0F9F64B1724B93940C53DCE7B760F54C0F446F7BD17B93940A3EDFDE5910F54C0386ECC5AA6B83940FA8C8D3E9B0F54C095862E698BB839400D7BD729A10F54C0DCB4F99671B839406B439AB8A20F54C07975261E64B83940D60A125C9E0F54C0FA60083637B839400D7BD729A10F54C0AD8A2CBD29B839403DA9D16C9D0F54C07909470A11B8394015E6D5EA9F0F54C017FEA68C0CB83940D2765B08A30F54C0C807995201B83940DDB7DBA7A30F54C01806EB9AF1B73940F9CE58C9A10F54C029C4D860E6B73940502C1D97A40F54C00735146FCBB73940A179C126B90F54C036AA04B97BB739404DE94039DE0F54C007A3AED605B739400D9213C0E90F54C028C03636C9B639409AF49E9AF00F54C0B4FB887194B639403F032479F20F54C0471C7BD54EB63940E67BE189F10F54C00AED6D2B24B63940ED3916FFEA0F54C00C51A74BE5B539401260A28B171054C058EA4274D4B53940CEB689492E1054C0A94BB093D5B5394031C0CC77301054C0F3579DDCBCB639409D54C2139A1054C02463C424ADB63940D35989209E1054C074BB805F6FB7394047AC7919BB1054C07A7A45016CB7394011E97D97BD1054C0AC76715538B83940A7C0D1A7581054C0B661DF113FB839407EC96359321054C0066365B039B83940	0106000020BC08000001000000010300000001000000270000008560C5847D872B416713FFD398CA1E416BECD67CFA872B411D8DCCFADFC11E41BE1666EA98912B41655D6D9055D01E41FB507580299C2B417CC5B182EEE91E41AC15B9949E9C2B4147709E718CED1E41212293144C9D2B41B0A4500CFDEF1E412E89651F62A12B41BF24197FB8F71E416DF64ABA1CA92B41646A007A33E61E4127380406C0A72B410B778BEDA7E31E41C7CF9A8300A62B41E90D490B42DF1E4163D768DAEDA42B415BCF08EE2CDE1E412F73B244A7A02B41ED3FE6E74CD41E41941D0C5D319F2B411751B1E1F2D11E415A8F9B1C459E2B418D2BE457B3CF1E41220F235D079E2B414723EDC387CE1E410DB48081B99E2B41460BC590A5CA1E41BE319DAC499E2B41FCAA396979C91E411595EB7DE19E2B414A8A0B3757C71E4114F0539C7D9E2B4144BE3372F2C61E413EEC7C1D019E2B41AA066EF5F7C51E41227C6412E99D2B41E5B210FF9AC41E41142CDCE8349E2B4165A710CDA2C31E416DEEB3EEC59D2B416E9854C74BC11E41F4E05B9A909A2B415036BD055ABA1E41EBE11D0CC6942B41178FB5E411B01E41A71BDA96FA922B41F11BF1ADCBAA1E41EFAFF272EA912B416E169EF035A61E4158F6A0B5A3912B41B195DADF2CA01E415FDA23F7CB912B41BC4EB4D77A9C1E416002D3E2D6922B41C36AA30A0B971E413D7D4558D98B2B41E6E54C1981951E41B26F983047882B4187A940A78F951E41E18DA306E1872B41280F8E7499A91E410E6C42464D772B4194B105F20CA81E41E8BCE26A9E762B414071D5E0DFB81E4165CDE02B12722B41CC292E1E88B81E4155D4C453A1712B41906E95CC3BCA1E411FFDDA9D79812B41485C0ECDFECA1E418560C5847D872B416713FFD398CA1E41
27	4360	B	Miami	2	1245000	FL	Miami, FL	8.05245465471671e-05	0.0625108181799737	0106000020E61000000100000001030000000100000017000000E75F1E74010C54C0FA117B8C65DB3940454CC1615C0C54C06DD9D66D55DB3940412E37CC5B0C54C0B6AF4148DEDA3940C1EB30AF6E0C54C0765CB0FBDEDA39407DA1B227820C54C08744C52BD5DA3940C695735C9F0C54C039079A92D6DA3940F6F9D423A00C54C0085F84AF83DB3940112A5A14B10C54C0F782C3C985DB394076F21CA3B20C54C0CC1D1A833FDC39403DAA41FBE50C54C03921A04E3BDC39407B49F15EE60C54C047D4196688DC39402915559EE40C54C0C94EEF5EC5DC3940325169C9E50C54C0D8445CBCFCDC39406D0EA3C2E60C54C0B68506FA75DD394075CC622AE90C54C0CA4CE10989DD3940D1F9F176E80C54C0BAF9811D12DE394079A2E408EB0C54C0DD61CFC211DF3940227C1336A80C54C0461C942B1ADF39406AF1BF1BA60C54C0720EA67A15DE3940A907D246A70C54C0635DB67FE0DD3940A554D6F7A00C54C0B8CDCB96E9DB39405A3DB6B1EE0B54C0E859C23A0BDC3940E75F1E74010C54C0FA117B8C65DB3940	0106000020BC080000010000000103000000010000001700000095627733862D2C414486C34D6BEC204127F179FD441F2C412BFA9800A2EB20410FDBD08E641F2C41D914518A78E620413B22924B6E1C2C414CCA4EA97BE62041AFEA334C61192C4194CD1E080AE6204190F7D1B4CC142C41FD10336812E62041651FD5B4A1142C419F6C436D92ED204166B2F487F9112C4112B48098A5ED204165D4786DAE112C416676574FB1F52041DFF5DA8EA1092C41011FF11C76F52041CE355CBA8C092C4117914A23CDF82041EDBE6DF6CE092C41FEBEC4E171FB2041274AB0549C092C41F2B6E3B7D7FD204153D317136D092C41FD66855018032141B16A973C0B092C41F9BAD22AEB032141CC6374211E092C41E2F2BAD3DB09214137A8EAB9A5082C41AC4325E3EE142141E6A118741F132C41E8C51F835C15214146BCF88785132C415BF6A85F110A2141E5F3033A5A132C411818B86AC507214121A9C18D79142C41211EC38FFCF120413E0A10EA6B302C417C9D48BD9DF3204195627733862D2C414486C34D6BEC2041
29	4362	B	Miami	2	1245000	FL	Miami, FL	4.57515111520479e-05	0.0327531576141459	0106000020E61000000100000001030000000100000005000000DAB18D4F131254C059912FBA1FBC3940CF2E42250C1254C066D0C985DCB8394059DC75F2461254C0822A0DB3D2B83940EAAF31914D1254C009B9EDA31CBC3940DAB18D4F131254C059912FBA1FBC3940	0106000020BC0800000100000001030000000100000005000000899A4F1DBF3B2B41785150B43E201F411D19C873113D2B416A3967CCE1D71E41A4CFD2D0D6332B413FBF473DEED61E410EFBB73B9A322B4159CD0CD3E01F1F41899A4F1DBF3B2B41785150B43E201F41
30	4363	B	Miami	2	1245000	FL	Miami, FL	0.000241876394056817	0.146594308763939	0106000020E61000000100000001030000000100000031000000210EA598111154C0F4D03C55C5BF39407E6B6966141154C0E84EAE4565C03940FB21154A6F1154C0BCA5F6E5F6C039400A4CF8BC7A1154C02D8933A00DC13940D2BE63BF811154C067797C4D1FC1394009D08ED2871154C06A0273AB22C13940CE0DDE3B901154C0F8661A9B3DC1394029511DA81C1254C04C704B742EC13940BA482565201254C07A36343035C139405A161452331254C0688688401AC139405AB77997361254C047003D420AC13940599AAA67401254C0B4A84047DAC039406D945859481254C0D6E2F68CC3C0394089ABD57A461254C026FDC2CD57C0394059DC75F2461254C0A58E3AAC83BF394049D78EDA4B1254C0D73AABE467BF3940A5C2529C441254C05D17980B98BD3940C19704333C1254C007556DAECFBC3940DAB18D4F131254C059912FBA1FBC3940EAAF31914D1254C009B9EDA31CBC39404E30670C4C1254C0E53E206D6FBC3940BEDA0F80511254C0053A860CD3BC39400998B9F3561254C017F563890ABE394049AECB1E581254C0F88D7793D4BE39408BF412CB5C1254C09C1E89E86EBF39408BF412CB5C1254C01D7B403196BF39408BF412CB5C1254C06CA732481EC03940B21D26F65D1254C0DE8B569FBFC03940ED636DA2621254C00CDCB529C3C139406FAEAB13611254C0865FFECB34C239405F37494C601254C09ABCABAC5AC23940D9585487661254C03BA4449E66C33940FDEE582A971154C0D7870FE286C33940CAA8117E921154C07926D11E71C23940275B48B35E1154C03B1308BF7DC23940C6391D6D611154C08378F223DDC23940AB5B8E6E3C1154C0393718C4E9C239403D1C69183A1154C0E38CB74E09C23940638F74F95B1154C04957511905C239402D2B13325B1154C0085225BBB3C13940B26B8AE6D21054C03799D762CEC1394047D3FCD8D41054C0AB05DB4152C23940DA5CC0C1BA1054C00DBE52A54CC239403D076935C01054C0EB32B6D0C8C33940AEFC95D5A11054C018860F06CDC33940C107AFF09D1054C07D16AFB9F0C0394029214C75D41054C033D926B2E2C039407390C657D11054C0BB91088DE0BF3940210EA598111154C0F4D03C55C5BF3940	0106000020BC0800000100000001030000000100000031000000D2D9C3F6F9632B41E2C5DB9C97711F4150C977717F632B41D7F35271727F1F4107C5239832552B413892A88CE88B1F41639B7A3365532B41006E16A9DB8D1F41677DAF7C4A522B41A57A06B3608F1F414167DA3256512B41484367B4A88F1F417967119802502B41431F9888FA911F41D4632A7AF9392B41716601AF6C901F414A95BDDD62392B4191C8E96F00911F415003DF146C362B41B4344DA0A28E1F41FFB87C9DE9352B412474B6673E8D1F41BD2C823662342B410C425FBC11891F417AB1376424332B41B233761616871F41954031F875332B41FFED0BA8C07D1F41EE44C5F06F332B4106A662905E6B1F41FD9F8174AC322B418E3EBA2BF4681F41FE3E285DEB332B41B8F0ED61C5401F4174C58A6849352B41BF4E91336C2F1F41899A4F1DBF3B2B41785150B43E201F410EFBB73B9A322B4159CD0CD3E01F1F4171AA404BD2322B4177B3A1FE0D271F417175233CF1312B4176C70BA3AD2F1F419A47AB7803312B41B96CD043A94A1F4122A96A68C8302B4192B63EC52A5C1F41944E396203302B41C0FB676D88691F418B14180701302B41C6D554E6EF6C1F419D259ADDF82F2B41257141E5BA781F415FE58A3FC02F2B41D8FD648BB5861F419F18FBEDF42E2B4118C02E22319D1F41C25AAEB22C2F2B4156BA68A70AA71F41B844E0B7492F2B41A277364453AA1F41EC59F5523F2E2B41DE57A09988C11F415910E361C84E2B41ED02C339AFC41F41B59CED13954F2B411736FD6A9FAC1F41D6B2482CB5572B41CA2DC775CEAD1F41E1A38ACE41572B41C91A777811B61F41356657580F5D2B4118BFF7013AB71F4188AC3C057B5D2B41E71E57ABC7A31F41FB07D8162A582B41F353783C5BA31F41EF85BF5E4E582B41A3828D854E9C1F411B3B03D3B06D2B41E19773B9DA9E1F41A054FD6A5A6D2B41F751B74647AA1F4152AD880773712B418F396F86D6A91F41E0DE655F80702B414D9F97BFC5CA1F412606E26A44752B41AB1989CB30CB1F41DAADE37B0E762B41243D8F40BD8B1F411791C2DA806D2B417BA20B7B6D8A1F418335B8080E6E2B41636BCF3310741F41D2D9C3F6F9632B41E2C5DB9C97711F41
33	4366	B	Miami	2	1245000	FL	Miami, FL	0.000131145978457425	0.064313988728671	0106000020E6100000010000000103000000010000001400000019A70B58C21154C0B6D098C0E2D139406D26211CA91154C013283C4AA0D13940CB411A5FA51154C0879990FF17D1394049278C12A61154C0B8200895DAD0394051CDD86FA41154C0A9C20AC426CF3940CDEA4B39161254C096A34EE020CF394081046F8F181254C0586053DDDFCF3940E373C9661E1254C012BA8DFEFECF3940E9F27C1F911254C07405D6CF6DD1394029A2017DC11254C09C4E977E6FD139401D31D1B8C11254C0F9CB339E24D13940F18AD355091354C067DF572427D1394031A1E5800A1354C08644840DBCD13940371AA406D11254C0758D45BCBDD13940A98EE5F5D11254C088A3FA0121D239402E7C4ABCA61254C0049C310E26D239401EAE569F6B1254C03C27DF7B1ED23940E6DEF6166C1254C0B78C5DB4DDD139407FB2DBC7471254C0ED14D4CCE7D1394019A70B58C21154C0B6D098C0E2D13940	0106000020BC080000010000000103000000010000001400000067460EED21472B413F8905E4928120411E8A7B4E1B4B2B415E930B42B77E2041A3E8D8C0B94B2B41A8994054D07820415F1EBE5AA14B2B414CD65BF12676204108DFACA5FD4B2B418161083545632041F4B6E041243A2B413B45C3D8EA622041946947E0BA392B41B3C4FDC8306B2041201BE769CE382B41969CB5CC886C2041DA742050B9262B41DB078D92547C20415271C1FB221F2B41DFA8FBC65C7C204139086E101E1F2B415D1EB2311E7920418AB2FB13E2132B414CC8DEC82A792041AC0BFE57AA132B41E6EBCA419E7F2041250AAD5FAE1C2B4118530C47BD7F2041391F15EF821C2B41AA0A33350A842041C69F8B664A232B418905B3874B8420411FF823A2902C2B410B8C935D048420415B1C3DC2812C2B413FA296BA358120413643943533322B418E4F7E9DAD81204167460EED21472B413F8905E492812041
34	4367	B	Miami	2	1245000	FL	Miami, FL	0.000104449571608711	0.0551907019423497	0106000020E6100000010000000103000000010000001900000072482684C70B54C0A8ABA6F833DA3940FD756720C80B54C0FB9B0CB258DA3940C56191A8950B54C0E9C517A163DA3940D2ADC511850B54C096CDAFF5ABDA394045A9487BBF0B54C0F8A224C1A7DA3940851EF560BD0B54C08C597B5B8DDB394025C43C8E930B54C0FDFA150A8FDB3940D507DE05940B54C0D8E5F7F128DC39400AA5CC59C10B54C067445D4327DC3940BE074579BA0B54C0C82E38676ADC39409A229A223B0B54C0B75277816CDC39408F052C89F10A54C0849063537DDC39407192F34CEF0A54C0BE8080C495DB3940557B762BF10A54C0F782C3C985DB39407DA48956F20A54C0B424D86938DB3940F618CB45F30A54C04D85BD3F14DB3940E6F614FE010B54C06865383BA5DA3940E2AFC7AC0D0B54C0369A4F627FDA3940A1DB800C130B54C0184F082766DA39401F03BE4A1A0B54C0731FEB6F2ADA39401333F3CB1D0B54C06D37CCA7F9D939402E10D28D2F0B54C09C94316E05DA394049F05BB46D0B54C0C949ADB3FED939400D1CB47DC60B54C0865D8E4AF6D9394072482684C70B54C0A8ABA6F833DA3940	0106000020BC0800000100000001030000000100000019000000006D8325B1362C41A87E7B2C3CDF204182E8D41C96362C4157C84660D3E0204120A4C6777F3E2C41E6042C4359E12041BE20147314412C41D593A3B97FE4204155CE78BAEB372C41DA6F8B7942E420410349855130382C416111CFD035EE20411DB1A32EBF3E2C4167982DED52EE20413239F0C6A13E2C412A008BF9FDF4204196C7A94086372C41833438FDDFF42041C06FD3B195382C412662F170CAF720415F7809628D4C2C41893F6FB301F820417597FBC016582C41624AF7DECEF82041731D96B280582C4191A02EEDC6EE2041505235C736582C4149F8483415EE2041CEBC5B4B0D582C4182B35AA5BAEA2041991D564EEA572C418E6C324329E92041B46B8321A3552C41FAFBB51856E42041E6DF94C5D0532C4117803B54AFE22041FC9474CAFA522C411285661896E12041DD2A3F2CDC512C41FBB60DE3FDDE20415B0883DF52512C4135D2CDE6DFDC2041C0B3DB26894E2C41486052085EDD20419AC79478CA442C4126B315C303DD2041E833978DDE362C41EA49194290DC2041006D8325B1362C41A87E7B2C3CDF2041
35	4368	B	Miami	2	1245000	FL	Miami, FL	5.20074302130524e-05	0.0507137090507496	0106000020E6100000020000000103000000010000000C000000850537B2880B54C0BB4B313A32D639407DA46044BD0B54C0A876797F2BD6394065AB6DB8BF0B54C04A45824103D739408DDF1E5BC10B54C0D54CDDE624D73940A3D6827E490B54C008CE843333D73940B2A1CB36580B54C0CE75D69201D73940778080E5630B54C0E704C1B8DBD639402FEE04D06F0B54C0A93D581FBFD63940A9EBC3EC780B54C01A6694BAA6D639403EB94D887E0B54C0085E7C0490D63940062CB98A850B54C0F6D63C1E65D63940850537B2880B54C0BB4B313A32D6394001030000000100000006000000714A115DD30B54C03638E1C344D539400B9A919FFF0B54C055F8A51142D53940B19C22F2030C54C0FBE89830F0D6394099FC8CF40A0C54C02AB246EC7CD839408747312CDE0B54C0C50B24537ED83940714A115DD30B54C03638E1C344D53940	0106000020BC080000020000000103000000010000000C00000071FF7420D2402C416EDA510FDAB220417A0D15C593382C4115BA694782B22041BC028D6622382C41B89CE7E7DABB20416194646ADE372C414894EBB44FBD20415E33A7F1A94A2C411B0C6B570CBE2041983C06615E482C41BA8B5628E2BB20418616EDF18B462C41AC283B5C3BBA20414479077CAF442C41409CBA23FBB82041278A1C4E43432C41904C4046EAB720418110EEB963422C41CD5117F3ECB6204118775D414D412C41E44BC6570FB5204171FF7420D2402C416EDA510FDAB2204101030000000100000006000000DC3D276D2C352C41D511536E7DA820412AFA5F723B2E2C41A6A8E18554A82041A825F667702D2C4170343573F6BA2041945827CA3B2C2C41AFEB975E25CC204102A99DA941332C4155EB570B40CC2041DC3D276D2C352C41D511536E7DA82041
36	4369	B	Miami	2	1245000	FL	Miami, FL	9.60919805947924e-06	0.0189813563621829	0106000020E6100000010000000103000000010000000F0000003516C4088D0B54C0F92578C9D3D43940939B2F96CC0B54C0F546EF4CCFD439409D4AE571E10B54C0472A5C3B43D4394081FEBFA0FB0B54C0671786BB3FD43940D31A04CFFD0B54C009B78495EDD439407F317CC0D30B54C0AA17726FF5D43940D276F324CE0B54C02C87B6ADF7D4394051248888B50B54C02C87B6ADF7D43940CD2CFB6EAD0B54C01757E8C501D53940E196AE44A60B54C095F9C3A600D539408163EDF4A50B54C02378F58A24D53940D524CE43930B54C0BD1AD16B23D5394049040EF4920B54C0960EAD8008D539408B088A15910B54C0A726C9D3EFD439403516C4088D0B54C0F92578C9D3D43940	0106000020BC080000010000000103000000010000000F000000CEC9A02C3C402C412BAB69CEA9A320418A171B9F44362C41C10B902C68A320418C148FB508332C411C85594F519D20412DA11B96ED2E2C41B40654FD239D20410D31541A8A2E2C41B23F1BD9ABA42041C3DCE84922352C412DF6C8630DA520412F8E0F4C03362C414D4E24AB27A520418AEFA783DF392C415B38BECD2DA5204174F7A80D243B2C411F03C4CB9FA5204178F4D7D6433C2C419222CE2495A5204193C033DF4D3C2C41B60C4F5623A7204103D32F7D3C3F2C410E3377911BA720413BE4A6DB4A3F2C41FE46430FF1A52041F3FF439E973F2C412D638CD2DFA42041CEC9A02C3C402C412BAB69CEA9A32041
37	4370	B	Miami	2	1245000	FL	Miami, FL	6.35798412531585e-05	0.0341166722022337	0106000020E6100000010000000103000000010000000A000000FB87F2DA4C0D54C0F735BE82F6CF3940299916348E0D54C0E80D2310F1CF3940B7BA6468910D54C0FAFB9CED17D13940F1E3DCE49F0D54C0FAFB9CED17D139409EFDFF3AA20D54C097AE601B71D13940FFC84968780D54C0C8841E8579D1394046DF5B93790D54C08C2BE8B6F7D13940E61A31760C0D54C0C6A9528A08D23940217E4752070D54C076523715FECF3940FB87F2DA4C0D54C0F735BE82F6CF3940	0106000020BC080000010000000103000000010000000A000000365223C051FA2B41DE06F3C7466D20419E4358BC11F02B41607F0498FA6C204129BC1C767DEF2B41AF085683C0792041310CF9B737ED2B41298ACB07BD792041D6F0E1F8D3EC2B41431673A7997D20417B56E1F062F32B413D326D09017E2041087D47A02BF32B411A0B798678832041545AAD3648042C413E21A2914D842041E1A24EB739052C41648D5DA1AB6D2041365223C051FA2B41DE06F3C7466D2041
38	4371	B	Miami	2	1245000	FL	Miami, FL	2.63336237367184e-05	0.0258892056617427	0106000020E6100000010000000103000000010000000B000000D542F7AF430C54C0B323A085AED13940F15974D1410C54C0D7255A6EC0D03940E6FD1F2A640C54C09BA4B845C1D0394036BA7EB2630C54C049CDAA11F2D03940E2F89D63760C54C0294C09E9F2D039403C80E052770C54C0BC7FAB0A47D13940ADE22AA2C80C54C0F8004D3346D13940C19A0D09CA0C54C0F75685960DD2394066030C72870C54C05A65237A13D23940E11D9ABE860C54C0C87EA9AEE2D13940D542F7AF430C54C0B323A085AED13940	0106000020BC080000010000000103000000010000000B00000020A92CE4CC232C4110487E3D988020410A06142F28242C4159073CC047762041EDCEF7CFC41E2C41609B0C9E48762041DCC1D742D41E2C41938F83FE657820417EB3FB8FE51B2C41F99E5ABA6A7820412AD66151BA1B2C41B98505B30F7C2041102E991EF90E2C4126466871F27B20416670695EB30E2C419A8274BE9584204102A15B0825192C417CF81960E7842041FA828C7D44192C41E60F514ECA82204120A92CE4CC232C4110487E3D98802041
39	4372	B	Miami	2	1245000	FL	Miami, FL	5.05075902310637e-05	0.0389901138543014	0106000020E61000000100000001030000000100000014000000DB01F0B2B30754C00E72DDFC55DF394029784CD5C40754C0F9B3CFDF5BDF3940AF69228FC70754C07BB50C1A75DF3940F138E768D40754C0FCEC6C4E79DF3940E1F8B1B4D90754C0B8B78ECA7DDF394062F670D1E20754C0CD39CA6BECE03940B6805E25100854C0E852B70EE9E0394047246A9F170854C04A55457E1EE239402A8ED82EFA0754C0F8CB910F26E2394045E720DBFE0754C093E755F80EE33940E377C603F90754C0A8E5CF0314E33940A524D065EC0754C0270861F9E9E23940E6676CADC40754C074E39E2DEEE23940BB093DE9C40754C025161798ACE23940513B4857C20754C017D336597EE239402D3CB34DBF0754C004BD9D68CAE139407D57AC90BB0754C043BA72D288E139402D9B4D08BC0754C075C9F17026E139409598A7D3B70754C046FF7B6CA2E03940DB01F0B2B30754C00E72DDFC55DF3940	0106000020BC08000001000000010300000001000000140000006E40E46401DA2C4177F37D293A1921417AF0B32F51D72C41CDE92BDA761921410A6528E5E1D62C41C7381BF48D1A21415ACDFBC1DDD42C4125758B24B91A21413BE067D708D42C4189285878E91A2141A19694E97FD22C414DA50ED5C92A214126720CCA64CB2C412B197C63982A21410510B8D721CA2C4137FC0DC7FE3721413F2AABE3BECE2C41442FE2975A38214163DDED1AF2CD2C41683042DE704221413427B72BDCCE2C414E6C2964AA422141C50311ACD9D02C41C49BF96FDB4021418507F28C13D72C417F10DDBA1441214158B4280B0FD72C4114D13D2E3D3E2141BE341CA279D72C41A53845E53C3C21413A4E41E900D82C41FAE77CBE71342141264AF4D49BD82C412A823D3C9B312141BDEE8F6290D82C41F1820BD4572D21413A856C0043D92C4182634791A02721416E40E46401DA2C4177F37D293A192141
40	4373	B	Miami	2	1245000	FL	Miami, FL	5.38235240128415e-05	0.0382292243822232	0106000020E61000000100000001030000000100000010000000E3949533EF0754C097B6E08EB5DB394075268647EF0754C09229A5BB79DD3940EBA0F939F10754C07A7968D6D4DD3940F1FD98CCD40754C0C58176D8DBDD3940F138E768D40754C0FCEC6C4E79DF3940AF69228FC70754C07BB50C1A75DF394029784CD5C40754C0F9B3CFDF5BDF3940DB01F0B2B30754C00E72DDFC55DF3940B92411F1A10754C0466F427F73DE39402758D240A20754C0042BDA5E03DE3940625C4E62A00754C0263A001F92DD39401FAB08F59C0754C00920DE4F9ADC39403BC285169B0754C0164CEB6C51DC3940D3D8BC7CBB0754C00768DC4D50DC39406D10FAEDB90754C046DBA012B1DB3940E3949533EF0754C097B6E08EB5DB3940	0106000020BC0800000100000001030000000100000010000000235691A6F1D02C41D1864DB1EFF0204160E6F611CDD02C410409125E870421414DC84D2B78D02C415CA6B46979082141BAA9E2C7ECD42C41586982C4CE0821415ACDFBC1DDD42C4125758B24B91A21410A6528E5E1D62C41C7381BF48D1A21417AF0B32F51D72C41CDE92BDA761921416E40E46401DA2C4177F37D293A192141D4DD3407DBDC2C418D95819D6E0F2141DBE34CDDD6DC2C413C334DC7920A2141819FED522ADD2C41B18B0813AB05214146E49253C6DD2C415B0C7E33EFFA2041B8785FC916DE2C4180AF0938C7F72041D47A4B3A02D92C41DE35A410B2F72041F5B8FF944CD92C41CB28683ACCF02041235691A6F1D02C41D1864DB1EFF02041
41	4374	C	Miami	3	1245000	FL	Miami, FL	2.78442173566873e-05	0.0225876603081953	0106000020E61000000100000001030000000100000007000000E7D6B04EF10B54C00684E5EEC4E439400110454E8D0B54C0BDD76F8BD1E4394045AF6F55890B54C0C3EF9CE982E33940922FF4CACD0B54C067ADEDA979E33940D94506F6CE0B54C0DB524C94F3E339404904409BF00B54C0CCEBDA88EEE33940E7D6B04EF10B54C00684E5EEC4E43940	0106000020BC0800000100000001030000000100000007000000E65A7B7C692F2C4186053AFB655421415F762AF0153F2C414B4825D90A552141CFD43C89CC3F2C4116A901FF8B46214115ABAC9E11352C413A88E9481446214192B90B54DA342C417B208A515C4B2141F5BA8A5C942F2C4117E2A5FA1B4B2141E65A7B7C692F2C4186053AFB65542141
47	4380	C	Miami	3	1245000	FL	Miami, FL	8.48270847200183e-05	0.0402228745096557	0106000020E61000000100000001030000000100000011000000DAB265C1900E54C012B5D44496BC3940B937761EAF0E54C09218C5F14ABC394069B74F87080F54C035EB827D18BB39404BFB35451F0F54C0C995BF31BABA3940991E5CB3350F54C005938070BCBA39406D85DE52360F54C02958FA08B0BB39402A166470390F54C0E9FDC3B9ADBC39406A5B6031380F54C059489666CFBC3940A93624C0390F54C0AC1548C509BD39402327CF992D0F54C0791515620FBD3940F363D317300F54C03CA63D5858BD39409207201DED0E54C079A75134CEBD3940FF3AE16CED0E54C099654A49E1BD394011544689A10E54C03886B90A4DBE39405904410B9F0E54C05675BA3360BD39403DEDC3E9A00E54C039CCE95C18BD3940DAB265C1900E54C012B5D44496BC3940	0106000020BC0800000100000001030000000100000011000000475BB583C4C82B41346003301C2C1F419D08263A05C42B41BE333EEB86251F41B86BBAF40FB62B416E6F8EB9CE0A1F41BF787C1484B22B41C631174798021F41162B1A84FEAE2B4185F7FDA8BF021F418BAF14DED5AE2B41DC33534ADB171F415353B76B48AE2B416EC879B6D52D1F411366EF5678AE2B41359CD856C1301F41E22E2D0136AE2B417EF2657ECF351F415B3490E01DB02B41D18215A551361F417A47650CB5AF2B411DF7EC10A33C1F417A3D34F630BA2B41F4F727DFF8461F412D566C3623BA2B4194AB380AA0481F41DC0E68B705C62B418CF5680D1A521F415B20703A79C62B419E33F528953D1F41FA2DA6C632C62B41AD0DA7995A371F41475BB583C4C82B41346003301C2C1F41
48	4381	C	Miami	3	1245000	FL	Miami, FL	5.69725407331134e-05	0.0383225505516899	0106000020E6100000010000000103000000010000000D000000991E5CB3350F54C005938070BCBA394077CE8B1D510F54C0E457670DC2BA3940CD4AB9ACB60F54C0A28295D3B6BA3940B99E3A4CB70F54C038D906EEC0BA3940F750CBA4C00F54C0345DE58FBDBA3940D3CE4FC2C30F54C0934FABC248BB394085C265EAF50F54C0B6A5ABC73FBB394085C265EAF50F54C079C652C6EDBB3940ED49AF4C660F54C0CC725E1FFABB394066BEF03B670F54C0134C077BABBC39402A166470390F54C0E9FDC3B9ADBC39406D85DE52360F54C02958FA08B0BB3940991E5CB3350F54C005938070BCBA3940	0106000020BC080000010000000103000000010000000D000000162B1A84FEAE2B4185F7FDA8BF021F419B1ADD6BB0AA2B41E46042762F031F410737BDB5BF9A2B41873DF69107021F41E6EE9907A69A2B417DE52D6AE7021F418EF5D2A62E992B415CD5CF6998021F4101FA28A3A8982B414333A2F3A60E1F410E945A91C9902B413BBBAEC0C80D1F419390F296BE902B4161D86AA4DC1C1F418FB28C2949A72B41D472959C301E1F41BEFB8A4818A72B41C11ED6AF8E2D1F415353B76B48AE2B416EC879B6D52D1F418BAF14DED5AE2B41DC33534ADB171F41162B1A84FEAE2B4185F7FDA8BF021F41
49	4382	C	Miami	3	1245000	FL	Miami, FL	5.44428355624405e-05	0.0361926817330436	0106000020E6100000010000000103000000010000000C000000BD89891CAE0F54C0660AF68FA0B93940474A9EDEF10F54C0DDE82C927AB8394077D6A6652F1054C02CFC0AFAD4B739407EC96359321054C0066365B039B83940D945013D351054C0087034409CB83940F49D2DED821054C0A4FC2DCC85B83940C70CAD7E871054C02DACD05E82B939409EE5869A391054C0ABAB9616A3B93940D5EBD91DF90F54C055E753F2AAB93940E997587EF80F54C04C49658AB9B93940F52C9B48AF0F54C098F05827BFB93940BD89891CAE0F54C0660AF68FA0B93940	0106000020BC080000010000000103000000010000000C000000FB507580299C2B417CC5B182EEE91E41BE1666EA98912B41655D6D9055D01E416BECD67CFA872B411D8DCCFADFC11E418560C5847D872B416713FFD398CA1E41D6EAEB3703872B41353D7AFF21D31E41B32AE54DD27A2B41D50BD3AF0CD11E411AB76CF50A7A2B41D3895DABEDE61E41EAB2C14943862B4154B805C6E6E91E41B490427662902B416D0C7C7EB2EA1E41EA74FF947A902B418F970388F6EB1E4165AA2574F89B2B4116D5B69B94EC1E41FB507580299C2B417CC5B182EEE91E41
43	4376	C	Miami	3	1245000	FL	Miami, FL	0.000176208689936175	0.131775894942263	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
44	4377	C	Miami	3	1245000	FL	Miami, FL	0.00033831856217148	0.175438221239567	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	0106000020BC080000020000000103000000010000000D00000013382E0711092C41FA32B129BB0120410523C85E43FD2B41C7AF638F2F01204136D1350EA1FC2B41B617170E0F09204161FFD78F44FE2B4124A755AFED0A2041BE55E857D9FF2B4116EFF9142C0A2041B53789AFB2002C41CF57ECAB3A092041BEE108EEDD022C413C07D04C4B08204130E3B84632052C41311E230B1005204178CAC7B81D062C41D0CAFFC48E0420419F9DAE7C2E072C41B9B3781033042041136553BDC5072C41F6174E9A82032041061F8C0F41082C41580E73A1AC02204113382E0711092C41FA32B129BB0120410103000000030000002B000000ACF2D97100CE2B4159DF5A11801B20414F3B047A10CE2B41B4FF4957DA1020413EA3060215D72B418EEE834B2911204167C2DAF509DB2B415C212FA4A8112041C35A6432DADE2B4176B262C19B11204159912AEF92DE2B41AFD772C9731B2041AE621CA15BE62B41416426638818204181C3C8107CE62B41616627C9B9152041D2FF9207D8F72B418B2CC83BC90C2041DD73D84066F82B413110C95AC005204121791AB389F82B4130ABB8F102012041737217E638E12B41D82C92EF490020411D5E60FFE0D32B41005C6EB978FF1F4151ED7AF6A2D22B419D259D8CFFFD1F41F4593BF17CBE2B418C712656D0FC1F41E2149E568BBE2B416012FBBC1AF61F41624D6B5FD4BC2B41224533EC00F61F410FF2AE956FAA2B41BF25D241ECF41F4164569B11E7AA2B41D865C658AAEB1F41469265CC91AB2B41AC3B8D41E2CF1F4106211139A2A32B41CAE0FD17D8CE1F41EEB0E4422F992B411DFCFF5D49CE1F418A4B4C16B4952B4146B7C3C771CD1F4179E19E8A46892B410BF62A7D6DCC1F4143BB47A91C892B4193B4996826D51F41E95887858A882B41484B4A3196F31F413EE10913E1802B419BB27EF30FF31F419507BF8C90802B4164608F2F92FA1F4190D5FC8488952B412D5716F031FC1F41F935266051952B41C0D65753B60320411BC669E3AF9C2B411B8311CBD3032041482340E6C69E2B413ED3E1DCD60320415BED375E9CAA2B419B79546570052041F4B86CF920B72B4145F8DEA8050620416ACB394250B62B4133DF5B20701A2041DB6F70227ECA2B416D67AFA9231B20410E77E4B067CA2B411CFEF7F6941D2041EE8D969AD7CA2B41031361F90E1E204189A0582BFACB2B41F2E06706521E2041F8E7CC4321CF2B419E8F3E1B601E2041576BE88E76CF2B4167DF2496D41D2041F87FAC2484CF2B41F01EF85F881B2041ACF2D97100CE2B4159DF5A11801B2041050000001DDA593FBAD72B417396948BC10B2041D3C116FF1FD82B413E605B308B0620411348A35443E02B41E88BF5DFD806204180C1DE410CE02B41CA47FBD8340C20411DDA593FBAD72B417396948BC10B204106000000875C40A1F88A2B4188E22DF1E7F31F413B2A0B4F608B2B41CADAA1F081D91F41659A6B4DB9942B41665EDC427DDA1F41E531C46CBE942B4167E03A1553E01F41D9E05B7A19942B41CA2F314285F41F41875C40A1F88A2B4188E22DF1E7F31F41
45	4378	C	Miami	3	1245000	FL	Miami, FL	0.000234457498891061	0.136720332340442	0106000020E6100000030000000103000000010000001700000021536F87520D54C02790A266F9C33940E177ABF8500D54C0751BA44555C3394073B094EB010D54C08E9241495CC339407BEBE287010D54C025E92D2D89C33940F9268878F30C54C042F955958AC339406508423DF30C54C098C5667562C33940D1915F49160D54C0A83E113D09C33940B109EAA01A0D54C0DDDF71821DC339401D3F4582870D54C04838B96813C3394096B38671880D54C019BA193BCFC239408D81153DB60D54C014A3ACB4CCC239408D81153DB60D54C0B8E6216269C23940B1B80CF3D60D54C0B96A6EEA5BC23940EAA7E60FF90D54C0D461130656C23940612EBE08FD0D54C0BA3460D290C339406753BA630D0E54C066BC508192C339405BE2899F0D0E54C0EA48D845BEC339405DC2AE743E0E54C0697D6FBFBBC3394051517EB03E0E54C006EA650CDAC339406736EB33170E54C045901877E2C3394069685C68E90D54C008019C9FE1C33940169CA389B50D54C0663E2017EFC3394021536F87520D54C02790A266F9C339400103000000010000000E000000B31E5921CE0E54C063A4608BB2C539405A4B6E05CE0E54C0EA9812E190C539405E33E7837F0E54C0C501D3ED95C53940FB61478D500E54C0C9BCAF8DA2C539403231A715500E54C08AE0C24564C5394026C07651500E54C013B1FD6EFEC43940824CA0584C0E54C0F8D2DE571AC43940B1BA2973800E54C0CAFFE9A818C439409212A162B30E54C039E15EE00CC439402A29D8C8D30E54C01B1C46040DC439403682B0FAD30E54C056A44DCBCBC43940A5FC23EDD50E54C0D8C60A44F0C439404ABAFE0ED90E54C07AC88D9CB1C53940B31E5921CE0E54C063A4608BB2C539400103000000010000000C000000E5ECE7F1F40C54C0599A73BBDAC53940A5AFDE43CA0C54C0281F130DF8C43940B85B5DA4C90C54C016DDB5F651C43940BE54A1BE7B0D54C0F21778C33DC4394097A0B4A7AC0D54C042621BEE2CC43940212AD66E300E54C058A228DA19C4394059059AFD310E54C099C069E5D1C4394065461A9D320E54C05C448EA03DC5394065461A9D320E54C0D8B8967AAAC53940478B66773E0D54C0B9A06963CEC53940B2101390330D54C002E72244CDC53940E5ECE7F1F40C54C0599A73BBDAC53940	0106000020BC0800000300000001030000000100000017000000391044973AFA2B419CABC5ED94D01F414D90231C84FA2B41E627FE9D5CC21F4173CBF9A3EB062C41F88BC77F1EC31F41D12CCE46F8062C416BAF2E8B02C71F41442D590F2D092C41A2233A9628C71F41CAB5400E39092C41B9A17F90AEC31F4187CA28F3BE032C418D6F8245E2BB1F4111B695250F032C41C44CA6DCA1BD1F411C21905AF9F12B41E24FBE3A8DBC1F4187872054D8F12B41A7E4DE4DA4B61F41A88E4E93A8EA2B416D2D405056B61F41150C6024AFEA2B4105CF43EEBAAD1F412F2519C98DE52B41C1F4688480AC1F41581FF99933E02B4192767988EDAB1F41E13D81507FDF2B41C86A6E2933C71F411673401BEEDC2B41EB8E28B850C71F4122D06BD8E1DC2B41A77B808E1BCB1F416B82E51D38D52B4174A8395ACCCA1F410A4A72BF2CD52B415783526F6CCD1F414058BE995EDB2B411BEEC3E539CE1F41A77380828EE22B410526F0083DCE1F411E703C89B1EA2B41205A8C9580CF1F41391044973AFA2B419CABC5ED94D01F410103000000010000000E000000E2149E568BBE2B416012FBBC1AF61F4187CCCBE591BE2B4136888EF42FF31F418803EF6CE3CA2B41F20828E4C4F31F41A728284841D22B418F28E224F3F41F41212DE31F58D22B415AEA2EB78DEF1F41B59EB76455D22B4112704165BAE61F41344AF2DF03D32B418AC5404AF8D21F418765C9B2D6CA2B417DD7AD53BAD21F41898F8C1CD9C22B41423A7BF49CD11F41B4066C72C3BD2B418F48E7DE90D11F416A53C449AFBD2B41C1FDB10119E21F415C7912B55EBD2B410DCF742F41E51F41624D6B5FD4BC2B41224533EC00F61F41E2149E568BBE2B416012FBBC1AF61F410103000000010000000C000000F240FC15CA082C41C951E73878FA1F419AEFF0F08B0F2C4129526844E8E61F41A3159028B00F2C415805C60D84D81F41BE8E4E2FBEF32B417883DBA16DD61F4103DE734E12EC2B41182F45B4E0D41F4142F0525565D72B41F85154A0FAD21F41BC9DE4B21AD72B410BFC68BEECE21F415E86A29CFAD62B415AA8675E42EC1F413CD9587BF3D62B41DDA2A126B1F51F415464B85041FD2B41C42064BA42F91F418CFAA46CF7FE2B41870CCD1B2FF91F41F240FC15CA082C41C951E73878FA1F41
46	4379	C	Miami	3	1245000	FL	Miami, FL	9.65210515460058e-05	0.0480876683884914	0106000020E6100000010000000103000000010000000F000000F9268878F30C54C042F955958AC3394091FA327EE50C54C0872A65FB8BC33940653D69FFE80C54C0CC89AE0606C43940EDAADA4A3C0C54C0496863D61FC439407BF4CDD0340C54C0C830F92FA8C4394071F7D9CB0D0C54C02792E5AD85C439401B7D46CE140C54C049ED83156FC339403677F4BF1C0C54C02AC8C31A65C239407598DE7A640C54C005B47204B0C23940E5F77D65890C54C01D9D057EADC23940E53949F08F0C54C08259D1818DC2394033BACD65D40C54C01378501ED0C13940D1915F49160D54C0A83E113D09C339406508423DF30C54C098C5667562C33940F9268878F30C54C042F955958AC33940	0106000020BC080000010000000103000000010000000F000000442D590F2D092C41A2233A9628C71F414B4E6B8B5E0B2C41BA9E666A4EC71F41A74BD889C90A2C41C8E6ED28E0D11F41A447FE55E2252C410DE6EA5E71D41F41B4BC956E05272C412A8BECE045E01F41C8404163272D2C41D911769F5BDD1F4116AB55CD202C2C412D8D0BBB33C51F4100126BC8F32A2C418551D24023AE1F414BB895BCAC1F2C419F6762C87DB41F41F4A958B2E1192C4147E024A533B41F41B2D81D03DD182C41EA4BAADF6AB11F410F30343B2B0E2C414A913CFDDFA01F4187CA28F3BE032C418D6F8245E2BB1F41CAB5400E39092C41B9A17F90AEC31F41442D590F2D092C41A2233A9628C71F41
50	4383	C	Miami	3	1245000	FL	Miami, FL	0.000263088929614241	0.174470555743262	0106000020E610000001000000010300000002000000350000007138EEF23F0E54C0ECB28EADDEBE394093F18096540E54C0441B85C6C1BE394011544689A10E54C03886B90A4DBE3940FF3AE16CED0E54C099654A49E1BD394065564A2AEE0E54C0D714CDA566BE394082EDC5EF640F54C0ED5CF31F5CBE3940F16739E2660F54C0E6478C36F8BE394039F8E8BE900F54C02E569DB4F4BE3940CA7D75CC8E0F54C0B5E241D141BE3940B3A574D4C40F54C079A54E4F3EBE3940C2EF1442EC0F54C06D566CC933BE394092B5FD601D1054C06D566CC933BE3940595E6B4F461054C06D566CC933BE39408D1BA548471054C02CD2589DCABE39401D27CCE11E1054C064543062D3BE39409962F0BEF70F54C0A7CC70C4D9BE3940A3529668C30F54C0D79B2003DCBE3940EB9858B8C30F54C05D3A7C9F18BF394059FD3F51900F54C026BE27DE1ABF3940C63001A1900F54C03BB72593CFBF3940E32D5AF7C40F54C069137BF6C9BF394016C7D757C40F54C09C6F5E9206C0394089A61708C40F54C04B2DD6AF75C039402D4A9E25C70F54C04444553FFBC03940D5786380A50F54C084E5F37DFDC03940D5786380A50F54C0E96A95DA37C13940D6C36C09860F54C07A6925D540C139408BC14CA64D0F54C05956C81343C1394049BDD0844F0F54C089E5BD1B9FC1394005FA93779C0F54C0432DE70195C13940C98A19959F0F54C0C376CF380FC33940AD739C73A10F54C00233FD17AAC33940DDBBBA81670F54C0593D9356ACC339400F045EEC310F54C0B6769B6ABFC3394032FBE18C060F54C0E30927E3C4C33940DDA981C5050F54C0E9D6D816FFC23940FB20AA74C00E54C038C13A4C03C339403755D6BABD0E54C05315F778D1C13940D902EA7C010F54C0E9B7D011D0C13940D902EA7C010F54C008E763F090C1394027DE73F3BC0E54C0FD343D5B99C13940D18C132CBC0E54C0FAED2824D2C03940DE115A7EDC0E54C0D7D5B5EECDC03940DE115A7EDC0E54C0B69E000E4AC03940CA2EE8221D0F54C007925E7144C0394056F0885B1C0F54C0F8CEACC80FBF39406275CFAD3C0F54C0F8CEACC80FBF394052FE6CE63B0F54C08B89961B90BE39407E938FA5FB0E54C0591B1F5194BE394095454009FC0E54C0749979F605BF3940AD94C1F8790E54C0F8CEACC80FBF39403A993E8F3F0E54C008F90E021BBF39407138EEF23F0E54C0ECB28EADDEBE39400700000045622C1A850F54C02699EC1E27C0394031B6ADB9850F54C0AD7CA9C8B6C039408BC14CA64D0F54C0A4C63DC3BFC039408BC14CA64D0F54C054961464F3C0394042728670B90F54C0372736ECE5C03940E3A9C3E1B70F54C016DD99A122C0394045622C1A850F54C02699EC1E27C03940	0106000020BC0800000100000001030000000200000035000000F268AB8C4DD52B41849BD5E4E65E1F417820711D12D22B41F0529EF35B5C1F41DC0E68B705C62B418CF5680D1A521F412D566C3623BA2B4194AB380AA0481F4148CA24E2FCB92B41B92FB72F2E541F41132696FB58A72B41B87BF3860D531F414684C5C600A72B41EAB62E4A93601F41800864E56EA02B416F6A6B2432601F41926F1D85C8A02B4140291696B2501F412DDC259B4D982B410DF32CE94B501F41A3304EED1D922B4159461465504F1F414331741B688A2B41783154F5394F1F4165A5B45CFB832B41CDA8B854274F1F41FA97FDC8CA832B417CB0F8D8385C1F4107C972AA218A2B41CF3F37C30D5D1F418D2A14D745902B41C2618F3FAD5D1F4137AEAEB97C982B41855E4308F75D1F41398F535D6C982B41DC5F6C7A37631F415CD3F4AD7DA02B41C21F85EE80631F416A0BC7A865A02B41E381069829731F41B4C9A50D2F982B41E75F340395721F4193015E3F44982B414919FDD8D5771F41321090B849982B41FF231DF876811F41A4ACD214C4972B4130D47C72088D1F417C9CACCA0B9D2B41828068B6498D1F4131501715089D2B41236ABB6958921F417C90CABBF7A12B411C88CF1A2E931F419AE3D92CD1AA2B411A226BFD79931F416F4EAA2E80AA2B417DC3BCBE729B1F41E201E2266D9E2B4169E8B7186F9A1F411B53C6EDD79D2B417E6A80FC33BB1F415E014AFB829D2B41080319CF9EC81F4143D9E9D29AA62B416FE1305CEBC81F41A893C65C02AF2B41700B3B73ABCA1F41EC571B8ED0B52B419358DF0339CB1F41E2FF1795FCB52B41BABCE66815BA1F41B245B032DDC02B4118C95D3293BA1F414E1544855EC12B41F0C09F0514A01F41A10D4233BCB62B419C57D132D59F1F415A7D2144C0B62B415C3FBCB45C9A1F4114C07F7281C12B4174C7C780379B1F41FBFBAFA3ADC12B4155D71477F4891F41782E723F9BBC2B417D7138F487891F41F79DDBC3A3BC2B41C031BB5E1A7E1F415E370EC17EB22B41622A64B57F7D1F41FC2D97E0B1B22B4157521CC5C0621F413C49E9239FAD2B41056ACDBEB1621F4161D6FD9DC6AD2B416F9BCBBCA1571F41E5064037DCB72B41D2BEEF041D581F41687BA33FC5B72B4162BA45F6F5611F4191F8C7DD2ECC2B418F55E3D70C631F41538E964059D52B41548FF47121641F41F268AB8C4DD52B41849BD5E4E65E1F410700000095C20D3C2FA22B410A2ABC08C57A1F41DC35CA0B0DA22B41C69E49C537871F416AD58E94D9AA2B418F84B3E618881F41AFF19946D6AA2B41AFB09239928C1F41750E7430EC992B4184967CAD358B1F415521FF2A379A2B41A503AA0B4A7A1F4195C20D3C2FA22B410A2ABC08C57A1F41
51	4384	C	Miami	3	1245000	FL	Miami, FL	6.17113032603811e-05	0.0595846903751076	0106000020E610000001000000010300000001000000160000003D076935C01054C0EB32B6D0C8C33940DA5CC0C1BA1054C00DBE52A54CC2394047D3FCD8D41054C0AB05DB4152C23940B26B8AE6D21054C03799D762CEC139402D2B13325B1154C0085225BBB3C13940638F74F95B1154C04957511905C239403D1C69183A1154C0E38CB74E09C23940DFA2F116F81054C0685D364912C239405658B3A5F91054C0A4FCE13DC0C239406A2B2989221154C009C77B08BCC23940D9A59C7B241154C0770DB9B442C33940A3CE49E0501154C05C1135183DC339404F0D6991631154C0FBD379AD34C339404F0D6991631154C085B0C44A9FC339400D7C9DB8821154C03CEAA6E39DC3394006414F1C831154C089AE58CB36C439409357E718501154C07AE0E52E31C43940A3CE49E0501154C0E6ED7FB5A7C3394012AEEA26FD1054C0A96C72EEB2C33940AF50ABB5FE1054C07AE0E52E31C439403555284CC41054C0B986989939C439403D076935C01054C0EB32B6D0C8C33940	0106000020BC0800000100000001030000000100000016000000E0DE655F80702B414D9F97BFC5CA1F4152AD880773712B418F396F86D6A91F41A054FD6A5A6D2B41F751B74647AA1F411B3B03D3B06D2B41E19773B9DA9E1F41EF85BF5E4E582B41A3828D854E9C1F41FB07D8162A582B41F353783C5BA31F4188AC3C057B5D2B41E71E57ABC7A31F418DA89D6FD6672B41D069BC54ACA41F41F90358198D672B41D5C9C2A9BEB31F41F7D9199522612B41E17E96044FB31F4137E1E00ECC602B41BEEB15BAF9BE1F4100F9CED8D4592B41ADF0B47769BE1F417CFB7164E6562B416C452871A6BD1F410D12BDDBDF562B411355A192E3C61F41982BB357FC512B41CE27D0A3B6C61F413D169959E3512B41D89E0D82F6D31F41BE965827E5592B41531571AB90D31F415922794DCE592B41E04A4999A6C71F414BFAB549F1662B412C4F00EBC4C81F418FFAD8E7AA662B417B1D0FFDB4D31F41754B6418D56F2B41AFF5B7EC89D41F41E0DE655F80702B414D9F97BFC5CA1F41
52	4385	C	Miami	3	1245000	FL	Miami, FL	7.23133687188238e-05	0.0776039749164916	0106000020E610000001000000010300000001000000240000004E3D5160810C54C04753CB4317D93940DF3FF794850C54C07399C83C5ADA39408DD7F9A08F0C54C05973069A5DDA394016D5B8BD980C54C0E9D16BEB5BDA39405BB12C89AD0C54C07DC3D32B65DA3940B58C8DA6BE0C54C0F782E4D76EDA3940910A12C4C10C54C0632D31DBBDDB3940C93640CEF30C54C0F58348F3B8DB394031766524F60C54C0591A4E5246DD3940AAD24E81F70C54C086A0F4E381DD3940839720F0EE0C54C05CB65A9782DD39406D0EA3C2E60C54C0B68506FA75DD3940325169C9E50C54C0D8445CBCFCDC39402915559EE40C54C0C94EEF5EC5DC39407B49F15EE60C54C047D4196688DC39403DAA41FBE50C54C03921A04E3BDC394076F21CA3B20C54C0CC1D1A833FDC3940112A5A14B10C54C0F782C3C985DB3940F6F9D423A00C54C0085F84AF83DB3940C695735C9F0C54C039079A92D6DA39407DA1B227820C54C08744C52BD5DA3940C1EB30AF6E0C54C0765CB0FBDEDA3940412E37CC5B0C54C0B6AF4148DEDA3940454CC1615C0C54C06DD9D66D55DB3940E75F1E74010C54C0FA117B8C65DB3940D2020F67190C54C00E4279669CDA3940C7843ADA080C54C04410D8B657DA3940310620921A0C54C05D2CA5AB97D93940BB505E03190C54C0C8C2123A28D9394059809D384C0C54C06510999E22D93940CFFA102B4E0C54C079D18C82B6D93940DB53E95C4E0C54C0C8B1794585DA394049F358AA600C54C0D96CC15F87DA39409A3910D1690C54C018CCA6F67EDA3940C6F6D94F660C54C0EA4F469C1BD939404E3D5160810C54C04753CB4317D93940	0106000020BC0800000100000001030000000100000024000000E1B548DA9E192C41E84B2F20B8D22041D1B4E612E0182C41204BAB94B5E020419359D57F4C172C410508DD6DD8E020413EC803CADE152C4132F1CB88C3E02041073BF8549B122C4160A4420E25E12041FE2AD995EB0F2C41A19278268CE12041A25F9EDE570F2C419D594D6E0FF02041EA930A627F072C41D09FE3CACCEF2041818ABED206072C411EE0C7F503012141E8468D19CC062C41AE2A9E6198032141DBC546F423082C412D48493EA203214153D317136D092C41FD66855018032141274AB0549C092C41F2B6E3B7D7FD2041EDBE6DF6CE092C41FEBEC4E171FB2041CE355CBA8C092C4117914A23CDF82041DFF5DA8EA1092C41011FF11C76F5204165D4786DAE112C416676574FB1F5204166B2F487F9112C4112B48098A5ED2041651FD5B4A1142C419F6C436D92ED204190F7D1B4CC142C41FD10336812E62041AFEA334C61192C4194CD1E080AE620413B22924B6E1C2C414CCA4EA97BE620410FDBD08E641F2C41D914518A78E6204127F179FD441F2C412BFA9800A2EB204195627733862D2C414486C34D6BEC204170FD158BD2292C41F18A502CAEE3204122032BAC6F2C2C41BCFEC764B8E02041A33F097EB5292C41FACCB1CD61D8204187C01DA8FB292C4134D076078ED32041E85E7525F4212C416A36FC2A43D3204128B73DE49B212C411C2DAC1FABD9204128E0BFF985212C41B19E2686A0E22041D06E3C0FA71E2C417D7F4255B3E2204150E3F33E381D2C4108604AC953E22041CF504422DD1D2C41715802FDEED22041E1B548DA9E192C41E84B2F20B8D22041
54	4387	C	Miami	3	1245000	FL	Miami, FL	3.17900810387073e-05	0.0236252736066202	0106000020E6100000010000000103000000010000000E000000EAE7AE01FE0F54C026CED37E40E93940B679C095BC0F54C035EB406146E93940F2750F8CA00F54C0C913BAAB54E93940FF45DA0A9D0F54C0A7DBF3AB22E839406FA579F5C10F54C0F2C306E026E8394086C24CE0181054C009CB9E6C19E83940D3BB8FDB231054C0297690C5A0E83940898D30471A1054C0A506BE95B1E83940894B65BC131054C037861009BFE839408DDF1B100F1054C0E4B3D22ACEE839406E51B7CA0B1054C0C3C45EA9E0E83940B525FE6A061054C018553D9B00E939409ACCB5BE011054C06E9A9DAA1AE93940EAE7AE01FE0F54C026CED37E40E93940	0106000020BC080000010000000103000000010000000E000000D20C2F789B8C2B4184D1D61427852141E60A6438DC962B4191149A697785214178BE765C409B2B41DF86C2681C862141A67B3190E09B2B417890B400DB78214160D213EB16962B41B5EA8F1901792141D3F4DAF977882B412DCF05EC57782141DA194FC0B6862B41332179B6327E2141AF7D5A1636882B41AA32DD66EF7E2141C276B4C03B892B4116A7AE18867F214104E28D4EF6892B4161E881032F802141A5196464788A2B4158F035E8FC80214126201E014E8B2B41C4329A7A60822141A9F5A3DC078C2B4138D1949D82832141D20C2F789B8C2B4184D1D61427852141
55	4388	C	Miami	3	1245000	FL	Miami, FL	2.22379233036918e-05	0.0298514291909915	0106000020E6100000010000000103000000010000000C00000072482684C70B54C0A8ABA6F833DA3940D966172AE40B54C07C9031CD2DDA394033EE5919E50B54C0EC1B03BF01DB39400AA5CC59C10B54C067445D4327DC3940D507DE05940B54C0D8E5F7F128DC394025C43C8E930B54C0FDFA150A8FDB3940851EF560BD0B54C08C597B5B8DDB394045A9487BBF0B54C0F8A224C1A7DA3940D2ADC511850B54C096CDAFF5ABDA3940C56191A8950B54C0E9C517A163DA3940FD756720C80B54C0FB9B0CB258DA394072482684C70B54C0A8ABA6F833DA3940	0106000020BC080000010000000103000000010000000C000000006D8325B1362C41A87E7B2C3CDF20414E00AF7133322C41271A329AF0DE20416507B35AFF312C41DACC6C501FE8204196C7A94086372C41833438FDDFF420413239F0C6A13E2C412A008BF9FDF420411DB1A32EBF3E2C4167982DED52EE20410349855130382C416111CFD035EE204155CE78BAEB372C41DA6F8B7942E42041BE20147314412C41D593A3B97FE4204120A4C6777F3E2C41E6042C4359E1204182E8D41C96362C4157C84660D3E02041006D8325B1362C41A87E7B2C3CDF2041
56	4389	C	Miami	3	1245000	FL	Miami, FL	6.82354204855073e-05	0.0519415485728855	0106000020E61000000100000001030000000100000014000000F6816AD7920C54C018EB14254DD63940AFD5CAF6D40C54C006165D6A46D6394079A11954D30C54C0A837EF74F1D53940294BAFF8060D54C0F7B43F27EFD53940FEB90A57570D54C0F3959191EBD539401AD18778550D54C0753C155933D53940210398167B0D54C0B58A1FDF35D539407EBFF69E7A0D54C065450FA70CD53940F9FE6B18BC0D54C0C9B0A4D20BD539406E831C8CBF0D54C0B942078DFBD53940D3FC40D85A0D54C055E72D2B08D63940D39DA61D5E0D54C0D6A72703F2D63940A9278E64F80C54C0F367AFA601D73940124525CEDA0C54C086CA2C3306D73940A67BB202C60C54C0B82086160CD73940DA4D1E869E0C54C0DC812EB908D7394081E3AAC6930C54C0E4FA86A813D739407D0D29E8910C54C0B6878A5F9BD639408D54DB8A930C54C0B6F0B2E278D63940F6816AD7920C54C018EB14254DD63940	0106000020BC0800000100000001030000000100000014000000DA543A1612172C41126E28A8C2B32041FA78219DB30C2C41438676D367B32041B584A803FB0C2C41CDD986D8B9AF2041E486A499E1042C41B61D5BB593AF20419DBF77E046F82B4159A6FF7458AF20414F6E903B9EF82B4193EC917F5DA72041BD90B89CB7F22B41EB42B96870A720410BD6EF1ECDF22B411FDF1F50A7A52041B1395A2B88E82B41E550855D8EA52041CD8901AFEDE72B413856F4A4F0AF204140F8BA3EB8F72B419A2FD8D894B020416EAF6E4B25F72B415B4468E5B5BA2041E8EB8B7E18072C41733CF00A7CBB2041AABF8525BC0B2C416FC188B6B5BB2041B82692ABFE0E2C412910DD1AFCBB20412873A44F30152C411347D473E0BB2041FC645F1ADF162C415975C9615CBC2041A1A3CD4E32172C41B121B39C26B7204129CC38FAF2162C41DCD681AAA7B52041DA543A1612172C41126E28A8C2B32041
57	4390	C	Miami	3	1245000	FL	Miami, FL	1.74737067482056e-05	0.0234809972173835	0106000020E61000000100000001030000000100000010000000D524CE43930B54C0BD1AD16B23D539408163EDF4A50B54C02378F58A24D53940E196AE44A60B54C095F9C3A600D53940CD2CFB6EAD0B54C01757E8C501D5394051248888B50B54C02C87B6ADF7D43940D276F324CE0B54C02C87B6ADF7D439407F317CC0D30B54C0AA17726FF5D43940D31A04CFFD0B54C009B78495EDD439400B9A919FFF0B54C055F8A51142D53940714A115DD30B54C03638E1C344D5394081218594BA0B54C09561604646D539407DA46044BD0B54C0A876797F2BD63940850537B2880B54C0BB4B313A32D6394012DFB4D98B0B54C0DC875248A0D53940598A38BE920B54C015AA9B8B3FD53940D524CE43930B54C0BD1AD16B23D53940	0106000020BC080000010000000103000000010000001000000003D32F7D3C3F2C410E3377911BA7204193C033DF4D3C2C41B60C4F5623A7204178F4D7D6433C2C419222CE2495A5204174F7A80D243B2C411F03C4CB9FA520418AEFA783DF392C415B38BECD2DA520412F8E0F4C03362C414D4E24AB27A52041C3DCE84922352C412DF6C8630DA520410D31541A8A2E2C41B23F1BD9ABA420412AFA5F723B2E2C41A6A8E18554A82041DC3D276D2C352C41D511536E7DA8204120057D730F392C41FF557B5A94A820417A0D15C593382C4115BA694782B2204171FF7420D2402C416EDA510FDAB220419021CB915D402C4173F74E6A86AC2041D8FF767F4F3F2C41E127AAA853A8204103D32F7D3C3F2C410E3377911BA72041
58	4391	C	Miami	3	1245000	FL	Miami, FL	0.00019825301592391	0.143469121629449	0106000020E61000000100000001030000000100000029000000FB87F2DA4C0D54C0F735BE82F6CF3940217E4752070D54C076523715FECF3940E61A31760C0D54C0C6A9528A08D2394046DF5B93790D54C08C2BE8B6F7D13940FFC84968780D54C0C8841E8579D139409EFDFF3AA20D54C097AE601B71D13940F1E3DCE49F0D54C0FAFB9CED17D13940B7BA6468910D54C0FAFB9CED17D13940299916348E0D54C0E80D2310F1CF394045A5BD338D0D54C04DD9FEE994CF39404EB86158410E54C0C8840DA076CF394032A1E436430E54C0E4B7715607D03940EA8F1ABAE90D54C0E8A21C2A18D0394027BB6998B90D54C09D80A3871BD0394036A38180BE0D54C09BA467FE41D139407955772AD50D54C0085EE9A03ED13940E3687AC8D50D54C0988A6C6BB4D139403E51FB08D70D54C016C3F455A3D23940951A7769740D54C02CC5427FB1D2394053B43A85510D54C03CD2DCFBB5D23940B2F85565510D54C01296C2CD73D23940E5BDEE30CA0C54C04742792480D239403EDAF846860C54C004F57CB98ED239404EF2C0538A0C54C096AD027044D3394017956A25480C54C0F303F44E47D33940C59CAA52450C54C09C3F34A7D6D23940D542F7AF430C54C0B323A085AED13940E11D9ABE860C54C0C87EA9AEE2D1394066030C72870C54C05A65237A13D23940C19A0D09CA0C54C0F75685960DD23940ADE22AA2C80C54C0F8004D3346D139403C80E052770C54C0BC7FAB0A47D13940E2F89D63760C54C0294C09E9F2D0394036BA7EB2630C54C049CDAA11F2D03940E6FD1F2A640C54C09BA4B845C1D03940F15974D1410C54C0D7255A6EC0D0394023B8A395410C54C0F715D6534CD039402FF2E05E810C54C053EF8D4747D03940BD7D9F6F800C54C01551E343A8CF3940325752634C0D54C015B0738C91CF3940FB87F2DA4C0D54C0F735BE82F6CF3940	0106000020BC0800000100000001030000000100000029000000365223C051FA2B41DE06F3C7466D2041E1A24EB739052C41648D5DA1AB6D2041545AAD3648042C413E21A2914D842041087D47A02BF32B411A0B7986788320417B56E1F062F32B413D326D09017E2041D6F0E1F8D3EC2B41431673A7997D2041310CF9B737ED2B41298ACB07BD79204129BC1C767DEF2B41AF085683C07920419E4358BC11F02B41607F0498FA6C2041F719C81240F02B41B8C344B4FC682041F0767C72FFD32B41A76C22B381672041888B3FE6AAD32B415C33216DC66D20418AE11A95B3E12B4161807B5F966E2041A7A8354F40E92B41DD577938C76E2041D45343C467E82B411DED7248887B20415C4E3BD9D9E42B4166D518875D7B20414DE8CB46B9E42B417E6EC9EF77802041FA52D13577E42B41A89992BBD18A20414A86519CEEF32B411E559B80868B2041E56E1E6D67F92B4142F1C6B1C08B2041134A4CD970F92B41A638BDA4E2882041E57D2462A50E2C41DBCBA35D8C8920413B9A55964B192C41695A35BF3E8A204113E140A29C182C4130843E591D922041549D6EFAFD222C41C004367B4D9220411EAFDE0677232C419C4D2A956C8D204120A92CE4CC232C4110487E3D98802041FA828C7D44192C41E60F514ECA82204102A15B0825192C417CF81960E78420416670695EB30E2C419A8274BE95842041102E991EF90E2C4126466871F27B20412AD66151BA1B2C41B98505B30F7C20417EB3FB8FE51B2C41F99E5ABA6A782041DCC1D742D41E2C41938F83FE65782041EDCEF7CFC41E2C41609B0C9E487620410A06142F28242C4159073CC047762041AD2E2B7B39242C41C4A433F73F7120412071F533381A2C41040CF844F8702041B417BE85681A2C418EABF4AE146A2041676762426BFA2B41C948BA01E7682041365223C051FA2B41DE06F3C7466D2041
59	4392	C	Miami	3	1245000	FL	Miami, FL	6.7900737576565e-05	0.0608674991943116	0106000020E6100000020000000103000000010000000A000000DDE9AB979E0E54C08392251AF4D0394085D6DF7FBC0E54C00C4CA7BCF0D03940BBDBA68CC00E54C079EFF20511D23940155A7165A10E54C07E981B2512D239405E0BB7D2A40E54C02D10087E98D3394075D83B3E820E54C0387479DB9BD33940CF5F7E2D830E54C099242FAFFFD33940A1411FCC700E54C01B9473ED01D439406A2490B2680E54C0C548AD32FED03940DDE9AB979E0E54C08392251AF4D039400103000000010000000C000000E9B6D2D86F0C54C00519B586C8D43940F98CCF5A6D0C54C0931C3E5661D4394077845C74750C54C03DF3BCAC6DD43940758C899F8F0C54C096FBC6D265D43940893808008F0C54C0D6AF67143AD439404D22953EE10C54C0DCD29B7F2BD43940A58E6877120D54C0DCE4BB9E2CD43940F9B1FBEE130D54C094431CCF8DD439402AFE3B17D00C54C0BAE85F3791D4394071144E42D10C54C0375DEF4806D5394049EA9328700C54C04C35D2EA15D53940E9B6D2D86F0C54C00519B586C8D43940	0106000020BC080000020000000103000000010000000A000000F5EA59C845C52B41FBF4080DF3772041B810E2FA94C02B41605C2CB0C67720416C97FEA2DFBF2B41E22E3A72438420414F42C994C2C42B4198CF423757842041C32EF2941FC42B417B8B6F3240952041CA861AEC8BC92B41409C0FAD6D952041E94CDEE15FC92B41B70358C0C0992041284013CA41CC2B419165FFF9DD992041280C7476B9CD2B41164371C16F782041F5EA59C845C52B41FBF4080DF37720410103000000010000000C0000008D37B296A91C2C415355869DF4A220417590EBAC141D2C419C5C8FA17C9E204188D2A998CE1B2C415121297E039F2041F9189C59B4172C41603A6CF9A59E20416FCCA955D0172C4161D0F0E9C09C2041728BA2D9EA0A2C41BF82890D0B9C204166FBE74B32032C41FC9BC0820B9C2041E67F0ADDF0022C4190DC603141A0204196E6C7C8940D2C4117258C8377A0204127900DFA5D0D2C41DA28DEC689A52041E526B5D1971C2C4135220CFA4EA620418D37B296A91C2C415355869DF4A22041
60	4393	C	Miami	3	1245000	FL	Miami, FL	0.000138952752877231	0.0674971234862024	0106000020E610000002000000010300000001000000090000005B755A0D620E54C0DC76DF1A20CF394057CEC2C45D0E54C00C13D95DD9CD39404A23F4A0710E54C069CC59DCD5CD3940B99D6793730E54C0A863988A42CE3940153EBEC4A50E54C0DE1E6EE23FCE3940E9171D77A70E54C07B9F9E16BACE39408A4F5AE8A50E54C079E7445AE1CE3940D1656C13A70E54C0D949ABD81ACF39405B755A0D620E54C0DC76DF1A20CF394001030000000100000009000000D97AD549840D54C089FC3FF696CC39407355D1063D0E54C0D7C3494187CC3940A25A9813410E54C07710EFC422CF39402AC7ED62DD0D54C0268C1AD735CF39402DC98AAC580D54C0A8DEF50E41CF39405521886D570D54C07966487DA8CE39401BC11CF6880D54C0B83125C2A1CE3940AAB7D9C7860D54C0A835A2BB71CD3940D97AD549840D54C089FC3FF696CC3940	0106000020BC0800000200000001030000000100000009000000A9B47D93E3CE2B4142F7EA41BA632041300603F7A4CF2B419962840C93552041B316448F87CC2B4190752377675520416CF4D54432CC2B41118FFF801C5A20414DEA8A9952C42B4130B0D232F3592041B052578306C42B4132E7754C3E5F2041A4A6D28442C42B41FE9D5F30F2602041390737DD0FC42B41DFC33BA46F632041A9B47D93E3CE2B4142F7EA41BA6320410103000000010000000900000027BF8CF8D8F12B41AA7B95CCCE472041BF3AD01EDED42B41D11F086FF4462041692B7FBB0FD42B4139925D9FDF6320411082921EB2E32B418491BBE6CA642041A110BB3783F82B4106924F3A676520419C205171BFF82B41EBB0AA35CB5E20411EE9548BFAF02B41F0761F9B745E2041BA89205566F12B41B51462D64851204127BF8CF8D8F12B41AA7B95CCCE472041
61	4394	C	Miami	3	1245000	FL	Miami, FL	0.000100993696605656	0.0847679386920807	0106000020E6100000010000000103000000010000003E0000001B6471832A0C54C06B705BA24DD0394009E69CF6190C54C0E788C92351D03940C155ED19F00B54C0496CE7AA62D03940AD4AD4FEF30B54C0C74EA6880ED0394003132713F10B54C055E12038E6CF394066348A96F00B54C00D6D5CEDCBCF3940475DA59ADD0B54C08885CA6ECFCF39409625F8AEDA0B54C0972897E7BDCF3940D1E231A8DB0B54C097DD891592CF3940AEFCDCAAED0B54C0970F43D693CF3940D5AEFD88F20B54C0997917948ECF39400FF50CF8F40B54C03DD6648B79CF3940798D9A05F30B54C0A8646B4366CF3940A5D3A974F50B54C0CB1142B94DCF39403ED0600CF20B54C049E7F2E928CF3940B560EE02E10B54C049E7F2E928CF3940D1E231A8DB0B54C0C7741CE41ACF3940F2465B32DA0B54C0A5259B1A04CF39406FC1CE24DC0B54C0BA08D311EFCE394066E69242EA0B54C0388B1551EDCE39408D98B320EF0B54C0388B1551EDCE394003132713F10B54C036FA6E8DE4CE394003132713F10B54C02A14E5C3CDCE394052DB7927EE0B54C08869F3C0C6CE39408EFCC478E20B54C002F1BA7EC1CE394005A06BA1DC0B54C097E7DB78B3CE3940AA7E081EDD0B54C0B5F60E1C6FCE39407A3FA3B1EC0B54C04C4C1D1968CE3940AEFCDCAAED0B54C0BD0FA8945DCE39403E8269B8EB0B54C0A75AFACD4DCE39408EFCC478E20B54C0169CF4D054CE3940475DA59ADD0B54C01DE7460A45CE3940D1E231A8DB0B54C0C7A336B30ECE3940475DA59ADD0B54C00DC0C525EFCD3940E53B4217DE0B54C062EC70B379CD394011825186E00B54C0639B0D5F4ACD3940BDD7188DDF0B54C02CF46E31E1CC39405BB6B509E00B54C0440E4428CCCC3940BDD7188DDF0B54C06B447D9AACCC3940B560EE02E10B54C0C40D4EFD69CC3940E53B4217DE0B54C0D676019917CC3940A5D3A974F50B54C0B79B92530BCC3940716467CFFA0B54C0D57EF16099CB39400FF50CF8F40B54C09AE5B3CF72CB3940C155ED19F00B54C08D820E712ECB394066348A96F00B54C0D60C85DC00CB39408D98B320EF0B54C09860100FE3CA39402B295949E90B54C019A955C6CFCA39408EFCC478E20B54C09EA07B8DDFCA3940821ADF93DE0B54C0E994E20BDCCA39402D04952BDB0B54C075B5B7894ACA394031FCCE2C120C54C0B5F2B6C541CA3940E9337C18150C54C06A09535768CA3940D6DA6BA9120C54C003E9C044CCCA394073B90826130C54C026A5D1129BCC39409D24DCB2230C54C00CEAC10F94CC39408ACBCB43210C54C008CD195E04CB394076C0B228250C54C0B5F2B6C541CA3940C59B1E6F2D0C54C0999B19443ECA3940D1CBFBA7370C54C0CA8B82B038CF39404EF87746330C54C0A935381EA7CF39401B6471832A0C54C06B705BA24DD03940	0106000020BC080000010000000103000000010000003E00000078989CEAD7272C415FEB90285471204142288352702A2C4130BB11237F712041EBA9264800312C41AC02CEEF4B7220411EFABCA969302C419274C3BDA56E20410BBE10B8E1302C41796E224AE76C204143E81412F7302C411F4C17C6C36B204178F8083BF1332C41D49C0260EF6B204198841DBA67342C41F68003AD2D6B2041309495A343342C41412C365E47692041D1EBCF3570312C41383FD45556692041419FF114AD302C41878C76CC1A6920411DC49FC74C302C41E807B6E1306820413BC5FB4B9C302C410ADBA67E5B672041C42C073C3C302C41055513B14A662041FA9ED999C7302C4153556F3CB3642041E1C354D273332C417975C577B7642041C49B22D34B342C41E1CB5C411D642041075E920988342C4100E5F5DB206320414099E8483B342C41D72CFD0E37622041EC12CE7904322C41FDEA731B20622041419492FB40312C41E66502E61E622041A8CDE862F3302C41D53A4433BD6120411067DDF2F4302C412C188E70C06020419F8DD0B96A312C4103075264736020413E0CC54540332C41DEB8AEF63B60204104C4ECD32B342C419BB1D6DEA15F2041D874E4F81C342C41C63BAB75AB5C2041E8CD9CDDAB312C41223B12D1595C2041B53AD47C85312C415566F1E9E45B2041DDDDADC4D4312C417834F067365B20411B0247BB47332C4161A8507A865B204181119B4F0C342C411E6D40B2D85A2041CD57BC3D5E342C41A4760D6E7E582041B32E363512342C417984A9F51F572041CEC46AB806342C412960681909522041C3BAD937A8332C411BA26081FB4F204184CE7D89D6332C41B18F7C176D4B20412AF01C6EC4332C41402C47A3834A20411BFB7825DA332C41A7DC1BC22549204135CAE010A4332C413D544680424620418BCA92061F342C4173899652B1422041675BE16975302C41F38F136823422041C5BF7C27A62F2C413C0D8226323D204171B8EB6993302C41551CBECD873B2041D6252F9D5B312C416CE7A3A4923820419AB58F2F4B312C4122E15BF098362041F9653CE287312C41D3AFF0B94E3520414F8C25D473322C4182ED19467A342041DC8F417984332C4157E341FA2A35204155DEFD2021342C41177E9F0D053520414C709BFAB3342C4149725AE5B72E20417F8A4F2C132C2C4146562E06492E2041DF184C399B2B2C413B91CB1CF42F20411EDDAF27F62B2C41FA1F4D2049342041FFF4BFF7C22B2C411AC9E98356482041DE3695B82A292C41E1F9A1A4044820414E5489C4A7292C413CDAE8C5B3362041C0DA89A218292C4113003754442E20417299047CCC272C418BF655641B2E20410CA0DEFFDA252C4102BA14FD5065204121B1456883262C41BE18ECF61A6A204178989CEAD7272C415FEB902854712041
62	4395	D	Miami	4	1245000	FL	Miami, FL	7.02524005191663e-05	0.040450135741549	0106000020E61000000100000001030000000100000010000000AAD24E81F70C54C086A0F4E381DD394031766524F60C54C0591A4E5246DD3940C93640CEF30C54C0F58348F3B8DB3940CDC04024040D54C0CE6A5C74BCDB39407910CBFE0A0D54C02CA2BC5CB2DB3940FB82B02F460D54C02483C5A9A2DB3940B113364D490D54C09BAF19C765DC3940879A32816C0D54C0A403ED6962DC3940594235C06D0D54C0595338068DDC394066F72B378D0D54C01D8FA0DF94DC39404AE0AE158F0D54C0191D0D4A92DD394073EEB3206D0D54C0A90E73429BDD3940D2B676AF6E0D54C0C7F3E75C83DE3940F13903652B0D54C0E73A23178ADE3940E6F882C52A0D54C015CB7EF485DD3940AAD24E81F70C54C086A0F4E381DD3940	0106000020BC0800000100000001030000000100000010000000E8468D19CC062C41AE2A9E6198032141818ABED206072C411EE0C7F503012141EA930A627F072C41D09FE3CACCEF204155CD9F59EF042C41DDE7B9AEEFEF2041C4335BE4DC032C419EF685117EEF20412CF1C0C095FA2B4138FD878FC1EE2041BEBC4CA20BFA2B414664D30F35F72041276519AF86F42B412D32E93B07F72041F8DBFBD051F42B4162BE2994DFF820415E28853262EF2B41BBE0030E2FF9204167282E4B06EF2B415B50B88C290421410059F9CA58F42B416C21E23D950421416F644FC60AF42B4111073F69A30E2141DDE8C56C97FE2B41608B5454FE0E21418D6526E3C1FE2B417C84F8FEB8032141E8468D19CC062C41AE2A9E6198032141
63	4396	D	Miami	4	1245000	FL	Miami, FL	0.000151563027884549	0.111401191908603	0106000020E6100000030000000103000000010000000F0000003DFDD5B3051054C0A9CA5FB78EBC3940BFC2F1983B1054C0686328E53DBC3940027437063F1054C009E0B27F28BD394086747DC11C1054C054947B1C2EBD394092B5FD601D1054C06D566CC933BE3940C2EF1442EC0F54C06D566CC933BE3940B3A574D4C40F54C079A54E4F3EBE3940CA7D75CC8E0F54C0B5E241D141BE394039F8E8BE900F54C02E569DB4F4BE3940F16739E2660F54C0E6478C36F8BE394082EDC5EF640F54C0ED5CF31F5CBE39402F9EFD25620F54C0B4BC453C66BD3940F1D1821AD50F54C0748D4874CCBC39409DCED640E10F54C02BC4AFE1B4BC39403DFDD5B3051054C0A9CA5FB78EBC39400103000000010000000D00000016C7D757C40F54C09C6F5E9206C03940E32D5AF7C40F54C069137BF6C9BF3940C63001A1900F54C03BB72593CFBF394059FD3F51900F54C026BE27DE1ABF3940EB9858B8C30F54C05D3A7C9F18BF3940A3529668C30F54C0D79B2003DCBE39409962F0BEF70F54C0A7CC70C4D9BE39401D27CCE11E1054C064543062D3BE39408D1BA548471054C02CD2589DCABE3940B6DB89ED491054C0C877CC0181BF39408194F7553F1054C0525F242182BF3940EEC7B8A53F1054C06917B8F500C0394016C7D757C40F54C09C6F5E9206C039400103000000010000000B000000C98A19959F0F54C0C376CF380FC3394005FA93779C0F54C0432DE70195C1394049BDD0844F0F54C089E5BD1B9FC139408BC14CA64D0F54C05956C81343C13940D6C36C09860F54C07A6925D540C13940D5786380A50F54C0E96A95DA37C13940D5786380A50F54C084E5F37DFDC039402D4A9E25C70F54C04444553FFBC03940AB412B3FCF0F54C05AAFBFBF9DC33940AD739C73A10F54C00233FD17AAC33940C98A19959F0F54C0C376CF380FC33940	0106000020BC080000030000000103000000010000000F0000006A932F093A8E2B41CC30DABFC72A1F4116A92F54C9852B4162BFB942AE231F419F130EE730852B41D587362301381F41A31F3D9B918A2B41DB1DF73D8D381F414331741B688A2B41783154F5394F1F41A3304EED1D922B4159461465504F1F412DDC259B4D982B410DF32CE94B501F41926F1D85C8A02B4140291696B2501F41800864E56EA02B416F6A6B2432601F414684C5C600A72B41EAB62E4A93601F41132696FB58A72B41B87BF3860D531F41A9061FBAD8A72B41A552F801C03D1F4121D12E16D7952B41E3FAEE9337301F41BF617957F0932B411A8D6213272E1F416A932F093A8E2B41CC30DABFC72A1F410103000000010000000D00000093015E3F44982B414919FDD8D5771F41B4C9A50D2F982B41E75F340395721F416A0BC7A865A02B41E381069829731F415CD3F4AD7DA02B41C21F85EE80631F41398F535D6C982B41DC5F6C7A37631F4137AEAEB97C982B41855E4308F75D1F418D2A14D745902B41C2618F3FAD5D1F4107C972AA218A2B41CF3F37C30D5D1F41FA97FDC8CA832B417CB0F8D8385C1F41A8B2811A55832B41E5B96AD5056C1F41786AE8A2FE842B4180641E8C236C1F41C509BF28EA842B41C2E4150221771F4193015E3F44982B414919FDD8D5771F410103000000010000000B0000001B53C6EDD79D2B417E6A80FC33BB1F41E201E2266D9E2B4169E8B7186F9A1F416F4EAA2E80AA2B417DC3BCBE729B1F419AE3D92CD1AA2B411A226BFD79931F417C90CABBF7A12B411C88CF1A2E931F4131501715089D2B41236ABB6958921F417C9CACCA0B9D2B41828068B6498D1F41A4ACD214C4972B4130D47C72088D1F4166A46EE753962B413648C1E477C71F415E014AFB829D2B41080319CF9EC81F411B53C6EDD79D2B417E6A80FC33BB1F41
65	4398	D	Miami	4	1245000	FL	Miami, FL	0.000148578182461279	0.102251279638035	0106000020E6100000030000000103000000010000000B00000051D011EC441254C0226907C102C63940A5C2529C441254C0F4841BAC5CC53940FD17EA3E2D1254C09770814862C53940478764212A1254C0ACFD104173C439403345580B6E1254C0E67557856CC4394072201C9A6F1254C024961DAD2DC4394085676DA6C41254C05D04CEB224C43940F770B0D4C61254C0892B4427CEC439400306F39E7D1254C016B3FDE2D4C439404D2237CD7F1254C08AA11CE6FAC5394051D011EC441254C0226907C102C639400103000000010000000B00000045383D5AE21054C04847E94E87C63940793CB97BE01054C0C86CEFB880C53940C24D83F8391154C059747BE17FC5394041953ACB631154C0C5B1121974C53940CF20F9DB621154C0DA9A7811EAC43940FD025E1FC31154C06666BD64D8C439403FA83F86C41154C0DB8E86F373C639408DE589BFA41154C018D04D9380C63940863710378C1154C03BE7F10C7EC63940DD05665F3B1154C09B3F5D2688C6394045383D5AE21054C04847E94E87C639400103000000010000000800000046222FC9131054C0CB282F769EC73940FD70E95B101054C0886570EABCC639406D5285CAD50F54C016E8157ABDC639409F088984D40F54C0C9D047E67FC6394051F27659D30F54C0DC40734AFEC53940C7641BFF581054C02BF0CA4CEEC53940DCD08D765D1054C0843AC10B96C7394046222FC9131054C0CB282F769EC73940	0106000020BC080000030000000103000000010000000B000000EDE6EE505D332B41AB76DE197DFB1F41C0A0ECD173332B41DF0153E318ED1F41D048F9201E372B415A9EEC8C9FED1F4128B8B1B0A9372B418E09834DEAD81F410B8E30AE012D2B41467B4E5D37D81F410787E8DDC62C2B41884C308CC4D21F413B9615996E1F2B41FD9D4C9BD8D11F41593315E90C1F2B41D8EF27D786E01F416DEEABA6892A2B41A145DAD93BE11F416E7E9F72202A2B41E6D6E040B5FA1F41EDE6EE505D332B41AB76DE197DFB1F410103000000010000000B00000056B97D17F96A2B41B5D9E341CB0320414AEC0275546B2B4159D7DD24D6F01F410AEBE47F495D2B41EA258D729BF01F419F21900CBA562B412D2ACC7383EF1F415A2C880EE8562B413BA583D18DE31F415A7F7FD8CD472B41A7ADDD25DBE11F41486D23807C472B414C012F42C2022041C2A2D53E784C2B41D52F264B550320415DBB62F151502B41310F2FB63E032041435A90EC005D2B41BF5239AFC003204156B97D17F96A2B41B5D9E341CB0320410103000000010000000800000076E994B1518B2B415EC7B16612102041CCC76193E98B2B4109E09E6B4D062041A04CD8511A952B41829B4A0D61062041F935266051952B41C0D65753B603204190D5FC8488952B412D5716F031FC1F419507BF8C90802B4164608F2F92FA1F413C68AD8FC27F2B41D99CE447A40F204176E994B1518B2B415EC7B16612102041
66	4399	D	Miami	4	1245000	FL	Miami, FL	0.000247435648589089	0.125890735118139	0106000020E610000002000000010300000001000000170000004FB29D3B761154C0977E270514D739407B6F67BA721154C05A090B5E5CD639407334191E731154C05A1E5A1A2ED6394005F5F3C7701154C0F71C8E7E99D53940156C568F711154C04601C46C68D5394022776FAA6D1154C0AC48D63FDAD33940222A0B61801154C0DEA0F1E9D6D33940359788A8E31154C03AEBE437C5D3394075AD9AD3E41154C0E689A34F04D43940DA9A59BDF61154C0E689A34F04D4394043450231FC1154C00798093864D539401B54CC55141254C028E34A0360D53940461196D4101254C0197A034DFDD33940461196D4101254C0562C2B5283D3394022B4164D241254C04CD1498480D33940912E8A3F261254C0A9A64DB1F7D33940199EC40B351254C0A9A64DB1F7D339409753869A361254C0B70F35F5ADD439406ABBB8764A1254C0981E8C59A8D4394063806ADA4A1254C0935AB38BA5D439409DC6B1864F1254C05BDC450006D73940155777BA401254C0885598CB01D739404FB29D3B761154C0977E270514D739400103000000010000000B000000587F4C4A851154C0BC01DECA5EDC3940FD0FF2727F1154C066CDFA5AB8D939405791A1C8D21154C0447A6656AAD93940CD0B15BBD41154C02DB3D6D1EAD9394043AE2F6D131254C0244B2004E8D93940191A99240F1254C03859E581C9D739403E5190DA2F1254C04DC45EE6C3D73940BB19335E3A1254C00838B0A84ADB39406170DC48AA1154C0D889404657DB394079228DACAA1154C077428F2F59DC3940587F4C4A851154C0BC01DECA5EDC3940	0106000020BC08000002000000010300000001000000170000002C17D1C7C0522B415A742A143CBB204139429BC458532B417B8D67C347B32041947C9DF84B532B41C7CBF18146B12041BC5009E8B2532B416A249CA5D6AA204102BC42A596532B410475D730B6A82041BA0445724B542B41D24CD77576972041267D9B3A5C512B41FAD1CB4E4D972041D1C342CECA412B41993C7818739620415E21CB0F98412B412940ECAA2E9920415C651BC7C83E2B41E281F1BA2A992041A1DCB685D83D2B41043F4FEB68A820414015DC590F3A2B4142D63EF834A820413BFDCD8CB13A2B411BE4703FD79820416E6328EFB83A2B417F10523D8E9320416745E342AB372B411C1A24DF6A932041D65627E055372B41D818F15994982041FC3BEFAE03352B41C9C8C61D91982041AD1F6C23BA342B41F71A3C7976A020414FEAEF069D312B411A7B06EF33A0204175AF208F8D312B4179C3E1BE14A02041444EC246AD302B41ABD770C170BA20416CB29FA9FF322B413F3C6A5545BA20412C17D1C7C0522B415A742A143CBB20410103000000010000000B000000DABE5D2B11502B411F756005ECF5204187E5784625512B41C264610388D820415EF12B8514442B411CEDFA16DAD720417EE8BD6CC2432B41498253E7A4DA2041F9B3FD96ED392B41933B190678DA2041BDE0AD6DBA3A2B4103EAFC67F7C220411C23C47499352B411EC15F0BB2C2204154708FD1BC332B4190C7C93BCDE92041FA984935544A2B413AE362D978EA20418B1203CF344A2B41DC2AF18BA5F52041DABE5D2B11502B411F756005ECF52041
67	4400	D	Miami	4	1245000	FL	Miami, FL	0.000437976946159324	0.208970633521757	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
68	4401	D	Miami	4	1245000	FL	Miami, FL	5.97500138610485e-05	0.0315454563301569	0106000020E61000000100000001030000000100000007000000DA43C8671C0E54C004A0BC55F8D43940E215F8F2510E54C0DC078E4FF1D4394052BD4E4DB60E54C0794B5D25E4D4394079571799BB0E54C09B1E24BD88D63940010638735E0E54C006594FF493D63940B5031810260E54C046D129E6A5D63940DA43C8671C0E54C004A0BC55F8D43940	0106000020BC0800000100000001030000000100000007000000EBC3314D6ED92B412E9D50309FA4204153844DCF08D12B41A57E6B8E44A42041C07B4E2C4CC12B411807D7D59AA32041601822345CC02B4191FC2FDFD2B52041F4D0D276F7CE2B41C874194265B62041D569EE4ACED72B413BACA2B039B72041EBC3314D6ED92B412E9D50309FA42041
69	4402	D	Miami	4	1245000	FL	Miami, FL	0.000262699798440735	0.138803165769386	0106000020E6100000020000000103000000010000000A000000E3687AC8D50D54C0988A6C6BB4D139407955772AD50D54C0085EE9A03ED1394036A38180BE0D54C09BA467FE41D1394027BB6998B90D54C09D80A3871BD03940EA8F1ABAE90D54C0E8A21C2A18D0394032A1E436430E54C0E4B7715607D03940D5A0DFBF450E54C02DB8BA0B30D13940ADA4D154170E54C0A4F5A8D932D1394003F6311C180E54C0785EC350AAD13940E3687AC8D50D54C0988A6C6BB4D1394001030000000100000023000000421E611B080C54C04B48D7A576D439408EA5A30A090C54C0A5CCBC0B4AD3394017956A25480C54C0F303F44E47D339404EF2C0538A0C54C096AD027044D339403EDAF846860C54C004F57CB98ED23940E5BDEE30CA0C54C04742792480D23940B2F85565510D54C01296C2CD73D2394053B43A85510D54C03CD2DCFBB5D23940951A7769740D54C02CC5427FB1D23940C149BC97760D54C0DD41738429D339400102A3B9D80D54C0A7D067AA21D33940D9A9A5F8D90D54C0F749D45C05D43940441EE7E7DA0D54C0961BCD1015D43940715BAF0A500E54C07AA7F87B06D43940E215F8F2510E54C0DC078E4FF1D43940DA43C8671C0E54C004A0BC55F8D43940F9FE6B18BC0D54C0C9B0A4D20BD53940F151A2CCB60D54C0660FBAB9B5D33940FDC91567770D54C0EE1507F8B7D33940C2C59945790D54C03E6E65C1F8D43940A99EC2CD460D54C0234A2583F6D439404A32EF94150D54C0A3DDA9FFFAD43940F9B1FBEE130D54C094431CCF8DD43940A58E6877120D54C0DCE4BB9E2CD439404D22953EE10C54C0DCD29B7F2BD43940893808008F0C54C0D6AF67143AD43940758C899F8F0C54C096FBC6D265D4394077845C74750C54C03DF3BCAC6DD43940F98CCF5A6D0C54C0931C3E5661D43940E9B6D2D86F0C54C00519B586C8D4394049EA9328700C54C04C35D2EA15D53940F3D7D8E34D0C54C0CDC856671AD5394079F898334E0C54C0B9C4AD5C51D539407DCFA6880B0C54C0564612BA54D53940421E611B080C54C04B48D7A576D43940	0106000020BC080000020000000103000000010000000A0000004DE8CB46B9E42B417E6EC9EF778020415C4E3BD9D9E42B4166D518875D7B2041D45343C467E82B411DED7248887B2041A7A8354F40E92B41DD577938C76E20418AE11A95B3E12B4161807B5F966E2041888B3FE6AAD32B415C33216DC66D20419D5E9DA731D32B4161C6E0F3A07A20411A978F8A79DA2B414E03DF16CB7A20411790226952DA2B41214CB107F87F20414DE8CB46B9E42B417E6EC9EF7780204101030000000100000023000000BD13D0BCF42C2C418D0EC106829F204102A9E2CBE32C2C41898BED737B922041549D6EFAFD222C41C004367B4D92204113E140A29C182C4130843E591D9220413B9A55964B192C41695A35BF3E8A2041E57D2462A50E2C41DBCBA35D8C892041134A4CD970F92B41A638BDA4E2882041E56E1E6D67F92B4142F1C6B1C08B20414A86519CEEF32B411E559B80868B2041E4D0190C8FF32B41D6711943B9902041C6FA9BFE2AE42B410EDD8E994A90204164A421E8E9E32B4199DD49F4279A2041DCD54257C3E32B410B8140E9D59A204140B179C664D12B41618D8A46189A204153844DCF08D12B41A57E6B8E44A42041EBC3314D6ED92B412E9D50309FA42041B1395A2B88E82B41E550855D8EA520415148FA7E73E92B41E9F25A08BD9620417BD23D0965F32B412F03DE29E596204180959C9D04F32B414A4988EFCAA4204100BC263AEFFA2B41FAB1CA3EBEA42041B6391B5AA7022C410F9EF9F1FBA42041E67F0ADDF0022C4190DC603141A0204166FBE74B32032C41FC9BC0820B9C2041728BA2D9EA0A2C41BF82890D0B9C20416FCCA955D0172C4161D0F0E9C09C2041F9189C59B4172C41603A6CF9A59E204188D2A998CE1B2C415121297E039F20417590EBAC141D2C419C5C8FA17C9E20418D37B296A91C2C415355869DF4A22041E526B5D1971C2C4135220CFA4EA62041C96DFF80F7212C41A6A4E22E89A620410A6A0640E7212C416FC75EB7EAA82041DC7C49ED5B2C2C414512C58620A92041BD13D0BCF42C2C418D0EC106829F2041
70	4403	D	Miami	4	1245000	FL	Miami, FL	0.000509919217165589	0.16597353514472	0106000020E61000000200000001030000000100000009000000889754BE9E0F54C0BC8A839A0DCE39405933F3F69D0F54C0C3BB8CFD8DCD3940F12B71D86E0F54C085DE8F9993CD3940AADA10116E0F54C01D53529CADCC3940AC417760D80F54C0A48E26C89CCC3940CB1BCF83151054C0585C61B051CD3940AD691E20151054C0ECD483330CCE3940DEE8B4859F0F54C0E75778391ACE3940889754BE9E0F54C0BC8A839A0DCE39400103000000010000002200000065290498500F54C0CB10071DB5D5394093B1B17D4E0F54C0795562FC06D53940A9C11D70E90E54C083285DCF17D539400FC52E9BEA0E54C075052CD0A6D539409F06F5F5C80E54C0733B8C2DAAD539409F658FB0C50E54C0798132D733D439404E4FDE1B710E54C0CCCD7F7540D43940A1411FCC700E54C01B9473ED01D43940CF5F7E2D830E54C099242FAFFFD3394075D83B3E820E54C0387479DB9BD339405E0BB7D2A40E54C02D10087E98D33940155A7165A10E54C07E981B2512D23940BBDBA68CC00E54C079EFF20511D2394085D6DF7FBC0E54C00C4CA7BCF0D03940DDE9AB979E0E54C08392251AF4D039406A2490B2680E54C0C548AD32FED039409E32CC43650E54C0632074756CCF394069B72B2E0D0F54C0B942289B64CF39401630E93E0C0F54C0469B0CA32DCF39407D381B9A4E0F54C00332502629CF3940C7E3CA22520F54C0D92CFCB8B4D03940DDBB271E760F54C046BDF2FDADD03940E98BF29C720F54C0C7F7143354CF394081A6BEBC181054C0BB28947B3DCF39407D71A2231A1054C0E8EF2A27FECF39404FB7E49FF60F54C0C897145C02D03940D9B98AD4FA0F54C0A6D51E63DFD139406B55A33B2E1054C0128FA005DCD13940A2C56809311054C018419916DAD23940BBCB786DCC0F54C025B6AEDDE5D2394002E28A98CD0F54C0544ED9BBCFD33940F6A74DCF8D0F54C0637FB376D6D33940CAEA8350910F54C089F85CF4B5D5394065290498500F54C0CB10071DB5D53940	0106000020BC08000002000000010300000001000000090000003E785579469D2B41FF1286778B572041E9123EE26D9D2B41DDBC832604522041B1FD53F7D1A42B41FAA6BD424D522041A46B15F4FFA42B4130CD5F61564820414CC88C2D53942B41CB68163483472041FDE02C36B08A2B41962582D64B4F20411A296215B48A2B41018915BC6057204174091E64269D2B41AC689647175820413E785579469D2B41FF1286778B57204101030000000100000022000000D759B9710BA92B4159FEAAAA84AC2041ACA4CA0D6BA92B41D95F66B5F9A42041FA9FCC8D43B92B41CF071EE6CBA520412DE7B5640BB92B4141DA6ED6FDAB2041B1A64B1D52BE2B413781120D2BAC204199DCF3BEEDBE2B4113481B9DF39B2041FB23503231CC2B418891DF82939C2041284013CA41CC2B419165FFF9DD992041E94CDEE15FC92B41B70358C0C0992041CA861AEC8BC92B41409C0FAD6D952041C32EF2941FC42B417B8B6F32409520414F42C994C2C42B4198CF4237578420416C97FEA2DFBF2B41E22E3A7243842041B810E2FA94C02B41605C2CB0C6772041F5EA59C845C52B41FBF4080DF3772041280C7476B9CD2B41164371C16F782041AB5D5A905DCE2B41476A806C0867204176A7968006B42B414239DADC89662041A95CA9942FB42B419E1C545B28642041CCA3A0F3C6A92B4194548D22E7632041A25588A91FA92B4166414C0D0A7520415F0C161B7BA32B41501FAD0DB77420411D2D2AF71DA42B419F46874CBC65204185B815C40F8A2B4169FCD51D9A6420411A4C254FCB892B41012F58E9F26C204186F2CA4B5D8F2B41DE3159B2296D20419E9EB238968E2B41148AF1F7D38120410D95713F86862B41A2C952E4A28120417C4E99A605862B41966B9061A48C2041455C91F2CC952B414F557D0F3E8D2041D2AE7B2E8F952B410FA581E15F972041BC86B80E909F2B41ACE7263CB99720418A3A69B7E49E2B412A13F0FF7EAC2041D759B9710BA92B4159FEAAAA84AC2041
71	4404	D	Miami	4	1245000	FL	Miami, FL	0.00036731427576342	0.184376642387239	0106000020E6100000050000000103000000010000000D0000009918D040490D54C089562C67B7C839407D8439F8440D54C03936F1C4E2C73940B348E5B6550D54C043AE04ED36C83940CEC629BE6A0D54C0FA51E47B8CC83940010D716A6F0D54C059CD708CAFC839401D66B916740D54C0FD850893BDC83940C914DEAB770D54C0F97B5774D3C83940FD5BEBE67D0D54C03D8ECE29E3C839409D6AF521840D54C048020B7C9FCA3940A59B1B6B500D54C0EDFB82BAA1CA3940B57118ED4D0D54C0395DA4BDB2C93940553E579D4D0D54C0592FB7A971C939409918D040490D54C089562C67B7C839400103000000010000000600000012D99ABC070E54C0C941CA157FCB39408E6C4E283B0E54C0CDDAA10678CB39407355D1063D0E54C0D7C3494187CC3940D97AD549840D54C089FC3FF696CC3940D574A346830D54C0A47C1D4591CB394012D99ABC070E54C0C941CA157FCB39400103000000010000000500000012704200540D54C0477BA8F37CCD3940AAB7D9C7860D54C0A835A2BB71CD39401BC11CF6880D54C0B83125C2A1CE39405521886D570D54C07966487DA8CE394012704200540D54C0477BA8F37CCD3940010300000001000000120000001630E93E0C0F54C0469B0CA32DCF3940725D788B0B0F54C08841D0390ECF3940D1656C13A70E54C0D949ABD81ACF39408A4F5AE8A50E54C079E7445AE1CE3940E9171D77A70E54C07B9F9E16BACE3940153EBEC4A50E54C0DE1E6EE23FCE394067BBC39FA10E54C0B8A0136315CD394071AC1986800E54C0E8EA13FC13CD39408FA94E165D0E54C0D81227341FCD394049CE8A875B0E54C04AADA2196DCC3940F105C8F8590E54C0589C09043CCC394009B8785C5A0E54C09E5DEF2CB1CB39405A98204B480F54C0869F845599CB394089FC8112490F54C0CED9B7B1DECC3940C912943D4A0F54C0D8EC2D9E27CD3940D74DE2D9490F54C07A13657E54CD39407D381B9A4E0F54C00332502629CF39401630E93E0C0F54C0469B0CA32DCF39400103000000010000000F00000081DB48A9890C54C04C95F3CFD0CD39403EBF047B870C54C007BD4E69CBCC3940D517076CAE0C54C0A74E47CDC5CC3940D517076CAE0C54C06332BF14CACD39402212FAA3CC0C54C04C9BF197C5CD39406958BCF3CC0C54C0C801F3441BCC39404BF5A9D2320D54C0C8EA870619CC3940734DA793310D54C056D4A07C82CC39405FA12833320D54C05B4AEAD9B3CC3940BDABB64C3A0D54C0985353A911CF3940C2EC36EC3A0D54C0698F121928CF39409653B98B3B0D54C08E1DE84345CF3940EBF5F600800C54C01559E23657CF394036D06FA47B0C54C04C95F3CFD0CD394081DB48A9890C54C04C95F3CFD0CD3940	0106000020BC080000050000000103000000010000000D000000ACA6EB445EFB2B4171F0778AE61C20412506C58718FC2B413BC3C204B113204122ACB84572F92B41F5AB89725217204147DD8BDD1FF62B415B411365021B2041035A33D261F52B412DF6AA35861C20419CB7572DA5F42B419B38BAA8201D2041C936CBCF13F42B416ED7307E121E20417AAD6C7C18F32B412CD0BA3CBF1E20412312BEAF00F22B4141917F33FE312041F8A255BD1DFA2B4107257E8F2332204179CA6FCA91FA2B41EDE6C647C9272041A1418DA5A2FA2B41811C1D81F7242041ACA6EB445EFB2B4171F0778AE61C2041010300000001000000060000006F6B2EDA4BDD2B41EAEDF6E58E3B2041A90E33F73AD52B4129B8955F343B2041BF3AD01EDED42B41D11F086FF446204127BF8CF8D8F12B41AA7B95CCCE4720417548B30713F22B4122635852783C20416F6B2EDA4BDD2B41EAEDF6E58E3B2041010300000001000000050000005E32C60E5DF92B41EE4DB985D1512041BA89205566F12B41B51462D6485120411EE9548BFAF02B41F0761F9B745E20419C205171BFF82B41EBB0AA35CB5E20415E32C60E5DF92B41EE4DB985D151204101030000000100000012000000A95CA9942FB42B419E1C545B28642041F06F9AC14DB42B413765F31ACC622041390737DD0FC42B41DFC33BA46F632041A4A6D28442C42B41FE9D5F30F2602041B052578306C42B4132E7754C3E5F20414DEA8A9952C42B4130B0D232F3592041FAE328740CC52B414986EB34054D20417AA438F83DCA2B415B10E573FD4C2041734E5980CCCF2B41FEFF0F45824D2041627236B416D02B41A5CCE317CB4520419EC38F7958D02B4144E14203AB432041051C91E851D02B41B559B7E3A63D2041A11AFFCBFEAA2B416A5A0CA8663C2041F18005A6CAAA2B41817508667F4A204177BAED0C97AA2B417025D900A84D2041E8632AD0A3AA2B41879658DC994F2041CCA3A0F3C6A92B4194548D22E7632041A95CA9942FB42B419E1C545B286420410103000000010000000F0000009E5A6DFC15192C419B446DFBA4552041044935497F192C416B76D903524A204118B3899D63132C410E8F93400A4A2041D6421D0752132C41433F784F515520416B970BAB940E2C4142FF122618552041CB84F2E4A40E2C415BEEFF379F4220417F0FF266A9FE2B41CD7919906D422041B11A2666D4FE2B410CBB0CA8FF46204105226E12B8FE2B4155930010234920410F0DE53E4AFD2B417EFD97D66063204105DF18B92FFD2B41C5FB838E59642041F2F3C7BF14FD2B41E15B31EF9C65204153A345617F1A2C4114B37FC2916620412C80A006491B2C41C29F7D6CA85520419E5A6DFC15192C419B446DFBA4552041
72	4405	D	Miami	4	1245000	FL	Miami, FL	0.000171299556996019	0.0568181309267571	0106000020E610000001000000010300000001000000100000004BF5A9D2320D54C0C8EA870619CC39406958BCF3CC0C54C0C801F3441BCC3940BD416D14CC0C54C0B8579A1FF5CB3940678BA1257A0C54C037E25719FECB3940F957E0D5790C54C097D9E37649CB3940793F4DB1930C54C0AC8735CAB7C93940AD43C9D2910C54C0AD36BBD912C93940451835AEAB0C54C088D6C5DF09C9394083462FF1A70C54C01959620089C73940A6B6B333F50C54C0D9E57D2B78C73940493FCB9A280D54C0D453C04A79C73940A79C8F682B0D54C0B675987885C839409B9DDA53310D54C0B9B93DB07FC939408BC7DDD1330D54C03A29DBA649CA39408BC7DDD1330D54C08543539C41CB39404BF5A9D2320D54C0C8EA870619CC3940	0106000020BC08000001000000010300000001000000100000007F0FF266A9FE2B41CD7919906D422041CB84F2E4A40E2C415BEEFF379F42204164546A80CA0E2C4167F0D24FF840204192084BBEA41B2C4159E153EE6F41204141A12282BD1B2C41F6666D619C39204108B6251DCA172C41211F889A2E2820411579165C20182C41DE8CFD8709212041BF3E834F12142C414D3FF3A19F202041C212827AC2142C41D3B0597DF30F204134D91F00A4082C4153BB39F2250F2041E632980593002C41A7288EEA250F2041C9379C7410002C4119B21BE9C31A2041F12A16F511FF2B41CAB127EB992520411542A058A0FE2B4192899E84592E2041378565C48FFE2B4192360CE9173920417F0FF266A9FE2B41CD7919906D422041
73	4406	D	Miami	4	1245000	FL	Miami, FL	1.53494720507297e-05	0.018048003252475	0106000020E61000000100000001030000000100000008000000F9268878F30C54C042F955958AC339407BEBE287010D54C025E92D2D89C3394073B094EB010D54C08E9241495CC33940E177ABF8500D54C0751BA44555C3394021536F87520D54C02790A266F9C33940653D69FFE80C54C0CC89AE0606C4394091FA327EE50C54C0872A65FB8BC33940F9268878F30C54C042F955958AC33940	0106000020BC0800000100000001030000000100000008000000442D590F2D092C41A2233A9628C71F41D12CCE46F8062C416BAF2E8B02C71F4173CBF9A3EB062C41F88BC77F1EC31F414D90231C84FA2B41E627FE9D5CC21F41391044973AFA2B419CABC5ED94D01F41A74BD889C90A2C41C8E6ED28E0D11F414B4E6B8B5E0B2C41BA9E666A4EC71F41442D590F2D092C41A2233A9628C71F41
74	4407	D	Miami	4	1245000	FL	Miami, FL	0.000133509780198438	0.076333589706567	0106000020E61000000100000001030000000100000021000000F52C9B48AF0F54C098F05827BFB93940E997587EF80F54C04C49658AB9B93940D5EBD91DF90F54C055E753F2AAB939409EE5869A391054C0ABAB9616A3B93940C70CAD7E871054C02DACD05E82B93940B587B6299F1054C0A56DBA6D78B93940291C72ADC21054C058C6C6D072B9394001C474ECC31054C058AE595CD3B93940F958762BC51054C068B2E00EECB9394076844BDB601054C07AEAECBF29BB3940027437063F1054C059AFD35C2FBB3940027437063F1054C0FC23A265CBBB3940627698F42C1054C0A8591532EEBB3940A10F91F8271054C0097FD0C405BC394062F201DF1F1054C034CD138603BC3940B63779431A1054C0855E383D13BC394029D5ED68131054C057DA26381CBC39400611A7FB0F1054C096E739EA34BC3940228D5171B80F54C02BC4AFE1B4BC3940E289E6227A0F54C0894252F207BD3940A93624C0390F54C0AC1548C509BD39406A5B6031380F54C059489666CFBC39402A166470390F54C0E9FDC3B9ADBC394066BEF03B670F54C0134C077BABBC3940ED49AF4C660F54C0CC725E1FFABB394085C265EAF50F54C079C652C6EDBB394085C265EAF50F54C0B6A5ABC73FBB3940D3CE4FC2C30F54C0934FABC248BB3940F750CBA4C00F54C0345DE58FBDBA3940B99E3A4CB70F54C038D906EEC0BA3940CD4AB9ACB60F54C0A28295D3B6BA3940BEFEA005B30F54C0892D003752BA3940F52C9B48AF0F54C098F05827BFB93940	0106000020BC080000010000000103000000010000002100000065AA2574F89B2B4116D5B69B94EC1E41EA74FF947A902B418F970388F6EB1E41B490427662902B416D0C7C7EB2EA1E41EAB2C14943862B4154B805C6E6E91E411AB76CF50A7A2B41D3895DABEDE61E414313476054762B4115156A7106E61E4154C7236CC1702B4157BEC9EF79E51E41FA9F7F5A89702B410828C81FD7ED1E41167EF4BD55702B415AD6A172FAEF1E41D0B8C15101802B41B5788F5BAF0B1F41C42D4C9650852B4179DF3B3A3B0C1F41E92103CD46852B41FE04FDAEC0191F4141776ABB1A882B41C47E48DFCC1C1F41FCD1AC8EE1882B4126604D16DA1E1F41E5BE9932278A2B413ACFDEF8AB1E1F41BC8DB58D078B2B41E1E849280B201F41C1AAC9681A8C2B41BE87B57FD5201F4102B5BC90A28C2B410E7676E8FA221F4116652851589A2B4180BA64CC392E1F417376AACD1AA42B413325DB3689351F41E22E2D0136AE2B417EF2657ECF351F411366EF5678AE2B41359CD856C1301F415353B76B48AE2B416EC879B6D52D1F41BEFB8A4818A72B41C11ED6AF8E2D1F418FB28C2949A72B41D472959C301E1F419390F296BE902B4161D86AA4DC1C1F410E945A91C9902B413BBBAEC0C80D1F4101FA28A3A8982B414333A2F3A60E1F418EF5D2A62E992B415CD5CF6998021F41E6EE9907A69A2B417DE52D6AE7021F410737BDB5BF9A2B41873DF69107021F419CF9AFE2589B2B41211E124951F91E4165AA2574F89B2B4116D5B69B94EC1E41
\.


--
-- Name: mdc_holc_redlining_ogc_fid_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.mdc_holc_redlining_ogc_fid_seq', 74, true);


--
-- Name: mdc_holc_redlining mdc_holc_redlining_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mdc_holc_redlining
    ADD CONSTRAINT mdc_holc_redlining_pkey PRIMARY KEY (ogc_fid);


--
-- Name: mdc_holc_redlining_geom_geom_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX mdc_holc_redlining_geom_geom_idx ON public.mdc_holc_redlining USING gist (geom);


--
-- Name: mdc_holc_redlining_geom_local_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX mdc_holc_redlining_geom_local_idx ON public.mdc_holc_redlining USING gist (geom_local);


--
-- PostgreSQL database dump complete
--

