--
-- PostgreSQL database dump
--

-- Dumped from database version 12.17
-- Dumped by pg_dump version 16.1 (Debian 16.1-1.pgdg110+1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: fl_us_highways; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.fl_us_highways (
    fid integer NOT NULL,
    roadway character varying(8),
    rank character varying(1),
    route character varying(8),
    routenum character varying(8),
    district character varying(1),
    countydot character varying(2),
    county character varying(12),
    mng_dist character varying(4),
    begin_post double precision,
    end_post double precision,
    shape_leng double precision,
    shape_length double precision,
    geom public.geometry(MultiLineString,4326),
    geom_local public.geometry(MultiLineString,2236)
);


ALTER TABLE public.fl_us_highways OWNER TO postgres;

--
-- Name: fl_us_highways_fid_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.fl_us_highways_fid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.fl_us_highways_fid_seq OWNER TO postgres;

--
-- Name: fl_us_highways_fid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.fl_us_highways_fid_seq OWNED BY public.fl_us_highways.fid;


--
-- Name: fl_us_highways fid; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.fl_us_highways ALTER COLUMN fid SET DEFAULT nextval('public.fl_us_highways_fid_seq'::regclass);


--
-- Data for Name: fl_us_highways; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.fl_us_highways (fid, roadway, rank, route, routenum, district, countydot, county, mng_dist, begin_post, end_post, shape_leng, shape_length, geom, geom_local) FROM stdin;
2	14130000	1	US   98	98	7	14	Pasco	7	0	1.602	2527.8731	2527.87309124654	0105000020E61000000100000001020000001F000000117BF614018C54C000D256CACA5A3C40903C1E2B008C54C0B8F659D8DD5A3C40D5D3B3FFFD8B54C0072A0530EE5A3C4050F52C4CFB8B54C02B889D25FB5A3C40B853F2E0F58B54C0EA2D40740B5B3C40B9FE1B4EF38B54C0E55B5BAD135B3C404B8B65E2C08B54C05D9CD28A8E5B3C4014CD4A8AB98B54C0E419C4B9A15B3C4036D0A9CDB48B54C002783031B35B3C402FEA416DB18B54C0C928DA45C75B3C4077007C83AF8B54C0F00D07ADD95B3C409BE48496AE8B54C012A96831EC5B3C40E1D2E513AD8B54C04CBE800B1D5C3C40FE325675AC8B54C0E6B52BA8325C3C40092985ACAC8B54C03C28192D425C3C40091EA066AD8B54C0EA49F673535C3C4037FCD316AF8B54C038C5519E665C3C40594E861DB38B54C0E40E8E47825C3C40FE9A66AFBA8B54C08171756AAF5C3C40E21E1A4CC18B54C0D8BD2DFEDB5C3C40E51CD391C58B54C0C8E6B069FD5C3C40183FDC62C98B54C0D7F1BC671E5D3C406441A840CF8B54C05790B9B0565D3C406280AF90E08B54C0A4CE83FC015E3C40F1D0615EF78B54C01AF1FDF1E65E3C402FCF33B5FC8B54C001CE7A020D5F3C407B443424038C54C0089A56A5335F3C403D5DA78E0A8C54C013CD8275595F3C40DAB26B38128C54C05BCCBB9C7A5F3C407F91EE421A8C54C0E1DB64B9965F3C40A704DC7C228C54C0C282B29CAF5F3C40	0105000020BC0800000100000001020000001F000000BA02C4D457BC10413D9C8A1AE65436419DE4C5BAA3BC1041A69A91A64F5536410F1557AE51BD1041CDC7F1E7A95536411FA778A528BE10414E23B249F1553641F03FB0C1D5BF1041EF3445B84A563641C37467A8A1C01041DC0C00D977563641993A1BFF33D010412F9ABAD31759364142A1ACE778D21041A8D57ED980593641CAA7A2AFF0D31041A54045D9E0593641F3354437FED41041B9365A9D4F5A3641F531B87598D510419F469A5AB55A3641C19CC52DE5D5104190F091EA1B5B36412805B36766D610417FCE19AD2A5C3641E5E4FABE9BD610417E2C1978A25C3641DA450B328ED610419F12289EF85C364152B91FDE58D6104150FBD89D585D364161D33D76D8D510411E428947C35D364166753852A2D4104193EC95875D5E36417F0C9CB759D21041AF232C6C595F3641065852345CD0104162163C075260364122D646FF13CF104124988B470C6136418F4D0C7EEFCD104175890E12C461364142C6F21A2FCC1041C697AD7EFD62364151F1770605C710411FC8D941B76636414D879E7738C01041C26AB405B26B36419D990A8F9DBE104165337640866C364122C51ED8ACBC104108CE9CDD5D6D3641FC5D46D56EBA10418B118D1A316E3641A2B477631CB81041E68BE688EA6E3641BF82772CABB5104169E38C11886F3641C53FFFB62AB310412AB81FC013703641
3	10030000	1	US   92	92	7	10	Hillsborough	7	21.014	24.593	5756.3284	5756.32844653598	0105000020E61000000100000001020000001B000000E51555F03F8754C00B1B68C3AB043C40D19F9F4A3F8754C0C78E2322AC043C401C9F14B33B8754C0EEFAB7F7AD043C4083A470D6378754C0F80E56C4AE043C40CD516506338754C08915735FAF043C401C01B368FC8654C0B24C4B22B2043C400F3BD90AE78654C0EB5B1F1AB3043C4088E122A5E08654C00367EC4EB3043C40BA24F889DB8654C0210453BFB4043C404752D5CDD78654C038F42CB1B5043C4018E5E04FD38654C0D59A15C9B7043C4039B57D60CE8654C0EF4DF30ABA043C407EE58652C48654C0A9AC4659BF043C40AC0247C5B88654C0B4A1BB37C7043C402D0EEB01B78654C08466306BC8043C40B604008AAD8654C01B7088C9CE043C4067E394F8AB8654C062930D27D5043C40766E0179958654C093DA113EE5043C40768D29DA708654C085AF3EAEFE043C401A44B38D318654C0FA808D302A053C40A0548CE23C8554C0A75D1B5ED3053C406F27E68BA18454C03FE6FE463E063C40E39BB84B5E8454C0A49D2E8C6C063C408A32EFAAC88354C09E7FFA76D3063C40CE5C7D3EA98354C013E5644EE8063C408F542E3C928354C072CC8F3EF8063C408CB45F06918354C0BC82BE24F9063C40	0105000020BC0800000100000001020000001B000000AAF94E362C20124158FA85DA30763441963183475F201241F84D50CA32763441E115479D7A21124107F147523C763441977FA100AB221241939BD50F40763441FB967E402624124148230B8F427634410DFE8B47F53412416A0E901448763441BA0B1FAA883B1241E9225FA04976344117203EAA803D124148235FA0497634414746AE32133F124154368AB25076344148EA8E9C39401241663F6A4555763441F3E002E69B411241E3FB221560763441D4C7AF1F21431241BD836CB96B763441C1D1FE403A46124112F5C15D877634412AB8C4D7C9491241639A33F6B0763441792B08FA544A1241DB37724FB776344127FE1E25404D1241242E4DF4D8763441AE5AD2F2BC4D124146A964FDFB7634414A8C0883AC541241C7B4823F5177344154D8036CF65F12413F226FDDD77734418B98818079731241FE002E06BE783441651CA096E4BE12417100C6963D7C344136E91BEEC5EE12419A5DA6B4737E34412042D960800313416EEC07CA687F34416562D5959E3113417C79F0118A813441B91A69D44D3B1341CDA10B54F88134410BBCE24D654213416CC0BED34C8234414A0273CDC442134175C1F89B51823441
7	28125000	1	USA 301	301A	2	28	Bradford	2	0.392	6.818	10340.8459	10340.8459496541	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
17	31040000	1	US   19	19	2	31	Gilchrist	2	0	0.612	978.6881	978.688143730153	0105000020E61000000100000001020000000C000000807A9A31F0BB54C0D416903759973D4083126E9DE9BB54C0DC646E7D58973D40718AEF28E2BB54C02F1CA7E156973D40059B5DC0D7BB54C0E6AB0A5D53973D40F97ED20FCFBB54C0BE6C920052973D40EAC9D1668DBB54C09B0397934D973D40DC5F2F6287BB54C00E6EDF224C973D402AB8C3B375BB54C04FCD3CB446973D40C223E9266FBB54C08A3708C345973D40E22F006458BB54C0C681723444973D408AA4B02052BB54C06D2638C742973D404BE37DF94ABB54C0122269A83E973D40	0105000020BC0800000100000001020000000C0000004AB1309E19D6E340618DBD54F63D3D41F24DEE7B0CE6E3404FB40A2AF03D3D41B779FED51CF8E3405C0661D2E43D3D41C73B7A6B5111E440A49EDCECCD3D3D41C2E003196126E4406002A68EC33D3D410A9E76D696C5E44086229DC3953D3D41510D7C712BD4E440B7528CD38B3D3D41EA7A3863FEFEE440073BBDF7673D3D411AB7F3DFDE0EE5404601D69F603D3D41E1A1FBA80F46E5400F0213A4503D3D41D1FC97563C55E540403202B4463D3D41D9141ED28966E540237E27872D3D3D41
18	91020000	1	US   98	98	1	91	Okeechobee	1	0	3.134	5043.8211	5043.82106687381	0105000020E61000000100000001020000000B0000003D7F2BFC163554C0128BC598BE323B40C694028C193554C04A19B2FCD1323B40DFE6F862193554C0AA085947DD323B40C00F33F9193554C02A929831E5323B4015B2FB5C1A3554C0E7C0689AEE323B40B51998D01A3554C08EE612EDEC363B4013D1ABEE1A3554C0F19DE1F7D8373B40329EB6331B3554C02946CE34BC3A3B4063887A9D1B3554C0B2E3BFAF6A3C3B40C79A0EBD1B3554C0634D9835EB3C3B40D294BF191C3554C0056E1F75643E3B40	0105000020BC0800000100000001020000000B000000C040EE3934B72541B754F062E1C62F41F4BB4048CEB625412F25C05BB8C72F41022B0079D4B6254146E9EEA135C82F415EEFAC11BDB62541C38662688DC82F41F94A1D76ADB62541D0829CC5F5C82F4172FBBE228CB62541370E931543F52F4135A698EA83B625415F6855A97DFF2F41486359126EB62541B1EAEB45C30F3041CAC51C3157B625415C4328141719304128275C5C50B6254124E494F9DF1B30412EEE5B4F3CB62541501353830C243041
22	28125000	1	US  301	301	2	28	Bradford	2	0	0.392	630.8033	630.803326274166	0105000020E610000001000000010200000033000000F32669389E8854C040F3716918E93D4021B32D109D8854C09794E0C329E93D40CCB1E2369A8854C0B4B1F8BC51E93D405CE955F5978854C0A511CE7C6BE93D4086A17548958854C08C09E72189E93D4083C073CE958854C00C66E1DB93E93D40B52EEF76958854C068DC2E559AE93D40144C9025958854C059774ADFA0E93D40573F0BDB948854C032CE4B80A7E93D4093459198948854C024106951AEE93D40E2236494948854C0026649D0AEE93D4059DF675E948854C07B1CD73AB5E93D40B1871628948854C063F54D4ABCE93D40449DE4F5938854C042B302D9C3E93D406901C6D0938854C080753DD2C9E93D40369DEFAB938854C04F36573BD0E93D40F6F11B90938854C0FD2AF877D6E93D40813AF978938854C03E30E0A1DCE93D408BA4B966938854C06B064ED3E2E93D4078CFC65A938854C0DD92FE0DE9E93D40B4CEA453938854C0E2295715F0E93D406BDEA057938854C0A765097DF6E93D4042F0F05C938854C0A9DE65D3FCE93D40E2EF1E65938854C0B5C655AD02EA3D40767E9F78938854C0846A0E8909EA3D404B500B90938854C0E361F5C610EA3D40A8C09DB0938854C06C21042A18EA3D405922C1D1938854C0EFBBBCC41FEA3D40A9B8A0FB938854C0094F385D27EA3D4044C76833948854C0D33AA7872FEA3D40CE704268948854C0133A9D3136EA3D402FCCE8AF948854C059BADB3D3EEA3D4086CF2FFF948854C0DEF990C545EA3D405563C94F958854C0BFE112B94CEA3D40EB2796B4958854C030E7588854EA3D4052D65119968854C0245E92FF5BEA3D405E28B074968854C0DF8F4E0F63EA3D4070E70FC9968854C06010E38869EA3D40D1665C0D978854C08EA8DF176FEA3D400A109647978854C0616884F273EA3D407B698871978854C0EA510D1A77EA3D408BA834AB978854C032D42F617AEA3D40B1528CD9978854C06B99329C7CEA3D40AEFDEDDB978854C0E0FE8BB97CEA3D4025F33111988854C0ECD04ACA7EEA3D40294E9E35988854C0E265276180EA3D401F58F350988854C01E780FA681EA3D40375E7068988854C03E55049482EA3D405876F584988854C0D05AE4A683EA3D40D9D586AC988854C0B8B1DC2485EA3D40047B76D2988854C07BF813BF86EA3D40	0105000020BC080000010000000102000000330000007B4EE560811B1241C5933E906EF63E418B433EB2DE1B12415B255CA5CEF63E41E77899D4C31C1241D5229AEFABF73E41B7841FFE771D1241A10752673AF83E41230615704D1E1241922EF968DEF83E41CE1DDA4C271E124177889E091AF93E41CB57FB29431E124121AF44E63DF93E412834442F5D1E12416D845A2162F93E4120409B27751E1241CA82D1DC86F93E41DC974BBC8A1E12419708CEA4ACF93E41A58E271B8C1E12412DA21E64AFF93E41338A1ED39D1E1241E90C52F5D2F93E414EDBEBC8AF1E12411148A519FAF93E413358AF9BC01E12419DFBE50024FA3E4130092622CD1E124127C26A2045FA3E4116004DABD91E12418F2FD4AC68FA3E418F82B171E31E124171FC28448BFA3E41676618C9EB1E1241DC3A7C74ADFA3E4158B518A8F21E124167D87DCFCFFA3E41C144CFA1F71E12415FDB175FF2FA3E41CE39DA53FB1E124105E45F5F19FB3E41F272EF86FB1E12415951C9EB3CFB3E413FBF7B4FFB1E124161E83F1860FB3E418782001FFA1E12414CC4C19280FB3E41EA482DBBF51E12415D0106A6A6FB3E41772FB93DF01E1241E82CE7DACEFB3E41605B9104E81E1241272ABADFF7FB3E41F947D2ABDF1E1241E5D4911922FC3E41F0E5E5AED41E12416065A8484CFC3E411D7F229EC51E124111445EA479FC3E4155B7DD1BB71E12412C59DAA99EFC3E414ECF0B39A31E1241555A0E61CBFC3E41FB712EEB8C1E12417D9B313AF5FC3E41B0448D16761E12419B9221DD1BFD3E416AD89457591E124120F6894747FD3E419BF77E8A3C1E124198414CC970FD3E41450A217B221E124171FEF10A98FD3E418C34E7670A1E12416A2AF509BCFD3E41C490B9FCF61D1241B18F00F0DAFD3E4161C33D75E61D1241A7A84AEBF5FD3E4118469379DA1D1241D465CB7407FE3E41D8CB62C4C91D12417DECAAB019FE3E417322DC40BC1D1241B0AF651A26FE3E41B9E8138FBB1D12418C6EBABD26FE3E416567C7EAAB1D12411749393E32FE3E4120B88B42A11D124169F718173BFE3E41EE469047991D12410AD96A2742FE3E411D5ED962921D1241CA2E775447FE3E41026307018A1D12412E9F5B4F4DFE3E4175331A607E1D124114B4B19E55FE3E41F0999643731D124172D3788A5EFE3E41
23	08051000	1	US   41	41	7	08	Hernando	7	0	0.072	108.9081	108.908149136981	0105000020E610000001000000010200000003000000910E57A33B9954C020F15B763A8E3C40037880AE3B9954C03D06802F088E3C40BCCECA303B9954C0E01A6D28FA8D3C40	0105000020BC080000010000000102000000030000009C2B363E5F7509410B9F18AC157537411F481D713E7509417F649CB4FE733741BC899B2E847509410933BEC1B0733741
32	04020000	1	US   17	17	1	04	Desoto	1	15.78	16.693	1467.5979	1467.59787051561	0105000020E61000000100000001020000001B000000740F4041907654C0EED65437CB3B3B40B9F66A41907654C0FDE38C12CC3B3B409EF26355907654C0EF7D3EBDD83B3B4021FEFC4D907654C0D43AFFE9843C3B4099DC7A4C907654C00849104AA63C3B40C27BA620907654C09C1CAF66BC3C3B401854EDC18F7654C09B2B30CFD03C3B40389179048F7654C0D74E2A3AE53C3B409D914AE48D7654C0E4F99E9AFB3C3B40BDB2FF738C7654C0F178D54A113D3B40F281B4608A7654C0E11902212A3D3B408FF4A62D887654C0D68E99233F3D3B407F99FA6A857654C08BB2EE0A563D3B40808EA32B827654C013494FF56C3D3B40BC98179C7E7654C0ACAB12E8823D3B405EAB8DA37A7654C03F24DC4E983D3B40CA86A351777654C0B08A74D8A73D3B40B3A22C69727654C018F155F2BB3D3B4017AA9895567654C06371922D233E3B40A4DDD7CA517654C0F7F775FF363E3B409FC2D4594D7654C00FFA2DCF4A3E3B400F4880DE467654C045BFAC336B3E3B40C2609C91427654C0BE1CA44D833E3B40DF779BBF3E7654C0F8648EEC9C3E3B404393068C3B7654C0CAB59E35B43E3B403A025CC8387654C06CAE6959C93E3B408A273A7A387654C0BDEBC730CC3E3B40	0105000020BC0800000100000001020000001B0000006B7D0031E0231741E0AFE3322C1930417D85D444E0231741115BF7F230193041AA4D3EFEDB231741D7B4933977193041FA48F94DF8231741F473C34F321D304101E7CDD0FD23174154535673EB1D3041391172BD0E2417419C561916661E30412E66C92D2F2417417FA1C13ED71E30413735B5F96C241741CC845668481F304119C513AAC924174159B96562C41F3041BF1D05133F251741A718FC7F3C203041E29D0079E7251741130C69FEC52030414D3B4F229926174154FD993E3A2130415A60659677271741A49B61ECB8213041C772BFAC7C281741B8BC3E9A37223041A9F44F789A2917418071BEDFB0223041B12794B7D82A17411119A20E2723304167F24571E22B174187DA97CC7C2330410E333CD76A2D17415FE180A4EB233041F0175DE719361741B3DAC48A24263041D43C000A9937174196E3B5D79126304171749D5CFC381741606FBC24FF263041741E826E033B17417466F4F5B1273041B45E70335C3C174182032B14372830412D2ABB1D8F3D1741A20384B0C42830418B513496903E1741F7B4C26D45293041F6CDA60D6F3F1741D2942153BA2930419C6C0DB1873F1741A0A6820BCA293041
33	18120000	1	US   27	27	5	18	Sumter	5	0	1.016	1630.0699	1630.06990068811	0105000020E610000001000000010200000004000000C36874340F7D54C0288379DBF8F23C403DC146FA0F7D54C06A8101D6FBF23C40DB01605EC37D54C07B8DC6C5BFF53C40A614359CC57D54C04B099467C8F53C40	0105000020BC080000010000000102000000040000006B687360ED6C15411EC493E0A69E394106D1AD91B16C1541C333BA86B79E39419D3A39AF79361541C634AB052CAE3941C5205D3BCC3515410D9080465CAE3941
34	13010000	1	USB  41	41B	1	13	Manatee	1	5.284	7.552	3671.2472	3671.24715883601	0105000020E61000000100000001020000001100000023DABC55D1A454C064272CEA74763B40ED4F2A63D1A454C059435E617A763B403190237DD1A454C0A3BCB1BBA7763B400A7B2C6CD1A454C0D032BBCA45773B406F05FA4BD1A454C0ECCAE69305783B40DFBDE28BD1A454C02330CFC450793B406EDBC9A1D1A454C0B3FB807D79793B40539B3FBFD2A454C02CEB065A80793B4015E254D6D2A454C04F6EF8ACEE793B40D417C3D2D2A454C012BBC0DC2A7A3B409C1CD71ED2A454C0819D524A0A7C3B40C1008367D1A454C0AAD0C0C2347D3B4078BB4C08D1A454C038FFD829EA7D3B4014A908E0D0A454C0CE1F86C1FA7D3B4080B0F203D0A454C077C7C940317E3B403AE7E1DBACA454C0B5A294E42E7E3B40DB4145C69AA454C072E7B1AC2E7E3B40	0105000020BC0800000100000001020000001100000098023ABFC4BC0141747FB77F8A673141CFC95084BFBC014122B12CD6A86731412061B9FAC8BC01411D33AE7DA4683141ED0BED742CBD014146BF7C6C116C31416BBB6A5AACBD0141B56CE67739703141D382AD4F3FBE014198724610677731412F07ECB148BE0141167CAA04497831412548EFFA9BBD01415CEE005E6F78314156E51BD6CBBD0141775CF47ED37A314172D96FF1EFBD0141C0146F6C217C314117EF064B6DBF0141A4C14E3D85863141C3B511D786C00141FF069D0DFD8C314148B37EF027C101419AC44D6EEB90314155C049314AC1014156C6717347913141264BA804F1C1014108FA8A9975923141691C15FFADD70141F00F8FAD5F92314102FBF22ADDE20141D3AF51EE59923141
35	36001000	1	US  441	441	5	36	Marion	5	8.545	14.221	9147.1727	9147.17270691223	0105000020E610000001000000010200000036000000049F7192AE8954C0A2C8EBDCFE563D40FE4D9F91AE8954C0EF526FA804573D400C6E7A07A98954C0E867425D8D573D409E40437CA88954C040EC3858A6573D40A6C5E094A88954C04F4298FEB9573D40CFD1A053A98954C0276A66A4CB573D409E34495EAA8954C0CB8B8BEDDB573D40FA81939FAB8954C0FD57263CEA573D40A94AD05EAD8954C0178FE278F9573D406638691AB08954C07D7345BD0B583D405106DFDFB38954C0DA52AA9220583D40CCCA6425B98954C09A2EF00537583D402D1BBDE7BC8954C0D5B85AF642583D402C284537C18954C0012BF53B4F583D405A2F7DF6C58954C079F68C5C5A583D40BDC693FFCA8954C026FD4CF063583D405A30A2CEF78954C0C7D1236EB5583D406C18288DFE8954C0E0591E70C2583D40020E12A8058A54C0E8E224D2D2583D407330F3340B8A54C021136155E2583D40E066EB33108A54C02BC88E95F2583D4042D51FFF148A54C0FE7F26DE03593D4004A731B11A8A54C079BCB63A1D593D40279C55451F8A54C08EB2A14B35593D40622F4816238A54C0DD4E32FA4C593D40DD8974A6728A54C0B1760D703F5B3D402D3D45C0E08A54C0D422BC43F15D3D409FF62B014D8B54C069C66C2697603D40225A5C87518B54C0F5FF91BAAF603D40BB7D88DD558B54C0544A1635C4603D40194047AC5A8B54C00A6ABA7DD9603D400B1142885F8B54C0CF1A324FEC603D408F6B5099EE8B54C0C38BD03EEF623D4051B95A46178C54C0D0C0655382633D406AD80089A78C54C0C66035F788653D405C5C9DD7AD8C54C07BAEDB379F653D40DFDB6E6FB38C54C086E82DCDB1653D40324B0067B88C54C0905E8FD0C0653D40D1C91248BE8C54C0DED8BB06D1653D40FCDA5019C58C54C07AACF268E1653D400B8C6A52CB8C54C0D474A4F0EE653D40DFF9FE82D18C54C067163D23FB653D402D66BFEED78C54C075138C3206663D406EB42DB4F78C54C0629399B539663D40EF71005F248D54C0A2D0A17C81663D40E6EC818F2D8D54C086B0DB2A91663D4083DF931A348D54C0199B32DD9D663D409743DC00398D54C08B2030B2A9663D40B3EF2B4A3D8D54C00A98DE44B6663D407CBB2FFA408D54C0006731B4C1663D40B9960E6E458D54C090061217D4663D40DC93E297498D54C038E7BCE6E4663D40B69C5AD04C8D54C0E15B0FD7F4663D404C926F66508D54C04BD4590B08673D40	0105000020BC080000010000000102000000360000004DC91CB8FDA8114111EF1F8CDFCB3B41DC8F463CFFA81141FBD835B4FFCB3B41CE07A60ECCAA114150435C3FF5CE3B41E576F5D1FBAA1141017455C37FCF3B41EBCE4FA2F8AA11417C945AD2ECCF3B41B1C7C386C2AA114133E1DEE44ED03B411E9B240E75AA114183D32777A9D03B41BB6AFC8C16AA1141DD2F0919F9D03B414D2D69FA91A91141AFFC76FC4DD13B41E5D23C62C1A81141DD7D72E0B3D13B419D0A5D90A0A711410AF8383528D23B410CD117650BA61141EB6F50CCA5D23B4162EF7994E9A411416C8D48C5E8D23B418415D8EF9CA31141DD6713B22DD33B41AC05391B2EA21141F845605A6CD33B41F701BC7DA8A011418C58C376A2D33B412AADD5B21C93114192DC74476FD53B41625C4EED12911141073A15C2B8D53B410EC817D3ED8E11417D75580915D63B41AB5F247B418D1141979DD32F6CD63B4173EF286CC08B11416FF68B53C7D63B41C64978524F8A114104B7A42828D73B41334979D9998811419472C9FDB5D73B41D80125FA3A8711412F61916B3CD83B41A71B6155178611411D020392C0D83B41BEECD672586E1141E66EE2FA9DE33B415DEA0BF37D4D1141DCCC3755A7F23B415F527A3D322D11415E3E82326E013C4111484BE9D72B1141BF75D179F7013C41BC08F7408B2A1141071C2BF769023C414C5CF0261A291141D4710804E1023C413BC20B7BA4271141F3FD0A654A033C41D80BA30AA3FC104142F0360B900E3C41A3121E5D69F01041C14C5045C8113C41D7CA732A0EC510413E57C9FE221D3C414A40FBD928C310419F1307BD9F1D3C4199D597387AC11041A0B753FA071E3C414B6B0C73FBBF1041A92909485C1E3C41D00BCB0836BE1041786CEA6AB71E3C419E75C8B727BC10417A2A43B2131F3C41BF86D1F546BA104168397E05601F3C41DC8FF47C68B81041AD1249F2A41F3C413D3565C977B6104166F0959AE31F3C415D6A3C5ADDAC1041BCA6B3D007213C416BFC16F25C9F104148E684159F223C41F7EA6212969C1041FAF0E6F1F7223C414F62D0419C9A104145FE61B73F233C414C87700A2299104129F7145C82233C41634836ABD7971041679FEFFDC8233C41E209E797BB9610417861323009243C41F3AB2AA265951041E888161D70243C41F501EDCC25941041F7C99F3DCE243C4185D2DB112F931041D4833F5627253C41283D0CA91C921041143EBFA092253C41
36	72040000	2	US   17	17	2	72	Duval	2	15.895	15.968	117.4302	117.430220522528	0105000020E610000001000000010200000003000000D6B2C66DE86954C0BAA6F4BB2D553E409F792282E86954C08DE6FCCD2D553E407606BDCAFB6954C02D41BD4E3F553E40	0105000020BC08000001000000010200000003000000E4C9800CCE701B41133FE162CDA44041D146BEEEC7701B410EFE0B96CDA440412C0F7CE6FC6A1B41B5AAC539FFA44041
43	93020001	1	US    1	1	4	93	Palm Beach	4	1.238	2.356	1794.1597	1794.15967471966	0105000020E61000000100000001020000000A00000018BAA919700354C0904218F6DDB43A4068DF5A1C700354C018ECF158DCB43A4089887562700354C08C38145ED4B43A4091A4288F700354C0012C5C639AB43A40D548600D750354C0F078CD6E00B33A401C6FCBFB750354C0D3D2E072ABB23A40F8B103A1770354C094BE10E7FFB13A408998EAC7770354C01C263B3FCDB13A4023787594780354C040DDF0ADA6B13A40C02E8CF17A0354C0D7DCFD3DB9B03A40	0105000020BC0800000100000001020000000A000000F0348080D6732D41EE2044DB265B2A41CCB33C37D6732D414D2913F3145B2A41598C81F5CB732D41A9A53757BC5A2A41407548C6C9732D41B268101439582A415C2F477338732D4103B6C2CB73462A4156E518531A732D41291CFAB9C4422A4173E9E5DBE6722D41F1298625553B2A41218C4AF8E4722D41A876E32323392A41BA2BCE4BC8722D414235740B77372A411D2B579D7D722D41C754E8452C2D2A41
44	86010000	1	US    1	1	4	86	Broward	4	2.713	5.948	5197.8098	5197.80980919575	0105000020E610000001000000010200000019000000A091F9DC260954C015ADD00F47033A401A5DCD3B280954C0F12D659A4A033A40746EA844280954C0DDC8CA026F033A40316503B12A0954C047962F71DA043A40577245FF2A0954C0B5CDE7CFC9053A406F74F1122B0954C08E1AB0E705063A4073BD8B262B0954C04EF516F741063A40CA2E0F3A2B0954C0526428A87D063A4014F0994D2B0954C0DD608E62B9063A40329CEA5E2B0954C0ED32C546F5063A40FB033A702B0954C02AE8BF4631073A40BD1087812B0954C01D68E0036D073A40A676DC922B0954C02F056C24A9073A40382239A42B0954C0440DE21DE5073A40FE3B9FB52B0954C0E8E8576121083A40217504C72B0954C071F054A65D083A4015DC35D72B0954C0C98172AB95083A40C46017DC2B0954C07C439CB79C083A402CF43C212D0954C0251E23C2720A3A405B9E15D12C0954C0BA5342FD800A3A40D598AD43300954C0722E08A57A0C3A40299B84D7310954C00BF6944C630D3A4099CB7EB7320954C022FF773CDA0D3A40333AE330350954C0DE2149922A0F3A404E7DAD52350954C02727739D470F3A40	0105000020BC08000001000000010200000019000000CC3F9DED329D2C411CE2F93B86A72241F27D1EBAFB9C2C41195F0228ADA72241AC70DDB0F79C2C410D4BDB0041A92241666AD7177C9C2C410CDC39C1FFB82241C3CB186B5E9C2C41CEFCF4E75EC322412EF7E0F6569C2C41C0EAB978F9C52241257A05864F9C2C411E5292AC93C82241C50F951F489C2C418F740ECA29CB22415E734BB7409C2C4164320D4FC0CD224168AF35A5399C2C41C58E7FA458D02241E7B84691329C2C41927EF42DF2D22241CA4B8D822B9C2C418368DED188D5224128FE416B249C2C4176619AC423D8224160DBA4551D9C2C41F2E8CD05BDDA22419C042439169C2C411697DC7B59DD2241DF2DA31C0F9C2C412A02E402F6DF22418D69817F089C2C41A455EA6663E2224107DD8138079C2C41F4E67E92B1E22241D3F66416B29B2C411A6D50380FF72241F616EA99BD9B2C4158912529ADF722415B5E4E980E9B2C413B56C94B950D2341439C8E6DBE9A2C41F6DE6EA1A9172341389FAAB3929A2C419E56B0B9D01C2341EA47080D179A2C4179C031EB622B234107D96AA50F9A2C415029E80DA52C2341
50	91090000	1	US   98	98	1	91	Okeechobee	1	0	17.727	28513.9303	28513.9303369282	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
51	70030101	1	US    1	1	5	70	Brevard	5	0	1.397	2238.6385	2238.63849381718	0105000020E61000000100000001020000002700000095AB6AF9DE3354C0E594F65A8D9E3C4001DECA4DDC3354C0E71D992F8D9E3C40BE7D5C55D73354C0A18E78288D9E3C40C2D41F65D23354C02CC4AFCC8B9E3C40794EBD30CF3354C02E65B7018A9E3C40DD1E655ECA3354C018DF5719859E3C40518C9D3AC63354C0DA5DE7457E9E3C401102C929C23354C085F207D2759E3C404C4DCCB9BF3354C0D38D32B56E9E3C40CEB92490BB3354C0E68090A2609E3C402F99ACFEB93354C014C8D3AC599E3C40B93ECA7AB83354C088537888519E3C406B7657B9B63354C0301C945A489E3C402322E359B53354C05D720D4A3E9E3C40881F8005B43354C046DE8744319E3C409A4FBE19B33354C00DFBBF28229E3C40765E46A9B23354C0015CBBE7149E3C40AA234392B23354C0F806E1C6089E3C40E02DB7F5B23354C06F93CBD7F99D3C40FD6CBCBAB33354C0EA31007CEC9D3C40B0D5C5A7B73354C0E65A7336BB9D3C403EB3805CB93354C0D317692DA89D3C4067096867BA3354C0E63E6786979D3C40DCF823B3BA3354C00B39B040899D3C40BBFB1EE4BA3354C0BF9CE0D57F9D3C409A180C44BB3354C0250F1F13129D3C409B24DA58BB3354C0BCD86D7CD39C3C40EDFB9929BC3354C02F0E8599A69B3C40CBEFEE8FBD3354C00CDA04C1529B3C404154E6DABD3354C0C377C652379B3C40F9E37A22BE3354C096D6C9A7009B3C40D9DB0187BE3354C0EBB06DEC8B9A3C4032233356BE3354C08A23C1A0789A3C401100A810BE3354C08C90E9B9659A3C402DBA3360BD3354C0C5FB744A4C9A3C4065A8C97ABC3354C0DE1158C1359A3C40CB004F52BB3354C05F99FF31209A3C4031F56334B93354C02CD6170D029A3C404BEDB2A2B43354C080214A02CE993C40	0105000020BC080000010000000102000000270000004665EAA550E125413AC8FD6DAAC537419D24C53BB9E125418ACF9E92A9C53741CCD1B4E47BE225413BD89E92A9C537411437BE523DE32541EC9A7730A2C537413FCEF8DBBAE32541AAB4AC5798C53741EED96EC777E42541AD1CDA437DC537414DF215071AE52541CE29338657C5374146BC1568B9E5254129CEA1C128C53741FF51FFFD18E62541D0B5375F01C537411670F644BCE62541A521466DB3C43741A193AFCFF9E62541E00DD2DC8CC43741ACBAC84B35E7254124D103BD5FC43741E48DBC377AE72541DE40F8DD2CC437417C5BF229B0E7254105797C12F5C337412D213C78E4E72541BE9BDBDEACC3374166CD5FCE08E82541EC89E11359C33741FC9B983F1AE825410318018F0FC337412CBA39FC1DE825411EC10C46CCC2374148785F090FE825418904826879C2374151BD2722F1E72541735657452FC23741D6BE0C4158E72541C200F7C91DC13741813B5EC715E72541D9FFB220B4C03741A571F73DEDE62541708239B557C03741E215D3E8E1E6254130AE188408C0374198DB5F95DAE62541465A6B43D4BF37419557FFDBCDE62541549FFD4C73BD3741983F03CACBE625419082BB0E18BC3741B1900B33B1E625410B1E77B892B537410F2747DD7BE62541C857AB80C1B337415E06B3E170E6254129A4134F29B33741D2498BE666E62541EEA4FB00FAB13741D9779D9759E6254177EAB35D72AF3741EB83136761E6254102980C5207AF37411DA6F9606CE6254143B075769EAE3741C7263ED487E6254158D19B5E11AE374100F6CE54ABE6254114D5EA5E94AD3741F59DE913D9E62541901F09CB1CAD374149E503882CE725415F54DC9E75AC37416161286EE0E72541462D0F0955AB3741
54	11040100	1	US   27	27	5	11	Lake	5	0	0.101	163.2211	163.221102992596	0105000020E6100000010000000102000000070000006083B1BFCB7854C045DE0F4819D33C403175BC8FCA7854C0DD38D29723D33C401D5A9EEFC87854C0FC32C5722BD33C40643E40E7C67854C002DF7C5632D33C4090FFA6E7C37854C06B5670CA3AD33C40AE2D4F2CB97854C0834A785357D33C40C37C0012B87854C046361C425AD33C40	0105000020BC08000001000000010200000007000000EBD491C98DB4164109C92A5627ED384197BE1E52ECB4164148C27F6060ED3841CEE1F1B26CB5164144E283B98BED38411354DAC00CB6164149D28FA7B1ED384134FE2491F8B6164173B83E1EE0ED3841A284A94944BA1641435789E17CEE3841E8CA32FC9ABA164133184FFD8CEE3841
69	72140000	1	US  301	301	2	72	Duval	2	7.851	8.354	809.6332	809.633234202333	0105000020E61000000100000001020000000D00000042F79931E77E54C06E007B96A24B3E401A5F1236E77E54C03D688894A84B3E405D95BFC6E77E54C0FAD50B776A4C3E409AFA2C17E87E54C0A499B1CB8C4C3E4012E65E7DE87E54C04F1EF1E8A94C3E4015536504E97E54C058461F1DC64C3E40197640A9E97E54C064E4DCA5DC4C3E40336A6E4EEA7E54C0CBD284BFF34C3E409C5C8E33EB7E54C05F771E0C0E4D3E4085D4257EED7E54C0FFD4EC294D4D3E40D1A15120EF7E54C0F4D3B17E714D3E405B367F0AF07E54C00444F299764D3E400ABA6B5CF07E54C0EECE62EB7E4D3E40	0105000020BC0800000100000001020000000D000000A097B6C8D41D15419A060D6FC78B4041FD76F996D41D154133733E10D88B40412F70814BCE1D1541EABF731EF28D4041951E19AFBC1D15416401AA68518E40419E94EE84A31D15417B121C3BA28E4041D224744C801D15414A9E8E89F08E4041ED84A302531D15415149E91E2F8F4041A034D9BB251D154114EE6A466F8F40419DEE85D3E51C1541F594BC53B88F4041E5B52C68411C1541C76FC4A86790404190D72C88CA1B15419D823F9CCC9040415AE52E08851B15414EA142DBDA904041D0BE69F96D1B154137950DF7F1904041
74	87020000	1	US    1	1	6	87	Miami-Dade	6	14.139	15.265	1813.447	1813.44698824563	0105000020E6100000010000000102000000220000008CD6765A981654C00302D460C6993940C1625F6A961654C0ECC67EC0D2993940FBF915EF921654C09E6AFA8EE5993940B77919228F1654C0E21B67DFF899394046C5C27F8C1654C0C95ACA6B049A3940FED4A9F5891654C02980F6A00F9A394074A42C57831654C0497FAAEF2A9A3940AC93257D751654C008699224639A3940F3FDD8106E1654C07AB3F6A9819A394097F71988691654C090B65572949A39407D99147E661654C0D2239AC4A29A394078CBD8BF601654C08790547EBF9A39409CB08D9D5E1654C06115BD3ECB9A39403A9C6D415B1654C0B6DB710CDE9A394047088C12561654C000F00059FF9A39402D1AC136531654C008E55CAE139B3940C21E763F4F1654C06D4DE6BE329B39401F27D6AA401654C05059C4EAB39B39401354FB853D1654C08CE65A86D19B394079992B8B3A1654C00B80CFB8F19B394060D565BA371654C0B37E1A82149C3940BAEF5FD3351654C00D40A9F12E9C3940B2BB4B4E341654C09F382B95459C39402B599ECC321654C0938D57ED619C3940D2EEFE90311654C0D37C84707D9C3940D5C06D85301654C043FE2CDE999C3940211D08BB2F1654C027B0ED04B49C394091F773342F1654C0D77526E1D39C3940C58073DF2E1654C0477A262BF09C394091C787712E1654C0FB4B59BC2C9D39409E29F3E32D1654C0350810BE4F9D394072EE47482D1654C0E4AD1014699D39407DC8A2792C1654C02092DC08809D3940612FBEF42B1654C01C64B6DF8B9D3940	0105000020BC080000010000000102000000220000000DB0D3F5FB872A411D5F521F63241C4102243D4049882A41F153385F76251C41065B274CD4882A41FC6E17EE18271C4161C8A0276C892A41FD5FB7DFC6281C412A881180D5892A41030BFE16C8291C41FAC7EE0D3B8A2A41386517B6C12A1C41C378DFDB438B2A41F92EF414222D1C414F28370E6E8D2A4135FF866106321C411BEC9505978E2A41413AC95CAE341C41A24E29684C8F2A414F7FC3CF50361C413397EFE3C58F2A41E1E460B48F371C41431C025EAB902A41836D2A320F3A1C41F5551A9300912A414A581CBA143B1C4159C7F2B686912A411F9F6C2DB73C1C41DD717F6955922A41B52215E89B3F1C419D60ED4CC7922A4147EF1E1960411C4104213E2765932A415DF0B3C712441C4113C5E0A7A8952A41751605FE494F1C41D293868325962A411273D708DC511C41EF406D9F9B962A41FA9AB173A7541C4100CFBFFB0A972A41A681E73DAC571C41CF588F1156972A41BA39926DF7591C4153655CF891972A41964E323BEE5B1C41B9356506CD972A419C21DE99635E1C41D14DE41DFD972A4150B2CE67C6601C41BDE35C9B25982A41449350743D631C41C0FA0FFB43982A4112263CE481651C41102EB66257982A41A0A778DD44681C417F0D043263982A4110039C8AB86A1C415647CE2771982A4175B1A24AF86F1C4176CFE37C85982A41655B2D1301731C413B5707909C982A411F4AE05933751C41CE81FBC6BB982A41ADD59BEA30771C418382DC02D0982A4137119EC137781C41
108	72090000	1	USA   1	1A	2	72	Duval	2	4.889	6.126	1989.8584	1989.85842362123	0105000020E61000000100000001020000000D000000F2365B1FC46854C031B1E233475A3E40EAF5998FC26854C05E86C241CF583E40E239A22DC26854C091B29008A2583E4002158F43C16854C07527DFF8F6573E4076054727C16854C07413BA8CBF573E400EC6183AC16854C083C51E7B57573E40A0B0590FC16854C0836470E022573E40CE445591C06854C0E1D624D787563E404963A978C06854C0762A898269563E40DB50AC0BC06854C08CB8C25902563E40A5AEF70BC06854C08EF17F77DB553E4068836C1CC06854C0B577400BBE553E4072DB1C25C26854C0EC217F42B0553E40	0105000020BC0800000100000001020000000D0000009E54EF0E63C91B41465945C3E3B240416F495B6FACC91B41087DD081D0AE40410B0BBF44C4C91B41FC3E3B0053AE4041BE7ED65CF5C91B415866D84A78AC4041F5D382F6F6C91B4126183680DEAB40411E7CA454E4C91B41A91769BCBDAA40411D3E76A2EAC91B41C7EEEAC22BAA4041F818EB39FDC91B412725C38A7DA8404135E384DE00CA1B419A924C6029A840413DB41CCE14CA1B41AF19B51B0BA740419D7727DF0FCA1B41FF8EC8369FA64041A2802D4107CA1B41B10F4D934DA64041264871E168C91B41C42AE76F27A64041
112	38020000	1	US   19	19	2	38	Taylor	2	0	1.029	1656.2329	1656.2328673951	0105000020E610000001000000010200000011000000D0E184FF55E554C0992F6BE733193E404F17ECB28AE554C020A8BC49011A3E40D6AF81B196E554C0B3545DEA2F1A3E401C0CCF069CE554C03BEACCB0471A3E4053271ED79FE554C03E68AD095B1A3E40865B6721A4E554C07BBF4842731A3E404FD4D2ADA8E554C0943F0402911A3E40A17F468DABE554C08AC8756EA81A3E405E4D2B6BAEE554C0EEB8B5F2C21A3E4038D3C89FB0E554C075888755DC1A3E40A759B38FB2E554C0E7A1679AF81A3E40B58B2EE3B3E554C0B9BCBD8F111B3E409C4392CCB4E554C05A15F90C2D1B3E401B5BB441B5E554C0C2E8D51E471B3E40E0D4B6A5B4E554C0E881F85BF61B3E4063993A79B4E554C05A72200B921C3E407D47BD75B4E554C09C3D01C0971C3E40	0105000020BC08000001000000010200000011000000E16DDAB203A403C197C04279460F4041C6F6357F02C303C10C7BD5248C1140418FA0847710CA03C14FCFED3410124041E683596630CD03C15348C35F531240411B1E1B0E6ACF03C19EB0B7EA891240417C6E2B67E8D103C10CEB1D18CE124041ABC2DC1589D403C1409A70AC21134041590B7C482DD603C1CED6B253631340417CC4F86BCDD703C15260B390AD1340412CA1BA8C08D903C132BF2F85F4134041A845F05017DA03C1D71C7F6B43144041F0232C05CBDA03C1F145C5FE8814404198FADC273CDB03C1F02D6381D5144041D858DA9168DB03C13191D3F91D154041B42079E259DA03C116372C4F041740413F9B8A2CA2D903C106034374B4184041C5697C519AD903C140ECED4AC4184041
116	77010000	2	US   92	92	5	77	Seminole	5	16.782	16.929	237.0537	237.053693791048	0105000020E610000001000000010200000008000000FC553E7F7F5454C0CF8B93A20BD53C406FBCE758825454C00DB98FB310D53C40D66CA3BC865454C0D43A521618D53C40E07DB267905454C06EFD8F8B28D53C40B1E9E88B945454C06EC2F6AE2FD53C40FB43E4719E5454C029384F8F40D53C40E50BB62AA05454C0BB5B97FF42D53C4040745BFCA25454C08C486C9C4AD53C40	0105000020BC08000001000000010200000008000000E1B9D41827E520412850FB6F59F43841861C3ED9B7E4204176705AB275F43841B35D73810CE42041C36AE8E79EF43841CD50D11F93E22041AE2B78BAFAF43841B7EA1379F1E1204193C84C8D22F53841B82D601C6FE020416DCF90B580F538419EDA1FE22BE0204155C690548EF538419A67EBEFBDDF20411B2353B7B8F53841
117	15090000	1	US   92	92	7	15	Pinellas	7	7.645	9.992	3769.9182	3769.91823003966	0105000020E6100000010000000102000000090000004A034D991EA854C0EEAD2BBEF3DD3B40356F84D7CDA754C0332F35184EDE3B403DE4C75E5FA754C04973BBC8C9DE3B408F6FD2F1A5A654C04F4588A699DF3B407C0BEABB33A654C02ECC48E019E03B400903C1D007A654C0DEC96EDB4AE03B4052AB1AE3E0A554C032DE4F3676E03B40587D4BBFC8A554C0EB6C538E8FE03B406176F34FC8A554C0379152F690E03B40	0105000020BC080000010000000102000000090000008A7A9B2DDBDCFF4043E99F2EA0A6334135AD8C8269200041A811346580A8334139CCC337C964004183139CEB11AB3341408FCCC18BD70041ACA74F3F63AF3341AE3A56523A1E014159BD754B0DB233415D3DAA0B683901418B2213CA11B333412C1D6F137F5101412ED45A5DF8B333415F075F646E6001417205A8CD7EB43341F23E39D3B36001414C5F9E7E86B43341
121	48050000	1	US   98	98	3	48	Escambia	3	20.421	21.029	982.9325	982.932525107139	0105000020E61000000100000001020000000F000000E300F18978CF55C02E46AFC573693E40C11DF6F677CF55C0A2567850A4693E40A3FBB6ED76CF55C02535DE26E9693E4001A1C13476CF55C0F77C0998196A3E401582F01676CF55C091A15E67216A3E409403550B76CF55C0726B6F47606A3E40782893EA75CF55C09CFCD3006B6A3E407C680BC075CF55C0B69B28EE786A3E4052FBFDF074CF55C0E0B95A9BB46A3E405268F17A74CF55C0CC5EB86FFE6A3E4088B5679D73CF55C078AEB2C32F6B3E4014C0326072CF55C0A30A489F686B3E401DCE8D8971CF55C0AC440D199A6B3E408D15A5FF70CF55C070836111B26B3E4096BA68F170CF55C0F7B243C6B56B3E40	0105000020BC0800000100000001020000000F000000992730B7F60934C1E5CEE2A7374641417C96B3ADDC0934C15A8AC46EBE46414110D71179B30934C12677E0707D4741413F74979A960934C111CF2DDC034841415EC521F3910934C10BC8038819484141B2F3B6B27D0934C1782E1D7AC84841415EDD95EC770934C12BD38540E64841416D86316D700934C1EC1671EB0C494141F6FFEE6D4E0934C136AD5E8EB2494141A6F53BC72E0934C15F3C6FC37F4A41410288D9E00E0934C177865892084B4141216F7F72E50834C162F74D22A64B4141B4706F05C60834C1CCA90F5E2F4C41411FA9563DB40834C19FA39EC8714C41415F803706B20834C1EE8C93117C4C4141
127	86010500	1	US    1	1	4	86	Broward	4	0	0.248	416.3494	416.349417583404	0105000020E61000000100000001020000001C0000001A5DCD3B280954C0F12D659A4A033A40339E9EB12A0954C08EB7500141033A406087F60C2C0954C0759FFE363E033A4062BAF1562E0954C0BB7D577D3B033A404A9C01D7300954C05A95C30238033A40456D3F62320954C0D8B79FD834033A404AE28C43340954C045C234BC30033A409A7A79F4350954C06D91C1892B033A405E21CFE4360954C035B521F027033A40402679E7370954C0ADAEC26923033A409A5356DB380954C08DFE81971E033A402A431A1E3A0954C0A35DB8F416033A40B9DFF46C3B0954C0935C06A60B033A407EEF60E53B0954C0B2DACE1B06033A4088A41E323C0954C0E36E6B7B01033A40541B927D3C0954C0CB634726F9023A403433E46F3C0954C0C41F9F8DF2023A40A0DA2F273C0954C040C75293E3023A402A509C0A3B0954C0085D1B3CD6023A406E23121F390954C0AD110306C9023A4038C7B5F1360954C04D7B1A05BF023A40CF9ADE4F350954C05142A460B9023A403CD68DD3330954C009B13AA3B5023A40A212B2C2310954C007515BFFB0023A40771742D52E0954C0E49BD80AAC023A400D04F1EC2B0954C0F81F90D0A8023A40768585AB290954C0EBE82EFBA5023A4071B385EB260954C04BD0421D9F023A40	0105000020BC0800000100000001020000001C000000F27D1EBAFB9C2C41195F0228ADA72241ED28F7C9999C2C41992B0C0B42A72241C4D51198639C2C41297710BC22A7224122875C05089C2C4110463EE703A72241485F6E08A49B2C41873A33A8DCA622415CE31B5D669B2C417145C925B9A62241BB7AFA481B9B2C415878490D8BA6224105FEA6DCD79A2C4177CC6CF550A62241FA08027CB29A2C41533E19C728A622419582AE4D8A9A2C41F1F6D451F6A52241FD613C76649A2C416DCBBC96C0A522415C53C577329A2C41561A578E6BA52241B697E9D8FE992C411339C9C8EDA422410F36E863EC992C41C22D7E35B0A422418F9F33B5E0992C41B1396ECF7CA42241B46A257FD5992C4135619B4D20A422416D3E481ED8992C413B69A725D7A3224113B0CE97E4992C41AA01891431A3224144DD7921129A2C413EE6C0639DA22241CC799412609A2C41110BBE580BA2224117820917B89A2C4170CF1AF49CA12241E5BD94F0F99A2C41607217CB5EA1224121193EC6359B2C4193F0DBB235A1224113BD3DF0889B2C41B95D47C502A12241B7A1DBABFE9B2C416D0A3793CCA02241F12C0A7A739C2C41607D4889A9A02241B9F8761DCE9C2C41B32DC8B28AA0224103C406DF3C9D2C4146150C403FA02241
135	87010100	1	US    1	1	6	87	Miami-Dade	6	0	0.24	386.6762	386.676246310317	0105000020E61000000100000001020000000E000000AD41E064AC1D54C0A1ECDC0DF15F3940D0468492AB1D54C0D944FFCFF05F3940771DE4E3AA1D54C0CC0FE71CF05F39401B332032AA1D54C0CCFBBC0BEF5F394068A4C573A91D54C0DDB67599EC5F394026D8DD09A91D54C04E6B4660E95F3940C3BD2302A01D54C0D04AEF16445F39402A470119A01D54C0405275523F5F39404255E1FBA01D54C0C5FBC400355F3940395E01F9A01D54C0A7D996ED2F5F3940756BD478A01D54C0803DFA5F2C5F3940BFD9CF9D9F1D54C0DCA651292A5F3940AEEB7D529E1D54C0BDBF681A295F39407D11D02E9B1D54C0738230B42A5F3940	0105000020BC0800000100000001020000000E00000025820926CF6D29410171BAA3F31E17417E015247F06D29411ABC6E8BEE1E1741FA6193CD0B6E294198412F3FDF1E1741622A90D6276E294159F445CDC71E17412F93A5EA456E29414E0B90C6911E17411BF4E5BB566E2941FCFD56684A1E174159BA660FCA6F2941E0441EE6FA0F1741AAD42AACC66F29413400C41D910F1741856F7069A36F29419BF2A0EDAB0E1741EE423017A46F2941448CC85B3B0E1741920FF46DB86F29413E3F06B4EC0D1741D2AAEE02DB6F2941A9E22AE1BB0D1741BAF730390F7029418DD111D3A40D1741530206B08D70294169714459C90D1741
138	48100000	1	US   98	98	3	48	Escambia	3	0	3.224	5207.1711	5207.17114746925	0105000020E61000000100000001020000001100000030BBD7F158CB55C055C7E0FAB45F3E4056306F4897CB55C0ACA7B92E56623E40D900611915CC55C097134FBDA0673E40EF4E7AE951CC55C0BE1C30A5306A3E4020C0F67557CC55C0FD70DA196F6A3E40343E5E0359CC55C05642EA1D806A3E408A9217BC5ACC55C03DA820CC8E6A3E40AC2FC9B45CCC55C0121FC2599D6A3E40630224B15ECC55C050DB89EAA96A3E40654279EE60CC55C0D7029C97B66A3E4051B8640C63CC55C075015C4EC16A3E40A9DB6D1266CC55C0B66B284FCE6A3E40C0CBE31469CC55C07F34F270DA6A3E40EB703C1F6CCC55C004B06E9DE56A3E40E16C67636FCC55C0A99E1396F06A3E40100E2B7E72CC55C03F07F238F36A3E4069C93AE075CC55C053133745FC6A3E40	0105000020BC080000010000000102000000110000003A295F525FBD33C19526D59AE8284141103D2B5F45C133C10DFF8DD55A304141ADD98F0724C933C151701FAE563F4141BC8A03FDF0CC33C170CAE911984641413A9FB0F348CD33C1E9F41ECE48474141DE0052B361CD33C1552D49FA784741418C4F806D7ECD33C1BFF5C9BDA2474141B328D203A0CD33C14EAD8948CC4741419A33517CC2CD33C12A70434DF0474141B8DECAD1E9CD33C1EA4D29C3144841412B29BF620FCE33C1D4AB9DB2334841417EA6D1BE45CE33C1E795E77B59484141940E0D1A7CCE33C137F1BED67C484141F53F6258B3CE33C111012F8B9D484141266C1A02EFCE33C1116C07CEBD48414124268C192ACF33C141E84EC9C6484141E9E2869A68CF33C11EC0E8C1E1484141
147	10020101	1	USB  41	41B	7	10	Hillsborough	7	0	3.245	5226.9122	5226.91222805769	0105000020E610000001000000010200000033000000DED7EA11679D54C0B712498FA7FD3B403AFE8BDF679D54C081CE89A3A3FD3B4077B108D7689D54C01DE6850CA0FD3B40185C2FE8699D54C0F2FBF0E59CFD3B40F4F4443F6B9D54C01E83B7799AFD3B40F7FFD1036D9D54C06B8BFFCE99FD3B4021A7F449929D54C08CE99E2E9BFD3B4075EE8943929D54C09C4E73C822FD3B40B6D8AA4E929D54C05B8DD71153FB3B409BFD0733929D54C008EE864E4DFB3B407B6FD7E4919D54C0797ADF2D49FB3B4009E00442919D54C06AF0454246FB3B407499ED48869D54C0826F795622FB3B40C87CD36F849D54C0F2D519941AFB3B401A8B5930839D54C0D5805EC211FB3B407BD7119E829D54C0EED2C74807FB3B409F82048F829D54C0DEB94DD6F5FA3B406B3EFF96829D54C061140E545EFA3B40EC3AA5E5829D54C0C4B12C6906FA3B40A074BFA7829D54C071F85C32F3F93B40EB99D13D829D54C00C90BBF2E2F93B40CB9BF083819D54C0D1F9D73BD1F93B40F5940817809D54C064613DA4B5F93B4090AB676A7F9D54C0C426EEE1A6F93B40B4D071CE7E9D54C0DA429D2B91F93B40DE6767BA7E9D54C0C47B8B0E6CF93B40364650E77E9D54C080F007158DF83B40A21B5EFB7E9D54C0C239246B86F73B40BBA5AB707F9D54C071E2F28657F63B4016D211A47F9D54C0B3C197FDDEF53B402E0F30F77F9D54C0E9B0681A1CF53B403B2E63E97F9D54C0A85D87D102F53B407D4AF5E47F9D54C040AFF362F6F43B406BBE93E17F9D54C0557CFD98E9F43B4026BFC6DD7F9D54C0DBA4F355DDF43B40878D79DA7F9D54C0071EE79CD2F43B40E393F4EE7F9D54C01800561091F43B4056BF4AEF7F9D54C024702AFC8FF43B4070C68224809D54C0994C0E74E5F33B406AE5CE0C809D54C0F282B464D5F33B40BFA24A9D7F9D54C0DD9D0B0CCCF33B40B01A30617F9D54C00E0A676CC9F33B40D9A07EF97E9D54C0CBB488E5C4F33B40882BD9897C9D54C046137EC0ADF33B406E907153779D54C0F3251F657DF33B40EE7A2B09729D54C0AF3AF8A74CF33B40AB582ED36C9D54C09D5957441BF33B40907F2F6D679D54C025E24361EAF23B4090918EF9619D54C0B6F3E24BB9F23B40B42C5CB65C9D54C06C22160889F23B404ECC9B00579D54C0DA971C4658F23B40	0105000020BC0800000100000001020000003300000066508FD33A9A06410EDCECCEDC533441F94B7226BA99064124E3193EC7533441BB9545E11F990641529E458DB3533441A457F40A76980641176D5352A2533441CE519F89A1970641676CDB319553344151154E928A9606414EC041E991533441AD5A23B4987F06419C7B5352A2533441CB9C7EA35C7F06417BD8BC4806513441D69CE7445F7E0641D348CB64F94634418BC4AD386D7E0641F6708864D94634413B98332B9B7E0641D783456BC24634410DD3C5DDFD7E06414D55D210B2463441A4A1DB56AC85064131BA9F2BE8453441CB1AF481CB860641A26BBBAEBC453441CD6A8B868B87064173F972748B453441980DD506E0870641911F4033514534417800D506E0870641C52E9961F0443441038A5BA38A8706415BE044BFA741344189DC3E842B87064139252A03C03F3441F033776C478706417048B858553F3441506B8804808706410A2F2F18FB3E3441B420AD0FE9870641B1B3B1A2983E34413C24D917BB88064136898534FF3D34412EFF948C1D8906416B390428AD3D34411B96DE0C72890641AA54248B343D3441BF1BD5AE6A890641910C169A663C344127907BA3D8880641B922177A9137344168E776D7408806410153F81DE03134416781AAD257870641EE9D4EA54F2B34415E5C2831F8860641A2EED3E6B2283441A5C4E9915D860641CD6A9CA779243441598E50A6588606416741E859ED233441FAF292C754860641A8DF7E5EA8233441126C1713508606413A89496861233441850966E84B8606418C6E985E1D23344144031A4048860641B3720DDFE122344162D4E1D918860641DC84C23176213441395E41121886064113F08535702134413BAB15CD9C850641C2C76C12BE1D344117126DE0A285064113233BF1641D34412A4DB198E2850641EBFA69FB301D34419F355838068606419EFDAD5E221D3441F923E5AD4386064178D05428091D3441AFBB8E7BB78706415C0AA52A881C34411F5689A6D38A064118D416A27A1B3441EB1150DDFB8D0641278768F66A1A34415434AA40179106419608E8B357193441AB96477C50940641B782752F471834411AEDE20592970641568ECB9035173441F722872DB69A0641297D73882816344162722CA3209E064120E62EA918153441
151	11040100	2	US  441	441	5	11	Lake	5	0.101	0.234	215.0896	215.089641488901	0105000020E61000000100000001020000000C000000C37C0012B87854C046361C425AD33C405B2E3998B77854C056D8EB855BD33C406C9D5864BC7854C006C1081872D33C40780CB2B0BE7854C0D7322FE47DD33C40722D3EBCC07854C052B0812E8AD33C40A80F3472C17854C05915FA738ED33C40F496A510C37854C03856CDC199D33C40A142E68FC47854C07985419BA6D33C40394A66D6C57854C02F43C423B2D33C4098B11FFDC67854C00372EC1DBED33C40C6EE23BAC77854C0F25A1DA3C8D33C40222A84CEC77854C098B6379CC9D33C40	0105000020BC0800000100000001020000000C000000E8CA32FC9ABA164133184FFD8CEE38412D453862C0BA1641E5F538F093EE3841668995124DB916413FF31CDF11EF3841D07BD35A9BB816414AA134AA53EF384173F03082FDB71641CB1BED2798EF3841113013A6C6B7164118CE95F5AFEF384115C846F549B7164101086DEAEEEF38410C148D0CD7B616411E55DE6D36F038410480DC4075B61641FB20829B76F038419D873C3C1DB61641F517153BB9F038419768C941E5B51641CC54D5B5F3F0384193552432DFB51641C353F41EF9F03841
159	12020000	1	USB  41	41B	1	12	Lee	1	0	0.168	270.6456	270.645616324648	0105000020E610000001000000010200000008000000D82793A6DA7754C02C7F172008A43A40964C8E17D97754C0B173E4A912A43A40BF72F4F4D77754C0AEF07EE718A43A407EE5BEE0D07754C07E4E013836A43A4095DA53B2CD7754C05D7CBB0041A43A4092030184BF7754C05D56C01271A43A40E5F28021BD7754C0A8CD09A477A43A4023542A15BE7754C06D2B5FBE7BA43A40	0105000020BC080000010000000102000000080000000B83AFD73EA616419E16338E0C9F294166DEAFBFBCA61641821FB509819F294179B0323A18A71641A1F1A8F5C59F2941A4189C3C51A916417326EA3B09A12941DABAFF9650AA1641082A860080A129413976A0D5C2AE1641B86A7F6A91A32941E502D00482AF16417F82F99FD9A32941C21E14BB36AF164138D5226607A42941
161	11200039	1	US   27	27	5	11	Lake	5	0	0.27	434.093	434.092997403184	0105000020E61000000100000001020000000D00000070428874816F54C098A0296C048B3C405873E689816F54C04D63D395248B3C40F4936FE1816F54C0002CECF4328B3C40ECAD9EEA826F54C0F69BD0424A8B3C405E0ABBE5856F54C0FFCA9D3E7B8B3C40F3842EC9866F54C0E51554D78B8B3C402676A8A1876F54C0829D9EB79D8B3C4040029133886F54C0104CB133AD8B3C40F9C23E7F896F54C0F3703D83D78B3C403FA12A1B8A6F54C064D1647BE38B3C4010C9DFEF8A6F54C07894D80CED8B3C405E3C96F28B6F54C09FACC3D0F58B3C4032F5B6858D6F54C01F08D015008C3C40	0105000020BC0800000100000001020000000D00000046CB72B6E58019415F23340AFB5B3741B0F5AE96E3801941A7847F7EAD5C37413E528DC2CA80194124B05845FD5C37416F4F80C37C80194134BE43B17E5D3741B5A5BED5997F19416D13BDD28E5E37411DBAE078567F19417C78E502EB5E3741079E63A5167F1941FB0C304B4E5F3741D2F54A19EC7E194173893A46A45F3741463EE45B8C7E194167E5B42D8F6037417E7864435E7E194139A711A9D160374120BB43731E7E1941127DDCD806613741C56CDA70D07D194109FFE799376137415D13A06B567D194153DA41C570613741
167	08050000	1	US   98	98	7	08	Hernando	7	12.558	12.766	334.6777	334.677712079217	0105000020E610000001000000010200000003000000528164503B9954C0E2EB67763A8E3C40910E57A33B9954C020F15B763A8E3C40C690395C739954C08B5A9C013A8E3C40	0105000020BC080000010000000102000000030000004F482F0A927509419CB57199157537419C2B363E5F7509410B9F18AC157537415B8FB23F3F530941088F9ADC1F753741
168	93120000	2	US  441	441	4	93	Palm Beach	4	0.228	11.691	18412.6104	18412.6103898446	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
171	13010001	1	USB  41	41B	1	13	Manatee	1	0	1.379	2221.0222	2221.02216247046	0105000020E61000000100000001020000001A00000046B3A6AC99A454C0112A4BA92E7E3B401FCAB6618EA454C0EDB8908B2E7E3B406BBAF35E8EA454C0084AB0C97E7E3B401075C5578EA454C02A9B78458D7E3B40A8901A648DA454C09C8979AA927E3B40745150478DA454C000C82B71C27E3B400E06433E8DA454C0F2AE7D2CD37E3B40277139478DA454C0447DC741197F3B40C09721298DA454C02BD3D72F2C7F3B4078C131B38CA454C025F62945537F3B40A683131B8CA454C017DA15AE857F3B40ADE0D0C08BA454C025353D08B77F3B406E1E798F8BA454C0301BFD68E17F3B406E450F558BA454C07E0860AF10803B409988377E8BA454C0938522F73D803B409F04BA058CA454C036482B8263803B40FC5981FC8CA454C0A9E1F3838C803B4037DE965B8EA454C0305C855CB1803B4076AC6D6890A454C05F8B1773DB803B4059C24A2BA6A454C019CCE37285823B40E41217BAA7A454C0138E8439A3823B40F154CFEAA8A454C0D46A1795C1823B40C16C1752A9A454C06352FC82D2823B404B041DB2A9A454C0C913BA50EA823B407555E8EEA9A454C06ADAD4D616833B405BB26CDCAAA454C00508E8F01C833B40	0105000020BC0800000100000001020000001A000000C7DCA1558BE30141F502D794599231416618EC3C87EA014108C9411B56923141D402E90BB6EA014146E7B74F139431412E4BD3A0C2EA01410EADAEA963943141BFE9355C5CEB0141FDEACA5A819431416B37B60489EB014193E5BC668A953141610A580598EB01413B7B7839E795314134CAA0DEB9EB0141F611C7126C9731417993FC1ED7EB0141EAB27E12D5973141F98CFB0636EC0141839D23CDAD9831415C745C70B0EC0141E2EBFB56C5993141FDBE050004ED014180CE0B12D79A314171010C563AED014199387725C29B3141BEC0D90879ED01417CF62162C89C3141E805DA0879ED0141CC52AAA6C39D3141E9C30C563AED0141E3FC3F15949E314183C46CC6B8EC01418DE3A7D7779F3141F6875A5FF4EB0141C9961C9E44A03141F9B99977C7EA0141E212EFA52EA13141DF2B8E1E42DE01412B85E4AA6FAA3141C92DB6455CDD0141AEFB714315AB3141F49E41EEB0DC0141BF3ECAFEBDAB3141AFB73B987ADC0141A87D5F061CAC31415E3E519E4CDC0141B60A4330A0AC314158BE841740DC014114C6694797AD3141FB619CA7B0DB01412962DC5DB9AD3141
174	13040000	1	US   41	41	1	13	Manatee	1	7.754	8.425	1075.3192	1075.31919302697	0105000020E61000000100000001020000000E000000C904C806DAA454C0054B625559763B404F12F6ADD3A454C078C7466459763B40C8C0A106D1A454C011C7048359763B40DDA1F966B9A454C02985CD595A763B40F69F1911AFA454C0061BD97F5B763B40C3213AAEA6A454C0973C42A85C763B40C5669949A0A454C0A41130F25C763B40F9E59F5097A454C0D7AC2E875C763B40FBABB9838EA454C0841C09C65A763B402BEB5F2F8AA454C070DE0DE959763B4066F32DE883A454C08247227159763B40A1AA1D2678A454C01EA777A359763B40E860752D4BA454C0C8A32E7B5A763B406469DBCE27A454C059B041635B763B40	0105000020BC0800000100000001020000000E000000F4C320B554B70141223170A7F3663141EC0F92ED41BB0141E6500962F2663141295B7942E6BC01413E4F0962F266314164ED121684CB0141ACD30B1CF1663141620AEE96E9D10141B406EFE3F46631417E866F641AD70141536C4836F9663141AFE8B70B0FDB014168684836F9663141FA276FD29BE00141BC8516A5F4663141261BB3940CE60141982ED9B4E86631419A6F7DC5B9E80141970643D5E2663141EAC790CA9BEC0141C68D8FA9DE663141D3B7AA0FE2F3014126ED87CFDC6631413A34DDC5B40F024131F7693ED66631414ACC5BDA962502418AB11272D2663141
176	26020000	2	US  441	441	2	26	Alachua	2	24.654	26.493	2963.3385	2963.3385264868	0105000020E61000000100000001020000001800000024ECA95817A654C0D31F51E883D43D40E825D5F21BA654C0C1F1C98A9BD43D401EBEC27647A654C0231009E477D53D40136DEFDA5BA654C0620B8F34DFD53D408D00D5BB5EA654C01430E0D8E7D53D400B98B14468A654C03B74F61318D63D4055D3EA7A6FA654C06E9B91B23AD63D4091B2C9F989A654C0D2D63371C0D63D404C0B7E8390A654C081760C0EE2D63D40C2D336AEAFA654C0D380A11581D73D40564D94F8C2A654C0FC742C42E0D73D40209B52AEC9A654C07ED5C0F506D83D400230F1F6D1A654C09C836F993CD83D409DABC84AD6A654C037A106C15CD83D40B8118432DAA654C014A1456C7CD83D40F81499B3E0A654C03C572515BBD83D40632CAC2EE4A654C040A733DFDFD83D40DF7C64F1E6A654C02FA19A2E02D93D40ACBF457AEAA654C0A12C7CC035D93D40C996A28BECA654C0DDFF730D5BD93D40DE7A9994EFA654C00B6B32AAA8D93D40AB681E9CF0A654C0A0FDD77EE0D93D40F8EC19E8F0A654C0C926FA6911DA3D40F52EE85CF1A654C044F53DAC81DA3D40	0105000020BC08000001000000010200000018000000042EF159415A024126B3DB94FB8A3E415ED02B3A87570241641557FD7F8B3E41B7405298BC3D02414FEDF69E52903E41DB7351CBA63102416F034F8195923E412308E867EE2F0241000EFC3DC6923E4154839FCA472A02417867C87DD4933E41BC11DE7600260241F5D4AD9296943E4188B64E7A4C160241601B100084973E41D9DA64EE6C1202415A2F985040983E41FD3DAC86F5FF014187AC8F58BB9B3E41A3A9CDA385F40141BFE1BEC6D09D3E41E2EBC1B38EF001417E008E62A99E3E4147E1625FADEB01412C947653D59F3E41F7EB794623E9014130C1E0F488A03E418E28B144DAE6014126B203C739A13E41A562841512E30141EB0A734D97A23E41C60828FC0DE1014186CB776D64A33E41048489D977DF0141A1D74A9923A43E4130FC3E9574DD0141195ABBC542A53E41796BA0934BDC01417212A05A12A63E41479678D8A5DA0141654452EEC1A73E41AB5F9B1F29DA0141D01D4413F8A83E419B1CBE8719DA01412F7983A807AA3E413897B88F18DA0141C65680D476AC3E41
177	72270000	2	US   17	17	2	72	Duval	2	20.516	21.398	1419.6908	1419.69075899319	0105000020E61000000100000001020000001500000011C00412BB6C54C08792F6F53A523E4043DF6838B86C54C033C7AABE3D523E40AD8E7545AF6C54C05F7BAF9F45523E400FD789E9A66C54C078C323E64C523E40DE56F4559D6C54C0380A244752523E4031638623956C54C0D2BF63D154523E409D9B1A1D8E6C54C0AF46338654523E402E43BBD6856C54C0669AC22F52523E4005FEE0CA796C54C05E5FD34649523E40F388D121716C54C0B926C8B33F523E40DD98AD68576C54C0EE0E45251C523E40AA85782F506C54C0475EEDB015523E40FD7254014A6C54C04F63850412523E400D1FAF8E436C54C00BA2F75F10523E40EF87D774396C54C01319DE2810523E409E4E3C54366C54C01EA38A1010523E40F2C98B972D6C54C03F2830E80F523E40C8A711E4146C54C079D7582C11523E40114A5AE7E36B54C06EAF7A2213523E40A2F5E038D46B54C0145C948C14523E401D0BD7FDCC6B54C01741170D15523E40	0105000020BC080000010000000102000000150000009F5A04CBFA961A417D3D6D8DC89C404112F5D3B7D6971A41C00BC61BD09C4041A6873B28899A1A4189A7D170E59C40417339FC100E9D1A418EB80622F99C404181452D7FF09F1A410F52DB7D079D40413358DD4568A21A41CA56170E0E9D40419A2A6A6385A41A414E1331D30C9D4041734F3C8002A71A41138B8ED9059D40415452473DA1AA1A417D187F6AEC9C4041321401113BAD1A417481AC56D19C404184DED0C2F3B41A41CA9284296D9C40416C022F541FB71A41506EEFD35A9C40418E0A5AE9FAB81A41AA6A9445509C4041D5401962EBBA1A41D51EBD554B9C4041F0B7FE74F5BD1A41726C2C254A9C4041C5B68E5AE6BE1A4181B3BDB2499C40414F27495F87C11A416A0FB8BF489C4041D0B34555F6C81A41BC273ED14A9C4041F0BF0D35B4D71A417A6543674D9C4041ACB9E8626CDC1A410942976A509C40418DFF637299DE1A41438FA963519C4041
178	11210000	1	US  192	192	5	11	Lake	5	0.29	1.301	1643.0786	1643.07855962986	0105000020E610000001000000010200000008000000250C48A8206B54C06C39371AD2583C405C02A3601B6B54C0015F2251D2583C40B247FE11F26A54C0EFD41048D2583C409CECF2BAEB6A54C031D311FDCE583C409E8BAADD876A54C03DCEB089D0583C4092679247466A54C0C55F8D4AD1583C40146A2513116A54C09DFD7459D0583C401899FB0F0E6A54C09E51D246D0583C40	0105000020BC08000001000000010200000008000000FDC62085D7D11A4126148043FB4436411924DD2D76D31A41A4A306E0FB4436410124521122E01A4136010629F74436414719828C13E21A415166F732E44436415E0F472EB6001B41640F85F2E144364137164DD2D4141B41C5DF920EDF4436410EB265EC26251B411731C620D44436414CDA3B7A13261B419325ED66D3443641
184	53030000	1	US  231	231	3	53	Jackson	3	0	0.586	944.6739	944.673944679281	0105000020E61000000100000001020000000200000029E0ADD0D55855C01219D58E1D913E40BB6A731EC15855C062F7226246933E40	0105000020BC0800000100000001020000000200000018A62C97062426C137267A32907E4141AB26AE97FA1F26C11A628B9888844141
189	10130001	1	US   92	92	7	10	Hillsborough	7	0	2.96	4791.2387	4791.2386646919	0105000020E61000000100000001020000000C0000002699270B78A554C0A363D2F7DBE03B40F89C235F47A554C0F746D78712E13B400FC1C1DA8BA454C0B5686127E4E13B4034BC48993EA454C0FE7EDC6C3AE23B4004E4AB72E6A354C0F310AA1A9DE23B4002AD29C87BA354C0C44077A314E33B401BE2D9D1ECA254C01A12E7E4B4E33B40C38F45FEAFA254C0B663E202F8E33B4002E6878B9CA254C0FBAE09CF0DE43B40DC2E788590A254C041D1E05E1DE43B40AFB59ADE86A254C010828B372BE43B40BF7BCB2580A254C06E16B80A35E43B40	0105000020BC0800000100000001020000000C000000AD67516557920141AAE68A2612B63341486FB0DB75B0014173DCA77B34B733416D7F3D467E240241140DACFC8FBB3341AF43DBB44B5402411CF0D8275BBD334137EE06B2D68A02417E2E8D7C68BF3341761BFF01D6CC0241951A3CF9E4C133415154F885492503413BC5E6783AC53341141816CDEA4A03412DAA2DC09FC633413D14C405F35603418502ECDD13C733417EBEFF7E645E03411247C03A67C73341EF479ED55E64034180B5B3A9B1C733410BA59FB888680341EDA29E82E6C73341
195	18120000	2	US  441	441	5	18	Sumter	5	0	1.016	1630.0699	1630.06990068811	0105000020E610000001000000010200000004000000C36874340F7D54C0288379DBF8F23C403DC146FA0F7D54C06A8101D6FBF23C40DB01605EC37D54C07B8DC6C5BFF53C40A614359CC57D54C04B099467C8F53C40	0105000020BC080000010000000102000000040000006B687360ED6C15411EC493E0A69E394106D1AD91B16C1541C333BA86B79E39419D3A39AF79361541C634AB052CAE3941C5205D3BCC3515410D9080465CAE3941
198	36010000	2	US  301	301	5	36	Marion	5	14.711	24.959	16467.3016	16467.3015534125	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
200	48100001	1	US   98	98	3	48	Escambia	3	0.622	0.982	580.5837	580.583694706747	0105000020E61000000100000001020000000A000000E82EEB8B27CD55C04F6271DC7E6A3E401E2266CA26CD55C0F93E44557F6A3E408D5D36900DCD55C0B5CD6DC38F6A3E40028EC61CF6CC55C0C563207E9F6A3E40A65483D3D0CC55C03B0DD22CB96A3E40AC12A70CCFCC55C013BC35BDB96A3E40599AA388CDCC55C09C7EF856B86A3E40FA9E2521CACC55C0E96F7EB2B36A3E401D16ABA3C8CC55C0886C041EB26A3E40D9602AF8C6CC55C04FA082F6B06A3E40	0105000020BC0800000100000001020000000A0000004AC78DF1F2DC33C10A40630EE347414113B9BD36E4DC33C193ECD4F7E347414152956271F8DA33C1B77E044B044841413A18BC292FD933C15B38069D234841413A762EE757D633C116CF8A4A574841415648F87235D633C1187DF9EA574841412B1A5BA218D633C1BCEC363853484141503EB65FD8D533C1E6B59E7E44484141E8EF521BBCD533C19650AC4E3F484141352E983D9CD533C1E23F8A353B484141
205	86010000	1	US    1	1	4	86	Broward	4	8.286	10.33	3284.087	3284.08695586159	0105000020E61000000100000001020000000E0000006672179EBC0854C0FAE8222FC1173A400FA16FA4BC0854C08ADF32ADC5173A401CA7CAE8BF0854C07F9006B4A7193A404F8947F8BF0854C057B48E3DB0193A404688B21EC30854C0150DFF07861B3A40657DF533C30854C0E4A7D1A08F1B3A4003259978C40854C081F0D2C1831C3A403E43D521C50854C0DA93F6EAF51C3A40C117BB3BC60854C0B4B94DDDC41D3A40C2057C94C70854C032174B368B1E3A40EC20007DC70854C01814B504B01E3A4071152BDDC70854C0DD9077FBE91E3A40E3723D36C80854C0FB871E314D1F3A400EF6B549C80854C0CAA0B5F3571F3A40	0105000020BC0800000100000001020000000E00000097CB95A855AC2C41F167CA47C78A2341F20CD35554AC2C411019681BF98A23412BF2F8FFADAB2C4170159438DB9F234158D4C5F2AAAB2C411814F2E739A0234176856B340AAB2C41FACFB25394B4234186A6012C06AB2C41C62AE9C2FEB423414D60116BC1AA2C4139DBF97A92BF234153A2788A9EAA2C419285ABA884C4234163D0063663AA2C411DA687F87BCD23411586E2AD1EAA2C4128AAECD413D6234146C991A51FAA2C41FFA19323ACD7234118CA1D560CAA2C4170E498042FDA2341E42C511AF7A92C41281AA36E7BDE2341D369CF43F3A92C41102470C5F2DE2341
213	32040000	1	US  129	129	2	32	Hamilton	2	0.065	7.591	12110.9569	12110.956877885	0105000020E6100000010000000102000000350000009B427FF57DBD54C0911E12DA33863E40011E810884BD54C0878F0C1243863E408709CC8492BD54C0FB986A2F5D863E40A3F0F7899DBD54C0F606A35B70863E40F4458471A8BD54C0FE1BC6B68A863E401A4522C7B2BD54C011F7D26FA3863E40627AE89AB5BD54C08265A9C4AA863E402385CDA4BDBD54C05CD4039DBF863E4099F1E05AC8BD54C05F382C1BDE863E405167C8C3D0BD54C021F0E5F9F7863E40000217D7D8BD54C04762AEDA12873E40E0B531E6E1BD54C097B11E1833873E4092CAF96AE9BD54C03EF327EA50873E409A762F66F0BD54C0E43E381B6E873E4035ABEFBFF7BD54C02699686E90873E407A4C51EFFFBD54C06F72F82EB9873E40422ECA2D06BE54C087C66193DB873E40A8C350050EBE54C02A3D39180C883E4047691E9314BE54C0B68DB9CA38883E40586FF54A19BE54C0C53B7C1A5E883E4042C9EFE91EBE54C0854AF6BD8A883E40D5D8E30535BE54C0C7A21F253C893E404E72B5424DBE54C03E9AB150FD893E400278474794BE54C05491139D358C3E40D1277DD19ABE54C0B96388D8698C3E4098ABF43AC5BE54C0D80350F8BC8D3E40CA1EA641DEBE54C097EF47A9848E3E40BA627546FDBE54C0D4619C747C8F3E407DC8D8860BBF54C010D35262EF8F3E4031C8928A14BF54C033EB8E4F30903E40B36A9FBB1FBF54C0E1749E2C73903E40B36705AB2CBF54C0B0466BABB6903E40D148ACCD50BF54C038DDA70374913E40D355A4177DBF54C0DA928E4F5C923E4030EE790CCEBF54C0E203D1BF05943E40E30C517856C054C0F2F015D9D0963E404E2ED4CB8CC054C057B46455ED973E404F3A94B99CC054C0C5F4482D41983E408174B05EB1C054C0FCB45C5DAD983E40169CD20D14C154C0A2477F0FB39A3E401C2E6D673FC154C0EC209C26969B3E4095E9F3BB53C154C01E8A7546019C3E40A56DFE315AC154C0C1EC9A3B259C3E4011A7AE2E5FC154C009A2C4FE449C3E40C067745964C154C03A7ABF9F699C3E402807B2F96BC154C0C22B1A4EA59C3E40BD90400572C154C0B16E09D5DD9C3E40EEDE726675C154C0D3B161AF019D3E408272EC8678C154C02C1A9B482A9D3E40ECCB15457CC154C0C3C58CA8629D3E40B8D145297FC154C0C80D67CEA39D3E404E9A4ACA80C154C0472C4C3EDA9D3E405CD3D2DD81C154C0F1277966189E3E40	0105000020BC08000001000000010200000035000000779BE0D2D2E8E240A44C1C54263641416110D85969DAE240BFFC99955136414143AEEA84EBB7E240A9C55E7D9C3641416DFB60EAAB9DE2409FB5668CD336414158791BC0C983E2405224B2861E374141D9F9443C416BE24081604BE0643741413A0B70CF8C64E2409993C6B279374141A41BD58C7C51E2405B08D4E6B43741413FB1F33A1E38E2407ABEB8540B384141F8250C523924E240AEDF558B543841411E387D3F2511E240FB37F67FA03841412BB67DD1C4FBE1408178D080FB384141F0C3EB6910EAE14057B673884F39414195B2FAA7A4D9E140638B4DBAA1394141BFF8C2B265C8E14038AD8C3B023A41417609B96D39B5E1407DE898B7743A41412AF91F6DA3A6E1405B954339D53A4141E38D55786294E14091CE5F355D3B4141AB5A5CF22D85E140EEFDBC5EDA3B4141E02A5CB84B7AE1407A5B51B9423C414163EC53EF546DE140786AF990BF3C4141D17DC4455D3AE140E3AEE3ADAF3E414195E3DE637A02E1404BEFB0EACB4041413241F8CCC65EE040D90ECA3E0147414189AD6CB7B34FE040ED2EF552934741418D604FEAE7DBDF40E229A2C1474B414137E32E618C68DF40B080DA3F764D414148525BF695D9DE4043B787462B5041418C6323B4EE97DE405D6144AF6C5141411AA3793C376EDE40B1921E6C22524141DAA43FDD163ADE40FBC9BFE7DD524141D64A67989AFDDD40CCCD27709B5341410E01DADEA854DD40985F431DAF554141546EE9689D85DC405274C8663B584141EBE1CE57370BDB401857A008E65C4141898BFF05A58DD840D12DB72DBE644141ED740F8AC88FD74038CAD61CDD674141AC07D37E5D45D74008571F90C868414144501B77E7E4D640D3FC5065F86941412C1B2954E017D540B799F94CA66F4141BB6E86675F4DD4403589E1172472414163901E826CEED3405011A3F050734141BB231BF84BD0D340A09558DCB5734141BB84B99F24B9D3405656FBE10E744141860B5A253FA1D340A425927175744141E00F9F971E7ED3407E0C136A1C7541418FF2E8258162D340CA8CA95BBA754141A9B148092C53D340C74008751E7641417B42010F2C45D340A53F55AF8F764141FE31B4DB9B34D340A77A00CF2C7741410400F3645A28D340AF68EA22E277414171C3DE29E421D34052E944847978414142735EA4461ED340B2FEAA3A26794141
215	92030001	2	US  441	441	5	92	Osceola	5	0	2.336	3756.6784	3756.67841053686	0105000020E610000001000000010200000031000000B783A6578E4D54C0DD32D423FE3D3C4087697C4F834D54C0E301B58DFA3D3C407A7CC2BC804D54C02A7448D6F93D3C40562615F66A4D54C0C49219C6F33D3C40599D03454F4D54C00B80CF56EC3D3C40AEA57FEB2C4D54C0E126431DE33D3C40228023A7234D54C01C0371FEDF3D3C4059EBEBBF1C4D54C0DC709CF4DC3D3C40D0934C29144D54C0520BC77BD83D3C4048BF99D90C4D54C085897BCFD33D3C40C2FF9BAC054D54C0B87ED4A7CE3D3C4090446C3FFD4C54C0B4CEADC6C73D3C4010A7AE1AF74C54C089D94C1DC23D3C4047B4A550F24C54C0413ACD48BD3D3C409629544EEB4C54C03A969CC4B53D3C404622895FE44C54C0459F646FAD3D3C40C618B514DC4C54C083DC33B4A23D3C4016C9EF09D54C54C0651ADED4983D3C4065D1508ACE4C54C05AB45D0D8F3D3C40D6EA1C46C64C54C04814BFB8813D3C40730D59BFBF4C54C0CAAC5E4E763D3C40C0C19D6EB84C54C09BBACE95683D3C40E23C437FB14C54C0BED6A7DC5A3D3C40650889FDA94C54C0F54532BC4A3D3C40FAF56950A14C54C073A94804383D3C40453377DA3D4C54C0EEAF2514613C3C40D31D5BA5364C54C0BA656390503C3C40F9146AFB2F4C54C0832AC855403C3C4076827F72284C54C0EC2E7FD62C3C3C40116CAD45224C54C0325667BD1B3C3C40D75BB9261C4C54C04FC1E3720A3C3C402B48C6E4154C54C01C498D0AF73B3C407E4066170F4C54C0527054D8E03B3C406EA629DC084C54C031CAC407CB3B3C40B621F5DD034C54C096EFAD03B93B3C4098CAD758FD4B54C06CB5D1AB9F3B3C40A620CFD0F64B54C0BEB1C462843B3C407501A96AF04B54C078DAF1D6673B3C40D9F43770EB4B54C0F0C37DFD4F3B3C4016C42AE6E64B54C007177306393B3C406FA23755E24B54C040ED1A94203B3C4051513F13DF4B54C0B866A20C0E3B3C40D1C5FBDDDA4B54C0CCAE2979F43A3C400E8A662BD74B54C06BB43FE0DC3A3C40F41A0B92D34B54C01B062F8EC43A3C40DCCAD1DFC94B54C08CB2582D803A3C40A908681DC54B54C0B84E34755E3A3C405130A0AEB54B54C0AE28C369F2393C401D4C5E9FA44B54C0E03457FF7A393C40	0105000020BC080000010000000102000000310000000A40573584F121413A842F4104AE35418B7093B835F321411BF7CDFAEFAD3541CE30B2D69AF321416258A9EAEBAD354139694A94F2F6214141A95A89C9AD354163B835CB32FB21418532445A9FAD354101B77AA778002241637ED8056BAD35417ED3B2D0E4012241C31B166759AD354192C29912F4022241D6BB1B5148AD3541A3351F8945042241B22FEC382FAD35413855C2CD6405224124FE3F0E15AD3541456418BC7E06224197C68238F8AC3541A5C0EBCAC90722411D660FC7D1AC35419EDF4425BB082241FED09C2AB2AC35416B771A4977092241FEF9A13697AC35410B7E849F8A0A224191A1FE486DAC35415F77D0F29A0B2241C7FB7ED43EAC3541739CD3A9E00C22416201A60603AC3541D89CDC41F50D22414FA51307CCAB35412B04807DF40E224101D15E9095AB3541C64BA1243910224139769C574BAB354118C0D47139112241826722CD0BAB354192E577B6581222416E0A1772BFAA354137B7150869132241D9AC0B1773AA35418B33D4C78F1422414366E56119AA35416CD53473E4152241EED5AC42B1A93541E08C3CDB252522413425AEB705A53541AEAE22DB4026224190DD3EE0A9A435410B37A37E46272241052412A34FA435410EC1F14F6E28224158E2833DE3A3354156CC57BA602922417E0A263284A3354134E72003512A224177A5221524A33541531B62A2462B2241FEFF4839B8A2354145E4DD9D512C2241886CE0E03CA23541C908642B462D2241915BD6AAC3A135418172D61C0A2E2241535B82915FA135411FC667F3092F224102D932C6D2A035411E0CAD340A3022410B13A9343BA03541C7430D3D0531224112599FA59C9F3541530D6E82C83122417E920830189F3541AB62578A7A3222418D6AF5A5989E3541A2E33E9B2D332241DD067CE3109E354168373A57AD33224157B829FFA99D354180D1E44F5234224137AF8EFB1B9D3541EBBCC540E3342241C5A522F6989C354164B4364F70352241C46359EE119C3541DC0A1849EC3622412752064D969A3541D40589CCA6372241FAC46318DB993541162F509D033A2241EB15763D83973541D437A635A03C2241D827C041EC943541
219	55120000	1	US  319	319	3	55	Leon	3	3.731	5.288	2506.9018	2506.90175421503	0105000020E61000000100000001020000001100000063D0AA1A7E1355C048EA4B43225B3E408B9333B47D1355C08ED68D31245B3E406216C990771355C04F49038E3E5B3E40EB8649DB701355C05083B17F595B3E4086A19D0A6B1355C03EDE76196F5B3E4028A4D6E0571355C0CF2F2FEAB05B3E40A609007F511355C0CA60B184C75B3E40CA3ECB4D4C1355C060CCAF95DB5B3E40F22AFDFB461355C0485F2A80F25B3E403AAC298F421355C0FE48EFBF075C3E40D465E3203E1355C0ECC203F11F5C3E400395E6F43A1355C0776E7FF6325C3E403D0AB6FE371355C06C17CAC0455C3E40A431375A331355C0E5C9A9C9685C3E40ED7CF91AFD1255C04D1D098D195E3E40A7B3BA12C41255C06165BC65DD5F3E405B4875F7B81255C0DC725A1A35603E40	0105000020BC0800000100000001020000001100000026FD353E3C9517C1B18392ADDBD14041B7A03F251C9517C1E88350EDE0D1404155796001329317C1BF1BFA6728D24041F46BFB831B9117C136FA035871D240411A2987604D8F17C10E48BFB1ABD240415D76FDF05D8917C1F32404145DD340419DA75F77638717C1191F1A0E9AD34041AFAA2B57C68517C1D6791A52D0D34041D6C3FB8E1D8417C14350BF760ED44041D12F85C9BA8217C1CF45C23A48D44041B8322DAD558117C109A5502A8AD440413F318DEE548017C1C9BFC718BED4404115285C88647F17C1C5CDFC71F1D4404111ACFF15E87D17C1DD13B26E51D54041DE5DE1CD7B6C17C1ABEBCDFBF3D9404131F6BC1A2D5A17C1B795A8C2CADE404113B484A99C5617C16CA34634BBDF4041
220	72090000	1	US    1	1	2	72	Duval	2	0	0.162	260.6455	260.645472745328	0105000020E61000000100000001020000000400000098F9DB7FA66D54C0D3DBFEAC135C3E406F5FCCFB916D54C086689232A25B3E402230B6EB8E6D54C0A90FA0C6935B3E40174A11748E6D54C02E61FC2C925B3E40	0105000020BC08000001000000010200000004000000F197EA0D83511A411A480F2929B8404186C0A4FF9E571A41D29CA409EDB640412A9E7BD688581A41248EC5D5C4B64041B23E6E9AAC581A4139CADD5DC0B64041
226	01040000	1	US   17	17	1	01	Charlotte	1	1.532	6.425	7879.92	7879.91997413381	0105000020E6100000010000000102000000580000008D683F38DC8154C0FEB68246ACF03A40B34A1611DC8154C053AC7DE5ABF03A402371CC07D18154C09C7D831E90F03A40A0072F56CA8154C0BD0D60E87EF03A409D05FB04C68154C039BE861875F03A4012822906C28154C02FC1C7286DF03A40B730B929BD8154C0ADDFA13F65F03A404C5E56EAB88154C09285AA955FF03A40D9767A6FB48154C0E04EA8AE5AF03A406A864535AF8154C040EC194E56F03A407936E019AA8154C087EA226F53F03A405C8506CBA58154C098F81C2252F03A4092817900A28154C0AFCA09A851F03A404E1DC8AB9D8154C06C47F01152F03A409685651D998154C06674435753F03A40210E36E9938154C0B8BBD73856F03A40141D3FA18F8154C0DD29669259F03A40292CA5798B8154C038836DF85DF03A403A9F9E74848154C0AF5A0D0267F03A406F1364C26C8154C01122A70A84F03A40AEF3782E5B8154C06AB47BB999F03A40DB41E7F4588154C0B6C61F789CF03A40D55DFE7A4B8154C0B9B319D7ACF03A40EE99E4E5398154C0F2CBEABCC2F03A40070D109C348154C083CE0743C9F03A40D3F8BE6C298154C0C7689BD6D6F03A40DEBB69171B8154C07B916061E8F03A40527ADEE6188154C05F4AAC09EBF03A403FA7CEA0058154C0C65FEAE602F13A409656C401DC8054C0E66A9CFC35F13A40B6033AF0D28054C01356EA9341F13A401835D5AFCC8054C0483EC90F4AF13A40E4CE56C9C68054C01DF4DCB352F13A40DBACD236C18054C0466F78805BF13A40561A7300B68054C04D73E2466EF13A408636492BA88054C06ED2D95F85F13A40968A40BEA78054C06626ED1586F13A40F278600F9D8054C0094177EC97F13A40777EF7DA648054C08F1191E1F5F13A40C32AA4AD398054C0939A9F5A3DF23A40C7715F4B348054C0343CDF3E47F23A4063A291B52F8054C01C8A65FA50F23A407F1758F52B8054C0B04AC3AF59F23A40C03301A9278054C06AAD98E164F23A4099C55C55238054C056CE989F71F23A402A73C4E31D8054C08FF327EF83F23A4035AD36F1108054C07593A387B4F23A401AAE9186078054C092EE17CDD7F23A40CBCF3D80FD7F54C0A4FA8DD8FCF23A40CEADA81AEF7F54C06C91F4BD30F33A4033842379E87F54C0679FFAE348F33A404017BBF2DF7F54C0E0DA741E67F33A40D6AF5210D47F54C0C06BE51690F33A4011CB8F36C97F54C07C7112C5B5F33A40C9ADE9E5C27F54C00AD61558CCF33A4025FB2DFFB57F54C0251589DFFBF33A400CA956D4AA7F54C0023183EF25F43A40E7EF7CA1807F54C0EBDEF94CC2F43A40597399EC597F54C09B94B2E352F53A409EC6B4124F7F54C093E4CB8C7AF53A40896A68554B7F54C04653836787F53A40C7E7F2FC467F54C075EBC35D95F53A402C5EC4CA427F54C02D1FC0ACA1F53A406641291A3E7F54C051A54CDBADF53A402D40AEE3397F54C0AE9DA94AB8F53A4061A5938E347F54C0FDAA886FC4F53A40C1B8840F307F54C086EAF29ECDF53A404A080E012B7F54C0BF447493D7F53A40554D5466147F54C021050F2B04F63A40684A5F17F97E54C068642E8439F63A40F1F4494CF37E54C0683BBA9F44F63A4017AC6BCFED7E54C02D9511774EF63A40CC7A9A60E87E54C0697D138257F63A40B8FACCFCE17E54C0200176C061F63A407F5ACEFCD27E54C035758DA477F63A406C7156467C7E54C0ABB536DBF5F63A404D381E482E7E54C0841C252566F73A40EB2E60650F7E54C012D2CE8A94F73A407B81D305E27D54C0996D718ED8F73A40C31DBF5ACC7D54C0FCE1D979F8F73A40C8FAF016A47D54C098E0BA1B32F83A40F7470B4D9D7D54C071CD51823CF83A40A7C9BC5B977D54C03B1E119047F83A40AE4ACE47917D54C06EC4A68454F83A40AE09E1348C7D54C0EBF166A561F83A40E2837AC6867D54C08AC8A62E71F83A40C0671CE7817D54C090EC3C4D81F83A40ED81A9D27C7D54C04BCD79FD94F83A40	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
228	49010001	2	US  319	319	3	49	Franklin	3	0.769	0.845	122.2072	122.207226800563	0105000020E610000001000000010200000003000000E103A6522F3E55C024071B7CDAB93D40CC9D7981283E55C0D598BBDDDEB93D40258388EE1A3E55C04AB3E229E6B93D40	0105000020BC08000001000000010200000003000000DEF9E6543E7622C1AD2F13201A3E3E417FB63133347522C1667731EA2D3E3E41DB3127D5227322C16EFB1D654D3E3E41
235	72040101	1	US   17	17	2	72	Duval	2	0	0.072	117.0053	117.005319907378	0105000020E610000001000000010200000002000000E7AAAF53FF6954C0E0748CAC0D553E4008F4EFFAEB6954C073ABB7E4FC543E40	0105000020BC08000001000000010200000002000000EBB88141E6691B41EEB827B375A440414821C83FB66F1B41A0CC8F0F46A44041
239	92010000	1	US   17	17	5	92	Osceola	5	0	0.536	862.8957	862.895659197291	0105000020E6100000010000000102000000030000007AFAE96B4B6354C03195489DB63F3C40FA54DCD8FC6254C0AC21248461413C400EEA5AB7FC6254C061D8BD3C62413C40	0105000020BC08000001000000010200000003000000961101B76C361D41D2F470A2E8B83541DC36A19BB74E1D4176F2590022C23541431493F7C14E1D41A8A181FD25C23541
242	34020000	1	US  129	129	2	34	Levy	2	0	7.832	12619.7394	12619.7393549557	0105000020E61000000100000001020000001E000000B4BA14490BB754C06C4E2290D37C3D40BE6CCB640AB754C0EA81B075D57C3D40F58AA50C08B754C0BD987472DA7C3D4051F392EEC8B654C0D26783C9697D3D4003EFEDFAB7B554C06FEC5DEFD57F3D40A0BDDA1276B554C0DF350BF36B803D40CA7C0F682FB554C0DB6C26CA0B813D4048117FDED4B454C06E1BE114D9813D40CD0C2045CDB454C051F58A55EC813D40702BCF3EC4B454C042CE8FD708823D40DCDEEA8FBDB454C0C5D146F022823D40DCBE5BF9B8B454C0BA700E9038823D4077D59904B5B454C0A59544154E823D405B606232B2B454C067ED77FB60823D40C1F6639FAEB454C03A21A74A7C823D40606242F5ABB454C0BFCD67B097823D40460CC904AAB454C0C727CB07B3823D40D1646BA7A8B454C001F3B888B9823D40ABB0C04FA8B454C0D4B433B8C7823D40245FBCFEA7B454C0EE190C0CED823D407D76FD08A8B454C0FEA06A25AE833D40BACF0839A8B454C01741273DBE843D400FA3A016A9B454C0D4E4A5C97A883D40D64C6221A9B454C0C4E757F5368B3D4030659A15A9B454C0DB22AE55498C3D40DB0B0644A9B454C06FA4B2D4C08C3D406C89FCF8A9B454C05F2683C42D8D3D404DF76C20ADB454C0D22D2BA6EE8F3D40A5BF30D2AEB454C08C9A0DA9EE923D40010A6D3CB0B454C0E833D5D08C953D40	0105000020BC0800000100000001020000001E000000613DCFE99D69EF400049503034A93C414ABA5E91CD6BEF40F4495D703EA93C41CEFA22DC8C71EF409B23586459A93C41140D3C013106F0403906E56161AC3C41A2C61913F154F140272B481F7FB93C4121F9021FC3A5F140E63F6E82ABBC3C41E64A013969FCF1407576E7040DC03C41F629F8A36B6BF24011CD5DC864C43C419716D6A1BF74F2405B4A4A52CDC43C41D79FA672DB7FF240337F79CB68C53C41E93849591C88F2405DB74F99F7C53C413E60DC0CCC8DF240CA4007386EC63C4129C4C137B792F24012BB9C74E4C63C41AAC0B0183E96F240EAFE7B7D4CC73C41EE597FA7BA9AF240CC3C17F9E2C73C4156CA97B31C9EF240AD17E1387AC83C4103856C559DA0F240F8917A6111C93C417D1CEA684EA2F240CDF7BF0F35C93C411CC2C08ECCA2F24080F35DB083C93C41072DA1D962A3F240547535C452CA3C41DC782A3B63A4F2401B9FAE8282CE3C414ACBDFC3A3A5F2400C8052BA68D43C411B0AE618CBA9F24058361F0126E93C419522959B8DADF240E887ED1754F83C4119A178481AAFF24060508AEB46FE3C41390DC68388AFF24005DDB433DE003D415BC0DDCF44AFF240508E9B093B033D412AA59D0A48AFF2406BAB0A3B84123D41AA0FCA1F69B1F2402CA95E5E2B233D4187CCBFE458B3F240B9818C4EB3313D41
256	31040000	2	US   98	98	2	31	Gilchrist	2	0	0.612	978.6881	978.688143730153	0105000020E61000000100000001020000000C000000807A9A31F0BB54C0D416903759973D4083126E9DE9BB54C0DC646E7D58973D40718AEF28E2BB54C02F1CA7E156973D40059B5DC0D7BB54C0E6AB0A5D53973D40F97ED20FCFBB54C0BE6C920052973D40EAC9D1668DBB54C09B0397934D973D40DC5F2F6287BB54C00E6EDF224C973D402AB8C3B375BB54C04FCD3CB446973D40C223E9266FBB54C08A3708C345973D40E22F006458BB54C0C681723444973D408AA4B02052BB54C06D2638C742973D404BE37DF94ABB54C0122269A83E973D40	0105000020BC0800000100000001020000000C0000004AB1309E19D6E340618DBD54F63D3D41F24DEE7B0CE6E3404FB40A2AF03D3D41B779FED51CF8E3405C0661D2E43D3D41C73B7A6B5111E440A49EDCECCD3D3D41C2E003196126E4406002A68EC33D3D410A9E76D696C5E44086229DC3953D3D41510D7C712BD4E440B7528CD38B3D3D41EA7A3863FEFEE440073BBDF7673D3D411AB7F3DFDE0EE5404601D69F603D3D41E1A1FBA80F46E5400F0213A4503D3D41D1FC97563C55E540403202B4463D3D41D9141ED28966E540237E27872D3D3D41
274	06010101	1	US   17	17	1	06	Hardee	1	0	3.468	5578.6042	5578.60419528183	0105000020E610000001000000010200000025000000C3D7B1985B7354C02B176B7318823B40D4F6C8DB5E7354C0D5FC56EF2D823B40C90DE462677354C0E85B9B0A6D823B407DFE2F7E6B7354C0B6FA99A992823B40C8D534F76D7354C0A090804CAF823B400F2FC82C707354C03604F631CF823B4072DE04EF717354C07A424AA1E9823B4014E91DA7727354C0994A47D7FC823B401B631D3C737354C06268CE8811833B40C1BFA8CB737354C0C7AE3CB32B833B40C0FBF47D777354C0096DD544D1833B407DA242A6837354C0516DFB7F08863B40F018A43D857354C0AD83BC723E863B4003189E74867354C051FF2E7961863B40197DE003887354C018F04FF885863B404B1781CE897354C0DC45AFB8A9863B40E5DEF2E18B7354C0CF2FDA05CD863B40F0C13B618F7354C05CDB038307873B406F92423A967354C0E9CB78426D873B40D6511B87987354C0FFEC59568E873B400B779ED7A57354C01804B9E26B883B4077CD18D1B77354C0F74FE4B697893B40D53D3A54BA7354C0758B00C6C0893B40BB93DC65BC7354C0076C8DB3E5893B4034548304BE7354C0722EAFB7088A3B4026951CF8BF7354C0F718F9AE2E8A3B4062AFEFBAD57354C026688BF3978B3B40A0CC30B1DA7354C09DB714C6EA8B3B40DF058EA8DF7354C00F1E34AB3D8C3B40483148EDE97354C093C2BB5CE38C3B409F48FAA7ED7354C0230F3C55238D3B4078B5082EF07354C0E4351D11478D3B40B79371B3F27354C078276E52698D3B4098654F8AF47354C07886B5D4818D3B40ED8727DDF97354C0DE8B1F15D88D3B4046542929037454C0F53CB9E5778E3B405DBED728077454C0AB0476FBB88E3B40	0105000020BC08000001000000010200000025000000B7EA0B44402C184135ED564ABC9E31411688E52F412B1841FA336EE3339F31419F52815CA728184144668B0E93A0314132D519C5672718417CE11D4864A131416E111A32A82618417ACC9A7403A2314172D3E9F0FD251841287315AEB4A2314162C1CE8E762518414BF7D18C47A33141FDA6D7684025184136C26C36B2A33141B7EC4A5315251841FBEFFB1425A431413718E7B6EC2418410BBE334EB6A431411DD95001E0231841488014414DA831414A23F79D6F201841D1095D7899B431417C57D077F91F184173A178F2C4B53141FC187A649E1F1841377AE56687B631414D4AFD3D281F1841F4B5461052B731417A1AAAA29F1E1841273E189F18B8314168924075001E184137B732B8DCB831419D61892AF41C1841DB4F73A121BA3141DA3EC200E51A184149B7A8F256BC314142EBAEC5331A184162B32BBD0EBD3141B3D29542361618414788BF78DDC13141774C0F70D31018417BEEDD0F5FC83141CEAEC89C121018415DA84E2843C931413409C744740F184107F2664710CA314115C8AA2FF90E1841F6E0AABCD2CA314104C65847640E18413FE6139AA5CB314133E57EFBDE0718410DA85B847CD33141F5C6EF7062061841F0800B9C48D53141142FB493E5041841B0F1121B15D73141B7E67D49D1011841F3EF709BADDA3141C51A118FB30018410F898AF610DC314116D1651BF1FF1741A4927185D7DC3141882F5EA42EFF174110503BE095DD314191F6E8B2A0FE1741BECA5F131EDE31412C8A271A08FD1741F7AD993DFDDF3141B4705EE93FFA1741459A2D0275E3314163648D100DF91741DA5DEA94DEE43141
276	72090000	1	USA   1	1A	2	72	Duval	2	3.644	4.428	1261.1447	1261.14469041887	0105000020E6100000010000000102000000160000009C4C9251DC6954C0D8691C7C3A5B3E40E5E3B174CF6954C03A24D9103B5B3E4052359D14C66954C0E624170A3B5B3E407DCB25EEC16954C0B6743C2B3B5B3E40D55EE52CBD6954C0194CBD9E3A5B3E403C1B9F7DB76954C0195C8BCD385B3E402928BB31A46954C074F4EB802F5B3E40BD13C2F89C6954C0A7CB21D62B5B3E40F472E37B976954C07DF3195C295B3E40E93B19D3906954C01608EF9C275B3E4076E52C258C6954C088B0531A275B3E40E120CCFA866954C0D0A13C25275B3E400F1E9CE27D6954C0AF910F3B285B3E4051E538D16B6954C00FE869092A5B3E405F983B3C646954C08BC68E992A5B3E40ECA10624556954C0DAAF451D2C5B3E40A14A5B41446954C01D124DE52D5B3E4033A0DF4C396954C000F011C22D5B3E40E5F62FC0156954C0052862542F5B3E4083BB094B0E6954C09B12B643305B3E4016E1EBE9086954C0210AAD13375B3E409BE14B10066954C0F4A27363375B3E40	0105000020BC08000001000000010200000016000000D029BC1739751B41A5A1742D96B54041492C9AA817791B410FBD691397B54041E9636298E97B1B4128B3977B96B540411DF52533297D1B417A1AB29C96B540410925DD46977E1B416F7D6DD394B54041C00AF1C94C801B411F2B0B788FB540412DA5BB8319861B41EA08279974B540414548613745881B41378A17066AB540413621FD7BEB891B4162803FD962B540411400AB0FEC8B1B41D56D69A25DB54041D3C49954548D1B413045F6F55BB54041CAD31C1BE28E1B41676A5DCB5BB54041A642698F9E911B4168930F4E5EB540410B49CC190E971B415E109C5262B540414867FA0456991B412568F57763B54041EBA2498FE09D1B41257FBFD766B5404194DBB209F5A21B419EFB4BDC6AB540410419E59A40A61B41334215E169B540419C6B9946F2B01B41575B8C4C6CB5404146618FA930B31B4165CA9C7C6EB540419EC986C0CFB41B413A33C51881B54041FC7CCD42ABB51B4143D46ACE81B54041
283	77010000	1	US   17	17	5	77	Seminole	5	16.782	16.929	237.0537	237.053693791048	0105000020E610000001000000010200000008000000FC553E7F7F5454C0CF8B93A20BD53C406FBCE758825454C00DB98FB310D53C40D66CA3BC865454C0D43A521618D53C40E07DB267905454C06EFD8F8B28D53C40B1E9E88B945454C06EC2F6AE2FD53C40FB43E4719E5454C029384F8F40D53C40E50BB62AA05454C0BB5B97FF42D53C4040745BFCA25454C08C486C9C4AD53C40	0105000020BC08000001000000010200000008000000E1B9D41827E520412850FB6F59F43841861C3ED9B7E4204176705AB275F43841B35D73810CE42041C36AE8E79EF43841CD50D11F93E22041AE2B78BAFAF43841B7EA1379F1E1204193C84C8D22F53841B82D601C6FE020416DCF90B580F538419EDA1FE22BE0204155C690548EF538419A67EBEFBDDF20411B2353B7B8F53841
284	93280000	1	US    1	1	4	93	Palm Beach	4	9.031	9.12	143.2993	143.29925450421	0105000020E6100000010000000102000000030000002BF889B2820354C0714A2B459BB43A4091A4288F700354C0012C5C639AB43A40B7071C1A6B0354C0FC2633BC99B43A40	0105000020BC080000010000000102000000030000005B77D9CEF6702D4125364A803D582A41407548C6C9732D41B268101439582A4105FD2353A3742D4191C0FC7233582A41
287	91070000	1	US   98	98	1	91	Okeechobee	1	8.318	9.489	1886.6523	1886.65231694347	0105000020E610000001000000010200000012000000775CD8B9543654C0DA8E42F1593E3B401F1339373C3654C03F035C23593E3B400A4C884A353654C05A6B6738583E3B404B31FB152F3654C0D0914F1F563E3B40A1A5F452273654C00698E892533E3B408026DD30213654C087C61237523E3B40112969011B3654C0B3BC1756523E3B40C2C1F789123654C0F470CE12543E3B403487AB0B0A3654C0B5B4702D583E3B40747F0B52003654C0BA4856F05E3E3B40AED77278FA3554C0E551546D613E3B4097DA94F7F43554C0736E5353633E3B40865DEB94ED3554C065803808643E3B409F2E56E3B43554C04EAC3F1B643E3B40DF28A1DBA13554C054AF5221643E3B4040A4CD5E8E3554C0B2CCC4AA653E3B400A1EC5231E3554C0CD80B529663E3B4090A024EC1C3554C0C9CE0E2B663E3B40	0105000020BC08000001000000010200000012000000284C39F0CC852541428F1F3BCA23304199D8AC1699892541BA8FF65BC6233041611E57BFAB8A254121E39B6FC12330416515B0E4A18B25419B72FAF2B5233041CA742DC8D58C25419E738C00A8233041BE1BDF0EC98D2541939C789DA0233041F08E5762BE8E254193C04570A123304170FBB02A0E902541E9A13948AB233041256985FA5E912541F19A7C41C22330414703879BE09225413A3C1000E8233041D8792D99C8932541684B7EF2F5233041275FAAD9A29425412B453F9D00243041CDBA94C3C7952541B97FB9B7042430413759AE60909E25417798268F06243041472ED22883A12541C6E9702D07243041A1A79A1088A42541346A5B3410243041E3A71368EBB5254100E4F1EA152430414FC3F7AF1BB62541F205D3FA15243041
303	01010000	1	US   41	41	1	01	Charlotte	1	15.295	25.946	17130.7738	17130.7738280998	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
305	15010101	1	USA  19	19A	7	15	Pinellas	7	0	1.216	1960.4515	1960.45145267139	0105000020E61000000100000001020000002B000000F92AB37B02AA54C0352EBD9C08C73B402848C0C100AA54C09CE5EAD706C73B40A4EE9025FFA954C0D070344204C73B409AE990F1FDA954C0EE56271902C73B40FFFC65C8FCA954C000EAC4C0FEC63B40A4C4C4E3FBA954C0C9E799CDFAC63B402534D2A0FAA954C095947076F4C63B404EABF25EF6A954C0B395D65FDFC63B402E8E88FCF3A954C09C5D4E76D3C63B40D6C12767F2A954C0B84B23EDCCC63B40A6E9AF30F1A954C042BC8E40C9C63B40E78807BDEFA954C01A4E54CDC5C63B407DC43A3BEEA954C0286093A2C3C63B40B131B6BAECA954C0525B3DBFC2C63B40AB109330E9A954C02BB40B81C2C63B40834F9C79B1A954C02A73EF16C4C63B40FF42FD8D9CA954C0C5E4668EC4C63B40F10A2B5C87A954C011D6ACDCC3C63B40B260680D83A954C000565194C6C63B40D07C88D478A954C0BCA313F1C5C63B40F03DDB3D6CA954C031279C1DC6C63B408A3AE3F669A954C071CDB454C6C63B40E45253B067A954C0800BEDF8C6C63B40646DC82C65A954C0A0A15C0DC8C63B40BD28871863A954C0B88C0085C9C63B400F0933B45DA954C09C755B0FCEC63B4000BAD1345AA954C0EC4EB392D0C63B40457CCEF156A954C0434CF701D2C63B401D6AC4AD53A954C0B9AE8860D2C63B4063949E4041A954C0444829B7D2C63B40099366C729A954C03811EC9FD3C63B40D5327C1E26A954C02614B9D6D2C63B40633A6EC623A954C0D2D39D3ED1C63B405C47FAEF21A954C081B4B8C5CEC63B4085A7EADF1BA954C09EE44CB7C4C63B40C48092AC19A954C034657A68C1C63B401607AF7217A954C02D815346BFC63B4066D2291315A954C095BAFEE4BDC63B40A0BDBEEF11A954C0D84865BCBFC63B408CBE0ACDDFA854C003F70F65C1C63B400921F97FDDA854C0DC6D4FE3C0C63B40FCCCE638DBA854C0497C2998C0C63B407F9ABDB2C6A854C0ACE5E314C1C63B40	0105000020BC0800000100000001020000002B000000B3FB3DBAE16CFD4015BADD6FF52733410D7FB4E0006FFD403418C429EB27334193A88554FA70FD4098F38864DC273341E9B6E6BF7372FD40CF75F115D02733412FD11B63DE73FD4017B82837BD273341CDADBABDF374FD40EE4DC60FA72733412A7A7C9A7A76FD402AB4988B832733418A02780CA27BFD40A29E0A670D2733417F1297EC847EFD4096D213ACCA2633418FEE5F427180FD40A6078BFCA5263341BF7E01EBEB81FD40D20917479126334174680757B283FD40E50099BF7D2633416C85A7BE8B85FD40266DED5271263341DA44D6186587FD40DCA150FF6B263341162AEBC9C28BFD40828D5FB569263341929BB42882D0FD40C21088B663263341F2FBA06952EAFD408CE571C16026334129F959E47704FE409162DC49572633417A0DE2B2CB09FE402FA3AF3965263341F4CE539A6716FE400ABC28FB5E263341A5A216E7EF25FE405C1C799D5C263341A4BBD16ABF28FE40CC22F5345D26334193F1E4EF8E2BFE40573E0B2A60263341815F0437AA2EFE409B07A87D65263341B879FCA53C31FE40914429156D263341F2D97813E937FE40B70194D984263341986A07C53C3CFE40202D7DDE91263341849A31B34440FE40DAF28BF798263341C4CF5BA14C44FE40789345279A263341ABF2D9F7085BFE407F078829972633418091761D0078FE40E3B8750296263341BB0CBF21837CFE4065EBD8AE902633411FEFA293657FFE40418A1A38872633414E006F14A781FE40C9CE4E04792633413EFC740E1689FE405BED7A9E3F263341CCE99E2DC98BFE40AE7F3AAF2C263341F44C89C4858EFE408BEB8E422026334163A12DAE7191FE40AC01DCF917263341F76F051C5395FE40FD6C9D5D21263341849CE85330D3FE40FD40EE5C1D263341B8B3E28206D6FE40728CF7F119263341E440498CD5D8FE402B9191B717263341884EB89E28F2FE40D4C89C0515263341
309	10005000	1	US   41	41	7	10	Hillsborough	7	1.331	2.845	2433.9046	2433.90460595197	0105000020E610000001000000010200000011000000DC7773587E9A54C012A9A0885FF93B40D034017F7E9A54C052A9F3D1B0F93B40F9CACDC67E9A54C0B20AEEB0C8F93B4074B866397F9A54C083775223E2F93B401A4737467F9A54C0E9BE56B7F7F93B403C44BA5A7F9A54C079ED7C874EFA3B404F9C2C8F7F9A54C03649BFDC15FB3B4031767D927F9A54C047F8B86B41FB3B40E2418F977F9A54C042470F2A9CFB3B4031BB87A77F9A54C033E5C64CCEFB3B4076D1079A7F9A54C0862F7A9B40FC3B40E0E572997F9A54C08D9BE96200FD3B407FCFB3927F9A54C0F96A26FC21FD3B400DCF81527F9A54C01F9599CE19FE3B40E15845027F9A54C00876A82FF0FE3B407C3DCB0F7F9A54C02F4758E1FBFE3B40CCE4670B7F9A54C046A17A0AFFFE3B40	0105000020BC08000001000000010200000011000000D3C0707483620841782C45EA6E3B34412361127E9562084159FB7EF5313D34412834708D75620841021B0678B63D3441CFBA2F123C620841F3309FC2433E344146C987453F620841EC11007FBB3E34418EA39B435F620841F2362A309D4034414BD80170A5620841C38DFE36EF4434411D10CCC9B96208413758DDE5E045344182B34651E5620841E7755462D8473441373C8942F562084160443092EE483441C00A265738630841B0AE75C8684B3441A5D4474E9B6308417557D6D9904F34411C5752BCB0630841461A7C434B503441A4C0F8B157640841FCEC9E39AA5534415327B357F7640841D4A21E9E4F5A34413A8D3608F56408413A466C83905A3441F61DE85BF9640841EA68D50BA25A3441
318	37070000	1	US  129	129	2	37	Suwannee	2	0	2.755	4433.0318	4433.03177017209	0105000020E610000001000000010200000005000000EE88E8F10BB754C06FB1BA8D95E93D40570B1D1D0CB754C04C258509C0E93D408959364512B754C09296D8A066F33D403FA4D49012B754C0325E1C95D0F33D40D711BF9012B754C0B14D674BD2F33D40	0105000020BC08000001000000010200000005000000DBB4E3D66A4FF040A224889DD9043F4150BDBCB6734FF04097F56A79C5053F41EAE552A8E655F0409FA7CB84583B3F41C50ABAE22356F04091203CB7A43D3F417A7015742656F040D104FA37AE3D3F41
320	14050000	1	US  301	301	7	14	Pasco	7	20.483	22.212	2781.622	2781.62196450451	0105000020E61000000100000001020000000C000000A5927D03E78B54C064FA41E054743C403DA4D9BAE68B54C0820511D858743C409CB37C38E18B54C055B284F4A7743C408C424B21E28B54C001034DF0B1743C40D5820AA7DA8B54C0172B088320753C409391EBACD08B54C0A608B89CBD753C401F6C5898C58B54C09345764459763C40DC64937AC08B54C0FD2EC20D9F763C400A85693ABD8B54C04EC0608EC8763C402A69C9B9B98B54C05C32E648F2763C4013E82D07B38B54C0BAC39D433E773C408448CBDE678B54C00F025FBC807A3C40	0105000020BC0800000100000001020000000C000000CC3C72FDEBC91041FBAF2B4F95E236410B4B091F03CA1041990C5245ABE23641BD7493ADC4CB104123E0002761E436413F4F9E837FCB1041113FC4B898E4364162A9555FE2CD104180722CCAFCE63641E2EB017C13D110410E8FE48762EA36419EB288CE9AD410419E2CB10AC0ED3641F8DA0E713BD61041BBB42E4342EF3641D083FF8643D7104103A01CE927F036411ED4E9695FD810412735E4C30EF1364125DEB4717DDA10416F8C190BB3F236415252B91E3BF2104141978BA0BA043741
323	08070000	1	US   98	98	7	08	Hernando	7	0	7.026	11305.7807	11305.7807165429	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
324	72100000	1	USA  90	90A	2	72	Duval	2	0.992	6.167	8335.2821	8335.28213352094	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
329	87020000	1	US    1	1	6	87	Miami-Dade	6	15.265	20.042	7693.5833	7693.58330074633	0105000020E610000001000000010200000029000000612FBEF42B1654C01C64B6DF8B9D3940CEF2AC7F2B1654C0ABA9954D969D394011B22BC3281654C0CAD805D7DC9D3940DF3D4E39271654C06BDCEE3E019E39401FE4F188261654C00BBA683D0E9E3940CEEDA6BC251654C0AECB3E6D1E9E39401D7C2801241654C05956200A379E394066494757221654C044790D654B9E3940F8F2DFB8201654C099F2DD9E5D9E3940A42B06C41E1654C0D2A6FB48719E3940C3D800231D1654C06C10D7587F9E3940E725D49A011654C08BACBE866C9F3940D4C7A3D0F81554C0AA940255BA9F39405FED8021EF1554C038510AB80BA039406AD89875D41554C0E23FBB12F1A039405529438AD21554C0BBF54E2501A13940D8A4FB95CB1554C0606CAA733EA139405A89BD3C9A1554C0DE2C1E29E7A239405F22B9197E1554C0B4135E5BDAA33940BE8A0F49751554C01D65D57329A439408A4DDC8B6B1554C0EC23501079A43940D8CFE1EB601554C0D38BA5C2D3A43940F12531F8491554C0D7E199629AA5394093C698EA331554C0B2E4EB8658A639400FE83593271554C0BAA0F479C2A63940603749EF0A1554C002B2E7CEB8A7394061FDD732EE1454C02321F290B0A839407F5DE266DA1454C07237C7ED59A9394080A68C28B51454C03D9DBECA9AAA394095BCCFC39F1454C0DF9F688B53AB39400C1FF170891454C05A7F0E0813AC3940FB3592807C1454C0B17F07B182AC39409BEE5937761454C0CFB562CAB8AC39400110A3E86D1454C0AB6D0F4601AD394036F54912691454C0C01F5AAE26AD394037959BBF631454C042A3A70E4EAD39400A66F2615F1454C037E8DF796CAD39405813A0835B1454C09E1CDA8A85AD3940A2573EF4561454C085CB5A79A2AD39402FDB3BB44D1454C0DAE30196DAAD394065285CE0491454C0C6B449BFF0AD3940	0105000020BC080000010000000102000000290000008382DC02D0982A4137119EC137781C412E48E1D5E1982A41B9B6A64A1F791C415C95CA0B4C992A415FD54F1E3D7F1C419A6DE9F087992A41A96B175565821C413D01E8F0A2992A4136BD59DB85831C41ED2BB127C2992A4132117640ED841C41669E177E069A2A411ABDF5EE0F871C41668B894B489A2A417CE7B123D4881C41FD332169889A2A4144E58317698A1C410545BA07D69A2A41D704DD171E8C1C41C1B3D1C8169B2A41CBE652AE568D1C4103FA03345D9F2A41EBDBAC0FEFA11C414A6A027ABAA02A41DB891D8EB0A81C41848D74843BA22A41499DB4D9C1AF1C41A5EE9DA55FA62A411F33FB5AACC31C41E7957AF4ABA62A415CDDBEAA11C51C41FE611B46C0A72A41AC8F186D64CA1C41F260658969AF2A4183B45FB645EF1C41D9BD219FC7B32A412C465BF863041D41B8340BBC25B52A41AB7B4823420B1D413FF466F8A8B62A417AD6311F2C121D41FA3471344FB82A41CFA538610C1A1D4131071521DFBB2A41F71737DB4B2B1D41ED7B35564BBF2A4143BD3DCFCE3B1D41475DAFAF35C12A4142C8552602451D41ADDB5A8DA7C52A419CF17B4F665A1D412D5E671D1DCA2A417061CA2EEA6F1D4186BBD1952FCD2A41353ABF579F7E1D41CB896CF2F6D22A41336FC3807C9A1D41CC3CE9A448D62A4157FD1AC687AA1D41DA520951BFD92A4196EBF3D628BB1D416440902DC1DB2A419DA9B533DBC41D411B1462D3BADC2A416BD228E98DC91D41C3398FB104DE2A41B9582B48D9CF1D417241810AC5DE2A419FD7381D19D31D41AFC0F2CC98DF2A4107E7CFD284D61D4140BF029746E02A41B1835D6E29D91D41B7E57CAFE0E02A41EC77711857DB1D413F00AE5D96E12A41C16857CBDADD1D41C2C2520B07E32A41D9188965BBE21D419A1B37A99FE32A417554239AA8E41D41
334	13030000	1	USB  41	41B	1	13	Manatee	1	0	1.291	2073.223	2073.22296638435	0105000020E610000001000000010200000014000000FF483D17ABA454C0277FEB966F853B40BCAD6065AAA454C0370D343C50873B40249AC58BAAA454C0231A3D0382873B40618B00A3A9A454C0C6B2FE3A8A873B40B423BD78A9A454C0BB3800B508883B4008D7C046A9A454C0CFD9049318883B407812E3C5A8A454C08FE0035B28883B4002F7C8EEA7A454C08D51E1C037883B407B7F85D6A6A454C063AB755D46883B408104D444A5A454C0C883014C55883B4045CED571A3A454C012E3D45763883B4055272003A1A454C0F54DC34F73883B40DF9B0B6E9EA454C090516B7E80883B403225FF829BA454C042EF1CB18D883B4023A4B49498A454C0E5146CC298883B40F8D6A2E194A454C046217DEEA4883B4069DA899591A454C01D20F6C1AD883B40BEDF8FAC8CA454C09B8E1640B9883B409CAF22BC3EA454C0D0F5709B69893B40FA939FA93AA454C02916456173893B40	0105000020BC080000010000000102000000140000007E645524DBDC0141F55B2AB49CBA31410568E7D757DE0141F838954A07C53141A39F8C255CDE0141AE6155821BC63141AF18C7B0F0DE0141CBFD24E048C63141037AEF1152DF01414CD6449006C931413E37B9E979DF0141F200FF8C5EC931417E91D179D2DF0141F29CBBFBB5C93141A27D5B2360E00141792F5B340BCA3141F80AAFA415E101416717D4FF5BCA3141B893016716E20141C27D9773AECA3141118482083FE30141DCC00DEDFBCA3141946E7204C9E40141E4E9C7E953CB3141C3B1432769E60141D7E16D679CCB31419E0750723EE80141E8EFEAE5E4CB3141CC6D098B14EA0141F231A89121CC314117EFDBEA64EC014174B9DC2C64CC3141852C9ABE73EE01415E2E4C5194CC314118E5AA5483F101414D4EC1D9D2CC3141168733BA15220241045804CF91D03141E6283AB89F24024128A22D03C7D03141
335	10250000	1	USB  41	41B	7	10	Hillsborough	7	6.698	6.845	236.4929	236.492942998527	0105000020E61000000100000001020000000500000090050148D39B54C0D54A3AAC19F43B40DE2AD855D39B54C0A2BBD85522F43B4027802F2FD29B54C0BF3841AD2CF43B40AACFA116D39B54C0DCC22A999FF43B400D452403D39B54C0EEB9FDB7A4F43B40	0105000020BC080000010000000102000000050000009F337B8AD68D0741819B38AC7B1E34414E021E88D28D07410054AFBFAB1E344192EA45638D8E0741AAB16ADCE41E34412A5631BE3A8E0741495CC2B362213441A763226A498E074195003E187F213441
336	10080000	1	USB  41	41B	7	10	Hillsborough	7	4.613	5.238	1005.024	1005.02400861373	0105000020E6100000010000000102000000070000008BF0593E7A9C54C066603249B2F43B40FE9BC4F0749C54C00490E9F6B1F43B40127E4E0C6F9C54C0D427E99EB1F43B4047620DB0599C54C0EF01B609B1F43B40ABF5E775089C54C021F43460AEF43B40190B5381DF9B54C0DE9467B8ADF43B4084B061E3D29B54C0B3474D10ADF43B40	0105000020BC0800000100000001020000000700000038497D8453270741CB756234F1213441F9875668972A07418FB7802FEE213441A0000234382E0741C1A0D3E7EA213441F082397C5F3B07412D37DFB2E2213441EDEB4505646D074125B9C50EC12134414EA89F879C860741CCA94DEEB3213441C5DDAD52618E07412FE4065EAD213441
353	36220000	2	US  441	441	5	36	Marion	5	8.571	8.76	304.1787	304.178661856149	0105000020E61000000100000001020000000600000078AB1C91328354C0D9B36F9DE80E3D400FEF07ED328354C0F905880CE90E3D409B55EA083D8354C09A5C7DC9F40E3D400701F4BD468354C0825AF116FD0E3D40AC18D7CE548354C05C47B08C070F3D404288224B648354C03A7F887D120F3D40	0105000020BC08000001000000010200000006000000E0CD9BE020931341C4314520AE3A3A413FFF5AF4049313410886AC98B03A3A41B827C5B8F28F134188EB0C7CF33A3A415BFC7B26FF8C134104B6983D233B3A4126E8C2FFB7881341259508BA5F3B3A418D57903602841341FD824E219F3B3A41
359	48020001	1	US   90	90	3	48	Escambia	3	0	0.045	84	83.9999552467713	0105000020E610000001000000010200000007000000B8096B4493CC55C0F67B98B68C8A3E40E9FB976095CC55C0C340F5839A8A3E407049525796CC55C0654821849F8A3E40ADFE799497CC55C0EE5F1387A28A3E40E893804499CC55C00A604D44A48A3E40C55601CB9BCC55C060CE810CA58A3E40F18B19039ECC55C0053FABC3A58A3E40	0105000020BC080000010000000102000000070000006DDDC0F4F2C733C1A08EB5B4C6A04141980F516017C833C11C71173CEEA04141FB165B6928C833C151D490A9FCA04141F2C5CF5B3FC833C185CB76B305A141418E1EB4575FC833C17D9C0E700BA1414138D58DC38FC833C14C3ADBF40EA14141C834CD4DBAC833C177F58D2012A14141
360	72070001	1	US    1	1	2	72	Duval	2	0	0.114	185.8167	185.816741479444	0105000020E6100000010000000102000000070000001163C9A71B6A54C00EFF0B0983533E40695391AB1B6A54C033411FF47A533E40F208391C216A54C07CF5752740533E407493E083216A54C0C8EA8C283B533E40A6D73771226A54C0F56DBD0432533E408F714637236A54C05001C72026533E407E8A79B2236A54C02E9F054119533E40	0105000020BC08000001000000010200000007000000EF852C802D611B411081963D30A04041226BA1522B611B41EE01F9D019A0404180FFA1B6805F1B413FA7CFF6769F40418BA28EE1605F1B41DDB3E51F699F404185A01D4A185F1B41D2FCADD04F9F40417088ED29DB5E1B41327F65DD2E9F4041BE3C776FB45E1B418BB4422B0B9F4041
375	93100000	1	US   27	27	4	93	Palm Beach	4	0	12.599	20276.5993	20276.5993011641	0105000020E6100000010000000102000000810000007A5E3C6CB43854C014BDAB2557BE3A4098FFAA422A3854C0B913A42462BD3A40B4D4A408093854C0D29D9EF026BD3A40944C74EBF83754C010E9AA570ABD3A40D3279F38F23754C0174800C5FDBC3A404CF93EE5E73754C0F1D5D76FE9BC3A40C8E5C648DA3754C092B858B1CDBC3A400E3C2F838E3654C0157C8BD524BA3A4061171B6A893654C0AFF5F17E1ABA3A4043645A6D863654C04B487C0014BA3A4035EF0A73813654C0B1AE987A08BA3A40CC95F07B7C3654C0B307F15DFCB93A40A095652E753654C0A6839CC2E8B93A40113625EC6E3654C0890C6497D6B93A40C10543A05C3654C003E0A607A1B93A403B72839F523654C021C2369782B93A4013BDA7EB4C3654C0215AD1C26FB93A40AACA5423453654C0CE83CE6252B93A4007DCC661C63554C03553973F4EB73A405C2417C4BE3454C07F039C6B1CB33A401B29FB48B83454C048E4A0BF02B33A408353D372B23454C0076E8641EDB23A4045472131AC3454C02F09D439D8B23A4002F9B5BEA63454C0FFEF903EC7B23A40553B3B23A13454C0A39ABD3DB7B23A4060C0E5F59C3454C066A669C8ABB23A409F62F9E6963454C0940BE2B79CB23A402F3FA641913454C0EFB3BB768FB23A40943265A48B3454C0A31B139A83B23A40749DD3DD853454C00DD6033478B23A4084ADFCD47E3454C07D31104A6BB23A403005A7A2773454C0EEFA57C45FB23A40B6A9A3BA703454C096A6046855B23A407A34ED5E6A3454C020CB7A5E4DB23A40D0FCB576633454C0F79FA41845B23A40449E1DE95B3454C022A22B843DB23A401D577A19553454C041EF1C5537B23A404EC9B1AC4D3454C0527739F531B23A40CAE2F605463454C0BA1081822DB23A4015266B673E3454C0C1D80E1B2AB23A40E628A4A7363454C0E1BA77DC27B23A4005ECEE522E3454C07EC1271F27B23A4020034191AA3354C0DCDD1A2E29B23A4004D0A3B3723354C0A76573002AB23A40ECBF59EE6B3354C05905D8172BB23A409D189F96663354C052E433E92CB23A40CD1EB1C9613354C0584389F62FB23A40DD9001795C3354C0AE55090A34B23A409A7CE3AB573354C0729FDBBB38B23A4076CB8EDE513354C00E1AFE933FB23A40A2565CF40F3354C073B2DD729AB23A40C031355A0A3354C01759BC30A1B23A40EECB6AF3043354C070B8417FA6B23A405B83FBBFFF3254C0CB455978AAB23A40FDE0F51EFA3254C081F2066AADB23A407D6D59FAF43254C08AEBA155AFB23A40407FE360EF3254C048AE25EBAFB23A4069889FB1E53254C04EB744C9B0B23A4069B382E7903254C0095D563EB6B23A403FABFF99313254C0AC9E1809BCB23A407C20BEBE2C3254C05CA49F0BBCB23A40B4690A9A253254C077CF193FBAB23A4084BB4558203254C02793359BB8B23A4018491E771A3254C0880EBD6DB5B23A40C7D2B0CF133254C0F8BF98F9B0B23A406C3F343E0E3254C0986E6552ACB23A400C5EF2C2073254C0630FCD67A5B23A4003A7739D023254C089FC229B9FB23A409868650EFC3154C0AE3E887396B23A4063B8EA42F63154C0850138628DB23A40E15E6702F13154C0E7EEF46B84B23A4031C6A6088A3154C03AC97A35C6B13A409F402ED97C3154C09432087EADB13A40A700A124753154C0511A075B9EB13A40FA858B706C3154C06D8B67D38BB13A40BDBCCDED703054C08CCD42C067AF3A400C9427334E3054C0DA6CC4BE1BAF3A403099C315273054C0F1A5B9CCC6AE3A4003FCB6201D3054C05E0AE0CAB1AE3A4092AD277B153054C0D1E660DBA2AE3A404230483B0F3054C0610B6A0998AE3A40357A6E95073054C003639B418BAE3A4003D44CAD003054C0AF69E20B81AE3A409A011F49F82F54C0A99C3E9875AE3A408E280BECEF2F54C0A9EF5EE36BAE3A40A5D86271E82F54C0E4F3010964AE3A4040F6431BE02F54C0BEB6ADCA5CAE3A4010FC4D0ED72F54C02810620E56AE3A407C397C93CD2F54C0AB3FAF3D50AE3A40CE44A7ECC32F54C088688CDC4BAE3A402BEC8D03BC2F54C07589BC7149AE3A40472718B5A92F54C0104C6E4F45AE3A407A01C80E982F54C0D113FA7C41AE3A408BF6F46F842F54C03EF8F2C03DAE3A401D7085DDFF2E54C0DA3A44FD21AE3A4073D95620F72E54C0A717C3C41FAE3A40BBF23537F02E54C07AA44F5B1DAE3A40366A67C3E72E54C030CFC97E19AE3A40D88FEF56E02E54C0166D323B15AE3A407699FF07D82E54C0F34850A00FAE3A4026300CEACF2E54C06D1CE83E09AE3A402E49CE2FC82E54C0A6D3925E02AE3A406B1BF3BCBE2E54C0086742F5F8AD3A4099B8763BB62E54C0FE9C9524EFAD3A40A6E8ED44AE2E54C0E65A8220E5AD3A40DA18194BA22E54C05C84F053D4AD3A408E394569972E54C0CD2C89E0C2AD3A40C42F571C8D2E54C0490E2A25B1AD3A40BFF050796A2E54C02635825F72AD3A409178BCCC622E54C07725475463AD3A4075177BA35C2E54C00F97368755AD3A40A1EF11E8562E54C039AB310347AD3A40E9DE91A1512E54C07B6D7BB438AD3A4051A71F624D2E54C0F3D9BCD72BAD3A402DCC8364492E54C073D68FAC1EAD3A405C14D549452E54C07DADEF4510AD3A40E92601A4412E54C041F168B202AD3A4017A3C2813E2E54C082EA48A3F5AC3A405D9E6AD83A2E54C07E82D3FBE5AC3A40560B8A5B372E54C05F6F7040D5AC3A401B58DE58342E54C08D092F97C5AC3A40D0E04E68312E54C09DB964FEB4AC3A407A529D942E2E54C007953FE7A3AC3A40B69E28C12B2E54C0B664AC0F91AC3A40F22D22B9272E54C0F443E7FA72AC3A404F31F617072E54C04C85513A7BAB3A409E6F2E0CF72D54C0434E9CEA01AB3A402C2F38CAE52D54C0AF85A2707FAA3A40563E4660D52D54C099B4AA5603AA3A40	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
393	35030000	1	US   19	19	2	35	Madison	2	0	5.794	9329.1008	9329.10075962962	0105000020E61000000100000001020000001F000000536CD345E0EF54C07D0B4431A64D3E402C3D56E0D8F054C0E4D64BD3ED513E40B20CB6C6E7F054C0003345372F523E40749CC4FBEFF054C05BDFF80352523E407A2658CCF8F054C0AF866EEB75523E401101EDE001F154C064307FAF99523E409A15537D0BF154C0B8BC3A0FBD523E4089353EA813F154C04E9E5A32DA523E405F66F8AD1CF154C00D761E62FA523E40999848BE0CF254C0D27028C44B563E40A604AA3C18F254C00F68D6CB75563E4013856ABB20F254C0D087127C96563E401D95D5C828F254C06BDE3A57B7563E4074E6C0B232F254C09CCFDB87E2563E40E5B782515BF254C09E27E02895573E40B03179699AF254C0FD5C0FD6AB583E403EF8507DA4F254C0E3A5F0F2D7583E40238B56B9ABF254C0482EA734F9583E40A6A0DBA2B2F254C060A1F2FD1B593E401467E4F1B8F254C082CD9B403E593E40D8FDAB3BBEF254C0E9A427985D593E40853A6216C3F254C017BC6BDB7C593E40D3465E283BF354C0A552A416AA5C3E402B872B3056F354C0FBD0A249605D3E40671512145BF354C0E3F746A97F5D3E40FCF66A2E5FF354C0A58F0079975D3E406E035F0164F354C062102D3AB25D3E40144DE29C69F354C04EB2BA57CF5D3E4059ED91D26FF354C09C81D0C0EC5D3E403A080AD38FF354C0A96993DF7D5E3E4064409CB29BF354C0235C8F52B45E3E40	0105000020BC0800000100000001020000001F00000060E2BDA21BC809C10875BE4941A340410BD5B98232590AC1F0ACDD415DAF40415566A784E4610AC10A99714C16B04041876E07F6AF660AC13EB005D778B0404140393DD6D76B0AC117434197DEB0404134287DCB28710AC17369510544B140415AFCDDF0CB760AC1344BDF7CA8B140412660855B977B0AC1751F0E4DFBB140415E41C734E3800AC14DEA11C856B240411994A090D10D0BC15BEF4087C5BB4041D3259E2C8F140BC1BC1A47EF3CBC4041EA6A06CF88190BC1D04A82B299BC40415FEC02043E1E0BC12EB533D2F6BC404159793FCD06240BC189206B1371BD40417F700712B83B0BC1B4D5B99F6ABF4041B817D9F582600BC1E53DA6467FC24041D90E1FBB63660BC15E586E23FCC24041842EC2399A6A0BC166C4C22F5AC340419DAA995E9D6E0BC192E3BF67BCC3404199609B1444720BC12A305A051DC44041B07129B550750BC1C03EC14A75C440414AEDBA8D1A780BC1CF94863DCDC4404101F7B3EAE4BC0BC186E58598BBCD4041B64B0BAE61CC0BC1796AE3E1BBCF40410C410CB030CF0BC1C42CD42614D040410CA6F7B08ED10BC1B185FE3C57D040414CDF419058D40BC1DE1306ABA2D0404124A2478B98D70BC1C30DDED6F4D04041E8D9DBFB34DB0BC1924D38F947D1404181B3A70CD8ED0BC10C11BB82E2D240411A46137CC1F40BC1892F99837CD34041
402	34050000	2	US   98	98	2	34	Levy	2	36.443	36.547	167.2943	167.294349741326	0105000020E6100000010000000102000000090000005F70F11504B754C0239D10F3757C3D4034244B1804B754C00D869118797C3D4094E5592204B754C0D2A208637F7C3D403461AA4B04B754C0E71F89978A7C3D40F3E8A5EF04B754C00FA7510B9B7C3D40EB4873CA05B754C082DB25A0A97C3D40F5385D5407B754C0CE29ECB4BB7C3D40927E967309B754C057D639EFCD7C3D40BE6CCB640AB754C0EA81B075D57C3D40	0105000020BC08000001000000010200000009000000933513420F7AEF408BFE09612AA73C419DD6777B127AEF40E9617AD83BA73C4139A31BEB0B7AEF400A0603C65EA73C412FEE8569C779EF4039F59B039DA73C418EC7FEF66778EF408F17C686F8A73C41BF4FB71B7E76EF40E4F4A9B849A83C4149AF2E06F572EF40E9AB9A8DAEA83C41B75AE7D7016EEF4043FE336114A93C414ABA5E91CD6BEF40F4495D703EA93C41
403	87030000	1	US    1	1	6	87	Miami-Dade	6	10.556	10.834	447.4445	447.444465372667	0105000020E61000000100000001020000000A000000677C79A5270C54C03101B1665AC53940F42ACACF260C54C01B18BDB45AC53940843224F6FF0B54C0DCBD264D5DC539407270268AFD0B54C0D7B237655FC53940ED5E8D1EFC0B54C0D1CA69C062C53940134D8726FB0B54C0834E9E0269C53940202E9DEDFA0B54C00BE3D6EB72C53940195EDC5FFC0B54C04754FC69AAC5394033B57B68FA0B54C0AE111B5AC9C539408AF44C58FA0B54C0BADDB191CAC53940	0105000020BC0800000100000001020000000A000000E1359A5A0A292C41387C07EBBDEF1F4171BED9DD2B292C41A5D3FF17C5EF1F419E2CC074442F2C41742C8CE311F01F419EE6989BA52F2C41EAE4F68A41F01F418C60FD6FDE2F2C41947AC3B38CF01F41B0A076EE04302C4119086C0618F11F413A35592F0D302C41D75C0301F4F11F4130823649CF2F2C413EC6755AC2F61F41230AC3291C302C413B3F02AA71F91F41E17F8D9E1E302C4115B967B28CF91F41
407	38020000	2	US   27	27	2	38	Taylor	2	3.823	17.387	21832.0958	21832.0957983321	0105000020E610000001000000010200000010000000BF43E5EE21E754C06B907A2177253E40946653A00AE854C0C949C095272A3E40C8EA9D8CF5E854C0364BB631E22E3E408D32ABFC2AE954C01B06EBA6F52F3E40AD421F5739E954C0AC7FD02C3F303E406F7253EC45E954C01A0B71B37A303E402CCD605351E954C061ED0F80AD303E40C1E736BAD1E954C020FA7E9BE5323E40BD29DF50ECE954C005A29B555B333E403EF7AF8E37EB54C0EBF38EB715393E40A7619883D7EC54C0423BF28840403E4049DD305965EE54C04D261E201D473E404A5001F024EF54C05CAB8BF86B4A3E4025FEBD15CCEF54C0C1B7864B4D4D3E40FC285286DDEF54C0A894DCFA994D3E40E433CA45E0EF54C0B2351A31A64D3E40	0105000020BC08000001000000010200000010000000C9605D7A19AD04C137015928B6314041A49F6DC3A73405C19D8FAC4AEE3E404188FAA1FE75BD05C1A3950871434C4041B626766B92DC05C11843C5194C4F4041C207C803EEE405C1546F6A6C1B5040411212B0BA46EC05C104F6407EC350404130D0423EF2F205C1384AC012535140410D8E4E50103E06C11AAB4B089957404176C535CD9D4D06C13D7A79D6E5584041EC48F8DF520F07C18A92D58D176940418750C797770208C16EC509275C7D4041106BC58FDFEA08C1E766D666C4904041EFF1E069BE5A09C163AF88DC1F9A4041E60CF2C852BC09C1C69168C645A2404196E8971781C609C148D4D6BD1EA3404111565D9D1BC809C1EA28484941A34041
410	13040001	1	US   41	41	1	13	Manatee	1	0	0.158	256.251	256.250981602209	0105000020E61000000100000001020000000C0000006AAF3DC11CA454C025D4EEBD60763B407923C6CC19A454C054DBC56C64763B408BFD99EC16A454C00011BB4469763B40D53D2B4D14A454C06EBA9FDD6E763B40F9A1507D11A454C018CFC59276763B4005A9589D0EA454C02401CB1E80763B40F97C70E20BA454C022EB26578B763B40DD6717C509A454C0A3B5725E98763B40D565513908A454C096FE579BA4763B4000C83DC306A454C032AB0BAAB4763B404A87172B06A454C081358F63C2763B408FF202EB05A454C07D72FCBDD3763B40	0105000020BC0800000100000001020000000C000000779F935E702C02414CF44B65ED6631411D8E2F69462E0241E663CE1701673141C4FD9E8B10300241AAD7DF3F1B673141AE5EB60CB33102413C318CA63967314150DB16B0743302410119A2B663673141F7EB675241350241C5EB39F7976731416EC72BF6F736024170539889D5673141C1075C234E3802410D12B74B1D683141B82969D049390241896925CF606831418A013E333A3A0241A5F91489B9683141518099FD9F3A02416D88F78805693141D6583053D13A0241B5329DC065693141
414	46010001	1	US   98	98	3	46	Bay	3	0	0.44	685.2376	685.237629770028	0105000020E61000000100000001020000000F000000F2D4D75DBC7E55C0D62831D8DB443E40123AAE85A87E55C0A827F71F6E443E406B5EAAEEA77E55C0935F8CF76A443E4070599F579F7E55C0DDD1533C40443E401137745D9A7E55C095C9EBED2C443E4035C28A4E967E55C0F9DF75D51E443E40B3319022917E55C099584CFF0E443E409B43FE098C7E55C066B424CE00443E400C066DA3857E55C03353EF6DF2433E4079949E48807E55C0B17A5EB7E7433E4015EF76BA7B7E55C0D1B68A00E0433E407B23DA02777E55C0618E29B6D8433E40B9178604737E55C070C85730D3433E40F3C2A1E16D7E55C009E00E69CD433E40FE0BC2596B7E55C02B813819CB433E40	0105000020BC0800000100000001020000000F0000004DA8A77CE1FB2BC158C53FACC5B9404142A045ED18F92BC116BC59418CB840419E6DA4B103F92BC1DB8A0E3A83B840417EE61FEACCF72BC1AB0F90CC08B840415177BB2D16F72BC1D1F86705D1B74041B94FB76080F62BC16100281EA8B7404124341D6FC0F52BC174A128E779B740414FCF1B9D02F52BC12715C44A50B740413CD4B38212F42BC189DD1C9E25B740416FA54F0049F32BC1A87D759105B7404109016CE49CF22BC163CCBC31EEB64041C6D6E352EAF12BC13B76F4EDD7B64041685705D652F12BC14E25BBE2C6B64041233087598FF02BC118B7A3A5B4B64041AA97B4C42EF02BC1CCA90926ADB64041
416	38501000	1	US  221	221	2	38	Taylor	2	0	1.346	2177.1724	2177.17244046443	0105000020E610000001000000010200000004000000E873672D23E754C007BACB9274253E406ABC290D16E754C07CA9F1C574253E40EA30F05092E654C0D36CAFC276253E405DA2361AB1E554C0B4197F1E83253E40	0105000020BC080000010000000102000000040000005576EB31DCAD04C1C1A95155AF3140415FBF2731F1A504C1640E97FCAC3140412BADABBD795604C135FE696F953140415832F6D795CE03C1AFBFA94186314041
417	10030000	1	US   41	41	7	10	Hillsborough	7	0	2.267	3646.1893	3646.18925560092	0105000020E61000000100000001020000000C000000066C2580DF9C54C091391009FCFE3B40C1FC1676599C54C0AB942BB9FBFE3B40CFFD34D1199C54C0D8CDEABAFBFE3B40AB4088FFD29B54C09A788BC6FBFE3B402322FDBDBD9B54C0D4EFCC75FBFE3B40A0D5D0A17A9B54C08EDB8DBEFBFE3B404242F0274B9B54C06FE96808FCFE3B40F9D89DCD109B54C001D8E20FFCFE3B403BD63DA0089B54C042E1AD21FCFE3B40A562133EA69A54C0A53AC816FCFE3B40E12D14D8819A54C0EAC237E5FBFE3B40ACAD9416809A54C0F7DEC4E2FBFE3B40	0105000020BC0800000100000001020000000C000000E39591FF64EE0641565F99141E5B3441E7AFB117E94007411703AA09FD5A34413234BE3A176807411DE04545EE5A344194B07A21B093074189C77118DE5A3441A05865DAC5A0074164AEB16CD75A34415650945616CA074176818C7EC95A3441301BCD9050E7074199C0CE26C05A3441C44B20CA3C0B08419D3BBBE4B25A3441D03B0E8845100841C48EB366B15A3441A2539264D64C084100A0589F9A5A34416DF4C68C3E6308410DA6813B915A3441C3FEB842536408414F3C4FC7905A3441
418	92010000	2	US   92	92	5	92	Osceola	5	0	0.536	862.8957	862.895659197291	0105000020E6100000010000000102000000030000007AFAE96B4B6354C03195489DB63F3C40FA54DCD8FC6254C0AC21248461413C400EEA5AB7FC6254C061D8BD3C62413C40	0105000020BC08000001000000010200000003000000961101B76C361D41D2F470A2E8B83541DC36A19BB74E1D4176F2590022C23541431493F7C14E1D41A8A181FD25C23541
422	08010000	1	US   41	41	7	08	Hernando	7	9.31	10.092	1260.4203	1260.42025978254	0105000020E61000000100000001020000000B0000000E5FA4F2359954C0F479FD9D008E3C401C19F87A329954C025186F1F048E3C40AE9F2EED2E9954C0EB9C844C078E3C40430F55262B9954C0D1B24E8D098E3C40E06D86AA269954C049B7C0FA0A8E3C407CCC3B451A9954C0ADCF9E4E0B8E3C40818E00BE0F9954C091A82F970B8E3C402ED68076F69854C03C8DA08E0B8E3C4029460799D29854C077C69E3B0D8E3C4084531F85699854C0D3AEECFD0F8E3C4003162735639854C006EAA0C8108E3C40	0105000020BC0800000100000001020000000B000000EBEFA173BD780941A6F21A67D3733741F9FE7FDFDE7A0941B4B58910E67337414AFC98AA0D7D0941A578DDE0F6733741F58E9AED5E7F09411D7D1185027437414343E9941E820941C40F616B09743741E44CCA12B6890941D0AE1D6A08743741FA6C2FC728900941CF91509707743741C9C01FE7A39F09418A4E04A8017437410356D17D9BB50941508B16CF027437419332A45CF6F5094109E58E53FA73374199560A62D4F909415D48554BFD733741
423	55003000	1	US  319	319	3	55	Leon	3	11.14	11.44	482.7248	482.724835080278	0105000020E61000000100000001020000000C00000086CFDECDE20F55C0EED51D91A4803E40486A58CDE50F55C07966212DC6803E40B552B0F7E80F55C0B629E20CE8803E4067704793EB0F55C071C77DA20A813E40071DE637F10F55C0F3B5BC1947813E408DBCCBBCF20F55C03B52BAD556813E408DF029B8F80F55C010E57BB891813E400447B678F90F55C0E6F8A85F9A813E401D05DAFCF90F55C009601889A3813E401A3B3F3BFA0F55C013AB4933AB813E40A9242C4BFA0F55C0EFBDF9ACB2813E40E380C835FA0F55C01D63E425B5813E40	0105000020BC0800000100000001020000000C000000CA45A828576716C15F48C44403394141427D5F55286816C1C4B0556E613941419D589C38066916C1DD59E85FC0394141342361BEB86916C19CB9F022213A41410A10263F446B16C17BD76A9CCA3A4141DE305310AF6B16C1A8D0BDB9F63A4141E09FE8A3556D16C1114218E89B3B414162F315F9896D16C16BD6E824B43B41416D3AB4D2AB6D16C13AC8B3BACD3B4141448941ABB96D16C1C524EA14E33B4141B87D41ABB96D16C139A08CDBF73B4141673535A8B16D16C1B9F132B3FE3B4141
424	72090448	1	USA   1	1A	2	72	Duval	2	0	0.235	375.6277	375.627732444879	0105000020E61000000100000001020000000C00000032BF7EAF496754C0C5D83AA8B44D3E40301F69E53D6754C0FEE7522F8B4D3E40BFF5C2733A6754C0D4232E3D7E4D3E408B6EBFD3376754C05D26D089704D3E407F3B0477356754C0B8D6759D604D3E403379D4F7336754C0090ADC98524D3E40C63174EF326754C0F6ECAB03454D3E4005571F55326754C042FECF22334D3E4035872018326754C0FD691F47264D3E408C6D4274326754C0F031D430174D3E406DAE206B336754C042963C77064D3E403CAB3337356754C05370C3A7F34C3E40	0105000020BC0800000100000001020000000C0000002D376AD4B6391C413E239AECEC8F40410C91532D3E3D1C4188CD1F3C798F40416B76A6F7453E1C41B5644F22558F4041123E7F930E3F1C41FEE241FB2E8F404111A98BABC23F1C4187A3E8AC028F4041693CF85034401C41AA8F79B3DB8E404133C5E74182401C41144F5CF5B58E4041DFACAC90AE401C41BE95A251848E4041FB1F1862BF401C41792DCDA0608E4041B51C25D9A1401C415F46A1C8368E4041B8CAF68B55401C41A5EC0A6D088E404190E9B9D3C83F1C4183D72353D48D4041
425	15090101	1	US   92	92	7	15	Pinellas	7	0	0.279	451.945	451.944973763908	0105000020E610000001000000010200000003000000E7FE4DB2DDA854C0D0570A420EC73B400921F97FDDA854C0DC6D4FE3C0C63B40EEBF2325DDA854C0D7B350F702C63B40	0105000020BC0800000100000001020000000300000054FF08FB23D6FE4089EA6C4AC7273341B8B3E28206D6FE40728CF7F119263341EB3FCBD395D5FE4020783D0EFC213341
427	36030000	1	US   27	27	5	36	Marion	5	0	1.23	1978.0765	1978.07650618148	0105000020E61000000100000001020000001E000000BD6F6C1CFD8854C03D0A74A1E22D3D4094B80775FC8854C044FCE2947D2F3D40B58C674DFC8854C0E511493CB02F3D406138424CFC8854C0B528FE06E22F3D40DF9B1D48FC8854C095A93006EA2F3D4089B08D14FC8854C0AD002E434E303D4063EFD017FC8854C029478F4F51303D4091E8C117FB8854C00439269153303D405C36FD19FB8854C08445670166303D40CAAE2748FB8854C0A8D7DB9978303D405F2FEFC3FB8854C0C5B346F38E303D401C9B9F7BFC8854C0DA9904EFA4303D40B5C5008BFD8854C0C48D6D3EBC303D405BD7C5C9FE8854C0B1623E8AD1303D40CDC20E3E008954C0F2DAC4DCE5303D40CE794CFB028954C08C93E1F40B313D4069A21041058954C00CC3F7A327313D407FCD11380A8954C034F9C9C867313D4043388E0B0D8954C08111F32C91313D405900E0490E8954C03C4A72CDA5313D403F759FC80F8954C0B3FEE42FC1313D407ECF2EA7108954C08AE356C5D0313D40E289A388118954C004308D71E4313D402837ED65128954C006F7D0E6F9313D409E25A241138954C09AB07DC914323D40122909E4138954C05EEF1F4B2B323D40B4D5E308148954C0BCF31A6932323D40D272FE67148954C0AC7239C744323D4023ED1EB0148954C08BEBC66356323D408FE924BF148954C0782B541769323D40	0105000020BC0800000100000001020000001E000000983273340AD611416D5A10F49DE73A41220D1BB095D611419A1AD33386F03A41ABDF5DA9ACD61141DFF8A7409FF13A41B07E24BDB7D61141FA8A268CB3F23A4172CB08B9BAD6114197874DEBDFF23A4115477F03E0D61141F98BE01A0CF53A412B7276ADDFD611415589D6051DF53A411A4A0C172ED7114121A47A5A29F53A4168B2406231D71141C659AFAB8FF53A41CD1B4D5727D711412BC746E4F6F53A41C2DAC27C06D71141465DF1FF72F63A419411B052D3D611418DD2211FEDF63A41296F34C285D6114198B4BBAB6EF73A41D9F1BA5629D611417E344214E5F73A416C90826CBCD51141F0ED971F56F83A41A8786F3BEFD41141DA9DEB062AF93A41AEBF332844D4114155F56113C4F93A4144BFCB32CFD21141D0C266F328FB3A4170E419F5FBD111414A88AE2A0FFC3A411367A0899FD1114198138BDC81FC3A41DCA04AF830D111410F78261A1AFD3A417B64AD9AF0D011412BBAD0BD70FD3A41A630663DB0D0114137019212DEFD3A413465928771D011415CB3BC4E55FE3A4154F6DB7834D01141AB3F7BA8EAFE3A4170658EE807D011417777B1AA67FF3A410E5FB23AFECF1141F222E42F8FFF3A41EBD69640E5CF11413A55162EF5FF3A41B189BA1AD3CF114129F9D3F556003B41DD729C91D2CF11412637EEBEBE003B41
428	16020102	1	US   17	17	1	16	Polk	1	0	0.816	1308.7876	1308.78763981714	0105000020E61000000100000001020000001C000000B494FAC39B6E54C031F377A84C183C405B391FCCA46E54C09D6E38F53D183C4064DED1A4AD6E54C075C6D2C32F183C4033BEBCDEB16E54C011C850B326183C40C0BA0F5AB56E54C0ED3A40631D183C40DC65D903B86E54C0415D791714183C402D4C57D2BA6E54C015E952A007183C4009FFF1FEBD6E54C01E412E83F8173C40A322302DC16E54C00AF60E18E2173C40F2128D37C36E54C037E5E9B5D3173C4085BE04D5C56E54C0DE29B083B9173C405D6F248BC76E54C01D37C34AA3173C40A4FE06FEC86E54C088453B648E173C4019046263C96E54C0081E447083173C40C77AF5A0C96E54C06E965D2773173C40B638A1DCC96E54C00F32C4AE5E173C401BF84F96C96E54C0F9EAF7F448173C401620FB0CC96E54C02BD9DA312D173C40538A3A80C76E54C0DA66C9F9DC163C40D041F65AC66E54C046733E908D163C4083FCA874C46E54C0025460B514163C4087669CAFC36E54C0FD5C8E3705163C4043DA2097C26E54C0D26EB95DF6153C40148106CFC06E54C0D4CF585EE6153C40CBA45C0EBC6E54C050DA6266C6153C40433BFE5CBA6E54C06E838E15B6153C403B0BE15AB96E54C02ED4182DA6153C407ED2AAD3B86E54C028420FD898153C40	0105000020BC0800000100000001020000001C0000003523747EE0B71941A78373DD6BDF34419F9B2E9717B51941781D33601BDF3441E9A225575DB21941BD03F1ADCDDE3441E53799750FB11941C353E7E39BDE3441FEF33D26FCAF19413330CFA268DE34412AA24D4529AF19417F75CA6035DE3441A10BF0AE4AAE1941E8B6CA8DF0DD34415EB4CBCD4EAD1941F28090149DDD344132973C7251AC1941EBC84B1521DD344165F17AE8AEAB1941E96B3E87D1DC344149DFBC8FDDAA194123EC9C8140DC344125922BE153AA19418F336B6CC5DB3441FD796F0CDFA919418120A0A451DB34418A3F096CBEA91941CC9FC9EC14DB344182610151A9A919415A58DE9BBADA3441E040083D94A91941E385291149DA3441DABAC3F6A6A91941ED722481D0D93441BBEACE7DCDA91941B02C1C6C36D93441203F5ACC3CAA1941342A5D3379D73441AA53BD648CAA1941AA5EA380C0D53441797B1DD411AB194142C8D2CC21D334419E98E35B4CAB194190DF00C4CBD234411E4CB3A1A0AB1941F5B8193F79D234410354DCC12AAC1941717EEC4820D2344144A183A39CAD1941E6B7555E6ED134410123ACBB1FAE19417B71FFA613D13441F9AE2DFD6CAE194162A56147BBD03441F75B38CB94AE1941B8E09C4071D03441
433	13130403	1	US   41	41	1	13	Manatee	1	0	0.403	653.3907	653.390687535605	0105000020E61000000100000001020000000D00000014B2FECA07A454C00CD207928D7C3B409589557C09A454C0401E4F10347C3B40621892F90AA454C00E96A6A5247C3B408A96EBB20BA454C0ACD296C0087C3B4012C2B8470EA454C0AADE6A1AAE7B3B40D110A4770EA454C0BA119E3C9C7B3B4019EEAE2C0EA454C03B01A9288D7B3B40717BE5510DA454C04E8D09147D7B3B4028DCB5730AA454C0D6DE5D5C597B3B406A5A196B09A454C027032E11497B3B405C41D0AB08A454C074DEF6D4347B3B403706406208A454C04C99BCB01F7B3B40AE449B2E06A454C00F7D1A26117B3B40	0105000020BC0800000100000001020000000D000000669A7B72DB3C0241194366FC2A89314109E09B639D3B0241493E6BCD3A8731416F2F5DF8A83A0241E62B6AA3E58631415012FFBB263A024183253F0D4B8631415EFD41565B380241F71A6CC05484314110E595B533380241344DCDABF1833141695CB9A45938024181E11FF19D833141D8E1F4FAD738024148CB8C824483314128B406228A3A024103B337A07D82314136087BB2243B024118E87FF722823141F44263B48F3B0241B690B982B28131419D31FF63B13B0241274408243D813141FB865FE6053D02414DF77CE9EB803141
438	08030000	1	US  301	301	7	08	Hernando	7	0	6.667	10738.3645	10738.3645417484	0105000020E6100000010000000102000000170000008448CBDE678B54C00F025FBC807A3C40350B41D94C8B54C0E165034FAD7B3C40066EB53E478B54C080153213F17B3C4039E476AE408B54C045EACA0D497C3C40BF245FB23C8B54C01191954D847C3C4020F2490E108B54C04D3BEEB6627F3C40976DAA5C088B54C056D0A042E17F3C40BD1F62B2E98A54C0449C4BF1DB813C404319522BE78A54C051F5AD3A03823C408196F578DB8A54C08D34C411C7823C40422B55C4C68A54C0957E190D1A843C406CCE5460BD8A54C01FE14332B1843C40EAF76630B68A54C025C293462B853C409EEC5DB4978A54C093CD1F5C21873C408FCE930D728A54C075526D1C8D893C409A1B0D544D8A54C054CE8D18EC8B3C4003484ABF178A54C066EFC30D5D8F3C403B0357DF0B8A54C0A9A1332E24903C402A20AE3E098A54C0AB6F03B256903C40FB79C874078A54C067EF6A2F7D903C40B8A5CC21048A54C05ECC9040CC903C4082228AB6018A54C0803CEDC905913C408A239674EF8954C0427E923AC0923C40	0105000020BC080000010000000102000000170000005252B91E3BF2104141978BA0BA043741F91D4208C4FA1041B6E58929390B3741E7C1474B8AFC1041D4FE7616B00C37412309D437A0FE10414C088FFA960E3741B02360A1E5FF10410B924BF5DE0F374185C4C531320E1141F1D43449C11F374161FACC03A910114133B9DDF37D22374144865A8F7B1A1141D53D186B732D3741A87599454A1B11412DD3EDEA4C2E374148F484DD091F1141A91DF24D89323741F1219CC2AA25114185044D32DE3937419B5C37BFAB281141C7264C09233D374145053DA9F92A1141F3E26306C73F37413501B22EBC34114151F7450AA34A3741F5328797C940114163C7E1940A5837416DE30C1E8B4C114131A1F27A2B6537418293382AB05D11413396FF5939783741FEB6F8937D611141B6428BF7877C3741A180315856621141F884FDC09F7D3741460ADDC7EA621141B1E767FA747E37411E02114100641141CDDE540E2B80374166FDF72ACA6411417E25B9D7698137419263C4CCBF6A1141E4394F4AFD8A3741
440	87120001	1	US   41	41	6	87	Miami-Dade	6	0	2.998	4832.3994	4832.39944435399	0105000020E61000000100000001020000001B00000043A282A0300C54C0D580F7FC5EC439403AD9B4E0310C54C05306B31160C43940592BF791490C54C0AFB6C38B74C439403C8E21394C0C54C09F12CCC975C43940647FE6FD4F0C54C02BBFAB6D75C43940CC2871D85F0C54C0AC0367F372C439406DA4D6ED7D0C54C094373C3E6FC4394071FB834AA30C54C05078712B6BC43940AEE5747CBE0C54C014547B1168C43940AF0892B5D00C54C0224E4BFD65C43940B6A87ECCD10C54C0526A24DF65C4394069DEFEE1D30C54C03B5DECA065C43940A1D1F02DD40C54C07D88469865C43940809B83A3D90C54C0A7A8016665C43940A22EB938470D54C034128EAB57C43940913CCADAB90D54C0DD7B104E49C4394059E7DBD93B0E54C02F43366D39C43940C586B2353E0E54C0BDA47C4139C43940D254D31C410E54C079C2279539C4394001106021440E54C092199AA33AC43940BB1E15D1480E54C0612BEB083BC43940CFC9F597810E54C09A25BA7C34C439402ADEFBA7C20E54C0CEC713652EC439402ED5DA01C50E54C00CFF401D2EC43940959656922E0F54C06D07BB8521C4394031BD76583A0F54C0D27DA062EEC3394029FB633E3D0F54C0C83E641FE4C33940	0105000020BC0800000100000001020000001B000000D5C6A9B2B2272C41202B6813F0D91F41A90AD85F80272C4136507B7007DA1F41664B0122C7232C416D4A2205C2DB1F41CAC9CD765C232C41353EE745DCDB1F4109D25215C5222C4167ED0A6FD2DB1F415346E95348202C41344E19AB93DB1F41F00781F78F1B2C41BA1656A332DB1F415C189C37B3152C41E82C49F7C5DA1F4163570BDC6E112C41F8FF03DF73DA1F4152BD25E2920E2C4141E295DC3CDA1F41E622581E670E2C41E957B1B739DA1F41083B0B69130E2C41DB20534F33DA1F41787E847E070E2C41C0A6756A32DA1F41BCA1252E2C0D2C41796227662BDA1F41A28C9F96FAFB2B418F8ADAACC5D81F419F5E3722FEE92B41FB11F7D94FD71F419B83A88A98D52B41C4E487A9B1D51F413BC326CA39D52B414A0D4BC1ACD51F4196754E25C5D42B41CB2A37A1B2D51F41C7B93AD64BD42B419EA8CAA2C8D51F4153C70E898FD32B41C9B72432CFD51F4128D6E4EFA6CA2B41D536231D23D51F419EA1DD6C71C02B4129B6015D7DD41F41EF2A2FFD12C02B41F560630976D41F412C028DB882AF2B41AD0A1A662DD31F41FCDCBBFAACAD2B41DD1C037FB9CE1F41A658DD3339AD2B41AB9C927BD4CD1F41
443	48020000	2	US   98	98	3	48	Escambia	3	13.473	15.535	3336.0807	3336.08074533521	0105000020E610000001000000010200000021000000274A79D06DCF55C01AE0D780B16B3E40822B721F3ACF55C08BC6D855A86B3E40DB504BC9B9CE55C09C8C2F8D916B3E409229B802AFCE55C093D211948F6B3E409BA6C5D3A9CE55C0A0E8218A8F6B3E40A6545F32A5CE55C06E8F8FFA8E6B3E40FA6B637F9ECE55C05F8B5F828D6B3E406BAC751F85CE55C0F4807AA4876B3E40C19D49117ACE55C015357190856B3E40D4FBAD0770CE55C01F07136B846B3E40BFED55E76ACE55C0CF8B253A856B3E4046D7396E67CE55C04DDE4AE1866B3E40B603BEA05FCE55C0C4C80E888B6B3E40995B2F1C3CCE55C00BD46AD0A36B3E40940A883716CE55C02DCEC0CBBD6B3E40120757B500CE55C06E6BCF60CC6B3E40669DD789F8CD55C0890DB0F2D16B3E40C57D8CF9E8CD55C09ADE698FDA6B3E404AAC8899D1CD55C04589FDACE86B3E408F1856F1BDCD55C09F05943EF66B3E4069E89A66B9CD55C0424EC010FA6B3E40C71842A4B6CD55C0C60B270AFC6B3E40BB5CE658B2CD55C0A590448BFF6B3E40A1538614A7CD55C0EF57C539076C3E400C85D19BA4CD55C0DDE1082C096C3E406A159F5192CD55C031F8C7DA156C3E401CFF1AE97ECD55C05B92F445226C3E4073D448955CCD55C03DD1895D376C3E40358B1A9A56CD55C0343045573C6C3E403319A7434FCD55C05E4F1BEF436C3E4095D1A17746CD55C039C8EE5C4B6C3E40ECAACF2341CD55C04F74277F4F6C3E4086F71B5D3DCD55C0D90A7210526C3E40	0105000020BC08000001000000010200000021000000FE721DFA760834C1D8FBEA826E4C4141DCCCB479940434C1C3724364394C414164D90265EFFA33C152AF5F82B54B414135CA361920FA33C11D72CE45AA4B41410220851ABCF933C16A08A666A74B4141C7A1EAEF62F933C16DFE1D5FA34B41416F8D3623E2F833C1DFE2F7B59B4B4141D0958A5EFAF633C189BCF0DB7D4B41412744A3B525F633C1E73B152F724B4141B8C59A6664F533C17A5365A5694B41416026FF3E01F533C1C2E9592A694B4141D3CCB9BABDF433C1A3C620EA6B4B41414D13EEC125F433C1500A80B3744B414116AA6A0771F133C17F44B55AA54B4141D805B8F48DEE33C176093D7AD94B414188462781EAEC33C16CC5419BF64B4141204F542B4BEC33C18214E5C1014C414193C535401CEB33C1B13EA770114C4141C9E2D3EF54E933C11EF23B482C4C414157F49D86D5E733C128B94595474C4141B68AB1B97CE733C15911CACC4F4C4141A823F5E246E733C106F37AD3534C4141621E9EF5F2E633C139222F4B5B4C41419098B43917E633C118FE66AD6A4C41419F91FBF1E6E533C1269D75C76E4C4141B89D203082E433C1C2238158884C41412A1183EF07E333C1EC11BD95A04C4141D01C34316BE033C1867A6908C94C41417F45DE45F6DF33C18D5B2AB3D34C4141970D586166DF33C1723827EEE44C4141F6D79B62BADE33C1BA3ED2EDF44C4141794B605652DE33C16689F499FD4C41414DC094B208DE33C162DA6CBD024D4141
444	72070008	1	US    1	1	2	72	Duval	2	0	0.08	128.3252	128.32522425574	0105000020E610000001000000010200000005000000CBEEB9A3306A54C04324A298F4503E4043E6BCE7306A54C0A18E910ACB503E40F4F01E0A316A54C0E500ADCEB9503E4035144514316A54C0F0CE9D10B1503E401A5C500F316A54C085BDA8B9A8503E40	0105000020BC08000001000000010200000005000000B38562BF885A1B414454287C19994041500E83EC6E5A1B413EAAA231A69840416B50F55A625A1B41822083617698404121A3912C5E5A1B41874EF31F5E984041239C1A975E5A1B41713AA1FB46984041
445	86010000	1	US    1	1	4	86	Broward	4	0	2.465	3960.5908	3960.59080363768	0105000020E610000001000000010200000017000000139D2254190954C09EB50D847DF93940084D9BD9180954C05FA8D28E86F939401CB22C99170954C095703F4CA6F9394082787FEE160954C04EE9DF13BAF939403AEF9A50160954C0C8AF478DD7F93940BFE88C17160954C09AD8DA16EFF939400DCC8107160954C0BA53DE2905FA3940DD5EE681180954C09D4285AE54FB3940087B6350190954C025B01B87BAFB3940B083ABE0190954C00C376539D3FB3940047531C91A0954C02AD40DA5F4FB394041307B381B0954C0B0C4CED509FC39403BD7C0691B0954C01D5383011CFC39401B6A10E71B0954C06FD2E79A4FFC3940F37C65FD1B0954C01FD2C79757FC394032808F3C1D0954C04AA5685215FD3940F6A613F81D0954C0D858F8271CFD39406DD9B856210954C0B118D5A7AFFE394075E5F3C9210954C0C794159329FF39407C2CDAD5220954C08489EDF313003A402B249E58240954C026089D4710013A4071B385EB260954C04BD0421D9F023A40E71A6A1B260954C004E31889A1023A40	0105000020BC08000001000000010200000017000000EA9A06F207A02C41A17D54EAF83A22417D18B37B1AA02C417C242C575D3B224115DC9B5F4AA02C41C0FDDDBEBD3C224169C438AC63A02C4100EF2154993D2241AA9084437AA02C4171CC366FE03E2241261F427D81A02C41F3970695E53F22413DDA7B6582A02C414B553975DA40224199BEE19906A02C418CEF928C634F2241C6F8EFD7DE9F2C4136012A11CD5322414C8DDE71C69F2C4142C95DDDDE542241D4A8A3969F9F2C418CF61958515622412B990D9D8C9F2C4166F812493C572241C045B192839F2C41358A4CCB05582241586368306C9F2C4102D4F107425A22418A4C101C689F2C417FA6E99C9A5A2241F53E4B4F289F2C41676256DCD262224115487A700A9F2C411EEA167A1E632241CB2B7FF5659E2C411663D16C997422416E442B0A4B9E2C411CA5CAB2E1792241B3AA8C06109E2C416542C046098422418E21B316C19D2C412AF250D4F78E224103C406DF3C9D2C4146150C403FA022411486A7495D9D2C4194955B525AA02241
447	26020064	1	US   27	27	2	26	Alachua	2	0	0.619	990.8484	990.848446155947	0105000020E610000001000000010200000003000000A90E5270C9A654C051EF19D7BCD43D40A97BB5B633A654C0174F61ADB4D33D403C98488B33A654C0C53C1861B4D33D40	0105000020BC08000001000000010200000003000000B9DB7998AAEE01418FABB17A678C3E411C118B039948024164DBB40C85863E41EA9F4B19B3480241CE42A95983863E41
449	92010000	1	US   17	17	5	92	Osceola	5	1.915	10.298	13496.9393	13496.9392760239	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
458	08050000	1	US   41	41	7	08	Hernando	7	11.725	12.558	1340.5655	1340.56554634542	0105000020E610000001000000010200000015000000EA17497C699854C0E1EC44B8078E3C4084531F85699854C0D3AEECFD0F8E3C40ABBAE3A6699854C0A9E565E52E8E3C405CC676B8699854C039303495368E3C40963086256A9854C04001445F3A8E3C406E5F81E06A9854C0EBD99AFE3D8E3C4077DB6DCF6B9854C0F884D86A408E3C40C510ED056D9854C0BEE47CC0418E3C409F01A0FE6E9854C08B2A670E428E3C402ABD4C8D8B9854C087AFE126418E3C401255E29DCE9854C01528659E3E8E3C4073A4DDBDD29854C069F50FE03D8E3C40DF75E829029954C095062D053D8E3C409F95A27B069954C049AC10063C8E3C4033548CF50B9954C0572C75F4398E3C40E4DF3C6C109954C0784D41BF388E3C40E37B92AE219954C0F6D6FB09388E3C40A3F5BDFD269954C0D9C7F520388E3C405B96C63F2B9954C09C892ED5388E3C40C404CBAD309954C0E3E4F4773A8E3C40528164503B9954C0E2EB67763A8E3C40	0105000020BC0800000100000001020000001500000002236F8AF7F50941A1141E6BCC7337419332A45CF6F5094109E58E53FA733741228D287FF1F50941C50B5ED6A5743741D955E9AAEAF5094176524C81D074374160739FD1A9F509417C289DA0E5743741BAFB9A2A39F509415A7F79E4F97437414A9F4717A8F4094118590B8C077537416C59AFA0EAF30941A6E1E5390F75374160178CB5B5F20941E164445C117537418131913C38E1094168A784CC12753741EC0C7FFF24B80941B31225F0137537419D9A41F09DB50941F05EA8BF1075374175EC060093980941D41E27C716753741C1854A58ED9509412F49153B12753741C464FFC0919209413A3851FF077537414D117A5AD58F094167FD9E4F02753741D73A3A3843850941ECFE9E4F02753741803D87EA0282094195CDAE0404753741B00F56BF677F0941C7C705E508753741453CE459157C0941C2F77435137537414F482F0A927509419CB5719915753741
464	93010101	1	US    1	1	4	93	Palm Beach	4	0	2.336	3758.9545	3758.95451440852	0105000020E61000000100000001020000001D0000005FFCFF3B4B0454C0CDBF29130C7A3A40C6CA6D754E0454C06A6E3093EA793A40D31925E5500454C0C28D7956D5793A4092AF4B82540454C0AF9EF7D8B7793A40A1086731560454C0F41F8BF3A8793A4023825FE2570454C09B42615B96793A407FF8B213590454C0FE7A718F86793A401C22B6055A0454C08BE9613377793A402FB14C7F5B0454C03FCDA4B05A793A404B1A70535D0454C0AE24E5BB2C793A4095AF555A5E0454C0BDF6474209793A40E84796B05E0454C0C1C1DEAEEB783A4036A7927F5D0454C012B46B841F783A40E10297C35C0454C0D38BAC168E773A40DC9EB1805B0454C06DCE4D71A7763A407645B3F65A0454C0E13CC0FE2E763A4044EBDA2C5A0454C0B2F77CCEB8753A405D4C9752580454C0C3F8DA9755743A40A0CC763B590454C0086BC0F072723A4001F4DA37590454C0BA30323E56723A4051BB0D81590454C0CB07F4C047723A40F2610B635A0454C02422574624723A40EB13CEC75B0454C014BA7C2B07723A4076B93C785D0454C026FAB041EB713A40E2E8BA125F0454C0DF953325D6713A408AE62510620454C0A128FCDCB6713A40A0EE3FCD630454C0F335950BA6713A402C9841F7660454C00B95C6178C713A40EDF110CD6A0454C0F02898AD71713A40	0105000020BC0800000100000001020000001D0000001D79DFA87A562D41213BB18760CE2741841EB698FC552D41265C9CF7EBCC27411C96CC029D552D4129B723ABFFCB2741F76E2C110F552D415D454979B7CA27417AFE0A04CD542D418A8185BC11CA27418CBE97F88A542D41E0FAA9F842C927411226E19C5C542D4192CE306393C8274151D5871838542D41CBBF25B9E8C727414846C47CFF532D41D7CCEC03ACC6274155E0F527BA532D41C10D3FADADC42741CC9285FF93532D4167E41DD723C3274164FCE9EB88532D41E2816EA5DBC12741907C45ECC8532D41C5F7151903B9274163A5AFF1F1532D41C9E82A03B6B22741E861A4DD36542D41736A32BBB7A827418E0E6E1456542D41D9047AB77FA327415366F4127F542D41983585D5609E2741BB563FA1E5542D4144505ADAFC8E27414BF8BB18E8542D41FE620058127A27415A6563F7EA542D412D6E06FFD37827411C45A8B5E0542D419ED1DB2D337827410ACD8A4CC0542D4169A7BA57A9762741A9579FF88A542D41325D791166752741DC785EBD49542D4131C473ED2F742741261073620B542D41342BBC4445732741BCAA077796532D41EBDF4B61E9712741E76F1F5D52532D410138314F2E7127414326A00ED6522D416A51D47E0D702741BE409CFA3E522D41A1B1B15BE76E2741
467	35050000	1	US  221	221	2	35	Madison	2	12.621	19.356	10845.3766	10845.3765504205	0105000020E61000000100000001020000002C000000EF3063FEA5E854C0D0F43DF982783E4086147FB5A5E854C0E86B1276A2783E40BFEBE71DA5E854C02C28AE0DC4783E40ED2E88A7A0E854C062889B2E94793E40B28DDFEE9DE854C09084D24AEB793E40CE67D1CC9CE854C0148752D8017A3E40E10F00509AE854C0EC2571E62C7A3E40DF21B6C196E854C060DB3E91637A3E407FBD376363E854C0E5466FD6677D3E404FD0530761E854C068B636ED8F7D3E405CED9AC65FE854C027AC6A49AD7D3E409BA659335FE854C0B3885F1DC97D3E40983EDCDB5EE854C043306352E87D3E404638D0035FE854C01E166682FF7D3E40BBF0F9A55FE854C0183E7FEB157E3E40A4A563367AE854C0277359989F803E40BCCAB4187EE854C0DB675C5B04813E40110CF4547FE854C04231A55C32813E40B24B6DFD7FE854C0DA58CF035D813E40019C703183E854C002CC1B702D843E406968554184E854C0614E656D4F853E4009BFD3C983E854C0C0591B467D853E4057098FF982E854C0B9F6DF9CA3853E4044903C4A81E854C015BDD5BAD6853E4018ED9D407FE854C01EB2FB7301863E4028E75F9D7CE854C0D63EFDC72B863E400A1D2CA96EE854C0CC504A52F6863E40C0AF81516CE854C015C34C311C873E4070F8AE1C6BE854C056A54DF538873E40AE63EE4D6AE854C0FF4529745B873E4071C476146AE854C0C3D555617F873E4002BB8E706AE854C0D70EC2CA9D873E40A615858B6BE854C0B135C1CDBE873E40E17B25EB6CE854C0A9DC944AD9873E40BDE88CC796E854C01371A502058B3E40C1FFE485B0E854C0741CD0CCF58C3E40FF6915D9BDE854C05127EFFFF88D3E40887890E3C4E854C043ED6C3E828E3E40B5AC05F5C6E854C0D687DC79B08E3E406956E50BC8E854C0A84546CBCD8E3E40CFBC24BFC8E854C013B8266AE68E3E405AD73E69C9E854C0CD0F6C2A078F3E4025E353C3C9E854C057C97DF61F8F3E40DC6E5C34CAE854C07264C00A45913E40	0105000020BC0800000100000001020000002C000000444C6D717D4105C17A193BA298184141CF5C92FA304105C1B3844CFCEF184141B6822005B34005C1E135741C4D1941416167957D2C3D05C16ED13FEA8D1B4141430024622F3B05C122A29E237F1C41413F45EEA2693A05C1C015E07EBD1C4141AD0B802EBE3805C16ECD7D77341D4141F4ADAB4C623605C1407F7C6FCB1D4141AEC4D44E611405C18B6491E21F264141C80FA1CFCC1205C1C446A6A68E264141A9CE5BA1ED1105C1408031E1DF264141F07E404D781105C17A14AE012D2741412C0A7465231105C1A37A23918327414154DC7365231105C1B306A2F9C3274141837FB4A76D1105C113064F5502284141CF8EC3B0C31E05C15ABC89EB132F4141F6BB7FCDB02005C12C59DC862C304141846AD3293F2105C1E8EDF885AC3041415C9E1F30782105C17EA39B1523314141F954D3D8792005C170268BD8F33841418B381668F01F05C1FF4BC227193C414171270D09791F05C1D64E7D54983C41416FE2541ED41E05C1404A9395023D41411158AFEB9B1D05C1271E181E903D4141179C5A2D361C05C18B90CA44063E41415D4DA68A741A05C1C7F035307B3E4141F3F59F1C401105C1CC089E59AA404141EB6A0589B00F05C15D2D67F612414141C3CD0427D90E05C199DC1B8D624141410FB2E527390E05C1BA5C0523C2414141B785CD5EF10D05C1050D69D3254241410AB4C529090E05C1EEE50C567A4241412E97B0EF900E05C1844F4E3BD6424141EDB873BA480F05C190F93B1320434141D9D85476242505C174EB9AFBF64B4141D75C5B3D973205C15411C6F75F514141955993CE8A3905C1FBB8B78F325441416AEED9C2363D05C123DF892AB15541415C95FDB1443E05C198F786FB315641414DF67CB4CD3E05C17373029F83564141962756C21F3F05C1B9A48F21C85641410D2569DC633F05C1F23D7A3423574141A6F3232C803F05C1DFFC6D2068574141FF4CF5C9883D05C1A35D4C985C5D4141
468	13010000	1	US   41	41	1	13	Manatee	1	0	5.284	8553.3473	8553.34730370974	0105000020E6100000010000000102000000290000000F68BEE1CBA354C06B2A35B497633B40A2B70935D1A354C0DA7226C8CA633B403309E6D8D5A354C0CC3043FDEF633B40E3A563C1DAA354C02F5AD3D713643B40C93EDAB505A454C0BA013B4643653B40CE714A8A08A454C028A7A98C5A653B40694157E20AA454C08ED4FC2E70653B400758E0B10CA454C04770C15C84653B40D1A9A3500EA454C0EBBE11539A653B406A0713EF0EA454C02B8B9958A8653B4013CD0B6010A454C02773394DC6653B406BBA579E11A454C0483FFE18DB653B40D329402913A454C06AECB68AF2653B407759323715A454C0CCE3305608663B4041F36FD817A454C0FC608FBB1F663B4030B50E141BA454C093C8825C36663B40CEE71DF91DA454C064FC1E2048663B409241DCBB4AA454C0D7C162184A673B40F7A875854FA454C08C4396DD66673B409973395553A454C02A8F76FB7F673B4090AACF6F6DA454C0911E44BF31683B40E304940899A454C02174CA3B5C693B4015CD9F0DCCA454C0EA7D030EB96A3B40058DEDA9CFA454C00E2F2823D56A3B40E94DDF8ED2A454C0F366CD18F56A3B40BAF51C12D4A454C05BC3DE7F0F6B3B40B84631DBD4A454C00F32A06D236B3B40D0C5056ED5A454C000E058943C6B3B40A0FA7133D5A454C0170847D9346C3B403ACDABB9D4A454C0B1E14161E86D3B40C1F2469AD4A454C0CADBE25D656E3B40E6D13270D4A454C0FC39E3AD516F3B4066CC13EED3A454C09E3E777EB9703B4080EA32A2D3A454C02375B2CC9E723B408DE327EBD2A454C0F6CD19D556753B403D3FC182D2A454C0FE04FC30F3753B404665C0DFD0A454C03CDB81C3FA753B40A7C94EE4D0A454C0CF37DB1E43763B40C8C0A106D1A454C011C7048359763B4079CEFA28D1A454C0429749B262763B4023DABC55D1A454C064272CEA74763B40	0105000020BC08000001000000010200000029000000CBAAC2140454024168C0F5C59FFE30418D5E5787D4500241ACCFC27BBCFF3041060B6CE0094E02410BC37E118C003141D12BA6FE134B024182DA9D35540131412DFD94CA25310241FCBA425FF20731418793C452722F0241CDC3E1357408314102F904F10A2E024118AEC1D2EC08314122E63541F72C0241D735AD3A5D093141254921C1022C0241CC2B797BD7093141FCA6807FA82B024191E1416E250A3141220331CDD42A0241D195FBFCCB0A31412994565E1B2A0241B3476BAD3F0B31413E5EA2FD33290241E8895422C20B314165502195FA2702410F7A2A913B0C31413AF1F2E4662602419651D506BE0C3141077E85387324024172E12E613C0D31412F15E36AB2220241CC68A2A89F0D314185F6FBAE8D07024146E7AA134213314156F63C27A704024197F7EAE4E213314174E2DA39590202417DA689326F143141D1762C6894F2014145E4E1FC4F18314175FD12C53FD80141CD6107F3D21E314131F2A1EA6FB90141ED05CD0F6F263141E04423A643B70141C9627DC60B273141CF219C0B8BB50141DC8ED8D1BD2731412C10EC39AAB4014141FDBDAF502831410133ACFB38B4014166F9D273BF2831417B914240ECB30141600314244B29314136BCC2159CB40141EBE11F89AC2E3141B0763E59DCB50141704910D71C383141F7D3151136B60141D8C6B243D23A314129C30604D5B60141501AB856F13F314109EAEDEEEFB701419453E98BBD47314128E4DAED2FB90141F133D60F42523141659057E528BB0141ABEA19A457613141F571B57FC1BB01415D30780EBB6431413D5CB8FAC8BC01418383ADA8E464314149B7CFE3EEBC01416207F51D76663141295B7942E6BC01413E4F0962F2663141C26E432ED6BC01411D9215602567314198023ABFC4BC0141747FB77F8A673141
469	59110000	2	US  319	319	3	59	Wakulla	3	0	0.18	289.7377	289.737672578893	0105000020E610000001000000010200000004000000BCFAB66F551855C0A5552E7DD81A3E403D302DCE4C1855C0FD70EB000F1B3E40FCA1E3E93D1855C05CC70A346C1B3E402D6367983D1855C0496D03326E1B3E40	0105000020BC08000001000000010200000004000000B4B3AAC0CC3419C1661F66ECB32040410F8FE7FF0D3219C1034093D74821404140AB3B13522D19C1F9F04266472240415AD8DB2B382D19C1397B27D74C224041
470	10080000	1	USB  41	41B	7	10	Hillsborough	7	4.569	4.613	70.7731	70.7730786139421	0105000020E610000001000000010200000003000000F67F77B6849C54C038CCB38FAEF43B406199CACB849C54C03931E9ECB2F43B408BF0593E7A9C54C066603249B2F43B40	0105000020BC080000010000000102000000030000004F1DB507DF2007418C29B2FADE213441A0A06C30D420074167256B36F721344138497D8453270741CB756234F1213441
481	92090000	1	US   17	17	5	92	Osceola	5	14.635	15.386	1208.6529	1208.65292412402	0105000020E6100000010000000102000000080000003F9C95FF9F5A54C0F2B65338F14D3C409FD9746F9E5A54C0DB05E640F14D3C4018518929675A54C0F5DB68ACF14D3C408C5E1C21305A54C0E15A3F45F24D3C40B3AB435B195A54C00DC58888F24D3C4051F48ECF085A54C021065067F14D3C40EA3EEFE9F45954C029E60725F04D3C40101FEA09D65954C08740E350EE4D3C40	0105000020BC080000010000000102000000080000002B392AD5F4E01F4108B50DB22A073641DACE00A06FE11F41EDCF8DC62A073641B7E854EE65F21F41217E516229073641610853B0A4012041CA2A6505290736417C350238230520413DD69DF728073641BEA74A18AD0720419E28AC9A2107364164AF859ABA0A204199F6714E19073641FF362A50770F2041880876210D073641
489	87110000	1	US   41	41	6	87	Miami-Dade	6	0	25.715	41380.5239	41380.5239294965	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	0105000020BC0800000100000001020000003E0000009D8373AF694C254162B83323C25320419C26B256BC4E25416A9E555D61512041CBED23CD3B5425417D5B22A04C4B20415BE6439139962541ADBDA2518F04204101505995CEA22541F99A342306EE1F4106A21EAF07BC25411BA9EF5714B81F41CDD38C86B8BC2541ED7CFC28DCB61F4106A4621899BD25413FE6A8BB7AB51F414148A71C97BE25413C5738DC4CB41F41658CAF79C0BF254134BD058021B31F4186AC42BE03C12541414ADC4007B21F413A482BE349C22541D044458721B11F41DB765B8593C32541DBCA9CFD83B01F41A2DB5ABEDCC42541B2682AF61AB01F4105E8ED842CC725413437FD5BC2AF1F41D73365CFB0C925412FC76E81B8AF1F41F267F5AB1DE5254183C614B3EDAF1F419AEE2BC683722641463466E811B11F41F78530717689264188859CA139B11F41334FE7A4EFA526417A34864E72B11F410F61B47405FD2641A6CFEAB9FFB11F41EFD3971887312741F841B0104AB21F4188A390CE64382741049E2A0A54B21F4112A58139224627412E1B2A4F59B21F410A93CF581A472741B64DA5053BB21F41E8DAB8022848274111D6D8DCEFB11F411C191AC736492741E26C10ED7CB11F4116688AF7494A274131CE7192DBB01F41B64FB5F29C4D27411C12E7194BAE1F41E595F4599D4E2741B1345287A7AD1F41DFF8F11CD64F27419DAAA5A515AD1F41201A5CBBAE50274146554D55D3AC1F4129042B114C522741BD5EDDB5A2AC1F417803132DC2702741174E7266B4AC1F413E1BA21BEFAE2741A3E63996FAAC1F4126DF34DCF1C527417B33737C1AAD1F413C99936BD1F62741101FCF0B57AD1F41B20A67418F1228413DCC525D93AD1F4194DC345EDF30284154523F7EC5AD1F417A676FCD92522841ED42D86F0BAE1F410131EB0EE86D2841D1D3490D40AE1F41BAADA40F9D992841407E20DDA6AE1F4130CAC63BB2A428411E8B2910B2AE1F4171101A5F3AA72841B396BD8EA5AE1F413BD8D654ADA82841032BA0E294AE1F41B284B42004AD284159CB0C8641AE1F4131D81162F2AF284115BEE08328AE1F414EDB426E57B32841C0E174021CAE1F416640033470CB2841724C92885AAE1F41923FAE2D3ADE2841295479E07BAE1F41DA43608FAFE02841C2EEA5E294AE1F41190AA002EDE32841D4F7FEE6C6AE1F4196D40E5AD5E72841DC64FFC426AF1F4197B00430B9EA28415600519E54AF1F41BC56309A9AEC28416F55111F61AF1F411F91FB101BF128418297EBFD6DAF1F41CC0B4C6BE1F82841378FD31F7DAF1F41A20EED13E8102941684688D1B6AF1F4125FC4EFEB323294159F329F0E1AF1F412A8838BDD8322941E59FADEA2DB01F413C37F4C23D352941467BB321D4AF1F4196B54464E53B2941ADF5A5EBC8AF1F41
490	89050000	1	US   98	98	4	89	Martin	4	0	12.333	19803.5308	19803.5308274979	0105000020E61000000100000001020000003D000000D85E4762042754C04415B0AE2EF53A408730E847042754C052D1877A52F53A4050495BBE042754C05089030590F53A40B910FBDA052754C094CE23C5C2F53A40170F96C1072754C0DA4AF3DE07F63A4082FABE360C2754C02B5D231C97F63A40876F5C89132754C0F85E74275AF73A40682CDBD0152754C0AE393C4A8BF73A400DD56BC6192754C087439EA9BEF73A409C50A4AA3E2754C0A1DF92DC83F93A40CE3666534B2754C0FD733DE316FA3A4038079B4B4E2754C03678CDB131FA3A4000D30C8A522754C0B32E47BA52FA3A40D11818BE5B2754C0B1E8A1C294FA3A40BFD249F85F2754C0D1F9864FBCFA3A4078624F5E632754C060B54135DEFA3A403859B0CE792754C05995743E07FC3A40771D9C207F2754C06D257FAD4AFC3A40A29F40BA922754C029A4B92154FD3A4091327D4C982754C028927BCDB2FD3A4039FD19159D2754C0993714D30EFE3A409141EA11AF2754C0048B789BECFE3A404B50FA92BE2754C0F0D0D741AEFF3A4037204B8AC22754C0995EF727DCFF3A40F36894DEC62754C0C40E3B8B07003B406A8CA5C9692854C053AC28630D063B40775B5C5CFE2854C00FF2FDD38C0B3B40DC9B142E162954C046BE7CA86A0C3B4054152EAE342954C0673C7411640D3B40059962836F2954C0A9CB0B30430F3B4047913FD7A92954C0BA03BDDB1D113B40079F0A59EC2954C068905B5B38133B40F51A9542F12954C0CD0C1DD165133B400CCE387FF42954C080A905C288133B404E29D3C1082A54C06B692CCEBC143B4017679F230A2A54C0DE29103FD5143B4081232B980B2A54C09DA5742C04153B400A54A4DE0C2A54C0AF89B19D72153B40049B5A0D122A54C0F30A589827173B40BF74CB1D142A54C036EEF012DB173B40C66FA8EE132A54C0A762DD230F183B4092568D9D132A54C07F0D312E31183B40CB9324360F2A54C0B51E1FD31E193B40961EC3790F2A54C036A761D03F193B40617A0E79102A54C0BD2369E064193B40A382FE8F122A54C08A516D3C85193B40E672979C152A54C0882FA770A7193B4084E4361D192A54C0695A7F74C3193B408FDAD784502A54C0814B6F23411B3B407F06BA286E2A54C0150869250E1C3B4031189BED792A54C09BF22E61501C3B40D7231BF4842A54C025E75FB3841C3B40B886DBD5942A54C0D2F5AA61C61C3B402FF7E14EB42A54C08EEFD1573A1D3B40173C9A23F12A54C09646A4EA181E3B40161F5488FD2A54C09AA58986431E3B40E58B58CF0A2B54C0B959C8796C1E3B4021DE292F172B54C002D707488D1E3B400A86C467442B54C03768341D021F3B401E5170F1502B54C0651DBE06261F3B40D485065D5B2B54C08BEF679F491F3B40	0105000020BC0800000100000001020000003D000000E67AAB82B5E727419275FBC42E1D2D4109B05261B8E727410B9D9EE2BB1E2D41394F8ADFA3E727410852438766212D41AE45D9EC75E72741D85C836399232D41455810FA27E72741D36B6AB897262D41CF7263D371E62741D407782FCC2C2D413E5ADFFD47E52741322167FF3E352D41CBAFA2AFEBE42741B656D2CD5F372D41220364824CE42741FD56BE3799392D41C2B0FF4B82DE274114886440384D2D419974180286DC27419BA2DBBC95532D416D13E6090FDC2741BFC701C2BE542D41327DBB3165DB2741259498B12C562D416CFA3C11F5D927418E267C1B08592D412309D5AA4BD92741C87D6958BE5A2D4115EBE668C3D8274194A60DF9355C2D41E63F49533DD527418452A56A12692D4154F6299067D42741B35449D9FD6B2D4158255E7953D1274100765F4B7C772D41B4308BD472D0274145AFA6DA957B2D41C362BB96B1CF27413528271F927F2D41699CE425DFCC27412918CD4E2C892D41144E5E6670CA2741BD4DA8B48E912D41CAA1F438D1C92741600843698B932D41035CF0B123C927414B8653376C952D418659D8E5A5AF2741B9BB977A29D82D4142BF40FB68982741472DA9E815152E41747E1394AF94274112054F18B01E2E41FF6243EBEB8F2741C92B61807B292E41D10D1A95BB86274123910810383E2E41DDF1E3C09F7D274155FC5165C3522E418262945E3D73274109F643FC116A2E4166FD73DC787227418E62C2C3096C2E410EA38039F77127411212B0088D6D2E41F93B7421C96E27417512462FE47A2E410B16397F916E27410308482CF37B2E41B3B05646566E2741489A859BFB7D2E4189540748206E274156DFC5ABC4822E418C4B613C456D274124203CC7B3952E41FDD787D4ED6C274180F63C9F7A9D2E4140560192F36C274196601D3EBC9F2E41B279F11FFF6C274144062CE835A12E41D27F57D8A66D27416BFF21B782AB2E4170EB8A5B9B6D2741B9FC3BA8F0AC2E41CCFFE9A1726D2741A3D11BB58BAE2E41AD4D14AB1E6D2741E037E376F2AF2E4184FE1F8AA46C2741DAEEA3946DB12E412C438399186C2741157563FDA3B22E418D8808E0746327415694DC4728C32E4104CC0EBAD55E27410DB53C6507CC2E4115969F68005D27418673D9E9E4CE2E418B77AC0A495B274144C77A2C28D12E417FF59770D0582741A74B9221FFD32E4191EC3646EB53274109D06E3F02D92E4165B2EF4B754A27417B0CAF09A1E22E41FBEB09F387482741FAA5767078E42E416E68878E77462741B3F5AA593DE62E41015DD5438B44274116916901A8E72E41A11A8B56843D274134AEFE74B3EC2E4195E37E7C913B27415BAFA19240EE2E41CA9CE1B9F2392741F1771467CAEF2E41
491	48100003	1	USB  98	98B	3	48	Escambia	3	0	0.31	500.1696	500.169626762177	0105000020E61000000100000001020000000F000000DE0F831E2BCD55C06D65B04DCD6A3E409760A44031CD55C03D9E1521C96A3E4022550D2B36CD55C0D71035C2C66A3E401C7E29303ACD55C002F04A2CC66A3E40145A2A1F3ECD55C0D08393B8C66A3E40205E22BF48CD55C0A758990DC86A3E40317ECE7251CD55C0B9B06CE6C96A3E4060258A5857CD55C036095C21CA6A3E4030F2A7325CCD55C0BB132D92C76A3E4011260E7561CD55C0E2ED4555C26A3E40BD5DF70C6FCD55C02DD45B5DB66A3E403A1F72BC73CD55C0565CCC33B36A3E4063E6DBA977CD55C0EE81F1B9B16A3E40EFD3E6F27DCD55C0BDB71F64B16A3E407BC95D107FCD55C0E69A426CB16A3E40	0105000020BC0800000100000001020000000F000000EF0BF7D61FDD33C1A08A903CBF484141D71E577497DD33C121C1E0E0B648414184A5F705F7DD33C1D47385E4B24841413FCA7BC344DE33C15843FE65B3484141E5958C7D90DE33C1A8A74803B74841416611F2135DDF33C123AA355DC048414178B79B6704E033C1F8747E20CA4841410566411E76E033C1D0CEA8E6CD484141EB3A7184D4E033C1E8DC785BC94841414DE3E7983BE133C15DBE8F93BD4841415009B78945E233C1002DDC7EA34841413969C0E8A0E233C12962922F9D484141B0DE1C23EDE233C1ADA97B2A9B4841419E8B678266E333C1496AEC929D4841418966AF037CE333C1448D4D419E484141
497	12001000	1	USB  41	41B	1	12	Lee	1	5.137	5.257	193.2361	193.236110130823	0105000020E610000001000000010200000004000000C2A55C13B67954C01245215E61B63A4058681CC8BD7954C0E7F097E190B63A40692A71E0C17954C0BE24ED95ACB63A409E10082AC57954C01B9EADF1C5B63A40	0105000020BC080000010000000102000000040000007DCFB65902151641F6ABE4CB1D6B2A414436EB9BA3121641364A3E122F6D2A41DE876992611116417EC35792636E2A41628317895F101641D13781D17D6F2A41
505	87006000	1	US    1	1	6	87	Miami-Dade	6	0	0.563	909.0914	909.09141911533	0105000020E6100000010000000102000000210000008B9BBE35B50C54C0A6C4134E8EC539409C5988D6B20C54C0026F33C4A0C5394040BE298BB10C54C0EE4D6D82A9C53940C196F407B00C54C018DD7400B1C53940025E5DACAE0C54C06A870381B6C5394068D2305DAC0C54C05E1D692EBDC539408878AEABA90C54C0B48FFF26C3C5394008372130A70C54C0A3885C89C6C53940E4501756A40C54C0D4DD9A77C8C539404B0E2EA7A10C54C08EBF7368C8C5394000DFF18B9E0C54C0C57CCA4BC6C539409B1A0F989B0C54C0AC46BFCAC2C53940943FED7A920C54C02D610C15B5C5394064A261C78A0C54C047E0E9FFA9C53940C4A03CF5840C54C0321799E5A1C5394096EC5267820C54C0008F9BD99EC5394053E119CB7F0C54C0D650E24C9CC53940B91E26F87B0C54C09FC0269C99C5394091CD37E0620C54C0B57CEADF8AC5394028673F5B620C54C0AD5EF9B88AC53940ADB3635D5B0C54C0FD1095A186C53940E92863A6560C54C09F1B4CE684C5394096D2F803530C54C0B8F3A83B84C5394046754E51500C54C0AFA5907F85C539400EAFD1BB4B0C54C05B981CCE84C5394056934992480C54C022EA9C4085C53940035C301E480C54C01FA0F45085C5394048962915440C54C029DA214386C53940F83C325A3F0C54C07F940AA387C539402FD83F81380C54C0B08B19E38AC53940DB458EA7330C54C075951AA88CC53940DB022317300C54C095ED15BA8CC53940007453492B0C54C0C48E4C8D8DC53940	0105000020BC08000001000000010200000021000000744947AFCF122C41DDA86CD0F7F31F4111604EBA2D132C41FACF978692F51F4100A18F2361132C411ADDE21D55F61F415F109B659D132C419E802E11FCF61F4150DF7592D3132C416175E1CA76F71F4119CB8FE42F142C41FFD69A0D0CF81F4129F749B19B142C4123F55DD591F81F41487E0C33FF142C41D344DC1FDEF81F4152C1C7A171152C413A0175590AF91F417CEC566EDD152C41E51075590AF91F419DE0265E5A162C41FC688D04DDF81F41933E4739D1162C416B4065BA90F81F419BB68B4840182C41B575340D65F71F411D53666C76192C41002BD5F772F61F4161FB3AD1601A2C4191907211C2F51F415E9513A4C71A2C415590B7BA7FF51F41313C34AD301B2C4119BB627248F51F4125E6E97BCA1B2C4157AEC9A30EF51F4181879C94BB1F2C41A0888A13D4F31F41F5712A75D01F2C411CAF08F5D0F31F4102678E9DE9202C419AFFDAA179F31F41079E7525A7212C41BCD3E38955F31F41D4CA533339222C413DC9708A48F31F41B715EE7FA5222C41BC5D1AF065F31F417B6961B35D232C41022366D158F31F4140B983B5DC232C416082594C64F31F41B6C583ECEE232C410A8C1AF065F31F410FAC94F890242C411E9CB3E97CF31F41E2A8ACE94E252C41114585BD9DF31F41BF7970C761262C41A26BA838E9F31F41BB4D098424272C41819BE1DE12F41F410C0A13B2B3272C4146C0223016F41F412F9EBFA174282C410E79EFDC2AF41F41
506	55003002	1	US  319	319	3	55	Leon	3	0	0.508	817.9281	817.928091238142	0105000020E610000001000000010200000016000000E62AD17EE10F55C032F54BEB5E823E40DF41F7C5E20F55C0BD95DEFE57823E406B02FB2EE40F55C004F8AD9D50823E40ACFDB126E50F55C0FA0E09F64B823E4081654DF2E70F55C028775B833E823E407B714F31EC0F55C0CCACC14C2A823E4097625706F00F55C035E7A2B016823E400FFDA66AF30F55C06BFCA05B04823E405023FFE7F40F55C0FBD61AC3FC813E406ECAAC03F70F55C05DC01D3FEF813E40CEF942E9F80F55C035A594DAE4813E4038860072FA0F55C02089D4E8D8813E40024A1F47FB0F55C0CBD041D5CE813E40198163FBFB0F55C01E6FBB14C5813E4073474811FC0F55C0E57BAEBDC2813E40A88CB66AFC0F55C052870A2EB9813E40BF9CBD86FC0F55C02C6BA6E0AD813E40AC410607FC0F55C00FA3EC429D813E40FA366049F50F55C0CC003BCF50813E40C8264242EC0F55C04C81B19AEB803E40121B5BA7E70F55C0948D3E35B9803E409F738A99E50F55C0FDD26625A2803E40	0105000020BC08000001000000010200000016000000DC814057D76516C1A43CD24BCF3D4141FE454B193E6616C10678886CBC3D414136D5D853AF6616C1462C6352A83D4141FFEE62C2FC6616C1557BE5A99B3D41419B61B772DC6716C133061018773D4141990AA118306916C1EB16B523403D4141BBB2F481636A16C15ADFFBBE0A3D41412BD13B39746B16C1819268C7D83C4141FD6F29B4EB6B16C1CEDA4319C43C4141E5794790966C16C16179A4269F3C4141E35DA42A2F6D16C125A412D1823C41410B0387DBAC6D16C13B97B812623C41414C729F5DF36D16C1068F7352463C4141704EAFCA2F6E16C157FCB16F2B3C41417E56DFDE376E16C1B3D23AF6243C41410F7C63DF586E16C13A950A820A3C4141B592BA88686E16C1DE730027EB3B41414D8382C94C6E16C1056433DFBC3B4141B2F9E710776C16C17B012FB3E63A414147DB3433016A16C1F84BE627CB3941418071EC1BBF6816C1509286EE3D394141594254D22F6816C121742652FD384141
514	55050000	1	US   27	27	3	55	Leon	3	0	0.386	621.2588	621.25875472812	0105000020E6100000010000000102000000030000003982E8B5F61155C029097B60D8713E40F3C94CCEF61155C0E69CF1CDF7723E40172A2D2FF71155C037FC985347733E40	0105000020BC0800000100000001020000000300000056051DDBC61017C10A0909A47F10414119D51FB6141017C1AD01E4D89D1341417D058186FE0F17C14FA9BAC87A144141
519	15010000	1	USA  19	19A	7	15	Pinellas	7	0.5	9.81	14980.5416	14980.5415899259	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
528	36010000	2	US  441	441	5	36	Marion	5	14.711	24.959	16467.3016	16467.3015534125	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
529	13130000	1	US   19	19	1	13	Manatee	1	8.466	9.194	1173.8255	1173.82545305776	0105000020E61000000100000001020000001000000034F7D510FAA454C024C7EEFB64943B4051F16E7009A554C06D17BF39D3943B40E08C5C5C0DA554C0E959BD97EE943B40A904C1DF11A554C0EBE47FDF0A953B40E5DCF62916A554C0CD7EE54B20953B40B7C8283C1DA554C0AF7D258C3B953B4038996D2022A554C03EBBF1144A953B40344C29E328A554C0E5D9D7AA5A953B40189EBF9730A554C04BCE31E168953B4088B8DDCE36A554C0ED940AB971953B4052928E4D3CA554C08DA45C3377953B4067AFBBD944A554C09266141F7D953B40EE2D36524CA554C0803399037F953B403C3E9A2A66A554C016585B597D953B4059C94A638EA554C03B9B93DC79953B403958C62095A554C0EEC9E25077953B40	0105000020BC08000001000000010200000010000000A96E32BF7BB40141D0E44242AF0D324122A51F083AAB01415DC051CB16103241298FD420DDA8014172BC53A0AF103241F3B25A2523A60141931DA2AC4D113241EB5BD69E88A30141DB11349FC511324122BDA56A399F0141B788F19A5E1232411592B8CA3B9C01412FDC817BB0123241913C62A817980141D84377360E133241814672B95C9301412B61C9035F133241FE25F57B8A8F0141E94D97A691133241B1F7404E288C01418AEACF6EB11332413E40E972E3860141614FF071D4133241ACD090AD46820141F1050AD6E0133241FD09AB074D72014176D8FF23DE1332413F9C3E0A7059014145B066FCD41332410088B44C4455014188E65592C8133241
536	15010000	1	USA  19	19A	7	15	Pinellas	7	0	0.5	804.499	804.498996378544	0105000020E610000001000000010200000009000000E7FE4DB2DDA854C0D0570A420EC73B40B3AE157E14A954C0F75CAF410EC73B400C8D815D1EA954C07B1227B40FC73B40A801006329A954C0155B25390EC73B40E45A964A34A954C0EDB63A750DC73B4026632A8641A954C02B57A3EA0CC73B4071C85A9B60A954C0518238AA0CC73B407B89433F63A954C0BE23A0810DC73B4051EB526863A954C0F7E45D7D0DC73B40	0105000020BC0800000100000001020000000900000054FF08FB23D6FE4089EA6C4AC727334127D20EEA8892FE404DB1DBB7D5273341B5A5EF5E5C86FE40C6C80A5AE0273341C166FB88C178FE40080B8E0BDB27334135BBC5714C6BFE40CD2B5EADD9273341D92C154DF85AFE402695F92ADA2733418F6D4CA39E34FE40481E9EFCE0273341AE3151B85D31FE40C179905AE6273341A329970A2B31FE40502BCB4DE6273341
542	77530000	2	US   92	92	5	77	Seminole	5	6.523	7.686	1875.6148	1875.61480233257	0105000020E610000001000000010200000011000000DCD6C1E4A75454C07E408E36C6CF3C4075F397EDA75454C03B512D53CACF3C40191FE812A85454C05D5FC5C330D03C4057101C3DA85454C07A16008EC0D03C40FEBC9922A85454C04636C526D8D03C402EBEA1D5A75454C053D2F878F7D03C40392F9849A85454C0BB5D210907D23C40C7A8DDACA85454C07525CE0F24D23C40E9B5128DA95454C0D3A5333A42D23C40D73496E4A95454C033E3858858D23C40B74629BAAA5454C027FE7EACD3D33C401E651EEFA95454C07C535912D7D33C40802BE5E9A95454C0E25ECCBAEAD33C40AAB8F1ACA95454C015424EA1F8D33C402C6E6892A85454C088C47CFA09D43C40015E708EA75454C02E5A2F8513D43C4063E04BD8A65454C0CCB7AFC418D43C40	0105000020BC08000001000000010200000011000000B921F88ED3DE204176CD97BB1CD73841DCF43E55D2DE2041AF8E308C33D738410025A1B8CFDE2041A533D5E86BD938419653E39BCDDE2041E5BEC2B089DC38417527265ED2DE204131F49F9A0CDD38411B477810DFDE2041291BF55CBADD3841019A438AD5DE20411BBA85119DE338412CAECC41C7DE204125AB88213EE4384142059CEEA5DE20417AB5B48AE5E438415CECF73D99DE20410916435161E53841761A481084DE2041404F62E798ED3841B65CAB2AA3DE2041D275B5B6ABED3841B4CB918EA4DE204178C768C718EE3841BDFB3048AEDE2041287371E365EE384112C446F1D9DE204122F7F414C6EE3841A4F503EC01DF20410968B4F7FAEE3841A0EDB1E31DDF20414F93090C18EF3841
543	38010000	2	US   98	98	2	38	Taylor	2	0	27.458	44209.6319	44209.6319044014	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
549	46020000	1	US   98	98	3	46	Bay	3	12.064	14.214	3468.5939	3468.59385219898	0105000020E61000000100000001020000001A00000061C3CCAED96555C06B38BBC57F203E401C77336AD96555C0B0A7AE447D203E40B2335C99D76555C0A897685068203E40F3351E4AD66555C0828DE41D55203E4020A50D46D56555C03EFC915041203E405AA930A2D46555C07E065F032C203E40834FA854D46555C06D23DEDE17203E4004CDE565D46555C04F1CFEBE01203E405E2408C8D46555C08295C0F1EC1F3E40BFD9CBE5D56555C0BCDE3189D31F3E40D663C8D3D66555C038E81FF7C31F3E40D56788B4D76555C086DC8325B91F3E40D746825DD86555C08D032303B11F3E40BEAB4F2FDA6555C0126353699C1F3E403D8773BADC6555C0530C206C861F3E40357FB9E6DF6555C0C539ACDC6F1F3E40C4B722FEE26555C0AC400F415D1F3E409E583F65E66555C042F650914B1F3E408574E8CFEA6555C0F50A5591371F3E40B3BA1E5F286655C041FF930D311E3E40DFF895135B6655C02549B102591D3E407F285B798D6655C057DF6370821C3E4052D2B4849B6655C098AF47F9461C3E40DDF986ABB16655C00CD48D00E21B3E4063DBBB39C16655C0BB809D52971B3E4071C30C77186755C0524B0719011A3E40	0105000020BC0800000100000001020000001A0000006A66B0C3954B28C1E3F4C937974A4041830C6C878C4B28C124968D27904A4041C8B7C1BB4F4B28C1C546D736554A4041EF39C5B7254B28C10F87845A1F4A40412AB9DC52074B28C1D4AD42EDE7494041230B5320F84A28C1A80FA87AAC49404179CDBA71F54A28C1096B366274494041C168ACF5014B28C10C84A9EC3649404133FDB1181A4B28C10B52B443FD484041DF3FA0A0504B28C12EE46C16B74840417C747A897B4B28C1C8CC922D8C484041BA4EB851A24B28C13EFD2F746E4840411293377ABF4B28C1F83CF01A58484041B1B1080A0F4C28C1B6A11A901F484041109032357B4C28C1A42ECF71E347404132AA7CF6FF4C28C19CC1D6FBA5474041B09D2DCC7F4D28C14FC3B77973474041228F1D410B4E28C1CE6626A643474041433A4FF0BE4E28C101B0D3C90D474041CFF0A835805828C15ECF623B4C4440417206AB34896028C114C05E9B07424041E5349AC8856828C1A41CFDF5C63F40419AE2286CBF6A28C12F1A292F273F40419DAD5523456E28C162117639173E4041BFABEA0EC07028C183BF33C24D3D404146043B72A37E28C1CE737EE906394041
550	92550002	2	US   92	92	5	92	Osceola	5	0	0.877	1413.5036	1413.50358496305	0105000020E61000000100000001020000000E000000E7EFA29C9F5A54C03E4ACA05B14A3C405B6836BB9F5A54C043F9AE21EB4A3C4029D75ABC9F5A54C0E2A82957244B3C408CCE3BC99F5A54C055D1B84A394B3C409FD26BAF9E5A54C0054A2DF6134C3C40F440F79D9E5A54C04020A296534C3C40A1F2F4779E5A54C0212BD5F0C04C3C40B96D7F669E5A54C05EF3C3E4064D3C403A3F6B619E5A54C089AE43FC2A4D3C40C73692EE9E5A54C0126C222C404D3C40CE6DA3B89E5A54C0ED23095D834D3C4080B79A9B9E5A54C05461F91FE94D3C409FD9746F9E5A54C0DB05E640F14D3C400DE17F5B9E5A54C09691AB0CF54D3C40	0105000020BC0800000100000001020000000E0000002D5340A2D3E01F41CEB550D021F535412F45EEAFCEE01F4112EEA03264F63541267FA5B4D2E01F41A2E6AC94A1F7354102AD675AD0E01F41BEF56BD115F83541CFE2AC8A37E11F4160C175E0D2FC354153BDFCC141E11F41788731DC33FE35416C9713C655E11F41C4308E8392003641C322667960E11F418507D79716023641583C11CA64E11F419D5E4FD2DE02364151CA12173BE11F413C9E5A6654033641E492F9C550E11F413C97BC25C9043641F2FCC67461E11F419D9CFFB0FD063641DACE00A06FE11F41EDCF8DC62A073641921F0D0A76E11F4147DC64D43F073641
551	10030000	1	US   92	92	7	10	Hillsborough	7	2.267	4.772	4028.9946	4028.99459803835	0105000020E610000001000000010200000012000000ACAD9416809A54C0F7DEC4E2FBFE3B407C3DCB0F7F9A54C02F4758E1FBFE3B4029064720259A54C05F6C59C5FBFE3B402C1C9047BD9954C0BFD8BA76FBFE3B40D26CCC56BA9954C00F898699FBFE3B405B1AD25EA59954C0058E9E04FDFE3B404A7DA246729954C017AE9BF8FDFE3B40DB688F13649954C05F1E87ECFEFE3B4024C8367E589954C0E13B76A5FFFE3B40AC64385B4E9954C0FBD0AA4800FF3B4051848C6F409954C0248E0E7400FF3B407F45E493309954C0BA8355CB00FF3B407CBAB55E2D9954C08413F8DC00FF3B4074ABE634C99854C0E18B453B02FF3B40B90B679FA19854C0C9F7585C02FF3B4031F45F609C9854C074AEC63B02FF3B40F200E634FF9754C0404961F302FF3B4060F254E8E09754C088C17EC002FF3B40	0105000020BC08000001000000010200000012000000C3FEB842536408414F3C4FC7905A34413A8D3608F56408413A466C83905A344100D61C7B529C0841BE08FF6A7B5A34412132631D40DC0841F4EACA27625A3441ACC3A2970FDE0841FA3D7A3E625A34415B7B33E3F8EA0841EDC1BF5E655A34418034A9A36D0A0941FD9D341E5F5A3441C9912AE72B130941914BB833615A344192A24CC24D1A094156736299625A344180185E948B2009413CD53FDA635A34415A5CAB7C1D290941873A81A8615A3441841624D0E032094178322CFB5F5A34418B14845FDA340941EB494CA45F5A344137311D5384720941CFF4FCC0505A34419F42E8A0E28A09417E492C9D485A34419F99F0561D8E094189FA40BC465A3441869DDBD8DEEE09412E8E86B5275A3441672748B885010A41AFB5C9E21F5A3441
554	13130401	1	US   41	41	1	13	Manatee	1	0	0.403	648.9698	648.96980806815	0105000020E610000001000000010200000009000000AE449B2E06A454C00F7D1A26117B3B40643D0BD403A454C018C99A731F7B3B4050E71E6603A454C06B88B0713E7B3B401326234A03A454C033C05BD85F7B3B4022038E4A03A454C0A4DF47B1607B3B402D1DE35703A454C0DB5372AE7C7B3B40FEA524C603A454C0F670A8025A7C3B40547B92E603A454C0E57241E67D7C3B4038124EA205A454C0A1BC947D8D7C3B40	0105000020BC08000001000000010200000009000000FB865FE6053D02414DF77CE9EB803141BAD6EE99823E024180B03BAE3A813141E8EB3DE9D73E02419BB41387E68131412B314AE2FB3E0241DF854CD19F823141F2D86719FC3E024161EAF084A4823141300D2A7E033F0241663A5AD23F833141C3AAEFFB3A3F0241A9CA97EA0B883141DCDFEFFB3A3F0241F16EBC11D388314133D7E13E313E0241BC802F012A893141
557	14050000	2	US  301	301	7	14	Pasco	7	11.342	13.476	3433.1656	3433.16558819289	0105000020E610000001000000010200000010000000A76325B7FF8B54C06067B6E0FE523C40414AD44BFF8B54C067F676D80D543C40F3A49148FF8B54C03330031416543C40583893ACFE8B54C08F01196BAA553C40CC4B47DCFD8B54C0E43B6D13D7573C40981057B5FD8B54C00B9509203F583C40E2635DCFFD8B54C08FB1264D80583C4087B57955FF8B54C00C0213EE00593C40E2610294FF8B54C0FD69921025593C408ADF9091FF8B54C07A87BA5255593C40257A0EA4FF8B54C07B61B3EE905A3C407D7457A7FF8B54C09BB2F772A35A3C40D7C8DBA7008C54C0605D4A27B15A3C40117BF614018C54C000D256CACA5A3C4045729B11038C54C04AA17F9BE65A3C403BBCAEAF038C54C0A891E691EB5A3C40	0105000020BC080000010000000102000000100000003FF655470FBB10414D0260B7A32936414A61185B6BBB1041F24B0812832F3641ECCC43276EBB1041C481E7BEB02F36417C7C464AF6BB10419C9C201174383641BF8483BFAFBC1041B1A6F477844436414E5BD76AD2BC1041A5D41DBFC54636417C5EE1AAD8BC104127DFEA632F48364158BBCF147DBC10417322595EF94A3641406741CA71BC10417693F6E7C14B364158B6CF147DBC1041EC9864A9CD4C364106407C5BBCBC104184E728CEA4533641A2F72765BFBC1041ADBEBF8B0B543641AA61E7B273BC1041AE5EF3C657543641BA02C4D457BC10413D9C8A1AE65436413F9242E0C1BB10414439FFD3805536417469067892BB1041E676457B9C553641
561	87120000	1	US   41	41	6	87	Miami-Dade	6	15.163	18.121	4760.4211	4760.42110780577	0105000020E610000001000000010200000019000000EBED1D453D0F54C027A8DD1EE4C3394029FB633E3D0F54C0C83E641FE4C33940B249B17CC40E54C0E6DB28A2F2C3394033C9134CC20E54C0824995E5F2C33940F5FE1EDA3D0E54C0EC2B105D00C439409577D37AB90D54C0C9B0C0B70FC43940EEAA120C860D54C07073C70015C439403F6B79FB630D54C06C7EA04C15C4394093266590460D54C00368AAAE18C43940AD5A7C55060D54C0BA3E072920C43940766E75D7D80C54C04E80C69425C43940864E5F60D40C54C00FDFF01D26C43940537EF808D40C54C0A7C43E2C26C43940B7867BCAD10C54C0E9BCFE9D26C439408B6BADF6CE0C54C0AFB0AC0027C43940EA3AB320CA0C54C0D53F5CCB27C43940AECBB782C40C54C012C94C4328C4394021D4A620BE0C54C069BDC0DC28C439408590208AA20C54C0574911AE2BC43940C921A1A5840C54C0216871142FC439407C2CDF7D5F0C54C09AC6C88E33C43940F18C025A4E0C54C0304A0BD036C43940219E1367490C54C05D30B2A134C43940553E18A5350C54C001E2CD4225C439400501E467340C54C0723B134C24C43940	0105000020BC08000001000000010200000019000000FAA5A92538AD2B418F18C96CD4CD1F41A658DD3339AD2B41AB9C927BD4CD1F41CBDDD0BC2BC02B4193D366C04ECF1F4181747EB383C02B41462C119F55CF1F4124CF3BE24BD52B41D29D9DD1BED01F41A9B53E0011EA2B413449258252D21F41DA1AD7FB22F22B4127583F70E0D21F411A9471897BF72B4193078369F7D21F41FA4DD53419FC2B4131F3B3A850D31F41546C3C2F2D062C417EBF09AA15D41F413BF0137F500D2C413CAD170DA4D41F411414EBD9030E2C41B2D8181DB2D41F41B1F65B90110E2C41B8C00785B3D41F41185A0DB16B0E2C4110378B78BED41F419DD6A341DD0E2C414DE29766C8D41F41AE5B587C9F0F2C4108DCD252DCD41F41BE37E91F81102C41EEB23975E9D41F414477FD8681112C413C9D22DFF9D41F414C3CB6B2D5152C41C79D01DD45D51F4175E7AC6A861A2C41DB173EEE9FD51F41FF7460D85A202C4159F1388415D61F419B222D3C0B232C410CC9CB2866D61F41BB36C835D2232C41AF02463638D61F41AF49A008ED262C412CE838F7ECD41F41218048E11E272C41A4D73932D8D41F41
564	90040000	1	US    1	1	6	90	Monroe	6	0	11.713	18908.3479	18908.347872911	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
565	72070001	2	US   90	90	2	72	Duval	2	0	0.114	185.8167	185.816741479444	0105000020E6100000010000000102000000070000001163C9A71B6A54C00EFF0B0983533E40695391AB1B6A54C033411FF47A533E40F208391C216A54C07CF5752740533E407493E083216A54C0C8EA8C283B533E40A6D73771226A54C0F56DBD0432533E408F714637236A54C05001C72026533E407E8A79B2236A54C02E9F054119533E40	0105000020BC08000001000000010200000007000000EF852C802D611B411081963D30A04041226BA1522B611B41EE01F9D019A0404180FFA1B6805F1B413FA7CFF6769F40418BA28EE1605F1B41DDB3E51F699F404185A01D4A185F1B41D2FCADD04F9F40417088ED29DB5E1B41327F65DD2E9F4041BE3C776FB45E1B418BB4422B0B9F4041
566	72040000	1	US    1	1	2	72	Duval	2	15.895	15.968	117.4302	117.430220522528	0105000020E610000001000000010200000003000000D6B2C66DE86954C0BAA6F4BB2D553E409F792282E86954C08DE6FCCD2D553E407606BDCAFB6954C02D41BD4E3F553E40	0105000020BC08000001000000010200000003000000E4C9800CCE701B41133FE162CDA44041D146BEEEC7701B410EFE0B96CDA440412C0F7CE6FC6A1B41B5AAC539FFA44041
577	36220000	2	US  301	301	5	36	Marion	5	8.571	8.76	304.1787	304.178661856149	0105000020E61000000100000001020000000600000078AB1C91328354C0D9B36F9DE80E3D400FEF07ED328354C0F905880CE90E3D409B55EA083D8354C09A5C7DC9F40E3D400701F4BD468354C0825AF116FD0E3D40AC18D7CE548354C05C47B08C070F3D404288224B648354C03A7F887D120F3D40	0105000020BC08000001000000010200000006000000E0CD9BE020931341C4314520AE3A3A413FFF5AF4049313410886AC98B03A3A41B827C5B8F28F134188EB0C7CF33A3A415BFC7B26FF8C134104B6983D233B3A4126E8C2FFB7881341259508BA5F3B3A418D57903602841341FD824E219F3B3A41
579	87030001	2	US   41	41	6	87	Miami-Dade	6	0	0.286	463.3192	463.319163115478	0105000020E6100000010000000102000000090000003D6AA5E4FF0B54C02111729BCBC5394036ABF4C5170C54C0BDA6D2BCC8C53940F706E6EE190C54C0BC009C40CBC539403D40D5302C0C54C0883C3560CAC539401BAFF5082C0C54C0034B5844A7C53940EBD4EAFA2B0C54C0181C57E49EC53940007453492B0C54C0C48E4C8D8DC53940ECC7E8BD2A0C54C03F6730D282C539409B61B7F7290C54C09B6DAB8D59C53940	0105000020BC08000001000000010200000009000000BFE33CA83F2F2C41EED80BFAA0F91F414528E881802B2C41CB52E87E55F91F41B4535B90292B2C41626A66378CF91F415522CE274C282C41E9DFACBF6FF91F4131475ACE54282C41F3A949F664F61F41711EA49457282C41143F1232ABF51F412F9EBFA174282C410E79EFDC2AF41F41BB0CEB3D8B282C41CFBF30133DF31F41CF495728AD282C4118C511F7A9EF1F41
589	02010000	1	US   41	41	7	02	Citrus	7	13.136	13.177	65.9142	65.914239987809	0105000020E610000001000000010200000005000000FC6B5BE1BE9554C0E8F91B7805D63C402A160F4BC29554C0F6F3C4860DD63C40D828151DC59554C0AFFAF98D11D63C405C8FA037C89554C0EE630CD318D63C401031D65CC89554C04CD6383F19D63C40	0105000020BC08000001000000010200000005000000261BCAF1E0BB0B4114466D92AC023941ACB84B5CCFB90B41B2E0AF08DA0239416B9CDB6518B80B41E34E0802F102394199B767C436B60B4118F448081A03394172D9C44020B60B418F54BE681C033941
597	15045101	1	USA  19	19A	7	15	Pinellas	7	0	0.235	379.4527	379.452665847342	0105000020E61000000100000001020000000E00000073DCE981B7B254C02543D8EAFFF53B4032D0C9E8B8B254C04A723D0501F63B40D7A4701BBBB254C0AE6CFE3C03F63B40F0668DADBDB254C0C0652A6C07F63B40F61B5CD0BFB254C0AF9632520CF63B4088E5FC19C2B254C00626DF9712F63B40F4746945C4B254C0BAAC35BC19F63B407A535956CAB254C0C66C4AD933F63B40DF7C4A3CCCB254C02F0E1F0E3AF63B404B30B59DCEB254C0107C40493FF63B40B7D49A5AD1B254C0B61242AF42F63B405D1ABEB6D4B254C04CA2D4A143F63B40D8AC2690EFB254C0A60C600643F63B40715E81C6EFB254C03DC9FD0343F63B40	0105000020BC0800000100000001020000000E000000FC2E337CB4EBF240413486F2FA2E3441F9DAFFE0FBE9F240497D4E79012F3441E2582FB949E7F240F926796A0E2F34416640148C24E4F2401985B660262F34414EA2EF6689E1F240A89B752D422F3441D6291B3BC0DEF240AAE3B2A4652F3441BBD4EC651DDCF2409BEFC4E68D2F3441FD39629EC6D4F240F8E5658F20303441F218E22778D2F2409424648C433034419E39715590CFF240F9028D4361303441916C9C7135CCF24066BA0BEA74303441E926403713C8F24060400B257B3034419C43863000A7F2404676FC8C7F3034414EE1283ABDA6F2405FB8818F7F303441
609	10003000	1	USB  41	41B	7	10	Hillsborough	7	0.424	0.483	96.568	96.5680489751582	0105000020E6100000010000000102000000030000008CF73DE8B89C54C08B475C941BF33B4006E67240B99C54C0B28969A32CF33B4034728336BA9C54C08658BC8154F33B40	0105000020BC08000001000000010200000003000000F844A133E6FF0641DE7EC03E2F193441EF2F5BDAB8FF0641E31CA1F98D1934414DB24C4936FF064104ED2A686B1A3441
618	72090000	1	USA   1	1A	2	72	Duval	2	6.126	6.447	516.4186	516.418603987519	0105000020E61000000100000001020000000E00000072DB1C25C26854C0EC217F42B0553E40BFBF4738C26854C0E9D796C0AF553E40FB680317C86854C0C4B7FDEA37553E405FB3FDAAC86854C04986915626553E40731464AAC86854C0BB4B8D3E12553E402EA2851DC86854C0093E6AB0FC543E408EC28422C76854C08BDF527CEA543E407989B9D7C46854C050908948D2543E40924ED638C26854C00A110160BE543E40FB0099FABE6854C0BB6B0EECAA543E407B9CA034BE6854C03B6E675FA7543E40C6917BD7BA6854C04E2C2EEE97543E40FFD69F7CB96854C0AF6201B792543E40B9270B97B86854C0496CBD3C8F543E40	0105000020BC0800000100000001020000000E000000264871E168C91B41C42AE76F27A640418248F20C63C91B41D851790826A6404165AB8FFD8FC71B41D9F9FAD5D9A44041E8D5C54661C71B413CA04716A9A440419CF096F35EC71B4124E1B55471A44041CED5BCA586C71B41FCEF737D35A44041494DE3E5CFC71B4109F621ED02A440412A9C956E7DC81B41624A70A5BFA3404132F9D9CD44C91B4112D8654388A34041EF1BEE2D3CCA1B417DAE411C52A34041E8B6454D77CA1B41D25D3F3848A340410805217A78CB1B41469764301DA3404135D57E30E0CB1B41C220D7A40EA34041F24808D524CC1B416E5E26F204A34041
619	15090001	1	US   92	92	7	15	Pinellas	7	0.13	0.228	157.5983	157.598273114492	0105000020E610000001000000010200000007000000DB42FF0BCFA854C06B74826007DD3B40C599AF89CEA854C06C0D968909DD3B40BAFF2E5CCBA854C02B9DEEA516DD3B40F247D96DC7A854C09C52BC3623DD3B409B633790C2A854C070E0F40030DD3B40E65B3179BEA854C0A1EAAD2F38DD3B406AFE6D6FBAA854C01151D1773FDD3B40	0105000020BC08000001000000010200000007000000B32BB9523E02FF40434B3D07AFA13341DE7D8C88E102FF403EE0B7E1BAA13341A0A7E4F7DB06FF4067937CCA02A23341168BD279C30BFF4065B0327A47A233416472BD3FD211FF40BD007E298DA23341B3201FB6E616FF40F7C08B7CB9A2334127A77FC1E91BFF40E1B4B3D3E0A23341
627	48003000	1	US   98	98	3	48	Escambia	3	0	0.496	802.1345	802.134529938436	0105000020E6100000010000000102000000050000001E2266CA26CD55C0F93E44557F6A3E40DE0F831E2BCD55C06D65B04DCD6A3E40A7256BA02FCD55C0E84A37321C6B3E401503D58236CD55C0A87A3F00956B3E402D70E91841CD55C0564FE5BF4E6C3E40	0105000020BC0800000100000001020000000500000013B9BD36E4DC33C193ECD4F7E3474141EF0BF7D61FDD33C1A08A903CBF4841417771A0A15EDD33C1F502AF2A9D494141CFF37D6FBEDD33C130244BFDF04A4141C440B9BE51DE33C10022F27FFB4C4141
628	79040101	1	US   17	17	5	79	Volusia	5	0	0.411	658.9642	658.96421368366	0105000020E610000001000000010200000011000000FCD4AD88B45454C0F0241C1BEFD63C40EF3E0054B05454C01504098418D73C408007F729AC5454C01846EA613FD73C409E9AF517A95454C09F42BD155ED73C4000AD4946A75454C029892D6273D73C40B4517312A75454C08E5673C175D73C40E1D2627CA65454C0BDBE0FEA7BD73C40652F9FEBA45454C0E5BC979992D73C40105B5120A35454C09ED07E2DABD73C40EEEE36BFA15454C0DDF081E9C4D73C4033FCF56FA05454C00AD05D83DED73C40C2CF3F8F9F5454C0B80EE458F3D73C407B1165019F5454C0779D850503D83C4077A41ABB9E5454C0FF9A248A0CD83C40B0C05B329E5454C0434CF32021D83C407C7E17F09D5454C04DDE311E36D83C40DD5CD3139E5454C0D4EC3C9869D83C40	0105000020BC08000001000000010200000011000000E13EC1CA1CDD204134ADE3A2D6FE3841C7A54569C2DD20418DE8A529BCFF3841235BBC5366DE20411267E494930039419FA7D43EDFDE2041752302C33D013941732025FA26DF204193D87FD5B30139410AAD4DF62EDF20417B7804FCC0013941A4C07B0E46DF20414166671FE30139410542B6EB83DF2041C96D7AE76002394125C533C7CADF20418024D82BE9023941A1B41B7501E02041345ABAE077033941D003526835E02041743C13D905043941B7B1B15658E02041339EA06479043941435A30776EE02041B226FE53D0043941E073817B79E020419DAB211F050539415D822EFA8EE02041EBDA625377053941D8839AB999E02041E42FB8C3EB05394187E1C9D195E02041A7C7106009073941
629	12001000	1	USB  41	41B	1	12	Lee	1	0	1.029	1657.0529	1657.0528683239	0105000020E6100000010000000102000000060000002C2950BF6C7754C07AACCAE780A53A4069CF41767B7754C08B5619EDD5A53A4092A62AB7B07754C0467CB49A09A73A4005BD749AF97754C0BC55796BB2A83A40F842DFBEFA7754C00396D0A9C2A83A406590FE0EFB7754C0089CC16EC4A83A40	0105000020BC080000010000000102000000060000005829ABB1B4C81641A043B08F42AF294159A6E5022CC41641432C02B9F5B22941BD834A9EC3B31641A97C136859C02941B15989B24F9D1641F22C19FBD5D2294158B1FF14F79C16415E9CD97D8AD3294170C2D364DE9C164159FB79349ED32941
631	34010000	1	US   19	19	2	34	Levy	2	0	8.199	13203.702	13203.7020273464	0105000020E61000000100000001020000002B0000004BE37DF94ABB54C0122269A83E973D403C7AA50546BB54C0A14F070039973D4000FF248D41BB54C00504F7F932973D402E4B23AC3CBB54C05ACA18322B973D40B8775E2938BB54C0976D381F22973D40F54234AD33BB54C0211F374017973D401573562E2DBB54C0ECA03E8503973D4043A375D228BB54C0F50B1DC7F2963D40B10B9E2425BB54C06CEF74FAE0963D400DD5797121BB54C04850BDCFCA963D40F40B60CE19BB54C0B7D6104099963D4041F6057EABBA54C0F8603741CD933D4048AA5DDB58BA54C08784F916B4913D4067DD3A6FD5B954C0CF12BFD75D8E3D405B3F3583B7B954C0C4B5D8219B8D3D404FF0E45F10B954C094CD7AB85C893D405A7F37A5ECB854C027E9081C74883D403BF1C0B561B854C0FE978A73EB843D40251148FB09B854C09624B020B0823D4016B6C91401B854C0FB595C8075823D40B18B58C1F7B754C04AE1CF5233823D4005C8B833F3B754C09D65FFE90F823D40D704E894E9B754C058D61DF8C1813D40FD89B33EDBB754C0D1D728B84C813D40F1C4F1D3D0B754C01218F0D9F7803D401EDD6AA8B6B754C0EA62E0ED21803D409FDD68C9AAB754C07682334BC27F3D40B50093ACA4B754C0FD72E143927F3D400DEF79079FB754C0AC216BD86A7F3D40450DB0BF99B754C07B6390C7487F3D400CAF8B6C94B754C066F1A47A297F3D40C778A4BA92B754C02E664F841F7F3D40AEDB422A90B754C0AE07A40E117F3D4073B782C086B754C0C92D024BDF7E3D40EC7E5F7280B754C0B290A613C17E3D40090391CC79B754C053E831E1A27E3D40985F102872B754C07FD5A07D827E3D4067568B6F15B754C0F35E4B6A007D3D4093EA9A6011B754C09E5EDB97EE7C3D408F8BDFBF0DB754C0CDC65D5FDB7C3D401281D8530CB754C052B1A3D8D17C3D40B4BA14490BB754C06C4E2290D37C3D4050A0CB0C09B754C041D48273D27C3D40	0105000020BC0800000100000001020000002B000000D9141ED28966E540237E27872D3D3D41E4DCD8567C72E540D4787A870C3D3D41B61DDC9B427DE5405BBBA3A7E93C3D4128A9E32E0189E5401C1B99E5BC3C3D4194ADC85FD793E540C4C1BF14893C3D41C65F8E41989EE5405D51304C4B3C3D41CBA962791FAEE540F66CDCB1DB3B3D41079ABBC380B8E54013CBE55C7D3B3D4148D09CD138C1E54027FB7C62193B3D410FED7DDFF0C9E540C453BE289D3A3D41A0CCFC26E5DBE540D990109E87393D41136CC6C043DFE64011929924DE293D4115ED2A2996A1E740F9E5063B1E1E3D41C9663539B4D6E840E6BE51F36E0B3D41DE7665B4171DE940BA8ECAB92C073D4172A67F1C5DA6EA4068BC33D269EF3C4142BDC78172FAEA4026A6797953EA3C4105084B5F7841EC40CE2AE99C8AD63C41AA9AEDE20210ED4034CAF2180CCA3C41ACF634D7F524ED4039A261EBC3C83C41420954BEDB3AED40270919B251C73C41958080E48345ED4065E648BD8BC63C41DB662246FF5BED407375A51DD8C43C41594A895D7D7DED4080AFBCDD48C23C41AA1D7E67D495ED406EDA2B926EC03C414EFD79FBF8D2ED40F4704613C3BB3C4131A63C99B9EEED409672C391ACB93C415896A07007FDED40BF0C6917A0B83C418D0E9E374B0AEE40E7F3758AC3B73C41139DA4C8BB16EE40F0B2E8D104B73C4146805ED64F23EE409D64196F55B63C41D2F261D35027EE40C36CCF9C1DB63C41BA94731C612DEE4060C0F68ECCB53C41AF69B47EAD43EE40F9169F6BB5B43C419C550A1DA652EE40AAB765BF0BB43C416F7544AA7362EE4010592C1362B33C41FA768F5CA574EE4010986CEDABB23C41DC0A0C577851EF406FA2A54730AA3C410E1F9336205BEF40429E7D1ACCA93C417303F48CB863EF40CFE3554C60A93C41A56D69581167EF403937DCFB2AA93C41613DCFE99D69EF400049503034A93C41EEB5FD3D086FEF404A9FE8522DA93C41
633	26030000	1	US   41	41	2	26	Alachua	2	26.189	26.418	368.4249	368.424875116936	0105000020E610000001000000010200000003000000F218D50F33A654C0C9B5102DB9D33D4008DEBA6E17A654C0018BEFD977D43D4027F578E416A654C0E24A0C9B7BD43D40	0105000020BC0800000100000001020000000300000011EA94BA00490241B608D9D79D863E41734BA0962C5A0241264425B1B88A3E419BAA3F87825A0241774D5062CD8A3E41
634	29001000	1	US  441	441	2	29	Columbia	2	0	0.363	586.5993	586.599346303936	0105000020E610000001000000010200000003000000ADF0A2DB2DA954C09B452B86FE333E404FF03A7A2CA954C0BF905CF7FE333E40C50E5B39CAA854C016C9D0BF13343E40	0105000020BC08000001000000010200000003000000B3A45466EDB80041BA9F5A12E14E4041AD4E91A8C2B9004167094E1BE24E4041A0367AF205F50041C84CB3220E4F4041
637	72050000	2	US   90	90	2	72	Duval	2	8.294	8.67	606.3075	606.307510302737	0105000020E61000000100000001020000000900000056961E9E086A54C035442D0073533E409D625A9D046A54C0574A4F42A5533E40D46D82F8006A54C0868B1B58D7533E40F58B666FFD6954C03F82D8C207543E40EEB10E01FA6954C015025EE837543E404E755C61F66954C029F40F1069543E4073C98BFEF26954C09C854AE599543E4040725649EF6954C081729A88CC543E400E0D1D26EF6954C08B54AC7ACE543E40	0105000020BC080000010000000102000000090000006B3D85E1E5661B41E3C797AF02A040415562ECAD20681B41D68745EB8DA0404133F9E6CA3F691B411EB212B118A1404181D6AE57566A1B41854A70D79EA14041B058EACC646B1B410F5A403F24A24041D1D6B83B826C1B418392B670ACA24041196C8D4D8D6D1B410C2FC1C033A340416689E863B16E1B4116856A0EC0A340411535DF3CBC6E1B41A3FF7E72C5A34041
639	10080000	1	USB  41	41B	7	10	Hillsborough	7	3.307	3.995	1106.3949	1106.39488625709	0105000020E610000001000000010200000011000000BE7B6820579D54C0266E001958F23B404ECC9B00579D54C0DA971C4658F23B409D9A04B73B9D54C0A6B2F8017EF23B40CB816A4E399D54C074A1E75C81F23B4030CEB8F92D9D54C0D55DD7D890F23B405CC33E14209D54C080F40FD6A3F23B400843F652129D54C0FA814C5CB7F23B401562FE59049D54C002521681C9F23B40C284582EE69C54C08462387DF3F23B40B55A9E54E29C54C0219EEFD1F8F23B4017853E10CD9C54C03156564316F33B4088A9B583D29C54C0DED3D24647F33B404D5604FBC69C54C041CA94C654F33B404CA3AAF2C39C54C0F4D11C4E58F33B4039BE4D5EC09C54C0D08F0B155AF33B40F917815CBE9C54C0FDA8589C5AF33B400B0BAC03BE9C54C025F23D815AF33B40	0105000020BC08000001000000010200000011000000F20074F50C9E0641BF015FB61715344162722CA3209E064120E62EA9181534414099E90103AF0641AAA47F9CE3153441A9B7368B80B006413EDC67A9F5153441E355074083B7064125BBEBE9481634411652944E1CC0064145B62B03AF163441B862DB579FC80641510C9B1D18173441740D23EF43D10641F08C5F827917344111C9E4F5EEE30641DF2AB3645B1834414732F3DC50E6064112C50612781834416D69957679F30641F9FF34751619344147DB77D737F006419F8C60AE271A3441DF3ABB7059F70641826901E26F1A34410B3FC46E39F90641E7BCB6C1821A3441890F70BB6EFB06419C8BB4C78B1A3441CEF72B72ABFC06419D31583E8E1A3441A84C8619E2FC0641F02533938D1A3441
645	53050001	1	US  231	231	3	53	Jackson	3	0.566	0.939	603.0416	603.041638397937	0105000020E610000001000000010200000010000000831FFD6C2C5655C0539A4D2E62D73E4074C6A0C32C5655C090698C7063D73E40FADF20CB2A5655C01E30103C79D73E4070FC170B295655C06487019A8FD73E403D1930B8275655C08EB4D1F0A7D73E40F9865C24275655C03BA81E24B9D73E407F1DC6AB265655C00CF065E4CED73E40181106A4265655C0A893D4E1E7D73E40ADD3A537275655C05E18BCEA00D83E40B8D4DA5F285655C03A776B891CD83E40D2CFE3C5295655C0D4A7D14230D83E4011A274032B5655C09327200E40D83E40667AE9772B5655C03A092DD945D83E4021A767882E5655C089EBED2561D83E4050536C72315655C0052DD04477D83E40817B02EF395655C0EA5AF3D4B6D83E40	0105000020BC08000001000000010200000010000000EF6C3431509F25C1F1E086C0D240424130D451A15C9F25C15E7E5660D64042413BF91297079F25C145C3C5331241424106AEA1C3BA9E25C1B5E831B34F4142410E2006707D9E25C1128D4CD69241424168301AD65F9E25C1EEB0A46AC2414241679F9558449E25C1BD7953AEFE41424188F6945C389E25C155862B1C44424241F5CCF1A3439E25C1E58BF4E3894242418B8A6B10649E25C1BBC62D12D74242411932062C919E25C18D19E7660E4342413C63DCEAB99E25C14988D8C03A4342411877DDDBC89E25C1B7F35D054B43424119F66F96329F25C1C04F6E0698434241BC0A29CB989F25C12644E594D643424154880CCFC2A025C18D46E8608A444241
647	72090447	1	USA   1	1A	2	72	Duval	2	0	0.516	837.9039	837.903855540414	0105000020E6100000010000000102000000080000001F41A8CE666754C0A879456B1C4B3E40BFE6459E626754C0ED488937454B3E4011B7F12A616754C02125E100474B3E4046B4B8345E6754C0DD4F0DFF644B3E40B3571CF8566754C0A17F5345AB4B3E4016FD609B456754C0F7B55C57534C3E407883471C366754C0039745C6D64C3E40B6D553E1336754C06DFD912FE94C3E40	0105000020BC08000001000000010200000008000000D9D62B33A3301C41294C9D56BB88404132301FE2EA311C419C79FE522C894041F3F011DD5A321C41D2D5A23431894041DA965DAF42331C41735E2F46848940419270F0BC78351C41712053E4468A404124D63CAFC63A1C414816E657188C4041EAF1576C803F1C41D334D83B848D4041BE5C6F772E401C4186227934B78D4041
648	75020001	1	US  441	441	5	75	Orange	5	0	0.207	333.1977	333.197715774704	0105000020E61000000100000001020000000A00000012DF19B3E55F54C02DEBF4EE46AC3C408458474BE15F54C0B66CAEBE43AC3C40C69D7BC7DA5F54C0A4D1CC123EAC3C40B049E201D55F54C0A64F99A637AC3C40BBE8FF9DCF5F54C06F48F25530AC3C40B82A5222C95F54C00A5B1DC925AC3C409051F5B1C15F54C0FC5C0D1417AC3C40F64AAE1CBB5F54C082602DED07AC3C40AC6834D1B65F54C02CEBDC9FFCAB3C40706958B2B35F54C00C739513F4AB3C40	0105000020BC0800000100000001020000000A000000EDDEB038734B1E41F1A66E16ED123841D0D29ED4CB4C1E417F738609DB123841BC7B9257C94E1E41413B300ABB1238410ADFB39E8C501E418F3973EF9612384162E0FCEE31521E415A1A48E96D12384190A9D3832C541E41D91C91D9321238411E41FA8A71561E41C0CA92A5E01138417B79458873581E413593140C8C113841C278E6BAC2591E41AA4B49FE4C1138412A6A993FB65A1E414F8691501D113841
650	36030000	2	US  301	301	5	36	Marion	5	0	1.23	1978.0765	1978.07650618148	0105000020E61000000100000001020000001E000000BD6F6C1CFD8854C03D0A74A1E22D3D4094B80775FC8854C044FCE2947D2F3D40B58C674DFC8854C0E511493CB02F3D406138424CFC8854C0B528FE06E22F3D40DF9B1D48FC8854C095A93006EA2F3D4089B08D14FC8854C0AD002E434E303D4063EFD017FC8854C029478F4F51303D4091E8C117FB8854C00439269153303D405C36FD19FB8854C08445670166303D40CAAE2748FB8854C0A8D7DB9978303D405F2FEFC3FB8854C0C5B346F38E303D401C9B9F7BFC8854C0DA9904EFA4303D40B5C5008BFD8854C0C48D6D3EBC303D405BD7C5C9FE8854C0B1623E8AD1303D40CDC20E3E008954C0F2DAC4DCE5303D40CE794CFB028954C08C93E1F40B313D4069A21041058954C00CC3F7A327313D407FCD11380A8954C034F9C9C867313D4043388E0B0D8954C08111F32C91313D405900E0490E8954C03C4A72CDA5313D403F759FC80F8954C0B3FEE42FC1313D407ECF2EA7108954C08AE356C5D0313D40E289A388118954C004308D71E4313D402837ED65128954C006F7D0E6F9313D409E25A241138954C09AB07DC914323D40122909E4138954C05EEF1F4B2B323D40B4D5E308148954C0BCF31A6932323D40D272FE67148954C0AC7239C744323D4023ED1EB0148954C08BEBC66356323D408FE924BF148954C0782B541769323D40	0105000020BC0800000100000001020000001E000000983273340AD611416D5A10F49DE73A41220D1BB095D611419A1AD33386F03A41ABDF5DA9ACD61141DFF8A7409FF13A41B07E24BDB7D61141FA8A268CB3F23A4172CB08B9BAD6114197874DEBDFF23A4115477F03E0D61141F98BE01A0CF53A412B7276ADDFD611415589D6051DF53A411A4A0C172ED7114121A47A5A29F53A4168B2406231D71141C659AFAB8FF53A41CD1B4D5727D711412BC746E4F6F53A41C2DAC27C06D71141465DF1FF72F63A419411B052D3D611418DD2211FEDF63A41296F34C285D6114198B4BBAB6EF73A41D9F1BA5629D611417E344214E5F73A416C90826CBCD51141F0ED971F56F83A41A8786F3BEFD41141DA9DEB062AF93A41AEBF332844D4114155F56113C4F93A4144BFCB32CFD21141D0C266F328FB3A4170E419F5FBD111414A88AE2A0FFC3A411367A0899FD1114198138BDC81FC3A41DCA04AF830D111410F78261A1AFD3A417B64AD9AF0D011412BBAD0BD70FD3A41A630663DB0D0114137019212DEFD3A413465928771D011415CB3BC4E55FE3A4154F6DB7834D01141AB3F7BA8EAFE3A4170658EE807D011417777B1AA67FF3A410E5FB23AFECF1141F222E42F8FFF3A41EBD69640E5CF11413A55162EF5FF3A41B189BA1AD3CF114129F9D3F556003B41DD729C91D2CF11412637EEBEBE003B41
652	72080000	1	US   17	17	2	72	Duval	2	0	0.819	1319.7048	1319.70479803836	0105000020E61000000100000001020000000D0000007606BDCAFB6954C02D41BD4E3F553E40A2D3CD4A4E6A54C07404300986553E406D24416D746A54C06318EA81A6553E4030167C33876A54C06B28F4C2B6553E404748C4639A6A54C04853BA42C8553E406DF62A6B9E6A54C01D8220C3CC553E4030B183A3A16A54C03BBC4093D1553E4018E491C3A46A54C0F0584B21D7553E40E585B324A86A54C027A595E5DE553E40AB0848E4C46A54C03339844B2E563E4012AA8D4FC76A54C0FCB0F90B35563E4079E6E4B8CB6A54C0598D6AE941563E402B93392ACC6A54C04CCBEC3343563E40	0105000020BC0800000100000001020000000D0000002C0F7CE6FC6A1B41B5AAC539FFA44041339745A833521B415EB0B217C8A540416F661BADBE461B41D2B06E5624A640419ECD1FC31A411B4178C9457F52A640414645431C573B1B416976FF2284A6404131F5C662213A1B41E6BBF2DA90A64041F58F56FF29391B41BE7C70649EA64041E782AE033A381B411A208CFBADA64041B734C8BD36371B41E9B692B9C3A64041DB09C3E69A2E1B41D676B7AAA1A74041FAA19478E12D1B41E17AF689B4A7404123E6EB618F2C1B41BFA0AA7CD8A74041B38279746D2C1B41574D3118DCA74041
658	87270000	2	US    1	1	6	87	Miami-Dade	6	0	0.145	233.2612	233.261222179909	0105000020E6100000010000000102000000040000008FA7C6D08A0D54C018BFF3BADABF39407CF167AE6C0D54C096C97855F6BF3940A81AEA59660D54C0A52BF868FCBF3940DDA460EA650D54C05CFA4E14FDBF3940	0105000020BC080000010000000102000000040000005CAD7533ABF12B41999572DA14751F41346C843164F62B413B088BB587771F41381BF72262F72B41F9DD728D11781F41BC633A9973F72B41ED0F329C20781F41
27	36040000	1	US  301	301	5	36	Marion	5	14.143	16.652	4051.2188	4051.2187738078	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
261	16100001	1	US   92	92	1	16	Polk	1	0	0.912	1471.0337	1471.03373828148	0105000020E6100000010000000102000000050000001E9A82F95C7F54C03507E5289F0A3C40029C5B0F5C7F54C0717CB6C8AB0A3C40367737985D7F54C0A7F492BAF30D3C40ED14CB785E7F54C0DB389FCFFC0D3C403AF331305F7F54C0FCCED5F2030E3C40	0105000020BC0800000100000001020000000500000034552684848E144170714CB7DD953441BE992ED4CE8E1441E33ADC9B23963441A9425F70ED8E1441B91DE0D757A83441DC3CABFEA98E1441B8311F5F8AA834415B6AA8DD728E1441B472CE15B2A83441
82	92090000	2	US   92	92	5	92	Osceola	5	14.635	15.386	1208.6529	1208.65292412402	0105000020E6100000010000000102000000080000003F9C95FF9F5A54C0F2B65338F14D3C409FD9746F9E5A54C0DB05E640F14D3C4018518929675A54C0F5DB68ACF14D3C408C5E1C21305A54C0E15A3F45F24D3C40B3AB435B195A54C00DC58888F24D3C4051F48ECF085A54C021065067F14D3C40EA3EEFE9F45954C029E60725F04D3C40101FEA09D65954C08740E350EE4D3C40	0105000020BC080000010000000102000000080000002B392AD5F4E01F4108B50DB22A073641DACE00A06FE11F41EDCF8DC62A073641B7E854EE65F21F41217E516229073641610853B0A4012041CA2A6505290736417C350238230520413DD69DF728073641BEA74A18AD0720419E28AC9A2107364164AF859ABA0A204199F6714E19073641FF362A50770F2041880876210D073641
291	15045000	1	USA  19	19A	7	15	Pinellas	7	1.402	1.697	475.1033	475.103311990912	0105000020E610000001000000010200000004000000AC24DA6DB7B254C0F5B73FBDF8F53B40BD97833DB4B254C0A65BCC1BFBF53B40C38CE8E0ABB254C065777C65FBF53B40F1FF6E6468B254C048CDE9D1F8F53B40	0105000020BC08000001000000010200000004000000A92D3ED8C3EBF240E2C5F617D32E344140516C74B4EFF240B89AA251DF2E344106CB938401FAF240BD8EAC7FDE2E3441E2352E6E1E4DF340B5C887B7BC2E3441
311	93020001	1	US    1	1	4	93	Palm Beach	4	0	0.413	662.8373	662.83730021329	0105000020E610000001000000010200000003000000A93D87F5670354C09D5CD61D75B93A40C03D6EE26A0354C0A530B9A7EDB73A40FBA87CE36A0354C0EAF7EA15EDB73A40	0105000020BC08000001000000010200000003000000FAB1251BBA742D41822A0B34168E2A4179B99ACC65742D41F2E8098A1E7D2A4108A586AE65742D41C60C3038187D2A41
351	93020002	1	US    1	1	4	93	Palm Beach	4	0	0.291	468.611	468.611046395337	0105000020E6100000010000000102000000050000002A473910A30354C0EA6392E580BC3A403AE6DB41A30354C0BB99CABC56BC3A4089072197820354C0FF23F83E53BC3A409ECE4B97660354C0157F744050BC3A40D7D325D5610354C0A2A380794FBC3A40	0105000020BC08000001000000010200000005000000D500DFD9466B2D4130E8C478CFAF2A411D58FB96426B2D412C8BE8B4FBAD2A41D497257758702D414CBB669FDEAD2A41A1EF6853B4742D414FE064B1C5AD2A41CE7614FC71752D4118AD2E7BBEAD2A41
354	34010101	1	USA  27	27A	2	34	Levy	2	0	0.057	94.7098	94.7097770578314	0105000020E610000001000000010200000007000000E60F2C3606B754C026D54194727C3D404D47971304B754C064F82ACD727C3D409631670F02B754C09101BEE0727C3D40E6AC8B40FEB654C0E1E0BFDD727C3D40993061A0FBB654C0082C172B727C3D40626EED20F9B654C0F1C8F7A7707C3D4079198C61F6B654C0DC105EBB6D7C3D40	0105000020BC08000001000000010200000007000000F9FEC14EDC74EF408F65395518A73C41568AAE080C7AEF40F0606AE718A73C4165921F8DF17EEF402717D4B318A73C416F4004773088EF4043DDA47417A73C412C6B9E7F8E8EEF405E5272C412A73C41C97207CB9A94EF401836679909A73C4104DC904C3E9BEF40F4E54384F8A63C41
87	08050000	2	US   98	98	7	08	Hernando	7	11.725	12.558	1340.5655	1340.56554634542	0105000020E610000001000000010200000015000000EA17497C699854C0E1EC44B8078E3C4084531F85699854C0D3AEECFD0F8E3C40ABBAE3A6699854C0A9E565E52E8E3C405CC676B8699854C039303495368E3C40963086256A9854C04001445F3A8E3C406E5F81E06A9854C0EBD99AFE3D8E3C4077DB6DCF6B9854C0F884D86A408E3C40C510ED056D9854C0BEE47CC0418E3C409F01A0FE6E9854C08B2A670E428E3C402ABD4C8D8B9854C087AFE126418E3C401255E29DCE9854C01528659E3E8E3C4073A4DDBDD29854C069F50FE03D8E3C40DF75E829029954C095062D053D8E3C409F95A27B069954C049AC10063C8E3C4033548CF50B9954C0572C75F4398E3C40E4DF3C6C109954C0784D41BF388E3C40E37B92AE219954C0F6D6FB09388E3C40A3F5BDFD269954C0D9C7F520388E3C405B96C63F2B9954C09C892ED5388E3C40C404CBAD309954C0E3E4F4773A8E3C40528164503B9954C0E2EB67763A8E3C40	0105000020BC0800000100000001020000001500000002236F8AF7F50941A1141E6BCC7337419332A45CF6F5094109E58E53FA733741228D287FF1F50941C50B5ED6A5743741D955E9AAEAF5094176524C81D074374160739FD1A9F509417C289DA0E5743741BAFB9A2A39F509415A7F79E4F97437414A9F4717A8F4094118590B8C077537416C59AFA0EAF30941A6E1E5390F75374160178CB5B5F20941E164445C117537418131913C38E1094168A784CC12753741EC0C7FFF24B80941B31225F0137537419D9A41F09DB50941F05EA8BF1075374175EC060093980941D41E27C716753741C1854A58ED9509412F49153B12753741C464FFC0919209413A3851FF077537414D117A5AD58F094167FD9E4F02753741D73A3A3843850941ECFE9E4F02753741803D87EA0282094195CDAE0404753741B00F56BF677F0941C7C705E508753741453CE459157C0941C2F77435137537414F482F0A927509419CB5719915753741
541	93280001	1	US    1	1	4	93	Palm Beach	4	0.31	0.398	142.7791	142.779119279372	0105000020E61000000100000001020000000500000014DED681710354C090B165BDD4B43A40342670C7730354C0D2DF517ED5B43A40BA0CBEA7860354C0828D52EDD6B43A403AC401A2880354C0A89348D7D6B43A40E766FD01890354C008261DD3D6B43A40	0105000020BC08000001000000010200000005000000639045309F732D416152A423C05A2A413CA2149544732D41BF10D9D3C75A2A41F8B0092A54702D4128BEE226D25A2A41CD61F55A05702D416B51D79CD05A2A41BF40F469F66F2D417FA93B52D05A2A41
8	55020000	1	US   90	90	3	55	Leon	3	16.265	19.323	4923.9574	4923.95737315561	0105000020E6100000010000000102000000100000005E05220E000255C08DB56806A2853E403A30146EF60155C008580FDEAF853E401E4094E1EE0155C0B94EADFBB9853E403DC302E9E70155C0497B7096C2853E40BE56991EE00155C0EF2232A1CB853E405F7761A3D70155C0ED22866DD4853E40938BA1FBCD0155C0434783EBDC853E40D1C86280C40155C0464E063EE4853E40205AB9D58E0155C0829447EE08863E40E168E23E8B0055C068F7C863BA863E40B59B5A21B8FF54C0EF7ED47B4C873E40F744FA64A5FF54C03FCE030B57873E403310CC8F97FF54C037606B5D5C873E402B203A2183FF54C06C3A0CA360873E40B98CD5D369FF54C033F4E89160873E40A01B98B0C5FE54C0BA43A5525E873E40	0105000020BC080000010000000102000000100000009921CC25F13712C15835526C26434141F41E8E77043512C1310EBB5E4A43414188512EBDB93212C14BB2A18164434141E9CBC25D9C3012C1B8A5AC987A4341411DB4EBAD3F2E12C123AC84B091434141763D3803AE2B12C1EF3F69EDA743414182B7D739C22812C17C933B03BD4341410D882883E42512C147591FE5CE434141DFEE2F6DAE1512C1385889E92644414166173CEF44C711C14A0C97D9D04541413B6347B27F8711C124E3426D30474141FACE7357D88111C151235BF548474141E9D2DE37AD7D11C1182BA53354474141B131A31F877711C1363C8CD85A474141F1838BF8EC6F11C1480FA533544741414C41C4419D3E11C16E14FA2524474141
635	90060000	1	US    1	1	6	90	Monroe	6	19.298	22.623	5350.9293	5350.92927805027	0105000020E610000001000000010200000013000000497E4B3AA02054C08482D149320639402A7C144D9D2054C00767335241063940C6509F6B9A2054C091CD9EC54E0639407BC515D58B2054C0B13B72C18E063940AEB458E1722054C099F62B3BF9063940FAA890915F2054C074C0FCEE4B0739403596A782462054C068520833B207394056B7F833342054C0F640135B010839400B12A32CFC1F54C0F876241BF308394028B0E147811F54C00D92B054050B39404CF1094C451F54C0B990072E080C3940B7373704071F54C05D3A35E7140D394042C04E4CEE1E54C067226ED27F0D39406ECD36F5D11E54C0B7371ECAF90D3940EE7EE1D7A71E54C0D247201DB00E39406E23BB638F1E54C00686D564180F3940F96D43CB811E54C016687855540F394009A29047711E54C05537CF449B0F394039E4DD226F1E54C06BDDD481A40F3940	0105000020BC08000001000000010200000013000000437E0C9C6FFA28417C907B90AEAE0E41EB47144DE5FA2841A61BFF294BB10E41F901093359FB2841322DB88FA1B30E413AC0CE46A4FD2841C7B53893C0BE0E410F7E6C8A900129414FCF12BC42D10E414E765FC2990429414CCAE3FBA2DF0E41180BDD6F8A082941F4751C8A6AF10E413686052C6B0B294116EE4EF32CFF0E41CFDCC0D6391429414F2E24EA32290F41238874C38A2729418E4103F05E850F417692131EF8302941053D50A15EB20F41018D4EB7C13A29410663AE1016E10F414FF67919A43E294160767C7EACF30F41A013432D184329416BF3E96770041041850E5543B649294190CA99AB49141041CC0B36F68D4D29417DE4BE5C5A1D1041AA0F7CC6B04F2941A3A8562890221041D9F7260E495229412E5AA5C1BA281041079882449F5229413922E35888291041
659	46160101	1	US   98	98	3	46	Bay	3	0	0.314	500.2476	500.247590209552	0105000020E61000000100000001020000000A000000E51E2A45367155C039D043933B303E40BB1EAB35337155C008DF962C3B303E40BA3FAA8E2A7155C0DB294D0A3A303E40A31D39DF237155C05278786B38303E40847B5C5A197155C0467E7EF335303E40E22A2D6FF67055C00C9510A72E303E40ADBCF611F07055C09ED40D102D303E405ACF9E67EF7055C045B71BDE2C303E409DF698C2E77055C03A5819DB2B303E40002EA87CE17055C0C8D0F1A42B303E40	0105000020BC0800000100000001020000000A0000002906CAC56FFB29C101CBEF26D57A404138FDD7B8F9FA29C1A2791BCCD27A4041EF98EDFBABF929C178B6E223CC7A40412E773077AAF829C11FE696EDC47A40415CE8753C15F729C1DF714DCEB97A4041819BB99FD3F129C17B855B61977A4041D2BF0280DEF029C115268E62907A4041268367E2C4F029C14258C7928F7A404178526C059EEF29C162C9B4AA897A404112C45CC4ABEE29C15FAE2E8A867A4041
9	72090200	1	USA   1	1A	2	72	Duval	2	0	0.41	659.633	659.632963047274	0105000020E61000000100000001020000001B00000083BB094B0E6954C09B12B643305B3E40C5B75F75036954C0F861EB46315B3E40F2E125C3FF6854C0E1F11F69315B3E40C22D8BD5FB6854C0DFE7D6EE305B3E401548CA28F76854C034952C39305B3E4017CC4791F36854C0971AE9EF2E5B3E409B92D146F06854C0F79602E82C5B3E40A26C0F58EC6854C043755FA7295B3E40BDA6C84DE86854C0356ABDC9255B3E4053BB5D74E56854C00A734815225B3E40489C3F76E26854C0F8560EB41D5B3E4040431DAADD6854C0A1F0E602155B3E40AC6D0BC3D96854C08BF3507D0C5B3E40E529FFB9D66854C0191CC0BB035B3E409B3D45E7D36854C062A0FE2BFA5A3E40C0A85946D16854C03B5DF01CF05A3E402C0BC036CF6854C04155057DE55A3E403FF15E95CD6854C0BC769142DD5A3E401D123766CC6854C038043351D65A3E40F33E75DACA6854C0F439CC5FCB5A3E40C78182DFC86854C036DDF991BB5A3E409AC72BA6C76854C0083C0E0AB25A3E40E7C5EABDC66854C0CAEBD367A65A3E40AAECE8B9C56854C0FCCFC3C9995A3E400F73142FC56854C09D36132E8B5A3E40C747A5B8C46854C03BA7FF9D715A3E40A3DAB033C46854C00D53C6525A5A3E40	0105000020BC0800000100000001020000001B00000046618FA930B31B4165CA9C7C6EB54041061A621A73B61B41F252DEB470B54041161534BE8FB71B4174494EE070B540417FC8CA2ABEB81B4133A84D566FB5404153A9450F26BA1B41D3522A1D6DB540413F134A7C3ABB1B410A0D905969B540416DD66DA437BC1B419CFA2E8963B54041C88E041166BD1B4120491E4C5AB54041E27F0CB19CBE1B41D008F3594FB540418E69D0A277BF1B4183B098EA44B54041E6D319895DC01B4137BFDC9938B540417B52DCDECDC11B413E79EB3820B5404102234153F9C21B41FE5D505D08B54041468D98F7E1C31B415A2E53E7EFB4404127874E2BBAC41B4160E52738D5B440410DBAF75383C51B4106AD762AB9B440412FEA49B420C61B41154EAF929BB44041EAD8BB399DC61B41DB4C1EA784B44041704B808CF7C61B41A289E05271B4404107B0563A6DC71B4171B825E052B440411BF65ABF03C81B41E94D65EA26B44041935DD7CF60C81B41D6042B670CB44041D7CC3A39A5C81B41E70EA312ECB34041811E72DCF1C81B41CECED001C9B34041415AC4CC19C91B4112C37071A0B34041E8C7C53C3AC91B41979A937C59B34041D3437B535FC91B418997ACD218B34041
10	87140352	1	USA 441	441A	6	87	Miami-Dade	6	0	0.09	157.5284	157.528429332649	0105000020E61000000100000001020000000400000016051D542C0D54C069304A8AF2F4394083EFC4E42C0D54C0C5089628DFF43940ED7A3FFF2C0D54C06A1544F6CAF439405BDA788F2C0D54C0A3F26E7595F43940	0105000020BC08000001000000010200000004000000DD5DF57AF0FC2B412E3C1F9A8C072241A4D18F1EDBFC2B412C44D279B5062241BDAA6854D8FC2B41BB033B6CD5052241A5F99F71EDFC2B418908FE0C84032241
172	90060000	1	US    1	1	6	90	Monroe	6	0	18.507	29783.8352	29783.8352290951	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
376	17020000	1	USB  41	41B	1	17	Sarasota	1	0	0.679	1092.6224	1092.62235872749	0105000020E61000000100000001020000001D00000077C90E476F9C54C0A8CBC78190193B4019288B466F9C54C0791564F5CF193B40CD9369636E9C54C0ABEC0013D8193B40E8563CC56E9C54C0F9F359B0181A3B40D17F4CBB6E9C54C04E9A4BCE271A3B40E67585876E9C54C09F3497B8361A3B403F690A056E9C54C07CDF1348471A3B40BD40F1F76C9C54C03B0B239B5E1A3B40E48784566B9C54C064DC33E77C1A3B40D902D18A6A9C54C0AE7EC5248F1A3B4035EE521F6A9C54C0A7B4047A9D1A3B40C2C652DB699C54C037409D86AB1A3B40A8F6C4D3699C54C0525DC689BA1A3B406EFF32FF699C54C05D411C12CB1A3B40032DA6B66A9C54C07923C3DAE81A3B403CEFC4ED6A9C54C084963C8AFB1A3B4070B38DE96A9C54C0AA103525291B3B405EE75E126B9C54C09AB3F78E3A1B3B40D0531A096C9C54C04C514A856F1B3B40A4D2EE556C9C54C0758E06CB811B3B406CE6C21D6D9C54C0B84CF8ED9D1B3B40AC72AA5E6D9C54C0A6973F19BA1B3B40CE364A5B6D9C54C091184B87BD1B3B408EEA71A86D9C54C01E5327B4E41B3B40D2581E0A6E9C54C0719A691EEE1B3B40CEDAEAB56E9C54C0946DFE93F61B3B40EC262EB56F9C54C007DF1848001C3B402CF04F4B719C54C06631EF370B1C3B4057FB3634729C54C0D7368F2A111C3B40	0105000020BC0800000100000001020000001D0000000CD80506BEBC0641B986899454C42E41FB772BB0DEBC06412A72779C14C72E4189A137CA6FBD06416C1526416EC72E414D18470454BD06416C47885D3BCA2E41354CE3E361BD064119D64014E3CA2E415746CAA089BD064108AFD07A88CB2E41D52FAD0CE3BD0641F0F4D5FE3FCC2E41C86290F295BE06418162695042CD2E4185C8E873A8BF0641164D01BC91CE2E41D0B5B62B30C00641035CA4C25BCF2E41BA5421307AC006417C10059AFACF2E415BEC1C8DABC0064120FA4E5D96D02E4143DD30E4B7C006418D2EF3EB3CD12E41BDC28A5DA5C006415674F86FF4D12E4109715DB242C006418001953B3FD32E4136C089032AC006417FBE25A80ED42E41E0CDD4E043C0064152B7CBAA08D62E41D411816C33C006417648DBF2C9D62E415665634DB5BF0641A84BE60816D92E41DEA604F08EBF0641A8C426EAE0D92E4159A73A4521BF06414567317619DB2E41D2A37E5A07BF0641B134272152DC2E41BF8983320BBF06411DD1082E78DC2E4119604B4AEFBE06413D2A4FFD2ADE2E415F9BDA79B7BE0641F4611CA193DE2E416ECA6D2C51BE064145C1E5CBF1DE2E4109459AB5B7BD0641EF58F6EA5DDF2E414B1B6E3FC1BC06411A2423FED7DF2E41467EE4BE33BC06412204D9661AE02E41
544	93020000	1	US    1	1	4	93	Palm Beach	4	9.237	9.242	8.0434	8.04336138110853	0105000020E6100000010000000102000000020000007CCC8AEE670354C0CB8B0F9777B93A4055471DE1670354C090BD62587CB93A40	0105000020BC0800000100000001020000000200000000DF52FDBA742D416B8EF9A6318E2A41716A08B0BC742D414074BA6B668E2A41
547	90060001	1	US    1	1	6	90	Monroe	6	0	3.026	4869.9927	4869.99266592675	0105000020E61000000100000001020000000C0000000C89FB4A441C54C062726423FF1739409A466E34DB1C54C0C490A0DDDF153940EB352A2B3C1D54C044F1A48E8314394037A575BF9A1D54C05B8E5E412F1339400AFE7F0AB11D54C01C2A5E16DF1239403D97B414BD1D54C0F5F0006EB212394011FD7D27C91D54C0EF961DAA82123940FAA836B8DE1D54C0A49F056D2612394066FA476E011E54C0654B4A1D911139404C5001D71D1E54C0F89B998715113940D0DAD3EF581E54C050531E951710394050ADE673661E54C03BE3432CDD0F3940	0105000020BC0800000100000001020000000C00000016A3AAB0D1A92941B25F12C689E31041724013A919922941CA114A3745B41041D97CEDCBDB8229410D9BC891F79510412618D595FD73294163CC77A55C781041E61966617C70294187C9BF4163711041926EF4E0976E29413CDE28D5806D10416EA84A27B26C2941FBC46C79596910410E5790D84E6929414CECB29C54611041F85303D6DA63294176B892A3595410415ED31B4E645F2941ABFCE05B9B491041C30916591B562941DB7637D68733104183739CB6FB532941EDB8C8FD732E1041
1	59010000	1	US   98	98	3	59	Wakulla	3	0	9.337	15018.8965	15018.8964833817	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
4	91020000	2	US  441	441	1	91	Okeechobee	1	0	3.134	5043.8211	5043.82106687381	0105000020E61000000100000001020000000B0000003D7F2BFC163554C0128BC598BE323B40C694028C193554C04A19B2FCD1323B40DFE6F862193554C0AA085947DD323B40C00F33F9193554C02A929831E5323B4015B2FB5C1A3554C0E7C0689AEE323B40B51998D01A3554C08EE612EDEC363B4013D1ABEE1A3554C0F19DE1F7D8373B40329EB6331B3554C02946CE34BC3A3B4063887A9D1B3554C0B2E3BFAF6A3C3B40C79A0EBD1B3554C0634D9835EB3C3B40D294BF191C3554C0056E1F75643E3B40	0105000020BC0800000100000001020000000B000000C040EE3934B72541B754F062E1C62F41F4BB4048CEB625412F25C05BB8C72F41022B0079D4B6254146E9EEA135C82F415EEFAC11BDB62541C38662688DC82F41F94A1D76ADB62541D0829CC5F5C82F4172FBBE228CB62541370E931543F52F4135A698EA83B625415F6855A97DFF2F41486359126EB62541B1EAEB45C30F3041CAC51C3157B625415C4328141719304128275C5C50B6254124E494F9DF1B30412EEE5B4F3CB62541501353830C243041
5	16030301	2	US   98	98	1	16	Polk	1	0	0.508	818.7473	818.7473299156	0105000020E610000001000000010200000015000000960B87B6087554C05E72662E98E53B40B57989F2087554C004D1232DA5E53B401AA81EF5087554C036F82615ACE53B40BB665206097554C01C698D8EDAE53B40B7F393ED087554C05DE6E4050EE63B407DA71805097554C091E64C5E31E63B40FBDD2431097554C025133F193FE63B4000CA479A097554C01C68D1934AE63B40C76502A80A7554C02A2CC0BD5BE63B40953206320C7554C054C8758C6CE63B40BA5A0EFA0D7554C099391C017DE63B40D8B931E1167554C00F915414C0E63B409CA521B5197554C0FE22AE23D6E63B40A6A1B8851D7554C00956F798F6E63B4024B0F4671F7554C0179668A409E73B40B5EA94F9207554C03EF46A4C1DE73B40FB01E90D227554C0C4554C3D2FE73B401A50F4F0227554C0D9C6AD2242E73B4034824F8B237554C07D93342F59E73B40F41EF19E237554C0056891EA66E73B4081E04B98237554C0D8EB5E466BE73B40	0105000020BC080000010000000102000000150000007D2F190770B61741520ABF0AEEC63341EF3A457E5FB61741F4E38B2A36C733411A8F1BBC5FB61741BE73507B5CC73341D498476A61B6174138A4F6505EC83341DF6A4EC470B617411311ADD27BC93341F18E99D46EB617410286C7EB3FCA3341B28DED5263B61741C331921D8CCA3341D7D14AA944B617414466F4D9CBCA3341CDDDA926F4B517418E103B362BCB334199C1624D7DB51741898D04A988CB33419EE5244CF3B41741B8AA7730E4CB33417530D84F3FB21741A436D77D59CD334192BADEA063B1174144F77140D4CD3341DFDC21AF3BB01741081D81D488CE3341C58FE000AAAF1741AC0C88BCF2CE33417858F33E31AF1741BEED61FE5FCF3341C24CACD3DEAE1741B4D753ABC3CF3341D972B3BB9BAE17418D231B9E2CD0334108A0BEA76FAE174109163491ACD03341F125C6AC6BAE1741452912C2F8D033411413BF606EAE174160AA57EF10D13341
6	13121000	1	US  301	301	1	13	Manatee	1	0	7.908	12748.196	12748.1960077396	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
28	16060000	1	US   98	98	1	16	Polk	1	0.521	12.222	18828.7879	18828.7879378164	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
29	48100001	1	US   98	98	3	48	Escambia	3	0.982	1.296	506.3664	506.366415129494	0105000020E610000001000000010200000013000000D9602AF8C6CC55C04FA082F6B06A3E40B19B4E29C6CC55C08A9D8667B06A3E406252DED1C3CC55C05D8B7B79B96A3E407AD999F8BFCC55C079A56A6DC66A3E40FEF46A4BBCCC55C097AA5E6FD06A3E4030803B38B8CC55C040763CA5DA6A3E4015BD0581B2CC55C08ED4B10AE56A3E406E201775ADCC55C0A8DD0FB7EC6A3E4009EB9DA5A7CC55C091D5C498F46A3E40084CB9CFA1CC55C0DB8B620AFC6A3E401EF93F929BCC55C0257B122B026B3E4049F4BC6294CC55C0C4784066076B3E40E2ADF8178ECC55C03CE99F3E0A6B3E4024B0071389CC55C03005B9940B6B3E40743E690B85CC55C0D3BB5AD40A6B3E406E9F77CD80CC55C0A1650238086B3E4035ABED457DCC55C064FFA175046B3E409A01B4157BCC55C0D2CA5334016B3E408D48858D78CC55C06820F96F026B3E40	0105000020BC08000001000000010200000013000000352E983D9CD533C1E23F8A353B484141598942D28CD533C1AB33E7393948414159070DDE5CD533C1ADB12C3951484141F93488A50ED533C1687BB1397348414180C268A6C4D433C1DC56831F8D4841416DF173E772D433C18BB4B15FA7484141B2E62B7201D433C1D08A8345C14841413083E4BA9DD333C16FD96EF2D34841416E35A7362BD333C1557C17CCE6484141733CEF58B8D233C17F0D796AF848414126FBEF133ED233C1EE1F642806494141EB3A75D7B1D133C18DD059E7104941419092379337D133C10177FD7B1549414101768053D6D033C1E5E7918A164941414426C8CE88D033C13AEA3F5012494141AC538AC337D033C1CDB1A6CC0849414184FE75D1F4CF33C175059777FC4841414A1E9F97CBCF33C16217BB3FF248414105BB565D9ACF33C10AE16B56F4484141
53	12001101	1	USB  41	41B	1	12	Lee	1	0.69	2.29	2574.7415	2574.74152674461	0105000020E610000001000000010200000017000000CC642605137754C0D07E439019A43A40F3AFBBCF127754C03100966B1FA43A40D506E501127754C0D2AF45262EA43A405B0DF7A6107754C00F2A804F53A43A403D69F5DE0F7754C07EC7C7157AA43A4020EF825C0F7754C0B3375792DFA43A4015C434FC0F7754C01E50A886F3A43A40F9B6993C117754C0A9079F460AA53A40AFB6BD3A137754C03206B24D21A53A400945B73B177754C01F3C889B3DA53A409DBD0F05237754C0C2F95DD882A53A40467517ED367754C02C7FF9CFF7A53A40FF93544F437754C0C1D575B23FA63A404F5F9EF6477754C078D1754057A63A405F804C684B7754C0C9C132EB68A63A404B0BD3D0507754C0633B1CB77FA63A40FB41CCB3567754C0467D025A96A63A40AC6B96E35D7754C00F9441E1AEA63A408F1A4347E77754C01726003F7FA83A4071084EE4EC7754C02CBE717C92A83A40E08F5D65F27754C0167B8FCCA7A83A40CAABDDD5F67754C0F435D779BAA83A40F842DFBEFA7754C00396D0A9C2A83A40	0105000020BC08000001000000010200000017000000EB7AA7B072E41641EECEF702989F2941AC32DD3484E41641818065EDD89F29417BED9188C6E416419F2F551C7CA029412431A22A38E516417CE671FE17A229414287B5447CE51641036C38EEC5A32941B312CA11B4E5164178305CA32BA8294162AE384D85E516417836862B09A92941066AC0E324E516418F8DE7E105AA294198E9B76889E4164147FE20E005AB294130F5BC554EE316419DD36DF140AC2941E2A905B8ACDF1641073A9C3344AF2941B8F755B98AD916412A5AA8235BB42941BE5984ECB9D5164150DE9EEE7BB72941BDB5055B4AD4164160A6E07D82B82941B7213B5A3AD31641CDB0DB6847B9294138CE977A8ED11641EF1A54C345BA29418DD8AA70BCCF1641AC47077842BB2941C286620383CD16410788EA8354BC294132517D2EFDA2164110D6A64799D02941C44C687A40A11641C6B2764070D12941365CD6CE8C9F16411052DB305ED229416E1A8EA32D9E1641F4D8A2982ED3294158B1FF14F79C16415E9CD97D8AD32941
15	90060000	1	US    1	1	6	90	Monroe	6	22.623	25.728	4996.9587	4996.95870470267	0105000020E61000000100000001020000001C00000039E4DD226F1E54C06BDDD481A40F39401291A7B55F1E54C0284BBFFFE60F3940A1708CED5B1E54C04D526326F50F3940B3138016581E54C003E6A8EE0010394051931887531E54C0479F03F70B103940CF4EC2BC491E54C0A533200522103940DAA87D07471E54C0A5857715291039400307BACC431E54C0C29E0D8B33103940E5C108D83F1E54C099B7B70543103940651996D6CE1D54C07F535C852B123940F52C2553C51D54C02DA9812054123940A289D812C01D54C0AB6CF8F8691239406BB95D94B71D54C0EFDED7498B1239406BDD5979B01D54C0DD35CFABA512394041977BD4921D54C0B2B356B211133940F6603523341D54C07C7D0E8C66143940C32436920E1D54C0D6570F15ED143940ABCCC478861C54C080942A53D71639407FCE1B04751C54C06CC72D18161739409DF946E9501C54C016C3EE9B9717394065FC96A54D1C54C0E4A68794A417394050B293594B1C54C0FE63DA32AF1739403E857C8A491C54C0243F7B61B9173940A8786EF8471C54C0C4C71DB8C31739409F3DB85A451C54C089AB931BD6173940C316446E431C54C0E2C47FC3E5173940A3CA8E32411C54C026CCEA55F4173940F56753EB3F1C54C0BDE870E9F9173940	0105000020BC0800000100000001020000001C000000079882449F5229413922E35888291041CE83ADC40B55294136A03C10502F1041FFF9DDF7A35529414BD537238B3010411603DBA03E5629415B9FF6B0913110410A99736BF6562941E8F6D2D787321041445075138158294158558522743410416437C732EE582941E2F52DAC11351041D946C03E70592941619AF9B0FA351041DBD7FE6B0F5A29419F92354953371041BDA22350D06B29417934B6B1CA6110418233AFEC4E6D2941F200716E52651041D17EA823226E2941C195DAAC386710411A5999E0776F2941E4F8E4621E6A10418DB775D095702941C58BD7DD696C10414F84A1CD3E75294142019B89CF751041FE528D9021842941F3DB70B17693104171D98D4F098A29410FA7A21C2B9F104196DD6FAA6D9F29416354E42CD2C91041DA97D5002CA229417130004A48CF10414AB6C2ACD8A7294117A6C1218DDA1041F53325F55BA829419A7345F0ADDB104100BE6143B8A82941632FE93C9ADC10413A6C08E000A92941CFA35AB27CDD1041741F13D93FA92941CBFBDC8A62DE104171A676B0A8A9294192EAF44CFBDF10419453ECAEF5A92941BDFD1D3757E11041D08ABE3B4FAA294183BC54309BE21041ED13C69D82AA29410B37444E17E31041
93	72070000	1	US    1	1	2	72	Duval	2	18.211	19.076	1392.0116	1392.01156012732	0105000020E61000000100000001020000001B0000006F48E6861C6A54C00B3BBEFD7C503E409AC0C6261F6A54C0822F0E5480503E40FAC6EF33226A54C0A61CA8C586503E40B50F7654256A54C05F8629E990503E400AE0E267286A54C0656489619C503E40F4F805132A6A54C07B7706FEA6503E408D6542172B6A54C00C8ED645B1503E40CF96C6AF2B6A54C0B808E734B9503E4037A1D0022D6A54C036298587D0503E40A52013452D6A54C0DB1B1B30DB503E4050F0DB582D6A54C056A6FB4AE5503E40D708D7592D6A54C0C8E9E094F3503E40B399C7072C6A54C0BBC4AFB856513E40109114212A6A54C0C56A45E5D2513E40A6F667C12A6A54C02F2E1CBDD6513E40930679882A6A54C05C56FF10E2513E403B12EF6A2A6A54C05296DB0CE7513E40E03F0AE6246A54C010B2D8AFD8523E40D596917A236A54C0D7F3F7F00D533E401E638E56226A54C0E76895E311533E40A2A5966E216A54C0FAFB1DD217533E40229B08B81E6A54C0BF647D4223533E403127D1D2166A54C045021FAA36533E406CC41239106A54C04E4910E346533E40BBD4503F0E6A54C043238C6E4D533E401AFDF0BF0A6A54C059CF4A5B5E533E402DE939AB086A54C072A69A5B72533E40	0105000020BC0800000100000001020000001B00000017EB4EBF86601B4117B0B17BCC974041E316BCFDBC5F1B41EC09BCE3D597404126B0B8BFD25E1B41BC3DA4F0E797404158D6E027E35D1B41065F523F049840418BF448ADF75C1B4139E41E3F249840419383FB81785C1B41878DA8C841984041FE095F852B5C1B41B0ECE95D5E984041735AC1A5FE5B1B413BCB336A749840418897D8A09B5B1B41425B5334B5984041474F1D10895B1B4183A543CBD29840414F2F6969845B1B411CDC64D6EE98404192AF4DF5855B1B417E1F517C16994041F725DA76F85B1B41E99BE580299A404184DDC4EB9A5C1B41CB4129F4819B4041E2BE272C6B5C1B416F8810A78C9B404191979BC37D5C1B4195187212AC9B404101AF7D4B875C1B41545A08E5B99B4041E8A1B6924F5E1B4128668213589E4041D789DACCC35E1B414BD634C4EB9E404124C38D2C1C5F1B41C96422A8F69E404153876DBC625F1B41B885C810079F404134B77E3235601B41880B9AA7269F4041C0CB26DE97621B41AE51E30E5C9F40416895346396641B41E43F27B4889F40415D5A70682F651B41EC760FC19A9F404151ADB1FE3E661B4140149685C99F40416A95C9DAE1661B41914AABE700A04041
11	58030000	1	US   98	98	3	58	Santa Rosa	3	0	24.005	38801.6406	38801.6405769821	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
12	36030000	2	US  441	441	5	36	Marion	5	1.23	2.606	2212.8689	2212.86886996723	0105000020E6100000010000000102000000160000008FE924BF148954C0782B541769323D40908BF5C2148954C070E16ED66D323D4069416FCC148954C05EAFEE4F7E323D40CF9514B8148954C013CE315DBD323D409FD45E7E148954C014A3A406DB333D40BC163E5B148954C063D356209E343D400BE5DD5D148954C02A00CD66C0343D40F3561783148954C0BEA6393ED2343D40BA3B04AB148954C0377FD5BBE0343D40E9FEC415158954C01F10653DF5343D40F08C0616168954C0C51E70B215353D40FFB35766178954C04E24D65B34353D406F979383188954C05E0A121948353D403FE0B1E8198954C064A6CBD55D353D4079ED8CC11B8954C08F78A62876353D40429D3DA91D8954C084AB2F798C353D406BBAF5DF218954C09F13BF75B9353D40762393CA408954C050236F74FB363D405619539E438954C05023E96315373D40834D74EB488954C0B08A98EE44373D4002A5E7414B8954C0F40E9C205B373D408FD533AB4E8954C01635393A5E373D40	0105000020BC08000001000000010200000016000000DD729C91D2CF11412637EEBEBE003B4197DBA86ED2CF114100044D16D9003B418477BA1AD3CF11418ADE1D8334013B419B090AE8E6CF1141221C965F92023B412786F81F36D011413900357AC3083B4140F5CBED6AD01141B380E511FE0C3B416920918771D01141E3013044BC0D3B419FEBF80D6AD01141B276094C1F0E3B41982BD20861D01141997E59BC6F0E3B410FD99FFA44D01141F5D6919AE10E3B410C659303FECF11419F024AE6950F3B413B7B3B4D9ECF114144C3984A40103B4144A065C64BCF1141C5E43609AE103B41C516D5CEE3CE1141E362BDEB26113B4139094D2F59CE114108CA623EAE113B417D2B739DC9CD1141D167E16D2A123B41615FFC1C8BCC1141A7B02ADC24133B416E456DA468C3114199C90F7D251A3B411396BF0D92C211419DD241F1B51A3B41E0587970FFC0114155B0B9C2BE1B3B418F04FB2A4EC0114169202E5E3A1C3B41F6A4BD2345BF1141EC96EB374C1C3B41
13	38030000	2	US  221	221	2	38	Taylor	2	0	0.425	684.3758	684.375760136218	0105000020E61000000100000001020000000300000005C997C7B5E554C0D5C2FA10921C3E4063993A79B4E554C05A72200B921C3E40B884587B41E554C067D6A905901C3E40	0105000020BC0800000100000001020000000300000094950CE66BDA03C1D1AFBDCDB41840413F9B8A2CA2D903C106034374B41840414EBFD213429403C1C3C035B195184041
14	72050443	1	US    1	1	2	72	Duval	2	0	0.48	773.0466	773.046635304794	0105000020E61000000100000001020000000A0000007606BDCAFB6954C02D41BD4E3F553E40E7AAAF53FF6954C0E0748CAC0D553E40714180D1026A54C0ECFE13FFDC543E40F8E70069066A54C06843AE18AB543E40FA6D03EB096A54C0F657B5F179543E405A8695720D6A54C0B5A4581549543E407B26D2D4106A54C079ACE58218543E4051BA987A146A54C0547C97C5E6533E401CCFC5ED176A54C003C09A0FB6533E40C47AC69B1B6A54C01CD481AD83533E40	0105000020BC0800000100000001020000000A0000002C0F7CE6FC6A1B41B5AAC539FFA44041EBB88141E6691B41EEB827B375A44041C2656E14D3681B415BD4FBD2EEA3404180069003B8671B4180D2F48F64A3404145C5B581A3661B410725EA5EDCA240419F7B1A5C8D651B415EB93AFD54A24041A8DDAA7A82641B41F2DD9266CEA14041A6E7831F63631B4123E3709644A1404133DAB91E53621B419A05289EBDA04041F2898D3231611B417F77420532A04041
16	46040000	1	US  231	231	3	46	Bay	3	0	34.764	56059.9977	56059.9977044536	0105000020E6100000010000000102000000CF000000CFCB8A2C436A55C08E5D5D5DA8283E40FF0AA92C426A55C0EE975B9F0D2A3E4006EAA87D416A55C0782DC32CF82A3E4039C0AFA5406A55C09C8C256AE72B3E40E02F1023406A55C00CB135AED12C3E401B67801C406A55C0F7CFD3D4D82C3E40210FDAFE3F6A55C095EFA639F92C3E408443A25C396A55C0E5602F820D2D3E40104E7EEA356A55C0CB5ADBD0182D3E40A73677A1316A55C03D9EDD86252D3E407E29A64A0D6A55C00DF6FBC48C2D3E40F5F19F79C86955C0C92A3ABB4F2E3E4057242553B26955C01087388C8E2E3E404A166ABCAB6955C06ADDA3E0A02E3E40D4C0C9AEA66955C06BB96084AD2E3E40C25354439C6955C0C297BCF1CA2E3E4001F03C179A6955C03DB04314D12E3E4025101EA18B6955C001EDD8C6F92E3E406CBE91C3876955C03024A645052F3E40DE0B3F37816955C04E890DB4192F3E40DB6F0E43056955C0134EB26C78303E407CF6BB87046955C06B59AA7E7A303E40E78A1D5C2B6855C076FEAFCAE1323E406AA3C217FE6755C0EAAC2A0562333E40883ABB1DDB6755C015F28220C5333E4069EAC4A3D66755C0C8C788CFD1333E40DA2BB0C9D46755C0BE974FFAD6333E4068F27E3A6A6755C0629B2FCB04353E40884AD37D2E6755C0EC927238AE353E405339CADFE16655C0D9653D7A87363E4033487975B36655C014A64B060B373E40FE60844EA26655C066E67ABA3B373E40DD8B9897886655C092D12C6084373E40D11F8A164A6655C0612F989B35383E40C61ED81E386655C064B7DE8F68383E40F70C4645CC6555C004547BD199393E400CAE0C8D0C6555C0F9313C84B83B3E40A03AA9C6FD6455C0A2BE3B3CE23B3E401FC5ECDAF66455C03C274AD5F53B3E40E8278791566455C00BE8CEB4BB3D3E4061521C42D56355C09F3C66A7293F3E40FC45D24AB86355C09ED8C4747B3F3E406B942A9BA76355C0C9B8D3B6AA3F3E4070C0B12F0C6355C06F0F2EBA62413E40DEF2ED51DA6255C035A01E35F0413E405A5F2BA1906255C0BA1887FEC0423E401650E492AD6155C0AF23148743453E40108A7E787A6155C0131ADE89D4453E40EE27488A426055C0CBBD64B947493E40A88F57D4D95E55C081F2FFCD444D3E40A8D5D6A3A45D55C0735879B6B0503E408CAA54C47B5D55C0E3C6DD6B24513E4003B76EA6245D55C01883B3601B523E40C5D46DFE0A5D55C05A536CC364523E400BC0E0B6025D55C0097189337D523E409A163CC3F85C55C0A1EB8AD69B523E40EB274166EF5C55C02AE90932BA523E406C2194C3E35C55C01AB95496E1523E405FD01A91D85C55C00BCAA58B09533E40BB3AF072D05C55C0433E645E28533E40EB5D03A0C85C55C0BA3C0FF246533E4012C71CBFC15C55C073749ECE62533E40F49AE369B95C55C0D874515B86533E402E4A8D5BB15C55C04AB5116CA9533E403A40F4DDA95C55C09655FC7FCC533E40C0FA1A9CA15C55C0FA36027FF4533E40D23B40F5995C55C09E23B7841B543E40A5A49596905C55C096089D2F4E543E406A14EDB2885C55C09443227B7B543E4069BAFF0F825C55C056029FB3A3543E40F85A08747C5C55C0C15D3A53C7543E4060BD21D7765C55C041D5F5E8EC543E406A9D19E06F5C55C0A5480FB71E553E40CFF006DC6A5C55C0F858B7D744553E4027572D06655C55C0DA6832AB74553E40FD05B92E605C55C07B669C759E553E40A9A60F39595C55C049CA1564E0553E404B374D02535C55C0C3E7F0A622563E40581E6D3E4F5C55C078C30C614D563E40D5AE1DF14B5C55C00AB478D276563E40D8B50E48495C55C03EB71AC59A563E4035E6D7A5465C55C0693B9E11C1563E403C27B393425C55C0B9DB22E903573E40CF24E7983F5C55C06821F3C03E573E40A46BCC373D5C55C02A9C5FE474573E407F318EB9225C55C012D780C53C5A3E4072462E7B115C55C07F153D5A0C5C3E40D2F060F00B5C55C0EEC3C7B7A55C3E4035A3E0670B5C55C09DD0B6BAB95C3E40C136C5FB0A5C55C08E61024AD05C3E40A5F6BEC30A5C55C00FF6D7ADE65C3E401F7B41C30A5C55C050472299EC5C3E4035C297BC0A5C55C040172790FD5C3E401C6514FD0A5C55C0FE90899A3F5D3E40DE8264A30B5C55C058215BF2E45D3E4089CAE2A60D5C55C0B0BC1200BF5F3E40223637A40D5C55C0B836766DEF5F3E40BBA5522C0D5C55C082FE99D725603E4064C987990C5C55C020438F444A603E403E2376F50B5C55C035DF60A06B603E40BFF31A3D0B5C55C01F9CEBE488603E404157322E0A5C55C01616761BAB603E407CB851E0085C55C0C84DB5D5CE603E40067B3F9F075C55C003D09882EF603E4010B9873E065C55C0BEAAAC4711613E402ADB2801045C55C0CAF730BF4D613E40C7726D82025C55C0300BDDBA7A613E40FE98639F005C55C01762C34AB0613E40CEB14E76FD5B55C007A1F2EC01623E400E766754E75B55C04D2B086C27643E40A6C6DADAD35B55C05DC312EC08663E40225506EAD15B55C02F19B17830663E404D93C1A2CF5B55C0E7A3B1F557663E4098FD2680CD5B55C03EB2392A79663E40A160D822CA5B55C0CDC97D7DA7663E4064FA8FEAC75B55C0DF62B6EDC3663E405303486FC45B55C0B27B2EA0EA663E40CA1B8CEBBF5B55C0A200542B1A673E40E62F27F3AF5B55C00139E63FC3673E400BA3F7A4A65B55C07471288D26683E40B31E5FC3A35B55C0E731121148683E400902EAA7A05B55C012370CD86E683E40285D56819D5B55C0070671D499683E40B94E96D69A5B55C033CDB904C2683E40896FC193975B55C0A8C3FAAEF8683E4019FD37F4945B55C0852EDB1C2A693E400DF091DB925B55C0F737F9E459693E4077C99E158D5B55C0C9C6C45BF2693E40D2118295575B55C0F0A166E2866F3E408374B7F4485B55C0652FE1BD0F713E40EE23E9CF3D5B55C0540F1E1A36723E40F9CB4223385B55C03D553DFCCA723E40CD99C2E82F5B55C0B99FF5C2A7733E401F43E522215B55C0D2413E8D32753E409629C734185B55C0C4D500CA1F763E40C671E2AF155B55C0CAC4A19461763E4039BE53E1125B55C02E69C321A3763E4074DBC44A0F5B55C0B36E16B7FC763E403B23F9260C5B55C03B3C55EA4F773E40BE64EF0E065B55C030C112C5F2773E40B017300FFD5A55C011267626E1783E402516FDBCF75A55C0E6D9D93570793E406A01E4FBF55A55C03D43B63F9C793E405D6422D9F35A55C058F04A66CE793E40728333D7F15A55C058ADD2CCF6793E406D12A573EF5A55C04099EA4F257A3E404B1D2642ED5A55C0B8CD97594B7A3E4035FD80C4EB5A55C08FBF8287647A3E40B8C0BA35EA5A55C0ABDB160E7D7A3E40A5162789E65A55C075AFBA9EB47A3E40AA0220E4D55A55C0710E4917987B3E40079B8D4BD05A55C0CDC235EEE47B3E40A11A4ECDCD5A55C0C0E9BA01097C3E40BCE880B2C35A55C066C9728B957C3E40C0F597B3B05A55C0640E78C5957D3E40678D9CA2575A55C02C82F38846823E40EBC15F3A345A55C0E36328FB23843E40656179F91F5A55C0F467502835853E401A1816471C5A55C0FC2EA10866853E40B14D03601A5A55C06B4B33577C853E40CBA736D7175A55C0D8BA753896853E404AACE258155A55C069D81DD5AC853E40E97FFF69125A55C01F229E5BC4853E40594CA0A80F5A55C053FA7407D9853E404F84BD130C5A55C050CBDF0BF1853E40FDFC8022095A55C09537EDA303863E40C883349B055A55C0912E9A1718863E40659737D8005A55C03563141431863E40B7370B21FB5955C0EFF439754C863E407F3002D1F65955C00529F2B85F863E40FC43C4C4F15955C04DF9A60E74863E40C60CEF5EEC5955C0C9E7787088863E40BD8C472EE75955C043B152879A863E40B5D5FE2BE05955C04E9F06FDB0863E401A5F2529D95955C062E02E2FC5863E40B080B09BD25955C0DF3DAF91D6863E4021EFB9BECB5955C0439D1F59E7863E402616B84E905955C03AB05E776D873E40F7DD1196875955C0606CE13E81873E40F415B36C7F5955C0C2BEFCF294873E40EA72E12A795955C03E8B5AA5A5873E40F28A6679715955C03998C78CBB873E402A0043B66A5955C09CF89B2AD1873E40B86A0A89645955C0071162F2E6873E40E9C15DFB5E5955C0990A7E13FC873E401AE8BB11595955C0F623D99114883E4047BEC56D545955C0A19828E629883E40C0CD337B4E5955C04488B09247883E40891418B1495955C0D72A385762883E4074557815455955C0A51566B37E883E40B7A360AF405955C01E2DDD0D9D883E40CC87F2EA3C5955C05983F37BBB883E40D2F68A2B3B5955C0947C666ACA883E409EDF7891385955C03A452EDEE3883E4004FE3F0B365955C04BCF071C00893E40A9F4B141285955C086CDA191AC893E40D91D9EE11F5955C0FD5BA057178A3E404A08F0B21B5955C09C534D9C4D8A3E4030A101E4175955C0121E28B8838A3E40DA4DC53F155955C00474445DAF8A3E402CA421E1125955C0D15CD41ADA8A3E40B4D04355105955C0B4E9DF320E8B3E409F8060BA0C5955C0FE78EF3A678B3E4019DB41B3025955C08358299F728C3E4018568A63FD5855C077CD6BE8018D3E407E76B7C9E85855C07F0BF485258F3E4029E0ADD0D55855C01219D58E1D913E40	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
191	48110000	1	US   98	98	3	48	Escambia	3	0.388	3.971	5790.6338	5790.63376802917	0105000020E61000000100000001020000001F00000075B8EBB191DB55C09C1CFF6BA6673E409838E22640DB55C01112D94BF1663E40BB71F12638DB55C0A75BB72EDE663E40A0F072DD25DB55C06BA61B5AAB663E404CACE2A619DB55C02F033F6789663E406AFB0D98EDDA55C0387EE65C0F663E4039042E54E7DA55C05F0FA97E00663E40C2496AE9DFDA55C01B8E8D4DF3653E4041D6EE5AD9DA55C0EF1894A0EA653E401E763A5ED1DA55C09B98DA9EE4653E40EC1C701FCEDA55C0F778A00BE3653E40756A1131C9DA55C0EC441E0FE2653E402312F88048DA55C0E53FF216DB653E408C2AC7E737DA55C01A09C64ED9653E40BAA22FBDFED955C0F0AA5528D7653E4007A2CAC5AED955C0AC9E9B4AD2653E40A3F6ABF59ED955C02079670BD3653E4085979C647FD955C047249A6ED1653E4045F629926ED955C081E50186CF653E402C6AED7565D955C080CCB064CF653E406BE696D75DD955C094FBC611D1653E408516996D56D955C05D099901D4653E40D89004CD4FD955C05606721ED8653E406A8267C549D955C0126C0F43DC653E40E689FCE67DD855C0F76F88BD9F663E4085F1437A24D855C0AC58EC5EF5663E408B345A5506D855C0352DCBD512673E4029DBB5F1FDD755C08F7366C418673E40F74B9BA1F6D755C0448505B71C673E4013508DD7F0D755C0D207DE271F673E4092F95DD4F0D755C047CE4FF520673E40	0105000020BC0800000100000001020000001F0000009FCC280000F434C14146876BC34741414C8C14A813EE34C1C56BC76B9E454141FF505D517FED34C1E17D52D264454141DC14A87B2EEC34C164D4D049CD444141A12CED854DEB34C1F5436E1568444141EF7C81D721E834C1D0980531FC424141C449CFA0ADE734C107ACC15DCF42414127A41EA622E734C15592E792A642414105C0ACD8A6E634C1054403D38A4241416384F1950EE634C1B345A5B77542414169CB2372D0E534C1C8A5E78C6F424141873B659471E534C1A63491186A424141A1039CE9BFDB34C19DA5310B10424141D8C6551A80DA34C19A1539FA01424141745AD76331D634C1CDE5C8A3DC414141B6CABA772BD034C104746C44A3414141F865BF04FACE34C195754EB39C4141418D8C3A4099CC34C1FF214AEC86414141BDA09E2A55CB34C1DC11486678414141D523085EA5CA34C159929E0C73414141A4CC92CA11CA34C11AB61B8B7341414104159AC381C934C1316191A87741414121A21E8D00C934C1FDC02B7A7F4141416B98ADDC8AC834C13AB02CB58741414166F45361EEB834C11917674838434141E612DA7E15B234C1609A78C6F543414140545D70C6AF34C1D95DEF5337444141F64530A922AF34C173EC9342434441412AC5D14794AE34C19C7AD7414A444141576BC9C723AE34C1E28D4CE44D44414185381AF922AE34C1E187D5E652444141
19	02010000	1	US   41	41	7	02	Citrus	7	13.177	30.062	27152.3431	27152.343090406	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
88	93140000	1	US   98	98	4	93	Palm Beach	4	19.36	26.288	11151.6222	11151.6221654767	0105000020E610000001000000010200000034000000B5A98B5A6F2854C0E892836ECCDC3A40ED50C1A1702854C0003B0DF8CFDC3A40777835A0722854C09CD874A0D6DC3A40E65E7188732854C0CBBF3BA1DCDC3A40A5D174E3732854C0B67CEF83E3DC3A40A4C219C5732854C0EEF191A3EADC3A40B1A03510732854C083A50F22F3DC3A40E86BC50A722854C0B295A82AFADC3A40319C87016F2854C0CA01DFDE08DD3A403CBAD85D692854C032AB8F7E26DD3A40393F1FCE582854C006A8040C7ADD3A40D244B937142854C0EF6EFFFDD1DE3A40E9EB2B8BF82754C07D10B84078DF3A40F2F4DE3FF02754C019FB58BCA5DF3A40476A6F51C52754C0DC28915788E03A40A7B654DBBA2754C087011EA9C2E03A40BD7AFC8BB42754C0E1E4A504E8E03A40F591A477A02754C024C654916AE13A407837778A702754C037BF569DA2E23A40B0F87C06562754C0BC86F5DE6DE33A40695CBE6F4B2754C091691284C2E33A40CC9C37A1442754C02E35940301E43A40F885EEA53C2754C07641D9DE56E43A401A6FDE43382754C0DEA2B63A88E43A4043A491A5342754C0781A68ACB7E43A40250487122F2754C0A9E22C9F13E53A403CD75BF01D2754C0FC380D6E54E63A40A753E2911C2754C0E3EFFFAD81E63A40CF8A6F2F1C2754C0220E51569DE63A400B65D2F81B2754C019F1CD404EE73A40767AF5E31C2754C0FD91107871E73A401095F4D71E2754C02AC7C2D990E73A40155CF60E232754C0951B193AC4E73A40BA792FDA252754C04C27F562E9E73A403EA5FB41272754C0A51FE0170AE83A40BE236C50282754C0C410570529E83A404CC37CAE292754C0D16EF8DC51E83A40A05CDA1C402754C08B9BF8BBD1EA3A40639445E0402754C057F474D101EB3A400E92D5D5402754C0697247DB49EB3A40D31CD9D33F2754C079BBDAF182EB3A402B2C5F683D2754C03CA0CC17D3EB3A407CF1CEE9302754C0CCF3C29036ED3A403739CF06202754C0EB45007FD2EE3A40425CE8BE1A2754C0FF824F8D4AEF3A40C2AEC778052754C0199ED12C47F13A40EA4DEAF8032754C0FDC508607BF13A40F2713EB7022754C055C28310DAF13A4061C713A8012754C0D98E558616F23A404F369B82012754C0B258810B43F23A40549B637D022754C09D20980127F33A40D85E4762042754C04415B0AE2EF53A40	0105000020BC08000001000000010200000034000000641F33D81DB02741EC809217840E2C41722202DDEAAF27415773202FAB0E2C414DE1824B9BAF2741EEBB8FCFF40E2C41E84BCAFF76AF274187B09A4C370F2C41CF21FAA068AF2741544334A4830F2C4177F1571E6DAF27412991C2ADD20F2C41E5C245F788AF2741FCADD7FC30102C41F770C161B1AF2741B98888217F102C41BB0757BC29B0274194A8B99822112C4126F1E33509B12741FC7480DF6B122C41AB566D9999B327410E5D7EA90C162C41095ED9E037BE274133E51C24FC242C4173F147B07FC22741D88E57C5332C2C4196A4E33EC8C32741902DD44D2D2E2C414BAFC81E6DCA27414614A13204382C416FC5B1760BCC2741DFAC0F638C3A2C4123AC6B4E05CD2741D4B8878E2B3C2C417653E2F21FD0274191F8AD2DD6412C4181A9028188D727419EB1E78F614F2C41F7F4E5ADA0DB27414F08BB8C33582C41A5BC0A2143DD2741C1575AD3DF5B2C4181B9CBD64FDE27419CC54EF6955E2C41C183127F8ADF274160927B5D4F622C41F6300F3637E027416EF1937373642C41CB095F90C5E02741FE6A553482662C41CE74E139A0E12741712338E57E6A2C4135F2DDF83EE42741985794D067782C41C9CC9CE573E4274152CAFBF35D7A2C410D84104182E427416C3E54D0907B2C410F8BB1B684E4274190559B6D3B832C41F8F51FF95EE427415A2636FAC1842C41839D4B3410E42741E154A6DD1D862C41EFEDFFC666E327410383404957882C41D3AE275EF6E22741EC345D2BF3892C412101DB57BDE22741E8F11BD35D8B2C411E5CFC4392E227410CD544C9B48C2C412C1C447A5AE22741884C79B2798E2C4112F5E472C8DE27415208EB4731AA2C4197225074A8DE2741D1CBB49946AC2C41CC686FA2A7DE2741B641BFC065AF2C41DC7C06C9CDDE27412534DF2CDFB12C41A20D29522BDF2741EF64349558B52C41EB1AC63910E12741612ED17DC1C42C4194FB0DDAA1E327418C922F419DD62C412C602FCA6FE4274184DA03BAD1DB2C41AD89AE7BACE727411C007BB0DEF12C4117800654E6E72741427B1CF321F42C41B08D2C0E15E82741CB9C05883CF82C412D8BBB1B3DE8274130910A5FDBFA2C4197245C6741E827414BBF1645C9FC2C410210CAA212E8274159C27104AA062D41E67AAB82B5E727419275FBC42E1D2D41
89	87140352	1	USA 441	441A	6	87	Miami-Dade	6	0.09	0.358	417.9709	417.970850520548	0105000020E6100000010000000102000000020000005BDA788F2C0D54C0A3F26E7595F439407E58038B2A0D54C0D3DF9F3C9EF33940	0105000020BC08000001000000010200000002000000A5F99F71EDFC2B418908FE0C840322410434FE004FFD2B41B2258543CEF82141
20	59110000	1	US   98	98	3	59	Wakulla	3	0	20.725	33357.2841	33357.2841255491	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
30	54110000	1	US   98	98	3	54	Jefferson	3	0	7.412	11926.3478	11926.3477670204	0105000020E61000000100000001020000002D0000005E96DB0BDF0455C051844DF9EC303E4032DFE17DFD0355C0D982BD70CB303E407D9291E8ED0355C0E9C40BFEC8303E40BE09585A2D0355C08AF8FADD88303E40617BEF43C10255C08A052EAC64303E409F65475B1C0255C0727F69142E303E40617FCF66A30155C0CE52576705303E40A8CF4116910155C032D18A7DFD2F3E4012D25091820155C0D01BAFE5F32F3E40A65755C16F0155C01198B732E42F3E401D8E6082610155C003CE1DEED32F3E403DFEC34B550155C02D0EDAA7C42F3E4006B1F023460155C08F6646B5AE2F3E406C1BA5F3320155C0454DCE0C8E2F3E40F8111E07220155C04B09C6AB6A2F3E40705D0678110155C0FFB74F90432F3E4067A70232020155C0B71ED687192F3E404BF953D0F30055C0A67F21E7EC2E3E406239D3E9E70055C0B25F6043C22E3E401CF033E9DA0055C0F041534D8F2E3E404EAA5EF1CF0055C0468241ED5D2E3E40A6EEC526C50055C09C660F1E262E3E40B99006E5B90055C0B4EE1858E22D3E4013731BA0B20055C01665DE5EAC2D3E402FA8BED7AB0055C03DF1FC4D722D3E4069357940820055C03CB93D7A002C3E4014B878FA610055C06338593EDD2A3E400342D281520055C02E0A82B2532A3E40DD8381494E0055C08E9511A82F2A3E40C72B0E98480055C093E82B01052A3E40C1069873420055C0BEBDE7D7DA293E405354580C3A0055C03F9FD091A8293E40DA7E6804310055C077179DD378293E400EB7D89F280055C0AB6C027250293E40E9C54B231F0055C0A684C3D628293E40207F67BD150055C0DB8C5B5F04293E405AA4D694090055C051C9143BDC283E40CDB17BCE000055C0E1C5B138C0283E40FF5AEE6FF2FF54C00EBA574797283E4069D4B257E5FF54C01BAD775876283E405F6CC4BED8FF54C02DC2A0A659283E40A740EFE1CAFF54C0337F0E413E283E409D865DC383FF54C00F0F4E02BA273E4080CBF5AA5CFF54C05855538472273E40C414E2A55EFE54C0BBDA30449C253E40	0105000020BC0800000100000001020000002D000000ADF38E0BE74713C14BE53172B1584041DA7C6069F90313C1F0BEDBA71958404113E3C40F48FF12C1712E68D00E5840410F5D7AA05FC512C15C72B4E42A5740419CFAE939DEA412C1BD4EA77CAA564041246569C9457312C1CA2E3571E85540412DE1A4A8E54E12C15FE97772585540417A2386AB644912C1F043A0C73D5540413E7CA19F094512C1368A206C1F55404142D496CC663F12C1200D4D03EF544041C1123FC8243B12C17BDCF431BE5440414B34FB107F3712C125C149A89054404174661E2CFA3212C1B126D0D64F54404153399D45442D12C1A80C7B40F05340419A611DC53E2812C19230E4B0895340419C1EF09E572312C1482892DF18534041C6A7FD66D51E12C133181343A052404173A9D38A991A12C1313CFCAC205240410CCF6A051C1712C1B0E9913EA7514041969C0D504E1312C1785D736D1651404190A2A6B01C1012C16D09C5888A504041AD899079FC0C12C1DF947FD2EC4F4041E4AD2758BF0912C1B8C118C62D4F404174CDF9E8AD0712C177F3200F964E4041F56F7A6DC40512C10F772C1BF34D4041849D25CE12FA11C1D3D961A9E5494041E7C3900D02F111C1539F7AD1B446404172FFE43AA8EC11C1DBBB32FA324540413544ED8B77EB11C14A61B1D5CD444041BF3EC0FED8E911C134B411F655444041A23FEF7617E811C19ECA0C56DF434041ECE9DB1FACE511C148E6769C514340417A9691D40EE311C1B37CFFC0CA424041E1E90E7D9EE011C16CC4D87F58424041C910163ED9DD11C185B75A1EE8414041B013DAFB18DB11C1E4D1A37A80414041F50CC9BC85D711C1D13617EF0D41404119743DA1F0D411C18C3D72EFBD404041696CA821B3D011C1588E169B4840404114F0EE5AD3CC11C1334818D7E93F404169C3737C17C911C17BEF4AF8963F40414FC03C29F9C411C1D3800C62473F4041848F7F2CD3AF11C1ACC7E529C63D404193ABF63B32A411C1D62DAAC2F53C404176295279A55811C1B4223EF49B374041
90	10080101	1	USB  41	41B	7	10	Hillsborough	7	0	0.549	892.6834	892.683369643467	0105000020E61000000100000001020000000E00000088A9B583D29C54C0DED3D24647F33B400D469AB2E09C54C06B69782533F33B406B6569BCE49C54C038C3416A2DF33B4044B6542AE69C54C0F16DDF622BF33B400BC45FEAEF9C54C0DAC163C71CF33B40EFE929A1F49C54C0BE2FF7D817F33B40860F67E8099D54C00CC779CCFAF23B409990CE88179D54C05B7F373CE8F23B406558F975259D54C0D3716C68D5F23B40837E9647339D54C0696C16E3C1F23B40B1D60119419D54C0678CD35DAEF23B40BF47E5B04E9D54C02C2509FD9BF23B40B42C5CB65C9D54C06C22160889F23B40A53BD2175D9D54C0FDB9B58688F23B40	0105000020BC0800000100000001020000000E00000047DB77D737F006419F8C60AE271A3441BBAE820D71E706413D64C94EBB193441E7B8E954F1E40641A22300749C1934414A3487E60EE40641637EE18791193441A0E310F005DE064163DFF9C342193441E0F86A191CDB06417B461D82281934414D327BEAF1CD0641BC3A9A518C1834418F8739A983C50641EE7CF983281834414A275BFAE5BC0641EB391C52C3173441CA2AC4E258B406412F5D2B415A173441BE01BCE6CBAB0641DB951131F1163441545431F162A306413554AB6A8E163441F722872DB69A0641297D73882816344177C968E2799A0641F6BF89D125163441
602	87030000	2	US   41	41	6	87	Miami-Dade	6	10.556	10.834	447.4445	447.444465372667	0105000020E61000000100000001020000000A000000677C79A5270C54C03101B1665AC53940F42ACACF260C54C01B18BDB45AC53940843224F6FF0B54C0DCBD264D5DC539407270268AFD0B54C0D7B237655FC53940ED5E8D1EFC0B54C0D1CA69C062C53940134D8726FB0B54C0834E9E0269C53940202E9DEDFA0B54C00BE3D6EB72C53940195EDC5FFC0B54C04754FC69AAC5394033B57B68FA0B54C0AE111B5AC9C539408AF44C58FA0B54C0BADDB191CAC53940	0105000020BC0800000100000001020000000A000000E1359A5A0A292C41387C07EBBDEF1F4171BED9DD2B292C41A5D3FF17C5EF1F419E2CC074442F2C41742C8CE311F01F419EE6989BA52F2C41EAE4F68A41F01F418C60FD6FDE2F2C41947AC3B38CF01F41B0A076EE04302C4119086C0618F11F413A35592F0D302C41D75C0301F4F11F4130823649CF2F2C413EC6755AC2F61F41230AC3291C302C413B3F02AA71F91F41E17F8D9E1E302C4115B967B28CF91F41
31	93160000	1	US   27	27	4	93	Palm Beach	4	0	26.086	41998.1366	41998.1365961258	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
79	35030000	2	US   27	27	2	35	Madison	2	0	5.794	9329.1008	9329.10075962962	0105000020E61000000100000001020000001F000000536CD345E0EF54C07D0B4431A64D3E402C3D56E0D8F054C0E4D64BD3ED513E40B20CB6C6E7F054C0003345372F523E40749CC4FBEFF054C05BDFF80352523E407A2658CCF8F054C0AF866EEB75523E401101EDE001F154C064307FAF99523E409A15537D0BF154C0B8BC3A0FBD523E4089353EA813F154C04E9E5A32DA523E405F66F8AD1CF154C00D761E62FA523E40999848BE0CF254C0D27028C44B563E40A604AA3C18F254C00F68D6CB75563E4013856ABB20F254C0D087127C96563E401D95D5C828F254C06BDE3A57B7563E4074E6C0B232F254C09CCFDB87E2563E40E5B782515BF254C09E27E02895573E40B03179699AF254C0FD5C0FD6AB583E403EF8507DA4F254C0E3A5F0F2D7583E40238B56B9ABF254C0482EA734F9583E40A6A0DBA2B2F254C060A1F2FD1B593E401467E4F1B8F254C082CD9B403E593E40D8FDAB3BBEF254C0E9A427985D593E40853A6216C3F254C017BC6BDB7C593E40D3465E283BF354C0A552A416AA5C3E402B872B3056F354C0FBD0A249605D3E40671512145BF354C0E3F746A97F5D3E40FCF66A2E5FF354C0A58F0079975D3E406E035F0164F354C062102D3AB25D3E40144DE29C69F354C04EB2BA57CF5D3E4059ED91D26FF354C09C81D0C0EC5D3E403A080AD38FF354C0A96993DF7D5E3E4064409CB29BF354C0235C8F52B45E3E40	0105000020BC0800000100000001020000001F00000060E2BDA21BC809C10875BE4941A340410BD5B98232590AC1F0ACDD415DAF40415566A784E4610AC10A99714C16B04041876E07F6AF660AC13EB005D778B0404140393DD6D76B0AC117434197DEB0404134287DCB28710AC17369510544B140415AFCDDF0CB760AC1344BDF7CA8B140412660855B977B0AC1751F0E4DFBB140415E41C734E3800AC14DEA11C856B240411994A090D10D0BC15BEF4087C5BB4041D3259E2C8F140BC1BC1A47EF3CBC4041EA6A06CF88190BC1D04A82B299BC40415FEC02043E1E0BC12EB533D2F6BC404159793FCD06240BC189206B1371BD40417F700712B83B0BC1B4D5B99F6ABF4041B817D9F582600BC1E53DA6467FC24041D90E1FBB63660BC15E586E23FCC24041842EC2399A6A0BC166C4C22F5AC340419DAA995E9D6E0BC192E3BF67BCC3404199609B1444720BC12A305A051DC44041B07129B550750BC1C03EC14A75C440414AEDBA8D1A780BC1CF94863DCDC4404101F7B3EAE4BC0BC186E58598BBCD4041B64B0BAE61CC0BC1796AE3E1BBCF40410C410CB030CF0BC1C42CD42614D040410CA6F7B08ED10BC1B185FE3C57D040414CDF419058D40BC1DE1306ABA2D0404124A2478B98D70BC1C30DDED6F4D04041E8D9DBFB34DB0BC1924D38F947D1404181B3A70CD8ED0BC10C11BB82E2D240411A46137CC1F40BC1892F99837CD34041
26	75010000	2	US  441	441	5	75	Orange	5	0	14.201	22862.7915	22862.7914863554	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
21	86100000	1	US  441	441	4	86	Broward	4	0	24.597	39585.5976	39585.5976267973	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
24	72090447	1	USA   1	1A	2	72	Duval	2	0.516	0.93	672.1655	672.165460710215	0105000020E610000001000000010200000014000000B6D553E1336754C06DFD912FE94C3E406DE13C00336754C01553B671F04C3E406640310B2F6754C0D7A11480114D3E402A1929872D6754C0D838519F204D3E40E33158852C6754C06F3503DA2C4D3E40C0E378CE2B6754C0F0907EBC384D3E40767797622B6754C043D68E9D444D3E4089A268432B6754C095694F8F544D3E405036F0B42B6754C01E29CF9C664D3E409B5D29762C6754C061B06AC2744D3E40CC4012C82D6754C0024284D8844D3E402EBF6E832F6754C0D32BBFE3924D3E4044EAB7AE316754C0353F748EA04D3E40AEFB5579346754C041290124AF4D3E4001DE672A386754C0576734DBBD4D3E40F8D532CB3C6754C0CD1C6F1CCC4D3E4046CE4517406754C07941B5BCD34D3E400EA228EB416754C03865B6FDD74D3E4039D2AE38576754C0D97E7F77054E3E40181FEE0E606754C02FC85A511C4E3E40	0105000020BC08000001000000010200000014000000BE5C6F772E401C4186227934B78D4041A5FD931473401C413ABEAF4CCB8D404123233DEEA7411C415B4227D1268E40413F6151861E421C4183E2C6B2508E40414B0BEA946D421C4157CD5594728E4041C7B0B30AA6421C414C860385938E404126FF66EEC7421C41007EA675B48E404109424B39D3421C411665EFB1E08E40417A232F37B3421C41671967CF128F4041BA5465C17A421C41DE4D8B1A3A8F4041B0D694FB16421C410B42D9CE668F40410110B73A93411C41E889CADD8D8F40410C1F26BFED401C413F35B9E6B38F4041EBA01B6C18401C4142479383DC8F4041DB6713C2FD3E1C416725C989059040414563C0E49A3D1C41277C23552D90404153A907C79D3C1C41AD4E24AA429040415E905379113C1C41C51137904E9040416FAFABA9AD351C415F6D7CDBCD904041CE1EB49307331C414A037AB90D914041
25	15090000	1	US   92	92	7	15	Pinellas	7	0.895	6.857	9576.2845	9576.28454746722	0105000020E610000001000000010200000016000000480DEF6CDBA854C0CBB77D460EC73B40E7FE4DB2DDA854C0D0570A420EC73B403847746CDDA854C00FA878431EC73B4069F5EBE8DDA854C02E4DAF3D3DC73B40E0D47EE2DDA854C06042A674DCC73B40DC46569DDDA854C0310944DBFCC73B40E7718C85DDA854C08A3F67D9E7C83B406D787BECDDA854C0CD2F1D29C8CA3B40325B8D32DEA854C0C315EDCCA5CC3B40289B3C5EDDA854C0C3431816ACCC3B408107FAACDDA854C058AD4DCC84CE3B40C6D04E85DEA854C0F298AE473BD23B408DF33CEADEA854C01605B00D18D43B40D75CA813DFA854C0C0A1F9C52FD53B40E340BB66DFA854C041BC23CE73D63B40D21E5AB6DFA854C05B9EDF74B4D73B400E76BF13E0A854C03AD7FC12FAD83B40891D6F41E0A854C0421B07E989D93B405FBD45A2E0A854C096E7238688DB3B40A2533DD4E0A854C02F77F3FF8FDC3B4041C6D702E1A854C04A597D0AF5DC3B4035089810E1A854C087D55E2F25DD3B40	0105000020BC08000001000000010200000016000000FBEC7947F1D8FE404A4221CAC627334154FF08FB23D6FE4089EA6C4AC72733412109581A8DD6FE40CA3DF70620283341ED65CC3318D6FE40927B2509CC283341FAF62794DCD6FE40296CE1713F2C3341A70CD64058D7FE409E380A27F32C33415B3E0FC58BD8FE4029643E010B323341C945DC7345DAFE4021FD1629743C334137294AAA24DCFE4007BF4776CE4633413AE0860132DDFE40AED8001FF14633418D51BED100DFFE406D44011730513341CC56854D5CE2FE40377FB429CA65334181BAA00315E4FE40912BF4B21F7033412559A7972DE5FE40A2F2F9CC2F763341A4FBEE6847E6FE40D8111DD1357D33410A00378C61E7FE40AE58B2122984334133C4D5A970E8FE404239A2E6378B33419EA257FCE2E8FE40DE56A50A568E33411D900582C9EAFE40FF77E159679933413AB03E9FC4EBFE4090AAD0551D9F3341C29AEF1A03ECFE405B0B49064EA13341E711774D2BECFE406B28482C59A23341
45	16261000	1	US   98	98	1	16	Polk	1	1.194	1.994	1285.1878	1285.18776322354	0105000020E61000000100000001020000000B0000004A8263E7FA7554C062460E466AE73B4002976A35F97554C0A0C49ACB69E73B40421B2485E47554C05CBC2D6366E73B402BA47A00DE7554C085CEB71F66E73B40390BD95ABD7554C05376224966E73B409CF3781D717554C0C5936D0266E73B40F99F02F5567554C057DCC0DB65E73B4074C101994C7554C07917B5D465E73B4080CF8181447554C0739537F365E73B40BB0DD45D267554C0D074E6D566E73B40FAE79CFB247554C088254DE066E73B40	0105000020BC0800000100000001020000000B000000E9F95AC71B6C174107A4896528D133419C511562A16C17412275458325D13341681F814900731741FA1E8ECC0FD1334116A7BD3F02751741C21114740DD1334188FBEDB1107F1741EBAB65EE09D1334104A87AA28C9617410D3F561EFED03341C9AE64569B9E17412A8F2CC4F9D03341B389493CCCA11741A0164A39F8D03341342384574AA417417D7AD2CCF7D0334111A6B92693AD1741130A67ADF8D03341A14F5D4400AE17418E99BCB7F8D03341
483	13130000	1	US   19	19	1	13	Manatee	1	6.517	8.466	3142.649	3142.6489872644	0105000020E610000001000000010200000022000000146A60FA1FA454C07144BDC9418E3B40884EDEF21FA454C0D5B9B9F8DD8E3B404E966FF21FA454C03658A69204903B4044E08E1C20A454C0389FDD9F18903B40D673EAA220A454C011C4A0922F903B40AAECDAA521A454C08295D36A45903B401293730923A454C04970DD685C903B40E5EFFDB824A454C06D9A7B7971903B407EC18DF926A454C005C4114388903B404AB37BEE29A454C00EB81511A0903B40B929EC7D2CA454C0D4281AA1B1903B40274B97292FA454C03EEEB352C1903B403F13541D32A454C0A6FC5556D1903B40E200C03236A454C0B4381861E4903B40AAA60F893AA454C0F0649C7EF6903B407CCF36A03EA454C0B32934E004913B4042EA4FB642A454C0FD0A811712913B40184EF20147A454C005277A0C1F913B4003B08EA94CA454C0ADB3F85B2D913B4013806A9A6CA454C0B4C50FE77B913B40ECA7AF0790A454C050E47EC6D2913B405ACC3B5B95A454C09B9AD299E0913B40A01FC3249AA454C05F640FDEED913B406453B0999FA454C0A229DF83FF913B40451C414BA3A454C0A2F09ED40D923B4033970F37A7A454C0F459AE0B21923B4022839686ABA454C04DF18BA738923B4025FB90A8AEA454C0231F5A674D923B40FC76744CB6A454C08AE1251383923B40112762B5D9A454C01D3F447E7E933B409F8D96EFEAA454C0F3720FFAF8933B409D4DF0FCF2A454C05B619D9F32943B40528CCB93F8A454C0C908774F5A943B4034F7D510FAA454C024C7EEFB64943B40	0105000020BC0800000100000001020000002200000037C5F8C7D0370241A2EF58026BEB31413F3BBA032D38024152DE268ECDEE3141B481AF85D2380241D139A71730F5314153892BBCC3380241BA0DD6629FF53141321472907D380241C20967D71EF63141C48C1FC6E937024138FE5C4B98F63141E1182EE31A3702413690CE3518F73141586A64FB1B360241C76C98818DF73141B2C74B69C43402413FD448800CF831410E7D28EFFD3202410F7D085191F831411A8F3FAF72310241941D3D66F3F831417A3EC1F0D42F02413BD81E244BF931415FADB6D50A2E0241FA1531BBA4F93141ACF45D638F2B024158A666670FFA3141D81F9B51EB2802417E7199FF74FA31419DC5E9306C2602410FE547D0C5FA31418E6A3810ED230241B227B92910FB3141BEE732B44C21024112119C2059FB3141E019C109D61D0241AC854AF1A9FB3141610A5D77440A024181FEB5BA65FD31416007AC2590F401411617CF9D50FF314182C023354DF1014165DD8BA99EFF3141E3EFE9415FEE0141A733C878E9FF314142FA84D909EB01410969FFC14C003241DADC8386C9E801415947CD1C9D00324139AFDAF867E60141B1189BB508013241573C2145CBE30141F7464EC88C0132415F9C8453E7E1014199CB89B100023241DCB437D04CDD014184E434662C03324146078C87F8C7014116F76343A80832418432594598BD0141F489F22E540B3241A3C614FBBEB801419FE7710E960C3241BBCA2F2F61B501413B5083A9730D3241A96E32BF7BB40141D0E44242AF0D3241
37	60020000	1	US   98	98	3	60	Walton	3	3.025	26.636	38116.6016	38116.6016050915	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
41	38040000	1	US  221	221	2	38	Taylor	2	0	0.914	1471.582	1471.58204237269	0105000020E6100000010000000102000000140000006C508E0D56E554C0C8C56D722E193E40D0E184FF55E554C0992F6BE733193E40B9967AC155E554C08EA24BFE4B193E40AB56E4DE54E554C000DA9F6A4D193E40BBA3E99E54E554C02266FAF25D193E40F9234F0C54E554C07C915CBF6D193E402A4B3A6553E554C01653E78580193E4067CAF88551E554C0A43F9C94AD193E40C480C7644FE554C0ABCB63E0E0193E407BDD574D4CE554C0BC3346532B1A3E40B9BDD7AF4AE554C0BFC03513521A3E403224E88E4BE554C0428184C5561A3E404B15C34644E554C05D7A5016061B3E400074FFE442E554C0AAA5A42F281B3E40130ED2F441E554C0F42DD6654A1B3E406908B37741E554C039C26FE76D1B3E40489F3B3741E554C0949499668D1B3E4032575E3441E554C02771F2DAF51B3E40E2323DFD40E554C0B32D5CCD3F1C3E40360C743941E554C0EA8ADC668C1C3E40	0105000020BC08000001000000010200000014000000F3B04CA711A403C1E1024456370F4041E16DDAB203A403C197C04279460F4041CB5DE80CC6A303C12316094B890F4041706AAAE23BA303C1FF70EA0C8D0F40411A0375A904A303C11AB401E4BA0F4041F17B1A519CA203C1755F3D9FE60F40418921659F24A203C161FAC2991A1040416CAAEA22D6A003C1B48B8F4597104041747A5B98599F03C1F6A17434251140419B0F4633319D03C1CA314A33F3114041419727BE109C03C168B4D76A5E1240419A2B74A0929C03C1795A30A56B1240417B248F997D9703C1F98EBABB50144041ACA169DF859603C16A153417AF14404175E0AF92D29503C109DE9DDB0D1540415FF91566639503C1320A26517015404146543EDA1C9503C1B1B786B2C7154041B8AF012BB29403C107317FA9E91640415F124299469403C1A3B091E4B61740419DDF22F51D9403C1C74600968B184041
42	90060000	1	US    1	1	6	90	Monroe	6	18.507	19.298	1272.9788	1272.97881014009	0105000020E61000000100000001020000001B00000035C0710ED42054C0878547856A033940AB529174CE2054C0EB9EABF480033940C5E653A8C82054C09904AFEE980339405E4856B4C52054C0A21BFA8CA70339406CEA4486C32054C0424AFC5DB603394083BBFD8CC12054C0CD80AB2FC5033940AEEABCC7BF2054C0D261BC03D70339408724F443BE2054C030B2CDE9EA033940CCE3DE53BC2054C042997A840904394044ED4C55BA2054C0AAF3CD312D043940915126A5B72054C0521F0B8A68043940DAF05F86B32054C0B07046CDC3043940E2D49585AD2054C0AF9605074B0539403F0A500BAD2054C0207D18BD58053940A617E6DDAC2054C0EDA85AA96F05394033C13CE6AC2054C09F3033D4820539408739FDCBAD2054C0276284A8A105394082E15CCFAD2054C0125A11C9B1053940F46F73B7AD2054C085667898BE05394098B7DB22AD2054C0BBFB8556CA05394059B28C4CAC2054C0750E2052D8053940F5529801AA2054C0D34D13B8F005394092D5E8FEA62054C08EB932CF070639403B6009F6A32054C0F495ED551C06394088C367E4A22054C0AC9FBE2C23063940F6129EBDA02054C02D1B4AA72F063940497E4B3AA02054C08482D14932063940	0105000020BC0800000100000001020000001B00000086E3970D5DF22841A8DE5FBA38330E41CFB26A933EF32841067986411F370E41E19208FD27F428414EE4EA484A3B0E41023886C79EF42841A6146C81D43D0E41A56A214FF6F42841A516A81067400E41B1D3AD8045F528417208389FF9420E419F76565C8CF52841EA93608F11460E41A29A41CCC8F528410DA87F3185490E41C14B4AE815F62841618D41FED34E0E417EABD61965F62841E89692DE03550E41AF0C1363CFF628415A4E7E194E5F0E41D21D944872F7284150CB251E216F0E41784103865FF82841A2F3838893860E412983CF4772F828418B29BB12F4880E41AB8F5A8878F82841CCD07216ED8C0E41A9D0AB7276F82841F4BC56603F900E41284294EF50F828419D54278396950E413F4AC9C14FF828410BDA07F161980E4171E3EC0453F82841310EB8489A9A0E41A746B9026AF82841438BD88AA39C0E41D4A0D0498BF82841C67D4D57109F0E418F369EFCE6F82841D466CF0A4CA30E41078737BF5FF92841868C25244EA70E416E291196D9F9284146CD3682DEAA0E419ED9208404FA284104FC79880EAC0E41261603FB5AFA284178E8FF5F39AE0E41437E0C9C6FFA28417C907B90AEAE0E41
46	26030000	1	US   27	27	2	26	Alachua	2	0	26.189	42126.0692	42126.0692226402	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
48	46020003	1	US   98	98	3	46	Bay	3	0	9.813	15775.5862	15775.5862041114	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
47	48010000	1	USA  90	90A	3	48	Escambia	3	2.485	15.597	21202.507	21202.506950967	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
80	72040000	1	USA  90	90A	2	72	Duval	2	7.514	9.572	3309.7407	3309.7407382693	0105000020E61000000100000001020000001600000092F78D69C76354C09B460F7F67493E40D094947BC76354C031D6FD3B88493E40C7EE91A2C76354C0A4577E8AB4493E40F158B8D1C76354C0B24D9AE0EB493E40D0EA732DC86354C0062CB05C1C4A3E40A9BB1D59C86354C0A9A24ADD304A3E40CF72B571C86354C0326892894A4A3E40D04C8C78C86354C0B001F0605D4A3E4034D20725C86354C06CE08BA4734A3E40D003439BC76354C0B8B37FBC874A3E4000D52FD5C66354C0BEC7E5019E4A3E40B7DC97F7C46354C0DB81F67DD14A3E40EBC511A8C06354C0DF828E95444B3E402D0E108ABF6354C045C9D701654B3E403F129534BF6354C0ABA73FE3754B3E40577948F7BE6354C0863CC7638A4B3E404117B31CBF6354C09EF2F2E89F4B3E401E27BDD4BF6354C05583A021C64C3E400AB43725C16354C0F08CBE93D54E3E40AE53A940C26354C0D1FD3CC67C503E4007214D77C26354C0A9DE8F6AE9503E4092C33089C26354C090412DCF0A513E40	0105000020BC0800000100000001020000001600000064EE862B96471D419BD13ECCD08340416E2E005294471D41EC1F0EA42B84404142EB9C6C8D471D41F0347796A68440419AC0F24685471D41E2810F244085404133D364F66E471D41EE56CDB0C68540415693500F64471D417C066B96FF854041FDC163765F471D4101E4FFD3468640411FA363765F471D414CB0F11B7B864041F90E93087B471D41D88BF5DEB88640415DCE54B2A6471D41A4D59899F08640411825C9BFE4471D418465265C2E87404113FC14207A481D413FECDE20BD874041B7DE90D7D2491D41E1CBA346FC88404189B534772C4A1D4135F14C3056894041B6296409484A1D41714211038589404164F58CB95C4A1D41AD2A84E3BD89404115EEF4CF534A1D411CF1DA9BF9894041905F128B3C4A1D4117B2A2082A8D4041301C4DE1104A1D416CCDACA0E19240413830CBD0E9491D4188D4FAF2779740418C87963EE5491D4176A2066AA598404112CEA282E3491D41D325361302994041
601	48080000	1	US   98	98	3	48	Escambia	3	1.689	2.054	589.2094	589.209399737368	0105000020E610000001000000010200000006000000C29574C1C2D155C090834D97FA653E405A014DBDC2D155C07109FA40FB653E40BCF6EC34BFD155C060DCAA958B663E40646D1CEFBED155C001EE8002AA663E40816104F9BCD155C03296DE50E5663E40DF95BB37BAD155C028105F2754673E40	0105000020BC0800000100000001020000000600000005519BD9393734C136623334C73D414123B4DB54393734C13ECF270AC93D41411D2FD56FC83634C1F4530FCD583F4141480245BFB93634C185012553AD3F41414327A385813634C1F71D835051404141750768032A3634C1A4862B4984414141
56	08051000	2	US   98	98	7	08	Hernando	7	0	0.072	108.9081	108.908149136981	0105000020E610000001000000010200000003000000910E57A33B9954C020F15B763A8E3C40037880AE3B9954C03D06802F088E3C40BCCECA303B9954C0E01A6D28FA8D3C40	0105000020BC080000010000000102000000030000009C2B363E5F7509410B9F18AC157537411F481D713E7509417F649CB4FE733741BC899B2E847509410933BEC1B0733741
57	72100102	1	US   90	90	2	72	Duval	2	0	0.268	448.4881	448.48809005198	0105000020E610000001000000010200000019000000F996A82F296954C0616EE993CB4E3E407648C49D2B6954C05C81CC65CE4E3E4007E1449F2F6954C057721521D34E3E407E5A2CA3346954C0F7968E2EDB4E3E40D8E7425F396954C0FAF0ED38E14E3E409C610EC53C6954C034F66FA9E54E3E407C5E4F63416954C01ECDB808EC4E3E40774073EE436954C0024F397DF04E3E4011CDDB63466954C0FAACD6BEF54E3E406D901764496954C069F95331FA4E3E40AC5F0E38486954C0AC9BBCFFF74E3E40255984774C6954C067E9D2B6FF4E3E404C5EA8E5516954C03C60A03C0B4F3E401649C006566954C04C2C7897164F3E402818DAEF586954C0AC9890C01F4F3E4043AA0C1E5D6954C0868C9C812F4F3E40E8658C3E5E6954C0DDF344F2334F3E40BF0316505F6954C0821A704B384F3E40DE99D25B606954C014E6637A3C4F3E4080A03E62616954C0DBD30583404F3E4008093D79626954C0FCF956C8444F3E40AF6D0B57636954C0CB2A2B37484F3E408632FA45646954C0711667F04B4F3E4066A9E824656954C0CBCFFD8B4F4F3E40866CB702666954C0592F0C33534F3E40	0105000020BC08000001000000010200000019000000194F11878AA91B412488686D0C9340413F3E39A9CFA81B4175D96C6214934041FC7E9DA29BA71B41BD2170BB21934041A7E34F431AA61B417573AA5938934041D7DC3C40AEA41B412ED9B65E499340411DF8A50CA9A31B413FFFCCDF559340413CB10F0F46A21B41FBA2E1CE6793404170C8C1A982A11B4199B3204F74934041C426A4E8C5A01B41C4FD5507839340418F702746DF9F1B4107246C888F9340416AD59D4A39A01B41C3F6B6618993404127B6E6FFF29E1B412420A7059F934041B5AD7D19529D1B41D8FFCE4ABF934041F2797868159C1B41F5898D06DF934041521D1655369B1B414A4A7F9AF8934041920A5641F6991B41DCC2F68B24944041083CB6FE9F991B4110F5C0ED309440416E49CA394E991B415F238C0D3D944041419B772EFE981B412B47E2B748944041E569C6B7AF981B4111FD99F7539440418621134C5C981B41A68D9DE05F944041CEB90EFB19981B41F148567369944041EE05088CD2971B414A0775D573944041B05005EA8F971B41AFFF70E47D94404148A20FA04D971B41D3392F1388944041
58	15090101	1	US   92	92	7	15	Pinellas	7	0.279	0.375	155.6963	155.696276807144	0105000020E610000001000000010200000002000000EEBF2325DDA854C0D7B350F702C63B40C8231CF9DCA854C00FF3FBE1A6C53B40	0105000020BC08000001000000010200000002000000EB3FCBD395D5FE4020783D0EFC213341D84878305FD5FE40E2403B14FD1F3341
38	55003000	1	US  319	319	3	55	Leon	3	0	11.14	17924.6774	17924.6773812037	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
39	72080000	1	US   23	23	2	72	Duval	2	0.819	0.926	172.449	172.449001916975	0105000020E6100000010000000102000000080000002B93392ACC6A54C04CCBEC3343563E40DC964F84CF6A54C034FC5EFA4C563E404CCB5440D36A54C0F0C89F0C57563E400A8F978CD36A54C0C9EF2BDA57563E40E10866C9D46A54C0215A10E85C563E402A636A81DD6A54C0062C4B6276563E4086AFFEECE16A54C0A09CF44F7F563E4037EB3713E36A54C0A024338F82563E40	0105000020BC08000001000000010200000008000000B38279746D2C1B41574D3118DCA74041D1EE8F926C2B1B41781FAD68F7A740411625EE434E2A1B413514169113A84041D9C5486D372A1B41E2FDC4CF15A8404193BF7CC6D8291B416BA30CE823A840419031DB983C271B4169E8BB186BA84041926F6553E9251B41196A511F84A84041928A9D3B91251B412D9495328DA84041
40	87140001	1	US  441	441	6	87	Miami-Dade	6	0	0.74	1192.323	1192.32296466414	0105000020E610000001000000010200000025000000D57215E51D0D54C0C2F31213A0EE3940A5689C5C1E0D54C08F31D8CF8FEE39408D2A32501F0D54C0924C43317DEE39405CB9DDE2200D54C098155BDA65EE39405016D424220D54C0CACA1E6F56EE39403C9BE0C4220D54C0E05CA9C44EEE394010E335CB220D54C044A30A774EEE3940A393847E230D54C0F051B37E44EE39404E4940D6230D54C0AC5FEFAC41EE39401F0CFDAA250D54C0F38FF6392BEE3940B9776BD8270D54C03F2CCF3919EE3940237E3F842B0D54C0938EDA9900EE3940F37683DE2D0D54C05C9BEBEDF3ED3940CC310D00310D54C0E5A33F89E6ED39407311A4D9350D54C05082DE5FD2ED394046476C5A3B0D54C0AA94B2F7BEED39404814771B400D54C072EDF505ADED3940C1E9F49E4A0D54C0CE69BD1587ED39408224C664500D54C0C10D37D973ED39408C43EE6C510D54C044E1116970ED39405E07AA0E5D0D54C06D1277A649ED3940E0826105620D54C082FF25AB3AED3940BE4517BF670D54C04196E99828ED3940CAE0CBC7700D54C008169DA511ED3940682AED4E740D54C06D5005DA07ED3940C212633D780D54C0D8D12FCCFEEC39401193CA8F7A0D54C049DEFCC7F8EC3940923F7FF37B0D54C0C9725EE1F4EC3940E867EB20810D54C0BD0AE917E9EC3940305059EE850D54C0535699D7DEEC3940FF8C65E4890D54C0A8764233D6EC3940AF33E1E68A0D54C060D052DFD3EC3940218D59CD8D0D54C09C34632FCDEC394033AA032B8F0D54C0F27A3609CAEC3940ED41DAF2920D54C01E5FA451BFEC39404FBA12589B0D54C01ADF371EA9EC394098B15E009C0D54C017EDB026A6EC3940	0105000020BC0800000100000001020000002500000062832F6DA0FF2B4106525B826FC121414CAE0ECA8EFF2B4167004901BBC02141D1C35DDE69FF2B41CD756D3DECBF2141ECDE7D552CFF2B4195DEB1F7E8BE214176E90EEAFAFE2B41971C3FA13DBE2141D42EF958E2FE2B413A730872E8BD21415DAC1C60E1FE2B4180058113E5BD2141FDCF0DF2C5FE2B4156146E5076BD2141C6F2C362B8FE2B41061C03F556BD2141C1B6A96F70FE2B41A711967F5DBC214107CD6F491AFE2B4180DAC24C95BB2141A1C147A788FD2B417BA98D4283BA214177FC4F1E2BFD2B4177B14A21F6B921413EDBCA66AEFC2B419DAD6FCE60B921413AB2822CEDFB2B412A49EAFC7FB82141807F1FB111FB2B41B3710762A7B721410A550D2954FA2B414932342FDFB621410ECD07E4B0F82B41A299C7CE37B52141963BDF92CAF72B41C7BCDF0761B4214156C6A667A1F72B416547F5A43AB421413927A452D1F52B41A16875E289B2214185D7C22C0BF52B417A5E1780E2B1214141E838AC26F42B41621483A918B1214107A842C0BDF22B410D5D30E717B02141C81C01DD30F22B419F5BBC65AAAF21411B3E31BB93F12B414D953B0445AF214182E6AEF936F12B41D1582BB801AF2141CFA7EC7CFFF02B4153EA321DD6AE21419F995E8C30F02B41E7A4531E52AE21410CADD18C70EF2B41F7D8AE3FDFAD214195D32133D2EE2B411EE2DE6E7EAD214166B51BD8A9EE2B416ACB285E64AD21419A7C1CED35EE2B41A49D9D7D19AD21419DC1B855FFED2B411A30E33AF6AC21413E98435D68ED2B418649D0707EAC2141B9394C0119EC2B41F0012C2886AB21410C2D84D3FEEB2B41CE20AF1665AB2141
49	79050000	1	US   17	17	5	79	Volusia	5	0	25.873	41640.092	41640.092023583	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
52	54030000	1	US   19	19	3	54	Jefferson	3	0	18.076	29098.5323	29098.5322825078	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
55	08020000	1	US   19	19	7	08	Hernando	7	0	19.514	31393.3728	31393.3727913001	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
59	09110000	1	US   98	98	1	09	Highlands	1	0	24.521	39446.316	39446.3159801744	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	0105000020BC080000010000000102000000760000001951FF46DBC51F41756710330E2C3141B194DB5648C61F4123E073DD0E2C3141553588FF5CCE1F41E8F5A7811A2C3141A0EA440A5FD01F417D59FADC182C3141BBAC36D68FD21F41BA4F96180A2C31419DFB5BC87DD41F412596CD39F72B31418561168E05D71F415FFECB88C32B3141857500462DE11F41493120ABD02A3141931A60AE1CF81F41A0F58D7AA8283141670A4DD95BFA1F41698E06E4782831414FEBBD107DFC1F41186C53FE5C283141917D3A0C8DFE1F41A2936954522831415B7F77275800204135B30C6E562831410FB16BDE6C012041610DC24D69283141CFB2345360052041F6414160C4283141FE5D71ACBE0620412E60B5F0EA2831419D087A53C9082041EF9105662D293141BC706F172F202041CBA95D042F2C31413FF577BEF2252041786064BAEB2C314120087F22C42B204124FA4F36972D3141E5EB68ACF2492041E4EF8B0801313141F2927E21E35E204156F02BB55433314124C172B78A5F20416C70C30361333141BDB55CF74C60204111618EDC6A3331418A121CCBBF65204134CA7C735A3331416214962E62A520417871592C97323141470D4A69BBDB2041F8F77E7C03323141B99BE161BADC20416EB2D968083231418723885899DD2041A6BE475B1632314139D636EE90DE20416E6B1041323231415A888BE66FDF2041F9CC331353323141986154C352E020412714023380323141A21CB43D66E12041608F9995C732314171F9BC5AE50421415C48BAC4213C3141D853825E76062141AC524D3A843C3141BB026DF2FD072141F25C3361DA3C314144D911DC720921410F804481273D314178B00977DB0A214104B094F6693D3141850651C9780C214146125F86B03D3141B39FD84EDA1B214161BDD7D0FC3F31418EE2F9BCBB1C214130A3DB741E4031411996D8DBE81D21410340E753514031417D365D64061F21411A221A958B403141330C856737202141E6216810D74031413C5E3D0A512121410BEA1CA7264131410589800761222141BECD74577A413141FA268257C4392141D114003B68493141A65C5E47E23A2141FC1CE661BE49314109C616E3F23B21415F3093BDFC493141654B4D29EE3C214159104EDE294A314187680EDFFA3D2141E3DA84AF4A4A314199AA4E2B0F3F214152C010335F4A31414AEF59862540214128FD801F644A314116244A849D5B2141EE302FB02A4A31415E0ADDF0565D2141EF4C64D7204A31411BD874CCE15E2141A3B98795064A31417936F9BCA76021417A8E70EBDB493141B2D9F89F53622141BF2971349F49314139F5185B41632141FC901CD2774931412DE543D644642141CBC7A00640493141425577CCE365214123FDBCD9E04831410241872ABF75214189C617C233443141CBA3726C5B7C2141A27EF397544231411DBBD609E69D21411DC428B7E63831418CB10F86F99E214188C2C4DE9C38314142EB40E5E09F2141F2C8A5006A383141603ACF7A20A121416BEC7CED2E38314144732A0F58A221418817C2CC01383141ED8CDCF8A4A321415FACF1B2DD37314185A66AEF83A521412B4A176BBA3731415B841B4E53A721419FA9D66491373141B9E92C0F5AA92141B0D7A323573731417443D29B28AB2141235CA8FC0037314155E26D16E3AC2141F43706BA8A363141462B128A2CAE214135C983362C363141815FEC81C2BE2141F4FD39C6263131417431355B8EF9214127A3B2E79A203141D3D73E63E0692241B72C21C1FF0031418420FA0641B82241C3B409B8F7EA3041939D1829BFBA22411B7FD7AB45EA3041555271B65DBC2241F6768DC0E0E93041E15AE53DDBBD2241AD67FA5187E9304172E1683472BF224128ECFE2A31E93041152C6EB947C122411A7EEFA7DCE83041C26E391FD0C2224158EE6BA89CE8304129B61EFBC2C422419C92B57454E83041197DA63FDEC622417A06327514E83041DBC70C77B7C82241D16DE740ECE73041FB7517DC97CA2241A5C85DB7CEE73041C81E364AE9CB22415C9775AABCE7304180B0D56DB7CD224189F36341ACE730411E209A7E22CF224150401383A6E730414BF40F79E1E922410E778CEC76E730411536DCA919EB2241CDBC455C70E7304103588CD590EC22419723209761E730415D1BC85C36EE224101B6D1CB49E73041C6E30E45A3EF224143991EE62DE730412644B2139CF12241B35B5AF4FFE630412BF60D4B2DF3224199899FD3D2E6304180CC0C6E2BF622413A2861B365E63041D646AE56D8F7224145A61C091BE630417EF116F6E9F92241958C25D6B2E530416D11255A8E7623417B35F7B826CC304197E0F0E76C772341D312CCB2FDCB30414F3140004178234144FAD970E3CB30410DAD3D1A15792341CFFD6150D6CB3041AFE1BBD60A7A23410B046250D6CB30416AC658C0C77A234167FC22FBE0CB3041F144A1837E7B234114341536F2CB30412804A2D7437C23417227057E15CC3041C469FD0ADC7C2341A497DFC538CC30419495E70A6C7D23414E3F2AFA60CC3041198741FB117E2341F3A2723B9BCC3041CB53FF55C07E2341D9A1C0B6E6CC30417C602B634A7F23412AA72EBD2FCD3041F0983947E67F234112BD78A894CD304194C4C55070812341CA68ED649ACE3041E15DFB67A0842341602F1753B6D03041
61	90010000	1	US    1	1	6	90	Monroe	6	0	4.531	7302.2087	7302.20868258209	0105000020E61000000100000001020000003D000000E183F108757354C07209E5E5278E3840E9D9BBD66A7354C0A16B8567F28D3840691A59BF667354C030F24E9DDD8D3840E2DD5C6B397354C0304C9856E88C38409E87EF5C2F7354C02AD5CB01018D38405C9EA353277354C043DE1A27158D38406AB7EAA7117354C032E722EF4B8D38406261C243C77254C0AA53C08D058E38403D2D4E6BAE7254C04A9FDD12448E3840A0BC8C06A37254C09D32226E608E3840E6FCE125717254C03574DD05DD8E384073B1328A607254C0FA7ACFCC068F38404C0A10805B7254C0B6B7741D118F3840893464F3567254C064C448DE178F384023B46F39397254C09A967071378F3840D3ACDA81277254C0EB1ABC9A498F3840F3DC623D157254C04CA702895C8F3840ADEC069C007254C07A4AA782728F38401411926DE17154C0DA509939928F3840FD634DF1DD7154C0CE8FC20E978F3840FB1A573FDA7154C0958D64689D8F3840D7220D9BD67154C01E92E19EA78F38401DE646E2B07154C0B326BF5B26903840DC1DB4F19D7154C03E1FFA6765903840E1DB6457997154C099F6B7CE73903840BA2DD831927154C0C560A77D869038406559E2228A7154C0FCCB3F3A9C9038409B9F55F23C7154C068905FD96791384020569689337154C0744DC8CB7F913840D6D02F602E7154C0360B4D0B8C913840EDAED183177154C096447EF9BD91384005E9668CD47054C055D7C7D34D92384048C320EFCD7054C0E3EA374859923840D803E296C97054C0CE9108D85E923840556FE564C47054C0B66E8C2C64923840825E67D7BF7054C09A3AA120679238407566E037BB7054C02D9D04776892384029527BDB607054C08CCF404F7F9238407B08D7A35C7054C0936638257F923840FE9C69BD577054C0844FD1407D92384026B701B9537054C0A67EF2787A923840151D57D14E7054C011478358759238409FE2B9AB497054C0E3E87F9C6D9238404081E8EA3F7054C04C8892C45B92384057A32CF03A7054C088FACC4952923840AC232F7E367054C064EADA2F479238405389A395337054C0893ABF4B3C923840B55CF43D307054C0F2A5E60C2B923840FBAED9C5297054C0621DAAC8E5913840B764A460267054C04B3C73F1E4913840128FB81C217054C0CC511758E9913840E5FEE331147054C0CE9E9B8CF4913840196902AE0D7054C0D79B00FBFA913840D8FB27CF077054C030F3B2F8019238407317EE98EC6F54C0B94D426425923840275BEC5DE06F54C05204E6C7359238402E77E897C76F54C09D41E63257923840FB76FB9CB96F54C09FC89EFA68923840729B0759AA6F54C093BBC14F7C923840A057DAC4A46F54C061233945839238409FE5FED9956F54C059B74D8496923840	0105000020BC0800000100000001020000003D0000007AE569DC1BBD1741705E26D9BEE1F340656C215950C01741027DD17421CFF340BC72D6AB99C117410D313C2FE5C7F340C0E91C6ED8CF174179BF55158E72F3402F9A9CB10BD31741463236D1077BF34082933A719AD5174106DA8612F481F3400824C01580DC17415FC2F0ABC794F3401A327BAC2CF417410A14C1F390D4F340B14AA3D214FC174158B622830DEAF340CA720500B5FF17417CF27923CCF3F340874C8C42940F1841F0A01B929D1EF440E49AD73EDD141841E8C69156F92CF440D6A8B67E771618413647572C8330F440C7180286E9171841EE04BFE8D132F4402786FEAF59211841692CAD4F8C3DF440C85310A5F9261841CBD7FAE8B643F44002877C59C62C184144B1AECE244AF440EDAB062A533318410094EA829C51F440ECF0EC5C393D1841B8B9E902615CF4404391E3CA543E1841D6AC6661075EF440C0DF6B6E813F1841DF0BF7FF3360F440CB204138AA4018414F7BB46DB763F440EAF808F8AE4C184110720ED45E8FF4407ED79DAAB752184141EE51F815A5F440F10B87F12E5418413319BB490BAAF44046B3D92B75561841BC38B5E077B0F4407EF34DC20559184111B6B9B6F1B7F4402B85954B9671184113A23E33F7FDF4405E66D8B79474184142E71FC83206F540002BC20D39761841527A5A1E680AF5408182B8227E7D1841BED49CB88C1BF540C6A89966C992184193777FFCEE4CF5400D99D17AE39418412F239866DB50F540916557AE44961841F3DE190DC152F5401FA771DDEA971841753238A09054F5409FF02B9F5C991841F2B5D67D8E55F540EE0969E5D39A1841B82317DCFC55F540424A4D517AB71841BEDE9633465DF5405663217BD0B81841C44B3320305DF54065D8C1D45DBA18416A2A70867F5CF540DB650B70A3BB1841CC5A29AA815BF54042D9ABC930BD1841A4840A17B259F540FF479974D1BE1841FD5CB0B9FA56F5400C5101A3E6C11841E62B7C49BA50F5406D90248179C318413076C265684DF540CB351FD6E0C41841C96E81928749F540ACC9AB7ECBC51841F8C48922BC45F5403DA2C49BD8C61841577C2126BC3FF540D8044E1CDDC81841144C0B34AF27F540C9AC7F80F0C91841F2AB37995E27F540781538419CCB18418B4902BBDB28F5409ADA42B3B5CF18410AE24C01A72CF5401E2E631BC7D11841C4594D12D62EF5401A828846A4D31841FC5AA3F23731F540BC96A57648DC1841F29471724E3DF54081DC09CB2AE01841E5C255F8E642F540059585DF08E818411C817A45504EF54028C9675279EC1841567236316154F540ADA3E33B52F1184104B34E9EF95AF540295049B717F318416671993C595DF540AB92275FD4F71841424472ACEA63F540
62	72070000	2	US   90	90	2	72	Duval	2	18.211	19.076	1392.0116	1392.01156012732	0105000020E61000000100000001020000001B0000006F48E6861C6A54C00B3BBEFD7C503E409AC0C6261F6A54C0822F0E5480503E40FAC6EF33226A54C0A61CA8C586503E40B50F7654256A54C05F8629E990503E400AE0E267286A54C0656489619C503E40F4F805132A6A54C07B7706FEA6503E408D6542172B6A54C00C8ED645B1503E40CF96C6AF2B6A54C0B808E734B9503E4037A1D0022D6A54C036298587D0503E40A52013452D6A54C0DB1B1B30DB503E4050F0DB582D6A54C056A6FB4AE5503E40D708D7592D6A54C0C8E9E094F3503E40B399C7072C6A54C0BBC4AFB856513E40109114212A6A54C0C56A45E5D2513E40A6F667C12A6A54C02F2E1CBDD6513E40930679882A6A54C05C56FF10E2513E403B12EF6A2A6A54C05296DB0CE7513E40E03F0AE6246A54C010B2D8AFD8523E40D596917A236A54C0D7F3F7F00D533E401E638E56226A54C0E76895E311533E40A2A5966E216A54C0FAFB1DD217533E40229B08B81E6A54C0BF647D4223533E403127D1D2166A54C045021FAA36533E406CC41239106A54C04E4910E346533E40BBD4503F0E6A54C043238C6E4D533E401AFDF0BF0A6A54C059CF4A5B5E533E402DE939AB086A54C072A69A5B72533E40	0105000020BC0800000100000001020000001B00000017EB4EBF86601B4117B0B17BCC974041E316BCFDBC5F1B41EC09BCE3D597404126B0B8BFD25E1B41BC3DA4F0E797404158D6E027E35D1B41065F523F049840418BF448ADF75C1B4139E41E3F249840419383FB81785C1B41878DA8C841984041FE095F852B5C1B41B0ECE95D5E984041735AC1A5FE5B1B413BCB336A749840418897D8A09B5B1B41425B5334B5984041474F1D10895B1B4183A543CBD29840414F2F6969845B1B411CDC64D6EE98404192AF4DF5855B1B417E1F517C16994041F725DA76F85B1B41E99BE580299A404184DDC4EB9A5C1B41CB4129F4819B4041E2BE272C6B5C1B416F8810A78C9B404191979BC37D5C1B4195187212AC9B404101AF7D4B875C1B41545A08E5B99B4041E8A1B6924F5E1B4128668213589E4041D789DACCC35E1B414BD634C4EB9E404124C38D2C1C5F1B41C96422A8F69E404153876DBC625F1B41B885C810079F404134B77E3235601B41880B9AA7269F4041C0CB26DE97621B41AE51E30E5C9F40416895346396641B41E43F27B4889F40415D5A70682F651B41EC760FC19A9F404151ADB1FE3E661B4140149685C99F40416A95C9DAE1661B41914AABE700A04041
60	89010000	1	US    1	1	4	89	Martin	4	0	19.558	31477.1863	31477.1863238046	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
92	15010000	1	USA  19	19A	7	15	Pinellas	7	9.81	10.191	613.0585	613.058464428138	0105000020E610000001000000010200000011000000CE318B2F0DB254C0C6FCF74B66D03B408E2B16C911B254C08839AF8D68D03B40A67F944B1BB254C05952FD476ED03B4082FD209826B254C0E39A66F577D03B40ABBD65F62BB254C0B16CEA3E80D03B4065A0B34333B254C0823283488AD03B4012A3E30D3AB254C0787740A196D03B40F0C7DA3440B254C0D5CAEC01A4D03B400C16CBAE45B254C071B1FCD8B2D03B40A6B5B6AE4AB254C0C05975DAC2D03B4057ECD5DA4FB254C0A49F80D8D5D03B4068899A6053B254C022C1AB63E6D03B40EFA3526656B254C0D2745258F0D03B40E920F2A758B254C04C9DFD1F00D13B40B842E8AF5AB254C00B04CF8A10D13B40D09DE7D25BB254C0DB91224E1DD13B4001C3BE7D5CB254C040A3DBB826D13B40	0105000020BC08000001000000010200000011000000CECA6F10EB8CF3403EF42445265E334188497F944187F340DE302F1C345E3341BD12E53C8E7BF3405BD92C9E565E3341668D9D06AB6DF340C8AB358E8F5E3341098961AF1667F3402D694514BF5E3341C1B91007225EF340259DC0DEF85E3341B990B213D255F34079BEE8533F5F3341B00273C84C4EF3401AB8DE528B5F33417AF9B5CB9E47F340D395B03DDF5F3341545A6ED18841F340019D627D3960334174702530403BF3404761575CA460334140FF6054FD36F340301DA12B0161334132FFADE54F33F3403C34F04739613341F52B44DB9B30F340D9AE607D91613341CA83F2C22F2EF34070468F2BED61334121479858D92CF34056F7115134623341C7E565CE122CF340C5D6E5C268623341
63	01040101	1	US   17	17	1	01	Charlotte	1	0	1.668	2657.2609	2657.26094479857	0105000020E61000000100000001020000001B000000BD067330DE8154C02C6CE414BFF03A40E916D2AEE58154C06E084C96D3F03A401992D086088254C00FA9025A2CF13A40635566400E8254C0CD4C6D163AF13A4022BF8004138254C0846730C344F13A4040B84F8A188254C02A6688584EF13A4085B5CD771C8254C07FDDC22554F13A40633A4EEE208254C0804A447D59F13A40DC4D3B21268254C0E41D327B5EF13A40503D251A2B8254C0E46B39A061F13A406733914E2F8254C06D4BFF8663F13A405E25C8EB338254C01B385F6764F13A401F206E88388254C0EC9F954F64F13A400B63AF4B5A8254C0D28C2F2E62F13A40C902C8A55E8254C006C8EE8B61F13A406CA79D50638254C04635AFF95FF13A400A3B58CA678254C096E054D95CF13A4052366AF26B8254C0D62E4F1959F13A406A199582708254C0433CEE2453F13A406365E26E758254C030BDE7064BF13A4032DA20DF798254C0D6653EFF41F13A40E36B4274858254C03DCCE10229F13A4062D8F16B328354C009CFEF91ABEF3A40EC82C78A348354C055416C4BA5EF3A40AD98399A368354C0474A9E669FEF3A400ECA8E80468354C0818915906CEF3A406CBF8DB0588354C0C369148931EF3A40	0105000020BC0800000100000001020000001B000000787CEC1061951341F5926F8D19F52C4135A0BDAD1093134109BF1979FFF52C41D716EC0F4D881341CA67F88CE3F92C4198DF652888861341EEA0EFCC7DFA2C414FFE2EFA0E851341D3653CC7F5FA2C41C452536959831341EDD49EE461FB2C41E967B90822821341AE92E588A3FB2C41A6077800C08013411A00BA3FE0FB2C412B74F05B237F134168D41F5219FC2C41082C5168987D13416DE247D33DFC2C41534EEE484A7C13414F6DCF4954FC2C4138023A6ADB7A1341400765835FFC2C413EB5858B6C791341285FB5FB5FFC2C4180338882EE6E13413ACED85853FC2C4111066E38946D1341E08523BC4DFC2C415DF74CAC206C1341E2FE47D33DFC2C4130E9BE19BC6A13419009CD991CFC2C417DC68DC97069134162C2555AF4FB2C41A8330BBA046813412D18CAC7B3FB2C412EEDA6A47B66134106D419555BFB2C41C2EEA9F0186513412BB0F599F8FA2C41265B0C0C7B6113418B0FB92FE7F92C419C9A3FFA752B1341E264EB2E98E92C41DE50EE23CC2A13417194F74253E92C41E75DBC27272A13411661F98D12E92C4125B025F52C251341380147CBE3E62C41AF94063D7B1F1341D22AA0F05AE42C41
64	29040000	1	US   41	41	2	29	Columbia	2	0	11.48	18469.7725	18469.7725388855	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
65	35010000	2	US  221	221	2	35	Madison	2	6.108	6.419	500.632	500.632032467413	0105000020E610000001000000010200000005000000F9C5265AA6E854C03B1760A27E783E406E252D09A6E854C02955DF4F7E783E400BF0F887A1E854C081F33F477A783E403C49515962E854C0B4F4343038783E40DEDE4BB554E854C0D3249B2E28783E40	0105000020BC08000001000000010200000005000000E62AE71BB94105C1798FD9AA8C184141675D0AC3884105C16577A0B38B184141E2C2BDA6D73E05C1AC09FD7D7F18414107401A0F201905C1CD6165D7B91741410D14E63DFD1005C1AA371B598A174141
66	72050000	2	US   17	17	2	72	Duval	2	8.845	10.452	2591.6856	2591.6856479933	0105000020E6100000010000000102000000150000002EBF8EAFFB6954C0A1E90F363F553E407606BDCAFB6954C02D41BD4E3F553E40E6794BBBF76954C07FB2E2DD77553E408A6981CCEC6954C05A17B268FC553E4025BD3638EB6954C052E5FDA417563E405C3399CEEA6954C0476E2B2426563E40F40F1FA9EA6954C04D3F4F9F2B563E40B428AC8BE96954C0223C474B2E563E40F352E785E26954C06C853A4336573E400B87B8A2D96954C0E893AFD482583E40AA067B5ED56954C08377E4FA22593E4043542ABFD46954C0BA6CFC8A3D593E4035C3D6A2D46954C064AD3F9548593E40DD3AD0B8D46954C06C95DA7B55593E4008A52C91D56954C03BFD0303C1593E40EED7B5AED66954C0FBA374BEC8593E40A2D3AA05D76954C03366D696065A3E405F11001FD76954C0727F85D51E5A3E404379EDCBD96954C0286C8046165B3E40E8C8D1C7D96954C0E951057F295B3E40F47EF4C5D96954C0DB6685662D5B3E40	0105000020BC08000001000000010200000015000000585ADA10056B1B41DAFDC8F3FEA440412C0F7CE6FC6A1B41B5AAC539FFA4404108870FE53C6C1B4136AC80F09BA54041F868E5F2976F1B41B44FB41B0BA74041F603451315701B416C12E49756A7404167976FB536701B414423C3CB7EA74041C6E6C1AF42701B41794E19FF8DA7404187A9A2E898701B41D33D1A5995A74041A3D88A97D7721B41A427656A71AA404171274FA3AE751B417FDAEABA0BAE40415D148BB50B771B417559EADFC7AF40419BDB9D083F771B4184C6F18B11B04041BF7EACF748771B410D90AC2C30B040410F40FE0144771B4156A2F2F953B0404156A194AE10771B4120E436647EB14041FC651EC7BB761B410A949AE893B140411B460F89A9761B41173212893FB24041A294A204A5761B4120DFC3D082B24041F36F39AAF6751B410BA94D9031B5404197569A5CFA751B41AE8F86E566B540411C26266CFB751B41569DD5BA71B54041
67	10250000	1	USB  41	41B	7	10	Hillsborough	7	6.623	6.698	120.5358	120.535772507688	0105000020E610000001000000010200000008000000997A301FD39B54C0C2BE4566D2F33B40A55C4010D39B54C0CD5BA326D5F33B4009C48342D39B54C063C34E2CEFF33B404280383FD39B54C0D661B6F8F7F33B4055E86D3BD39B54C07CAC5B2402F43B4046CAED38D39B54C091939CC708F43B40C040A936D39B54C0042024D20EF43B4090050148D39B54C0D54A3AAC19F43B40	0105000020BC0800000100000001020000000800000044DCC388CA8D074113C3B92EF01C34415EF3F22AD58D0741160E616FFF1C34411689FEC5C38D0741DF6EAFDC8F1D34410A202063CA8D0741F68730ADC01D3441F186B805D28D07414968681AF91D344116BF7B05D78D07414964FCED1D1E34411F0DF790DB8D074149023E723F1E34419F337B8AD68D0741819B38AC7B1E3441
68	10030102	1	US   92	92	7	10	Hillsborough	7	0	1.755	2825.6667	2825.66666769818	0105000020E610000001000000010200000035000000C584E665E09754C0C725A2BF02FF3B40C447A2A7DD9754C0FC1852DE02FF3B40DA6F28F5A49754C0FBB1ACC302FF3B40E515A8D79F9754C047898D3701FF3B40AA4747D19B9754C00ECF2D06FFFE3B404DFCBA3F979754C0C1BB263CFBFE3B40D2433E98919754C087C7E3B1F4FE3B40613753D98C9754C01122693CEDFE3B400710A9F57C9754C024987FE6CFFE3B40326AA0D7799754C0E0271A4ACAFE3B4051D4EFF6759754C06FA3A476C4FE3B400682443C729754C041C5AF86BFFE3B40DA9136146E9754C0AC3EC186BBFE3B4088C2DD83699754C0F54A76AAB8FE3B405107006A649754C0447D5EBCB6FE3B4007C57F43619754C0D239670DB6FE3B4096D84F015C9754C07E78BEB3B6FE3B40D87CC8EA569754C0BDF386F6B8FE3B400473DFC2509754C0EE1B9B0FBEFE3B40CB289B90469754C095EE082FC9FE3B406EA45E353A9754C0668DC548D7FE3B40366E2CA9329754C00165E224E0FE3B40F3F78BE92C9754C0803BE339E6FE3B40D16D0675269754C0A3FBFCE0EBFE3B40488F01B21F9754C0274F7058EFFE3B40251330B5199754C0F7975402F2FE3B403403EED4149754C026A29088F2FE3B406B00B5050E9754C078890CB5F0FE3B40D31E12B3F29654C0B7C17F6EE0FE3B4082098AE8E39654C0C4C756C1D7FE3B404790C7A4E19654C081904D75D6FE3B403B8637C5D59654C0276B7491D0FE3B40608E5BA1D19654C0BC777183CEFE3B4052174217C99654C055EA9D47CBFE3B40FAF74C86BD9654C0D3534E35C8FE3B4059792143AE9654C0D0C74BB4C5FE3B403B566476A29654C0689C76FCC4FE3B40787EC3099E9654C0F10F32E2C4FE3B40B5109BD98F9654C03A2FB279C6FE3B408712A94B839654C030BD7751C9FE3B4028929379749654C03EC6CEEDCEFE3B40CE416FBB669654C087CB1E54D5FE3B40A0FA3E505A9654C0098F15D2D9FE3B40F74BBACE559654C0B266E2FED8FE3B400A407A314E9654C095E90109DAFE3B4068A5E1E2469654C05D33D935D9FE3B408648FEA6409654C051B2F9BCD6FE3B404FF377963A9654C0C907C8C6D2FE3B4061EA99E4339654C0797D647BCDFE3B4011E8C3E62D9654C0E295876AC8FE3B40EF288213219654C087753988BEFE3B403089DFAD169654C098B26A65B8FE3B4026132D50129654C0C2294CDBBBFE3B40	0105000020BC08000001000000010200000035000000275C1F03D6010A4122C118C11F5A344199C3D26386030A411540B7CF1F5A3441E73ABD7F6D260A4180303FAF125A3441334A91DC92290A41A932FAF7085A3441CA68EB120C2C0A41FA8A92E9FB593441161F592ADA2E0A41164C1BE1E5593441FA4A35FD51320A41A431F757C0593441BB1EC42F3A350A41731331E9955934414696B6ACF33E0A41AD62A5A3EF5834417C7C2229DC400A41774FEED1CF583441BB7A545F3C430A419F04CBA3AE58344162D3F39E85450A418AFD576C925834416EAAB2AC12480A41EF048D507B5834412B56917FE04A0A41F093EC6F6A58344178EF5971034E0A41E585A79A5E58344130FDC297F34F0A41A1C6201E5A58344166A600A430530A4181F965905C58344163F3819C53560A412EC3BAFC6758344195FC0C49205A0A416EFFA8EA8258344113953DB46C600A41EE2E7962BE5834411FA056010F680A4112846EE609593441DC8DFEDDB86C0A411409B065395934410D5045D245700A4135F9DDE059593441D4FDC0EB41740A41A05496D277593441EC6674426D780A41159A079289593441463EC72F1E7C0A41DFED9D089759344103E6C4E01E7F0A416CAA33DF9859344150ACAC1B4F830A41257E713E8D593441F1E0A6FC18940A414AB220F22C593441D5BC5DB52F9D0A4150314490F9583441E28B9BF8939E0A411ACEF7DEF1583441EC90363CE0A50A41D8DE0797CE583441001C43AD6BA80A41A6607048C25834414DFD83DBABAD0A41C570C678AE583441A8AC6920C9B40A41F3C01BE69A583441ACD0C52B2DBE0A413B0914AB8958344114CF336770C50A41E3C6E21A83583441AC4C0D9B29C80A413976AE9181583441E842175EE6D00A413C6A644D87583441DEA3F849A2D80A4156F1D45594583441D4706AB4C4E10A414A12883BB05834419F24F0A13DEA0A41CB4D86BED0583441C10D85F5E4F10A41EAE14AF6E65834410CAB1EAAAAF40A41F97E4767E1583441202AE8235BF90A41A9DA6F83E558344145E81A48DAFD0A41B200BD58DF583441DA462681AF010B417D6D2046D058344122ECA54D69050B41C2EE59F9B8583441D01CFFC585090B414DC887249A583441DFB15E87330D0B41BFF1ACBB7C583441C11E40E113150B415491491B4358344188D94A65771B0B41D2D4E2CD1E583441AFE14426291E0B417C55610E31583441
81	10250001	1	USB  41	41B	7	10	Hillsborough	7	0	1.315	2115.0604	2115.06042156361	0105000020E610000001000000010200000026000000133F2FE9B39B54C0EC3D183359EF3B400D5E2FCCC19B54C004F52BA986EF3B409B03A710CB9B54C09162D7FFA4EF3B404B009798DA9B54C07C465422D8EF3B4048F38BAEDB9B54C02EC7E4D8DBEF3B4065FFC5D8DF9B54C00BF0D517EAEF3B40350552A5E39B54C098F38D57F7EF3B405C28332AE69B54C0D5D3BFBD02F03B4053D18A9BE89B54C057299D8810F03B40F9853F5EEB9B54C0AB82B85525F03B4025FC3452ED9B54C05D596BA137F03B40B59A3E9AEE9B54C05C6C98404AF03B403F89D88CEF9B54C02C16D3C85DF03B40E963A5FBEF9B54C031437D336EF03B40F7B73DF8EF9B54C0DA08E9BB97F13B40640EEAF3EF9B54C0CF1C009767F23B40542165E0EF9B54C004D5276D7BF23B40E7810592EF9B54C0244051258AF23B4042436D00EF9B54C06711533498F23B407972471FEE9B54C05B435144A5F23B40C7D9EFE9EC9B54C0F86F1A04B3F23B405EAA8570EB9B54C08F286F18BFF23B40950B51DDE99B54C01C086F54C9F23B402F723586E69B54C0A49C8E78DDF23B40281D6009E19B54C09C9631AB01F33B40E1BD44DFDD9B54C0FCE65BE918F33B402FF5A71ADC9B54C0D20A7B3429F33B40CD60B9CBDA9B54C0AFF66C5C35F33B4040870367D99B54C0B9AF6A7644F33B4002271E04D89B54C0186714AA55F33B4089651DCBD69B54C006B95B6368F33B40BEAA5306D69B54C014C0B84978F33B4053792642D59B54C0E06119FA8AF33B408F895C03D59B54C039E1B6C78EF33B40F73445D0D49B54C0BA5CD37A97F33B403E8C6761D49B54C00498D709A4F33B40A144FD7ED39B54C044945AC0C0F33B40A55C4010D39B54C0CD5BA326D5F33B40	0105000020BC0800000100000001020000002600000025022072AF9E0741A61508F0160434415131E15D399607413793076216053441514580D393900741868301DBC005344178CA47791D870741DB36CF29E0063441835F79337486074164FE3A04F50634410C9E30E2EA8307414DAFA30545073441019F34C09A81074197FC54698F0734413821447B1380074179ABE93DCF073441743AB47E997E0741DB6153551C083441470C8D0CF17C0741C118C562900834418DB5ADA4C67B07414B929259F60834412DEE694D067B0741FCF1BDF75D09344165B8970F7B7A07419C5A348FCA093441996769603F7A0741C679F0BE250A3441B0108AA8DC7A07414CC65893981034417730A2BF4B7B07416A5924D71915344181584D1E627B07416DDC4CE28715344110B105119A7B074183D8727BD9153441C7890F12FB7B074165047D5A27163441F491E58C8C7C0741AC3F2EA06F163441D9E0FD3D527D074182F8BEA1BB163441B794BBFC407E07413AF0DA4FFE1634417BDF44A73E7F074155214FBB36173441CE03E2CD57810741692695B5A5173441A8339CE3CB840741A3B36D476D183441AE3718EFCA860741BB73DB81ED18344198D55A2EEA870741EEC22F804719344132BA3ECBBE880741056603A58A19344161E6A65AA2890741E56C8F1CDE193441567802E4858A07415953C13B3D1A34417BB5316B508B0741EC5565D6A41A344176E6A7E6D18B07410CE8E6E0FC1A3441355FB275548C074106A03165641B34418A3F811C7D8C0741AD6EAE70791B3441F40A461CA18C07416002C9A9A91B3441C9C309EFEB8C074109985C3EEF1B3441A10D7E56868D07415939A0598E1C34415EF3F22AD58D0741160E616FFF1C3441
70	92030000	2	US  441	441	5	92	Osceola	5	0	13.243	21322.2505	21322.2505121384	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
78	92030001	1	US  192	192	5	92	Osceola	5	0	2.336	3756.6784	3756.67841053686	0105000020E610000001000000010200000031000000B783A6578E4D54C0DD32D423FE3D3C4087697C4F834D54C0E301B58DFA3D3C407A7CC2BC804D54C02A7448D6F93D3C40562615F66A4D54C0C49219C6F33D3C40599D03454F4D54C00B80CF56EC3D3C40AEA57FEB2C4D54C0E126431DE33D3C40228023A7234D54C01C0371FEDF3D3C4059EBEBBF1C4D54C0DC709CF4DC3D3C40D0934C29144D54C0520BC77BD83D3C4048BF99D90C4D54C085897BCFD33D3C40C2FF9BAC054D54C0B87ED4A7CE3D3C4090446C3FFD4C54C0B4CEADC6C73D3C4010A7AE1AF74C54C089D94C1DC23D3C4047B4A550F24C54C0413ACD48BD3D3C409629544EEB4C54C03A969CC4B53D3C404622895FE44C54C0459F646FAD3D3C40C618B514DC4C54C083DC33B4A23D3C4016C9EF09D54C54C0651ADED4983D3C4065D1508ACE4C54C05AB45D0D8F3D3C40D6EA1C46C64C54C04814BFB8813D3C40730D59BFBF4C54C0CAAC5E4E763D3C40C0C19D6EB84C54C09BBACE95683D3C40E23C437FB14C54C0BED6A7DC5A3D3C40650889FDA94C54C0F54532BC4A3D3C40FAF56950A14C54C073A94804383D3C40453377DA3D4C54C0EEAF2514613C3C40D31D5BA5364C54C0BA656390503C3C40F9146AFB2F4C54C0832AC855403C3C4076827F72284C54C0EC2E7FD62C3C3C40116CAD45224C54C0325667BD1B3C3C40D75BB9261C4C54C04FC1E3720A3C3C402B48C6E4154C54C01C498D0AF73B3C407E4066170F4C54C0527054D8E03B3C406EA629DC084C54C031CAC407CB3B3C40B621F5DD034C54C096EFAD03B93B3C4098CAD758FD4B54C06CB5D1AB9F3B3C40A620CFD0F64B54C0BEB1C462843B3C407501A96AF04B54C078DAF1D6673B3C40D9F43770EB4B54C0F0C37DFD4F3B3C4016C42AE6E64B54C007177306393B3C406FA23755E24B54C040ED1A94203B3C4051513F13DF4B54C0B866A20C0E3B3C40D1C5FBDDDA4B54C0CCAE2979F43A3C400E8A662BD74B54C06BB43FE0DC3A3C40F41A0B92D34B54C01B062F8EC43A3C40DCCAD1DFC94B54C08CB2582D803A3C40A908681DC54B54C0B84E34755E3A3C405130A0AEB54B54C0AE28C369F2393C401D4C5E9FA44B54C0E03457FF7A393C40	0105000020BC080000010000000102000000310000000A40573584F121413A842F4104AE35418B7093B835F321411BF7CDFAEFAD3541CE30B2D69AF321416258A9EAEBAD354139694A94F2F6214141A95A89C9AD354163B835CB32FB21418532445A9FAD354101B77AA778002241637ED8056BAD35417ED3B2D0E4012241C31B166759AD354192C29912F4022241D6BB1B5148AD3541A3351F8945042241B22FEC382FAD35413855C2CD6405224124FE3F0E15AD3541456418BC7E06224197C68238F8AC3541A5C0EBCAC90722411D660FC7D1AC35419EDF4425BB082241FED09C2AB2AC35416B771A4977092241FEF9A13697AC35410B7E849F8A0A224191A1FE486DAC35415F77D0F29A0B2241C7FB7ED43EAC3541739CD3A9E00C22416201A60603AC3541D89CDC41F50D22414FA51307CCAB35412B04807DF40E224101D15E9095AB3541C64BA1243910224139769C574BAB354118C0D47139112241826722CD0BAB354192E577B6581222416E0A1772BFAA354137B7150869132241D9AC0B1773AA35418B33D4C78F1422414366E56119AA35416CD53473E4152241EED5AC42B1A93541E08C3CDB252522413425AEB705A53541AEAE22DB4026224190DD3EE0A9A435410B37A37E46272241052412A34FA435410EC1F14F6E28224158E2833DE3A3354156CC57BA602922417E0A263284A3354134E72003512A224177A5221524A33541531B62A2462B2241FEFF4839B8A2354145E4DD9D512C2241886CE0E03CA23541C908642B462D2241915BD6AAC3A135418172D61C0A2E2241535B82915FA135411FC667F3092F224102D932C6D2A035411E0CAD340A3022410B13A9343BA03541C7430D3D0531224112599FA59C9F3541530D6E82C83122417E920830189F3541AB62578A7A3222418D6AF5A5989E3541A2E33E9B2D332241DD067CE3109E354168373A57AD33224157B829FFA99D354180D1E44F5234224137AF8EFB1B9D3541EBBCC540E3342241C5A522F6989C354164B4364F70352241C46359EE119C3541DC0A1849EC3622412752064D969A3541D40589CCA6372241FAC46318DB993541162F509D033A2241EB15763D83973541D437A635A03C2241D827C041EC943541
86	06010000	1	US   17	17	1	06	Hardee	1	11.165	11.753	946.8043	946.804277239026	0105000020E610000001000000010200000003000000BBCB5D95117354C0D0883CD427803B4016CB55AE3A7354C0F615A3383A813B40307A0A4C5B7354C0C485E46D16823B40	0105000020BC08000001000000010200000003000000163E73D8DA421841960BDFE4EF933141DB7F84684D361841A99B2F4AE7993141003736AC572C1841361A9D09B19E3141
71	05010000	1	US   27	27	1	05	Glades	1	0	28.938	46592.5261	46592.5260571748	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	0105000020BC080000010000000102000000C500000074D776972233234117E7D743D4012B4180361985553423419E0467C0D77D2B41D622A9FAB53423418D82391583A62B414AEF48C1B8342341D3924C75CFA72B419E0F7B12A8342341BFA6E8DBDBA82B41E1EDE9088F3423418C4765D6CDA92B415E88407D69342341900CC659ACAA2B41EC13A27830342341B0885ECBB1AB2B417D8DC032E13323417033D03EB7AC2B4143C6988277332341AC3BEB3DE2AD2B41D4DF9100F2322341DF033C8303AF2B41AF8499FA5F32234110075F210DB02B4164A30E29EB312341E5BAA763D5B02B41DF4EE83A4B3123412CE132DABAB12B418D1702A6B3302341BAAE628D7DB22B4103D71EF92930234155D8760A23B32B4151D981B6BA2F2341A8A4E1FBA2B32B41C8292EED052F2341AF5880A54CB42B41D701F13E232E23412429FE2012B52B41933FDE83472D23413FD54E02B9B52B41609EDD39662C2341978FEAC354B62B415043F571912B23419E6B3F0EDDB62B41BCA842F0B22A23414513988E62B72B410301782DBE292341005B14E4E3B72B41246F20CA91282341BF1DD08574B82B415057369B82272341FF0E6DC8E3B82B412D2E85DB6D2623412DDE7BE947B92B41646C7ABF702523418EB687229EB92B41F6FADE655D242341996C053AE9B92B414D49EC8A7623234103F503781FBA2B419D0B441CAA2223416ADA623049BA2B412BC9784CBC21234168C50FB175BA2B4159327DB9AB202341C5126B7498BA2B41C1C00CC7791F2341E5F99B44B4BA2B418AB3274F3B1E23414E8AED01BEBA2B4148F5F037061A234174440691C3BA2B410C7F327DD1182341D4C9DE85CABA2B414A39447A5D172341F71C3761DFBA2B4187D3AA56EE1523414B1C4FA2F5BA2B41E1F78D8C0E14234151F15F921CBB2B417BB3B6D298122341815FE87A30BB2B41902F45D3DC102341A85569573FBB2B41FD6C3BFF150F23413952CCA344BB2B41C171FA52900B2341BCD8B5244FBB2B41C8D719341F08234138DA84CE52BB2B41BC1942E1F9052341463C76525FBB2B41757577B3810423419AB42E6771BB2B414F763B22F8022341BAB246A887BB2B418C01B006A20123410C0DED4B9FBB2B41C1A01B2F80FF2241D17724F9CFBB2B4147F586F377FE224131D9F59CE7BB2B41E938F8878BFD224118CE464DF8BB2B41532E2E7D7FFD224156DADE10F9BB2B415FF370409AFC2241BD44B19907BC2B41E5922C3140F92241BD16E26923BC2B41A6583D719AF6224127FCE16923BC2B41FA9CF3F1F1EF224138BBE16923BC2B417A88D04E70D32241E61259252DBC2B414BC4033D0ACE22411E5CDFAF26BC2B41E3BC15E3D3B322415C7F2D3226BC2B41FF6A6C99D8772241675C284A18BC2B411FD3E34E7F6122417592274A18BC2B415031E23B234B224101B39540FFBB2B41ED298A14F12922411BC66B82D8BB2B410402F4F36028224169CC0C4BD7BB2B415E8F427936272241911E58DAE6BB2B41CE2DAB365B262241BCD844F905BC2B412D275F838F252241D715D5C02ABC2B41168A7EE2902422415F0C27A76EBC2B414AE404F24C232241288554C0D8BC2B41801FA5391E222241FBC28A6163BD2B41F93709D1FA202241AB37B47807BE2B41A81FCEE5DF1F224180EF6D57D0BE2B41C8A99951F91E224145CA63E68DBF2B414EAB96140D1E2241C37AFF4E77C02B4113F9430A0D1D2241A97BC6DBA8C12B415E3302C8BD1B22412AD7B44E92C32B41564681BA2D192241006CE6136AC72B41E9C44E2D8115224100AAAA15B8CC2B41577085866D1122417E145D4B7CD22B41B3C9B714810B2241C176D60BEFDA2B41BD159EEFC80422416903000283E42B41AE1221FB8702224181753BC094E72B411762A7E8A3012241856D0340ECE82B413AD4E6EB50FD214141A6BA560EEF2B41E060767997F221416848529565FE2B41ADDFF105A7EE214135A9AA02FA032C41D09085C53DE02141E9BEACF277182C419940038E84D22141FCB5056EFF2B2C41CA3D7921F6C92141F254AEC223382C4159F29DC614C62141D7868817A93D2C412E9E894CDAB621410428A30E55532C416B218D0A84AA2141BE2B6F20CC642C4138713941CFA921419144A717DE652C411208A0F366A921417BD8DDE8AB662C41CAAD1EE714A921413023D1376D672C41C330E451D6A82141113FC01D4D682C41DE3A09E99BA821419B62797C40692C419CC4147D81A8214131F6A2F75E6A2C41213E17C01EA8214160D1702953702C41B7BFA98B01A82141B91A0E1133712C41F962A42FC0A72141FBB7B05454722C418B5EB1856FA72141CA4094A64E732C419286F02C0EA7214141671F1D34742C4163A5E9AA88A62141728A542C38752C4142ED98C9E1A52141ABC770AC36762C41D8B3BAD328A521415B6BEABE1A772C4184FD20E14FA4214128F74E78F6772C413D2D47956EA3214168C65043AB782C41F58151D279A221418F88B67D5A792C41B0817CFC72A1214160C835BBE9792C41344F2FAC58A021412A9FEB8C5E7A2C41454FDE25419F21411E74CCC5B47A2C413D342A7E1E9E2141A3DEE392F07A2C41F11EC49EFE9C21419ABF174B1A7B2C41F4EC61D8988B21410EBA10452A7D2C41E1D101B7C3892141934ACCF27B7D2C411AAFE94727882141964319F0CE7D2C4179B354DA8A862141AA3DF587337E2C4167803972F3842141ED3DCC36A77E2C413E8D3B8154832141533B07802C7F2C4100689477A68121412428CE6AC87F2C41F858F992667F2141D916A1D6B9802C414F1A6154B06D2141742CA4EC65882C4121E12A572A5821418C277DECAB912C418D2DFE77C03E2141ED3328F69F9C2C41496AD0CDDE2C214139E974A94EA42C41B9909B572D2321413133E7E782A82C4143407D8DAF1D2141582A78FAE0AA2C41718652DAAAF320413CEDA0A7EEBC2C41A84313BCA2F120414F1BA2FEC8BD2C41B398D41175EF20411EA0A530B8BE2C41F67D9C1A63EE2041607F257B40BF2C4142C1895F87ED204144CAA1D0C1BF2C41BBE85D55D8EC2041F21111E638C02C41807B8BB3D2EB2041A7D002F910C12C41D7527CEDFDEA20414D7AFD72D6C12C412A764F2249EA20416A2D697DA1C22C419D3FEDDCA0E920414D6CB89C7EC32C41CDEDC6EE00E92041EB7C261B7DC42C41840EC06C7BE820417819A3156FC52C41F53BD12B0CE820415CC098D863C62C4194BF1AE6BCE720415B73AE7B4DC72C417E544EF975E72041F81E765634C82C41962933FA4AE62041D3143D06A3CD2C418574459A6AE520412B4FEAC77ED12C419D3FAD8FBAE42041BE66A17699D42C41585FE55CC0E12041F75070E68BE12C41CBE1002F63E12041573741B72BE32C414E8129BB2FE1204184C2E9CA68E42C41FD7D7F2211E12041A8F01BF25EE52C41301A245FEEE020413A43657E08E72C41F775D2A1E4E020417D52CE4536E82C417DED6A12E9E02041C676539923EA2C41D272E7FAECE02041279877DDD5EB2C41C382D68BEEE020419B72FF4D3BED2C41C467745BF2E02041C436F2268AF12C41DD71627AF6E02041A03DB28575F52C41090915E3FAE02041AD97D3C6A7F92C41E0FA11F6FAE0204133B7C4D9B4F92C412E4C3FD601E12041F56586F970FE2C4133B4C90206E1204193AEFCC738032D4123245147FCE020417AAF263538082D413E9002F603E120416D3A6F652D0F2D41C4462AFD08E12041A4D822C9B6172D41917D084F15E12041FBB38758BE1B2D41C434363723E1204172E62870E8242D419CC896291FE12041DC3023E8B6262D414E5FEF4136E120416E17EAD733392D41427CD54033E12041B5D1F9C67C3A2D4184BABABA2EE12041800B6AF78F3B2D41D51EC29B1CE12041A5693B16AB3C2D4114EFD05DF8E020415F6FCDA5E33D2D416CACF5BAD0E02041BF0DF8A3EC3E2D415ADE206FA3E02041C629A10CE83F2D41C37B31F16BE02041FB4D27D8F7402D41F544D30017E0204155A63B3337422D415B13C223BADF20413F0AEAB466432D41F7CFC6E159DF2041C83F5AE579442D412F7B9D0385DD2041A9B0EF5D3D492D415B0EE5E24AC22041069DD985F98F2D41E0B3F818C8A920415200DD57ABCF2D412C5EAF2EB4A82041146B10CB9ED22D4166510F62A1A72041F655AE7EA6D52D41F3F344441DA72041CE39590617D72D417D1CBBB9FAA420412DA87743ABDC2D41356706A19EA32041A44C9AE22CE02D4121EE84BBA4A2204101DDB2A9BCE22D41AC15D1B8F2A12041D6A833E396E42D415EEEE62687A120418E205344D4E52D410F94543117A12041D012B9D14AE72D41CB826964C0A02041FF43575F99E82D41C5B14EBD4EA02041B656686C93EA2D41FE38B857F49F204186B8B9FB95EC2D411A6F79D3B99F2041DF490D8A64EE2D41EFC26CD28E9F20415C56BB6E4AF02D412CBC17AB8A9F2041BF973FA1C5F02D41
94	01010101	1	US   41	41	1	01	Charlotte	1	0	2.042	3212.2856	3212.28564816015	0105000020E6100000010000000102000000200000008A921C9D058454C0ADD78FA311F43A40745188C9028454C0EBA4B45503F43A400AFBA223FC8354C0B7F7CEBCDEF33A4087ABAE8AF98354C07269F69CCEF33A4041A127C0F68354C0BABCB720BDF33A40BEC3186EF38354C0B3EC587CA6F33A401BBA468CF08354C0CFA2640091F33A401884943EEE8354C056C2896D7EF33A40FBD4870FEB8354C02C78299E66F33A40DB62D788DB8354C08E02BE42D8F23A402B0EB169BF8354C09FFFCB93D5F13A40F392996EAD8354C04DE7D23A30F13A40534D311D968354C0DF677C4256F03A40E019E466938354C0FD52171040F03A40E71AA758908354C09476224D29F03A4041685184898354C04642410F01F03A4096280B3C838354C0D3B99540E1EF3A40804B93027D8354C01BB04071C5EF3A406CBF8DB0588354C0C369148931EF3A40953A6472488354C0AFF29AEBEFEE3A4091641C151F8354C0A97ECC0249EE3A40F7AE1287128354C0E475934814EE3A4065FBE7A2108354C09081A6E80BEE3A409A259A010F8354C0E3AD59C902EE3A40695B7C430D8354C07BD8C6BEF7ED3A40A492C4BD0B8354C01558011BECED3A4031D9FB990A8354C0A437DCE5E0ED3A4056697DCD098354C0D2A7F5F9D5ED3A40D75B5227098354C033F1C40CCBED3A400E17DAC4088354C05DE3F0DAC0ED3A40192302A4088354C0F782E821B8ED3A40234D849E088354C0EED89C60AAED3A40	0105000020BC080000010000000102000000200000000E4D0DBDA7EA124164593164AB1A2D416352D3E185EB124110A525C00B1A2D410E770DD48FED12414562F48073182D4194A0CA6B5BEE124175B3C5BEBF172D41D85FCD2936EF1241B30FCAD2FC162D41AC0BFE0D3AF012416250958300162D41F23A8D4A1BF11241138D7B3211152D4199DB900CCFF11241A051515D42142D41FE789ED9C7F2124130B5AC2439132D41AC5A5F4C80F7124198FFCB98080D2D4186124A110D00134117F4EF4AC9012D41C515C9A584051341FF2C9AE198FA2C414125CC199B0C1341EF261FE41EF12C41D1404EBB6E0D1341D687FDBA27F02C41C0C89A955D0E13413A7FE2302AEF2C41B20671677510134147F4BF7769ED2C414131C044631213413703618006EC2C412321AE464D1413413B8367E7CFEA2C41AF94063D7B1F1341D22AA0F05AE42C412A3B1E457B241341713C3D9C7DE12C41954B502B373113410E62C13334DA2C415E4CC44114351341AA516616E7D72C4133961C2DA9351341F0876E8D89D72C4111FB272E293613410F5757CF23D72C41891A25C9B13613413E6C6CBDA8D62C41DC5F57C128371341422B791A27D62C410608E15E81371341F80B1F63AAD52C416C249AE9BE3713413F2E20F530D52C410FAB248BF037134142247385B7D42C41789868450D381341017EBA4A46D42C416C6506E015381341FF9AEA79E5D32C4109D8FA0D15381341C26BB4DD4CD32C41
72	12010000	1	US   41	41	1	12	Lee	1	0	33.409	53781.4904	53781.4904274368	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
95	26040000	1	US   27	27	2	26	Alachua	2	0	1.707	2748.2927	2748.29266292054	0105000020E610000001000000010200000009000000508314AF60A854C0183122D6CAD73D40A9D04EF02BA854C0625A809E40D73D409BF22D5921A854C0C284455A25D73D404E00D17219A854C0A146148B12D73D403186FFA70FA854C0728C7A8DFDD63D4060E2C17F07A854C091BA93C6ECD63D40B56B5737FDA754C0E8757FAAD9D63D407EF18B0687A754C04085917209D63D40A90E5270C9A654C051EF19D7BCD43D40	0105000020BC0800000100000001020000000900000091F1CFE33FFA0041E541A273CA9D3E41EAADABD7CF190141435F05E1BC9A3E41DD5790812620014151CC18A6229A3E41F1C21FE6E12401417BE60C18B8993E416B4979F2C02A014172BA80EA40993E419E398479A52F0141940D8392E1983E4134C882AFD1350141F861A2B374983E41CD8DFE4BCC7C014145C705DAD0933E41B9DB7998AAEE01418FABB17A678C3E41
96	90060002	1	US    1	1	6	90	Monroe	6	0	0.772	1241.1597	1241.15974757834	0105000020E61000000100000001020000001200000091BB2AFEA42054C0BC12B24927063940AAC1AB30A62054C0F5D07A102006394077FDAD41A92054C0ED52B15A0A0639404EE6BEC8AB2054C0DA4D5E86F50539407C31A6C5AD2054C03D11CE76E205394064761587AF2054C0E8377637CE053940DC02CEE8B02054C0C3214630B8053940F65D2D0EB32054C01E3BEDCA8A053940994B82F2BC2054C0BF6BBEE4B604394045E03692C12054C012F48869540439401A252A6DC52054C0B9841C870304394081284138C72054C06B27F6BBE70339406C3C61BDC92054C0E09036B2CD033940B5871D9CCC2054C0DAF42C4DB5033940FED5FBB2D12054C05D39AE1B930339404F040FF0D42054C050584CDC800339406548D2F2D72054C035C3C19C7103394096011E94D92054C02605441B6A033940	0105000020BC080000010000000102000000120000007F165071AFF928413D843EC5C3AC0E41F59574567FF9284141D9959E82AB0E41C479DB4204F9284176D195B7BDA70E41740BCAED9EF82841947C6B3320A40E41AE4415574FF82841129B9875D1A00E41502B3B3009F8284145BD3B364E9D0E4170916338D2F72841E26787307C990E418CC88C4B7DF72841BF648C129D910E41B9A2E6ECF5F52841DC41B0FADE6C0E41E3B959F43EF528412283586FCB5B0E41E99B2358A6F42841216D84F9C44D0E41AA3C63F65EF42841422E65F2F2480E41020B5F22FAF32841E0BA865F6E440E4179BE071787F328411456548032400E41E93B83B9BAF22841C4863FA6423A0E41EE7A698938F228417A8B844317370E41963AC56FBFF128413039FD1171340E4174B697D77DF12841285F052623330E41
97	86010000	1	US    1	1	4	86	Broward	4	2.465	2.713	398.387	398.386996714721	0105000020E61000000100000001020000001C000000E71A6A1B260954C004E31889A1023A40CC61CC8A240954C0CF895032A6023A4076F458AE220954C089A511C9AA023A405A58263D200954C0CEE41C6FAE023A40D1B3E19E1D0954C0A72D23D6B2023A406A7FF9261B0954C0E044D815B8023A40EAFF7F91190954C0F953BD7FBC023A408FC21F3C170954C095CF10EFC5023A401E120FF4150954C091809038CC023A40F33877E4140954C004FEABE4D2023A4036AD6F07140954C0750B83D2D9023A403DCFDB74130954C013C93423E1023A40EE591206130954C05AE9C374E8023A406A4BD3C0120954C075DA4228F0023A40B88B3EBF120954C07FE96B03FA023A4086AE30F4120954C002BF80FA01033A4095D9BE73130954C019BF33FE09033A40AB3AC749140954C0E637F80312033A40AAAAE072150954C0B7994E191B033A40DF840C7F160954C00A31512822033A40035ED1DB170954C00236643929033A402A22723F190954C00715D6442E033A40EF53B9EC1A0954C0A6B80E0A33033A4066CE977E1D0954C0F4E2A76F38033A40FC1524751F0954C03DB212E53B033A40C56005FE210954C0159189073F033A40CCD4B8CE240954C0EBC5E7BF41033A40A091F9DC260954C015ADD00F47033A40	0105000020BC0800000100000001020000001C0000001486A7495D9D2C4194955B525AA022413643D7B09B9D2C418655946F8EA02241A0D7D0F9E59D2C418522F6D3C1A02241929D08A0479E2C416D3967F1EAA02241F4323247B09E2C4143FD62771CA12241577B87DC129F2C41BE22E05657A12241F4A6010B529F2C41CF020DB788A122413FFAC0E9AE9F2C418DDF80FCF1A12241BA61A7D5E19F2C411D115E1038A2224175EC35E20BA02C417FDF305B82A222412425B5FE2DA02C41DC10D971CFA22241919BFC6A44A02C4131A872BD20A3224125F43C3C55A02C41C643370972A32241D2D1DB845FA02C4108206A88C7A322413C6F600C5FA02C4178812BDD34A42241878D082D56A02C41A0EAE1298DA42241CEE8789D41A02C4129A9E8EEE5A42241C8CFA7821FA02C411A6A1AB43EA52241B941B451F09F2C4179C0D527A3A52241567C58CEC59F2C41996E9B2DF1A52241236C7CAB8E9F2C4153480F353FA62241E90B5C9B569F2C41414CDFCC76A622411E798B07139F2C41B2765846ABA62241A724489BAB9E2C41F1D5A876E6A622417EEE64A65C9E2C413C26F44F0CA7224177E2BECCF69D2C41222D9A6A2EA72241BA6E5CBB859D2C414F9D81D94BA72241CC3F9DED329D2C411CE2F93B86A72241
83	16020000	1	US   17	17	1	16	Polk	1	15.852	22.811	11204.8993	11204.8992663605	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	0105000020BC08000001000000010200000075000000E2B20F32F6B7194123137C2E40DF344172A128912CB81941A27054FA46DF3441AA47D68216BD1941154DFDDBD3DF3441C5A12E4E96BE19411B543700F6DF34416FE7648CFEBF1941CE108D030AE034414D05927643C11941295D712418E03441C634D258F2C219410DD0C45223E034417E779A3BF6DE1941C1997BF616E034415629CA6A14E21941A7BF5CC915E034419CDDDB01C8E319416FE41FE819E03441DF855CD26FE51941809935BC22E034410C5EB88109E71941E2768A4630E03441D081DF6D97E81941A860CBEE41E03441DBD12EA220EA1941894660A85AE0344194AF6881CFEB1941667A85717AE034417520E3D966ED194159AEAA3A9AE03441D1F43E8900EF19417BD7A77DC0E03441CAB378AB82F01941CC60D9EDE7E034417002C8DF0BF219419168D7A914E13441E245FE1D74F319415108C26641E13441FE81DE5BDCF419413D4409AB71E134416653B2DB60F61941123AE25AABE13441435EB73AD7F719418F490292E8E13441EB55C57317F91941A6FB36501FE2344193686BF8C3FA1941C3A05B316EE234414ACC631FFDFB194108C3E31DB0E2344120308A13E7FD1941765FFE0220E3344135C6FAAE48001A41020AB03AADE3344115696A2BEB0B1A41B11B528668E63441C1DFE1A76F0D1A412E7E960DBFE63441C49C4631D30E1A41CAEA3E8304E734410FDE049F50101A41602380BC4BE734414965B019AD111A41B7806C6B85E73441DE576350F0131A41D27C9DF3DBE7344152E1C25DFD151A41E151596821E834419FFB271EE7171A4174FA835459E83441FD68FF3EB2191A414D93D4C58AE83441476E52D1AE1B1A41BE3FC954B6E834410CC52337961D1A41F2D7552EDDE8344139B907D3711F1A4189BECC33FBE834415D3979EBF7731A4134D912C1E2ED3441812496C741791A41D9237C8023EE344183CE6AF4627D1A411CC9663D50EE3441A540EDE3A4811A41A49346CD79EE34412EC87E58C9B21A41EEBE6D3738F03441E7C9C01C67BE1A41034F3CEFA3F034411828444723D11A41507387A34EF134413C0E888745D31A4157E32EE360F13441C4A22E00A5D51A411E1C3C036FF13441A042EE6E25D81A41C5079B5F7BF13441F7CE3EE784DA1A41DC0073D981F13441F1CA017DF2DC1A418839BC6185F1344125575F6415E01A416B0B73D981F134412398D44056E21A41B8892AF67BF13441849697D6C3E41A413886EAC670F134414644703B65E71A4172082FE360F13441361E6189D7E91A41B9CD72484CF134414EC09992BFEC1A416CE4F1702FF134410EFFF1405FF01A413E4E07B402F13441BB8CC2948BFE1A415B0D046A57F03441ACC2BB24660D1B41E48E081DA2EF3441934E5AD04B101B412715359080EF344127A3B73D15131B419879627C65EF34411C5018D2CB151B41D412BB3C53EF34413BF92E0BC9181B41FDEEB7EE43EF344138E307EAC31B1B41E7D212843AEF344170ED6547FD201B410A393A6536EF34413B74AB68E6371B415F70443735EF3441F8B7B7E2CE421B41524FA7C235EF3441915186F1C4451B412D5253503CEF34411E501DB91B491B41B21ECD4946EF34419FFFA7EA364B1B4157E00AA448EF3441494C2D6FFC561B416FFD007649EF34418F82FBE94C5F1B411D3D7EE548EF3441588BB872DE6A1B413EE4EE4E48EF3441C4ABBE3DB9731B4181EA887046EF34411BB9BA7E25761B4122D1DD5B46EF344159BDFB7317791B4183C8DA6E46EF3441FB4CA991EC7A1B41C29C01F343EF3441399BC7F0677C1B41BDA7C5713EEF3441956C99CFC47D1B414BB94D6F33EF3441890A5063237F1B4103CD0E8022EF34412B6F421E81801B414C491CA30BEF3441BE9D8D9317821B4111C5B1A5E7EE344146172F81B6831B41BDC06ABBBDEE3441A085A1261B861B4195C8732077EE34419FC0BB6F7C881B413DC7359631EE3441ED0CF6810F8A1B415427A23F07EE34412BE79DFA198C1B418A31AA3FD8ED3441C2A7B2F3FA8D1B41558FF039B7ED3441C8E35449B38F1B4100FCFD3E9EED3441999C5293CA901B41A48A928091ED34412C2DD3DFA8921B418D8C900A81ED34416ECF75803B941B41CA4C0ACD78ED3441A571A050E3951B4169BFB71774ED344135738D83B5971B410B80F57176ED3441393230E174991B41ACE75C827DED34418D542C66219B1B41B6D1BBDE89ED344151AB4A35129D1B412CF496A69FED3441DD49FD34CF9E1B418833E4F5B8ED34418306A0928EA01B41F2D79855D9ED344191665EBD38A21B41A544583EFDED34413688F98D90A31B41F59E54261FEE3441A345F3945FA51B4173F5B8BE53EE3441AA0F0B0613A71B41FBEDDA168DEE3441EDDB3E4083A81B4133FA0072C3EE34411621BE93DCAA1B41520C847022EF3441F8E63DFB12AB1B41C70C116B43EF34414A10998DF9AB1B41273709EF58EF3441D14E252389AC1B41749AFD2361EF3441E82FA6F972AD1B412BE2248668EF3441E53C50DBAEAE1B41B4E4248668EF344144F8FBBC53B41B41EA6B44B467EF3441AC19B5B8C3C81B41A6F6184562EF34412C681B6EB0D11B41AD22149269EF34415A61867067D61B4152C60BE360EF34414F00A7CA93E31B41769ACA9963EF3441
91	36030000	1	US  301	301	5	36	Marion	5	1.23	2.606	2212.8689	2212.86886996723	0105000020E6100000010000000102000000160000008FE924BF148954C0782B541769323D40908BF5C2148954C070E16ED66D323D4069416FCC148954C05EAFEE4F7E323D40CF9514B8148954C013CE315DBD323D409FD45E7E148954C014A3A406DB333D40BC163E5B148954C063D356209E343D400BE5DD5D148954C02A00CD66C0343D40F3561783148954C0BEA6393ED2343D40BA3B04AB148954C0377FD5BBE0343D40E9FEC415158954C01F10653DF5343D40F08C0616168954C0C51E70B215353D40FFB35766178954C04E24D65B34353D406F979383188954C05E0A121948353D403FE0B1E8198954C064A6CBD55D353D4079ED8CC11B8954C08F78A62876353D40429D3DA91D8954C084AB2F798C353D406BBAF5DF218954C09F13BF75B9353D40762393CA408954C050236F74FB363D405619539E438954C05023E96315373D40834D74EB488954C0B08A98EE44373D4002A5E7414B8954C0F40E9C205B373D408FD533AB4E8954C01635393A5E373D40	0105000020BC08000001000000010200000016000000DD729C91D2CF11412637EEBEBE003B4197DBA86ED2CF114100044D16D9003B418477BA1AD3CF11418ADE1D8334013B419B090AE8E6CF1141221C965F92023B412786F81F36D011413900357AC3083B4140F5CBED6AD01141B380E511FE0C3B416920918771D01141E3013044BC0D3B419FEBF80D6AD01141B276094C1F0E3B41982BD20861D01141997E59BC6F0E3B410FD99FFA44D01141F5D6919AE10E3B410C659303FECF11419F024AE6950F3B413B7B3B4D9ECF114144C3984A40103B4144A065C64BCF1141C5E43609AE103B41C516D5CEE3CE1141E362BDEB26113B4139094D2F59CE114108CA623EAE113B417D2B739DC9CD1141D167E16D2A123B41615FFC1C8BCC1141A7B02ADC24133B416E456DA468C3114199C90F7D251A3B411396BF0D92C211419DD241F1B51A3B41E0587970FFC0114155B0B9C2BE1B3B418F04FB2A4EC0114169202E5E3A1C3B41F6A4BD2345BF1141EC96EB374C1C3B41
85	79030000	1	US    1	1	5	79	Volusia	5	0	12.803	20581.4039	20581.4038858984	0105000020E610000001000000010200000057000000D616C59F744154C0C7E65F84FB353D40B75D047B854154C0B41E75A277363D408B669E8E9D4154C0DE2F6DB62E373D407732BD1DC14154C0217A1C3437383D40C9ADEA67E34154C0463DD3CF37393D40BFD829BFFD4154C0152EF28BFC393D40201F8F9CFE4154C0E4860AC2023A3D40BAD1ABF1144254C0E8B0A1F5A83A3D4066640195294254C08425AC41403B3D40C5761A63524254C038A31BC46C3C3D40A03621956F4254C03D989685433D3D40E6764C848C4254C0ED9DE51F193E3D405A9AB7D8A94254C06BA59CA1F13E3D403ED415EBC64254C05B7B081FC63F3D40DE3B565DE24254C0327225238F403D40187D2C5FE64254C03D506ACEAC403D401FED70B7E94254C04B825978C8403D40633D0616EE4254C0773FFC87ED403D40B66E4A9BF24254C0537A14D116413D4023044B8FF54254C067C218BC2F413D40E4A96D14FA4254C0449F5BD853413D4070005F47FD4254C0BE27EDF86B413D403C70BA22324354C0E203347AED423D40CB5AFE6B544354C05A8E9A0CE6433D4008550D02584354C0513A268BFE433D408D0B022C5B4354C0C9F35A9A12443D40EDE192545F4354C05C911EF12B443D4016B3AB01634354C013989F5F41443D40A0C97B10674354C0C65B49E256443D40A35A2B59714354C01F97DFA38A443D40389D0F69764354C0C1A6A3E0A5443D4069FF985B7A4354C049096378BC443D4032087A467E4354C014BFDC11D5443D401BF503B6814354C0EC792282EC443D40803243FF984354C0DB4BA7D498453D404D15C2F0B54354C06DAA6DE26F463D403A85DDFEBD4354C06244ADD9AB463D40BC63884AC54354C0D03D8A21E6463D407317073AF74354C0516FF70278483D407C00E35DF94354C0F7C9B80086483D4077AED6911C4454C0007C75F973493D40890DBF3C224454C00ED2E03D99493D40CBAF5FF3244454C0B6D1899CAB493D40ED60EC15284454C0BF0D3182BE493D40C8F7FB772A4454C0854901CDCA493D4033BF13AA2D4454C0895C51ABD8493D40EE610B6F304454C0B93D0359E3493D4065D623E6334454C001AB3461EF493D40DF1A02E8374454C03420F690FA493D401C0C62463C4454C00CFD67A5054A3D40EFA9828D404454C03A9B2EB80E4A3D4090700F75464454C09FB687D8184A3D4062101071584454C0896AC90F364A3D400D558FD25F4454C0822274E1434A3D4002D378AC694454C0424E2321564A3D40000FF258724454C06E17A357684A3D404B40EA3D8A4454C016A0C0499C4A3D40DE56F680704554C0729A067A934C3D4013723EC4AC4554C03338A9CC164D3D40A72EDA0EBF4554C0D1FB15AB3E4D3D40B2F0A9E4C64554C02A83CE20514D3D40C086DA10CE4554C0ECECBC0F634D3D40F45F5627D44554C0F67EB6FD724D3D4057DB4000DA4554C040298308854D3D400298E5A1E04554C001C81A679B4D3D403CB95FD6E74554C0007F13F2B64D3D40880E45BEFF4554C0AD041C02104E3D40A3EDC4C6104654C0132AE8B1504E3D4064D876B5364654C0FEEE9E8EDF4E3D40EB903E73544654C0810A605A4E4F3D40E28683F9C54654C083AF6074F7503D4037070FC1F94654C06898D6A9B9513D404D1AE674034754C0A4A4E7CFDD513D40DC4AA9C2084754C0540B8992F1513D40BADCD3DF124754C0A3C4251F17523D4003831BC1184754C01C8EECCC2B523D406827C8BE264754C0B32D141D5A523D402121D113334754C07AF921D480523D40FF2A6B043F4754C038178CE7A4523D40D4D0F30EB64754C0128A692504543D40E2B882B0534854C0D7BBEE0BD6553D40C501C61B614854C089A0EC07FC553D40AD13A6256B4854C0556A9AF91A563D4044382003774854C033C406BD3D563D4085D63179844854C00101A9C065563D40F0C48A5C8F4954C042CDC53378593D4053324AB8C04954C03D16B8FE095A3D40	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
73	11200000	1	US   27	27	5	11	Lake	5	0	33.71	54250.0924	54250.0924431456	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
84	13130000	2	US   19	19	1	13	Manatee	1	9.194	11.982	4495.5258	4495.52584804792	0105000020E6100000010000000102000000200000003958C62095A554C0EEC9E25077953B406900DC9796A554C0CC8036C376953B400287C195DAA554C05695F8F173953B4012B26E6EEEA554C086E58CB470953B40473ADA2F19A654C02C5226E865953B407637C4F12DA654C029AA2F0566953B407C56291644A654C0F0945DE764953B40E37625D757A654C0D4B2464F66953B404083F08B62A654C05655DB6966953B4047E4EE8191A654C003CC6A1766953B4036523B2CD2A654C06410D05565953B40F7D80A83F6A654C04851160265953B402580C7B709A754C0AEB6E21C66953B401097C3D112A754C0A8D7D13366953B40A156C0701DA754C0864BA00169953B402A709B4F28A754C00E59420F6D953B401951C85D34A754C0617FF05573953B40DB41725440A754C0EBFEC4717B953B40334644E449A754C0F4544C3683953B40A457E81256A754C0D96815548F953B406DC4510664A754C058F22C2F9F953B40AC98B1636FA754C0D4C5A64AAE953B402EDEC5D97CA754C080A93AB8C2953B40682FFB1789A754C00D8DA0FED7953B404890B24D96A754C0E3CD4F4FF3953B40F3F7814AA4A754C076604E4212963B409FC41EB0E6A754C0C3DD1C18AE963B40625D67E3F6A754C03493C3E2D2963B40C44342EE17A854C0CA5F188720973B40008620592DA854C0A30ABA9253973B403D08261743A854C0F43C30C389973B40E839BA3551A854C0D3B00E26B4973B40	0105000020BC080000010000000102000000200000000088B44C4455014188E65592C8133241AE1AD1315C540141049474DFC51332412D7CDC4F562A01414C602284C7133241CFE9E8C3101E014100B64097BA1332414177A8A89E030141FE56529289133241BA46A8E2CAF600410563197F8F1332410B87D8581BE9004127BE8DF48E1332419DA54A16E7DC004117FCB0CD9B133241E28FED6A49D60041BBF8EF1D9F13324117DA31FE43B900419229B459A91332418E90C5794D9100414C06CEBDB5133241F2A64D69D87A004172181644BD1332413EB185A4FA6E00411C2E1956C8133241EBD916D45A6900413C3C1B2DCB133241BD44C030CC620041D454EF77DD133241D6D594CE165C0041361007C2F613324142EDB744A7540041F605E8AF1C1432415A42B852474D0041A6401EC34C1432412D29A723634700412417AD537A1432413BCD58EEE23F0041F46F66B2C0143241156930194D370041A4D5F2451C1532417FDB51F54F3000417ABFC607731532414C40503F0A28004193B128DAE715324132C3C1C385200041E4BE5B0F61163241F89BC9D96B180041DC706A08FC163241696B4008D90F00410922365FAB1732415386BDF857CEFF40765DB1381D1B3241A9421E457DBAFF4033B01690ED1B3241679E7FB80192FF40F86FA4F0A41D32417CE3C239C577FF407AB0CBBBC51E3241291F80BC255DFF40A0145C0FF81F3241F266F239E44BFF402F3A6AEAE6203241
98	77010101	2	US   92	92	5	77	Seminole	5	0	0.521	833.6458	833.645818649896	0105000020E610000001000000010200000017000000E50BB62AA05454C0BB5B97FF42D53C40E28CFFFDA05454C082CF878948D53C40E6AA4D41A45454C037DFF5094ED53C40B25E1731A65454C00B3DEA4D51D53C4021A66B4CAA5454C08D64D0C458D53C4044948EACAE5454C0C3E06F6B63D53C40DBA4BB76B25454C09B93812B6ED53C40C27AA2D7B55454C01A3AFFD679D53C409C57BAFAB85454C03221714685D53C4061B222F2BB5454C02265E2D892D53C40DFC5E46EBE5454C0B5D585B4A0D53C40EDD261BCC05454C0AC07E8D0B0D53C4053E2427AC25454C002B067AEBED53C40954488D8C35454C0CD73AEB4CBD53C4026934031C55454C08A77D21BDFD53C40745A57F3C55454C016DD003CEFD53C40CF13AC4FC65454C0356D7EE501D63C4064CDB337C65454C07348D47F12D63C406035D3CDC55454C07A86E5A222D63C40454D31CEC45454C0BA4B89E733D63C404DBF9B2BC35454C05DC6328E48D63C40D25BD981C15454C05BE6AC6C5BD63C40FCD4AD88B45454C0F0241C1BEFD63C40	0105000020BC080000010000000102000000170000009EDA1FE22BE0204155C690548EF5384121A4D7CA0BE020419C69C41AADF538412022236E8CDF2041DD054FCDCBF53841C738EED540DF2041372FA705DEF5384182B8608DA0DE2041A2C381A707F63841470E47DCF5DD2041DA30DBFA42F63841D5531D1162DD2041DF4775D37EF638410224B55FDEDC2041F4B3A8C0BFF638413D6F4E1C64DC204120A4735DFFF638412F76F494F0DB2041FA75CAD24AF73841012485C98FDB2041FE3FB8D797F7384121031E4736DB204124D3095AF1F73841D68225A0F2DA2041A7A2225F3EF83841F469688BBDDA20411F020BB586F83841B1A02C8189DA2041CC171C6EF2F8384181C4B55C6CDA204196AC6DF04BF938416DA2FBD45EDA20415083CF7FB3F938418CD6AAFE62DA2041F561399C0FFA38415CD8E8A573DA204190F78A1E69FA3841EEC0C0329BDA204197F078DFC8FA38418E3760BADBDA20415119925C3BFB38417302814C1DDB20415F404AF6A3FB3841E13EC1CA1CDD204134ADE3A2D6FE3841
75	55020000	1	US   90	90	3	55	Leon	3	0	15.635	25175.3007	25175.3006751041	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
76	72090000	1	USA   1	1A	2	72	Duval	2	6.873	7.38	815.4995	815.499465957092	0105000020E61000000100000001020000001D000000A623D3C2966854C0D4EC61D831533E4029A311A8976854C0EDAC0FF821533E40FC5423469C6854C00938150BD0523E40A4B47F8F9D6854C0999B5C96C4523E409526A17C9E6854C05B76FB3EB3523E40D9A7CD659F6854C0830854D1A2523E4098AEC842A06854C0BFBBDDE190523E402767AE64A06854C0206D97ED8D523E400E3CC243A16854C0474A600E86523E4069548E32A16854C035B39D3E72523E40059BC661A06854C069B0AE3761523E40D168CBB69E6854C0234F681A4E523E40917A066B9C6854C0C5E036503F523E40D815628C996854C0F8D609AA30523E409690A183966854C09CFEBFA624523E400B155BC2936854C045789AC71B523E40EB68E269906854C0B5015AA012523E40DAEA00798D6854C0D47E0E2C0C523E400D518B7F896854C045E8E43905523E40223B93FD856854C066BAB55100523E40DE2DA44B826854C0614D7CBBFC513E407121A29F7E6854C08D241A89FA513E40DA3588CD786854C070A92042F9513E4002358D44746854C08D86BEA9F7513E40F7D3B847706854C0254FC3C3F5513E40CD4390906C6854C01013269EF2513E40952A63B8686854C054B1B7EFED513E405A05F62C646854C02DCE217DE6513E409CA386C8616854C089B12D77E2513E40	0105000020BC0800000100000001020000001D00000034C13E2527D61B41BCF3BEA2399F40413CEB9032E0D51B411AD97BA10D9F40410D43AA5972D41B412EBEB58D2A9E40415F2AF2D20DD41B4189D4C9D50A9E404184399951C4D31B4190D541C4DA9D4041997EF81D7CD31B41A20C0D3BAD9D4041B2229B6537D31B416034A8827B9D404152D98FD42CD31B4108C4FC51739D404116A77CBAE8D21B41CD8139865D9D4041740FD271EBD21B419439488C269D40418F5D232728D31B41B827F541F79C404111FD8E42A6D31B41F0623421C29C404152685E4955D41B41C1E5B4F7989C4041B222C08630D51B419418402A709C404171FFEAC318D61B41870934AB4E9C404136A507E3EBD61B41FC5D54E7359C40416E5D5178ECD71B41825A42531C9C4041D4D29B37CED81B41677506420A9C40411D0E8884FFD91B41784E54C5F69B40418050A31D0DDB1B41A48A72F7E89B4041DFA2874F29DC1B414626C5D0DE9B404120AC0FE543DD1B412103CF85D89B40412ABED21E04DF1B4104128EAAD49B404149BE8F4561E01B4123C81AFFCF9B40417301933694E11B41E7B0E083CA9B4041200B3209B2E21B4133D07E95C19B404176DCD09AD9E31B41B7046263B49B4041834740C536E51B41548EB87A9F9B404136A2AD8FEEE51B41FFF90930949B4041
99	72100000	1	US   90	90	2	72	Duval	2	0.491	0.992	806.8809	806.88094044651	0105000020E61000000100000001020000000D000000B86DA233296954C0451AF530C44E3E40DFAA6A9A286954C07AEB4A6DC34E3E40CAA8CA78146954C0FEF6C4B7A94E3E40EFC77F2AF56854C0034408D5814E3E40C249C9F5C76854C060DF7B29474E3E407439282EC36854C0DE503B123F4E3E40AB1A8AD4B26854C0CED01D61294E3E404A5279A5AF6854C0719A2551264E3E405B49F0A9AB6854C0D41C204A234E3E4046B7874AAB6854C00790FA4B234E3E4008E8C9D3A96854C0574E8178224E3E4007E6F327A86854C0A181203A224E3E40E75CE419A86854C0B558BF3B224E3E40	0105000020BC0800000100000001020000000D0000003294F76688A91B4104AAA6EEF7924041BE28A16AB6A91B41A0E65DC7F59240415F9F3728C2AF1B4177044158AD9240413E772F0D29B91B41267210F83C9240411563278CBCC61B41DDAD5EB9979140410C524FCB2BC81B4170BCFE0381914041690D4DC514CD1B4165026BF1439140412F8FEAAF09CE1B4125C21F463B914041A31FEB243CCF1B4127ADA6A8329140412DB1D2DB58CF1B414AADA6A83291404181C23989C9CF1B41E4B4A94930914041F010C8434AD01B4173DA85852F9140411F23477F4ED01B41A7FC42892F914041
100	72010000	2	US  301	301	2	72	Duval	2	1.922	2.576	1052.3149	1052.31490631892	0105000020E610000001000000010200000009000000F3F251C5F37E54C05E65D98E804D3E406BD72C6DF07E54C00337EE9E804D3E40E000F6D9CC7E54C042258A48814D3E4060AD7FF2BD7E54C0BF456D0C834D3E40717989A59D7E54C0C83CAD3B864D3E406A460B3F8E7E54C07F4FA194874D3E409381D649707E54C0A428B244874D3E40AB9F8B5B4C7E54C0FC2B45E4864D3E40C0327782407E54C01CBE071E874D3E40	0105000020BC080000010000000102000000090000005F47A591671A1541591DD7CBF69040414DFC3D42691B15415EDF09B1F69040414F03926C1E26154162A4D090F590404108DE531E9B2A1541076D5239F99040413A6CA77854341541F7399E60FF9040415A7E0051F7381541969BCBD6019140412131AD7CFB411541724DBA7DFE904041D03D19DCCB4C1541313ECF79FA904041498BA5C75C5015416108BE1FFA904041
77	26010000	1	US  441	441	2	26	Alachua	2	0	17.471	28121.9011	28121.9010840254	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
101	70050000	1	US  192	192	5	70	Brevard	5	0	18.478	29731.8788	29731.8788047903	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
102	16030000	1	US   17	17	1	16	Polk	1	29.132	32.906	6080.8391	6080.83913119749	0105000020E6100000010000000102000000330000008EAEE6D1E96E54C02A7688AA7C053C40A2286844EB6E54C017DB94E57C053C4072C92186EA6E54C05A85BD45B7053C40FC0C68F3E86E54C06FF2F3FE2B063C400933A1B8E76E54C067096CE884063C4022A1E38EE76E54C0E16624AE9F063C40D12007A5E86E54C0FCF4A5087E083C40D81C6FDEE86E54C02599F0BDE0083C40817CCD31E96E54C0CC1FBA1E2F093C401FBC79DDEA6E54C02742CDA99B093C40C3CF88DAEB6E54C0113AEFB8BA093C4023D754BBED6E54C0901196ECE1093C40F9D38B7CF06E54C0A630CA94070A3C404F12D120F36E54C019543721240A3C40A3004319F66E54C0294E59303F0A3C40B691F839046F54C07CAE9107B40A3C40353CFA12066F54C0C6D8CE2EC60A3C40A324546D086F54C0631CC464E80A3C40F1056DE7096F54C0564FC864070B3C408FFBF17D0A6F54C014519142210B3C404F0974850A6F54C0240219F93F0B3C4099777D900A6F54C00BC7C38E470B3C40776455590B6F54C0ED38535CD10B3C4066097F540C6F54C08FE0BBF2A00C3C40779150300C6F54C011029566C30C3C409B30B3950B6F54C0D4DA026BE20C3C40CF72097B0A6F54C0234F70B5FB0C3C409D5676DF086F54C0312B5D8A1B0D3C40299E877E066F54C053B49C7E3E0D3C400D780D83046F54C02E4DFD75550D3C40AFF61D39006F54C07A91D2987C0D3C408196BBF9FB6E54C01AC9635F9D0D3C40A7EBE26CF36E54C0BD9F7C0BDA0D3C4013197B32F16E54C0803FF671EC0D3C40D32ECC8DEE6E54C0E785E069040E3C4051004EF2EB6E54C0D505CED6200E3C405D643470E96E54C0E04A3A86420E3C40A9CF7409E86E54C04DE2C81A5B0E3C40A2219C19E76E54C0A99D5244740E3C409B4BB339E66E54C01E250758930E3C40E5A48BFCE56E54C014108AE6BC0E3C4051697216E56E54C074C22C73F40F3C406D0FEB06E46E54C0088C083FFE0F3C40776AB876E46E54C0446E0ACF3F103C40970942CDE46E54C0034EC1D871103C40405B7099E46E54C02776F07ABA103C40F132FC3AE46E54C0B5F481C220113C400F68D052E36E54C01CC6A8035F123C406152C6D1E26E54C094647F4620133C4039C46AD5E26E54C0C5B7D25853133C400226AE05E46E54C0DAFA718858133C40	0105000020BC08000001000000010200000033000000BC1009315D9D19417E5A0515177734416EF84338EB9C1941F7ED7688187734413BB8A68D2D9D1941ADE73D4C5C783441E923A509B99D1941E68BC9A9E37A34410B00C6BF259E1941408048C7D07C3441D9B6AE29369E1941CC740449657D34410B9A9C66209E194197F69232C38734419388E8E81B9E1941AE3D0FD5E689344177B637B80C9E1941FF565BB1998B34416A9B9CA1979D1941CE91C70FF48D3441522582EC4D9D1941FBBEA97CA08E3441CF7BD73DBF9C1941BFBAEC307A8F3441C1886150EB9B1941E908F16D4B9034416D70A1131F9B194186516D1FEA903441DB8D1CBF389A1941F7C5969780913441E4E3D1B9EF951941DE5BB6780A9434415FB1FAA3609519413F2C9B666F9434419E97F1E9AB941941007B23792D953441ACCF45BF3B941941AD9720A1D9953441C6628FE71094194151FB0F33699634419797A6B4129419417CCA5E9713973441EF1A5A5310941941D6B994AC3D973441966E9AFCE493194112DBD9433A9A34412DAD0F84B39319414B871807BA9E344196C33C42C393194149C63925799F3441CBE71FF9F69319411D6B7B2625A034419CA7404F519419418BBB8053B1A034414010EF2CD4941941DDD4EFBA61A1344167A7CD2A94951941F4A2665D23A234413F163758339619418F4A8D8AA2A234412AED0D508A97194102895C267BA334410630572EDD981941B2DA3B7A30A434412A003C96869B1941FE75140F80A534411B3ABD80389C19417C0F13E0E5A53441FFE153DA0B9D194152937E886AA6344166ED41F8DC9D194168A417EC07A73441345C05FAA69E194180D2C180C2A73441B57BBF9B189F19419C49E6B34AA83441A5C855BE659F1941AD6DA42FD6A83441701E02C4AE9F19419DED857D82A934410A4FD31FC79F194136B8440269AA3441ADAE3F7E37A019416C21754E29B1344106CD35518CA01941EEA653875FB13441D4E4BAAE72A0194123BB694ECBB23441479623BF5EA0194101AB0BF2E0B33441A63CF46178A019413BC83AE073B5344199D60C17A3A01941D0429341ABB73441196F01FE14A119413974F4C090BE344184D74D7C56A11941BDB331DDC0C234413B54872F5CA11941D5A32033DCC3344156BE174EFFA0194143E7861CF9C33441
105	50020000	1	US   27	27	3	50	Gadsden	3	10.952	15.944	8036.4287	8036.42871045253	0105000020E61000000100000001020000003C0000006550EE70FC1A55C0281F6E5A519D3E40DE6D8DF3FE1A55C09E465B0A479D3E40379638E3021B55C06A4D30F2339D3E400E0D928A061B55C0E714FA77209D3E40638CBC080A1B55C07997FDCC0C9D3E4024B8438E0D1B55C0E373ADE3F79C3E406A74B7F6101B55C0D9989D67E19C3E40D31BA21C141B55C0A153D988C89C3E40866D0021171B55C0636B6A5EAE9C3E40BEE64348191B55C0624786F2979C3E40682B7A821B1B55C08F8B3C597C9C3E4055A872651D1B55C034EB423C5E9C3E40BD46EFAE1E1B55C01812142F429C3E4090F187811F1B55C0620EFDF8299C3E40340E15F41F1B55C048F268520B9C3E40350B27F41F1B55C0988071F5ED9B3E407434B8661F1B55C00A0DD622D19B3E40D989BC611E1B55C0DDFB4454B39B3E404854910B1D1B55C0B612133E9A9B3E40496574451B1B55C0C35B12FF7E9B3E401B1EBE11191B55C0905FFEE5649B3E4004B6929C161B55C02F7EEF2B4B9B3E40C94AD456131B55C0C9D1F1642F9B3E40B7DE364A101B55C0F32DD79F189B3E40E16560EF0C1B55C0EC05CB55039B3E4076715616091B55C00327C15FEC9A3E4094703A6A031B55C0F74D168ACF9A3E40D071DF17FA1A55C04C6C7CF3A29A3E405F9A2F7DC91A55C05E5ACF68BD993E40C66DB3E8B51A55C06A41AAF261993E403F0A4F95A71A55C092E0E99B26993E402C8208DEA01A55C0AD6AAAAB0D993E403FD079CF961A55C0411D052DEA983E4029BD08CD8B1A55C0A62EB1C7C7983E40F49649467F1A55C0829FE78BA2983E40A2132281661A55C09876EF0B5A983E40E0C298BA4A1A55C047F97FAE08983E4004456BEAF61955C036D45C5612973E409A7D9548F01955C00E592E3FFE963E40E0617E29EB1955C0CC601D7AED963E40732AB39AE51955C0C033A22CD8963E40516A74F4E01955C073E610E0C3963E4073BDC737DD1955C0B88C8E09B1963E40B8C3E860D91955C0110F1F8E9B963E40701E9702D61955C06E2B3D7985963E4061A324E5A21955C0CC9F0BA20E953E40E99BBC4A9C1955C0C496D280DD943E4072D4B101691955C03F2B487F66933E40568D5934201955C087DA825A4F913E409F89B9EC101955C0034A6DF5DE903E40203007BAFF1855C0F4F8F02260903E40797BB0BEF01855C0B1EF6A83F38F3E40CDB6F778EC1855C0F82E3885D58F3E40182E81E8E71855C032B1F38EB78F3E40A492007BE21855C0967AF1FE948F3E402AEE7497DC1855C08CEBFE676E8F3E40283EC00CCC1855C031CE0D4D0A8F3E40D01C2F8AC21855C036E26E17D18E3E40EEA727D3941855C04E5A67D5B68D3E40CACCC651921855C0FA89ACCDA98D3E40	0105000020BC0800000100000001020000003C000000C536CD7123AA19C1BDC3DA93CE8B41414F0E3A5FEBAA19C14669CDABB28B41410F6261D926AC19C1FAB91DCB7E8B41411BB371DF4CAD19C1A735FFC4498B4141AFEC50A966AE19C11C52622B148B4141574CE48083AF19C1D546E01FDB8A4141008F7AAE98B019C1C0B259AD9D8A41414DF36C7F9BB119C13A814D87598A41411710861E95B219C145E155BE118A4141F86180D149B319C14144BE1AD48941417F0C54B607B419C14F61C81B8889414170F70E1DADB419C15D1DA10735894141A8D0BB0823B519C1CFC15880E7884141E7922DA872B519C1DDB78780A4884141D1EB8CCCA9B519C19F3762824F884141E942B9B1BDB519C146DF21F6FD87414104EDD2BBA6B519C18D6BB7C0AD87414173FA6B8A6CB519C1182590AC5A874141185E29C616B519C1D775909C14874141E5F07CDAA0B419C1D787896CC88641415968883E09B419C1C2FDBB4C7F86414131690BBA5DB319C1D10AAD21378641414A26C9F674B219C18762BD07E985414166133EF799B119C184669EE6A885414169399A79A6B019C1E53C59CB6C854141447E97378EAF19C1A6B08CE62B854141F243EEACEDAD19C1964B3B29DA8441416A49E23D3FAB19C126F25E9A5B844141CCEF36F3419D19C1DF4C40E8CF814141502B2A7B9E9719C11E93D12DCC804141688B2538799319C173A6D43223804141E7EE79BF859119C1CE8F6AFADB7F4141C4BCD28C988E19C1DDBE4377767F4141FBC1795C618B19C1DDFC5BBA137F41416E832877B78719C1D68DCCAAA87E41414769AC09788019C1504C1618D87D4141E846867B577819C1BEC33B07EE7C4141B622D596D15F19C19A351178297A41416B4F9632E15D19C1FE0559BEEF794141D7F052B8625C19C1AB2929AEBF7941412427C3BDC55A19C1265AD2E682794141877328ED6D5919C125A1AE2C4979414115D582465B5819C1549F5AC513794141E55F7D88425719C19B1D7AFED6784141E99AD6654E5619C19AC589B0987841416AB7A22EF04719C16B6C13D47874414142CEEE75154619C1DB96B777EE7341414D5421B2A93719C11468111ECE6F41410BCD2510322319C19777AFD1EA694141D7D17249E61E19C1571FAD40AE684141B6C10A9A101A19C1003CAC1049674141A772B01FD91519C17BA21E10176641417798C29FA41419C1F974E487C265414159DF9AA5591319C1DCD115006E654141FD30FF56CF1119C1B3938F710C6541417E725942241019C1A1D4D7919F644141116A9C026F0B19C133C674C684634141B61CE0DAB90819C18E7F0225E362414165E59C7CBAFB18C148B1D00DC65F414142666E7E02FB18C14404A524A15F4141
103	14050000	1	US  301	301	7	14	Pasco	7	0	11.342	18247.4845	18247.4844829499	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
104	11010000	1	US  441	441	5	11	Lake	5	6.313	23.29	27331.1943	27331.1942697342	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
106	06010000	1	US   17	17	1	06	Hardee	1	15.292	21.5	9995.7599	9995.75990253773	0105000020E61000000100000001020000002A0000005C389A46077454C079302020B88E3B405DBED728077454C0AB0476FBB88E3B409B71C02F117454C0D8091BCF5C8F3B4054B088EF157454C081CF6757AA8F3B40FEE739C01D7454C0652F81F82F903B40F86BEA442D7454C061A40A9130913B40680FE42B367454C0E87BDF6EC4913B406309FAF4467454C068CB87DEDA923B4066E0AAB3697454C01C6490D01A953B40F51E503D9B7454C0D7B1ADD94F983B408AB6C872C67454C0FE6B82ED1B9B3B406606FED3DA7454C09DC167FF679C3B40C26B0766DF7454C006B5E629B69C3B40B1BCCF53E07454C0AAE36464C89C3B4019F2F044E17454C0F2C4FCC5DF9C3B40AD34BF99E17454C05CDB9539EE9C3B40C5306CEBE17454C09F7DB263019D3B400BC0FB14E27454C0414F963A129D3B4069DE22FBE17454C0932359B52D9D3B40472AF58AE17454C0CF0FA39B439D3B4031755AEEE07454C0013339D2599D3B4085BAB2BCDB7454C040FDBE4DE09D3B4043E90F34D37454C078C07334C09E3B40C0B763B2CE7454C0B6DC690F369F3B40E2975168C87454C069E21C78DC9F3B4063A997BAC77454C0E8C870FCF19F3B409363C814C77454C0955549640CA03B40D1894A9BC67454C082EC432C26A03B40D5AE4921C67454C0D2E27E824AA03B4008E3E1F2C57454C072F0A5A369A03B403A1C5DF8C67454C088D44D126FA03B40E4EDBDD3C67454C0901E14BA89A03B4084A2E002C77454C065B37003AEA03B400A7D5DB3C77454C0D07A1741D3A03B404329D432CB7454C0D232F5446AA13B4063BD2FACCB7454C0FD3C78EC83A13B4055ED72D9CB7454C07D3377AC9AA13B401F48865DCB7454C0DBA0D291AEA13B402D4D73B4CA7454C0CB10222EC2A13B40922F528BBA7454C0B979B5116BA33B407795ED24B77454C019030C1AC4A33B40BBA46CE2A67454C03F9A58DB6DA53B40	0105000020BC0800000100000001020000002A000000EEC670BE03F91741B00608D8D9E4314163648D100DF91741DA5DEA94DEE43141E63B45C10BF617418869B5B36CE83141968BC8629FF41741CCFADF6C1BEA314117CD15AE48F21741689CD7BD01ED3141B80216A6A2ED174182AE193693F2314169392B1DF8EA174101E4F8A6C8F53141D1C60C33F1E5174135A96E73D3FB3141D4534FA789DB1741EDE684055308324116AF64DFB4CC1741B9B4982E241A3241614AAEEAC5BF1741222A624AAE293241D87D34B1ABB91741AA5AB521E3303241169ED0E84DB817410DE82F5C95323241AA2A3E2C07B817411C04E89AFA32324131A5C62AC0B71741BB5CC36F7C333241987C451EA8B717418F8470A6CC333241600B3EBC91B717416CCAD20137343241CFB5AC6587B717416D02EC7194343241272CD57493B71741566AC1DF2C35324181AAE359B9B71741E642C04DA6353241097B5503EDB71741ED2B547321363241A62F549D9BB917419887F7CD0A393241D400CE805FBC1741865578C4E33D324172C48841D5BD1741D1565EF9704032419AF39E22DFBF1741DA21094C0B4432415694DCF817C0174197708992824432419C0683164FC01741D21CE0F81445324134DCBF6C78C017416C7633EEA3453241D0D8937BA3C01741759D30726D46324162E76C6CB6C017413226E91C1A47324188D0A47A66C0174187910F6238473241E23279BC75C01741BC57183CCC4732415932FC8D6CC017419D76048F954832413095CA913BC0174121C3343E644932419166E86A3DBF17417541E975AA4C3241589D52BE1BBF17411D6E32D7384D32418D40322311BF174178BAC911B74D3241D5EA835A3ABF17419536D560254E324125602A7871BF17418F8BB114924E32410B9442E6ADC41741A5829D05C557324158BA1BD6C7C5174170927F7BB2593241CD8A22100CCB1741D3EA5738EA623241
107	08080000	1	US   98	98	7	08	Hernando	7	0.33	12.875	20191.1164	20191.116440867	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
111	36030000	2	US  441	441	5	36	Marion	5	0	1.23	1978.0765	1978.07650618148	0105000020E61000000100000001020000001E000000BD6F6C1CFD8854C03D0A74A1E22D3D4094B80775FC8854C044FCE2947D2F3D40B58C674DFC8854C0E511493CB02F3D406138424CFC8854C0B528FE06E22F3D40DF9B1D48FC8854C095A93006EA2F3D4089B08D14FC8854C0AD002E434E303D4063EFD017FC8854C029478F4F51303D4091E8C117FB8854C00439269153303D405C36FD19FB8854C08445670166303D40CAAE2748FB8854C0A8D7DB9978303D405F2FEFC3FB8854C0C5B346F38E303D401C9B9F7BFC8854C0DA9904EFA4303D40B5C5008BFD8854C0C48D6D3EBC303D405BD7C5C9FE8854C0B1623E8AD1303D40CDC20E3E008954C0F2DAC4DCE5303D40CE794CFB028954C08C93E1F40B313D4069A21041058954C00CC3F7A327313D407FCD11380A8954C034F9C9C867313D4043388E0B0D8954C08111F32C91313D405900E0490E8954C03C4A72CDA5313D403F759FC80F8954C0B3FEE42FC1313D407ECF2EA7108954C08AE356C5D0313D40E289A388118954C004308D71E4313D402837ED65128954C006F7D0E6F9313D409E25A241138954C09AB07DC914323D40122909E4138954C05EEF1F4B2B323D40B4D5E308148954C0BCF31A6932323D40D272FE67148954C0AC7239C744323D4023ED1EB0148954C08BEBC66356323D408FE924BF148954C0782B541769323D40	0105000020BC0800000100000001020000001E000000983273340AD611416D5A10F49DE73A41220D1BB095D611419A1AD33386F03A41ABDF5DA9ACD61141DFF8A7409FF13A41B07E24BDB7D61141FA8A268CB3F23A4172CB08B9BAD6114197874DEBDFF23A4115477F03E0D61141F98BE01A0CF53A412B7276ADDFD611415589D6051DF53A411A4A0C172ED7114121A47A5A29F53A4168B2406231D71141C659AFAB8FF53A41CD1B4D5727D711412BC746E4F6F53A41C2DAC27C06D71141465DF1FF72F63A419411B052D3D611418DD2211FEDF63A41296F34C285D6114198B4BBAB6EF73A41D9F1BA5629D611417E344214E5F73A416C90826CBCD51141F0ED971F56F83A41A8786F3BEFD41141DA9DEB062AF93A41AEBF332844D4114155F56113C4F93A4144BFCB32CFD21141D0C266F328FB3A4170E419F5FBD111414A88AE2A0FFC3A411367A0899FD1114198138BDC81FC3A41DCA04AF830D111410F78261A1AFD3A417B64AD9AF0D011412BBAD0BD70FD3A41A630663DB0D0114137019212DEFD3A413465928771D011415CB3BC4E55FE3A4154F6DB7834D01141AB3F7BA8EAFE3A4170658EE807D011417777B1AA67FF3A410E5FB23AFECF1141F222E42F8FFF3A41EBD69640E5CF11413A55162EF5FF3A41B189BA1AD3CF114129F9D3F556003B41DD729C91D2CF11412637EEBEBE003B41
118	17010000	1	USB  41	41B	1	17	Sarasota	1	14.882	17.155	3663.2177	3663.21773134381	0105000020E61000000100000001020000002B0000004A924711379B54C0674721AA17133B40C0A38FED389B54C014911B5D19133B40384BA52C3B9B54C0428E03321B133B40D689FA5F3C9B54C059D221A91D133B404DC4C9B73D9B54C09281F32721133B409043C4593F9B54C0CAFD630A28133B40BE40075D659B54C0BFBF80E4C6133B403C88151A679B54C0897CCE30CE133B409FE42C54679B54C0362D9025D5133B4016934F536D9B54C0A5FD5763ED133B40C2FCB666709B54C05530FB39F8133B4092285A98739B54C008BCC6AB01143B4098FA1F7F769B54C05E25260209143B40DD0540A9799B54C0DFA3979A0F143B407F7F53077D9B54C01B5F03E615143B40E131D01F949B54C0B7F2BBC538143B40CAC23A45989B54C0C5F14EFC3F143B4085FEF5E29B9B54C071F3CA5D47143B40B823857C9F9B54C0D42C451050143B407E801FB8A29B54C0A58051D958143B40855D3BBDA49B54C00E0E9BFA5E143B407DDDD8F4A79B54C0D632C74C69143B4037CA4299A99B54C0AFFF336369143B40E9A8CB80AE9B54C0B8A8C7B57C143B404DEE16E5B99B54C0A1DEAE4FAC143B403F79C6C5BD9B54C0F2824EF1BA143B405B266C4BC29B54C033CB10E1CA143B407327D9B9C99B54C02DC50B98E2143B403F2234B9F09B54C0F5207BFF57153B40B73CBC7B4B9C54C0FB38FDA36A163B4018D02DFE519C54C050A0E51E7F163B407B0877AE569C54C07667A2868F163B406A94966A5C9C54C009D11830A8163B404109DFBD619C54C0CDAF9230C3163B40A200CF19659C54C03DB6054CD8163B40573DCA78689C54C08572290EF1163B40342A88F46A9C54C0C19264B107173B4013687E526D9C54C052F9D67825173B4088DAADE26E9C54C0C150F94D3E173B4094F2D30C709C54C0B2CF87F65C173B408ACB3941709C54C0F0612E2A77173B40BACD1BD26F9C54C03D0508EC9A183B4077C90E476F9C54C0A8CBC78190193B40	0105000020BC0800000100000001020000002B000000B21C5BB2417B0741806C8497F77B2E41830A52E31A7A0741B32D18480B7C2E41520BCDCFB678074195169A9D207C2E4167945E44F9770741422976823C7C2E41886FC79825770741D0DEA1E5637C2E41CCB1B09625760741BBE6DB04B17C2E41EE8DA1B1DC5E0741366BA0AEA4832E419174EF18CC5D074143280771F6832E41850D598AAB5D0741E46C97B943842E41823570CEFE590741B861076653852E41BEBA737B1B5807412EE8230BCD852E41B24B84B02456074116EE984637862E413DA4FC4E5B540741A0EA2BFF89862E4170F1C9BE6752074157FAD19AD4862E4109F454C853500741B0D65CF71B872E41DA1AE5300F42074105C58856A9882E4172F544F57F3F07418166BE3EFB882E4117868909453D0741BB8ED5C54E892E41C58E435F0D3B074175DA36E6B0892E417F6D6D1310390741FE789FD6138A2E4151708E2DD23707416A7D6CC4588A2E41C4B58122D8350741A31A08BDCC8A2E4133DE7D35D3340741971BF173CE8A2E41FC25989AD131074118FD8110A78B2E41CF6DD664D72A074134909D60BC8D2E410CDF6897762807417D397579608E2E41BF51BD0DB02507416CA07458138F2E410C1C78241F2107414D9A6AD61D902E41F0D9E49A250907412C3D962B46952E416CEBFC065BD10641E439FEB956A12E417033D0145BCD064175CFE9ED3CA22E415DD84A697ACA0641050A1D17F5A22E41CAEAB8B3F7C6064126236F5709A42E417041BE43B7C30641F1B8875E37A52E415F514C41ACC106411F4ACF1823A62E4193B32138A1BF0641C832735737A72E41BC7AF82622BE0641C4F0A7A633A82E4186F8F735B9BC0641D1DD64257FA92E41095C8179CDBB064134C0DD6393AA2E41B1E2B20A24BB0641BC57FB17E8AB2E41F6F05FDF10BB064164AA05E90AAD2E41F42B268AEABB06416F594EECAFB92E410CD80506BEBC0641B986899454C42E41
109	87140000	1	US  441	441	6	87	Miami-Dade	6	0	10.812	17404.4478	17404.4477917179	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
119	29040000	2	US  441	441	2	29	Columbia	2	0	1.033	1661.9972	1661.99719038028	0105000020E61000000100000001020000001B000000AE2AF20BECA854C0BF031A847B303E40BF3CC006ECA854C0002D682486303E409FF9C866ECA854C03B2D0B6ED0303E408A326A41ECA854C0D24A6845E6303E402B11541DEBA854C08B97674E5A313E40F4A3F6D8EAA854C0FDE68A9BAC313E4046C30E20EBA854C0E63E67E3C6313E40471AE1DBEAA854C026B3558621323E40C3546B80EAA854C0634DDDD886323E40BA696C8EEAA854C0804186359C323E40A86E23E8EAA854C0A8215D8FAF323E409B41E985EBA854C0598972D7C1323E408A004E8CECA854C0BBFCA4ECD4323E40CEA1E1D6EDA854C0502A050EE7323E405DD5E153EFA854C0225055C4F7323E406271BFC4F0A854C0F12EBA3105333E405602874FF2A854C078D1D29D12333E4074AB9F1EF4A854C079F1E16220333E409CD338C4F6A854C025F7A45232333E4062AB3A92F9A854C050D8C6BB42333E405608B081FCA854C00DA10F1552333E400E51B4B5FFA854C0873566D460333E40036CC38603A954C0CD3F7FD670333E40DDF4C64208A954C059F0863582333E4088C6CE2B28A954C000908402F0333E404FF03A7A2CA954C0BF905CF7FE333E40784883F92CA954C0E87E17BB00343E40	0105000020BC0800000100000001020000001B000000EAEEE4C657DE0041C36377FD184540413B4DEDB261DE0041B23C267A36454041721F384B57DE0041EC5551B104464041DD81A9C67BDE00417109504941464041BA7EF7F975DF004199263F26834740419618A9C7D3DF0041D88FF58367484041A367A5BAB9DF004184A3077DB0484041D3E8E3BF1CE000415A1D80FCAB4940417FEBFDA194E0004196C89A20C54A4041BCB8DED899E00041B64E376B004B4041B35AE02570E00041AD719A2B364B4041A4A9E3BF1CE0004146AAB5FD684B4041EDB919D08ADF0041E2BA92179E4B4041E076512DCFDE00411FE63F96D04B404130EF3F3FF4DD004152FE5A2CFF4B4041B53F0F881EDD00415DED0DA3244C4041C0A9483239DC004159DCC0194A4C4041276EBFE92ADB00418E53D590704C4041B7A36B069ED900415AD207B6A24C4041473497CFF7D7004161C2C5A4D04C40419EF29FC23CD6004169D5BCA5FB4C4041A85CAA0258D40041F1D60105254D40418F439E6D15D200415068D6F9514D4041702B552046CF00417658B3D7824D404168003D6F51BC0041B0820B00B84E4041AD4E91A8C2B9004167094E1BE24E4041B3F8911577B900412C5EAA12E74E4041
120	89015000	1	US    1	1	4	89	Martin	4	0	1.171	1897.4516	1897.4516323087	0105000020E610000001000000010200000017000000A0D65E57721054C053A5A5DBFE323B4037DE5C8D731054C01CFC76FD19333B40EC425F37751054C0F1D47FBF33333B40ADF9E515771054C07162A1824D333B40C9068188791054C0CDAEBD9D70333B40C74BF27E801054C09FE417E3D0333B40354A437B881054C0B11177BD50343B406459656B8B1054C06416880192343B40D3AC16688D1054C0542CD06CBE343B4043CB406C8F1054C071AFF94BF4343B409F2457AE911054C04733CBF847353B4031A6E3B0931054C073E839B081353B40D395F5E3951054C093653029B5353B4090D4B05E981054C0336423E9E1353B408501EACE9A1054C0A986AE6A0C363B4009C5B3DC9D1054C0592518FC3D363B40AFC5DD52A11054C0E35282D66C363B40D282B316A41054C0B23B2F808F363B406FDCDD12A71054C024F43D92B4363B40A4E9A83DAA1054C0EA1F1EE2D7363B4017123503AD1054C0B37A818AF6363B403EFFDC04B11054C055B17E1421373B40A49F2BE3B41054C0AC9A923245373B40	0105000020BC08000001000000010200000017000000C6B2503A2A652B41DC8E2F97F6CE2F414CBE0465F8642B41B3EB8F5023D02F41DC3A65ABB4642B414F60E9AF40D12F412B16F5CD68642B41D0CF170F5ED22F41136FB05F05642B414E3395F4E2D32F41E8591FC6EA622B41D9A42F5E0DD82F4143ACBB84A5612B4137556CEB95DD2F41897F97A82C612B411D2D8F4D69E02F417F9A5BE6DA602B4114167FA155E22F413504155D87602B41C8145ED2AAE42F41AF248A4628602B415D36C0994AE82F415A8F6EBDD45F2B41D2B6C772CAEA2F41BA6B53187A5F2B415406B3FA04ED2F411D6D23C9145F2B41C2358DDCF4EE2F41A113D340B15E2B41245853DCCBF02F41BAAFC4D6345E2B4144E11410F1F22F41D679816DA85D2B41F871F80CF8F42F41FFA86774385D2B416EEB8DF577F62F4192994398BF5C2B41A216428712F82F4117F4F49F3F5C2B411720AC8B99F92F410027DBA6CF5B2B416F743905EDFA2F4195326EE92D5B2B412E92FF04C4FC2F41901E7B12925A2B410DD536CF53FE2F41
124	28010001	1	US  301	301	2	28	Bradford	2	0	0.447	718.6208	718.620840015951	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
110	57010000	1	US   90	90	3	57	Okaloosa	3	0	25.706	41520.5129	41520.5129355641	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
113	48060000	1	US   29	29	3	48	Escambia	3	0	20.075	32447.6071	32447.6070798656	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
123	52010000	1	US   90	90	3	52	Holmes	3	19.069	27.386	13415.4485	13415.4484852576	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
132	34050000	2	USA  27	27A	2	34	Levy	2	36.443	36.547	167.2943	167.294349741326	0105000020E6100000010000000102000000090000005F70F11504B754C0239D10F3757C3D4034244B1804B754C00D869118797C3D4094E5592204B754C0D2A208637F7C3D403461AA4B04B754C0E71F89978A7C3D40F3E8A5EF04B754C00FA7510B9B7C3D40EB4873CA05B754C082DB25A0A97C3D40F5385D5407B754C0CE29ECB4BB7C3D40927E967309B754C057D639EFCD7C3D40BE6CCB640AB754C0EA81B075D57C3D40	0105000020BC08000001000000010200000009000000933513420F7AEF408BFE09612AA73C419DD6777B127AEF40E9617AD83BA73C4139A31BEB0B7AEF400A0603C65EA73C412FEE8569C779EF4039F59B039DA73C418EC7FEF66778EF408F17C686F8A73C41BF4FB71B7E76EF40E4F4A9B849A83C4149AF2E06F572EF40E9AB9A8DAEA83C41B75AE7D7016EEF4043FE336114A93C414ABA5E91CD6BEF40F4495D703EA93C41
133	54010000	1	US   90	90	3	54	Jefferson	3	0	0.63	1014.2777	1014.27774385565	0105000020E61000000100000001020000000500000073732A97A20255C0DB94E909BE843E402A25FED9980255C07F9D07BEC7843E40B95879FE8C0255C06ED58F40D7843E40BF44607D050255C0C45B91359A853E409A8C1845020255C07D9A03D79E853E40	0105000020BC08000001000000010200000005000000C6375BBB506912C192E75B7AD7404141A03495B95D6612C1AF2D37E5EF40414170F9E444C46212C13A65DAE2174141413DBEADDD973912C1B5D26F201243414134062F6A9D3812C12765DB261E434141
114	34010000	1	USA  27	27A	2	34	Levy	2	8.323	34.918	42828.7713	42828.7712645047	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
115	03040000	1	US   41	41	1	03	Collier	1	0	32.308	51938.5302	51938.5302485132	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
122	72050443	2	US   90	90	2	72	Duval	2	0.106	0.48	601.7702	601.770211405304	0105000020E610000001000000010200000008000000714180D1026A54C0ECFE13FFDC543E40F8E70069066A54C06843AE18AB543E40FA6D03EB096A54C0F657B5F179543E405A8695720D6A54C0B5A4581549543E407B26D2D4106A54C079ACE58218543E4051BA987A146A54C0547C97C5E6533E401CCFC5ED176A54C003C09A0FB6533E40C47AC69B1B6A54C01CD481AD83533E40	0105000020BC08000001000000010200000008000000C2656E14D3681B415BD4FBD2EEA3404180069003B8671B4180D2F48F64A3404145C5B581A3661B410725EA5EDCA240419F7B1A5C8D651B415EB93AFD54A24041A8DDAA7A82641B41F2DD9266CEA14041A6E7831F63631B4123E3709644A1404133DAB91E53621B419A05289EBDA04041F2898D3231611B417F77420532A04041
125	79040000	1	US   17	17	5	79	Volusia	5	0.477	15.172	23653.0771	23653.0770569695	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
139	72070102	1	US    1	1	2	72	Duval	2	0	1.096	1761.6838	1761.68384305386	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
126	35050000	1	US  221	221	2	35	Madison	2	0	12.31	19822.9448	19822.9447503692	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
128	59010000	2	US  319	319	3	59	Wakulla	3	7.778	9.337	2507.693	2507.69297521341	0105000020E61000000100000001020000001400000053121F76D01855C000C1EB5F65153E409AEEFDF8CF1855C056F7EC9D6B153E40CAD8CD8BC01855C0A62CBDD531163E40EDB0956FB41855C0C3BBE452D6163E40ED6DC46DAD1855C0E6DF9F3D49173E40DF84BCB7AC1855C0027BF9A15B173E40B3DCBA26AC1855C0294D97FC75173E40C8FC5F41AC1855C0C9946EFC8A173E40572E0833AE1855C090B8F2E84F183E40C529897AAE1855C03C1F174881183E402FC18148AE1855C09EEF07969F183E40817BE0ADAD1855C068ACF268B2183E402027D049AC1855C0FE13F8A4C6183E40D10C8D5BAA1855C009700915DB183E402710C524A71855C09187D192F1183E402461B96DA41855C0F52B62C303193E40EB0C2667A01855C0D510643E1C193E40E42CFE946F1855C08F65EAF43F1A3E403113DE74621855C0AB597AA88B1A3E4042636304571855C0093A4629CF1A3E40	0105000020BC080000010000000102000000140000005BC35F54865D19C1E133C6E4B41140413F63A6705C5D19C1CFB29A16C61140410AF8429B315819C16E0C801FE81340411E4E04561D5419C1C6B83871AD154041F571B31EB45119C17E4AC28FEA1640416E35730D715119C1C3D4CD6E1D174041A2873CEA335119C1E078C574661740410A49D01E2E5119C1342B3ECDA0174041B53F2191425119C1ED6A9C38C419404128579B9C375119C17FAD4F684D1A4041C2A2C489145119C16E84F881A11A404181012E75D95019C12857EA9BD51A4041895379A5605019C171CBEF660D1B4041256CCCFCBD4F19C10881E59A451B4041BCAEC3D0B64E19C1E538A724831B4041933E1509D94D19C17D72E9E0B41B4041272BCED5914C19C1F3874AB5F71B40418C995757153D19C1413327D2131F4041B0CB4356ED3819C166D9D849E21F404129389D074D3519C18E73ED789A204041
142	10030000	2	US   92	92	7	10	Hillsborough	7	0	2.267	3646.1893	3646.18925560092	0105000020E61000000100000001020000000C000000066C2580DF9C54C091391009FCFE3B40C1FC1676599C54C0AB942BB9FBFE3B40CFFD34D1199C54C0D8CDEABAFBFE3B40AB4088FFD29B54C09A788BC6FBFE3B402322FDBDBD9B54C0D4EFCC75FBFE3B40A0D5D0A17A9B54C08EDB8DBEFBFE3B404242F0274B9B54C06FE96808FCFE3B40F9D89DCD109B54C001D8E20FFCFE3B403BD63DA0089B54C042E1AD21FCFE3B40A562133EA69A54C0A53AC816FCFE3B40E12D14D8819A54C0EAC237E5FBFE3B40ACAD9416809A54C0F7DEC4E2FBFE3B40	0105000020BC0800000100000001020000000C000000E39591FF64EE0641565F99141E5B3441E7AFB117E94007411703AA09FD5A34413234BE3A176807411DE04545EE5A344194B07A21B093074189C77118DE5A3441A05865DAC5A0074164AEB16CD75A34415650945616CA074176818C7EC95A3441301BCD9050E7074199C0CE26C05A3441C44B20CA3C0B08419D3BBBE4B25A3441D03B0E8845100841C48EB366B15A3441A2539264D64C084100A0589F9A5A34416DF4C68C3E6308410DA6813B915A3441C3FEB842536408414F3C4FC7905A3441
129	14130000	2	US  301	301	7	14	Pasco	7	0	1.602	2527.8731	2527.87309124654	0105000020E61000000100000001020000001F000000117BF614018C54C000D256CACA5A3C40903C1E2B008C54C0B8F659D8DD5A3C40D5D3B3FFFD8B54C0072A0530EE5A3C4050F52C4CFB8B54C02B889D25FB5A3C40B853F2E0F58B54C0EA2D40740B5B3C40B9FE1B4EF38B54C0E55B5BAD135B3C404B8B65E2C08B54C05D9CD28A8E5B3C4014CD4A8AB98B54C0E419C4B9A15B3C4036D0A9CDB48B54C002783031B35B3C402FEA416DB18B54C0C928DA45C75B3C4077007C83AF8B54C0F00D07ADD95B3C409BE48496AE8B54C012A96831EC5B3C40E1D2E513AD8B54C04CBE800B1D5C3C40FE325675AC8B54C0E6B52BA8325C3C40092985ACAC8B54C03C28192D425C3C40091EA066AD8B54C0EA49F673535C3C4037FCD316AF8B54C038C5519E665C3C40594E861DB38B54C0E40E8E47825C3C40FE9A66AFBA8B54C08171756AAF5C3C40E21E1A4CC18B54C0D8BD2DFEDB5C3C40E51CD391C58B54C0C8E6B069FD5C3C40183FDC62C98B54C0D7F1BC671E5D3C406441A840CF8B54C05790B9B0565D3C406280AF90E08B54C0A4CE83FC015E3C40F1D0615EF78B54C01AF1FDF1E65E3C402FCF33B5FC8B54C001CE7A020D5F3C407B443424038C54C0089A56A5335F3C403D5DA78E0A8C54C013CD8275595F3C40DAB26B38128C54C05BCCBB9C7A5F3C407F91EE421A8C54C0E1DB64B9965F3C40A704DC7C228C54C0C282B29CAF5F3C40	0105000020BC0800000100000001020000001F000000BA02C4D457BC10413D9C8A1AE65436419DE4C5BAA3BC1041A69A91A64F5536410F1557AE51BD1041CDC7F1E7A95536411FA778A528BE10414E23B249F1553641F03FB0C1D5BF1041EF3445B84A563641C37467A8A1C01041DC0C00D977563641993A1BFF33D010412F9ABAD31759364142A1ACE778D21041A8D57ED980593641CAA7A2AFF0D31041A54045D9E0593641F3354437FED41041B9365A9D4F5A3641F531B87598D510419F469A5AB55A3641C19CC52DE5D5104190F091EA1B5B36412805B36766D610417FCE19AD2A5C3641E5E4FABE9BD610417E2C1978A25C3641DA450B328ED610419F12289EF85C364152B91FDE58D6104150FBD89D585D364161D33D76D8D510411E428947C35D364166753852A2D4104193EC95875D5E36417F0C9CB759D21041AF232C6C595F3641065852345CD0104162163C075260364122D646FF13CF104124988B470C6136418F4D0C7EEFCD104175890E12C461364142C6F21A2FCC1041C697AD7EFD62364151F1770605C710411FC8D941B76636414D879E7738C01041C26AB405B26B36419D990A8F9DBE104165337640866C364122C51ED8ACBC104108CE9CDD5D6D3641FC5D46D56EBA10418B118D1A316E3641A2B477631CB81041E68BE688EA6E3641BF82772CABB5104169E38C11886F3641C53FFFB62AB310412AB81FC013703641
130	77030000	2	US   92	92	5	77	Seminole	5	5.92	8.929	4842.0244	4842.02442959933	0105000020E6100000010000000102000000270000003E5F96CFA75454C0D9B65B5DBCCF3C40E499B6849C5454C0CC2B6C6FBBCF3C4097D7D6A2855454C076B7A2D9B9CF3C407E936C9A505454C070EE4E1ABBCF3C406D703BC62A5454C0B3FFB4FBBBCF3C403F9EDDC1195454C0C46B28C4BBCF3C4068C2835B125454C0C2869D75BBCF3C404BA0A42B0B5454C09F89AB8CBACF3C403726855C025454C0C303C3C6B7CF3C406EBA6BE5E95354C093466C83AFCF3C403ABD9EB9E05354C023A31658ADCF3C40525046BAD85354C05F7E6F4AACCF3C40FB000D08D25354C0E38D8DD3ABCF3C40228E2BF9B75354C0D96C1037ACCF3C402D415C5F5C5354C06F5D0995AECF3C4084A3B4365A5354C096C645A3AECF3C40513B4088345354C0B29A41A7AFCF3C403F58AB4F275354C0F9F64FC5AFCF3C400A1A353B205354C069BD3675AFCF3C409537C7C9185354C05C07213FAECF3C40551FF36D125354C079893BEDACCF3C40A4DC83F4055354C0C4446A27A9CF3C4063EC165E005354C011D0384DA8CF3C406E8C8E6BFB5254C0788CAD1EA8CF3C40CC322CA0DB5254C0B0FCFA65A8CF3C405C3AB803B85254C07344E93BA9CF3C40B0ED57BEB05254C054AB951FAACF3C4061CAB622A75254C03C4C4E60AECF3C404752B685995254C09E62B56EB7CF3C402AC3D46B935254C0F913651CBBCF3C40311A9A718E5254C00AB5DE17BDCF3C403F877FA2885254C02C0ABE7CBECF3C40BB26F33B7D5254C099E862F6BFCF3C408D66FA1E585254C0DB079DEEC3CF3C400685D6DD435254C07DC2239DC5CF3C40E068B0E1145254C0276CF6F9C4CF3C40B33907C5FF5154C0584D301BC6CF3C40E09FA36CFB5154C0E4D2FCE1C8CF3C40C253199F7B5154C07D63F754CBCF3C40	0105000020BC08000001000000010200000027000000A936987ED6DE204181B06C16E6D6384177D6FDE98FE0204186B31555E0D63841C363E3620EE4204168473754D6D63841C6B00C9827EC20416BEA3E7FDAD638411C5CBA6EEEF12041602C406ADDD638416C98DEA887F420419E8FBC54DBD638411116D7ECA8F52041B2E6383FD9D6384150CA95DAC1F62041FE3800D4D3D63841253781231AF82041D4974AFDC3D63841CAB2424CD6FB2041F4A0DDE394D638412005E9C03CFD20418282C76288D63841421A695C75FE2041D8773C2282D638413F9ED21D7BFF2041C2ED50377FD638411DED58CC75032141436BA30C80D63841505FD0BE721121411DDA9C9588D638414536B623C71121415EA41DC988D6384156C2353888172141D1B7CF8D8CD6384187C5C90F8D19214135C8CF8D8CD638414B1AACD2A11A2141491F4C788AD63841E25974C1C41B21412F33596283D638416705764BBD1C21414D5CD6BF7BD63841042F16D7A41E21416E11103566D63841A517913F7F1F214171D4A03461D63841D8ADDFA540202141DA8B9AF45FD6384111048D921B252141BBB29AF45FD63841E069DCB68B2A2141F37086DF62D63841E5A365FAA72B214196CD417567D6384173CA60B01F2D21419AFEAF977ED638419B949E1B342F2141B99DD12FB0D63841F68366B622302141DA1BDF4DC4D638418D767258E5302141038BA710CFD63841DD181C78C8312141EEC9CB85D6D638410061762E86332141F0683D2ADED63841EFCC6E1E31392141B203F16EF2D6384172AEB3F3483C2141DCFDC0CFFAD63841B5A355AC75432141A857E214F5D63841D1DA2B03AF462141A945165FFAD63841BDB55DF358472141874E4E9309D738414C62E315DD5A21415AC1825711D73841
131	15025000	1	USA  19	19A	7	15	Pinellas	7	0	1.592	2559.8135	2559.81354745282	0105000020E6100000010000000102000000080000000AAFA86BEFB254C03CA6FAFBFDF53B40D8AC2690EFB254C0A60C600643F63B402101A7E7EFB254C0F07564D332F73B4094033A31F0B254C087D1097DD9F73B40321FBBEBF0B254C0B5F468F83CF93B40F6C3C500F1B254C07150C4B7B7F93B4074B7483DF1B254C073FA6C931AFB3B40D48C7048F1B254C0DBEAB8CEE7FB3B40	0105000020BC080000010000000102000000080000009A014C06D3A6F2405F18A967002F34419C43863000A7F2404676FC8C7F30344132F5636FCDA7F240076A774CB23534412E0A42644CA8F240E6747D304F393441D47F5FD536A9F240555E75F603413441AABEB735BDA9F240470E3B1CAD4334412093CB2342ABF2400BEAEE475E4B3441FB31697A40ACF240AEE6221FD14F3441
134	50040000	1	US   27	27	3	50	Gadsden	3	0	6.404	10322.3325	10322.3325421558	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
143	48280000	1	US   98	98	3	48	Escambia	3	0.232	6.067	9393.2974	9393.29735763343	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
140	13030000	1	US   41	41	1	13	Manatee	1	2.225	2.582	573.1538	573.15384507627	0105000020E610000001000000010200000009000000EAABC03C02A454C04EA3A1C6B68C3B40E944B12602A454C0C4538678B78C3B40461D5782FFA354C0D2FD283EBC8C3B401E57A95DF0A354C00A88247B198D3B40FAC3A79FECA354C0BF4B9B71308D3B40558FF0B6DFA354C03191CDAE7E8D3B403BD755A4D8A354C02E6F34A0AA8D3B403A6706B7D1A354C0E3EBC0B5D68D3B40AB96F288D1A354C0FE95B7FBD78D3B40	0105000020BC08000001000000010200000009000000D2426DAC55490241F2A3C4EFD3E231416A5905B363490241A54244C5D7E23141BEFB2776084B0241E4CE7596F1E23141C05011079954024199A8631FF3E431415D35A410F656024116CAE69771E53141749FA49D1C5F024105C8CC7720E73141C763CE63946302410399828312E8314197DB582DF567024127702E6105E931414B09EB5E12680241852A3E660CE93141
141	74040000	1	US  301	301	2	74	Nassau	2	15.294	15.637	552.1822	552.18216991826	0105000020E6100000010000000102000000040000009ECA7E14537554C06831869A498F3E4003D409DC467554C06BEB00D7818F3E406F6E7BEC1A7554C0A621815A4D903E400833D28F1A7554C0F4BB33084F903E40	0105000020BC0800000100000001020000000400000095FB0582F60A1841E560CEDBC4464141D507C3D4AA0E184186020E0B604741416C1C1C5DFC1B18414CEF19AB91494141563BB573181C18414480EE4C96494141
144	38010000	2	USA  27	27A	2	38	Taylor	2	0	27.458	44209.6319	44209.6319044014	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
145	79040101	2	US   92	92	5	79	Volusia	5	0	0.411	658.9642	658.96421368366	0105000020E610000001000000010200000011000000FCD4AD88B45454C0F0241C1BEFD63C40EF3E0054B05454C01504098418D73C408007F729AC5454C01846EA613FD73C409E9AF517A95454C09F42BD155ED73C4000AD4946A75454C029892D6273D73C40B4517312A75454C08E5673C175D73C40E1D2627CA65454C0BDBE0FEA7BD73C40652F9FEBA45454C0E5BC979992D73C40105B5120A35454C09ED07E2DABD73C40EEEE36BFA15454C0DDF081E9C4D73C4033FCF56FA05454C00AD05D83DED73C40C2CF3F8F9F5454C0B80EE458F3D73C407B1165019F5454C0779D850503D83C4077A41ABB9E5454C0FF9A248A0CD83C40B0C05B329E5454C0434CF32021D83C407C7E17F09D5454C04DDE311E36D83C40DD5CD3139E5454C0D4EC3C9869D83C40	0105000020BC08000001000000010200000011000000E13EC1CA1CDD204134ADE3A2D6FE3841C7A54569C2DD20418DE8A529BCFF3841235BBC5366DE20411267E494930039419FA7D43EDFDE2041752302C33D013941732025FA26DF204193D87FD5B30139410AAD4DF62EDF20417B7804FCC0013941A4C07B0E46DF20414166671FE30139410542B6EB83DF2041C96D7AE76002394125C533C7CADF20418024D82BE9023941A1B41B7501E02041345ABAE077033941D003526835E02041743C13D905043941B7B1B15658E02041339EA06479043941435A30776EE02041B226FE53D0043941E073817B79E020419DAB211F050539415D822EFA8EE02041EBDA625377053941D8839AB999E02041E42FB8C3EB05394187E1C9D195E02041A7C7106009073941
146	46160102	1	US   98	98	3	46	Bay	3	0	0.296	474.0242	474.024215282151	0105000020E610000001000000010200000008000000C2034FE6E57055C01DD6BD9E40303E405251ADAAEA7055C0776666AD3F303E40BB0539AEF47055C0A7F9A6933E303E40635D6AA2FF7055C0EF83AD9D3E303E403FB670E0077155C0A75F415B3F303E40C84BBB57127155C08C9CD09C41303E40D6F403A6207155C06BEB853744303E406A46414E367155C03A56A81C46303E40	0105000020BC0800000100000001020000000800000011FC49784CEF29C1591549A0C27A404111A3141305F029C1263D78EFC17A4041B4B4907388F129C1D5E820EEC27A404198E4099D2FF329C147F95079C77A40411F531EB16DF429C111619DDECC7A4041DEB8C7F800F629C15AFDE960D77A4041C0DFBE6E28F829C1F3DB4F69E47A4041C8F9E53A6CFB29C1463CD073F27A4041
149	54020000	2	US   27	27	3	54	Jefferson	3	9.997	17.036	11337.7599	11337.7598562244	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
136	17020000	1	US   41	41	1	17	Sarasota	1	0.679	22.43	35000.2464	35000.2464229726	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
137	38020000	1	US   19	19	2	38	Taylor	2	1.029	17.387	26329.2042	26329.204242751	0105000020E6100000010000000102000000220000007D47BD75B4E554C09C3D01C0971C3E407D9B001BB4E554C05EC616372C1D3E402F236117B4E554C02A360A254E1D3E405033C486B4E554C0F790F1C57C1D3E402A323991B5E554C0C9824A41FE1D3E4032C8B0C1B5E554C09EFA63360D1E3E40082E2210B6E554C0506C971A181E3E40643130FCB6E554C053322221251E3E40B1B43B98B8E554C00E289848331E3E402F243196BAE554C014E2A2F33F1E3E40BAB451C0BCE554C045EC06F84A1E3E405370215CCDE554C0100CA2E3A01E3E40AD9C8315E8E554C0796D6695271F3E40F69185C207E654C0D32126D3CA1F3E405A24C3240EE654C07F2A2B6AEB1F3E40FC8A82A813E654C0ABC185A106203E403F7F66B71EE654C0D97CD0833D203E40C77BF0AB37E654C0AD25F897BE203E40697C927521E754C042286FAF74253E40946653A00AE854C0C949C095272A3E40C8EA9D8CF5E854C0364BB631E22E3E408D32ABFC2AE954C01B06EBA6F52F3E40AD421F5739E954C0AC7FD02C3F303E406F7253EC45E954C01A0B71B37A303E402CCD605351E954C061ED0F80AD303E40C1E736BAD1E954C020FA7E9BE5323E40BD29DF50ECE954C005A29B555B333E403EF7AF8E37EB54C0EBF38EB715393E40A7619883D7EC54C0423BF28840403E4049DD305965EE54C04D261E201D473E404A5001F024EF54C05CAB8BF86B4A3E4025FEBD15CCEF54C0C1B7864B4D4D3E40FC285286DDEF54C0A894DCFA994D3E40E433CA45E0EF54C0B2351A31A64D3E40	0105000020BC08000001000000010200000022000000C5697C519AD903C140ECED4AC4184041EF3928F7CDD803C134C1A05B601A40419F469996A9D803C147C93E8BBE1A4041FE711BCEBDD803C1F48FC714401B40415BE49814DCD803C11C6E02C1A71C4041D4927C3FEAD803C1E1B54D51D11C4041DB7752990ED903C18A719A9EEF1C4041DB7863E48FD903C14AF215FB131D4041DE2B993A7ADA03C1951F2BA03B1D40414C822C23A1DB03C1B33DA73A5F1D40415FDA7A5BE4DC03C185D287497E1D40417E12C2FB92E603C1106BA371701E4041CBB340A92AF603C126A20338EC1F404199DFAF17A20804C151B7E854B821404129318E1C5B0C04C139482834142240416D1F0852930F04C1DD5AB8F7602240412D84A0B8071604C1159379C1FB224041527E3C58932404C1E64DCB906724404136388EC9D2AC04C1A2579743AF314041A49F6DC3A73405C19D8FAC4AEE3E404188FAA1FE75BD05C1A3950871434C4041B626766B92DC05C11843C5194C4F4041C207C803EEE405C1546F6A6C1B5040411212B0BA46EC05C104F6407EC350404130D0423EF2F205C1384AC012535140410D8E4E50103E06C11AAB4B089957404176C535CD9D4D06C13D7A79D6E5584041EC48F8DF520F07C18A92D58D176940418750C797770208C16EC509275C7D4041106BC58FDFEA08C1E766D666C4904041EFF1E069BE5A09C163AF88DC1F9A4041E60CF2C852BC09C1C69168C645A2404196E8971781C609C148D4D6BD1EA3404111565D9D1BC809C1EA28484941A34041
165	04020102	1	US   17	17	1	04	Desoto	1	0	6.971	11237.5226	11237.5226087042	0105000020E61000000100000001020000002B000000F5674E1F367654C08A24911DE23E3B406390CF88307654C0A7E0CD5E133F3B40334B5249167654C08C4D5ED203403B40B2CA2BAB087654C0C1D98FAF7F403B40E3E34685F97554C03B0EE9D40A413B4072631C4BF37554C05F33CEA743413B404169E70DEB7554C08DC8EF8D89413B409C915890E47554C0768B1555BD413B40AF6D53DADD7554C0DFC14239F0413B407B382C01D77554C0F0CE356122423B408DF5AD22D07554C0D351F64458423B405DC69BC4C77554C04FF2D72E9E423B40AC14F79DC47554C0CF2C2141BA423B408FE1AD15C17554C0208D3FA2D9423B407096AB438D7554C03ACD72BAB2443B40270C12FC677554C06FCB3A9406463B402C87998B487554C0DF0F739D25473B4087075AC52A7554C0A1ACECF634483B40999C690D1E7554C02B7362E5A8483B401B6997AE0B7554C0AF2A31DE4F493B4086EDB129FB7454C0DCFEED49E6493B40330212CCCD7454C0C1DC057F834B3B40990FE8BABA7454C03953A886314C3B40A02F1B87B17454C05EF8C8CC844C3B406111A7F68D7454C0B4CCD84CC84D3B400F1D46B8717454C0D7336F05CA4E3B40DC5F194F637454C063752A184E4F3B40712E41805D7454C0AD501029884F3B4023E5184C577454C088A74EF6CA4F3B40811D1277537454C0E57F436BF74F3B407F03873A4F7454C00FED78FC27503B40E002F6464B7454C0D539D89A53503B40BDBFBD16477454C0E0BC5F637E503B40CA4C37BD417454C000AAD3D1B1503B40B6532E063B7454C033A2A9F4EE503B4004002CE3347454C01506768126513B40EB79424E227454C04CE1316BD0513B40FC6C4777E87354C0DFFB26F9DD533B400FF17389C47354C081C864BA24553B40E4774086B07354C069236C1DDB553B40022ACCEEA97354C0C1E438E215563B40F3A70CB99E7354C0FE7103447B563B4061611CC98E7354C01DAE4A4C0E573B40	0105000020BC0800000100000001020000002B0000001C2107D145401741D144EA59432A304189BE3A7D0842174102CB1CD4532B30415D78AAB94E4A174156487225863030414344A181994E1741BC0A966C33333041B9BEDAEB5F531741BEC467453536304183521560565517419C0E31A76F3730415B2E4D5CEE5717413756264CF2383041AD8BD1ECF8591741C3A08DA7103A3041FF6235D8145C1741271478102A3B3041BDD765883B5E17411405AC603F3C3041B523DA6C6460174152F45366693D3041FEF98B8B066317416CFD6C1CEC3E30415AF602A8046417416BB9E968873F304199CAF28221651741A335FE013540304133185F017675174165EF5D7B6E4A3041F98619123581174181A37AC5C6513041379262E51C8B17412573C4DEFA573041E6C9542F7E9417418F106A2ED85D3041B7617BE07F981741DAE3E59A59603041DED8443E499E1741DC6D986BF56330418D10964F7DA317411F5D59AB35673041A14F3041C7B11741303F4DE1237030418F281D9CC8B7174153CB44C5E6733041F35F6E74AEBA1741C19C2282B375304128647D8DE1C51741CA65BE66B17C30414E6C8C6DC6CE1741E28F885D43823041E7053C3050D31741DCB153221E8530414B5F7E1A25D51741F266677C5F863041304B2DA81AD71741778EF83ED18730419843D0EE50D81741ABBA965CC788304197273CDCA7D917412A6FEA39D48930414BF3FF76E7DA1741252E4DADC58A3041766E5BBA39DC174159839F76B28B3041CC131250E9DD17411C6FA112CF8C304183192E8906E01741D48FE956218E30416F979D19F5E11741806BB4B1548F3041A3FED5CFCEE71741B184CDD600933041115D2AE003FA1741FA3FB0C15C9E304149E047F65205184156F517BA6CA53041292F017A9F0B1841134575E75DA9304190BEF264B20D18418B6A6510A3AA30410199FB7A391118410FE2EB04D4AC30416410F9C63D1618410F7FD29A01B03041
148	37010000	1	US   90	90	2	37	Suwannee	2	0	26.152	42094.4602	42094.4602301583	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
315	46010100	1	US   98	98	3	46	Bay	3	0.245	1.953	2747.0464	2747.04644463068	0105000020E610000001000000010200000027000000EB170278E17055C0F5A5FFB122303E40122DAEA0DB7055C05A586AA826303E408BB6585CCD7055C00A91ADCE31303E40CE4422DBB87055C0FF9D05C43E303E4030421FECB17055C0D4F33E1343303E401DAE954EAD7055C08E84215C45303E40760E35F7A77055C0A2B5B8F146303E406DA65F24A37055C0514520B847303E40B19F54A39F7055C00C035DA447303E40782732089B7055C063C8653647303E40D3BFF41D977055C08A80B85046303E40E145952F6E7055C054859BB83C303E40BA87AEF44C7055C0705FF0B734303E40D5EE712E3D7055C02C8E276930303E4019C84C01317055C05B1F06F92C303E40E801DCD5237055C045A81C7529303E40794AF09E0D7055C01F3B391423303E4093648B6D017055C06F315D0220303E4021F2743BFB6F55C02C9D83001F303E40D488E996F66F55C050E535041F303E409451C993F16F55C0D49DF0E31F303E40FD1B11C7EB6F55C09D0B9CFA21303E406A7570FAE36F55C002EBB34326303E40A1F0A0E9DD6F55C067603A0D29303E40550248AFD76F55C05EB8A29D2A303E4076C96324D26F55C0F525EB452B303E4032B18906CC6F55C0DA7DFF922B303E40F5CE2100C36F55C0E2A3AB762A303E405D78C8DE776F55C02BD4BDBC1A303E40405CD407436F55C0CA79D46712303E404B8351033E6F55C0472E431411303E402ABF8434396F55C0489D06A60F303E40C02B7732346F55C0D4D2015E0D303E40814B11DD2D6F55C0122600AA09303E40BAA2863F286F55C0AA3CFD0006303E406C400C58226F55C07CC55A2301303E40C7EDFABE1C6F55C01C93E26BFB2F3E406802BA67186F55C01CB83BB2F62F3E40F08A9A31126F55C0D92FBC16EF2F3E40	0105000020BC08000001000000010200000027000000D3D6183CAFEE29C1717CD1A86D7A40415B4878BACBED29C177F11C4F767A4041C6426F5C9FEB29C1C9174D868F7A404171F2662B81E829C18633D73EAB7A4041AE8F0E4C73E729C18DE3246BB47A40419850B0EDBFE629C10144DFE6B87A404191A353D7F0E529C1EA992225BB7A404151C7FA2136E529C1BE272F59BB7A4041711CF9CBAEE429C107107DB7B97A4041D491FF0DFDE329C1F05107A9B67A4041264FAB3966E329C1D20E6695B27A40414575C2683DDD29C145C1145F877A4041B2DA245D3DD829C19F76D5B3637A4041449AF8F5DDD529C11B70A55B517A4041DB91702709D429C12ACA93E2427A40411B61EC010ED229C16CFE0ECC337A404139FDB3C3B6CE29C1A801E819197A4041FF9DF924E1CC29C1625FECA50B7A4041A66EF041F2CB29C10F403359067A4041523392E33ECB29C1831BE083047A4041B6E817D97CCA29C14D3FF9EB047A4041EF6E23D29BC929C1BF63FE62087A40417BD5B9856CC829C1BA9ABC26117A40411E2F53E580C729C1BA668073167A4041D2F3B2918FC629C12FC54949187A4041F9A53024B9C529C10844BAE0177A40419CAC97B3CCC429C12AB3733F167A4041DD39CA8E70C329C1239E80850F7A4041514F566221B829C1F6622488C5794041F88295EB2BB029C101A7A51899794041B89022B16AAF29C1DE9CC863937940412599079EB1AE29C1C271737A8D794041C1FFC633F1AD29C1C3DC391F8579404139C7653CFEAC29C10491CF47787940419829B1FE26AC29C1D97FFFD86B79404180648A2745AB29C14DF3B3F25B794041797D658A6FAA29C1D19390CE4979404101051C08CAA929C1E6CE65ED3A7940411C1B8397DDA829C1718DDD4823794041
150	12001000	1	USB  41	41B	1	12	Lee	1	1.029	5.137	6615.3699	6615.36986215664	0105000020E61000000100000001020000002F0000006590FE0EFB7754C0089CC16EC4A83A401ECF122D197854C0ADF467AF6EA93A40FD778DB1227854C0D159244BA4A93A4054D9642D417854C0C30209C955AA3A40CFD6EE4C577854C0AD24EF08D9AA3A40A008AD6D687854C0A4D9B75939AB3A40C25EAFFA737854C06BE84D387CAB3A40BC72BA1D787854C06BD5D60997AB3A401B01A6F07B7854C00FEFBEF8B4AB3A402BD1E8A27E7854C0DFF194D3CFAB3A401169ED23817854C0A6C0A2F9EEAB3A40951EEAF6827854C0396A79D80DAC3A405E577411847854C06B68E8952CAC3A40C2C1B37E847854C0B97041304FAC3A4066CA9049857854C08609F9D1CCAD3A40EE9A3901867854C01A92514A02AE3A405476BFC6877854C0148BC7B444AE3A404ECF656E897854C0ED0B840A71AE3A4023133ECC8B7854C0679BDDEA95AE3A404595B8698C7854C0862B5B629FAE3A40FFA8225C8B7854C0DED5E275AAAE3A40FB8A94CE8D7854C02E793C84CFAE3A4009F3EBCE8F7854C0E6C143FEEAAE3A4013770AF7917854C03AEE38E003AF3A40829AE2FB937854C074C7768E1AAF3A40401A6FF2957854C0F9D2B2FD2FAF3A40A9645B9C987854C0AC3491DC48AF3A403DB357E59B7854C0DC3B708D65AF3A404CEF5F7AB77854C0A7AA3FED54B03A40260B3756F47854C07B3351C566B23A40C46329C3FA7854C0DF11512B9FB23A40C74C6412FE7854C031A503AEAEB23A4037DF8360047954C09B5FCA06E3B23A402BFD38170C7954C07BE85CD414B33A40124DE2D9117954C08E5EDEE337B33A405F5EB584177954C002F6462458B33A409DFE51901A7954C033391C4B69B33A403A2862651F7954C0590F066382B33A40606C7C442D7954C0D0CB3898C5B33A4069F56D65377954C01B333CE7F7B33A40CC11F8B3467954C06AEE445F42B43A40CEA543054C7954C0D22509DE5BB43A407EE4205C557954C0111C778887B43A4033E0BCB0A07954C03D09EB41F3B53A405212F681A87954C075239A2018B63A407C5ECC45B47954C082F13B4056B63A40C2A55C13B67954C01245215E61B63A40	0105000020BC0800000100000001020000002F00000070C2D364DE9C164159FB79349ED329419CCAADBB9693164120A1962607DB294159E720FDA79016415AF037775CDD29419552FF5F448716418A90A2D815E529417561BE6D74801641FF106AF4CBEA294176A0B77C2D7B164195C65727FDEE2941A7AEB5BE9E77164108289628E6F129413BEF7C0259761641CE36FACF10F3294187B9A9B52C751641D8DD1BEF5DF4294119AD15D859741641C4182E9888F52941BD7BE1F996731641371404D6E2F62941E0BA00450A7316413725DBCD39F82941102499FDB6721641E00043208FF92941289907479A72164121A7831D0FFB2941A49377B195721641119E0403990B2A41A9FCEFB4647216414E841863EA0D2A4136F18EAAE171164182313AABCB102A413B162F8A647116416732ECF5B7122A4180146287AD7016419FD3E8B451142A413628C5F07D701641FC82B1E5BA142A419F342399D37016414FB8997B35152A41489EAE33167016410241A03ED1162A411505A0DE7A6F16417389069D02182A41E7E08FC0D26E1641B9B57A3F17192A41E22D6148356E1641B3C48E6A131A2A41745216139C6D1641419EC3BE011B2A4181520789CB6C1641D0F5E562161C2A41A1C6DB0CCA6B1641B518A494551D2A411A6F620458631641A7CC6ABEBC272A419980815CB65016419887C28AC33E2A41BD0A7AE2BE4E1641FBCBC3FE36412A41D9767379B94D16418ED928FCE3412A4149B37DFACA4B16417FA353752A442A41CE1227D16B491641E223F11A55462A4160F73814A64716413F213AA9DB472A41A952E054E7451641F99F9D0743492A41494DFF3DF7441641219E8227024A2A410676DEF279431641E7ED69E1194B2A41F795E3AC323F164101119B55074E2A4187093422133C16413AAAAD4538502A41DA334F9E5A3716414E95C5AF76532A416D6EA9BAB6351641AF8C990293542A4175DFD01AD53216413E70FB097A562A4141545195991B16414CEF9B3D52662A41E3B78049301916419B5F2E77ED672A41937B8A4F901516412CAE36F6A16A2A417DCFB65902151641F6ABE4CB1D6B2A41
152	08010000	1	US   41	41	7	08	Hernando	7	0	9.31	15006.2783	15006.2782561102	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
193	74040001	1	US  301	301	2	74	Nassau	2	0	0.538	866.1546	866.154589955128	0105000020E61000000100000001020000000E000000AEE62D79C67554C06C5AE0ED0B8E3E4070143BF8C27554C016D9EC6D1C8E3E40BCAA6799BF7554C0FAD3C0692A8E3E402862339BBA7554C095E81B773D8E3E40352B42CFB57554C0C6C4578E4D8E3E40EEF7977BB07554C0C6EDD0C55C8E3E4097928B31AC7554C0F832ADF8678E3E40EE06BA16A37554C04DF7F90C7D8E3E40B3F8C9DC747554C0ED11AFFCE48E3E40BFBC87C4687554C0B8580763018F3E404A29D664637554C0B08E8BD40E8F3E40DB30F3FA5E7554C06397F3F31B8F3E4025986271597554C01EBB4B502F8F3E400CAEE964537554C025957128488F3E40	0105000020BC0800000100000001020000000E0000007578C2651EE81741D264CB8F5B434141365C30632EE917415AEF0A1989434141187960B733EA1741557713A9AF43414158F07293B6EB17410F90F52BE4434141098B04DB29ED1741CC5DBA7A104441412D8B47BBC5EE17412F47E6523A444141F58BCE3411F01741FFC6C117594441414A1E7060D0F21741A6CF98EF92444141549EE8E7C1001841F4C0600EB04541414E0C590668041841ABA3C800FE4541417A7FD03107061841B0E1EFEC22464141D615E6855C071841CC4EC00647464141B1C6F03A09091841FDAC8D5B7C46414133408021DE0A1841A32F91DEC0464141
153	55002000	1	US  319	319	3	55	Leon	3	0	1.33	2143.2023	2143.20230118081	0105000020E610000001000000010200000019000000EA78991A4C1155C0ABCD079A37603E401B4872A04D1155C07AB975A537603E4076959770581155C0C7A9A8F837603E404F14757B791155C0CF8A46E438603E40A6F833C8851155C05E3BB30839603E4070707F358E1155C0B06EE79938603E4017225C58951155C0F36AC40538603E40FCF63CDB9E1155C06D74EECA36603E40F6526AE1A41155C08D3EF80C36603E4006A1AF3EAB1155C0144DE6AF35603E40F244A56EB11155C0C506887A35603E40C4E5E642C61155C0B5459F9635603E403891E714081255C02053A5FD35603E401C2D9EB2451255C0DD47788836603E40577A4353531255C0935D758936603E40B5D5F3AA5A1255C0EFF2EFE536603E408908AA23611255C089E7017C37603E406127820C6B1255C06CA452D338603E402171CBB37A1255C0358A77833B603E400C39CD2C811255C06EFABA3C3C603E4052F89C03891255C02DA063AF3C603E40E13AA8FD901255C0DA414FFB3C603E4087F8A12C9F1255C099919B103D603E40428832A2B71255C0C12538A13F603E404DC1D90DB91255C0170E01963F603E40	0105000020BC080000010000000102000000190000007E4BAFD3CAE816C1DB6649435CDF40410EC0672140E916C1374883CF5CDF4041486F0E0D81EC16C1503AF7B860DF40413331B75372F616C10C18737A6CDF4041F02541EA25FA16C1C3E9AB4C70DF4041D0D7B579AFFC16C13243057271DF40416E14E3ADD5FE16C1DD0BB1D371DF40416DBD094CB30117C12FC3F80F71DF40416C29AFEC830317C1BA044DAE70DF4041E51B82856E0517C14F5A057271DF4041E58DAC614B0717C1CB72699772DF4041CA9C992A900D17C1A7B15FB478DF4041CAF95C475F2117C1230F12318CDF4041ED187F60EA3317C119190CEA9EDF4041C543525C043817C1F2EB44BCA2DF4041EFF6BEDC393A17C17E69C5CAA5DF4041CBA8DC1B2C3C17C14EE8E63AA9DF4041A15497C3263F17C1B26CF4B9AFDF4041708BC91CDB4317C14A123592BBDF4041943AE75BCD4517C185DF6D64BFDF4041FB8BB210294817C1435F8FD4C2DF40414BB726798F4A17C185DD0FE3C5DF40414DC6923ED44E17C1D8B2E916CADF40413B9E0C262F5617C134803B10D8DF4041FBB171A09C5617C1F1C1F956D8DF4041
154	72140000	1	US  301	301	2	72	Duval	2	0	7.429	11957.878	11957.8779797253	0105000020E61000000100000001020000001C000000B0D962C74C8154C05C97BF86CB2F3E406AB18339FE8054C0B16D07B4F9323E409481C10FF78054C03CB6B90746333E40595627BBEA8054C050AB54F8C5333E400EAFD833E38054C0F1A92C9B14343E4051D231B0D38054C0213EAF5CB5343E40380BBF49688054C071CC514212393E406BB55333308054C06823B2CF563B3E4080892D8ADF7F54C0F5E41D9B9F3E3E406B281EE9A57F54C0FA718A52F7403E40E85F00CE887F54C01E5F270827423E404AFAE83B337F54C0983B9E6FA3453E4013681E8DFF7E54C0380BA50EBD473E40CF0C453AED7E54C04C550FED7C483E40BA0D781AEA7E54C0C7733F38A1483E40DEA4FC68E87E54C041CE8567BA483E4013042F4EE77E54C003B12C3AD1483E40C24D385DE67E54C013736F9BE8483E40EC6F14BEE57E54C090ED2832FE483E40F004D284E57E54C0CC618BDD10493E40EBF44973E57E54C034C2A9B720493E4083FCD471E57E54C04B99742134493E401CB49693E57E54C0955145F96F493E40E3CF40B0E57E54C09C976B4680493E40D139DCC2E57E54C0A98469709D493E40BEA092F0E57E54C07D0C9915E5493E4040A59414E67E54C0013902440C4A3E40882BDF18E67E54C08D31F4EE104A3E40	0105000020BC0800000100000001020000001C000000502090A1995F1441D66B14D2BA3E40410406E075E6771441B01E3C4787474041688C010F1E7A144178CC8D755A484041CBD1DD66EE7D144191EF506ABC494041E315589B4280144100B925F9954A404190F08AEC0E8514417C3BB0B7524C404101D2D36245A61441B35ECBC56458404122AC62FF9BB71441981F8EF4AA5E404159C98E188BD01441C49FD736C1674041D1E1FB6F5AE214417C21717C3C6E4041BD94FC0359EB14415C5E6ACA847140418916AA43C905154130D3ADEB297B4041870B8305C0151541D6003F6FF9804041E970C907691B154168E6B3510C8340413BDAF4C4601C1541BFD6F8C470834041C8454819E81C1541C6694383B6834041FB645D9D411D15419E075CC0F5834041BFC664A48E1D154168D2AA8C3684404191B6A6B1C21D1541995F6967728440416A121784D71D15411BF4DD30A68440419D6673D6DF1D1541B5B2342CD28440419DAC2401E41D1541FCEAAB0A08854041245AEB55E51D154137E92A1CAE85404104FF72D6DF1D1541B1458E5ADB854041F4DF72D6DF1D1541E07E5B492C864041FB9172D6DF1D15412951CF1BF386404177723386DC1D1541B8AD07D85F8740418E0D0B21DC1D1541C4A238CC6C874041
155	15170001	2	US   19	19	7	15	Pinellas	7	0	4.143	6667.9741	6667.97413927635	0105000020E610000001000000010200000017000000E839BA3551A854C0D3B00E26B4973B406A025A4D6EA854C054920D5505983B40AA8D930E88A854C0901FE80551983B404FFC6F94A4A854C0C6F5D75CA9983B4062FC4DFBD1A854C04242A3AB43993B40B61F3AE9E4A854C0D8084B6888993B407135552DFEA854C059295F8EEA993B402EA5C1060FA954C063970E16309A3B40D55EFB9A1DA954C0F1AFFDA26E9A3B409D50C06534A954C099355A0DD59A3B4030EE349E44A954C084B9F83C239B3B40D9623EC958A954C0865EF2F6889B3B40E54BFF7373A954C08C45FB98149C3B40EB14B2DF9DA954C0FEAB96DEF79C3B4081A308F4BEA954C00B4B5CA4AB9D3B4072337BF1E2A954C0D9C9FE75709E3B40052116C301AA54C054CD6A331A9F3B409AB451A325AA54C0444C1090E09F3B4083382C8A86AA54C0B4C55FA7F8A13B40FF629F40ACAA54C0AF818564C8A23B406B900009C0AA54C05A8D84D137A33B404D737A7BD1AA54C096A18D179BA33B406D5BBAAFE1AA54C0EB09978DFFA33B40	0105000020BC08000001000000010200000017000000F266F239E44BFF402F3A6AEAE6203241471BCF2B4F28FF4034708BF1B0223241710ECFC4D308FF40C8ABE0A15B243241922ED2A4FBE5FE404B6F903B4D26324131A1FA6E95AEFE4034EE2B48B1293241AA3F62CE8197FE400F4C00A0332B3241D67AE04EBC78FE401EB801D35A2D3241F16A45EC3B64FE4067F7CF07E12E324174BDB59D8152FE40B9D001EB3F3032411EE52849D036FE4046DDE8277E3232411292E7602123FE402F7AEB3B343432414AEBBEA5AD0AFE40964FC2F76D3632417CCFB3275FEAFD403683E0BD7B39324155EE929D01B7FD404CB8A2F1733E32415958D94BF78EFD4063EEA025624232414D87E0246963FD40E16AD2B6AF46324106A2500C1F3EFD402DA77CAD654A32414D8C4A04B812FD4011BC88CDBB4E3241117C9268809DFC40D4960113745A32415DA5BC17E26FFC406F6165C5FE5E32419BCC3D4AF757FC409D02A14C6E6132412DA3A5B7E042FC40A64DFCC799633241340224D7542FFC40FBE0E685CB653241
156	49010000	1	US   98	98	3	49	Franklin	3	8.879	30.26	34420.2246	34420.2245626676	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
162	75060000	2	US   92	92	5	75	Orange	5	0	1.898	3050.6745	3050.67449532884	0105000020E61000000100000001020000001D00000005BA68D9515954C00BD362798F8D3C40211672122C5954C00CB6AD9D908D3C401910B7F6F15854C06C952B2E928D3C400E222A39E75854C06841C6DF918D3C40D3FB0B74CF5854C081F39B76908D3C40209DEB61C45854C0A4DC9CED8F8D3C40E73E733BB05854C09DEBD23E908D3C40548AE8D6985854C05FF4950B938D3C407A0352E18A5854C07700AA36948D3C40753C4305855854C06044807E948D3C40E525DDC97D5854C09A78A2F2958D3C403BE577DD7A5854C05A152767968D3C403E8370FD765854C0858148EB968D3C40220CF990755854C0EB4AD32E978D3C401B6BE29E6F5854C0E2A375B1978D3C401B65C2B6625854C0F5D29BDF988D3C4021A9120C5B5854C0B40140409A8D3C40BCF7A8454E5854C0B48ABBAB998D3C40822B4DE2445854C08A37D417998D3C40F05D71991E5854C05F00341E9A8D3C40E36774C2FE5754C0C4938F759B8D3C40610862C6EB5754C0C56D4E739A8D3C40A1400E39DD5754C056D99EEC9A8D3C40411A506FCA5754C07ABD40B49C8D3C40319E84D6AE5754C06A05E50D9E8D3C40E32FFB44975754C020063F8B9E8D3C40FCB601E4795754C09B4A7ADD9D8D3C40CCBFBD33535754C07FAB06C89B8D3C404A13B8F5525754C06993EFC59B8D3C40	0105000020BC0800000100000001020000001D00000082E95FDE1126204173627EF40668374165882057DA2B20419E5A8BDA0A683741105E4292BF342041A9C464D00F683741AB3AFE7564362041EE476C6E0D683741987D37EB073A204166DB5C180468374168EC46BFB93B2041D196DF6C00683741130F886ACF3E2041FCF5A3E90068374155448F3D64422041CC144FF90E6837410F04665387442041804056941468374197A9CEF66C4520415CFFE6C415683741D1E2566D8846204187CD9D611D68374114F0E001FB46204183C940B91F68374141D38FE29247204185184E58226837414D4BCFAFCA472041CEAE41B8236837413DA79AB4B3482041CFC3F82D26683741D4D88D8AAD4A2041368C49EC2B6837417A147409DA4B2041B09F9116336837411F3457A6CE4D2041825E5D132F683741EA00D4883E4F20410381B6492B68374107388BE11A552041124DB99B2E683741977837ADFA5920415060D517346837412A8D689EE25C20412195A6552D683741D438FCE71C5F204187D55D132F6837415AA0783DFD612041F18C7FCE376837419024C2C2366620415457CD9F3D683741B3DF2463D2692041A86400EB3E683741AB3B78AB516E204114D7E06239683741290CD1BC3D74204154695A832B683741FB354A3B47742041B5D80F742B683741
163	15170000	2	US   19	19	7	15	Pinellas	7	4.247	8.535	6902.0978	6902.09778115273	0105000020E6100000010000000102000000270000007D31C805E3AA54C0576EBAE604A43B40B7835734E3AA54C06C89E3DA08A43B401D509E31E8AA54C0961CC0FF28A43B4021B6E195EFAA54C0E8FEE0185AA43B4078B3E435F7AA54C0804E92C88EA43B40F4FEDABC00AB54C0246BE066D2A43B409DA5B37E18AB54C0F768128281A53B40A18F0D4D34AB54C0C7F203CD4AA63B407530296038AB54C0A619A35F6AA63B402E5E698F3CAB54C08FE53BBB8FA63B403F31E30641AB54C0893659EDB9A63B4089D686D744AB54C00B9C4608E6A63B402C75D2B447AB54C0AF7FF8D30AA73B400C9EE9F849AB54C048254BD62DA73B40297F61B84BAB54C0C48E72844CA73B4051B436D54DAB54C055978B9878A73B400AF8C6D44EAB54C09DB2F86B99A73B40279B2DCE4FAB54C0BE28E4D6BEA73B406DB14A4A50AB54C001F70BD7DBA73B400C53D34252AB54C0E39FD0E66DA83B4043D38D6254AB54C031601C5C07A93B40E39FBDE557AB54C08D8E25CD27AA3B40C8FF28A95CAB54C0FE7D8924A0AB3B406F0A09605DAB54C087765BC2C2AB3B404F8930415FAB54C00AA818E412AC3B4065C484C760AB54C02752030E59AC3B40265C9DD467AB54C083E316E574AE3B40EDAA71806CAB54C002C55CA0DFAF3B401C62222F6EAB54C0A456A8CD56B03B4099FA2D7C70AB54C0CB8EDF16EDB03B4059E01EC973AB54C0A06E6509EBB13B40E96285F674AB54C044E8B4135BB23B40C115B64A76AB54C08C42FD3AC2B23B4014EE25C776AB54C01F6692F9F0B23B409957AF9D77AB54C0EF41361C32B33B40EFC1E9D977AB54C09A8C7CF94EB33B404FE4C9FC77AB54C000C690B267B33B406CAE7A0078AB54C0241511758DB33B403B39500578AB54C05E1B8251A0B33B40	0105000020BC08000001000000010200000027000000F42E03B7B42DFC40D70C0E8EE9653241F95C42F27F2DFC40508F818AFF653241898866B47C27FC40B7CF1E3AB366324171278025961EFC409F4269A0C5673241A6DD5A206A15FC40E2DC88FFEB6832419E3BD391F609FC40283911BB656A32414CE2AE7270EDFB40AACC1BAD376E324134CC1FEF09CCFB402648E2029C723241B6A51F8127C7FB40CE8677494C7332417E84D64B29C2FB408DF6E8B01C743241B696A1B8D7BCFB40C261C3030875324179D5D98A56B8FB404AC31AC2FD7532413A8C7324F9B4FB40978E8DB0CA763241564CB3D556B2FB40E0F8268C8D7732419B567D2053B0FB40EFE36F3F38783241353B1543ECADFB40C66604632D793241395C7830D8ACFB40BAF977CAE3793241DEBF4C45D1ABFB40ED058FAAB37A324176EECBF35AABFB408A7231B5547B3241526653FB9BA9FB405988DDAA7F7E324192B88F90B5A7FB4050487EB5D38132410CBDE015BBA4FB404ADA3B161588324180757C629FA0FB40FC9714853E9032415F972E55E79FFB401CED99C8FE903241264CB8E0F59DFB4090D6B8E7BB923241800F2E91689CFB408C38829F4194324169BA91903F96FB407421FBDBF69F3241A2A6854A3192FB403E893FC2D4A7324180FCEE8AAD90FB406D4B50796AAA3241A20249E78B8EFB408B7C7FF7ACAD32416C6D1BB6AB8BFB40534819E72EB33241B4A87214BF8AFB40E24370E29CB53241DE3027D39789FB40C5BB1399D9B7324101A543BB3689FB406B8A3118DDB8324160D7B8A57C88FB40C063A4BA46BA3241DA1EC6345588FB40793EE5F2E6BA32418A53AD0E4888FB4003D6BC2970BB32413727252F7188FB40D1782BAE41BC3241D59FF7088288FB40E3228256AABC3241
192	93020100	1	US    1	1	4	93	Palm Beach	4	0	0.96	1559.8327	1559.8327175135	0105000020E610000001000000010200000015000000399C86FE870354C0A3D233BF9DB43A40373B1902870354C004B55AC5A3B43A40BA0CBEA7860354C0828D52EDD6B43A401C1CE605850354C017E0BC19DDB53A40CAC495D4830354C02C9756739AB63A4041DCB8C1840354C0277ED661A1B63A402985EB2D840354C0643C2646E6B63A401239C9BB830354C0296D51303BB73A40A52E62D5830354C0E3219E8151B73A40F15C5326840354C01A7054035FB73A40FE4D8289860354C0818E8920A9B73A403B247D91860354C0C1AF09AEB3B73A400DEF71FC850354C000D24F7FC0B73A406516368F840354C059ACC726CCB73A408972229B820354C0A9CF97A6D6B73A40E6B61D79800354C035F4404BDEB73A40DA1C8BA07D0354C082C1F058E5B73A400419C0707A0354C0BE3548AEEAB73A40A16B3E05770354C0795CEBB9EDB73A406646FF78730354C0D24E0C95EEB73A40C03D6EE26A0354C0A530B9A7EDB73A40	0105000020BC080000010000000102000000150000009FC62E8023702D414C29836957582A412C20CD4D4A702D416EBB5F889A582A41F8B0092A54702D4128BEE226D25A2A4145EDECA67F702D4146177D212F662A419DC0159B9F702D41D53FB917646E2A418FEBB61E7A702D416D3994B7B06E2A41AEBF0E768B702D417ECFDF28AD712A418C570C3E96702D41887D6C515B752A41837CE76B90702D41D08E0CE052762A41D393CCB582702D41F59E499FE8762A41434EC2781D702D4133A69E1F1E7A2A4122E0855C1B702D41F5DF2A2F937A2A41DD0D0F8231702D41E540028D217B2A41EEF6556769702D419A7EF242A37B2A41B2416F62B6702D413394D050187C2A41CC6871C00A712D41558006BD6D7C2A4108A3AB957B712D416D445CD4BC7C2A413EE9D922FA712D416FE06DF0F87C2A418516D12B82722D41AE2B86BC1B7D2A41F2C19F7B0F732D419AFD3048267D2A4179B99ACC65742D41F2E8098A1E7D2A41
157	02030000	2	US   98	98	7	02	Citrus	7	1.914	25.107	37338.1046	37338.1046272344	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
164	36010000	1	US   27	27	5	36	Marion	5	14.711	24.959	16467.3016	16467.3015534125	0105000020E6100000010000000102000000680000000205F68E648354C04EEBC3AE120F3D40D9F7AE77C68354C03ADF96BC590F3D40E3ABADCA108454C08A488C29900F3D4056E3BEC8118454C0EE9D493E940F3D40C2D1949B168454C0CCEFB617980F3D40A48F9F0C1A8454C04BCCF8419B0F3D40FF22E7E71C8454C0BA5E300C9F0F3D40C6B0C518218454C0A8E48619A50F3D402AF5280C258454C004CA80B4AB0F3D40024ED7BD288454C0B908C72AB30F3D406FAD14132C8454C0373CAE10BB0F3D40A59682932E8454C093A969B7C10F3D404641CEB4318454C09DCA8932CB0F3D402509FE81348454C0664E5372D40F3D4007BE7530378454C077C816F1DD0F3D4046F7AB153A8454C0BA014419EA0F3D402B4AE3753C8454C0BC52A17BF50F3D40C84D54593E8454C06D6C013FFF0F3D40720EFFEB408454C04D966E790D103D40C7A0FEB5518454C09609FE9E82103D40ADDD6B89648454C055139A6506113D402B384AFE748454C0015DDA277B113D4083CC63DC878454C088DB1EA4FE113D40F5E1EF12A58454C0ADCC00F7CB123D40A7D2C88EC88454C0E372C0C4C4133D40A38627D9FD8454C00CE823573B153D40E928114B0B8554C0EE52A48899153D40016AEED32A8554C06365741176163D40F24FB52F2F8554C091F57F9694163D40EC8B9764458554C0041CC65F30173D4045D3F8E56C8554C0FBEE31A344183D40081AF791878554C0DF98530DFF183D4012F3E6878B8554C0C3D2F63C1B193D4050C835D48E8554C0D5C9556D34193D40BDFA13F7918554C018CF56324E193D404941D2B1958554C03C4817DA6F193D40B975799C9B8554C03A7F3225A8193D409E498205A78554C0DE79656D131A3D4009C7A6A9AA8554C01513A17F321A3D40EBCC7DEBAE8554C00EBF5F69521A3D407E76E534B38554C0F59AEB026E1A3D400E0FAE5BB88554C0EA0D65BD8B1A3D4009DC65FECD8554C0568FF5EA041B3D403449F09FD68554C0098C3B93341B3D40A6A0A847DD8554C0D1BC62F35B1B3D402EB70DFBE18554C05D98F542791B3D4019C04FB0E78554C07B8B5C2BA01B3D4042E948A8F48554C05BD28273FC1B3D4033C54439178654C091D273CFF01C3D40AB70E5AA388654C0E96DFD95DD1D3D4002A5EB925F8654C0CF3259B1EF1E3D40B60E73BE8F8654C0B56D0BC043203D40518B1DCDC48654C09E2986FFBA213D40F390A4C3E58654C01FB7FCC1A3223D400E883BF4228754C0866994C652243D402C086A20478754C0C637E4B151253D404019D4D54A8754C0474117266A253D40CD269EF34D8754C020BBB26F7B253D40E367738F518754C01DA55D238D253D405E3F087F558754C0AA2F7AAF9E253D402CEC3B615A8754C0C13720A5B2253D4004C7F9F65E8754C0A8F7BA03C2253D4074114A20648754C0BBCFBEA8D2253D40483D45BF688754C09B19714DE0253D40F081E6996E8754C0487B16C6EF253D4067186D88848754C0CA39008A29263D405B5333459D8754C01D3F00676B263D4028D64114AB8754C0A6D02B048F263D402A50E0A7BA8754C0BAEAF371B5263D400A0CDB5F058854C0097E99F06F273D402547535B128854C023F1C74590273D40E9625B5D198854C0C2EE5F4AA2273D40194E4128218854C0437B5EDEB6273D4078A45A82278854C01144017AC8273D40ECB788122E8854C070ED6A85DC273D40C8D4823D378854C0EC66A7F6F9273D40C82D6D1D3C8854C0DB5E0D2F0A283D404DF90073418854C0B9519CD61D283D40B86AE2C6468854C02CE0786431283D4092F8E327488854C01E4238E136283D409E2C11924D8854C0F2F07D6D4C283D40DB9E2C54538854C0D4F1C96265283D400262B403578854C0300C81ED74283D40FC73C4E95A8854C043C0F67A87283D40A2F1CDBA5E8854C03ADB60E499283D4096C55BAD618854C0D15D29E2A8283D40CE5847F5658854C023D94274C0283D40D705F8009D8854C0B818C3C8E3293D40779CA130A78854C093679990192A3D40B8584AFFA88854C0339C829B1D2A3D4088EE7F53AA8854C0E5B2004D242A3D407A238331E48854C016AEA8E4552B3D40194CBB6FE78854C07D87A78E682B3D40B7C51838EB8854C04663C7757E2B3D40852BD328EF8854C02DA4DDF9992B3D403BEF714BF28854C0E09CD5BEB32B3D40244E7EF7F58854C00ED69309D52B3D409DE6E671F88854C00F50DF0BF12B3D4065791560FA8854C0DC6ABDCC0B2C3D406DF4BBE0FB8854C0DAF63489292C3D404BED3202FD8854C0BD10FBF0472C3D405088CF6FFD8854C0DF8FFBC55F2C3D402B6F4881FD8854C0C261B776782C3D40BD6F6C1CFD8854C03D0A74A1E22D3D40	0105000020BC0800000100000001020000006800000079F58695ED8313414BBA4B3EA03B3A41148E1452266613410951D19A3B3D3A4118FD09978B4F1341001C3AA5763E3A41FBBEE7FD3E4F134114FBFF768D3E3A41807E3981C74D1341A1CA29ACA33E3A4199CBD2AEBB4C13414D1526D7B53E3A418CF68C9EDD4B1341C62B675FCB3E3A415D7D15ED974A13416D5940B1ED3E3A412E94EE136549134174FE3F0A133F3A41659E3D6C46481341E33392183D3F3A41212BD405444713414CBF0E82693F3A415DEF813782461341A3640EDB8E3F3A41813872F68F4513411683F503C43F3A4123E16B4AB744134178DCCED4F73F3A41477E5C07E843134159FBB5FD2C403A41EA5FF39E08431341ADB556F570403A4175B6179551421341B803EA8BB0403A415C48DF3CC04113416780CB0DE7403A41302F2366FA4013413FDF327536413A4117E37B58F43B13419AF0FA72C3433A418C919F6852361341EC6173FAA1463A414A801F50663113417618E2C32C493A41992FEB2CC12B134120A5B0B2094C3A41DF50E71A042313417F942D3082503A41D2F992E866181341C7BF2C11ED553A41BA476CB9760813413F7B6601155E3A41FC918852710413411CC6371222603A4169529BF002FB124173CD3E6CEF643A41EB39D042B5F91241E02C6C8D99653A4115A6454611F31241C8C349F7FD683A413A1C5F0741E7124193E5B800026F3A418B24A75947DF12418036303011733A413D58B74718DE1241327E4B4DAE733A411E7B4B441CDD1241033275AA3A743A41220D20FF2CDC1241CDAFF238CA743A417A027D1511DB1241EE579DA485753A41B0106A454FD912419481EA12BF763A4118B62D8FEBD51241C0DCDE6C14793A4169E17F04D6D412414252027EC1793A41161BA69E90D31241354A7557737A3A41D8BA260948D2124167C83C430D7B3A419756E776BCD0124152DABB26B37B3A4139117A663ECA1241CA539375577E3A41BFF14D3CA7C71241FE52AF76617F3A418C6FFE6EA8C512411B7343283D803A41F6DAF1F23FC41241A32258A6E0803A419C192EE88AC21241E6AAD193B9813A415858B2C4AABE12411DC87CFCBB833A41C0C8722656B41241B5EF782C0E893A41D5F593AC57AA12418CBC1A17368E3A41E60B7D45B79E12416D5DA9292E943A413A2BF2AB52901241C26AFEE5959B3A416CE567D478801241B05075D3C1A33A41B73356F79F761241093CF96FD3A83A41A5465FB35864124129DF326136B23A41CB398CDA8A5